
      SUBROUTINE DIRSET
      INCLUDE 'LINDOP.INC'
      LOGICAL ERROR
C
C---- current optimization point index
      IH = NHIS
C
C---- set objective function type flag
 10   WRITE(*,1100)
 1100 FORMAT(/'  0  user-defined'
     &       /'  1  Sum[ w CD  ]'
     &       /'  2  Sum[ w D/L ]'
     &       /'  3  Sum[-w CL  ]'
     &       /'  4  Sum[ w D/ML]')
C
      WRITE(*,*)
      WRITE(*,1150) IFTYPE
 1150 FORMAT(1X,'Select objective function:',I4)
      CALL READI(1,IFTYPE,ERROR)
      IF(ERROR) GO TO 10
C
C---- set current unconstrained objective function and gradient
      CALL FUCALC(IFTYPE,FUN(IH))
C
C---- set pointers for current parameters
      IF(.NOT.LXPAR) CALL KHES
C
C---- put everything into pointered arrays
      CALL PARSET
C
C---- clear LXQLQ to force reading Hessian from disk file hessian.xxx
      IF(LTRNSF) THEN
       LXQLQ = .FALSE.
       CALL MKHESS
      ENDIF
C
C---- set constraint-projection matrix
      CALL PRJSET
C
C---- calculate Lagrange multipliers and constrained objective function
      CALL FCCALC(NHIS)
C
      IF(LTRNSF) THEN
        WRITE(*,*) 'Direction will be defined in eigenvector space...'
C
C------ update Hessian if it hasn't been done already
        IF(.NOT.LHESUP) CALL BFGS
      ELSE
        WRITE(*,*) 'Direction will be defined in scaled space...'
      ENDIF
C
C---- set constrained search direction
      CALL VCALC
C
      LOPDIR = .TRUE.
C
      CALL SHOGRD
C
C---- this will be the first point in a line minimization
      NSTEP(IH) = 1
      RETURN
      END ! DIRSET



      SUBROUTINE VCALC
      INCLUDE 'LINDOP.INC'
      DIMENSION GPART(NHESX,0:2), VPART(NHESX,2)
      LOGICAL ERROR
C
C---- history index of current point IH, and previous waypoint IH1
      IH  = NHIS
      IH1 = 1
      IF(NHIS.GT.1) IH1 = MAX(NHIS-NSTEP(NHIS-1),1)
C
C---- set index IH0 where conjugate directions were initialized
C-    (first waypoint in conjugate sequence)
      DO 1 IH0=IH-1, 1, -1
        IF(IDTYPE(IH0).EQ.0 .AND. NSTEP(IH0).EQ.1) GO TO 2
 1    CONTINUE
      IH0 = 1
 2    CONTINUE
C
C---- transform gradients and directions to scaled/eigenvector space
      CALL GP2SE(FC_PAR(1,IH0),GPART(1,0))
      CALL GP2SE(FC_PAR(1,IH1),GPART(1,1))
      CALL GP2SE(FC_PAR(1,IH ),GPART(1,2))
      CALL XP2SE(  VPAR(1,IH1),VPART(1,1))
      CALL XP2SE(  VPAR(1,IH ),VPART(1,2))
C
C---- set gradient dot product ratios
      GMGM = DOT(NPAR,GPART(1,1),GPART(1,1))
      GMGI = DOT(NPAR,GPART(1,1),GPART(1,2))
      GIGI = DOT(NPAR,GPART(1,2),GPART(1,2))
C
      VGM  = DOT(NPAR,VPART(1,2),GPART(1,1))
      VGI  = DOT(NPAR,VPART(1,2),GPART(1,2))
C
      IF(GMGM .EQ. 0.0) THEN
        WRITE(*,*) '*** Previous-point gradient has zero magnitude'
        GRATF = 0.0
        GRATP = 0.0
      ELSE
C------ ratio for Fletcher-Reeves method
        GRATF = GIGI / GMGM
C
C------ ratio for Polak-Ribiere method
        GRATP = (GIGI-GMGI) / GMGM
      ENDIF
C
      VGRAT = 1.0
      IF(VGM .NE. 0.0) VGRAT = VGI/VGM
C
      WRITE(*,2010) IH1, IH, FUN(IH1), FUN(IH)
      WRITE(*,2020) -VGM, -VGI, VGRAT
      WRITE(*,2030) GMGM, GIGI, GRATF
      WRITE(*,2035)             GRATP
C
 2010 FORMAT(/1X,'        previous     current'
     &       /1X,'hist.:',   I7, 3X, 2X, I7
     &       /1X,' F   :',F10.5,      F12.5 )
 2020 FORMAT( 1X,' v.d :',F10.5,      F12.5,'   => v.d/(v.d)_ =',F10.5)
 2030 FORMAT( 1X,' d.d :',F10.5,      F12.5,'   => d.d/(d.d)_ =',F10.5)
 2035 FORMAT( 1X,'      ', 10X ,       12X ,' (d-d_).d/(d.d)_ =',F10.5)
C
C
      IDSAVE = IDTYPE(IH)
C
      IF(LTRNSF) THEN
C
        IDTYPE(IH) = 0
C
      ELSE

       IF(IH.GT.1) THEN
C
         G0GI = DOT(NPAR,GPART(1,0),GPART(1,2))
C
         WRITE(*,1205) GMGI/GIGI, G0GI/GIGI
 1205    FORMAT(
     &    /1X,'Gradient-conjugacy parameter:       d.d_/d.d =',F10.5,
     &    /1X,'                                    d.do/d.d =',F10.5 )
C
         WRITE(*,*)
         WRITE(*,*) ' 0  Steepest-Descent'
         WRITE(*,*) ' 1  Conjugate-Gradient (Fletcher-Reeves)'
         WRITE(*,*) ' 2  Conjugate-Gradient (Polak-Ribiere)'
C
 8       WRITE(*,1200) IDTYPE(IH)
 1200    FORMAT(/1X,'Enter search-direction type (-1 = abort)', I3)
         CALL READI(1,IDTYPE(IH),ERROR)
         IF(ERROR) GO TO 8
C
       ELSE
C
         WRITE(*,*)
         WRITE(*,*) 'Previous-direction info not available.'
         WRITE(*,*) 'Initializing direction v to -(current gradient)...'
C
C------- no previous point: search directions same as in Steepest-Descent
         IDTYPE(IH) = 0
C
       ENDIF
C
      ENDIF
C
C
      IF(IDTYPE(IH).LT.0 .OR. IDTYPE(IH).GT.2) THEN
C
        IDTYPE(IH) = IDSAVE
        WRITE(*,*) 'Current search direction unchanged.'
        GO TO 90
C
      ELSE IF(IDTYPE(IH).EQ.0) THEN
C
C------ Steepest-Descent, Quasi-Newton
        GRAT = 0.
C
      ELSE IF(IDTYPE(IH).EQ.1) THEN
C
C------ Fletcher-Reeves
        GRAT = GRATF
C
      ELSE IF(IDTYPE(IH).EQ.2) THEN
C
C------ Polak-Ribiere
        GRAT = GRATP
C
      ENDIF
C
C---- set new search direction in either space
      DO 20 K=1, NPAR
        VPART(K,2) = -GPART(K,2) + GRAT*VPART(K,1)
 20   CONTINUE
C
C
C---- transform gradient and directions back to physical space
 90   CALL GSE2P(GPART(1,2),FC_PAR(1,IH))
      CALL XSE2P(VPART(1,2),  VPAR(1,IH))
C
      NPARH(IH) = NPAR
C
      RETURN
      END ! VCALC



      SUBROUTINE GP2SE(VEC,VSE)
C------------------------------------------------------------
C     Transforms physical-space gradient vector VEC 
C     into scaled/eigenvector space vector VSE.
C------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VEC(NHESX),VSE(NHESX)
C
      IF(LTRNSF) THEN
C
C------ set gradient in eigenvector space
        DO 2 J=1, NPAR
          GSUM = 0.
          DO 21 K=1, NPAR
            GSUM = GSUM + EGVEC(K,J) * VEC(K)/GSCPAR(K)
 21       CONTINUE
          VSE(J) = GSUM/SEGVAL(J)
 2      CONTINUE
C
      ELSE
C
C------ set gradients in scaled space
        DO 4 K=1, NPAR
          VSE(K) = VEC(K)/GSCPAR(K)
 4      CONTINUE
C
      ENDIF
C
      RETURN
      END ! GP2SE


      SUBROUTINE XP2SE(VEC,VSE)
C------------------------------------------------------------
C     Transforms physical-space movement vector VEC 
C     into scaled/eigenvector space vector VSE.
C------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VEC(NHESX),VSE(NHESX)
C
      IF(LTRNSF) THEN
C
C------ set movement in eigenvector space
        DO 2 J=1, NPAR
          GSUM = 0.
          DO 21 K=1, NPAR
            GSUM = GSUM + EGVEC(K,J) * VEC(K)*GSCPAR(K)
 21       CONTINUE
          VSE(J) = GSUM*SEGVAL(J)
 2      CONTINUE
C
      ELSE
C
C------ set movement in scaled space
        DO 4 K=1, NPAR
          VSE(K) = VEC(K)*GSCPAR(K)
 4      CONTINUE
C
      ENDIF
C
      RETURN
      END ! XP2SE



      SUBROUTINE GSE2P(VSE,VEC)
C------------------------------------------------------------
C     Transforms scaled/eigenvector space gradient VSE
C     to physical-space gradient vector VEC.
C------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VSE(NHESX), VEC(NHESX)
C
      IF(LTRNSF) THEN
C
C------ set gradient in eigenvector space
        DO 2 K=1, NPAR
          GSUM = 0.
          DO 21 J=1, NPAR
            GSUM = GSUM + EGVEC(K,J)*SEGVAL(J) * VSE(J)
 21       CONTINUE
          VEC(K) = GSUM*GSCPAR(K)
 2      CONTINUE
C
      ELSE
C
C------ set gradients in scaled space
        DO 4 K=1, NPAR
          VEC(K) = VSE(K)*GSCPAR(K)
 4      CONTINUE
C
      ENDIF
C
      RETURN
      END ! GSE2P



      SUBROUTINE XSE2P(VSE,VEC)
C------------------------------------------------------------
C     Transforms scaled/eigenvector-space movement VSE
C     to physical-space gradient vector VEC.
C------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION VSE(NHESX), VEC(NHESX)
C
      IF(LTRNSF) THEN
C
C------ set movement in eigenvector space
        DO 2 K=1, NPAR
          GSUM = 0.
          DO 21 J=1, NPAR
            GSUM = GSUM + EGVEC(K,J)/SEGVAL(J) * VSE(J)
 21       CONTINUE
          VEC(K) = GSUM/GSCPAR(K)
 2      CONTINUE
C
      ELSE
C
C------ set movement in scaled space
        DO 4 K=1, NPAR
          VEC(K) = VSE(K)/GSCPAR(K)
 4      CONTINUE
C
      ENDIF
C
      RETURN
      END ! XSE2P


      SUBROUTINE PRJSET
C-------------------------------------------------------
C     Calculates scale/eigenvector-space constraint
C     Jacobian BMAT, factored projection matrix PRJ,
C-------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL LSING
C
C---- set current constraint-Jacobian CONJAC
      IF(.NOT.LXCON) CALL CONGEN
C
C---- set scaled/eigenvector constraint Jacobian BMAT
      DO 10 L=1, NCON
        CALL GP2SE(CONJAC(1,L),BMAT(1,L))
 10   CONTINUE
C
C---- set weighted-square constraint matrix  B B^T
      DO 30 LCOL=1, NCON
        DO 304 LROW=1, NCON
          SUM = 0.0
          DO 3042 K=1, NHES
            SUM = SUM + BMAT(K,LROW)*BMAT(K,LCOL)
 3042     CONTINUE
          PRJ(LROW,LCOL) = SUM
 304    CONTINUE
 30   CONTINUE
C
C---- LU-factor square-constraint matrix
      CALL LUDCMP(NCONX,NCON,PRJ,PRJPIV,LSING)
C
      IF(LSING) THEN
        WRITE(*,*) '                                               T '
        WRITE(*,*) 'Singular squared constraint-Jacobian matrix [BB ]'
        WRITE(*,*) 'Check for redundant constraints.'
      ENDIF
C
      RETURN
      END ! PRJSET


      SUBROUTINE VCONS
      INCLUDE 'LINDOP.INC'
C------------------------------------------------
C     Projects search direction VPAR
C     onto constraint surfaces.  
C
C     Assumes that VPAR, BMAT, and factored [BB^T] 
C     matrix (PRJ) have already been calculated.
C------------------------------------------------
      DIMENSION VPART(NHESX), DVPART(NHESX),
     &              DVPAR(NHESX), VOLD(NHESX)
C
      IH = NHIS
C
      CALL XP2SE(VPAR(1,IH),VPART)
C
C---- set RHS for perturbed Lagrange multiplier system
      DO 10 L=1, NCON
        SUM = 0.0
        DO 104 K=1, NHES
          SUM = SUM + VPART(K)*BMAT(K,L)
 104    CONTINUE
        BLGM(L) = SUM
 10   CONTINUE
C
C---- calculate Lagrange multipliers
      CALL BAKSUB(NCONX,NCON,PRJ,PRJPIV,BLGM(1))
C
C---- set zero change for inactive Lagrange multiplier
      BLGM(0) = 0.0
C
C---- project direction vector VPAR onto constraint subspace
      DO 20 K=1, NHES
        SUM = 0.
        DO 204 L=1, NCON
          SUM = SUM + BMAT(K,L)*BLGM(L)
 204    CONTINUE
        DVPART(K) = -SUM
 20   CONTINUE
C
C---- transform back to physical space
      CALL XSE2P(DVPART,DVPAR)
C
      DO 30 K=1, NPAR
        VOLD(K) = VPAR(K,IH)
        VPAR(K,IH) = VPAR(K,IH) + DVPAR(K)
 30   CONTINUE
C
      VVO = DOT(NPAR,VOLD,VOLD)
      VOA = SQRT(VVO)
      IF(VOA .EQ. 0.0) VOA = 1.0
C
      VV = DOT(NPAR,VPAR(1,IH),VPAR(1,IH))
      VA = SQRT(VV)
      IF(VA .EQ. 0.0) VA = 1.0
C
      DOTVVO = DOT(NPAR,VPAR(1,IH),VOLD) / (VA*VOA)
C
C---- display projection changes
      WRITE(*,1800)
C
      DO 51 IP=1, NPOINT
        KP = KHESAL(IP)
        IF(LALFA(IP)) 
     &     WRITE(*,1900) 'Alfa', IP, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 51   CONTINUE
C
      DO 52 IP=1, NPOINT
        KP = KHESMA(IP)
        IF(LMACH(IP))
     &     WRITE(*,1900) 'Mach', IP, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 52   CONTINUE
C
      DO 53 IP=1, NPOINT
        KP = KHESLR(IP)
        IF(LREYN(IP))
     &     WRITE(*,1900) 'lnRe', IP, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 53   CONTINUE
C
C
      IF(LNKMOD) THEN
       IP1 = 1
       IP2 = 1
      ELSE
       IP1 = 1
       IP2 = NPOINT
      ENDIF
      DO 60 IP=IP1, IP2
        IF(.NOT.LNKMOD) WRITE(*,1910) IP
        DO 604 K=1, NMOD(IP)
          KP = KHESMOD(K,IP)
          IF(LMOD(K,IP))
     &       WRITE(*,1900) 'Mod ', K, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 604    CONTINUE
 60   CONTINUE
C
C
      IF(LNKPOS) THEN
       IP1 = 1
       IP2 = 1
      ELSE
       IP1 = 1
       IP2 = NPOINT
      ENDIF
      DO 70 IP=IP1, IP2
        IF(.NOT.LNKPOS) WRITE(*,1910) IP
        DO 704 K=1, NPOS(IP)
          KP = KHESPOS(K,IP)
          IF(LPOS(K,IP))
     &       WRITE(*,1900) 'Pos ', K, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 704    CONTINUE
 70   CONTINUE
C
C
      DO 80 K=1, NUPAR
        KP = KHESUP(K)
        IF(LUPAR(K))
     &     WRITE(*,1900) 'Usr ', K, VPAR(KP,IH)/VA, DVPAR(KP)/VA
 80   CONTINUE
C
      WRITE(*,1950) DOTVVO
C
      RETURN
C...........................................................
 1800 FORMAT(/1X,' Constraint corrections to search-direction ...'
     &       /1X,4X,3X, 2X ,'     current v/|v|   delta v/|v|')
CCC                                -0.120345      -0.123450
 1900 FORMAT(1X,A4,I3,' :', 2F15.6)
 1910 FORMAT(1X,'Point',I3,' ...')
 1950 FORMAT(/1X,' v.(v+dv) / |v||v+dv|  =',F10.6)
      END ! VCONS


      FUNCTION DOT(N,A,B)
      DIMENSION A(N), B(N)
C
      DOT = 0.
      DO 10 I=1, N
        DOT = DOT + A(I)*B(I)
 10   CONTINUE
C
      RETURN
      END


      SUBROUTINE SHOGRD
      INCLUDE 'LINDOP.INC'
      LOGICAL LALCHK, LMACHK, LRECHK
C
      IH  = NHIS
      IH1 = 1
      IF(NHIS.GT.1) IH1 = MAX(NHIS-NSTEP(NHIS-1),1)
C
 1010 FORMAT(1X, A )
 3000 FORMAT(1X, I3, 2X, I3, 4F11.4)
 3010 FORMAT(1X, I3, 2X, 3X, 4F11.4)
 3020 FORMAT(1X, 3X, 2X, I3, 4F11.4)
C
      IF(NMODMX.GT.0) THEN
C
        WRITE(*,*)
        WRITE(*,1010)
     &     '            previous   current'
        IF(LNKMOD) THEN
          WRITE(*,1010)
     &     '       k    dF/dModk   dF/dModk     -vk         ak'
        ELSE
          WRITE(*,1010)
     &     'point  k    dF/dModk   dF/dModk     -vk         ak'
        ENDIF
CCC           1   12     4.1234     4.1234    14.1234     4.1234
C
        IP1 = 1
        IP2 = NPOINT
        IF(LNKMOD) THEN
         IP1 = IPGSEN
         IP2 = IPGSEN
        ENDIF
        DO 10 IP=IP1, IP2
          DO 104 K=1, NMOD(IP)
            KP = KHESMOD(K,IP)
            IF(LMOD(K,IP)) THEN
             IF(LNKMOD) THEN
              WRITE(*,3020) 
     &      K,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
             ELSE
              WRITE(*,3000) 
     &   IP,K,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
             ENDIF
            ENDIF
 104      CONTINUE
 10     CONTINUE
C
      ENDIF
C
C
      IF(NPOSMX.GT.0) THEN
C
        WRITE(*,*)
        WRITE(*,1010)
     &     '            previous   current'
        IF(LNKPOS) THEN
          WRITE(*,1010)
     &     '       k    dF/dPosk   dF/dPosk     -vk         ak'
        ELSE
          WRITE(*,1010)
     &     'point  k    dF/dPosk   dF/dPosk     -vk         ak'
        ENDIF
CCC           1   12     4.1234     4.1234    14.1234     4.1234
C
        IP1 = 1
        IP2 = NPOINT
        IF(LNKPOS) THEN
         IP1 = IPGSEN
         IP2 = IPGSEN
        ENDIF
        DO 20 IP=IP1, IP2
          DO 204 K=1, NPOS(IP)
            KP = KHESPOS(K,IP)
            IF(LPOS(K,IP)) THEN
             IF(LNKPOS) THEN
              WRITE(*,3020) 
     &      K,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
             ELSE
              WRITE(*,3000) 
     &   IP,K,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
             ENDIF
            ENDIF
 204      CONTINUE
 20     CONTINUE
C
      ENDIF
C
      LALCHK = .FALSE.
      LMACHK = .FALSE.
      LRECHK = .FALSE.
      DO 25 IP=1, NPOINT
        LALCHK = LALCHK .OR. LALFA(IP) 
        LMACHK = LMACHK .OR. LMACH(IP) 
        LRECHK = LRECHK .OR. LREYN(IP) 
 25   CONTINUE
C
      IF(LALCHK) THEN
        WRITE(*,2060)
 2060   FORMAT(/1X,
     &     'point       dF/dAlfa   dF/dAlfa     -vk         ak')
C             1          4.1234     4.1234    14.1234     4.1234
        DO 30 IP=1, NPOINT
          KP = KHESAL(IP)
          IF(LALFA(IP)) WRITE(*,3010)
     &      IP,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
 30     CONTINUE
      ENDIF
C
      IF(LMACHK) THEN
        WRITE(*,2070)
 2070   FORMAT(/1X,
     &     'point       dF/dMach   dF/dMach     -vk         ak')
C             1          4.1234     4.1234    14.1234     4.1234
        DO 40 IP=1, NPOINT
          KP = KHESMA(IP)
          IF(LMACH(IP)) WRITE(*,3010)
     &      IP,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
 40     CONTINUE
      ENDIF
C
      IF(LRECHK) THEN
        WRITE(*,2080)
 2080   FORMAT(/1X,
     &     'point       dF/dlnRe   dF/dlnRe     -vk         ak')
C             1          4.1234     4.1234    14.1234     4.1234
        DO 50 IP=1, NPOINT
          KP = KHESLR(IP)
          IF(LREYN(IP)) WRITE(*,3010)
     &      IP,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
 50     CONTINUE
      ENDIF
C
      IF(NUPAR.GT.0) THEN
        WRITE(*,2090)
 2090   FORMAT(/1X,
     &     '       k   dF/dXuserk dF/dXuserk    -vk         ak')
C                 12     4.1234     4.1234    14.1234     4.1234
        DO 70 K=1, NUPAR
          KP = KHESUP(K)
          IF(LUPAR(K)) WRITE(*,3020)
     &      K,FC_PAR(KP,IH1),FC_PAR(KP,IH),-VPAR(KP,IH),GSCPAR(KP)
 70     CONTINUE
      ENDIF
C
      RETURN
      END ! SHOGRD



      SUBROUTINE LINMIN
      INCLUDE 'LINDOP.INC'
      LOGICAL ERROR
      DIMENSION SOP(NHISX)
C
      IF(.NOT.LOPDIR) THEN
       WRITE(*,*) 'Must set direction vector first.'
       RETURN
      ENDIF
C
      IF(LTRNSF) THEN
        WRITE(*,*) 'Descent performed in eigenvector space...'
      ELSE
        WRITE(*,*) 'Descent performed in scaled space...'
      ENDIF
C
      IH = NHIS
      IH1 = MAX(NHIS-NSTEP(IH)+1,1)
C
C---- set distance array for whole history
      SOP(NHIS) = 0.0
      DO 5 KH=NHIS-1, 1, -1
        SOP(KH) = SOP(KH+1) - OPSTEP(KH)
 5    CONTINUE
C
C---- set pointers for current parameters
      IF(.NOT.LXPAR) CALL KHES
C
      IF(NPAR .NE. NPARH(IH)) THEN
       WRITE(*,*)
     &   '*** Number of parameters different from history direction.'
       RETURN
      ENDIF
C
C---- clear all free and forced changes
      CALL CLRMOD(.FALSE.)
      CALL CLRAMR(.FALSE. , 0)
C
      WRITE(*,1000) IFTYPE
 1000 FORMAT(/1X,'Objective function used =', I3)
C
C
C---- set current objective function and gradient
      CALL FUCALC(IFTYPE,FUN(IH))
C
C---- put everything into pointered arrays
      CALL PARSET
C
C---- get/initialize approximate factored Hessian 
      IF(LTRNSF) CALL MKHESS
C
      LFCSET = .FALSE.
C
C---- set constraint-projection matrix
      CALL PRJSET
C
C---- set constrained objective function gradient
      CALL FCCALC(NHIS)
C
C---- project search direction VPAR onto current constraint surfaces
      CALL VCONS
C
C
C---- set forced parameter and function changes from constraint violations
      CALL DELCON
C
C---- add objective-function change to move onto constraint subspace
      FUN(NHIS) = FUN(NHIS) + DFCON(NHIS)
C
C
C---- set search-direction vector modulus
      VV = DOT(NPAR,VPAR(1,IH),VPAR(1,IH))
      VABS(IH) = SQRT(VV)
      WRITE(*,1040) VABS(NHIS)
 1040 FORMAT(/1X,' |v| =', F12.5)
C
C---- set derivative of objective function along search direction v
      CALL VGRAD
C
C---- set accumulated step distance for current line-descent
      SOPTOT = 0.0
      DO 10 KH=IH-1, IH1, -1
        SOPTOT = SOPTOT + OPSTEP(KH)
 10   CONTINUE
C
C---- set reasonable default step size to decrease obj. function 5%
      OPSDEF = -0.05 * ABS(FUN(IH)) / FC_SOP(IH)
C
C---- round off default step size, saving sign
      SGN = SIGN(1.0,OPSDEF)
      CALL SGSCAL(1,OPSDEF,0.0,OPSFAC,ANN,NANNT)
      OPSDEF = 1.0/ABS(OPSFAC)
C
C---- limit default step size to total step distance in current line
      IF(SOPTOT .NE. 0.0) OPSDEF = MIN(OPSDEF,SOPTOT)
      OPSDEF = SGN*OPSDEF
C
C---- first assume heuristic step size if it hasn't been set
      IF(OPSTEP(IH).EQ.0.0) OPSTEP(IH) = OPSDEF
      AA = 0.0
      BB = 0.0
      CC = 0.0
C
      IF(NSTEP(IH).GT.1) THEN
C------ set step size to get to minimum of fit parabola (if concave up)
        CALL FCFIT(AA,BB,CC)
        IF(AA .GT. 0.0) OPSTEP(IH) = -BB/(2.0*AA)
      ENDIF
C
cc      IF(NSTEP(IH).GT.2) THEN
ccC------ set step size to get to minimum of fit parabola (if concave up)
cc        CALL FCFIT3(AA,BB,CC)
cc        IF(AA .GT. 0.0) OPSTEP(IH) = -BB/(2.0*AA)
cc      ENDIF
C
      WRITE(*,1050) (SOP(KH)-SOP(IH1), FUN(KH), DFCON(KH),FC_SOP(KH), 
     &               KH=IH1, NHIS)
 1050 FORMAT(/1X,'History of current line-descent ...'
     &      //1X,'     step         F       forced dF   dF/dstep',
     &    50(/1X,    F10.5,      F12.5,      F12.5,      F12.5  ) )
C                    0.00020     0.01234     0.01234     0.01234 
C
      WRITE(*,1070) CNSTEP
 1070 FORMAT(1X,'Current forced dF  side step =', F11.6)
C
      XSIZ = 0.7
      YSIZ = 0.7*PLAR
      XLIM(1) = 0.0
      XLIM(2) = XSIZ + 0.10
      YLIM(1) = 0.0
      YLIM(2) = YSIZ + 0.10
C
      CALL PLTINI
      CALL LINMPL(0.075,0.075,XSIZ,YSIZ,1.1*CH,AA,BB,CC)
      CALL PLFLUSH
C
      WRITE(*,*)
 30   WRITE(*,3050) OPSTEP(IH)
 3050 FORMAT(1X,'Enter descent step size:', F11.6)
      CALL READR(1,OPSTEP(IH),ERROR)
      IF(ERROR) GO TO 30
C
C
C---- set parameter changes
      VA = VABS(IH)
      IF(VA .EQ. 0.0) VA = 1.0
C
      OPVA = OPSTEP(IH)/VA
C
      DO 70 IP=1, NPOINT
        DO 701 K=1, NMOD(IP)
          KP = KHESMOD(K,IP)
          IF(LMOD(K,IP)) DMOD(K,IP) = VPAR(KP,IH)*OPVA + DMODC(K,IP)
 701    CONTINUE
C
        DO 702 K=1, NPOS(IP)
          KP = KHESPOS(K,IP)
          IF(LPOS(K,IP)) DPOS(K,IP) = VPAR(KP,IH)*OPVA + DPOSC(K,IP)
 702    CONTINUE
C
        IF(LALFA(IP)) DALFA(IP) = VPAR(KHESAL(IP),IH)*OPVA + DALFAC(IP)
        IF(LMACH(IP)) DMACH(IP) = VPAR(KHESMA(IP),IH)*OPVA + DMACHC(IP)
        IF(LREYN(IP)) DLNRE(IP) = VPAR(KHESLR(IP),IH)*OPVA + DLNREC(IP)
 70   CONTINUE
C
      DO 76 K=1, NUPAR
        IF(LUPAR(K)) DUPAR(K) = VPAR(KHESUP(K),IH)*OPVA + DUPARC(K)
 76   CONTINUE
C
C---- unsaved optimization step and parameter changes have been generated
      LOPSET = .TRUE.
      LDSET = .TRUE.
C
      RETURN
      END ! LINMIN


      SUBROUTINE FCFIT(AA,BB,CC)
      INCLUDE 'LINDOP.INC'
C--------------------------------------------
C     Fits parabola to obj. function over 
C     current line-minimization interval.
C--------------------------------------------
C
      IH = NHIS
      IHM = NHIS-1
C
C---- fallback case: level line
      CC = FUN(IH)
      BB = 0.0
      AA = 0.0
C
      IF(IHM.LT.1) RETURN
C
      DSOP = OPSTEP(IHM)
      IF(DSOP.EQ.0.0) RETURN
C
C---- average slope over interval
      FSMID = (FUN(IH)-DFCON(IH) - FUN(IHM))/DSOP
C
C---- 2nd derivative over interval
      FSS = (FC_SOP(IH) - FSMID)/(0.5*DSOP)
C
      CC = FUN(IH)
      BB = FSMID + FSS*0.5*DSOP
      AA = 0.5*FSS
C
      RETURN
      END ! FCFIT


      SUBROUTINE FCFIT3(AA,BB,CC)
      INCLUDE 'LINDOP.INC'
C-----------------------------------------------
C     Fits 3-point parabola to obj. function 
C     over current line-minimization interval.
C-----------------------------------------------
C
      IH = NHIS
      IHM = NHIS-1
      IHL = NHIS-2
C
C---- fallback case: level line
      CC = FUN(IH)
      BB = 0.0
      AA = 0.0
C
      IF(IHL.LT.1) RETURN
C
      DSM = OPSTEP(IHM)
      DSL = OPSTEP(IHL)
      IF(DSM.EQ.0.0 .OR. DSL.EQ.0.0) RETURN
C
C---- average slopes over intervals
      FSM = (FUN(IH )-DFCON(IH ) - FUN(IHM))/DSM
      FSL = (FUN(IHM)-DFCON(IHM) - FUN(IHL))/DSL
C
C---- 2nd derivative
      FSS = (FSM - FSL) * 2.0/(DSM+DSL)
C
      CC = FUN(IH)
      BB = FSM + FSS*0.5*DSM
      AA = 0.5*FSS
C
      RETURN
      END ! FCFIT3


      SUBROUTINE FUCALC(IFUN,FUNC)
C--------------------------------------------
C     Calculates objective function and its 
C     derivatives wrt all design variables.
C
C     Currently implemented:
C
C     IFUN = 0:  user-defined
C            1:  F = Sum[ w CD  ]
C            2:  F = Sum[ w D/L ]
C            3:  F = Sum[-w CL  ]
C            4:  F = Sum[ w D/ML]
C--------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION FP_MOD(NMODX),
     &          FP_POS(NPOSX),
     &          FP_UPAR(NUPX)
C
      DIMENSION FU_CL (NPX), 
     &          FU_CDF(NPX), 
     &          FU_CDP(NPX), 
     &          FU_CM (NPX)
      DIMENSION FU_ARB(NBX,NPX),
     &          FU_EI1(NBX,NPX),
     &          FU_ASG(NBX,NPX),
     &          FU_THB(0:NTHX,NBX,NPX)
C
      FUNC = 0.0
      DO IP=1, NPOINT
        DO K=1, NMOD(IP)
          FU_MOD(K,IP) = 0.0
        ENDDO
        DO K=1, NPOS(IP)
          FU_POS(K,IP) = 0.0
        ENDDO
C
        FU_AL(IP) = 0.0
        FU_MA(IP) = 0.0
        FU_RE(IP) = 0.0
      ENDDO
C
      DO K=1, NUPAR
        FU_UP(K) = 0.0
      ENDDO
C
C
      WPSUM = 0.0
      DO 7 IP=1, NPOINT
        WPSUM = WPSUM + ABS(WP(IP))
 7    CONTINUE
      IF(WPSUM.EQ.0.0) WPSUM = 1.0
C
      IPG = IPGSEN
C
      IF(IFUN.EQ.0) THEN
C----- user-defined objective function
C
C----- evaluate and finite-difference user objective function for this point
       CALL UFDIFF(NTHX,NBX, NBL, NUPAR, NPOINT, 
     &             WP, FUNC, 
     &             UPAR , FU_UP , EPUPAR,
     &             ALFA , FU_AL ,
     &             MACH , FU_MA ,
     &             REYN , FU_RE ,
     &             CL   , FU_CL ,
     &             CDF  , FU_CDF,
     &             CDP  , FU_CDP,
     &             CM   , FU_CM,
     &             AREAB, FU_ARB,
     &             EI11B, FU_EI1,
     &             ASIGB, FU_ASG,
     &             THIKB, FU_THB )
C     
C---- set total derivatives wrt LINDOP design parameters
      DO IP = 1, NPOINT
        FU_AL(IP) = FU_AL(IP)
     &            + FU_CL (IP)* CL_ALFA(IP)
     &            + FU_CDF(IP)*CDF_ALFA(IP)
     &            + FU_CDP(IP)*CDP_ALFA(IP)
     &            + FU_CM (IP)* CM_ALFA(IP)
        FU_MA(IP) = FU_MA(IP)
     &            + FU_CL (IP)* CL_MACH(IP)
     &            + FU_CDF(IP)*CDF_MACH(IP)
     &            + FU_CDP(IP)*CDP_MACH(IP)
     &            + FU_CM (IP)* CM_MACH(IP)
        FU_RE(IP) = FU_RE(IP)
     &            + FU_CL (IP)* CL_REYN(IP)
     &            + FU_CDF(IP)*CDF_REYN(IP)
     &            + FU_CDP(IP)*CDP_REYN(IP)
     &            + FU_CM (IP)* CM_REYN(IP)
C     
        DO K=1, NMOD(IP)
          FU_MOD(K,IP) = FU_CL (IP)* CL_MOD(K,IP)
     &                 + FU_CDF(IP)*CDF_MOD(K,IP)
     &                 + FU_CDP(IP)*CDP_MOD(K,IP)
     &                 + FU_CM (IP)* CM_MOD(K,IP)
          DO N=1, NBL(IP)
            FU_MOD(K,IP) = FU_MOD(K,IP) 
     &                   + FU_ARB(N,IP)*ARB_MOD(K,N,IP)
     &                   + FU_EI1(N,IP)*EI1_MOD(K,N,IP)
     &                   + FU_ASG(N,IP)*ASG_MOD(K,N,IP)
            DO KT = 0, NTHX
              FU_MOD(K,IP) = FU_MOD(K,IP) 
     &                     + FU_THB(KT,N,IP)*THB_MOD(K,KT,N,IP)
            ENDDO
          ENDDO
        ENDDO
C     
        DO K=1, NPOS(IP)
          FU_POS(K,IP) = FU_CL (IP)* CL_POS(K,IP)
     &                 + FU_CDF(IP)*CDF_POS(K,IP)
     &                 + FU_CDP(IP)*CDP_POS(K,IP)
     &                 + FU_CM (IP)* CM_POS(K,IP)
        ENDDO
      ENDDO
C
      ELSE
C
C----- loop over points, adding objective-function contributions
       DO 1000 IP=1, NPOINT
C
        IF(IFUN.EQ.1) THEN
C
          FP    = CD(IP)
          FP_AL = CD_ALFA(IP)
          FP_MA = CD_MACH(IP)
          FP_RE = CD_REYN(IP)
C
          DO 111 K=1, NMOD(IP)
            FP_MOD(K) = CD_MOD(K,IP)
 111      CONTINUE
          DO 112 K=1, NPOS(IP)
            FP_POS(K) = CD_POS(K,IP)
 112      CONTINUE
C
          DO 114 K=1, NUPAR
            FP_UPAR(K) = 0.0
 114      CONTINUE
C
        ELSE IF(IFUN.EQ.2) THEN
C
          FP    =  CD(IP)/CL(IP)
          FP_AL = (CD_ALFA(IP) - FP*CL_ALFA(IP))/CL(IP)
          FP_MA = (CD_MACH(IP) - FP*CL_MACH(IP))/CL(IP)
          FP_RE = (CD_REYN(IP) - FP*CL_REYN(IP))/CL(IP)
C
          DO 121 K=1, NMOD(IP)
            FP_MOD(K) = (CD_MOD(K,IP) - FP*CL_MOD(K,IP))/CL(IP)
 121      CONTINUE
          DO 122 K=1, NPOS(IP)
            FP_POS(K) = (CD_POS(K,IP) - FP*CL_POS(K,IP))/CL(IP)
 122      CONTINUE
C
          DO 124 K=1, NUPAR
            FP_UPAR(K) = 0.0
 124      CONTINUE
C
        ELSE IF(IFUN.EQ.3) THEN
C
          FP    = -CL(IP)
          FP_AL = -CL_ALFA(IP)
          FP_MA = -CL_MACH(IP)
          FP_RE = -CL_REYN(IP)
C
          DO 131 K=1, NMOD(IP)
            FP_MOD(K) = -CL_MOD(K,IP)
 131      CONTINUE
          DO 132 K=1, NPOS(IP)
            FP_POS(K) = -CL_POS(K,IP)
 132      CONTINUE
C
          DO 134 K=1, NUPAR
            FP_UPAR(K) = 0.0
 134      CONTINUE
C
        ELSE IF(IFUN.EQ.4) THEN
C
          CLMA = CL(IP)*MACH(IP)
C
          FP    = CD(IP)     /CLMA
          FP_AL = CD_ALFA(IP)/CLMA - CL_ALFA(IP)*FP/CL(IP)
          FP_MA = CD_MACH(IP)/CLMA - CL_MACH(IP)*FP/CL(IP)
     &                             -             FP/MACH(IP)
          FP_RE = CD_REYN(IP)/CLMA - CL_REYN(IP)*FP/CL(IP)
C
          DO 141 K=1, NMOD(IP)
            FP_MOD(K) = CD_MOD(K,IP)/CLMA - CL_MOD(K,IP)*FP/CL(IP)
 141      CONTINUE
          DO 142 K=1, NPOS(IP)
            FP_POS(K) = CD_POS(K,IP)/CLMA - CL_POS(K,IP)*FP/CL(IP)
 142      CONTINUE
C
          DO 144 K=1, NUPAR
            FP_UPAR(K) = 0.0
 144      CONTINUE
C
        ENDIF
C
C
C------ sum over points
        WPF =  WP(IP) / WPSUM
        FUNC       = WPF*FP        +  FUNC
        FUN_WP(IP) =     FP/WPSUM
C
        FU_AL(IP)  = WPF*FP_AL
        FU_MA(IP)  = WPF*FP_MA
        FU_RE(IP)  = WPF*FP_RE
C
        DO 191 K=1, NMOD(IP)
          FU_MOD(K,IP) = WPF*FP_MOD(K)
 191    CONTINUE
C
        DO 192 K=1, NPOS(IP)
          FU_POS(K,IP) = WPF*FP_POS(K)
 192    CONTINUE
C
        DO 194 K=1, NUPAR
          FU_UP(K)     = WPF*FP_UPAR(K)   +  FU_UP(K)
 194    CONTINUE
C
 1000  CONTINUE
C
      ENDIF
C
C
C---- set forced change in objective function due to parameter changes
      DFUN = 0.
      DO IP = 1, NPOINT
        DFUN = FU_AL(IP)*DALFA(IP)
     &       + FU_MA(IP)*DMACH(IP)
     &       + FU_RE(IP)*DLNRE(IP)*REYN(IP)  +  DFUN
C
        DO K=1, NMOD(IP)
          DFUN = FU_MOD(K,IP)*DMOD(K,IP)  +  DFUN
        ENDDO
C
        DO K=1, NPOS(IP)
          DFUN = FU_POS(K,IP)*DPOS(K,IP)  +  DFUN
        ENDDO
      ENDDO
C
      DO K=1, NUPAR
        DFUN = FU_UP(K)*DUPAR(K)  +  DFUN
      ENDDO
C
C---- total modified objective function
      FUNMOD = FUNC + DFUN
C
      RETURN
      END ! FUCALC



      SUBROUTINE FCCALC(IH)
C------------------------------------------------------
C     Calculates current Lagrange multipliers ALGM, and 
C     constrained objective function gradient FC_PAR
C     at history point IH using current constraints.
C------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION GPARU(NHESX), GPARC(NHESX)
C
C---- transform unconstrained derivatives to scaled/eigenvector space
      CALL GP2SE(FU_PAR(1,IH),GPARU)
C
C---- set RHS for Lagrange multiplier system in either space
      DO 40 L=1, NCON
        SUM = 0.
        DO 404 K=1, NHES
          SUM = SUM + GPARU(K)*BMAT(K,L)
 404    CONTINUE
        ALGM(L) = SUM
 40   CONTINUE
C
C---- calculate Lagrange multipliers
      CALL BAKSUB(NCONX,NCON,PRJ,PRJPIV,ALGM(1))
C
C---- calculate constrained gradient components in either space
      DO 50 K=1, NHES
        GSUM = 0.
        DO 504 L=1, NCON
          GSUM = GSUM + BMAT(K,L)*ALGM(L)
 504    CONTINUE
        GPARC(K) = GPARU(K) - GSUM
 50   CONTINUE
C
C
C---- set derivatives from scaled/eigenvector space to physical space
      CALL GSE2P(GPARC,FC_PAR(1,IH))
C
      LFCSET = .TRUE.
C
      RETURN
      END ! FCCALC



      SUBROUTINE PARSET
      INCLUDE 'LINDOP.INC'
C-------------------------------------------
C     Stuffs active variables, scales, 
C     and gradients into pointered arrays.
C-------------------------------------------
      IH = NHIS
C
      DO 10 K=1, NPAR
        FU_PAR(K,IH) = 0.
 10   CONTINUE
C
C
      DO 40 IP=1, NPOINT
C
        DO 402 K=1, NMOD(IP)
          IF(LMOD(K,IP)) THEN
           KPAR = KHESMOD(K,IP)
           PAR(KPAR,IH) = MODN(K,IP)
           FU_PAR(KPAR,IH) = FU_MOD(K,IP) + FU_PAR(KPAR,IH)
           GSCPAR(KPAR) = GSCMOD(K)
           DPAR(KPAR) = DMOD(K,IP)
          ENDIF
 402    CONTINUE
C
        DO 404 K=1, NPOS(IP)
          IF(LPOS(K,IP)) THEN
           KPAR = KHESPOS(K,IP)
           PAR(KPAR,IH) = POSN(K,IP)
           FU_PAR(KPAR,IH) = FU_POS(K,IP) + FU_PAR(KPAR,IH)
           GSCPAR(KPAR) = GSCPOS(K)
           DPAR(KPAR) = DPOS(K,IP)
          ENDIF
 404    CONTINUE
C
        IF(LALFA(IP)) THEN
         KPAR = KHESAL(IP)
         PAR(KPAR,IH) = ALFA(IP)
         FU_PAR(KPAR,IH) = FU_AL(IP) + FU_PAR(KPAR,IH)
         GSCPAR(KPAR) = GSCAL
         DPAR(KPAR) = DALFA(IP)
        ENDIF
C
        IF(LMACH(IP)) THEN
         KPAR = KHESMA(IP)
         PAR(KPAR,IH) = MACH(IP)
         FU_PAR(KPAR,IH) = FU_MA(IP) + FU_PAR(KPAR,IH)
         GSCPAR(KPAR) = GSCMA
         DPAR(KPAR) = DMACH(IP)
        ENDIF
C
        IF(LREYN(IP)) THEN
         KPAR = KHESLR(IP)
         PAR(KPAR,IH) = LOG(MAX(REYN(IP),1.0))
         FU_PAR(KPAR,IH) = FU_RE(IP)*REYN(IP) + FU_PAR(KPAR,IH)
         GSCPAR(KPAR) = GSCLR
         DPAR(KPAR) = DLNRE(IP)
        ENDIF
C
 40   CONTINUE
C
      DO 60 K=1, NUPAR
        IF(LUPAR(K)) THEN
         KPAR = KHESUP(K)
         PAR(KPAR,IH) = UPAR(K)
         FU_PAR(KPAR,IH) = FU_UP(K) + FU_PAR(KPAR,IH)
         GSCPAR(KPAR) = GSCUP(K)
         DPAR(KPAR) = DUPAR(K)
        ENDIF
 60   CONTINUE
C
      RETURN
      END ! PARSET



      SUBROUTINE VGRAD
      INCLUDE 'LINDOP.INC'
C
C---- sets directional derivative dF/depsilon along search direction
C
      IH = NHIS
C
      VA = VABS(IH)
      IF(VA .EQ. 0.0) VA = 1.0
C
      FU_SOP     = 0.
      FC_SOP(IH) = 0.0
      DO 32 K=1, NPAR
        FU_SOP     = FU_SOP     + FU_PAR(K,IH)*VPAR(K,IH)/VA
        FC_SOP(IH) = FC_SOP(IH) + FC_PAR(K,IH)*VPAR(K,IH)/VA
 32   CONTINUE
C
      RETURN
      END ! VGRAD



      SUBROUTINE DELCON
C----------------------------------------------------
C     Calculates forced parameter changes required
C     to drive constraint residuals to zero.
C
C     Assumes factored projection matrix PRJ
C     is available.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION DPART(NHESX), DPARC(0:NHESX), DCON(0:NCONX)
C
      IH = NHIS
C
C---- set -(constraint) residual array DCON
      CALL CONRES(DCON(1))
C
C---- set forced parameter changes in either space
      CALL BAKSUB(NCONX,NCON,PRJ,PRJPIV,DCON(1))
C
      DO 30 K=1, NHES
        SUM = 0.0
        DO 302 L=1, NCON
          SUM = SUM + BMAT(K,L)*DCON(L)
 302    CONTINUE
        DPART(K) = SUM
 30   CONTINUE
C
C
C---- set forced changes from scaled/eigenvector space to physical space
      CALL XSE2P(DPART(1),DPARC(1))
C
      DPARC(0) = 0.0
C
      CNSTEP = 0.0
      DFCON(IH) = 0.0
      DO 50 K=1, NPAR
        CNSTEP    = CNSTEP    +              DPART(K)
        DFCON(IH) = DFCON(IH) + FU_PAR(K,IH)*DPARC(K)
 50   CONTINUE
C
C
C---- store forced design variable changes
      DO 70 IP=1, NPOINT
        DALFAC(IP) = DPARC(KHESAL(IP))
        DMACHC(IP) = DPARC(KHESMA(IP))
        DLNREC(IP) = DPARC(KHESLR(IP))
C
        DO 701 K=1, NMOD(IP)
          DMODC(K,IP) = DPARC(KHESMOD(K,IP))
 701    CONTINUE
C
        DO 702 K=1, NPOS(IP)
          DPOSC(K,IP) = DPARC(KHESPOS(K,IP))
 702    CONTINUE
C
 70   CONTINUE
C
      DO 80 K=1, NUPAR
        DUPARC(K) = DPARC(KHESUP(K))
 80   CONTINUE
C
      RETURN
      END ! DELCON


