
      SUBROUTINE PLOPTS
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 OPT
C
 899  WRITE(*,1000)
 1000 FORMAT(/'  G eometry modes and total surface deformation'
     &       /'  P osition modes and total position shifts'
     &       /'  O ptimization scaled-gradient history'
     &       /'  D esign parameter history'
     &       /'  A nnotation menu'
     &       /'  H ardcopy current plot'
     &       /'  S ize change' )
C
 900  WRITE(*,1008)
 1008 FORMAT(/1X,'Enter plot option: ',$)
      READ (*,9000) OPT
C
      IF(OPT.EQ.' ') THEN
C
        RETURN
C
      ELSE IF(INDEX('Gg',OPT).NE.0) THEN
C
        CALL PLTINI
        CALL GMPLOT
        GO TO 900
C
      ELSE IF(INDEX('Pp',OPT).NE.0) THEN
C
        IF(NPOSMX.EQ.0) THEN
         WRITE(*,*) '*** No position modes available'
         GO TO 900
        ENDIF
        CALL PLTINI
        CALL PSPLOT
        GO TO 900
C
      ELSE IF(INDEX('Dd',OPT).NE.0) THEN
C
       IF(NHIS.LE.1) THEN
         WRITE(*,*) '*** No optimization history to plot'
         GO TO 900
        ENDIF
        CALL PLTINI
        CALL HSPLOT(1)
        GO TO 900
C
      ELSE IF(INDEX('Oo',OPT).NE.0) THEN
C
       IF(NHIS.LE.1) THEN
         WRITE(*,*) '*** No optimization history to plot'
         GO TO 900
        ENDIF
        CALL PLTINI
        CALL HSPLOT(2)
        GO TO 900
C
      ELSE IF(INDEX('Aa',OPT).NE.0) THEN
C
        CALL ANNOT(CH)
        GO TO 900
C
      ELSE IF(INDEX('Hh',OPT).NE.0) THEN
C
        IF(LPLOT) CALL PLEND
        CALL REPLOT(IDEVRP)
        GO TO 900
C
      ELSE IF(INDEX('Ss',OPT).NE.0) THEN
C
 110    WRITE(*,9010) SIZE
 9010   FORMAT(' Enter new plot size (currently =', F7.3,'):')
        READ (*,*,ERR=110) SIZE
        GO TO 900
C
      ELSE
C
        GO TO 899
C
      ENDIF
C..............................................
 9000 FORMAT(A1)
      END ! PLOPTS


      SUBROUTINE PLTINI
      INCLUDE 'LINDOP.INC'
C
C---- if plot is open then close it
      IF(LPLOT) CALL PLEND
C
C---- start new plot
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
C
C---- re-origin to clear margins
      CALL PLOTABS(XMARG,YMARG,-3)
C
      CALL NEWFACTOR(SIZE)
      LPLOT = .TRUE.
C
      RETURN
      END ! PLTINI


      SUBROUTINE PLTALL(LVSCAL)
      INCLUDE 'LINDOP.INC'
      LOGICAL LVSCAL
      LOGICAL LSPECP
C
C---- multiplier for mode displacement off original surface
      DATA MODSF, TOTSF / 1.0, 0.0 /
C
C---- airfoil name, code identifier, polar annotation  character heights
      CHN = 1.2*CH
      CHC = 0.9*CH
      CHP = 0.75*CH
C
      IP = IPTARG
      IS = ISTARG
      IV = IVTARG
C
      N = (IS+1)/2
C
      IF(IP.EQ.0) IP = 1
C
      CALL GETCOLOR(ICOL0)
C
C---- plot objective-function info
      XLIM(1) = 0.0
      XLIM(2) = FRDX1*PLDX1
      YLIM(1) = 0.0
      YLIM(2) = PLDY1
      CALL BOX(XLIM,YLIM,4)
      CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
      XLAB = XLIM(1) + 1.0*CH
      YLAB = YLIM(2) - 1.5*CH
      CALL OFUNPL(XLAB,YLAB,CH)
C
      CALL CLRCLIP
C
C
      IF(NPOINT.EQ.1) THEN
      ELSE
C
C----- plot polar or sweep
       XLIM(1) = PLDX1*FRDX1
       XLIM(2) = PLDX1
       YLIM(1) = 0.0
       YLIM(2) = PLDY1
       CALL BOX(XLIM,YLIM,4)
       CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
       XFRP = 1.0 - (1.0-XFR)*1.25
       YFRP = 1.0 - (1.0-YFR)*1.25
       FRDXP = 1.0 - FRDX1
C
       IF(LSWEEP) THEN
        XORG = XLIM(1) + 0.80*(1.0-XFRP)*PLDX1*FRDXP
        YORG = YLIM(1) + 0.70*(1.0-YFRP)*PLDY1
        XSIZ = XFRP*PLDX1*FRDXP
        YSIZ = YFRP*PLDY1
        CALL SWEPLT(XORG,YORG,XSIZ,YSIZ,CHP,.FALSE.)
       ELSE IF(LPOLAR) THEN
        XORG = XLIM(1) + 0.80*(1.0-XFR)*PLDX1*FRDXP
        YORG = YLIM(1) + 0.70*(1.0-YFR)*PLDY1
        XSIZ = XFRP*PLDX1*FRDXP
        YSIZ = YFRP*PLDY1
        CALL POLPLT(XORG,YORG,XSIZ,YSIZ,CHP,.FALSE.)
       ENDIF
C
       CALL CLRCLIP
C
      ENDIF
C
C---- airfoil geometry plot
      XLIM(1) = 0.0
      XLIM(2) = PLDX1
      YLIM(1) = PLDY1
      YLIM(2) = PLDY1+PLDY2
      CALL BOX(XLIM,YLIM,4)
      CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
      XSIZ = PLDX1*XFR
C
      XORG = XLIM(1) + 0.50*(1.0-XFR)*PLDX1
      YORG = YLIM(1) + 0.40          *PLDY2
      CALL GEOPLT(XORG,YORG,IP,N,XSIZ,MODSF,TOTSF)
C
      IF(MODSF .NE. 1.0) THEN
C----- plot axes if mode changes are scaled
       XARR = XLIM(1) + 0.20*(1.0-XFR)*PLDX1
       YARR = YLIM(1) + 0.50*(1.0-YFR)*PLDY1
       ARRLY = 0.8*PLDY1*XFR
       ARRLX = 0.8*PLDY1*XFR/MODSF
       CALL ARROW(XARR,YARR,ARRLX,0.0)
       CALL ARROW(XARR,YARR,0.0,ARRLY)
       CALL PLNUMB(XARR-CH,YARR+ARRLY+0.5*CH,CH,MODSF,0.0,-1)
       CALL PLMATH(XARR   ,YARR+ARRLY+0.5*CH,CH,'#'  ,0.0, 1)
      ENDIF
C
C---- plot airfoil name
      CALL NEWPEN(3)
      XNAM = XLIM(1) + 0.3*CHN
      YNAM = YLIM(2) - 1.5*CHN
      CALL PLCHAR(XNAM,YNAM,CHN,NAME(IP),0.0,32)
      IF(NBL(IP).GT.1 .AND. ISTARG.GT.0) THEN
       CHE = 0.7*CHN
       CALL PLCHAR(XNAM         ,YNAM-2.0*CHE,CHE,' (Element  )',0.0,12)
       CALL PLNUMB(XNAM+10.0*CHE,YNAM-2.0*CHE,CHE,   FLOAT(N)   ,0.0,-1)
      ENDIF
C
C---- plot code identifier
      CALL NEWPEN(2)
ccc   CALL PLCHAR(XLIM(1)+0.4*CHC,YLIM(1)+0.4*CHC,CHC,'LINDOP',0.0, 6)
      CALL PLCHAR(XLIM(1)+0.4*CHC,YLIM(1)+0.4*CHC,CHC, CODE   ,0.0,32)
ccc   CALL PLCHAR(XLIM(1)+7.5*CHC,YLIM(1)+0.2*CHC,CHC, CODE   ,0.0,32)
C
      CALL CLRCLIP
C
C
C---- active variable plots
      XLIM(1) = 0.0
      XLIM(2) = PLDX1
      YLIM(1) = PLDY1+PLDY2
      YLIM(2) = PLDY1+PLDY2+PLDY3
      CALL BOX(XLIM,YLIM,4)
      CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
      IF(IPTARG.EQ.0) THEN
C
        IF(LSWEEP) THEN
         XORG = XLIM(1) + 0.60*(1.0-XFR)*PLDX1
         YORG = YLIM(1) + 0.60*(1.0-YFR)*PLDY3
         XSIZ = XFRP*PLDX1
         YSIZ = YFRP*PLDY3
         CALL SWEPLT(XORG,YORG,XSIZ,YSIZ,CH,.TRUE.)
        ELSE IF(LPOLAR) THEN
         XORG = XLIM(1) + 0.60*(1.0-XFR)*PLDX1
         YORG = YLIM(1) + 0.60*(1.0-YFR)*PLDY3
         XSIZ = XFRP*PLDX1
         YSIZ = YFRP*PLDY3
         CALL POLPLT(XORG,YORG,XSIZ,YSIZ,CH,.TRUE.)
        ENDIF
C
      ELSE
C
        IP = IPTARG
        YORG = YLIM(1) + 0.60*(1.0-YFR)*PLDY3
        XSIZ = PLDX1*XFR
        YSIZ = PLDY3*YFR
        LSPECP = .NOT.LVSCAL
        CALL VARPLT(XORG,YORG,XSIZ,YSIZ,CH,IP,IS,IV,LSPECP,LVSCAL)
        IF(NPOINT.GT.1) THEN
          CALL NEWCOLORNAME(PCOLOR(IP))
          CALL PIDENT(XORG+0.5*CH,YORG+YSIZ,CH,IP)
          CALL NEWCOLOR(ICOL0)
        ENDIF
C  
        IF(IV.EQ.1) XLAB = XORG + 0.6*XSIZ
        IF(IV.EQ.2) XLAB = XORG + 0.2*XSIZ
        IF(IV.EQ.3) XLAB = XORG + 0.1*XSIZ
        IF(IV.EQ.4) XLAB = XORG + 0.6*XSIZ
        YLAB = YORG + YSIZ  !!!  - CH
        CALL COEFPL(XLAB,YLAB,CH,IP)
C
      ENDIF
C
      CALL CLRCLIP
C
C
C---- save plot limits of active variable plot for MODVAR or MODPOL
      XLIMV(1) = XLIM(1)
      XLIMV(2) = XLIM(2)
      YLIMV(1) = YLIM(1)
      YLIMV(2) = YLIM(2)
C
      IF(NPOINT.EQ.1) THEN
C----- plot all variable types for the single point
C
       PLDYP = (PLDY1+PLDY2+PLDY3)/FLOAT(NVAR)
C
C----- size of each variable point plot in right section
       XSIZ = PLDX2*XFR
       YSIZ = PLDYP*YFR
C
       DO 10 JV=NVAR, 1, -1
         XLIM(1) = PLDX1
         XLIM(2) = PLDX1+PLDX2
         YLIM(1) = PLDYP*FLOAT(JV-1)
         YLIM(2) = PLDYP*FLOAT(JV)
C
         CALL BOX(XLIM,YLIM,4)
         CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
         XORG = XLIM(1) + 0.60*(1.0-XFR)*PLDX2
         YORG = YLIM(1) + 0.60*(1.0-YFR)*PLDYP
         CALL VARPLT(XORG,YORG,XSIZ,YSIZ,0.6*CH,
     &               IP,IS,JV,.FALSE.,.FALSE.)
         CALL CLRCLIP
 10    CONTINUE
C
      ELSE
C----- plot target variable for all points
C
C----- find number of non-zero weighted points
       NPACTV = 0
       DO 18 IPOINT=1, NPOINT
         IF(WP(IPOINT) .NE. 0.0) NPACTV = NPACTV + 1
 18    CONTINUE
C
       IF(NPACTV.EQ.0) GO TO 22
C
       PLDYP = (PLDY1+PLDY2+PLDY3) / FLOAT( MAX(NPACTV,2) )
C
C----- size of each variable point plot in right section
       XSIZ = PLDX2*XFR
       YSIZ = PLDYP*YFR
C
       IPACTV = 0
       DO 20 IPOINT=1, NPOINT
         IF(WP(IPOINT) .EQ. 0.0) GO TO 20
C
         IPACTV = IPACTV + 1
C
         XLIM(1) = PLDX1
         XLIM(2) = PLDX1+PLDX2
         YLIM(1) = PLDYP*FLOAT(IPACTV-1)
         YLIM(2) = PLDYP*FLOAT(IPACTV)
C
         CALL BOX(XLIM,YLIM,4)
         CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
         ISPNT = MIN( IS , 2*NBL(IPOINT) )
C
         XORG = XLIM(1) + 0.60*(1.0-XFR)*PLDX2
         YORG = YLIM(1) + 0.60*(1.0-YFR)*PLDYP
         CALL VARPLT(XORG,YORG,XSIZ,YSIZ,0.6*CH,
     &               IPOINT,ISPNT,IV,.FALSE.,.FALSE.)
         CALL NEWCOLORNAME(PCOLOR(IPOINT))
         CALL PIDENT(XORG+0.5*CH,YORG+YSIZ,0.7*CH,IPOINT)
C
         XPLW = XLIM(2) - 0.40*(1.0-XFR)*PLDX2
         YPLW = YLIM(2) - 0.40*(1.0-YFR)*PLDYP
         CALL WIDENT(XPLW,YPLW,0.7*CH,WP(IPOINT))
C
         CALL NEWCOLOR(ICOL0)
C
         CALL CLRCLIP
 20    CONTINUE
C
      ENDIF
C
 22   CALL PLFLUSH
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! PLTALL
      
      
      
      SUBROUTINE GEOPLT(XORG,YORG,IPOINT,NBEL,XSIZ,MODSF,TOTSF)
C--------------------------------------------------
C     Plots baseline and modified airfoil geometry.
C
C        MODSF   scale factor for current changes
C        TOTSF   scale factor for total changes
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION XT(IX), YT(IX)
C     
      IP = IPOINT
      NB = NBEL
C
      IF(NB.EQ.0) THEN
       SINA = 0.0
       COSA = 1.0
       SF = XSIZ/(XBMAX-XBMIN)
       XOFF = -XORG/SF + XBMIN
       YOFF = -YORG/SF + 0.0
       XROT = 0.0
       YROT = 0.0
      ELSE
       SINA = SIN(AGPLT(NB,IP))
       COSA = COS(AGPLT(NB,IP))
       SF = XSIZ/CHPLT(NB,IP)
       XOFF = -XORG/SF + XLEB(NB,IP)
       YOFF = -YORG/SF + YLEB(NB,IP)
       XROT = XLEB(NB,IP)
       YROT = YLEB(NB,IP)
      ENDIF
C
      CALL GETCOLOR(ICOL0)
C
      CALL NEWPEN(1)
      CALL XAX1(XORG,YORG,XSIZ)
C
      CALL NEWPEN(2)
      DO 20 IS=1, 2*NBL(IP)
         N = (IS+1)/2
         ILE = ILEB(N,IP)
         ITE = ITEB(N,IP)
         NPTS = ITE - ILE + 1
C
         IF(MODSF .NE. 0.0) THEN
C
C-------- set up and plot modified geometry
          DO 204 I=ILE, ITE
             XBAR = XBI(I,IS,IP) - XROT
             YBAR = YBI(I,IS,IP) - YROT
             DO 2044 K=1, NMOD(IP)
                MODNEW = MODSF*DMOD(K,IP)
                XBAR = XBAR + XBI_MOD(I,IS,K,IP)*MODNEW
                YBAR = YBAR + YBI_MOD(I,IS,K,IP)*MODNEW
 2044        CONTINUE
             DO 2046 K=1, NPOS(IP)
                POSNEW = MODSF*DPOS(K,IP)
                XBAR = XBAR + XBI_POS(I,IS,K,IP)*POSNEW
                YBAR = YBAR + YBI_POS(I,IS,K,IP)*POSNEW
 2046        CONTINUE
             XT(I) = COSA*XBAR + SINA*YBAR + XROT
             YT(I) = COSA*YBAR - SINA*XBAR + YROT
 204      CONTINUE
C
          CALL NEWCOLORNAME(MCOLOR)
          CALL XYLINE(NPTS,XT(ILE),YT(ILE), XOFF,SF,YOFF,SF,3)
C
         ENDIF
C
C
         IF(TOTSF .NE. 0.0) THEN
C
C-------- set up and plot geometry modified by total changes
          DO 206 I=ILE, ITE
             XBAR = XBI(I,IS,IP) - XROT
             YBAR = YBI(I,IS,IP) - YROT
             DO 2064 K=1, NMOD(IP)
                MODNEW = TOTSF*MODN(K,IP)
                XBAR = XBAR + XBI_MOD(I,IS,K,IP)*MODNEW
                YBAR = YBAR + YBI_MOD(I,IS,K,IP)*MODNEW
 2064        CONTINUE
             DO 2066 K=1, NPOS(IP)
                POSNEW = TOTSF*POSN(K,IP)
                XBAR = XBAR + XBI_POS(I,IS,K,IP)*POSNEW
                YBAR = YBAR + YBI_POS(I,IS,K,IP)*POSNEW
 2066        CONTINUE
             XT(I) = COSA*XBAR + SINA*YBAR + XROT
             YT(I) = COSA*YBAR - SINA*XBAR + YROT
 206      CONTINUE
C
          CALL NEWCOLORNAME('magenta')
          CALL XYLINE(NPTS,XT(ILE),YT(ILE), XOFF,SF,YOFF,SF,4)
C
         ENDIF
C
C
C------- set up and plot baseline geometry
         DO 208 I=ILE, ITE
            XBAR = XBI(I,IS,IP) - XROT
            YBAR = YBI(I,IS,IP) - YROT
            XT(I) = COSA*XBAR + SINA*YBAR + XROT
            YT(I) = COSA*YBAR - SINA*XBAR + YROT
 208     CONTINUE
C
         CALL NEWCOLOR(ICOL0)
         CALL XYLINE(NPTS,XT(ILE),YT(ILE), XOFF,SF,YOFF,SF,1)
C
 20   CONTINUE
C
C
C---- put cross on stagnation point
      DO 30 N=1, NBL(IP)
        IS1 = 2*N-1
        IS2 = 2*N
        I = ILEB(N,IP)
        DXB = XBI(I+1,IS1,IP) - XBI(I+1,IS2,IP)
        DYB = YBI(I+1,IS1,IP) - YBI(I+1,IS2,IP)
        XBC = 0.5*(XBI(I,IS1,IP) + XBI(I,IS2,IP))
        YBC = 0.5*(YBI(I,IS1,IP) + YBI(I,IS2,IP))
C
        ASDEG = ATAN2(DYB,DXB) * 180.0/PI
        CALL PLSYMB((XBC-XOFF)*SF,(YBC-YOFF)*SF,0.4*CH*SF,3,ASDEG,0)
 30   CONTINUE
C
      IF(NMOD(IP).EQ.0) THEN
        CALL NEWCOLOR(ICOL0)
        RETURN
      ENDIF
C
C
C---- put symbol on mode endpoint location SBLEGN at leading edge
      DO 40 N=1, NBL(IP)
        IF(SBLEGN(N,IP) .LT. 0.0) THEN
         IS = 2*N-1
        ELSE
         IS = 2*N
        ENDIF
C
        SBC = ABS(SBLEGN(N,IP))
C
        DO 404 I=ILE, ITE-1
          IF(SBC.GE.SBI(I,IS,IP) .AND. SBC.LE.SBI(I+1,IS,IP)) GO TO 405
 404    CONTINUE
        GO TO 40
C
 405    DXB = XBI(I+1,IS,IP) - XBI(I,IS,IP)
        DYB = YBI(I+1,IS,IP) - YBI(I,IS,IP)
        DSB = SBI(I+1,IS,IP) - SBI(I,IS,IP)
        XBC = XBI(I,IS,IP) + (SBC - SBI(I,IS,IP)) * DXB / DSB
        YBC = YBI(I,IS,IP) + (SBC - SBI(I,IS,IP)) * DYB / DSB
C
        ASDEG = ATAN2(DYB,DXB) * 180.0/PI
        CALL PLSYMB((XBC-XOFF)*SF,(YBC-YOFF)*SF,0.3*CH*SF,5,ASDEG,0)
C
 40   CONTINUE
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! GEOPLT



      SUBROUTINE VARPLT(XORG1,YORG1,XSIZ,YSIZ,CHL,
     &                  IPOINT,ISIDE,IVAR,LSPECP,LVSCAL)
C-------------------------------------------------------------
C     Plots baseline and modified surface variable.
C
C     If LSPECP, also plots specified variable distributions.
C     If LVSCAL, also plots rms-perturbation distributions.
C-------------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL LSPECP, LVSCAL
      DIMENSION XT(IX), YT(IX)
C
      IP = IPOINT
      IS = ISIDE
      IV = IVAR
C
      CALL GETCOLOR(ICOL0)
C     
      IF(ISIDE.EQ.0) THEN
C----- plot all sides
       IS1 = 1
       IS2 = 2*NBL(IPOINT)
C
C----- set minimum scaling factor for all sides
       YFAC = VARSF(IS1,IP,IV)
       DO 2 IS=IS1, IS2
         IF(ABS(VARSF(IS,IP,IV)) .LE. ABS(YFAC)) THEN
          RNANN = NANN(IS,IP,IV)
          YSGN = SIGN( 1.0 , VARSF(IS,IP,IV) )
          YFAC = VARSF(IS,IP,IV)
         ENDIF
 2     CONTINUE
      ELSE
C----- plot both sides of element containing active side
       N = (IS+1)/2
       IS1 = 2*N-1
       IS2 = 2*N
C
cccC----- set minimum scaling factor for target side
ccc       IS = ISIDE
ccc       RNANN = NANN(IS,IP,IV)
ccc       YSGN = SIGN( 1.0 , VARSF(IS,IP,IV) )
ccc       YFAC = VARSF(IS,IP,IV)
C
C----- set minimum scaling factor for all sides on target element
       YFAC = VARSF(IS1,IP,IV)
       DO 3 IS=IS1, IS2
         IF(ABS(VARSF(IS,IP,IV)) .LE. ABS(YFAC)) THEN
          RNANN = NANN(IS,IP,IV)
          YSGN = SIGN( 1.0 , VARSF(IS,IP,IV) )
          YFAC = VARSF(IS,IP,IV)
         ENDIF
 3     CONTINUE
C
      ENDIF
C
      YMAX = 1.0/YFAC + VAROFF(IV)
      YMIN = VAROFF(IV)
      DY = (YMAX-YMIN)/RNANN
C
      YMANN = YMIN*ANNFAC(IV)
      DYANN = DY  *ANNFAC(IV)
C
      NDIG = INT(0.99 - ALOG10(ABS(DYANN)))
      NDIG = MAX( NDIG , 1 )
C
C
C---- set axes-origin coordinates
      XORG = XORG1
      YORG = YORG1 - YSIZ * YMIN/(YMAX-YMIN)
C
      YSF = YSIZ/(YMAX-YMIN)
      YOFF = -YORG/YSF
C
      CALL NEWPEN(2)
      CALL XAX1(XORG,YORG,XSIZ)
      CALL XAXLAB(XORG,YORG,XSIZ,CHL,IXPLT)
C
C---- plot y-axis and label
      CALL NEWPEN(2)
      CALL YAXIS(XORG,YORG+YMIN*YSF,YSIZ,
     &           DY*YSF,YMANN,DYANN,CHL,NDIG)
      CALL NEWPEN(3)
      CALL VARLAB(XORG,YORG+(YMAX-1.5*DY)*YSF-0.5*CHL,DY*YSF,CHL,IV)
      IF(IV.EQ.1) THEN
       CPST = CPSTAR(IP)
       IF(YSGN*CPST.GE.YSGN*YMIN .AND. YSGN*CPST.LE.YSGN*YMAX)
     &    CALL YDASH(XORG,XORG+XSIZ,YORG+CPST*YSF)
      ENDIF
C
      CALL NEWPEN(2)
C
      DO 10 IS=IS1, IS2
        N = (IS+1)/2
C
        ILE = ILEB(N,IP)
        ITE = ITEB(N,IP)
        IFF = IEND(N,IP)
C
        NSID = ITE - ILE + 1
        IF(ISIDE.EQ.0) THEN
C-------- plot only surface distributions if all elements are plotted
          NPTS = NSID
        ELSE
C-------- plot surface + wake distributions if one element is plotted
          NPTS = IFF - ILE
        ENDIF
C
        IF(ISIDE.EQ.0) THEN
         XSF = XSIZ/(XBMAX-XBMIN)
         XOFF = -XORG/XSF + XBMIN
        ELSE
         XSF = XSIZ/(XPL2(IS,IP)-XPL1(IS,IP))
         XOFF = -XORG/XSF + XPL1(IS,IP)
        ENDIF
C
        IF(LSPECP .AND. (IS.EQ.ISIDE .OR. L2SIDE .OR. ISIDE.EQ.0)) THEN
C------- plot specified variable distribution
         CALL NEWCOLORNAME('red')
         CALL XYLINE(NSID,XPL(ILE,IS,IP),VARSP(ILE,IS,IP),
     &               XOFF,XSF,YOFF,YSF,4)
C
C------- save offset/scaling for MODVAR
         XOFFV(IS) = XOFF
         YOFFV(IS) = YOFF
         XSFV(IS) = XSF
         YSFV(IS) = YSF
        ENDIF
C
C------ calculate current perturbed coordinate and variable
        DO 104 I=ILE, IFF-1
          DXT = 0.0
          DYT = VAR_ALFA(I,IS,IP,IV)*DALFA(IP)
     &        + VAR_MACH(I,IS,IP,IV)*DMACH(IP)
     &        + VAR_REYN(I,IS,IP,IV)*DLNRE(IP)*REYN(IP)
C
          DO 1044 K=1, NMOD(IP)
            DYT = DYT + VAR_MOD(I,IS,K,IP,IV)*DMOD(K,IP)
 1044     CONTINUE
          DO 1046 K=1, NPOS(IP)
            DXT = DXT + XPL_POS(I,IS,K,IP   )*DPOS(K,IP)
            DYT = DYT + VAR_POS(I,IS,K,IP,IV)*DPOS(K,IP)
 1046     CONTINUE
C
          XT(I) = XPL(I,IS,IP)    + DXT
          YT(I) = VAR(I,IS,IP,IV) + DYT
C
 104    CONTINUE
C
C------ plot current total and buffer perturbed variable
        CALL NEWCOLORNAME(MCOLOR)
        CALL XYLINE(NSID,XT(ILE),YT(ILE),
     &              XOFF,XSF,YOFF,YSF,3)
C
C------ plot baseline variable
        CALL NEWCOLOR(ICOL0)
        CALL XYLINE(NPTS,XPL(ILE,IS,IP),VAR(ILE,IS,IP,IV),
     &              XOFF,XSF,YOFF,YSF,1)
C
        IF(LVSCAL) THEN
         CALL NEWCOLORNAME('green')
C
         DO 106 I=ILE, IFF-1
           DXT = 0.0
           DYT = GVARMS(I,IS,IP)*DELTRY
C
           XT(I) = XPL(I,IS,IP)    + DXT
           YT(I) = VAR(I,IS,IP,IV) + DYT
 106     CONTINUE
         CALL XYLINE(NSID,XT(ILE),YT(ILE),
     &               XOFF,XSF,YOFF,YSF,4)
ccc  &               XOFF,XSF,YOFF,YSF,7)
C
         DO 108 I=ILE, IFF-1
           DXT = 0.0
           DYT = GVARMS(I,IS,IP)*DELTRY
C
           XT(I) = XPL(I,IS,IP)    + DXT
           YT(I) = VAR(I,IS,IP,IV) - DYT
 108     CONTINUE
         CALL XYLINE(NSID,XT(ILE),YT(ILE),
     &               XOFF,XSF,YOFF,YSF,4)
ccc  &               XOFF,XSF,YOFF,YSF,7)
        ENDIF
C
 10   CONTINUE
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! VARPLT


      SUBROUTINE POLPLT(XORG,YORG,XSIZ,YSIZ,CH1,LVSCAL)
C--------------------------------------------------
C     Plots baseline and modified CD vs CL.
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL LVSCAL
      DIMENSION CLM(NPX), CDM(NPX)
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      SH  = 0.4*CH1
      CHL = CH1
C
      CALL GETCOLOR(ICOL0)
C
      WPAVG = 0.
      DO 10 IP=1, NPOINT
        WPAVG = WPAVG + ABS(WP(IP))
        CLM(IP) = CL(IP) + CL_ALFA(IP)*DALFA(IP)
     &                   + CL_MACH(IP)*DMACH(IP)
     &                   + CL_REYN(IP)*DLNRE(IP)*REYN(IP)
        CDM(IP) = CD(IP) + CD_ALFA(IP)*DALFA(IP)
     &                   + CD_MACH(IP)*DMACH(IP)
     &                   + CD_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 102 K=1, NMOD(IP)
          CLM(IP) = CLM(IP) + CL_MOD(K,IP)*DMOD(K,IP)
          CDM(IP) = CDM(IP) + CD_MOD(K,IP)*DMOD(K,IP)
 102    CONTINUE
        DO 104 K=1, NPOS(IP)
          CLM(IP) = CLM(IP) + CL_POS(K,IP)*DPOS(K,IP)
          CDM(IP) = CDM(IP) + CD_POS(K,IP)*DPOS(K,IP)
 104    CONTINUE
 10   CONTINUE
      WPAVG = WPAVG/FLOAT(NPOINT)
      IF(WPAVG .EQ. 0.0) WPAVG = 1.0
C
      CLMAX = CL(1)
      CLMIN = CL(1)
      DO 50 IP=1, NPOINT
        CLMAX = MAX(CLMAX,CL(IP))
        CLMIN = MIN(CLMIN,CL(IP))
 50   CONTINUE
C
      CALL SGSCAL(1,CLMAX,0.0,CLSF,ANN,NANNCL)
      DCL = 1.0/(CLSF*FLOAT(NANNCL))
      CLMIN = DCL * AINT(CLMIN/DCL + 0.01)    
      CLMAX = DCL * AINT(CLMAX/DCL + 1.01)
      NANNCL = INT((CLMAX-CLMIN)/DCL + 0.01)
C
      CALL SGSCAL(1,CLMAX,CLMIN,CLSF,ANN,NANNCL)
      DCL = 1.0/(CLSF*FLOAT(NANNCL))
      CLMIN = DCL * AINT(CLMIN/DCL + 0.01)    
      CLMAX = DCL * AINT(CLMAX/DCL + 0.01)
      NANNCL = INT((CLMAX-CLMIN)/DCL + 0.01)
C
      CLSF = 1.0/(CLMAX-CLMIN)
      DCL = 1.0/(CLSF*FLOAT(NANNCL))
C
      CALL SGSCAL(NPOINT,CD,0.0,CDSF,ANN,NANNCD)
      DCD = 1.0/(CDSF*FLOAT(NANNCD))
C
      CLFAC = CLSF*XSIZ
      CDFAC = CDSF*YSIZ
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DCL)))
      CALL XAXIS(XORG,YORG,XSIZ,DCL*CLFAC,
     &           CLMIN,DCL,CHL,NDIG)
      CALL NEWPEN(3)
      XL = XORG + XSIZ - 0.5*DCL*CLFAC - 1.2*CHL
      YL = YORG - 1.9*CHL
      CALL PLCHAR(XL        ,YL        ,1.2*CHL,'C',0.0,1)
      CALL PLCHAR(XL+1.1*CHL,YL-0.5*CHL,1.0*CHL,'L',0.0,1)
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DCD)))
      CALL YAXIS(XORG,YORG,YSIZ,DCD*CDFAC,
     &           0.0,DCD,CHL,NDIG)
      CALL NEWPEN(3)
      XL = XORG - 3.5*CHL
      YL = YORG + YSIZ - 0.5*DCD*CDFAC - 0.5*CHL
      CALL PLCHAR(XL        ,YL        ,1.2*CHL,'C',0.0,1)
      CALL PLCHAR(XL+1.1*CHL,YL-0.5*CHL,1.0*CHL,'D',0.0,1)
C
C---- fine grid
      CALL NEWPEN(1)
      DXG = CLFAC*DCL / 2.0
      DYG = CDFAC*DCD / 2.0
      NXG = 2*NANNCL
      NYG = 2*NANNCD
      CALL PLGRID(XORG,YORG, NXG,DXG, NYG,DYG, LMASK2 )
C
      CALL NEWPEN(3)
      XOFF = -XORG/CLFAC + CLMIN
      YOFF = -YORG/CDFAC
cc      CALL XYLINE(NPOINT,CL ,CD ,
cc     &     XOFF,CLFAC,YOFF,CDFAC,1)
cc      CALL XYSYMB(NPOINT,CL ,CD ,
cc     &     XOFF,CLFAC,YOFF,CDFAC,SH,0)
cc
cc      CALL XYLINE(NPOINT,CLM,CDM,
cc     &     XOFF,CLFAC,YOFF,CDFAC,3)
cc      CALL XYSYMB(NPOINT,CLM,CDM,
cc     &     XOFF,CLFAC,YOFF,CDFAC,SH,0)
C
      CALL NEWCOLORNAME(MCOLOR)
      CALL XYLINE(NPOINT,CLM,CDM, XOFF,CLFAC,YOFF,CDFAC,3)
      CALL NEWCOLOR(ICOL0)
      CALL XYLINE(NPOINT,CL ,CD , XOFF,CLFAC,YOFF,CDFAC,1)
C
      DO 70 IP=1, NPOINT
        IF(WP(IP) .EQ. 0.0) GO TO 70
        SHW = SH * SQRT( ABS(WP(IP)/WPAVG) )
C
        CALL NEWCOLORNAME(PCOLOR(IP))
C
        XSYM = (CL(IP)-XOFF)*CLFAC
        YSYM = (CD(IP)-YOFF)*CDFAC
        CALL PLSYMB(XSYM,YSYM,SHW,1,0.0,0)
C
        XSYM = (CLM(IP)-XOFF)*CLFAC
        YSYM = (CDM(IP)-YOFF)*CDFAC
        CALL PLSYMB(XSYM,YSYM,SHW,1,0.0,0)
 70   CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      IF(LVSCAL) THEN
       DO 81 IP=1, NPOINT
         CLM(IP) = CL(IP) + GCLRMS(IP)*DELTRY
         CDM(IP) = CD(IP) + GCDRMS(IP)*DELTRY
 81    CONTINUE
       CALL XYLINE(NPOINT,CLM,CDM,
     &      XOFF,CLFAC,YOFF,CDFAC,4)
ccc  &      XOFF,CLFAC,YOFF,CDFAC,7)
C
       DO 82 IP=1, NPOINT
         CLM(IP) = CL(IP) - GCLRMS(IP)*DELTRY
         CDM(IP) = CD(IP) - GCDRMS(IP)*DELTRY
 82    CONTINUE
       CALL XYLINE(NPOINT,CLM,CDM,
     &      XOFF,CLFAC,YOFF,CDFAC,4)
ccc  &      XOFF,CLFAC,YOFF,CDFAC,7)
      ENDIF
C 
      IF(LVSCAL) THEN
C----- save offset/scaling
       IS = 1
       XOFFV(IS) = XOFF
       YOFFV(IS) = YOFF
       XSFV(IS) = CLFAC
       YSFV(IS) = CDFAC
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! POLPLT


      SUBROUTINE SWEPLT(XORG,YORG,XSIZ,YSIZ,CH1,LVSCAL)
C----------------------------------------------------
C     Plots baseline and modified CD,CDwave vs Mach
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL LSPECP,LVSCAL
      DIMENSION MACM(NPX), CDM(NPX), CDWM(NPX)
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
C
      SH  = 0.4*CH1
      CHL = CH1
C
      CALL GETCOLOR(ICOL0)
C
      WPAVG = 0.
      DO 10 IP=1, NPOINT
        WPAVG = WPAVG + ABS(WP(IP))
        MACM(IP) = MACH(IP) + DMACH(IP)
        CDM(IP) = CD(IP) + CD_ALFA(IP)*DALFA(IP)
     &                   + CD_MACH(IP)*DMACH(IP)
     &                   + CD_REYN(IP)*DLNRE(IP)*REYN(IP)
        CDWM(IP) = CDW(IP) + CDW_ALFA(IP)*DALFA(IP)
     &                     + CDW_MACH(IP)*DMACH(IP)
     &                     + CDW_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 102 K=1, NMOD(IP)
          CDM(IP)  = CDM(IP)  +  CD_MOD(K,IP)*DMOD(K,IP)
          CDWM(IP) = CDWM(IP) + CDW_MOD(K,IP)*DMOD(K,IP)
 102    CONTINUE
        DO 104 K=1, NPOS(IP)
          CDM(IP)  = CDM(IP)  +  CD_POS(K,IP)*DPOS(K,IP)
          CDWM(IP) = CDWM(IP) + CDW_POS(K,IP)*DPOS(K,IP)
 104    CONTINUE
 10   CONTINUE
      WPAVG = WPAVG/FLOAT(NPOINT)
      IF(WPAVG .EQ. 0.0) WPAVG = 1.0
C
C
      MAMAX = MACH(1)
      MAMIN = MACH(1)
      DO 50 IP=1, NPOINT
        MAMAX = MAX(MAMAX,MACH(IP))
        MAMIN = MIN(MAMIN,MACH(IP))
 50   CONTINUE
C
c      CALL SGSCAL(1,MAMAX,MAMIN,MASF,ANN,NANNMA)
c      DMA = 1.0/(MASF*FLOAT(NANNMA))
c      MAMIN = DMA * AINT(MAMIN/DMA + 0.01)
c      MAMAX = DMA * AINT(MAMAX/DMA + 1.01)
cC
c      CALL SGSCAL(1,MAMAX,MAMIN,MASF,ANN,NANNMA)
c      DMA = 1.0/(MASF*FLOAT(NANNMA))
C
C
      CALL SGSCAL(1,MAMAX,0.0,MASF,ANN,NANNMA)
      DMA = 1.0/(MASF*FLOAT(NANNMA))
      MAMAX = DMA * AINT(MAMAX/DMA + 1.01)
      MAMIN = DMA * AINT(MAMIN/DMA + 0.01)
C
      CALL SGSCAL(1,MAMAX,MAMIN,MASF,ANN,NANNMA)
      DMA = 1.0/(MASF*FLOAT(NANNMA))
      MAMAX = DMA * AINT(MAMAX/DMA + 1.01)
      MAMIN = DMA * AINT(MAMIN/DMA + 0.01)
C
C
      CALL SGSCAL(NPOINT,CD,0.0,CDSF,ANN,NANNCD)
      DCD = 1.0/(CDSF*FLOAT(NANNCD))
C
      MAFAC = MASF*XSIZ
      CDFAC = CDSF*YSIZ
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DMA)))
      CALL XAXIS(XORG,YORG,XSIZ,DMA*MAFAC,
     &           MAMIN,DMA,CHL,NDIG)
      CALL NEWPEN(3)
      XL = XORG + XSIZ - 0.5*DMA*MAFAC - 0.6*CHL
      YL = YORG - 2.2*CHL
      CALL PLCHAR(XL,YL,1.2*CHL,'M',0.0,1)
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DCD)))
      CALL YAXIS(XORG,YORG,YSIZ,DCD*CDFAC,
     &           0.0,DCD,CHL,NDIG)
      CALL NEWPEN(3)
      XL = XORG - 3.5*CHL
      YL = YORG + YSIZ - 0.5*DCD*CDFAC - 0.5*CHL
      CALL PLCHAR(XL        ,YL        ,1.2*CHL,'C',0.0,1)
      CALL PLCHAR(XL+1.1*CHL,YL-0.5*CHL,1.0*CHL,'D',0.0,1)
C
C---- fine grid
      CALL NEWPEN(1)
      DXG = MAFAC*DMA / 2.0
      DYG = CDFAC*DCD / 2.0
      NXG = 2*NANNMA
      NYG = 2*NANNCD
      CALL PLGRID(XORG,YORG, NXG,DXG, NYG,DYG, LMASK2 )
C
      CALL NEWPEN(3)
      XOFF = -XORG/MAFAC + MAMIN
      YOFF = -YORG/CDFAC
cc
cc      CALL XYLINE(NPOINT,MACH,CD ,
cc     &     XOFF,MAFAC,YOFF,CDFAC,1)
cc      CALL XYSYMB(NPOINT,MACH,CD ,
cc     &     XOFF,MAFAC,YOFF,CDFAC,SH,0)
cc
cc      CALL XYLINE(NPOINT,MACM,CDM,
cc     &     XOFF,MAFAC,YOFF,CDFAC,3)
cc      CALL XYSYMB,MACM,CDM,
cc     &     XOFF,MAFAC,YOFF,CDFAC,SH,0)
C
      CALL NEWCOLORNAME(MCOLOR)
      CALL XYLINE(NPOINT,MACM,CDM,  XOFF,MAFAC,YOFF,CDFAC,3)
      CALL XYLINE(NPOINT,MACM,CDWM, XOFF,MAFAC,YOFF,CDFAC,3)
C
      CALL NEWCOLOR(ICOL0)
      CALL XYLINE(NPOINT,MACH,CD ,  XOFF,MAFAC,YOFF,CDFAC,1)
      CALL XYLINE(NPOINT,MACH,CDW , XOFF,MAFAC,YOFF,CDFAC,1)
C
      DO 70 IP=1, NPOINT
        IF(WP(IP) .EQ. 0.0) GO TO 70
        SHW = SH * SQRT( ABS(WP(IP)/WPAVG) )
C
        CALL NEWCOLORNAME(PCOLOR(IP))
C
        XSYM = (MACH(IP)-XOFF)*MAFAC
        YSYM = (  CD(IP)-YOFF)*CDFAC
        CALL PLSYMB(XSYM,YSYM,SHW,1,0.0,0)
C
        XSYM = (MACM(IP)-XOFF)*MAFAC
        YSYM = ( CDM(IP)-YOFF)*CDFAC
        CALL PLSYMB(XSYM,YSYM,SHW,1,0.0,0)
 70   CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      IF(LVSCAL) THEN
       DO 81 IP=1, NPOINT
         CDM(IP) = CD(IP) + GCDRMS(IP)*DELTRY
 81    CONTINUE
       CALL XYLINE(NPOINT,MACH ,CDM ,
     &      XOFF,MAFAC,YOFF,CDFAC,4)
ccc  &      XOFF,MAFAC,YOFF,CDFAC,7)
C
       DO 82 IP=1, NPOINT
         CDM(IP) = CD(IP) - GCDRMS(IP)*DELTRY
 82    CONTINUE
       CALL XYLINE(NPOINT,MACH ,CDM ,
     &      XOFF,MAFAC,YOFF,CDFAC,4)
ccc  &      XOFF,MAFAC,YOFF,CDFAC,7)
      ENDIF
C
      IF(LVSCAL) THEN
C----- save offset/scaling
       IS = 1
       XOFFV(IS) = XOFF
       YOFFV(IS) = YOFF
       XSFV(IS) = MAFAC
       YSFV(IS) = CDFAC
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! SWEPLT


      SUBROUTINE OFUNPL(X1,Y1,CH1)
C----------------------------------------------------
C     Plots numerical objective-function values.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION XT(2), YT(2)
C
      IH = NHIS
C
      CHL = 0.95*CH1
C
      X2 = X1 + 7.8*CH1
      X3 = X2 + 9.0*CH1
C
      CALL GETCOLOR(ICOL0)
C
      IP = IPTARG
      IF(IPTARG.EQ.0) IP = IPGSEN
C
      N = (ISTARG+1)/2
      IF(ISTARG.EQ.0) N = 1
C
      ITH = 0
      THBO = THIKB(ITH,N,IP)
      THBM = THIKB(ITH,N,IP)
      ARBO = AREAB(N,IP)
      ARBM = AREAB(N,IP)
      ASGO = ASIGB(N,IP)
      ASGM = ASIGB(N,IP)
      EI1O = EI11B(N,IP)
      EI1M = EI11B(N,IP)
      DO 20 K=1, NMOD(IP)
        THBM = THBM + THB_MOD(K,ITH,N,IP)*DMOD(K,IP)
        ARBM = ARBM + ARB_MOD(K,N,IP)*DMOD(K,IP)
        ASGM = ASGM + ASG_MOD(K,N,IP)*DMOD(K,IP)
        EI1M = EI1M + EI1_MOD(K,N,IP)*DMOD(K,IP)
 20   CONTINUE
C      
      CALL NEWPEN(3)
      YL = Y1 - CHL
      YT(1) = YL - 0.4*CHL
      YT(2) = YL - 0.4*CHL
C
      CALL PLCHAR(X2,YL,CHL,'Baseline',0.0,8)
      XT(1) = X2
      XT(2) = X2 + 7.75*CHL
      CALL XYLINE(2,XT,YT,0.0,1.0,0.0,1.0, 1)
C
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLCHAR(X3,YL,CHL,'Modified',0.0,8)
      XT(1) = X3
      XT(2) = X3 + 7.75*CHL
      CALL XYLINE(2,XT,YT,0.0,1.0,0.0,1.0, 3)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 0.6*CHL
C
      CALL NEWPEN(2)
C
      CALL FUCALC(1,FUNC)
      YL = YL - 2.0*CH1
      CALL PLMATH(X1        ,YL       ,1.1*CH1,'S',0.0,1)
      CALL PLCHAR(X1+1.1*CH1,YL       ,    CH1,'w',0.0,1)
      CALL PLCHAR(X1+2.4*CH1,YL       ,    CH1,'C',0.0,1)
      CALL PLCHAR(X1+3.3*CH1,YL-0.5*CH,0.8*CH1,'D',0.0,1)
C
      CALL PLNUMB(X2,YL,CH1,FUNC  ,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,FUNMOD,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
C
      CALL FUCALC(2,FUNC)
      YL = YL - 2.0*CH1
      CALL PLMATH(X1        ,YL       ,1.1*CH1,'S' ,0.0,1)
      CALL PLCHAR(X1+1.1*CH1,YL       ,    CH1,'w' ,0.0,1)
      CALL PLCHAR(X1+2.2*CH1,YL       ,    CH1,'C' ,0.0,1)
      CALL PLCHAR(X1+3.0*CH1,YL-0.5*CH,0.8*CH1,'D' ,0.0,1)
      CALL PLCHAR(X1+3.9*CH1,YL       ,    CH1,'/C',0.0,2)
      CALL PLCHAR(X1+5.7*CH1,YL-0.5*CH,0.8*CH1,'L' ,0.0,1)
C
      CALL PLNUMB(X2,YL,CH1,FUNC  ,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,FUNMOD,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
      IF(IFTYPE.NE.0) THEN
C
       CALL FUCALC(3,FUNC)
       YL = YL - 2.0*CH1
       CALL PLMATH(X1        ,YL        ,1.1*CH1,'S',0.0,1)
       CALL PLCHAR(X1+1.1*CH1,YL        ,    CH1,'w',0.0,1)
       CALL PLCHAR(X1+2.4*CH1,YL        ,    CH1,'C',0.0,1)
       CALL PLCHAR(X1+3.3*CH1,YL-0.5*CH1,0.8*CH1,'L',0.0,1)
C
       CALL PLNUMB(X2,YL,CH1,-FUNC  ,0.0,5)
       CALL NEWCOLORNAME(MCOLOR)
       CALL PLNUMB(X3,YL,CH1,-FUNMOD,0.0,5)
       CALL NEWCOLOR(ICOL0)
C
      ELSE
C
       CALL FUCALC(0,FUNC)
       YL = YL - 2.0*CH1
       CALL PLMATH(X1        ,YL        ,1.1*CH1,'S',0.0,1)
       CALL PLCHAR(X1+1.1*CH1,YL        ,    CH1,'w',0.0,1)
       CALL PLCHAR(X1+2.4*CH1,YL        ,    CH1,'F',0.0,1)
       CALL PLCHAR(X1+3.1*CH1,YL-0.3*CH1,0.8*CH1,'user',0.0,4)
C
       CALL PLNUMB(X2,YL,CH1,FUNC  ,0.0,5)
       CALL NEWCOLORNAME(MCOLOR)
       CALL PLNUMB(X3,YL,CH1,FUNMOD,0.0,5)
       CALL NEWCOLOR(ICOL0)
C
      ENDIF
C
      YL = YL - 2.0*CH1
      CALL PLCHAR(X1        ,YL        ,0.9*CH1,'Thick' ,0.0,5)
      CALL PLNUMB(X2,YL,CH1,THBO,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,THBM,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 2.0*CH1
      CALL PLCHAR(X1        ,YL        ,0.9*CH1,'Area'  ,0.0,4)
      CALL PLNUMB(X2,YL,CH1,ARBO,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,ARBM,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 2.0*CH1
      CALL PLCHAR(X1        ,YL        ,0.9*CH1,'Strain',0.0,6)
      CALL PLNUMB(X2,YL,CH1,ASGO,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,ASGM,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 2.0*CH1
      CALL PLCHAR(X1        ,YL        ,0.9*CH1,'EI 100',0.0,6)
      CALL PLMATH(X1+1.9*CH1,YL+0.1*CH1,0.7*CH1,'#'     ,0.0,1)
      CALL PLNUMB(X2,YL,CH1,100.0*EI1O,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH1,100.0*EI1M,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! OFUNPL



      SUBROUTINE COEFPL(X1,Y1,CH1, IPOINT)
C----------------------------------------------------
C     Plots numerical force coefficients.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION XT(2), YT(2)
C
      IP = IPOINT
C
      CHL = CH1
C
      CALL GETCOLOR(ICOL0)
C
      X2 = X1 + 5.5*CH1
      X3 = X2 + 9.5*CH1
C
      CALL NEWPEN(3)
C
      YL = Y1 - CHL
      YT(1) = YL - 0.4*CHL
      YT(2) = YL - 0.4*CHL
C
      CALL PLCHAR(X2,YL,CHL,'Baseline',0.0,8)
      XT(1) = X2
      XT(2) = X2 + 7.75*CHL
      CALL XYLINE(2,XT,YT,0.0,1.0,0.0,1.0, 1)
C
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLCHAR(X3,YL,CHL,'Modified',0.0,8)
      XT(1) = X3
      XT(2) = X3 + 7.75*CHL
      CALL XYLINE(2,XT,YT,0.0,1.0,0.0,1.0, 3)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 0.5*CHL
C
      CALL NEWPEN(2)
C
      YL = YL - 1.8*CH1
      MACB = MACH(IP)
      MACM = MACH(IP) + DMACH(IP)
      CALL PLCHAR(X1,YL,CH,'Mach',0.0,4)
      CALL PLNUMB(X2,YL,CH,MACB,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,MACM,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      IF(REYN(IP) .NE. 0.0) THEN
       YL = YL - 1.8*CH1
       REYB = REYN(IP)
       REYM = REYN(IP) + DLNRE(IP)*REYN(IP)
       CALL PLCHAR(X1,YL,CH,'Re  ',0.0,4)
       CALL PLNUMB(X2,YL,CH,REYB/1.0E6,0.0,4)
       CALL NEWCOLORNAME(MCOLOR)
       CALL PLNUMB(X3,YL,CH,REYM/1.0E6,0.0,4)
       CALL NEWCOLOR(ICOL0)
       CALL PLMATH(X3+7.0*CH,YL+0.2*CH,0.8*CH,'#'  ,0.0,1)
       CALL PLCHAR(X3+8.0*CH,YL       ,    CH,'10 ',0.0,3)
       CALL PLMATH(X3+8.0*CH,YL       ,    CH,'  6',0.0,3)
      ENDIF
C
      YL = YL - 1.8*CH1
      ALB = ALFA(IP)
      ALM = ALFA(IP) + DALFA(IP)
      CALL PLCHAR(X1,YL,CH,'Alfa',0.0,4)
      CALL PLNUMB(X2,YL,CH,ALB/DTOR,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,ALM/DTOR,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 1.8*CH1
      CLB = CL(IP)
      CLM = CL(IP) + CL_ALFA(IP)* DALFA(IP)
     &             + CL_MACH(IP)* DMACH(IP)
     &             + CL_REYN(IP)* DLNRE(IP)*REYN(IP)
      DO 21 K=1, NMOD(IP)
        CLM = CLM + CL_MOD(K,IP)* DMOD(K,IP)
 21   CONTINUE
      DO 22 K=1, NPOS(IP)
        CLM = CLM + CL_POS(K,IP)* DPOS(K,IP)
 22   CONTINUE
      CALL PLCHAR(X1,YL,CH,'CL',0.0,2)
      CALL PLNUMB(X2,YL,CH,CLB,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,CLM,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 1.8*CH1
      CDB = CD(IP)
      CDM = CD(IP) + CD_ALFA(IP)* DALFA(IP)
     &             + CD_MACH(IP)* DMACH(IP)
     &             + CD_REYN(IP)* DLNRE(IP)*REYN(IP)
      DO 31 K=1, NMOD(IP)
        CDM = CDM + CD_MOD(K,IP)* DMOD(K,IP)
 31   CONTINUE
      DO 32 K=1, NPOS(IP)
        CDM = CDM + CD_POS(K,IP)* DPOS(K,IP)
 32   CONTINUE
      CALL PLCHAR(X1,YL,CH,'CD',0.0,2)
      CALL PLNUMB(X2,YL,CH,CDB,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,CDM,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 1.8*CH1
      CDB = CDW(IP)
      CDM = CDW(IP) + CDW_ALFA(IP)* DALFA(IP)
     &              + CDW_MACH(IP)* DMACH(IP)
     &              + CDW_REYN(IP)* DLNRE(IP)*REYN(IP)
      DO 41 K=1, NMOD(IP)
        CDM = CDM + CDW_MOD(K,IP)* DMOD(K,IP)
 41   CONTINUE
      DO 42 K=1, NPOS(IP)
        CDM = CDM + CDW_POS(K,IP)* DPOS(K,IP)
 42   CONTINUE
      CALL PLCHAR(X1,YL,CH,'CDw',0.0,3)
      CALL PLNUMB(X2,YL,CH,CDB,0.0,5)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,CDM,0.0,5)
      CALL NEWCOLOR(ICOL0)
C
      YL = YL - 1.8*CH1
      CMB = CM(IP)
      CMM = CM(IP) + CM_ALFA(IP)* DALFA(IP)
     &             + CM_MACH(IP)* DMACH(IP)
     &             + CM_REYN(IP)* DLNRE(IP)*REYN(IP)
      DO 51 K=1, NMOD(IP)
        CMM = CMM + CM_MOD(K,IP)* DMOD(K,IP)
 51   CONTINUE
      DO 52 K=1, NPOS(IP)
        CMM = CMM + CM_POS(K,IP)* DPOS(K,IP)
 52   CONTINUE
      CALL PLCHAR(X1,YL,CH,'CM',0.0,2)
      CALL PLNUMB(X2,YL,CH,CMB,0.0,4)
      CALL NEWCOLORNAME(MCOLOR)
      CALL PLNUMB(X3,YL,CH,CMM,0.0,4)
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! COEFPL


      SUBROUTINE GMPLOT
C----------------------------------------------------------
C     Sets up for airfoil geometry deformation mode plots.
C----------------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      CALL GETCOLOR(ICOL0)
C
      IP = IPGSEN
C
      WRITE(*,1100) IP
 1100 FORMAT(/1X,'Modes are plotted for point', I3 / )
C
C---- set max deformation mode value and max total displacement
      GKMIN = 0.
      GKMAX = 0.
      DKMIN = 0.
      DKMAX = 0.
      DO 10 IS=1, 2*NBL(IP)
        IF(.NOT.LMODES(IS,IP)) GO TO 10
C
        N = (IS+1)/2
        NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
C
        CHB = SQRT( (XTEB(N,IP)-XLEB(N,IP))**2
     &            + (YTEB(N,IP)-YLEB(N,IP))**2 )
        DO 102 IG=1, NPTS
          DKSUM = 0.0
          TKSUM = 0.0
          DO 1022 K=1, NMOD(IP)
            GKMIN = MIN( GKMIN , GN(IG,IS,K,IP) )
            GKMAX = MAX( GKMAX , GN(IG,IS,K,IP) )
            DKSUM = DKSUM + GN(IG,IS,K,IP)*DMOD(K,IP)
            TKSUM = TKSUM + GN(IG,IS,K,IP)*MODN(K,IP)
 1022     CONTINUE
          DKMIN = MIN( DKMIN , DKSUM/CHB , TKSUM/CHB )
          DKMAX = MAX( DKMAX , DKSUM/CHB , TKSUM/CHB )
 102    CONTINUE
 10   CONTINUE
C
C---- set mode-shape axis annotation parameters
      GKSCAL = MAX(GKMAX,-GKMIN)
      CALL SGSCAL(1,GKSCAL,0.0,GSF,GANN,NGANN)
      DGK = 1.0/(GSF*FLOAT(NGANN))
C
C---- set total-deformation axis annotation parameters
      DKSCAL = MAX(DKMAX,-DKMIN)
      CALL SGSCAL(1,DKSCAL,0.0,GSF,GANN,NGANN)
      DDK = 1.0/(GSF*FLOAT(NGANN))
      DDK = MAX( DDK , 0.00001 )
C
C---- set number of axis increments above/below x-axis
      NANNP = MAX( INT( GKMAX/DGK + 0.01) , INT( DKMAX/DDK + 0.01) )
      NANNM = MAX( INT(-GKMIN/DGK + 0.01) , INT(-DKMIN/DDK + 0.01) )
C
C---- reset annotation limits on both y-axes
      GKMIN = DGK*FLOAT(-NANNM)
      GKMAX = DGK*FLOAT( NANNP)
      DKMIN = DDK*FLOAT(-NANNM)
      DKMAX = DDK*FLOAT( NANNP)
C
C---- set number of sides which have nonzero modes
      NS = 0
      DO 50 IS=1, 2*NBL(IP)
        IF(LMODES(IS,IP)) NS = NS + 1
 50   CONTINUE
      NST = MAX( NS , 2 )
C
      PLDXP =  1.0
      PLDYP = (PLDY1+PLDY2+PLDY3)/FLOAT(NST)
C
      XLIM(1) = 0.0
      XLIM(2) = PLDXP
      XORG = XLIM(1) + 0.40*(1.0-XFR)*PLDXP
C
C---- size of each variable point plot in right section
      XSIZ = PLDXP*XFR
      YSIZ = PLDYP*YFR
C
      KS = 0
      DO 60 IS=1, 2*NBL(IP)
        IF(.NOT.LMODES(IS,IP)) GO TO 60
C
        KS = KS + 1
        YLIM(1) = PLDYP*FLOAT(NS-KS)
        YLIM(2) = PLDYP*FLOAT(NS-KS+1)
C
        CALL BOX(XLIM,YLIM,4)
C
        FRMAX = YFR*( GKMAX)/(GKMAX-GKMIN)
        FRMIN = YFR*(-GKMIN)/(GKMAX-GKMIN)
C
        YORG = YLIM(1) + 0.4*(1.0-YFR)*PLDYP + FRMIN*PLDYP
        CALL PLMODE(XORG,YORG,XSIZ,YSIZ,
     &              GKMIN,GKMAX,DGK,
     &              DKMIN,DKMAX,DDK,1.1*CH,IP,IS)
C
        CALL NEWPEN(3)
        RIS = FLOAT(IS)
        CALL PLCHAR(XORG+0.5*CH,YORG+FRMAX*PLDYP-CH,CH,'Side',0.0, 4)
        CALL PLNUMB(XORG+5.5*CH,YORG+FRMAX*PLDYP-CH,CH, RIS  ,0.0,-1)
C
 60    CONTINUE
C
      CALL PLFLUSH
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! GMPLOT


      SUBROUTINE PLMODE(XORG,YORG,XSIZ,YSIZ,
     &                  GMIN,GMAX,DG,
     &                  TMIN,TMAX,DT, CH1,IPOINT,ISIDE)
C----------------------------------------------------
C     Plots geometry perturbation modes and total 
C     surface displacement on one airfoil side.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION XBC(IX), GBC(IX), TBC(IX)
C
      IP = IPOINT
      IS = ISIDE
C
      N = (IS+1)/2
C
      CHN = 0.9*CH1
      CHL = 1.1*CH1
C
      XSF = XSIZ/(XPL2(IS,IP)-XPL1(IS,IP))
      GSF = YSIZ/(GMAX-GMIN)
      TSF = YSIZ/(TMAX-TMIN)
C
      XOFF = -XORG/XSF + XPL1(IS,IP)
      GOFF = -YORG/GSF
      TOFF = -YORG/TSF
C
C---- set chord-line x array and total displacement array
      NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
      CHB = SQRT( (XTEB(N,IP)-XLEB(N,IP))**2
     &          + (YTEB(N,IP)-YLEB(N,IP))**2 )
      DO 12 I=ILEB(N,IP), ITEB(N,IP)
        IG = I - ILEB(N,IP) + 1
        XBC(IG) = XPL(I,IS,IP)
        GKSUM = 0.0
        TKSUM = 0.0
        DO 122 K=1, NMOD(IP)
          GKSUM = GKSUM + GN(IG,IS,K,IP)*DMOD(K,IP)
          TKSUM = TKSUM + GN(IG,IS,K,IP)*MODN(K,IP)
 122    CONTINUE
        GBC(IG) =  GKSUM / CHB
        TBC(IG) =  TKSUM / CHB
 12   CONTINUE
C
      CALL GETCOLOR(ICOL0)
C
C---- plot x-axis
      CALL NEWPEN(1)
      CALL XAX1(XORG,YORG,XSIZ)
      CALL NEWPEN(2)
      CALL XAXLAB(XORG,YORG,XSIZ,CHL,IXPLT)
C
      CALL NEWPEN(2)
C
C---- plot mode shape y-axis
      CALL YAXIS(XORG,YORG+GMIN*GSF,(GMAX-GMIN)*GSF,
     &           DG*GSF,GMIN,DG,CHN,1)
      CALL NEWPEN(3)
      CALL PLCHAR(XORG-3.5*CHL,YORG+(GMAX-0.5*DG)*GSF-0.5*CHL,CHL,
     &            'g',0.0,1)
      CALL PLCHAR(XORG-2.5*CHL,YORG+(GMAX-0.5*DG)*GSF-0.9*CHL,0.7*CHL,
     &            'k',0.0,1)
C
C---- plot total displacement y-axis on right side
      CALL NEWCOLORNAME('red')
      NDIG = INT(0.99 - ALOG10(ABS(DT)))
      NDIG = MAX( NDIG , 1 )
      CALL YAXIS(XORG+XSIZ,YORG+TMIN*TSF,(TMAX-TMIN)*TSF,
     &           DT*TSF,TMIN,DT,-CHN,NDIG)
      CALL NEWPEN(3)
      CALL PLMATH(XORG+XSIZ+1.5*CHL,YORG+(TMAX-0.5*DT)*TSF-0.5*CHL,CHL,
     &            'O',0.0,1)
      CALL PLCHAR(XORG+XSIZ+1.5*CHL,YORG+(TMAX-0.5*DT)*TSF-0.5*CHL,CHL,
     &            ' n/c',0.0,4)
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot and label each mode shape
      DO 14 K=1, NMOD(IP)
        CALL NEWPEN(1)
        CALL XYLINE(NPTS,XBC,GN(1,IS,K,IP),XOFF,XSF,GOFF,GSF,1)
        CALL NEWPEN(2)
        DO 142 IG=2, NPTS-1
          GNI = GN(IG,IS,K,IP)
          IF(GNI .GT. GN(IG-1,IS,K,IP) .AND.
     &       GNI .GT. GN(IG+1,IS,K,IP)       ) THEN
           XPLT = (XBC(IG)-XOFF)*XSF + 0.8*CHN
           YPLT = (GNI    -GOFF)*GSF + 0.2*CHN
           IF(XPLT.GE.XLIM(1) .AND. XPLT.LE.XLIM(2) .AND.
     &        YPLT.GE.YLIM(1) .AND. YPLT.LE.YLIM(2)      ) THEN
             CALL PLNUMB(XPLT,YPLT,CHN,FLOAT(K),0.0,-1)
ccc             CALL PLMATH(XPLT+1.2*CHN,YPLT,0.8*CHN,'#',0.0,1)
ccc             CALL PLNUMB(XPLT+2.2*CHN,YPLT,CHN,DMOD(K,IP),0.0,4)
           ENDIF
           GO TO 14
          ENDIF
 142    CONTINUE
 14   CONTINUE
C
C---- plot total displacement distribution
      CALL NEWCOLORNAME('red')
      CALL NEWPEN(3)
      CALL XYLINE(NPTS,XBC,GBC,XOFF,XSF,TOFF,TSF,3)
C
      CALL NEWCOLORNAME('magenta')
      CALL NEWPEN(4)
      CALL XYLINE(NPTS,XBC,TBC,XOFF,XSF,TOFF,TSF,5)
C
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! PLMODE


      SUBROUTINE PSPLOT
C----------------------------------------------------
C     Plots airfoil geometry and element 
C     displacement mode vectors.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION XT(IX), YT(IX)
      LOGICAL LROT
      DATA DPWT / 0.20 /
C
      IP = IPGSEN
C
C---- set max position mode value
      PSMAX = 0.
      DO 1 K=1, NPOS(IP)
        DO 12 NN=1, NPOSEL(K,IP)
          N = NBPOS(NN,K,IP)
          IF(ABS(ABPOS(NN,K,IP)) .EQ. 0.0) THEN
           PSMAX = MAX( ABS(XBPOS(NN,K,IP)), 
     &                  ABS(YBPOS(NN,K,IP)), PSMAX )
          ELSE
           RLEB = SQRT(  (XLEB(N,IP)-XBPOS(NN,K,IP))**2
     &                 + (YLEB(N,IP)-YBPOS(NN,K,IP))**2 )
           RTEB = SQRT(  (XTEB(N,IP)-XBPOS(NN,K,IP))**2
     &                 + (YTEB(N,IP)-YBPOS(NN,K,IP))**2 )
           PSMAX = MAX( RLEB, RTEB, PSMAX )
          ENDIF
 12     CONTINUE
 1    CONTINUE
C
C
      PLDXP = 1.0
      PLDYP = PLDY1+PLDY2+PLDY3
C
      XLIM(1) = 0.0
      XLIM(2) = PLDXP
      YLIM(1) = 0.0
      YLIM(2) = PLDYP
C
      XORG = XLIM(1) + 0.50*(1.0-XFR)*PLDXP
      YORG = YLIM(1) + 0.30          *PLDYP
C
      XSIZ = PLDXP*XFR
      YSIZ = PLDYP*XFR
C
      SF = MIN( XSIZ/(XBMAX-XBMIN) , YSIZ/(YBMAX-YBMIN) )
      XOFF = -XORG/SF + XBMIN
      YOFF = -YORG/SF + 0.0
C     
ccc      CALL NEWPEN(1)
ccc      CALL XAX1(XORG-XBMIN*SF,YORG-YBMIN*SF,SF)
C
      CALL NEWPEN(2)
      MODSF =  1.0
      TOTSF = -1.0
      CALL GEOPLT(XORG,YORG,IP,0,XSIZ,MODSF,TOTSF)
C
      DO 4 N=1, NBL(IP)
C
        ILE = ILEB(N,IP)
        ITE = ITEB(N,IP)
C
        IS1 = 2*N-1
        IS2 = 2*N
C
ccc        NPTS = ITE-ILE+1
ccc        CALL NEWPEN(2)
ccc        CALL XYLINE(NPTS,XBI(ILE,IS1,IP),YBI(ILE,IS1,IP),
ccc     &              XOFF,SF,YOFF,SF,1)
ccc        CALL XYLINE(NPTS,XBI(ILE,IS2,IP),YBI(ILE,IS2,IP),
ccc     &              XOFF,SF,YOFF,SF,1)
C
        XC = XCENT(N,IP)
        YC = YCENT(N,IP)
C
        DO 44 K=1, NPOS(IP)
          RK = FLOAT(K)
C
          DO 446 NN=1, NPOSEL(K,IP)
            IF(NBPOS(NN,K,IP) .NE. N) GO TO 446
C
            IF(ABS(ABPOS(NN,K,IP)) .EQ. 0.0) THEN
             XBP = XBPOS(NN,K,IP) * DPWT
             YBP = YBPOS(NN,K,IP) * DPWT
C
             IF(ABS(XBP) .GT. 0.0 .OR. ABS(YBP) .GT. 0.0) THEN
              CALL NEWPEN(3)
              CALL ARROW((XC-XOFF)*SF,(YC-YOFF)*SF,XBP*SF,YBP*SF)
              XNUM = XC + XBP + 0.5*CH
              YNUM = YC + YBP
              CALL PLNUMB((XNUM-XOFF)*SF,(YNUM-YOFF)*SF,CH,RK,0.0,-1)
             ENDIF
            ELSE
             XR = XBPOS(NN,K,IP)
             YR = YBPOS(NN,K,IP)
             AROT = ABPOS(NN,K,IP)
             XBP = -AROT*(YC-YR) * DPWT
             YBP =  AROT*(XC-XR) * DPWT
C
             SINA = SIN(AROT*DPWT)
             COSA = COS(AROT*DPWT)
             XD = XR + (XC-XR)*COSA - (YC-YR)*SINA
             YD = YR + (XC-XR)*SINA + (YC-YR)*COSA
             CALL NEWPEN(1)
             CALL PLOT((XR-XOFF)*SF,(YR-YOFF)*SF,3)
             CALL PLOT((XC-XOFF)*SF,(YC-YOFF)*SF,2)
             CALL PLOT((XR-XOFF)*SF,(YR-YOFF)*SF,3)
             CALL PLOT((XD-XOFF)*SF,(YD-YOFF)*SF,2)
C
             CALL NEWPEN(3)
             CALL PLOT((XC-XOFF)*SF,(YC-YOFF)*SF,3)
             DO 4462 KF=1, 12
               FRAC = FLOAT(KF)/FLOAT(12)
               SINA = SIN(AROT*DPWT*FRAC)
               COSA = COS(AROT*DPWT*FRAC)
               XD = XR + (XC-XR)*COSA - (YC-YR)*SINA
               YD = YR + (XC-XR)*SINA + (YC-YR)*COSA
               CALL PLOT((XD-XOFF)*SF,(YD-YOFF)*SF,2)
 4462        CONTINUE
C
             DX = -AROT*(YD-YR)*DPWT
             DY =  AROT*(XD-XR)*DPWT
             X1 = XD + 0.030*DY
             Y1 = YD - 0.030*DX
             X2 = XD - 0.030*DY
             Y2 = YD + 0.030*DX
             XP = XD + 0.300*DX
             YP = YD + 0.300*DY
             CALL PLOT((XP-XOFF)*SF,(YP-YOFF)*SF,3)
             CALL PLOT((X1-XOFF)*SF,(Y1-YOFF)*SF,2)
             CALL PLOT((X2-XOFF)*SF,(Y2-YOFF)*SF,2)
             CALL PLOT((XP-XOFF)*SF,(YP-YOFF)*SF,2)
C
             XNUM = XP + 0.5*CH
             YNUM = YP
             CALL PLNUMB((XNUM-XOFF)*SF,(YNUM-YOFF)*SF,CH,RK,0.0,-1)
            ENDIF
C
 446      CONTINUE
C
 44     CONTINUE
C
 4    CONTINUE
C
      CALL PLFLUSH
      RETURN
      END ! PSPLOT



      SUBROUTINE LINMPL(XORG,YORG,XSIZ,YSIZ,CH1,AA,BB,CC)
C----------------------------------------------------
C     Plots optimization line-descent history.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION SOP(NHISX)
C
      PARAMETER (NLIN=100)
      DIMENSION SLIN(NLIN), FLIN(NLIN)
C
      YSHIFT = 1.5*CH1
C
C---- temporarily clear global plot blowup parameters (save current ones)
      CALL GETZOOMABS(XZ_OFF,YZ_OFF,XZ_FAC,YZ_FAC)
      CALL CLRZOOM
C
C---- history index of previous waypoint
      IH1 = MAX(NHIS-NSTEP(NHIS)+1,1)
C
C---- start plotting 5 waypoints back
      DO 4 IWAY=2, 5
        IF(IH1.GT.1) IH1 = MAX(IH1-NSTEP(IH1-1),1)
 4    CONTINUE
C
C---- first history index
      IH1 = 1
C
C---- set distance array for whole history
      SOP(NHIS) = 0.0
      DO 10 IH=NHIS-1, IH1, -1
        SOP(IH) = SOP(IH+1) - OPSTEP(IH)
 10   CONTINUE
C
      SOPMIN = SOP(NHIS)
      SOPMAX = SOP(NHIS)
      FUNMIN = FUN(NHIS)
      FUNMAX = FUN(NHIS)
      DO 12 IH=IH1, NHIS
        SOPMIN = MIN( SOPMIN , SOP(IH) )
        SOPMAX = MAX( SOPMAX , SOP(IH) )
        FUNMIN = MIN( FUNMIN , FUN(IH) )
        FUNMAX = MAX( FUNMAX , FUN(IH) )
 12   CONTINUE
C
      SOPMIN = SOPMIN + MIN(OPSTEP(NHIS) , 0.0)
      SOPMAX = SOPMAX + MAX(OPSTEP(NHIS) , 0.0)
      FUNMIN = FUNMIN + MIN(FC_SOP(NHIS)*OPSTEP(NHIS) , 0.0)
      FUNMAX = FUNMAX + MAX(FC_SOP(NHIS)*OPSTEP(NHIS) , 0.0)
C
C---- set plot scaling factors for F and S
      IF(IH .GT. IH1) THEN
C------ some point in middle of descent line
C
        CALL SGSCAL(1,SOPMAX,SOPMIN,SOPSF,ANN,NANSOP)
        DSOP = 1.0/(SOPSF*FLOAT(NANSOP))
        SOPMIN = DSOP * AINT(SOPMIN/DSOP - 1.01)
        SOPMAX = DSOP * AINT(SOPMAX/DSOP + 1.01)
        SOPSF = 1.0/(SOPMAX-SOPMIN)
C
        CALL SGSCAL(1,FUNMAX,FUNMIN,FUNSF,ANN,NANFUN)
        DFUN = 1.0/(FUNSF*FLOAT(NANFUN))
        FUNMIN = DFUN * AINT(FUNMIN/DFUN - 1.01)
        FUNMAX = DFUN * AINT(FUNMAX/DFUN + 1.01)
        FUNSF = 1.0/(FUNMAX-FUNMIN)
C
      ELSE 
C------ first point
C
        IF(FC_SOP(NHIS) .NE. 0.0) THEN
         DELSOP = 0.2 * 2.0*ABS(FUN(NHIS)/FC_SOP(NHIS))
         CALL SGSCAL(1,DELSOP,0.0,SOPSF,ANN,NANSOP)
         DSOP = 1.0/(SOPSF*FLOAT(NANSOP))
         SOPMIN = -DSOP * AINT(DELSOP/DSOP + 0.01)    
         SOPMAX =  DSOP * AINT(DELSOP/DSOP + 0.01)
        ELSE
         SOPMIN = -0.01
         SOPMAX =  0.01
         DSOP = 0.005
         NANSOP = 4
        ENDIF
        SOPSF = 1.0/(SOPMAX-SOPMIN)
C
        DELFUN = 0.3 * ABS(FUN(NHIS))
        CALL SGSCAL(1,DELFUN,0.0,FUNSF,ANN,NANFUN)
        DFUN = 1.0/(FUNSF*FLOAT(NANFUN))
        IF(FUN(NHIS) .GT. 0.0) THEN
         FUNMAX = DFUN * AINT(FUNMAX/DFUN + 1.01)
         FUNMIN = FUNMAX - DFUN*FLOAT(NANFUN)
        ELSE
         FUNMIN = -DFUN * AINT(-FUNMIN/DFUN + 1.01)
         FUNMAX = FUNMIN + DFUN*FLOAT(NANFUN)
        ENDIF
        FUNSF = 1.0/(FUNMAX-FUNMIN)
C
      ENDIF
C
C---- scale to specified window
      XSF = XSIZ*SOPSF
      YSF = YSIZ*FUNSF
C
      XOFF = -XORG/XSF + SOPMIN
      YOFF = -YORG/YSF + FUNMIN
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DSOP)))
      NDIG = MAX( NDIG , 1 )
      CALL XAXIS((SOPMIN-XOFF)*XSF,(FUNMIN-YOFF)*YSF,XSIZ,DSOP*XSF,
     &           SOPMIN,DSOP,CH1,NDIG)
C
      CALL NEWPEN(3)
      XL = (SOPMAX-0.5*DSOP-XOFF)*XSF - 2.6*CH1
      YL = (FUNMIN         -YOFF)*YSF - 3.6*CH1
      CALL PLMATH(XL,YL,1.2*CH1,'O    ',0.0,5)
      CALL PLCHAR(XL,YL,1.2*CH1,' step',0.0,5)
C
C---- shift y-axis up slightly
      CALL PLOT(0.0,YSHIFT,-3)
C
      CALL NEWPEN(2)
      NDIG = INT(0.99 - ALOG10(ABS(DFUN)))
      NDIG = MAX( NDIG , 1 )
      CALL YAXIS((0.0-XOFF)*XSF,(FUNMIN-YOFF)*YSF,-YSIZ,DFUN*YSF,
     &           FUNMIN,DFUN,CH1,NDIG)
      CALL NEWPEN(3)
      XL = (0.0            -XOFF)*XSF - 2.5*CH1
      YL = (FUNMAX-0.5*DFUN-YOFF)*YSF - 0.7*CH1
      CALL PLCHAR(XL,YL,1.4*CH1,'F',0.0,1)
C
      IF(NHIS.GT.1) THEN
       CALL NEWPEN(2)
       NH = NHIS - IH1 + 1
       CALL SPLNPL(NSTEP(IH1),NH,
     &             SOP(IH1),FUN(IH1),DFCON(IH1),FC_SOP(IH1),
     &             XOFF,XSF,YOFF,YSF,0.4*CH1)
      ENDIF
C
      DELSOP = SOPMAX - SOPMIN
      DO 30 IH=IH1, NHIS
C------ horizontal width and endpoint coordinates of tangent line segment
        DELS = 0.03*ABS(DELSOP)/SQRT(1.0 + (FC_SOP(IH)*YSF/XSF)**2)
        X1 = SOP(IH) - DELS
        X2 = SOP(IH) + DELS
        Y1 = FUN(IH) - DELS*FC_SOP(IH)
        Y2 = FUN(IH) + DELS*FC_SOP(IH)
C
C------ plot tangent line segment
        CALL NEWPEN(1)
        CALL PLOT((X1-XOFF)*XSF,(Y1-YOFF)*YSF,3)
        CALL PLOT((X2-XOFF)*XSF,(Y2-YOFF)*YSF,2)
C
C------ plot diamond symbol if this is start of line
        IF(NSTEP(IH).EQ.1) THEN
         CALL NEWPEN(3)
         CALL PLSYMB((SOP(IH)-XOFF)*XSF,
     &               (FUN(IH)-YOFF)*YSF,1.1*CH1,5,0.0,0)
        ENDIF
 30   CONTINUE
C
C---- put arrow at guessed step location
      IH = NHIS
      CALL NEWPEN(1)
C
      SARR = SOP(IH) + OPSTEP(IH)
      FARR = AA*SARR**2 + BB*SARR + CC
C
      DX = 0.0
      DY = 0.1*(FUNMAX-FUNMIN)*YSF
      X1 = (SARR - XOFF)*XSF
ccc   Y1 = (FARR - YOFF)*YSF - DY
      Y1 = (FUNMIN-YOFF)*YSF - YSHIFT
      CALL ARROW(X1,Y1,DX,DY)
C
      IHM = NHIS-1
C
C---- calculate fit parabola
      IF(IHM.GE.1 .AND. AA.NE.0.0) THEN
       DO 50 ILIN=1, NLIN/2
         SLIN(ILIN) = OPSTEP(IHM)*(FLOAT(ILIN-1)/FLOAT(NLIN/2-1) - 1.0)
         FLIN(ILIN) = AA*SLIN(ILIN)**2 + BB*SLIN(ILIN) + CC
 50    CONTINUE
C
       DO 52 ILIN=NLIN/2+1, NLIN
         SLIN(ILIN) = OPSTEP(IH)*FLOAT(ILIN-NLIN/2)/FLOAT(NLIN-NLIN/2)
         FLIN(ILIN) = AA*SLIN(ILIN)**2 + BB*SLIN(ILIN) + CC
 52    CONTINUE
C
C----- plot fit parabola
       CALL NEWPEN(2)
       CALL XYLINE(NLIN,SLIN,FLIN,XOFF,XSF,YOFF,YSF,3)
      ENDIF
C
C---- restore global plot blowup parameters
      CALL NEWZOOMABS(XZ_OFF,YZ_OFF,XZ_FAC,YZ_FAC)
C
      RETURN
      END ! LINMPL


      SUBROUTINE SPLNPL(NL,N,X,Y,DYC,YP, 
     &                  XOFF,XSF,YOFF,YSF,SH)
      DIMENSION NL(N)
      DIMENSION X(N), Y(N), DYC(N), YP(N)
C
C-----------------------------------------------------
C     Splines and plots objective function history 
C     in individual line-descent pieces.
C-----------------------------------------------------
      PARAMETER (NTX=100, NN=20)
      DIMENSION XT(NTX), TMP(NTX,3), XX(NN),YY(NN)
C
C---- overlay YT,YTP,DYT with TMP for passing them all to SORT routine
      DIMENSION YT(NTX), YPT(NTX), DYT(NTX)
      EQUIVALENCE (TMP(1,1), YT(1)),
     &            (TMP(1,2),YPT(1)),
     &            (TMP(1,3),DYT(1))
C
C---- first point of first line-descent piece
      K1 = 1
C
C---- loop over line-descent pieces
      DO 1 ILINE=1, 1234
C
C---- find last point KN in current line-descent piece
      DO 10 K=K1+1, N
        IF(NL(K) .EQ. 1) GO TO 11
 10   CONTINUE
      K = N
 11   KN = K
C
      NT = KN-K1+1
      IF(NT.GT.NTX) STOP 'SPLNPL: Array overflow.  Increase NTX.'
C
C---- store and sort line x,y,  subtracting off constraint corrections
      DYSUM = 0.
      DO 20 IT=1, NT
        K = K1 + IT - 1
C
        DYT(IT) = DYC(K)
        DYSUM = DYSUM + DYT(IT)
C
        XT(IT) = X(K)
        YT(IT) = Y(K) - DYSUM
        YPT(IT) = YP(K)
C
 20   CONTINUE
C
C---- sort arrays and remove duplicates
      CALL SORT(NTX,NT,3,XT,TMP)
      CALL REMD(NTX,NT,3,XT,TMP)
      CALL REMD(NTX,NT,3,XT,TMP)
      CALL REMD(NTX,NT,3,XT,TMP)
C
      IF(NT.LE.1) THEN
        STOP 'SPLNPL: Internal error. Only one point in descent line.'
      ELSE IF(NT.EQ.2) THEN
C----- spline line with prescribed left slope
       YPT1 = YPT(1)
       DYT1 = YPT(1)
       CALL SPLIND(YT,YPT,XT,NT,YPT1,-999.0)
      ELSE
C----- spline line with constant-curvature end conditions
C-     YPT array is overwritten
       CALL SPLIND(YT,YPT,XT,NT,-999.0,-999.0)
      ENDIF
C
C---- go over line-descent intervals
      DYSUM = 0.
      DO 30 IT=1, NT-1
        DYSUM = DYSUM + DYT(IT)
C
        DX = XT(IT+1) - XT(IT)
C
C------ fill finely-spaced line array over interval from spline
        DO 304 KK=1, NN
          FRAC = FLOAT(KK-1)/FLOAT(NN-1)
          XX(KK) = XT(IT) + DX * FRAC
          YY(KK) = SEVAL(XX(KK),YT,YPT,XT,NT) + DYSUM
 304    CONTINUE
C
C------ plot interval
        CALL XYLINE(NN,XX,YY,XOFF,XSF,YOFF,YSF,1)
C
C------ plot dashed vertical segment over Y discontinuity
        XX(1) = XX(NN)
        XX(2) = XX(NN)
        YY(1) = YY(NN)
        YY(2) = YY(NN) + DYT(IT+1)
        CALL XYLINE(2,XX,YY,XOFF,XSF,YOFF,YSF,4)
        CALL XYSYMB(2,XX,YY,XOFF,XSF,YOFF,YSF,SH,1)
C
C
 30   CONTINUE
C
      IF(KN.GE.N) RETURN
C
C---- set first point for next line-descent piece
      K1 = KN
 1    CONTINUE
C
      END ! SPLNPL



      SUBROUTINE HSPLOT(ITYPE)
C----------------------------------------------------
C     Plots optimization history of ...
C        design parameters (ITYPE=1)
C        scaled gradients  (ITYPE=2)
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION SOP(NHISX), TMP(NHISX,NHESX+2)
C
C---- overlay OFN,GFN arrays into one TMP array for passing to SORT routine
      DIMENSION OFN(NHISX), DFN(NHISX), GFN(NHISX,NHESX)
      EQUIVALENCE (TMP(1,1),OFN(1  )),
     &            (TMP(1,2),DFN(1  )),
     &            (TMP(1,3),GFN(1,1))
C
      DIMENSION KINP(40)
C
      LOGICAL LPLT(NHESX), LNUMOK, ERROR, LFIRST
      CHARACTER*1 PTYPE
C
 1000 FORMAT(A)
C
      XSIZ = 0.75
      YSIZ = 0.75*PLAR
      XLIM(1) = 0.0
      XLIM(2) = XSIZ + 0.20
      YLIM(1) = 0.0
      YLIM(2) = YSIZ + 0.20
C
C---- turn on clipping for current plot box
      CALL NEWCLIP(XLIM(1),XLIM(2),YLIM(1),YLIM(2))
C
      CH1 = CH
C
      XORG = 0.075
      YORG = 0.075
C
      LFIRST = .TRUE.
C
C---- temporarily clear global plot blowup parameters (save current ones)
      CALL GETZOOMABS(XZ_OFF,YZ_OFF,XZ_FAC,YZ_FAC)
      CALL CLRZOOM
C
C---- history index of previous waypoint
      IH1 = MAX(NHIS-NSTEP(NHIS)+1,1)
C
C---- plot starting index
      IH0 = 1
ccc      IH0 = IH1
C
C---- plot finishing index
      NH  = NHIS
      IF(ITYPE.EQ.2 .AND. .NOT.LFCSET) THEN
        WRITE(*,*) 'Gradient for current point not yet computed.'
        NH = NHIS - 1
      ENDIF
C
      NHF = NHIS
      IF(.NOT.LFCSET) NHF = NHIS - 1
C
C---- set current objective function and gradient
      CALL FUCALC(IFTYPE,FUNC)
      FUN(NHIS) = FUNC
C
C---- set pointers for current parameters
      IF(.NOT.LXPAR) CALL KHES
C
C---- set FU_PAR, GSCPAR pointered arrays
      CALL PARSET
C
C---- set distance array for whole history
      SOP(IH0) = 0.0
      DO 30 IH=IH0-1, 1, -1
        SOP(IH) = SOP(IH+1) - 1.0
 30   CONTINUE
      DO 31 IH=IH0+1, NH
        SOP(IH) = SOP(IH-1) + OPSTEP(IH-1)
 31   CONTINUE
C
      DO 40 IH=1, NH
        OFN(IH) = FUN(IH)
C
        IF(ITYPE.EQ.1) THEN
C-------- set GFN as parameter change
          DO 401 K=1, NPAR
            GFN(IH,K) = PAR(K,IH) - PAR(K,1)
            IF(INDEX(DPNAME(K),'ALFA').GT.0) GFN(IH,K) = GFN(IH,K)/DTOR
 401      CONTINUE
        ELSE
C-------- set GFN as scaled gradient w.r.t. parameter
          DO 402 K=1, NPAR
            GFN(IH,K) = FC_PAR(K,IH) / GSCPAR(K)
 402      CONTINUE
        ENDIF
C
C------ set gradient magnitude
        DFN(IH) = 0.
        DO 404 K=1, NPAR
          DFN(IH) = DFN(IH) + (FC_PAR(K,IH) / GSCPAR(K))**2
 404    CONTINUE
        DFN(IH) = SQRT(DFN(IH))
C
 40   CONTINUE
C
      CALL SORT(NHISX,NH,NPAR+2,SOP,TMP)
C
      SOPMIN = SOP(IH0)
      SOPMAX = SOP(IH0)
      FUNMIN = OFN(IH0)
      FUNMAX = OFN(IH0)
      DFNMIN = DFN(IH0)
      DFNMAX = DFN(IH0)
      GFNMIN = GFN(IH0,1)
      GFNMAX = GFN(IH0,1)
      DO 52 IH=IH0, NH
ccc      DO 52 IH=MAX(NH-10,1), NH
        SOPMIN = MIN( SOPMIN , SOP(IH) )
        SOPMAX = MAX( SOPMAX , SOP(IH) )
        FUNMIN = MIN( FUNMIN , OFN(IH) )
        FUNMAX = MAX( FUNMAX , OFN(IH) )
        DFNMIN = MIN( DFNMIN , DFN(IH) )
        DFNMAX = MAX( DFNMAX , DFN(IH) )
        DO 522 K=1, NPAR
          GFNMIN = MIN( GFNMIN , GFN(IH,K) )
          GFNMAX = MAX( GFNMAX , GFN(IH,K) )
 522    CONTINUE
 52   CONTINUE
C
C
C---- set plot scaling factors for S, F, D, and G
      CALL SGSCAL(1,SOPMAX,SOPMIN,SOPSF,ANN,NANSOP)
      DSOP = 1.0/(SOPSF*FLOAT(NANSOP))
      SOPMIN = DSOP * AINT(SOPMIN/DSOP - 0.01)
      SOPMAX = DSOP * AINT(SOPMAX/DSOP + 1.01)
      SOPSF = 1.0/(SOPMAX-SOPMIN)
C
      CALL SGSCAL(1,FUNMAX,FUNMIN,FUNSF,ANN,NANFUN)
      DFUN = 1.0/(FUNSF*FLOAT(NANFUN))
      FUNMIN = DFUN * AINT(FUNMIN/DFUN - 1.01)
      FUNMAX = DFUN * AINT(FUNMAX/DFUN + 1.01)
      FUNSF = 1.0/(FUNMAX-FUNMIN)
C
      CALL SGSCAL(1,DFNMAX,DFNMIN,DFNSF,ANN,NANDFN)
      DDFN = 1.0/(DFNSF*FLOAT(NANDFN))
      DFNMIN = DDFN * AINT(DFNMIN/DDFN - 1.01)
      DFNMAX = DDFN * AINT(DFNMAX/DDFN + 1.01)
      DFNSF = 1.0/(DFNMAX-DFNMIN)
C
      CALL SGSCAL(1,GFNMAX,GFNMIN,GFNSF,ANN,NANGFN)
      NANGFN = 2*NANGFN
      DGFN = 1.0/(GFNSF*FLOAT(NANGFN))
      GFNMIN = DGFN * AINT(GFNMIN/DGFN - 1.01)
      GFNMAX = DGFN * AINT(GFNMAX/DGFN + 1.01)
      GFNSF = 1.0/(GFNMAX-GFNMIN)
C
C
C---- scale to specified window
      XSF = XSIZ*SOPSF
      FSF = YSIZ*FUNSF
      DSF = YSIZ*DFNSF
      GSF = YSIZ*GFNSF
C
      XOFF = -XORG/XSF + SOPMIN
      FOFF = -YORG/FSF + FUNMIN
      DOFF = -YORG/DSF + DFNMIN
      GOFF = -YORG/GSF + GFNMIN
C
C
C---- plot objective function history
      CALL NEWCOLORNAME('green')
C
      CALL NEWPEN(2)
      XAX = (SOPMAX-XOFF)*XSF + 4.0*CH1
      CALL YAXIS(XAX,(FUNMIN-FOFF)*FSF,YSIZ,DFUN*FSF,
     &           FUNMIN,DFUN,-CH1,-2)
C
      CALL NEWPEN(3)
      XL = XAX                        + 1.9*CH1
      YL = (FUNMAX-0.5*DFUN-FOFF)*FSF - 0.8*CH1
      CALL PLCHAR(XL,YL,1.6*CH1,'F',0.0,1)
C
      CALL NEWPEN(4)
      CALL SPLNPL(NSTEP(IH0),NHF-IH0+1,
     &            SOP(IH0),FUN(IH0),DFCON(IH0),FC_SOP(IH0),
     &            XOFF,XSF,FOFF,FSF,0.4*CH1)
C
C---- plot diamond symbol if this is start of line
      CALL NEWPEN(3)
      DO 58 IH=IH0, NH
        IF(NSTEP(IH).EQ.1) THEN
         CALL PLSYMB((SOP(IH)-XOFF)*XSF,
     &               (FUN(IH)-FOFF)*FSF,1.1*CH1,5,0.0,0)
        ENDIF
 58   CONTINUE
C
      CALL NEWCOLORNAME('black')
      CALL PLFLUSH
C
C
C
      KAL = 0
      KMA = 0
      KRE = 0
      KGM = 0
      KPS = 0
      KUP = 0
      DO 8 K=1, NPAR
        KAL = MAX( KAL , INDEX(DPNAME(K),'ALFA') )
        KMA = MAX( KMA , INDEX(DPNAME(K),'MACH') )
        KRE = MAX( KRE , INDEX(DPNAME(K),'LNRE') )
        KGM = MAX( KGM , INDEX(DPNAME(K),'MOD' ) )
        KPS = MAX( KPS , INDEX(DPNAME(K),'POS' ) )
        DO 81 KK=1, NUPAR
          KUP = MAX( KUP , INDEX(DPNAME(K),UPNAME(KK)) )
 81     CONTINUE
 8    CONTINUE
C
C---- display menu item for every available parameter class
 10   WRITE(*,*)
      WRITE(*,*)              '    ! all'
      IF(KAL.GT.0) WRITE(*,*) '    A lpha'
      IF(KMA.GT.0) WRITE(*,*) '    M ach'
      IF(KRE.GT.0) WRITE(*,*) '    R eyn'
      IF(KGM.GT.0) WRITE(*,*) '    G eometry modes'
      IF(KPS.GT.0) WRITE(*,*) '    P osition modes'
      IF(KUP.GT.0) WRITE(*,*) '    U ser parameters'
      WRITE(*,*)
C
 1050 FORMAT(1X,A,I3)
C
 15   WRITE(*,1100)
 1100 FORMAT(1X,'Specify  parameter,index(s)  to plot:  ',$)
      READ(*,1000) LINE
C
      PTYPE = LINE(1:1)
C
      IF(PTYPE .EQ. ' ') THEN
C------ restore global plot blowup parameters
        CALL NEWZOOMABS(XZ_OFF,YZ_OFF,XZ_FAC,YZ_FAC)
        CALL CLRCLIP
        RETURN
      ENDIF
C
      IF(PTYPE.EQ.'a') PTYPE = 'A'
      IF(PTYPE.EQ.'m') PTYPE = 'M'
      IF(PTYPE.EQ.'r') PTYPE = 'R'
      IF(PTYPE.EQ.'g') PTYPE = 'G'
      IF(PTYPE.EQ.'p') PTYPE = 'P'
      IF(PTYPE.EQ.'u') PTYPE = 'U'
C
C---- if selected parameter is not recognized, ask again
      IF(INDEX('!AMRGPU',PTYPE).EQ.0) THEN
        WRITE(*,*) 'Command line not recognized'
        GO TO 15
      ENDIF
C
      LINE(1:1) = ' '
      CALL GETINT(LINE,KINP,NINP,ERROR)
      IF(ERROR) GO TO 15
C
C---- set special meaning: NINP=0 means plot all parameters in this class
      IF(NINP.GT.0 .AND. KINP(1).EQ.0) NINP = 0
C
      IF(LFIRST .AND. PTYPE.NE.'!') THEN
C------ initialize limits if no plot yet and not all will be plotted
        GFNMIN =  1.0E12
        GFNMAX = -1.0E12
      ENDIF
C
C---- go over all active parameters
      DO 60 K=1, NPAR
        LPLT(K) = PTYPE.EQ.'!'
C
        IF(PTYPE.EQ.'U') THEN
C-------- go over available user parameters
          DO 602 KK=1, NUPAR
C---------- plot if name matches and parameter number was selected (or 0)
            LPLT(K) = LPLT(K) .OR.
     &          (INDEX(DPNAME(K),UPNAME(KK)).GT.0 .AND. NINP.EQ.0    )
            DO 6024 L=1, NINP
              LPLT(K) = LPLT(K) .OR. 
     &          (INDEX(DPNAME(K),UPNAME(KK)).GT.0 .AND. KINP(L).EQ.KK)
 6024       CONTINUE
 602      CONTINUE
        ENDIF
C
C------ see if number in name (KNUM) matches any selected number 
        LNUMOK = NINP.EQ.0
        IF(PTYPE.NE.'U') THEN
          READ(DPNAME(K)(6:8),*,ERR=60) KNUM
          DO 605 L=1, NINP
            IF(KINP(L) .EQ. KNUM) LNUMOK = .TRUE.
 605      CONTINUE
        ENDIF
C
C------ is this parameter to be plotted?
        LPLT(K) = LPLT(K) .OR.
     &   (PTYPE.EQ.'A' .AND. DPNAME(K)(1:4).EQ.'ALFA' .AND. LNUMOK) .OR.
     &   (PTYPE.EQ.'M' .AND. DPNAME(K)(1:4).EQ.'MACH' .AND. LNUMOK) .OR.
     &   (PTYPE.EQ.'R' .AND. DPNAME(K)(1:4).EQ.'LNRE' .AND. LNUMOK) .OR.
     &   (PTYPE.EQ.'G' .AND. DPNAME(K)(1:4).EQ.'MOD ' .AND. LNUMOK) .OR.
     &   (PTYPE.EQ.'P' .AND. DPNAME(K)(1:4).EQ.'POS ' .AND. LNUMOK)
C
        IF(LFIRST .AND. LPLT(K)) THEN
C-------- set limits for plotted parameters
          IF(PTYPE.NE.'!') THEN
            DO IH=IH0, NH
              GFNMIN = MIN( GFNMIN , GFN(IH,K) )
              GFNMAX = MAX( GFNMAX , GFN(IH,K) )
            ENDDO
          ENDIF
        ENDIF
C
 60   CONTINUE
C
C
      IF(LFIRST) THEN
C------ plot axes for first call
        CALL SGSCAL(1,GFNMAX,GFNMIN,GFNSF,ANN,NANGFN)
        NANGFN = 2*NANGFN
        DGFN = 1.0/(GFNSF*FLOAT(NANGFN))
        GFNMIN = DGFN * AINT(GFNMIN/DGFN - 1.01)
        GFNMAX = DGFN * AINT(GFNMAX/DGFN + 1.01)
        GFNSF = 1.0/(GFNMAX-GFNMIN)
C
        GSF = YSIZ*GFNSF
C
        GOFF = -YORG/GSF + GFNMIN
C
        CALL NEWPEN(2)
        YAX = (0.0-GOFF)*GSF
        CALL XAXIS((SOPMIN-XOFF)*XSF,YAX,-XSIZ,DSOP*XSF,
     &             SOPMIN,DSOP, CH1,-2)
C     
        CALL NEWPEN(3)
        XL = (SOPMAX-1.5*DSOP-XOFF)*XSF - 2.6*CH1
        YL = YAX                        - 3.6*CH1
        CALL PLCHAR(XL,YL,1.2*CH1,'step',0.0,4)
C     
        CALL NEWPEN(2)
        CALL YAXIS((SOPMIN-XOFF)*XSF,(GFNMIN-GOFF)*GSF,YSIZ,DGFN*GSF,
     &              GFNMIN,DGFN, CH1,-2)
        CALL NEWPEN(3)
        XL = (SOPMIN         -XOFF)*XSF - 4.5*CH1
        YL = (GFNMAX-1.5*DGFN-GOFF)*GSF
        IF(ITYPE.EQ.1) THEN
          CALL PLMATH(XL        ,YL        ,1.5*CH1,'O ',0.0,2)
          CALL PLCHAR(XL        ,YL        ,1.5*CH1,' X',0.0,2)
          CALL PLCHAR(XL+2.8*CH1,YL-0.6*CH1,1.0*CH1, 'k',0.0,1)
        ELSE
          CALL PLCHAR(XL,YL+0.8*CH1,1.2*CH1,'dF',0.0,2)
          CALL PLCHAR(XL,YL+0.8*CH1,1.2*CH1,'__',0.0,2)
          CALL PLMATH(XL,YL-1.7*CH1,1.2*CH1,' _',0.0,2)
          CALL PLCHAR(XL,YL-1.7*CH1,1.2*CH1,'dX',0.0,2)
          CALL PLCHAR(XL+2.2*CH1,YL-2.3*CH1,1.0*CH1,'k',0.0,1)
C
          CALL NEWCOLORNAME('red')
          YL = (GFNMAX-0.5*DGFN-GOFF)*GSF
          CALL PLCHAR(XL-0.9*CH1,YL-0.5*CH1,1.4*CH1,'| |',0.0,3)
          CALL PLCHAR(XL        ,YL-0.5*CH1,1.2*CH1,' F',0.0,2)
          CALL PLMATH(XL        ,YL-0.5*CH1,1.2*CH1,'N' ,0.0,1)
          CALL NEWCOLORNAME('black')
        ENDIF
C     
        LFIRST = .FALSE.
      ENDIF
C
      DO 70 K = 1, NPAR
        IF(LPLT(K)) THEN
C-------- plot this parameter's history if selection test passed
          CALL NEWPEN(2)
          CALL XYLINE(NH-IH0+1,SOP(IH0),GFN(IH0,K),XOFF,XSF,GOFF,GSF,K)
C
          XL = (SOP(IH0)  -XOFF)*XSF
          YL = (GFN(IH0,K)-GOFF)*GSF
          CALL PLCHAR(XL+0.5*CH1,YL+0.2*CH1,0.9*CH1,DPNAME(K),0.0,8)
C
          XL = (SOP(NH)  -XOFF)*XSF
          YL = (GFN(NH,K)-GOFF)*GSF
          CALL PLCHAR(XL+0.5*CH1,YL-0.4*CH1,0.9*CH1,DPNAME(K),0.0,8)
        ENDIF
 70   CONTINUE
C
      IF(ITYPE.EQ.2) THEN
C------ plot gradient magnitude
        CALL NEWCOLORNAME('red')
        CALL NEWPEN(2)
        CALL XYLINE(NH-IH0+1,SOP(IH0),DFN(IH0),XOFF,XSF,GOFF,GSF,1)
        CALL NEWCOLORNAME('black')
      ENDIF
C
      CALL PLFLUSH
      GO TO 10
C
      END ! HSPLOT


      SUBROUTINE ARROW(X,Y,DX,DY)
      CALL PLOT(X,Y,3)
      CALL PLOT(X+DX,Y+DY,2)
      X1 = X + 0.90*DX + 0.007*DY
      Y1 = Y + 0.90*DY - 0.007*DX
      X2 = X + 0.90*DX - 0.007*DY
      Y2 = Y + 0.90*DY + 0.007*DX
      CALL PLOT(X1,Y1,2)
      CALL PLOT(X2,Y2,2)
      CALL PLOT(X+DX,Y+DY,2)
      RETURN
      END

