
      SUBROUTINE VARLAB(X,Y,DY,CH,IVAR)
C
      IF(IVAR.EQ.1) THEN
        CALL PLCHAR(X-3.5*CH,Y       ,1.4*CH,'C' ,0.0,1)
        CALL PLCHAR(X-2.3*CH,Y-0.4*CH,1.1*CH,'p' ,0.0,1)
      ELSE IF(IVAR.EQ.2) THEN
        CALL PLCHAR(X-3.5*CH,Y       ,1.4*CH,'H' ,0.0,1)
        CALL PLCHAR(X-2.3*CH,Y-0.5*CH,1.1*CH,'k' ,0.0,1)
      ELSE IF(IVAR.EQ.3) THEN
        CALL PLMATH(X-4.5*CH,Y       ,1.3*CH,'r 2q',0.0,4)
        CALL PLCHAR(X-4.5*CH,Y       ,1.3*CH,' U  ',0.0,4)
        CALL PLCHAR(X-2.4*CH,Y-0.4*CH,0.6*CH,  'e' ,0.0,4)
        Y1 = Y - DY
        CALL PLMATH(X-4.5*CH,Y1-0.5*CH,1.1*CH,'#   ',0.0,4)
        CALL PLCHAR(X-4.5*CH,Y1-0.5*CH,1.1*CH,' 100',0.0,4)
      ELSE IF(IVAR.EQ.4) THEN
        CALL PLCHAR(X-3.5*CH,Y       ,1.1*CH,'ln',0.0,2)
        Y1 = Y - DY
        CALL PLCHAR(X-4.5*CH,Y1       ,1.3*CH,'A/A',0.0,3)
        CALL PLCHAR(X-0.8*CH,Y1-0.5*CH,0.8*CH,'0'  ,0.0,1)
      ENDIF
      RETURN
      END ! VARLAB



      SUBROUTINE PIDENT(X,Y,CH,IPOINT)
C
      DSQR = 2.0*CH
      DX = 0.0
      IF(IPOINT.GT.9) DX = CH
C
      CALL PLOT(X        ,Y     ,3)
      CALL PLOT(X+DSQR+DX,Y     ,2)
      CALL PLOT(X+DSQR+DX,Y-DSQR,2)
      CALL PLOT(X        ,Y-DSQR,2)
      CALL PLOT(X        ,Y     ,2)
C
      XNUM = X + 0.7*(DSQR-CH)
      YNUM = Y - 0.5*(DSQR-CH) - CH
      RIP = FLOAT(IPOINT)
      CALL PLNUMB(XNUM,YNUM,CH,RIP,0.0,-1)
C
      RETURN
      END ! PIDENT


      SUBROUTINE WIDENT(X,Y,CH,W)
C
      AW = MAX( ABS(W) , 1.0 )
      XPLT = X - CH*(5.0 + AINT(LOG10(AW)+0.001) - SIGN(0.5,W) + 0.5)
      YPLT = Y - CH
      CALL PLNUMB(XPLT,YPLT,CH,W,0.0,3)
C
      XPLT = XPLT - 3.0*CH
      CALL PLCHAR(XPLT       ,YPLT,CH,'w',0.0,1)
      CALL PLCHAR(XPLT+1.5*CH,YPLT,CH,'=',0.0,1)
C
      RETURN
      END ! WIDENT


      SUBROUTINE BOX(X,Y,IWID)
      DIMENSION X(2), Y(2)
C
      CALL NEWPEN(IWID)
      CALL PLOT(X(1),Y(1),3)
      CALL PLOT(X(2),Y(1),2)
      CALL PLOT(X(2),Y(2),2)
      CALL PLOT(X(1),Y(2),2)
      CALL PLOT(X(1),Y(1),2)
      RETURN
      END


      SUBROUTINE XAX1(XORG,YORG,XLEN)
      DATA YTICK / 0.003 /
C
      YT = XLEN*YTICK
C
      CALL PLOT(XORG     ,YORG,3)
      CALL PLOT(XORG+XLEN,YORG,2)
C
      DO 5 ITICK=0, 10
        XTICK = XLEN * FLOAT(ITICK)/10.0
        CALL PLOT(XORG+XTICK,YORG-YT,3)
        CALL PLOT(XORG+XTICK,YORG+YT,2)
 5    CONTINUE
C
      DO 8 ITICK=0, 2
        XTICK = XLEN * FLOAT(ITICK)/2.0
        CALL PLOT(XORG+XTICK,YORG-1.5*YT,3)
        CALL PLOT(XORG+XTICK,YORG+1.5*YT,2)
 8    CONTINUE
C
      RETURN
      END ! XAX1


      SUBROUTINE XAXLAB(XORG,YORG,SF,CH,IXPLT)
      CHARACTER*2 CHLAB(3)
      DATA CHLAB / 'X ', 'XC', 'S ' /
C
      X  = XORG+0.85*SF - 1.0*CH
      Y  = YORG         - 1.8*CH
C
      CALL PLCHAR(X,Y,CH,CHLAB(IXPLT),0.0,2)
C
      RETURN
      END ! XAXLAB


      SUBROUTINE YDASH(X1,X2,Y)
C
      CALL NEWPEN(1)
      DXT = 0.08*(X2-X1)/50.
      DO 30 NT=1, 51
        XT = X1 + (X2-X1)*FLOAT(NT-1)/50.
        CALL PLOT(XT-DXT,Y,3)
        CALL PLOT(XT+DXT,Y,2)
   30 CONTINUE
C
      RETURN
      END ! YDASH



      SUBROUTINE MODIFY(IX,IBEG,IEND,NSIDE,X,Y,
     &                  XLIMV,YLIMV, XOFFV,YOFFV,XSFV,YSFV)
      DIMENSION IBEG(NSIDE), IEND(NSIDE)
      DIMENSION X(IX,NSIDE), Y(IX,NSIDE)
      DIMENSION XLIMV(2),YLIMV(2)
      DIMENSION XOFFV(NSIDE),YOFFV(NSIDE),XSFV(NSIDE),YSFV(NSIDE)
C
      PARAMETER (NUX=100)
      DIMENSION XU(NUX), YU(NUX), YUD(NUX)
C
      LOGICAL OUTSID, LABORT
      CHARACTER*1 CHKEY
C
      DATA SH /0.010/
C
C---- zero out coordinate and input arrays
      DO 5 I=1, NUX
        XU(I) = 0.
        YU(I) = 0.
        YUD(I) = 0.
    5 CONTINUE
C
      CALL GETCOLOR(ICOL0)
C
      XREL = XLIMV(2)
      YREL = YLIMV(1) * 10.5/8.0
      CALL PABORT(XREL,YREL)
C
      WRITE(*,*)
      WRITE(*,*) 'Input new values'
      WRITE(*,*) 'Terminate last entry with 3 spaces...'
      WRITE(*,*)
C
      CALL NEWCOLORNAME('red')
      DO 10 NU=1, NUX
C------ fetch x-y point coordinates from user
    9   CALL GETCURSORXY(XU(NU),YU(NU),CHKEY)
        IF(LABORT(XU(NU),YU(NU))) THEN
          CALL NEWCOLOR(ICOL0)
          RETURN
        ENDIF
C
C------ if point falls outside window limits, terminate further input
        OUTSID = XU(NU) .LT. XLIMV(1)
     &      .OR. XU(NU) .GT. XLIMV(2)
     &      .OR. YU(NU) .LT. YLIMV(1)
     &      .OR. YU(NU) .GT. YLIMV(2)
        IF(OUTSID) GO TO 11
C
C------ plot small cross at input point
        CALL PLSYMB(XU(NU),YU(NU),SH,3,0.0,0)
C
        IF(NU.LT.3) GO TO 10
C------- test for last input point (3 identical s-values)
         IF(XU(NU).EQ.XU(NU-1) .AND. XU(NU).EQ.XU(NU-2)) GO TO 12
   10 CONTINUE
C
   11 NU = NU-1
C
   12 XUFRST = XU(1)
      YUFRST = YU(1)
C
C---- sort points in s and strip out identical s pairs
      CALL SORT(NUX,NU,1,XU,YU)
      CALL REMD(NUX,NU,1,XU,YU)
      CALL REMD(NUX,NU,1,XU,YU)
C
      IF(NU.LT.2) THEN
       WRITE(*,*)
       WRITE(*,*) '***  Need at least 2 points    ***'
       WRITE(*,*) '***     NO CHANGES MADE        ***'
       WRITE(*,*)
       CALL NEWCOLOR(ICOL0)
       RETURN
      ENDIF
C
C---- spline variable as a function of s
      CALL SPLINE(YU,YUD,XU,NU)
C
C---- First input point plot coordinates
      XM1 = XUFRST
      YM1 = YUFRST
C
      ISMOD = 1
C
      IF(NSIDE.GT.1) THEN
C
C----- go over all surface points
       DSMIN = 1.0E9
       DO 20 IS=1, NSIDE
         DO 202 I=IBEG(IS), IEND(IS)
C
C--------- current specified-array plot coordinates
           XM = (X(I,IS)-XOFFV(IS))*XSFV(IS)
           YM = (Y(I,IS)-YOFFV(IS))*YSFV(IS)
C
C--------- find side which has minimum plot distance^2 to first spec. point
           DSQ = (XM-XM1)**2 + (YM-YM1)**2
           IF(DSQ .LT. DSMIN) THEN
             DSMIN = DSQ
             ISMOD = IS
           ENDIF
 202     CONTINUE
 20    CONTINUE
C
      ENDIF
C
C---- set side actually being modified
      IS = ISMOD
C
      CALL NEWCOLORNAME('red')
      CALL PLOT(XU(1),YU(1),3)
C
C---- go over all points on modified side
      DO 30 I=IBEG(IS), IEND(IS)
        XI = (X(I,IS)-XOFFV(IS))*XSFV(IS)
        YI = (Y(I,IS)-YOFFV(IS))*YSFV(IS)
        IF(XI .LT. XU(1)) THEN
C------- current point is outside modified interval...try next point
         CALL PLOT(XI,YI,3)
        ELSE IF(XI .LE. XU(NU)) THEN
C------- stuff new point into Vspec array and plot it
         YI = SEVAL(XI,YU,YUD,XU,NU)
         Y(I,IS) = YI/YSFV(IS) + YOFFV(IS)
         CALL PLOT(XI,YI,2)
        ELSE
C------- went past modified interval...finish up
         GO TO 31
        ENDIF
   30 CONTINUE
C
 31   CALL PLOT(XU(NU),YU(NU),2)
C
      CALL PLFLUSH
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! MODIFY


