
      SUBROUTINE MKHESS
C----------------------------------------------------------
C     Reads/initializes current Hessian.
C----------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL LHESOK
C
C---- get current Hessian from hessian.xxx file
      IF(.NOT.LXQLQ) CALL QLQGET
C
C---- set current history point index, and previous-waypoint history index
      IH  = NHIS
      IH1 = 1
      IF(NHIS.GT.1) IH1 = MAX(NHIS-NSTEP(NHIS-1),1)
C
C---- check if old Hessian is OK
      LHESOK = LXQLQ                   .AND.
     &         IH1.GT.0                .AND.
     &         IH1.LT.IH               .AND.
     &         NPARH(IH1).EQ.NPARH(IH) .AND.
     &         NHESOP.EQ.NHES          .AND.
     &         (IFTHOP.EQ.IFTYPE .OR. IFTHOP.EQ.999)
C
C---- initialize Hessian if necessary
      IF(.NOT. LHESOK) THEN
C
        IF(IH.GT.1) THEN
C
          IF(.NOT.LXQLQ)
     &       WRITE(*,*) 'No previous Hessian available.'
          IF(IH1.LE.0) 
     &       WRITE(*,*)
     &       'Previous optimization history point not available.'
          IF(NPARH(IH1).NE.NPARH(IH) .OR.
     &       NHESOP    .NE.NHES          )
     &       WRITE(*,*)'Number of active parameters has changed.'
          IF(IFTHOP.NE.IFTYPE .AND. IFTHOP.NE.999)
     &       WRITE(*,*) 'Objective function type has changed.'
C
        ENDIF
C
        CALL QLQINI
C
      ENDIF
C
      RETURN
      END ! MKHESS



      SUBROUTINE QLQWRT
C----------------------------------------------------------
C     Writes eigenvalues and eigenvector matrix of Hessian.
C----------------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      IF(.NOT.LXQLQ) THEN
        WRITE(*,*) 'Hessian is not available!'
        RETURN
      ENDIF
C
C
      LU = 9
C
      FNAME = 'hessian.' // ARGP1
      IBLANK = INDEX(FNAME,' ')
C
      OPEN(LU,FILE=FNAME,STATUS='UNKNOWN',FORM='UNFORMATTED')
      REWIND LU
C
      WRITE(LU) NPAR, IFTYPE, IHISOP
      DO 2 J=1, NPAR
        WRITE(LU) EGVAL(J), (EGVEC(K,J), K=1, NPAR)
 2    CONTINUE
C
      CLOSE(LU)
C
      WRITE(*,2060) FNAME(1:IBLANK-1)
 2060 FORMAT(/1X,'Hessian written to file ',A)
      RETURN
C
      END ! QLQWRT



      SUBROUTINE QLQGET
C----------------------------------------------------------
C     Reads eigenvalues and eigenvector matrix of Hessian.
C----------------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      LU = 9
C
      FNAME = 'hessian.' // ARGP1
      IBLANK = INDEX(FNAME,' ')
C
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=7,FORM='UNFORMATTED')
C
C---- size of Hessian, opjective-function type, history point where defined
      READ(LU,ERR=8) NHESOP, IFTHOP, IHISOP
C
C---- read in each eigenvalue and corresponding eigenvector
      DO 2 J=1, NHESOP
        READ(LU,ERR=8) EGVAL(J), (EGVEC(K,J), K=1, NHESOP)
 2    CONTINUE
C
      CLOSE(LU)
C
      DO 4 K=1, NHESOP
        SEGVAL(K) = SQRT(EGVAL(K))
 4    CONTINUE
C
C---- set actual Hessian (HESSOP) from the QLQ decomposition just read in
      CALL HREST
C
C
      WRITE(*,2060) FNAME(1:IBLANK-1)
 2060 FORMAT(/1X,'Previous Hessian read in from file ',A)
C
C---- Hessian and its QLQ factorization exist, but have not been updated
      LXQLQ = .TRUE.
      LHESUP = .FALSE.
      RETURN
C
 7    WRITE(*,2070) FNAME(1:IBLANK-1)
 2070 FORMAT(/' File ',A,' not found.')
      LXQLQ = .FALSE.
      LHESUP = .FALSE.
      RETURN
C
 8    WRITE(*,2080) FNAME(1:IBLANK-1)
 2080 FORMAT(/' File ',A,' read error.')
      LXQLQ = .FALSE.
      LHESUP = .FALSE.
      RETURN
      END ! QLQGET



      SUBROUTINE QLQINI
C------------------------------------------------------
C     Initializes optimization Hessian to the identity.
C------------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      WRITE(*,*) 'Initializing objective-function Hessian ...'
C
C---- no particular objective function is implied
      IFTHOP = 999
C
C---- size of Hessian = current number of parameters
      NHESOP = NHES
C
      DO 2 J=1, NHESOP
        DO 21 K=1, NHESOP
          EGVEC(K,J) = 0.
          HESSOP(K,J) = 0.
 21     CONTINUE
C
C------ set unity diagonal eigenvector elements, unity eigenvalues
        EGVEC(J,J)  = 1.0
        HESSOP(J,J) = 1.0
        EGVAL(J)   = 1.0
        SEGVAL(J)  = SQRT(EGVAL(J))
 2    CONTINUE
C
C---- Hessian is taken to be initialized at last previous waypoint
      IHISOP = 1
      IF(NHIS.GT.1) IHISOP = MAX(NHIS-NSTEP(NHIS-1),1)
C
C---- QLQ factorization exists, but Hessian has not been updated
      LXQLQ = .TRUE.
      LHESUP = .FALSE.
C
      RETURN
      END ! QLQINI



      SUBROUTINE BFGS
C------------------------------------------------------
C     Performs inverse-BFGS update on current Hessian.
C     Assumes PAR, FC_PAR, GSCPAR arrays for current 
C     history point have been calculated.
C------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION DG(NHESX), DX(NHESX), AX(NHESX),
     &          HESNEW(NHESX,NHESX),VALNEW(NHESX),
     &          VECNEW(NHESX,NHESX)
      LOGICAL LHESOK, LOUSY
      CHARACTER*1 ANS, ADEF
C
 1000 FORMAT(A1)
C
      IF(.NOT.LXQLQ) THEN
       WRITE(*,*) '? BFGS: Internal error.  Hessian not defined.'
       RETURN
      ENDIF
C
C---- history index of current point IH, and previous waypoint IH1
      IH  = NHIS
      IH1 = 1
      IF(NHIS.GT.1) IH1 = MAX(NHIS-NSTEP(NHIS-1),1)
C
      LHESOK = IH1.GT.0                .AND.
     &         IH1.LT.IH               .AND.
     &         NPARH(IH1).EQ.NPARH(IH) .AND.
     &         NHESOP.EQ.NHES          .AND.
     &         (IFTHOP.EQ.IFTYPE .OR. IFTHOP.EQ.999)
C
      IF(.NOT.LHESOK) THEN
C----- cannot update Hessian for whatever reason
       LHESUP = .FALSE.
       RETURN
      ENDIF
C
      WRITE(*,*) 'Calculating Hessian update ...'
C
C---- dg, dX  vectors
      DO 3 K=1, NHESOP
ccc     DG(K) = (FU_PAR(K,IH) - FU_PAR(K,IH1)) / GSCPAR(K)
        DG(K) = (FC_PAR(K,IH) - FC_PAR(K,IH1)) / GSCPAR(K)
        DX(K) = (   PAR(K,IH) -    PAR(K,IH1)) * GSCPAR(K)
 3    CONTINUE
C
C---- A dX  vector
      DO 4 K=1, NHESOP
        SUM = 0.
        DO 42 J=1, NHESOP
          SUM = SUM + HESSOP(K,J)*DX(J)
 42     CONTINUE
        AX(K) = SUM
 4    CONTINUE
C
C---- dX A dX , dg.dX, and magnitude scalars
      XAX = 0.
      GX  = 0.
      XX  = 0.
      GG  = 0.
      DO 6 K=1, NHESOP
        XAX = XAX + DX(K)*AX(K)
        GX  = GX  + DX(K)*DG(K)
        XX  = XX  + DX(K)*DX(K)
        GG  = GG  + DG(K)*DG(K)
 6    CONTINUE
C
      WRITE(*,2000) IH1, IH, GX, SQRT(XX), XAX, SQRT(GG)
 2000 FORMAT(/1X,'Previous, Current  history points:', 2I4,
     &      //1X,'  dg . dx =',E13.4,'       |dx| =',E13.4,
     &       /1X,'  dx A dx =',E13.4,'       |dg| =',E13.4 )
C
      IF(ABS(GX) .LT. 1.0E-9 .OR. ABS(XAX) .LT. 1.0E-9) THEN
       WRITE(*,*) 'Improper line descent detected. Hessian not updated.'
       LHESUP = .FALSE.
       RETURN
      ENDIF
C
      LOUSY = GX .LT. 0.0  .OR.  XAX .LT. 0.0
C
      IF(LOUSY) THEN
       WRITE(*,*) 'Poor line descent detected.'
       WRITE(*,*) 'Hessian update not recommended.'
      ENDIF
C
C---- update Hessian, set first guess for QLQ eigenvectors and eigenvalues
      DO 10 K=1, NHESOP
        DO 104 J=1, NHESOP
          DHES = DG(K)*DG(J) / GX
     &         - AX(K)*AX(J) / XAX
          HESNEW(K,J) = HESSOP(K,J) + DHES
          VECNEW(K,J) = EGVEC(K,J)
 104    CONTINUE
        VALNEW(K) = EGVAL(K)
 10   CONTINUE
C
C---- perform QLQ factorization
      CALL JACOBI(HESNEW,NHESOP,NHESX,VALNEW,VECNEW,NROT,.TRUE.)
C
C---- set max,min eigenvalues, and negative,zero eigenvalue count.
      EGLOW =     VALNEW(1)
      EGMIN = ABS(VALNEW(1))
      EGMAX = ABS(VALNEW(1))
      NNEG = 0
      NZER = 0
      DO 20 K=1, NHESOP
        EGLOW = MIN( EGLOW , VALNEW(K) )
C
        AVAL = ABS(VALNEW(K))
        IF(AVAL .LE. EGMIN) THEN
          JMIN = K
          EGMIN = AVAL
        ENDIF
        IF(AVAL .GE. EGMAX) THEN
          JMAX = K
          EGMAX = AVAL
        ENDIF
C
        IF(    VALNEW(K)  .LT. -1.0E-8) NNEG = NNEG + 1
        IF(ABS(VALNEW(K)) .LE.  1.0E-8) NZER = NZER + 1
 20   CONTINUE
C
      WRITE(*,*)
      WRITE(*,*) '  Eigenvalues   |   Eigenvectors for...'
      WRITE(*,*) '       L        |    min|L|    max|L|'
C                    1.2345E-10   |    0.9123   -0.1234
      WRITE(*,3005) (VALNEW(K),VECNEW(K,JMIN),VECNEW(K,JMAX),DPNAME(K),
     &               K=1,NHESOP)
 3005 FORMAT(1X,E13.4,'   |', 2F10.4, 3X, A)
C
C---- condition number
      COND = 0.0
      IF(EGMIN .NE. 0.0) COND = EGMAX/EGMIN
C
C---- individually shift any eigenvalue below threshold
      EGLIM = ABS(EGMAX/CONDMX)
      DO 30 K=1, NHESOP
        VALNEW(K) = MAX( ABS(VALNEW(K)) , EGLIM )
 30   CONTINUE
C
C---- new condition number (check)
      EGMIN2 = ABS(VALNEW(1))
      EGMAX2 = ABS(VALNEW(1))
      DO 40 K=1, NHESOP
        EGMIN2 = MIN( EGMIN2 , ABS(VALNEW(K)) )
        EGMAX2 = MAX( EGMAX2 , ABS(VALNEW(K)) )
 40   CONTINUE
      COND2 = EGMAX2/EGMIN2
C
      WRITE(*,3010) NNEG, EGMAX, NZER, EGMIN, COND, EGMIN2, COND2
 3010 FORMAT(
     & /1X,' # negative =',I3,'   max |L| =',E12.4,
     & /1X,' # zero     =',I3,'   min |L| =',E12.4,'          C =',F9.1,
     & /1X,'             ',3X,'   new min =',E12.4,'  =>  new C =',F9.1)
C
      ADEF = 'U'
      IF(LOUSY) ADEF = 'C'
C
 50   WRITE(*,5000) ADEF
 5000 FORMAT(/1X,'  U pdate hessian'
     &       /1X,'  I nitialize hessian to identity'
     &       /1X,'  C ancel update'
     &      //1X,'Select operation: ', A1,'  ' ,$)
      READ (*,1000) ANS
C
      IF( ANS.EQ.'U' .OR. ANS.EQ.'u' .OR.
     &   (ANS.EQ.' ' .AND. .NOT.LOUSY)    ) THEN
C
C------ set new (and possibly modified) QLQ factors
        DO 60 K=1, NHESOP
          DO 604 J=1, NHESOP
            EGVEC(K,J) = VECNEW(K,J)
 604      CONTINUE
          EGVAL(K) = VALNEW(K)
          SEGVAL(K) = SQRT(EGVAL(K))
 60     CONTINUE

C------ set new Hessian (HESSOP) from updated QLQ factors
        CALL HREST
C
C------ set objective function-type for the current Hessian
        IFTHOP = IFTYPE
C
C------ set defining history index for the current Hessian
        IHISOP = NHIS
C
        LXQLQ = .TRUE.
        LHESUP = .TRUE.
C
      ELSE IF(ANS.EQ.'I' .OR. ANS.EQ.'i') THEN
C
        CALL QLQINI
        LHESUP = .TRUE.
C
      ELSE IF( ANS.EQ.'C' .OR. ANS.EQ.'c' .OR.
     &        (ANS.EQ.' ' .AND. LOUSY)         ) THEN
C
        RETURN
C
      ELSE
C
        GO TO 50
C
      ENDIF
C
      RETURN
      END ! BFGS


      SUBROUTINE HREST
C------------------------------------------
C     Restores Hessian from QLQ factors.
C------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      DO 10 J=1, NHESOP
        DO 102 K=J, NHESOP
          SUM = 0.
          DO 1024 L=1, NHESOP
            SUM = SUM + EGVEC(K,L)*EGVAL(L)*EGVEC(J,L)
 1024     CONTINUE
          HESSOP(K,J) = SUM
          HESSOP(J,K) = SUM
 102    CONTINUE
 10   CONTINUE
C
      RETURN
      END ! HREST



      SUBROUTINE JACOBI(A,N,NDIM,D,V,NROT,LINIT)
      DIMENSION A(NDIM,NDIM),D(NDIM),V(NDIM,NDIM)
C------------------------------------------------
C     Computes eigenvalues and eigenvectors
C     of a real symmetric matrix.
C
C     Adapted from "Numerical Recipes".
C
C   Input:
C     A      real symmetric matrix (upper part is destroyed)
C     N      size of A and V
C     NDIM   physical size of A and V
C     LINIT  T if the eigenvectors are to be initialized
C
C   Output:
C     D(.)  eigenvalues
C     V(i.) normalized eigenvectors
C     NROT  number of Jacobi rotations performed
C
C------------------------------------------------
      PARAMETER (NMAX=150)
      DIMENSION B(NMAX), Z(NMAX)
      LOGICAL LINIT
C
      IF(N.GT.NMAX) STOP 'JACOBI: Array overflow.'
C
      IF(LINIT) THEN
C
C----- initialize eigenvectors and eigenvalues
       DO 1 IP=1, N
         DO 14 IQ=1, N
           V(IP,IQ) = 0.
 14      CONTINUE
         V(IP,IP) = 1.0
         D(IP)    = A(IP,IP)
         B(IP)    = A(IP,IP)
 1     CONTINUE
C
      ENDIF
C
      DO 2 IP=1, N
        Z(IP) = 0.
 2    CONTINUE
C
C---- perform Jacobi sweeps ...
      NROT = 0
      DO 5 ISWEEP=1, 50
C
C------ sum diagonal and off-diagonal elements
        DSUM = 0.
        ESUM = 0.
        DO 51 IP=1, N
          DSUM = DSUM + ABS(A(IP,IP))
          DO 511 IQ=IP+1, N
            ESUM = ESUM + ABS(A(IP,IQ))
 511      CONTINUE
 51     CONTINUE
C
ccc        write(*,*) ISWEEP, NROT, ESUM, DSUM
C
C------ convergence test (relies on machine zero)
        IF(ESUM .EQ. 0.0) RETURN
C
        IF(ISWEEP .LT. 4) THEN
          TRESH = 0.2*ESUM/FLOAT(N**2)
        ELSE
          TRESH = 0.
        ENDIF
C
        DO 52 IP=1, N-1
          DO 521 IQ=IP+1, N
C
            G = 100.0*ABS(A(IP,IQ))
C
C---------- perform rotation only if off-diagonal element is bigger
C           than eigenvalue by factor of (100 x machine zero)
            IF((ISWEEP .GT. 4) .AND. 
     &         (ABS(D(IP))+G .EQ. ABS(D(IP))) .AND.
     &         (ABS(D(IQ))+G .EQ. ABS(D(IQ)))       ) THEN
              A(IP,IQ) = 0.
            ELSE IF(ABS(A(IP,IQ)) .GT. TRESH) THEN
              H = D(IQ) - D(IP)
              IF(ABS(H)+G .EQ. ABS(H)) THEN
                T = A(IP,IQ)/H
              ELSE
                THETA = 0.5*H/A(IP,IQ)
                T = 1.0 / (ABS(THETA) + SQRT(1.0 + THETA**2))
                IF(THETA .LT. 0.0) T = -T
              ENDIF
C
              C = 1.0 / SQRT(1.0 + T**2)
              S = T*C
              TAU = S/(1.0 + C)
              H = T*A(IP,IQ)
              Z(IP) = Z(IP) - H
              Z(IQ) = Z(IQ) + H
              D(IP) = D(IP) - H
              D(IQ) = D(IQ) + H
              A(IP,IQ) = 0.
C
              DO 5211 J=1, IP-1
                G = A(J,IP)
                H = A(J,IQ)
                A(J,IP) = G - S*(H + G*TAU)
                A(J,IQ) = H + S*(G - H*TAU)
 5211         CONTINUE
C
              DO 5212 J=IP+1, IQ-1
                G = A(IP,J)
                H = A(J,IQ)
                A(IP,J) = G - S*(H + G*TAU)
                A(J,IQ) = H + S*(G - H*TAU)
 5212         CONTINUE
C
              DO 5213 J=IQ+1, N
                G = A(IP,J)
                H = A(IQ,J)
                A(IP,J) = G - S*(H + G*TAU)
                A(IQ,J) = H + S*(G - H*TAU)
 5213         CONTINUE
C
              DO 5214 J=1, N
                G = V(J,IP)
                H = V(J,IQ)
                V(J,IP) = G - S*(H + G*TAU)
                V(J,IQ) = H + S*(G - H*TAU)
 5214         CONTINUE
C
              NROT = NROT + 1
            ENDIF
C
 521      CONTINUE
 52     CONTINUE
C
        DO 54 IP=1, N
          B(IP) = B(IP) + Z(IP)
          D(IP) = B(IP)
          Z(IP) = 0.
 54     CONTINUE
C
 5    CONTINUE
      WRITE(*,*) 'JACOBI: Convergence failed. Res =',ESUM/MAX(DSUM,0.01)
      RETURN
      END


      SUBROUTINE EIGSRT(D,V,N,NDIM)
      DIMENSION D(NDIM), V(NDIM,NDIM)
C--------------------------------------------
C     Sorts eigenvalues D(.) into descending
C     order and rearranges the eigenvectors
C     V(i.) accordingly.
C--------------------------------------------
C
      DO 1 I=1, N-1
        K = I
        P = D(I)
        DO 11 J=I+1, N
          IF(D(J).GE.P) THEN
            K = J
            P = D(J)
          ENDIF
 11     CONTINUE
        IF(K.NE.I) THEN
          D(K) = D(I)
          D(I) = P
          DO 12 J=1, N
            P = V(J,I)
            V(J,I) = V(J,K)
            V(J,K) = P
 12       CONTINUE
        ENDIF
 1    CONTINUE
      RETURN
      END
