
      SUBROUTINE SHOWGT
C------------------------------------------------
C     Displays operating-point weighting factors
C     used to sum objective function.
C------------------------------------------------
      INCLUDE 'LINDOP.INC'
C
      CALL FUCALC(IFTYPE,FUNC)
C
      WPSUM = 0.
      DO 5 IP=1, NPOINT
        WPSUM = WPSUM + ABS(WP(IP))
 5    CONTINUE
C
      WRITE(*,2000)
      DO 10 IP=1, NPOINT
        WRITE(*,2010) 
     &   IP,WP(IP),WPSUM*FUN_WP(IP),ALFA(IP)/DTOR,MACH(IP),CL(IP),CD(IP)
 10   CONTINUE
C
 2000 FORMAT(/1X,
     & ' point  weight  |    Fpoint    alpha    Mach      CL        CD')
CCC        3    1.0000  |   0.012312   8.234   0.7354   1.1234   0.01234
 2010 FORMAT(1X,
     &    I4, F10.4, '  |', F11.6,     F8.3,   F9.4,    F9.4,    F10.5)
C
      RETURN
      END


      SUBROUTINE SELWGT
C----------------------------------------------------
C     Allows user to change operating-point weights.
C----------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION ANUM(10)
      LOGICAL ERROR
C
 1000 FORMAT(A80)
C
      WRITE(*,*)
 5    WRITE(*,*) 'Enter  point, weight (<cr> if done) ...'
      DO 10 IPASS=1, 12345
        READ (*,1000) LINE
C
        CALL GETFLT(LINE,ANUM,N,ERROR)
        IF(ERROR) GO TO 5
        IF(N.EQ.0) RETURN
C
        IP = INT(ANUM(1))
        IF(IP.EQ.0) THEN
          DO 105 JP=1, NPOINT
            IF(WP(JP).NE.ANUM(2)) THEN
              LXHES = .FALSE.
              LXSYS = .FALSE.
              LXQLQ = .FALSE.
              LHESUP = .FALSE.
              LPRSET = .TRUE.
              LFCSET = .FALSE.
            ENDIF
            WP(JP) = ANUM(2)
 105      CONTINUE
        ELSE IF(IP.LT.0 .OR. IP.GT.NPOINT) THEN
          WRITE(*,*) 'Point index out of range !'
        ELSE
          IF(WP(IP).NE.ANUM(2)) THEN
            LXHES = .FALSE.
            LXSYS = .FALSE.
            LXQLQ = .FALSE.
            LHESUP = .FALSE.
            LPRSET = .TRUE.
            LFCSET = .FALSE.
          ENDIF
          WP(IP) = ANUM(2)
        ENDIF
 10   CONTINUE
C
      END ! SELWGT



      SUBROUTINE SHOPAR
C------------------------------------------------------
C     Displays status of available design parameters.
C------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*160 LLINE
C
      WRITE(*,1000)
 1000 FORMAT(
     &   1X,'__________________________________________________________'
     & //1X,'Current design-parameter changes (* = active parameter)...'
     & //1X,'point      dAlfa          dMach        d(ln Re)')
C              1      -1.2345 *      -0.0123 *       1.0000 *
C
 1020 FORMAT(F13.4)
 1050 FORMAT(A)

      DO 10 IP=1, NPOINT
C
        DO 105 K=1, 132
          LLINE(K:K) = ' '
 105    CONTINUE
C
        WRITE(LLINE(1:4),1060) IP
 1060   FORMAT(1X,I3)
C
        IF(KALFA(IP).NE.0) THEN
          WRITE(LLINE(5:17),1020) DALFA(IP)/DTOR
          IF(LALFA(IP)) LLINE(18:19) = ' *'
        ENDIF
C
        IF(KMACH(IP).NE.0) THEN
          WRITE(LLINE(20:32),1020) DMACH(IP)
          IF(LMACH(IP)) LLINE(33:34) = ' *'
        ENDIF
C
        IF(KREYN(IP).NE.0) THEN
          WRITE(LLINE(35:47),1020) DLNRE(IP)
          IF(LREYN(IP)) LLINE(48:49) = ' *'
        ENDIF
C
        WRITE(*,1050) LLINE(1:49)
 10   CONTINUE
C
C
      DO 15 K=1, 160
        LLINE(K:K) = ' '
 15   CONTINUE
C
C
 1080 FORMAT(1X,I3,3X,F10.6)
 1082 FORMAT(         F10.6)
 1090 FORMAT(1X,A8,2X,I3,3X,F14.6)
C
C
      IF(NMODMX.GT.0) THEN
C
        IF(LNKMOD) THEN
         IP1 = IPGSEN
         IP2 = IPGSEN
         WRITE(*,2010)
        ELSE
         IP1 = 1
         IP2 = NPOINT
         WRITE(*,2020)
        ENDIF
C
 2010   FORMAT(/1X,
     &   '  k       dModk ')
 2020   FORMAT(/1X,
     &   '  k     dModk(p1)   dModk(p2)      ... ')
C           1    -1.234567 *  1.234567 *  1.234567 * -1.234567 * -1.234567
        DO 20 K=1, NMODMX
          WRITE(LLINE(1:7),1080) K
          DO 201 IP=IP1, IP2
            K1 = 8 + (IP-IP1)*12
            K2 = K1 + 10
            K3 = K2 + 2
            WRITE(LLINE(K1:K2-1),1082) DMOD(K,IP)
            LLINE(K2:K3-1) = '  '
            IF(LMOD(K,IP)) LLINE(K2:K3-1) = ' *'
 201      CONTINUE
          WRITE(*,1050) LLINE(1:K3-1)
 20     CONTINUE
C
      ENDIF
C
C
      IF(NPOSMX.GT.0) THEN
C
        IF(LNKPOS) THEN
         IP1 = IPGSEN
         IP2 = IPGSEN
         WRITE(*,3010)
        ELSE
         IP1 = 1
         IP2 = NPOINT
         WRITE(*,3020)
        ENDIF
C
 3010   FORMAT(/1X,
     &   '  k       dPosk ')
 3020   FORMAT(/1X,
     &   '  k     dPosk(p1)   dPosk(p2)      ... ')
C           1    -1.234567 *  1.234567 *  1.234567 * -1.234567 * -1.234567
        DO 30 K=1, NPOSMX
          WRITE(LLINE(1:7),1080) K
          DO 301 IP=IP1, IP2
            K1 = 8 + (IP-IP1)*12
            K2 = K1 + 10
            K3 = K2 + 2
            WRITE(LLINE(K1:K2-1),1082) DPOS(K,IP)
            LLINE(K2:K3-1) = '  '
            IF(LPOS(K,IP)) LLINE(K2:K3-1) = ' *'
 301      CONTINUE
          WRITE(*,1050) LLINE(1:K3-1)
 30     CONTINUE
C
      ENDIF
C
      IF(NUPAR.GT.0) THEN
        WRITE(*,5000)
 5000   FORMAT(/1X,
     &   ' Xuser      k          dXuserk')
C         SWEEPxxx    1        -1.234523 *
        DO 50 K=1, NUPAR
          WRITE(LLINE(1:31),1090) UPNAME(K), K, DUPAR(K)
          LLINE(32:33) = ' '
          IF(LUPAR(K)) LLINE(32:33) = ' *'
          WRITE(*,1050) LLINE(1:33)
 50     CONTINUE
C
      ENDIF
C
      RETURN
      END ! SHOPAR



      SUBROUTINE SELPAR
C------------------------------------------------------
C     Allows user to select active parameters.
C------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL DONE, ERROR, CHANGE, BLANK
      CHARACTER*80 LINEN
C
      PARAMETER (NINPX=40,NKEYX=8)
      DIMENSION KEYARR(NKEYX), KINP(NINPX)
C
      LOGICAL LALFA1,LMACH1,LREYN1,LMOD1,LPOS1,LUPAR1
      DIMENSION LALFA1(NPX),LMACH1(NPX),LREYN1(NPX),
     &          LMOD1(NMODX,NPX),LPOS1(NPOSX,NPX),LUPAR1(NUPX)
C
 1000 FORMAT(A80)
C
C---- save current active-parameter flags
      DO 1 IP=1, NPOINT
        DO 11 K=1, NMOD(IP)
          LMOD1(K,IP) = LMOD(K,IP)
 11     CONTINUE
        DO 12 K=1, NPOS(IP)
          LPOS1(K,IP) = LPOS(K,IP)
 12     CONTINUE
        LALFA1(IP) = LALFA(IP)
        LMACH1(IP) = LMACH(IP)
        LREYN1(IP) = LREYN(IP)
 1    CONTINUE
      DO 2 K=1, NUPAR
        LUPAR1(K) = LUPAR(K)
 2    CONTINUE
C
      KALMAX = KALFA(1)
      KMAMAX = KMACH(1)
      KREMAX = KREYN(1)
      DO 8 IP=1, NPOINT
        KALMAX = MAX(KALMAX,KALFA(IP))
        KMAMAX = MAX(KMAMAX,KMACH(IP))
        KREMAX = MAX(KREMAX,KREYN(IP))
 8    CONTINUE
C
C---- display menu item for every available parameter class
 10   WRITE(*,*) '___________________________________'
      WRITE(*,*)
      IF(KALMAX.GT.0) WRITE(*,*) '    A lpha'
      IF(KMAMAX.GT.0) WRITE(*,*) '    M ach'
      IF(KREMAX.GT.0) WRITE(*,*) '    R eynolds #'
      IF(NMODMX.GT.0) THEN
       IF(LNKMOD .OR. IPTARG.EQ.0) THEN
                      WRITE(*,*) '    G eometry mode for all points'
       ELSE
                   WRITE(*,1050) '    G eometry mode for point',IPTARG
       ENDIF
      ENDIF
      IF(NPOSMX.GT.0) THEN
       IF(LNKPOS .OR. IPTARG.EQ.0) THEN
                      WRITE(*,*) '    P osition mode for all points'
       ELSE
                   WRITE(*,1050) '    P osition mode for point',IPTARG
       ENDIF
      ENDIF
      IF(NUPAR .GT.0) WRITE(*,*) '    U ser parameter'
      WRITE(*,*)
C
 1050 FORMAT(1X,A,I3)
C
 15   WRITE(*,1100)
 1100 FORMAT(1X,'Specify  parameter(s), index(s)  to toggle:  ',$)
      READ(*,1000) LINE
C
C---- get keyword character locations
      KA = MAX( INDEX(LINE,'A') , INDEX(LINE,'a') )
      KM = MAX( INDEX(LINE,'M') , INDEX(LINE,'m') )
      KR = MAX( INDEX(LINE,'R') , INDEX(LINE,'r') )
      KG = MAX( INDEX(LINE,'G') , INDEX(LINE,'g') )
      KP = MAX( INDEX(LINE,'P') , INDEX(LINE,'p') )
      KU = MAX( INDEX(LINE,'U') , INDEX(LINE,'u') )
C
      KLIST =   INDEX(LINE,'?')
      BLANK = INDEX(LINE(1:1),' ') .EQ. 1
C
      KEYARR(1) = KA
      KEYARR(2) = KM
      KEYARR(3) = KR
      KEYARR(4) = KG
      KEYARR(5) = KP
      KEYARR(6) = KU
C
      KEYARR(7) = KLIST
      KEYARR(8) = 80
C
C---- total number of keywords to be examined (must be .LE. NKEYX !)
      NKEY = 8
C
C---- sort keyword locations
      DO 17 IPASS=1, NKEYX
        DONE = .TRUE.
        DO 171 LKEY=1, NKEY-1
          IF(KEYARR(LKEY).GT.KEYARR(LKEY+1)) THEN
            KTMP = KEYARR(LKEY)
            KEYARR(LKEY) = KEYARR(LKEY+1)
            KEYARR(LKEY+1) = KTMP
            DONE = .FALSE.
          ENDIF
 171    CONTINUE
        IF(DONE) GO TO 18
 17   CONTINUE
      WRITE(*,*) 'SELPAR: Sort failed'
 18   CONTINUE
C
C
C---- go over keywords
      DO 900 LKEY=1, NKEY-1
C
      KEY  = KEYARR(LKEY)
      KEYP = KEYARR(LKEY+1)
C
C---- skip if this keyword character was not input or it's a "?"
      IF(KEY.EQ.0 .OR. KEY.EQ.KLIST) GO TO 900
C
C---- read all integers between current and next keyword character
      KLEN = KEYP - KEY - 1
      DO 20 K=1, 80
        LINEN(K:K) = ' '
 20   CONTINUE
      LINEN(1:KLEN) = LINE(KEY+1:KEYP-1)
C
      CALL GETINT(LINEN,KINP,NINP,ERROR)
C
      IF(KEY.EQ.KA .OR. KEY.EQ.KM .OR. KEY.EQ.KR) THEN
       IF(NINP.EQ.0 .AND. NPOINT.EQ.1) THEN
C------ no point index was input for single-point case... just set it
        NINP = 1
        KINP(1) = NPOINT
       ENDIF
C
       IF(NINP.EQ.0) THEN
        WRITE(*,*) '*** Must specify point index!'
        GO TO 900
       ENDIF
C
       DO 32 L=1, NINP
         IP = KINP(L)
         IF(IP.LT.0 .OR. IP.GT.NPOINT) GO TO 32
C
         IP1 = IP
         IP2 = IP
         IF(IP.EQ.0) THEN
          IP1 = 1
          IP2 = NPOINT
         ENDIF
         DO 321 IP=IP1, IP2
          IF(KALFA(IP).GT.0 .AND. KEY.EQ.KA) LALFA(IP) = .NOT.LALFA(IP)
          IF(KMACH(IP).GT.0 .AND. KEY.EQ.KM) LMACH(IP) = .NOT.LMACH(IP)
          IF(KREYN(IP).GT.0 .AND. KEY.EQ.KR) LREYN(IP) = .NOT.LREYN(IP)
cc        IF(.NOT.LALFA(IP)) DALFA(IP) = 0.0
cc        IF(.NOT.LMACH(IP)) DMACH(IP) = 0.0
cc        IF(.NOT.LREYN(IP)) DLNRE(IP) = 0.0
 321     CONTINUE
 32    CONTINUE
C
      ENDIF
C
      IF(NMODMX.GT.0 .AND. KEY.EQ.KG) THEN
C
       IF(LNKMOD .OR. IPTARG.EQ.0) THEN
        IP1 = 1
        IP2 = NPOINT
       ELSE
        IP1 = IPTARG
        IP2 = IPTARG
       ENDIF
C
       IF(NINP.EQ.0 .AND. NMODMX.EQ.1) THEN
C------ no mode index was input for single-mode case... just set it
        NINP = 1
        KINP(1) = NMODMX
       ENDIF
C
       IF(NINP.EQ.0) THEN
        WRITE(*,*) '*** Must specify geometry mode index k !'
        GO TO 900
       ENDIF
C
       DO 42 I=1, NINP
         DO 421 IP=IP1, IP2
           K = KINP(I)
           IF(K.LT.0 .OR. K.GT.NMOD(IP)) GO TO 421
           K1 = K
           K2 = K
           IF(K.EQ.0) THEN
            K1 = 1
            K2 = NMOD(IP)
           ENDIF
           DO 4211 K=K1, K2
             LMOD(K,IP) = .NOT.LMOD(K,IP)
cc           IF(.NOT.LMOD(K,IP)) DMOD(K,IP) = 0.0
 4211      CONTINUE
 421     CONTINUE
 42    CONTINUE
C
      ENDIF
C
C
      IF(NPOSMX.GT.0 .AND. KEY.EQ.KP) THEN
C
       IF(LNKPOS .OR. IPTARG.EQ.0) THEN
        IP1 = 1
        IP2 = NPOINT
       ELSE
        IP1 = IPTARG
        IP2 = IPTARG
       ENDIF
C
       IF(NINP.EQ.0 .AND. NPOSMX.EQ.1) THEN
C------ no mode index was input for single-mode case... just set it
        NINP = 1
        KINP(1) = NPOSMX
       ENDIF
C
       IF(NINP.EQ.0) THEN
        WRITE(*,*) '*** Must specify position mode index k !'
        GO TO 900
       ENDIF
C
       DO 52 I=1, NINP
         DO 521 IP=IP1, IP2
           K = KINP(I)
           IF(K.LT.0 .OR. K.GT.NPOS(IP)) GO TO 521
           K1 = K
           K2 = K
           IF(K.EQ.0) THEN
            K1 = 1
            K2 = NPOS(IP)
           ENDIF
           DO 5211 K=K1, K2
             LPOS(K,IP) = .NOT.LPOS(K,IP)
cc           IF(.NOT.LPOS(K,IP)) DPOS(K,IP) = 0.0
 5211      CONTINUE
 521     CONTINUE
 52    CONTINUE
C
      ENDIF
C
C
      IF(NUPAR.GT.0 .AND. KEY.EQ.KU) THEN
C
       IF(NINP.EQ.0 .AND. NUPAR.EQ.1) THEN
C------ no user-parm. index was input for single-param. case... just set it
        NINP = 1
        KINP(1) = NUPAR
       ENDIF
C
       IF(NINP.EQ.0) THEN
        WRITE(*,*) '*** Must specify user-parameter index k !'
        GO TO 900
       ENDIF
C
       DO 62 I=1, NINP
         K = KINP(I)
         IF(K.LT.0 .OR. K.GT.NUPAR) GO TO 62
         K1 = K
         K2 = K
         IF(K.EQ.0) THEN
          K1 = 1
          K2 = NUPAR
         ENDIF
         DO 621 K=K1, K2
           LUPAR(K) = .NOT.LUPAR(K)
cc         IF(.NOT.LUPAR(K)) DUPAR(K) = 0.0
 621     CONTINUE
 62    CONTINUE
C
      ENDIF
C
 900  CONTINUE
C
      IF(KLIST .GT. 0) THEN
C----- "?" was input... display parameter status and toggle menu
       CALL SHOPAR
       GO TO 10
      ENDIF
C
C---- go get new input line
      IF(.NOT.BLANK) GO TO 15
C
C
C---- a blank line was input...  check for any changes
 90   CHANGE = .FALSE.
      DO 92 IP=1, NPOINT
        DO 924 K=1, NMOD(IP)
          CHANGE = CHANGE .OR. (LMOD1(K,IP).XOR.LMOD(K,IP))
 924    CONTINUE
        DO 926 K=1, NPOS(IP)
          CHANGE = CHANGE .OR. (LPOS1(K,IP).XOR.LPOS(K,IP))
 926    CONTINUE
        CHANGE = CHANGE .OR. (LALFA1(IP).XOR.LALFA(IP))
     &                  .OR. (LMACH1(IP).XOR.LMACH(IP))
     &                  .OR. (LREYN1(IP).XOR.LREYN(IP))
 92   CONTINUE
      DO 96 K=1, NUPAR
        CHANGE = CHANGE .OR. (LUPAR1(K).XOR.LUPAR(K))
 96   CONTINUE
C
      IF(CHANGE) THEN
C------ valid pointers, Hessian, etc. no longer exist
        LXPAR = .FALSE.
        LXHES = .FALSE.
        LXCON = .FALSE.
        LXQLQ = .FALSE.
        LXSYS = .FALSE.
        LHESUP = .FALSE.
        LPRSET = .TRUE.
        LFCSET = .FALSE.
      ENDIF
C
      RETURN
      END ! SELPAR



      SUBROUTINE SHOCON
C--------------------------------------------------
C     Displays status of available constraints.
C--------------------------------------------------
      INCLUDE 'LINDOP.INC'
      CHARACTER*1 CHRX
      DIMENSION THNEW(0:NTHX)
C
      ISMAX = 0
      DO 2 IP=1, NPOINT
        ISMAX = MAX(ISMAX,2*NBL(IP))
 2    CONTINUE
C
C
      IP = IPGSEN
C
      IF(ISTARG.EQ.0) THEN
        N1 = 1
        N2 = NBL(IP)
      ELSE
        N1 = (ISTARG+1)/2
        N2 = (ISTARG+1)/2
      ENDIF
C
      DO 10 N=N1, N2
C
      CVNEW = CVLE (N,IP)
      ALNEW = ANGLL(N,IP)
      ARNEW = ANGLR(N,IP)
      ABNEW = AREAB(N,IP)
      SGNEW = ASIGB(N,IP)
      EINEW = EI11B(N,IP)
      DO 102 ITH=0, NTHFIX(N)
        THNEW(ITH) = THIKB(ITH,N,IP)
 102  CONTINUE
C
      DO 104 K=1, NMOD(IP)
        CVNEW = CVNEW +CVLE_MOD(K,N,IP)*DMOD(K,IP)
        ALNEW = ALNEW + AGL_MOD(K,N,IP)*DMOD(K,IP)
        ARNEW = ARNEW + AGR_MOD(K,N,IP)*DMOD(K,IP)
        ABNEW = ABNEW + ARB_MOD(K,N,IP)*DMOD(K,IP)
        SGNEW = SGNEW + ASG_MOD(K,N,IP)*DMOD(K,IP)
        EINEW = EINEW + EI1_MOD(K,N,IP)*DMOD(K,IP)
        DO 1042 ITH=0, NTHFIX(N)
          THNEW(ITH) = THNEW(ITH) + THB_MOD(K,ITH,N,IP)*DMOD(K,IP)
 1042   CONTINUE
 104  CONTINUE
C
      WRITE(*,*)
     & '______________________________________________________________'

      IF(NPOINT .GT.1) WRITE(*,1000) IP
      IF(NBL(IP).GT.1) WRITE(*,1001) N
C
      WRITE(*,1003)
C
      IS1 = 2*N - 1
      IS2 = 2*N
C
      CHRX = ' '
      IF(LSLFIX(IS1)) CHRX = '*'
      WRITE(*,1005) ' L slope :',CHRX, XBLFIX(IS1), SBLFIX(IS1), IS1
C
      CHRX = ' '
      IF(LSLFIX(IS2)) CHRX = '*'
      WRITE(*,1005) ' L slope :',CHRX, XBLFIX(IS2), SBLFIX(IS2), IS2
C
      CHRX = ' '
      IF(LSRFIX(IS1)) CHRX = '*'
      WRITE(*,1005) ' R slope :',CHRX, XBRFIX(IS1), SBRFIX(IS1), IS1
C
      CHRX = ' '
      IF(LSRFIX(IS2)) CHRX = '*'
      WRITE(*,1005) ' R slope :',CHRX, XBRFIX(IS2), SBRFIX(IS2), IS2
C
C
      WRITE(*,*)
C
      CHRX = ' '
      IF(LALFIX(N)) CHRX = '*'
      WRITE(*,1010) ' L angle :',CHRX,ANGLL(N,IP),ALNEW,ALSPEC(N)
C
      CHRX = ' '
      IF(LARFIX(N)) CHRX = '*'
      WRITE(*,1010) ' R angle :',CHRX,ANGLR(N,IP),ARNEW,ARSPEC(N)
C
      CHRX = ' '
      IF(LCVFIX(N)) CHRX = '*'
      WRITE(*,1011) ' Curv LE :',CHRX,CVLE(N,IP),CVNEW,CVSPEC(N)
C
      ITH = 0
      CHRX = ' '
      IF(LTHFIX(ITH,N)) CHRX = '*'
      WRITE(*,1020) ' Thickmax:', CHRX,
     &  THIKB(ITH,N,IP),THNEW(ITH),THSPEC(ITH,N), XTHFIX(ITH,N)
C
      DO 108 ITH=1, NTHFIX(N)
        CHRX = ' '
        IF(LTHFIX(ITH,N)) CHRX = '*'
        WRITE(*,1021) ' Thik(', ITH, '):', CHRX,
     &    THIKB(ITH,N,IP),THNEW(ITH),THSPEC(ITH,N), XTHFIX(ITH,N)
 108  CONTINUE
C
      CHRX = ' '
      IF(LABFIX(N)) CHRX = '*'
      WRITE(*,1030) ' Area    :',CHRX,AREAB(N,IP),ABNEW,ABSPEC(N)
C
      CHRX = ' '
      IF(LSGFIX(N)) CHRX = '*'
      WRITE(*,1031) ' Strain  :',CHRX,ASIGB(N,IP),SGNEW,SGSPEC(N),
     &                           TBSKIN(N)
C
      CHRX = ' '
      IF(LEIFIX(N)) CHRX = '*'
      WRITE(*,1032) ' EIx100  :',CHRX,
     &       100.0*EI11B(N,IP),100.0*EINEW,
     &       100.0*EISPEC(N), XSTRF(N), XSTRB(N)
C
 10   CONTINUE
C
C
      IF(NHKFIX.GT.0) WRITE(*,*)
      DO 15 J=1, NHKFIX
        IP = IPHFIX(J)
        IS = ISHFIX(J)
        IF(IP.LT.1 .OR. IP.GT.NPOINT .OR. 
     &     IS.LT.1 .OR. IS.GT.2*NBL(IP)  ) GO TO 15
C
        HKNEW = HKLOC(J)
     &        + HKL_ALFA(J)*DALFA(IP)
     &        + HKL_MACH(J)*DMACH(IP)
     &        + HKL_REYN(J)*DLNRE(IP)*REYN(IP)
        DO 152 K=1, NMOD(IP)
          HKNEW = HKNEW + HKL_MOD(K,J)*DMOD(K,IP)
 152    CONTINUE
        DO 154 K=1, NPOS(IP)
          HKNEW = HKNEW + HKL_POS(K,J)*DPOS(K,IP)
 154    CONTINUE
C
        CHRX = ' '
        IF(LHKFIX(J)) CHRX = '*'
        WRITE(*,1036) ' HK',J,'    :',CHRX,HKLOC(J),HKNEW,HKSPEC(J),
     &                               XHKFIX(J), IS, IP
 15   CONTINUE
C
C
      WRITE(*,*)
      DO 20 IP=1, NPOINT
        CLNEW = CL(IP) + CL_ALFA(IP)*DALFA(IP)
     &                 + CL_MACH(IP)*DMACH(IP)
     &                 + CL_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 202 K=1, NMOD(IP)
          CLNEW = CLNEW + CL_MOD(K,IP)*DMOD(K,IP)
 202    CONTINUE
C
        DO 204 K=1, NPOS(IP)
          CLNEW = CLNEW + CL_POS(K,IP)*DPOS(K,IP)
 204    CONTINUE
C
        CHRX = ' '
        IF(LCLFIX(IP)) CHRX = '*'
        WRITE(*,1040) ' CL',IP,'    :', CHRX, CL(IP), CLNEW, CLSPEC(IP)
 20   CONTINUE
C
C
      WRITE(*,*)
      DO 30 IP=1, NPOINT
        CMNEW = CM(IP) + CM_ALFA(IP)*DALFA(IP)
     &                 + CM_MACH(IP)*DMACH(IP)
     &                 + CM_REYN(IP)*DLNRE(IP)*REYN(IP)
        DO 302 K=1, NMOD(IP)
          CMNEW = CMNEW + CM_MOD(K,IP)*DMOD(K,IP)
 302    CONTINUE
C
        DO 304 K=1, NPOS(IP)
          CMNEW = CMNEW + CM_POS(K,IP)*DPOS(K,IP)
 304    CONTINUE
C
        CHRX = ' '
        IF(LCMFIX(IP)) CHRX = '*'
        WRITE(*,1040) ' CM',IP,'    :', CHRX, CM(IP), CMNEW, CMSPEC(IP)
 30   CONTINUE
C
C
      IF(LMAFIX1) THEN
        WRITE(*,*)
        DO 40 IP=1, NPOINT
          SQCL = SQRT( ABS(CL(IP)) )
          MCBAS = MACH(IP)*SQCL
          MC_CL = MACH(IP)/SQCL * SIGN( 0.5 , CL(IP) )
          MC_MA =          SQCL
C
          MCNEW = MCBAS + MC_CL*CL_ALFA(IP)*DALFA(IP)
     &                  + MC_CL*CL_MACH(IP)*DMACH(IP)
     &                  + MC_CL*CL_REYN(IP)*DLNRE(IP)*REYN(IP)
     &                  + MC_MA            *DMACH(IP)
          DO 402 K=1, NMOD(IP)
            MCNEW = MCNEW + MC_CL*CL_MOD(K,IP)*DMOD(K,IP)
 402      CONTINUE
C
          DO 404 K=1, NPOS(IP)
            MCNEW = MCNEW + MC_CL*CL_POS(K,IP)*DPOS(K,IP)
 404      CONTINUE
C
          CHRX = ' '
          IF(LMAFIX(IP)) CHRX = '*'
          WRITE(*,1052) ' Ma vCL ',IP,':', CHRX, MCBAS, MCNEW, MSQCL(IP)
 40     CONTINUE
      ENDIF
C
C
      IF(LREFIX1) THEN
        WRITE(*,*)
        DO 50 IP=1, NPOINT
          SQCL = SQRT( ABS(CL(IP)) )
          RCBAS = REYN(IP)*SQCL
          RC_CL = REYN(IP)/SQCL * SIGN( 0.5 , CL(IP) )
          RC_RE =          SQCL
C
          RCNEW = RCBAS + RC_CL*CL_ALFA(IP)*DALFA(IP)
     &                  + RC_CL*CL_MACH(IP)*DMACH(IP)
     &                  + RC_CL*CL_REYN(IP)*DLNRE(IP)*REYN(IP)
     &                  + RC_RE            *DLNRE(IP)*REYN(IP)
          DO 502 K=1, NMOD(IP)
            RCNEW = RCNEW + RC_CL*CL_MOD(K,IP)*DMOD(K,IP)
 502      CONTINUE
C
          DO 504 K=1, NPOS(IP)
            RCNEW = RCNEW + RC_CL*CL_POS(K,IP)*DPOS(K,IP)
 504      CONTINUE
C
          CHRX = ' '
          IF(LREFIX(IP)) CHRX = '*'
          WRITE(*,1054) ' Re vCL ',IP,':', CHRX, RCBAS, RCNEW, RSQCL(IP)
 50     CONTINUE
      ENDIF
C
      IF(NUCON.GT.0) WRITE(*,*)
      DO 70 ICON=1, NUCON
        IF(LUCDEF(ICON)) THEN
         CHRX = ' '
         IF(LUCFIX(ICON)) CHRX = '*'
         WRITE(*,1080) UCNAME(ICON), ICON, ':', CHRX
        ENDIF
 70   CONTINUE
C
      RETURN
C................................................................
 1000 FORMAT(' Geometric constraints imposed on point',I3,' geometry')
 1001 FORMAT(' Element',I2,' ...')
 1003 FORMAT(/1X,
     &'Constraint ?  baseline  modified specified        x/c    s/smax')
C     ' L angle :     174.317   174.317     0.000   at     "       "
C     ' R angle :       8.531     8.531     0.000   at     "       "
C     ' Curv LE : *   100.123   100.110   100.110
C     ' Tmax    :     0.12341   0.11001   0.11001   at  0.4922
C     ' Tloc(1) : *   0.12341   0.11001   0.11001   at  0.6000
C     ' Area    :     0.12341   0.11001   0.11001
C     ' Strain  :     0.12341   0.11001   0.11001 | skin  t_top/t_bot:
C     ' EIx100  :     0.12341   0.11001   0.11001 | skin  x/c extent :
 1005 FORMAT(1X,A10,1X,A1,33X,'at',2F8.4,'   side',I2)
 1010 FORMAT(1X,A10     ,1X,A1,3F10.3,'   at     "       "')
 1011 FORMAT(1X,A10     ,1X,A1,3F10.3)
 1020 FORMAT(1X,A10     ,1X,A1,3F10.5,'   at x/c =',F8.4)
 1021 FORMAT(1X,A6,I1,A3,1X,A1,3F10.5,'   at x/c =',F8.4)
 1030 FORMAT(1X,A10     ,1X,A1,3F10.5)
 1031 FORMAT(1X,A10     ,1X,A1,3F10.5,' | skin t_top/t_bot =', F8.4)
 1032 FORMAT(1X,A10     ,1X,A1,3F10.5,' | skin extent  x/c =',2F8.4)
C
 1036 FORMAT(1X,A3,I2,A5,1X,A1,3F10.5,
     &                   '   at x/c =',F8.4,'   side',I2,'  point',I2)
C
 1040 FORMAT(1X,A3,I2,A5,1X,A1,3F10.5)
 1052 FORMAT(1X,A7,I2,A1,1X,A1,3F10.5)
 1054 FORMAT(1X,A7,I2,A1,1X,A1,3F10.0)
 1080 FORMAT(1X,A7,I2,A1,1X,A1)
      END ! SHOCON



      SUBROUTINE SELCON
C-------------------------------------------------
C     Allows user to impose/remove constraints.
C-------------------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL DONE, ERROR, CHANGE, BLANK,
     &        LTHSET, LAGSET, LCVSET, LHKSET
      LOGICAL LTHNEW, LHKNEW
C
      DIMENSION RINPUT(4)
      CHARACTER*80 LINEN
C
      PARAMETER (NINPX=40, NKEYX=20)
      DIMENSION KINP(NINPX), KEYARR(NKEYX)
C
 1000 FORMAT(A80)
C
      LTHSET = .FALSE.
      LAGSET = .FALSE.
      LCVSET = .FALSE.
      LHKSET = .FALSE.
C
      IP = IPGSEN
C
 10   WRITE(*,*)  '_____________________________________'
      WRITE(*,*)
      IF(NMODMX.GT.0) THEN
       WRITE(*,1050) '  LS    left  slope     | per side index'
       WRITE(*,1050) '  RS    right slope     | ', 1, '..', 2*NBL(IP)
       WRITE(*,*)
       WRITE(*,1050) '  LA    left  angle     | per element index'
       WRITE(*,1050) '  RA    right angle     | ', 1, '..', NBL(IP)
       WRITE(*,1050) '  CV    LE curvature    | '
       WRITE(*,1050) '  TH    max thickness   | '
       WRITE(*,1050) '  T1,2  local thickness | '
       WRITE(*,1050) '  AR    area            | '
       WRITE(*,1050) '  ST    strain          | '
       WRITE(*,1050) '  EI    EI              | '
       WRITE(*,1050)
      ENDIF
C
      WRITE(*,1050)  '  HK    shape parameter | per location index'
      WRITE(*,1050)
C
      WRITE(*,1050)  '  CL                    | per point index'
      WRITE(*,1050)  '  CM                    | ', 1, '..', NPOINT
      IF(LMAFIX1) 
     & WRITE(*,1050) '  MC                    | '
      IF(LREFIX1)
     & WRITE(*,1050) '  RC                    | '
C
      IF(NUCON.GT.0) THEN
       WRITE(*,*)
       WRITE(*,1050) '  UC   user constraint  | per constraint index'
       WRITE(*,1050) '                          ' , 1, '..', NUCON
      ENDIF
      WRITE(*,*)
 1050 FORMAT(1X,A,I2,A,I2)
C
 15   WRITE(*,1100)
 1100 FORMAT(1X,'Specify  constraint(s),index(s)  to toggle:  ',$)
      READ (*,1000) LINE
C
C---- get keyword character locations
      KLS = MAX( INDEX(LINE,'LS') , INDEX(LINE,'ls') )
      KRS = MAX( INDEX(LINE,'RS') , INDEX(LINE,'rs') )
      KLA = MAX( INDEX(LINE,'LA') , INDEX(LINE,'la') )
      KRA = MAX( INDEX(LINE,'RA') , INDEX(LINE,'ra') )
      KCV = MAX( INDEX(LINE,'CV') , INDEX(LINE,'cv') )
      KTH = MAX( INDEX(LINE,'TH') , INDEX(LINE,'th') )
      KTL = MAX( INDEX(LINE,'T1') , INDEX(LINE,'t1'),
     &           INDEX(LINE,'T2') , INDEX(LINE,'t2'),
     &           INDEX(LINE,'T3') , INDEX(LINE,'t3') )
      KAR = MAX( INDEX(LINE,'AR') , INDEX(LINE,'ar') )
      KST = MAX( INDEX(LINE,'ST') , INDEX(LINE,'st') )
      KEI = MAX( INDEX(LINE,'EI') , INDEX(LINE,'ei') )
      KHK = MAX( INDEX(LINE,'HK') , INDEX(LINE,'hk') )
      KCL = MAX( INDEX(LINE,'CL') , INDEX(LINE,'cl') )
      KCM = MAX( INDEX(LINE,'CM') , INDEX(LINE,'cm') )
      KMC = MAX( INDEX(LINE,'MC') , INDEX(LINE,'mc') )
      KRC = MAX( INDEX(LINE,'RC') , INDEX(LINE,'rc') )
      KUC = MAX( INDEX(LINE,'UC') , INDEX(LINE,'uc') )
C
C---- find local-thickness location number
      ITHL = -1
      IF(KTL.NE.0) READ(LINE(KTL+1:KTL+1),*,ERR=16) ITHL1
      ITHL = ITHL1
 16   CONTINUE
C
      KLIST = INDEX(LINE,'?')
      BLANK = INDEX(LINE(1:1),' ') .EQ. 1
C
      KEYARR( 1) = KLS
      KEYARR( 2) = KRS
      KEYARR( 3) = KLA
      KEYARR( 4) = KRA
      KEYARR( 5) = KCV
      KEYARR( 6) = KTH
      KEYARR( 7) = KTL
      KEYARR( 8) = KAR
      KEYARR( 9) = KST
      KEYARR(10) = KEI
      KEYARR(11) = KHK
      KEYARR(12) = KCL
      KEYARR(13) = KCM
      KEYARR(14) = KMC
      KEYARR(15) = KRC
      KEYARR(16) = KUC
      KEYARR(17) = KLIST
      KEYARR(18) = 80
C
C---- total number of keywords to be examined (must be .LE. NKEYX !)
      NKEY = 18
C
C
C---- sort keyword locations
      DO 17 IPASS=1, NKEYX
        DONE = .TRUE.
        DO 171 LKEY=1, NKEY-1
          IF(KEYARR(LKEY).GT.KEYARR(LKEY+1)) THEN
            KTMP = KEYARR(LKEY)
            KEYARR(LKEY) = KEYARR(LKEY+1)
            KEYARR(LKEY+1) = KTMP
            DONE = .FALSE.
          ENDIF
 171    CONTINUE
        IF(DONE) GO TO 18
 17   CONTINUE
      WRITE(*,*) 'SELCON: Sort failed'
 18   CONTINUE
C
C
      CHANGE = .FALSE.
C
C---- go over keywords
      DO 900 LKEY=1, NKEY-1
C
      KEY  = KEYARR(LKEY)
      KEYP = KEYARR(LKEY+1)
C
C---- skip if this keyword character was not input or it's a "?"
      IF(KEY.EQ.0 .OR. KEY.EQ.KLIST) GO TO 900
C
C---- read all integers between current and next keyword character
      KLEN = KEYP - KEY - 2
      DO 20 K=1, 80
        LINEN(K:K) = ' '
 20   CONTINUE
      LINEN(1:KLEN) = LINE(KEY+2:KEYP-1)
      CALL GETINT(LINEN,KINP,NINP,ERROR)
C
C---- examine the number of indices NINP ...
C
C---- ... for all side-indexed constraints
      IF(KEY.EQ.KLS .OR.
     &   KEY.EQ.KRS     ) THEN
        IF(NINP.EQ.0) THEN
         WRITE(*,*) '*** Must specify side index!'
         GO TO 900
        ENDIF
      ENDIF
C
C
C---- ... for all element-indexed constraints
      IF(KEY.EQ.KLA .OR. 
     &   KEY.EQ.KRA .OR.
     &   KEY.EQ.KCV .OR.
     &   KEY.EQ.KTH .OR.
     &   KEY.EQ.KTL .OR.
     &   KEY.EQ.KAR .OR.
     &   KEY.EQ.KST .OR.
     &   KEY.EQ.KEI     ) THEN
        IP = IPGSEN
        IF(NINP.EQ.0 .AND. NBL(IP).EQ.1) THEN
C------- no element index was input for single-element case... just set it
         NINP = 1
         KINP(1) = NBL(IP)
        ENDIF
C
        IF(NINP.EQ.0) THEN
         WRITE(*,*) '*** Must specify element index!'
         GO TO 900
        ENDIF
      ENDIF
C
C
C---- ... for all point-indexed constraints
      IF(KEY.EQ.KCL .OR. 
     &   KEY.EQ.KCM .OR. 
     &   KEY.EQ.KMC .OR. 
     &   KEY.EQ.KRC     ) THEN
        IF(NINP.EQ.0 .AND. NPOINT.EQ.1) THEN
C------- no point index was input for single-point case... just set it
         NINP = 1
         KINP(1) = NPOINT
        ENDIF
C
        IF(NINP.EQ.0) THEN
         WRITE(*,*) '*** Must specify point index!'
         GO TO 900
        ENDIF
      ENDIF
C
C
C---- ... for user-constraints
      IF(KEY.EQ.KUC) THEN
        IF(NINP.EQ.0 .AND. NUCON.EQ.1) THEN
C------- no point index was input for single-point case... just set it
         NINP = 1
         KINP(1) = NUCON
        ENDIF
C
        IF(NINP.EQ.0) THEN
         WRITE(*,*) '*** Must specify user-constraint index!'
         GO TO 900
        ENDIF
      ENDIF
C
C
C---- ... for Hk constraints
      IF(KEY.EQ.KHK) THEN
        IF(NINP.EQ.0 .AND. NUCON.EQ.1) THEN
C------- no point index was input for single-point case... just set it
         NINP = 1
         KINP(1) = NUCON
        ENDIF
C
        IF(NINP.EQ.0) THEN
         WRITE(*,*) '*** Must specify location index!'
         GO TO 900
        ENDIF
      ENDIF
C
C
C==== left or right slope ===============================
      IF(KEY.EQ.KLS .OR. KEY.EQ.KRS) THEN
        IP = IPGSEN
C
        DO 22 I=1, NINP
          IS = KINP(I)
          IF(IS.LT.0 .OR. IS.GT.2*NBL(IP)) GO TO 22
C
C-------- do only specified side
          ISS1 = IS
          ISS2 = IS
          IF(IS.EQ.0) THEN
C--------- side index=0... do all sides
           ISS1 = 1
           ISS2 = 2*NBL(IP)
          ENDIF
C
C-------- go over sides
          DO 221 IS=ISS1, ISS2
            N = (IS+1)/2
            IS1 = 2*N - 1
            IS2 = 2*N
            KS = IS+1 - IS1
C
C---------- toggle selected constraints
            IF(KEY.EQ.KLS) LSLFIX(IS) = .NOT. LSLFIX(IS)
            IF(KEY.EQ.KRS) LSRFIX(IS) = .NOT. LSRFIX(IS)
            IF(KEY.EQ.KLS .OR.
     &         KEY.EQ.KRS     ) CHANGE = .TRUE.
C
C---------- get left slope-constraint location if constraint was enabled
            IF(KEY.EQ.KLS .AND. LSLFIX(IS)) THEN
 2211         WRITE(*,2212) IS, SBLFIX(IS)
 2212         FORMAT(1X,
     &  'Enter s/smax for left  slope constraint (side',I2,'):',F9.4)
              CALL READR(1,SBLFIX(IS),ERROR)
              IF(ERROR) GO TO 2211
              IF(SBLFIX(IS).LT.0.0 .OR. SBLFIX(IS).GT.1.0) THEN
               WRITE(*,*) '*** Must specify 0 < s/smax < 1 '
               GO TO 2211
              ENDIF
C
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                    XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), KS, SBLFIX(IS), XB1, YB1)
              DXB = XTEB(N,IP) - XLEB(N,IP)
              DYB = YTEB(N,IP) - YLEB(N,IP)
              CHB = SQRT(DXB**2 + DYB**2)
              XBLFIX(IS) = ( (XB1-XLEB(N,IP))*DXB
     &                     + (YB1-YLEB(N,IP))*DYB ) / CHB
              WRITE(*,2213) XBLFIX(IS)
 2213         FORMAT(1X,'Resulting x/c =', F9.4)
            ENDIF
C
C---------- get right slope-constraint location if constraint was enabled
            IF(KEY.EQ.KRS .AND. LSRFIX(IS)) THEN
 2216         WRITE(*,2217) IS, SBRFIX(IS)
 2217         FORMAT(1X,
     &  'Enter s/smax for right slope constraint (side',I2,'):',F9.4)
              CALL READR(1,SBRFIX(IS),ERROR)
              IF(ERROR) GO TO 2216
              IF(SBRFIX(IS).LT.0.0 .OR. SBRFIX(IS).GT.1.0) THEN
               WRITE(*,*) '*** Must specify 0 < s/smax < 1 '
               GO TO 2216
              ENDIF
C
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                    XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), KS, SBRFIX(IS), XB1, YB1)
              DXB = XTEB(N,IP) - XLEB(N,IP)
              DYB = YTEB(N,IP) - YLEB(N,IP)
              CHB = SQRT(DXB**2 + DYB**2)
              XBRFIX(IS) = ( (XB1-XLEB(N,IP))*DXB
     &                     + (YB1-YLEB(N,IP))*DYB ) / CHB
              WRITE(*,2218) XBRFIX(IS)
 2218         FORMAT(1X,'Resulting x/c =', F9.4)
            ENDIF
 221      CONTINUE
 22     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== left and right angle =======================
      IF(KEY.EQ.KLA .OR. KEY.EQ.KRA) THEN
        IP = IPGSEN
C
        DO 28 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 28
C
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 281 N=N1, N2
            IS1 = 2*N - 1
            IS2 = 2*N
C
            IF(KEY.EQ.KLA) LALFIX(N) = .NOT. LALFIX(N)
            IF(KEY.EQ.KRA) LARFIX(N) = .NOT. LARFIX(N)
C
            IF(KEY.EQ.KLA .AND. LALFIX(N)) THEN
              RINPUT(1) = ALSPEC(N)
              RINPUT(2) = SBLFIX(IS1)
              RINPUT(3) = SBLFIX(IS2)
 2811         WRITE(*,2812) N, (RINPUT(K),K=1,3)
 2812         FORMAT(1X,'Enter specified',
     &   ' left  angle, s/smax_top, bot (element',I2,'):',3F10.4)
              CALL READR(3,RINPUT,ERROR)
              IF(ERROR) GO TO 2811
              ALSPEC(N)   = RINPUT(1)
              SBLFIX(IS1) = RINPUT(2)
              SBLFIX(IS2) = RINPUT(3)
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                    XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), 1, SBLFIX(IS1), XB1, YB1)
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                   XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), 2, SBLFIX(IS2), XB2, YB2)
              DXB = XTEB(N,IP) - XLEB(N,IP)
              DYB = YTEB(N,IP) - YLEB(N,IP)
              CHB = SQRT(DXB**2 + DYB**2)
              XBLFIX(IS1) = ( (XB1-XLEB(N,IP))*DXB
     &                      + (YB1-YLEB(N,IP))*DYB ) / CHB
              XBLFIX(IS2) = ( (XB2-XLEB(N,IP))*DXB
     &                      + (YB2-YLEB(N,IP))*DYB ) / CHB
              LAGSET = .TRUE.
            ENDIF
C
            IF(KEY.EQ.KRA .AND. LARFIX(N)) THEN
              RINPUT(1) = ARSPEC(N)
              RINPUT(2) = SBRFIX(IS1)
              RINPUT(3) = SBRFIX(IS2)
 2815         WRITE(*,2816) N, (RINPUT(K),K=1,3)
 2816         FORMAT(1X,'Enter specified',
     &   ' right angle, s/smax_top, _bot (element',I2,'):',3F10.4)
              CALL READR(3,RINPUT,ERROR)
              IF(ERROR) GO TO 2815
              ARSPEC(N)   = RINPUT(1)
              SBRFIX(IS1) = RINPUT(2)
              SBRFIX(IS2) = RINPUT(3)
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                    XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), 1, SBRFIX(IS1), XB1, YB1)
              CALL XYSFIX(IX,ILEB(N,IP),ITEB(N,IP),
     &                    XBI(1,IS1,IP),YBI(1,IS1,IP),SBI(1,IS1,IP),
     &                    SBLEGN(N,IP), 2, SBRFIX(IS2), XB2, YB2)
              DXB = XTEB(N,IP) - XLEB(N,IP)
              DYB = YTEB(N,IP) - YLEB(N,IP)
              CHB = SQRT(DXB**2 + DYB**2)
              XBLFIX(IS1) = ( (XB1-XLEB(N,IP))*DXB
     &                      + (YB1-YLEB(N,IP))*DYB ) / CHB
              XBLFIX(IS2) = ( (XB2-XLEB(N,IP))*DXB
     &                      + (YB2-YLEB(N,IP))*DYB ) / CHB
              LAGSET = .TRUE.
            ENDIF
C
 281      CONTINUE
 28     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== max-thickness ==============================
      IF(KEY.EQ.KTH) THEN
        IP = IPGSEN
        ITH = 0
C
        DO 30 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 30
C
C-------- go over selected one or all elements
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 301 N=N1, N2
            LTHFIX(ITH,N) = .NOT. LTHFIX(ITH,N)
C
            IF(LTHFIX(ITH,N)) THEN
 3011         WRITE(*,3012) N, THSPEC(ITH,N)
 3012         FORMAT(1X,'Enter specified',
     &     ' max thickness (element',I2,'):',F12.5)
              CALL READR(1,THSPEC(ITH,N),ERROR)
              IF(ERROR) GO TO 3011
              LTHSET = .TRUE.
            ENDIF
 301      CONTINUE
 30     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== local thickness ================================
      IF(KEY.EQ.KTL) THEN
        IP = IPGSEN
        ITH = ITHL
C
        DO 32 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 32
C
C-------- go over selected one or all elements
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 321 N=N1, N2
            ITH = MIN(ITH,NTHFIX(N)+1)
            IF(ITH .LE. 0 .OR. ITH .GT. NTHX) THEN
             WRITE(*,*) '*** Local-thickness index outside range (1-3)'
             GO TO 321
            ELSE
             LTHFIX(ITH,N) = .NOT. LTHFIX(ITH,N)
             LTHNEW = ITH.GT.NTHFIX(N)
             NTHFIX(N) = MAX(NTHFIX(N),ITH)
            ENDIF
C
            IF(LTHFIX(ITH,N)) THEN
C
             XTHOLD = XTHFIX(ITH,N)
 3211        WRITE(*,3212) N, XTHFIX(ITH,N)
 3212        FORMAT(1X,'Enter x/c (element',I2,'):',F12.5)
             CALL READR(1,XTHFIX(ITH,N),ERROR)
             IF(ERROR) GO TO 3211
             IF(XTHFIX(ITH,N).LE.0.0 .OR. XTHFIX(ITH,N).GE.1.0) THEN
              WRITE(*,*) '*** Must specify 0 < x/c < 1 '
              GO TO 3211
             ENDIF
C
C----------- set local thickness
             IS = 2*N - 1
             K = 1
             CALL THCALC(IX,ILEB(N,IP),ITEB(N,IP),
     &            XBI(1,IS,IP), XBI_MOD(1,IS,K,IP),
     &            YBI(1,IS,IP), YBI_MOD(1,IS,K,IP),
     &            XLEB(N,IP),YLEB(N,IP),
     &            XTEB(N,IP),YTEB(N,IP),
     &            XTHFIX(ITH,N),
     &            THIKB(ITH,N,IP),THB_MOD(K,ITH,N,IP) )
C
C----------- initialize specified thickness if it's new
             LTHNEW = LTHNEW
     &         .OR. ABS(THSPEC(ITH,N) - THIKB(ITH,N,IP)) .GT. 0.01
     &         .OR. ABS(XTHFIX(ITH,N) - XTHOLD         ) .GT. 0.01
C
             IF(LTHNEW) THSPEC(ITH,N) = THIKB(ITH,N,IP)
C
 3215        WRITE(*,3216) THIKB(ITH,N,IP), THSPEC(ITH,N)
 3216        FORMAT(1X,'Baseline local thickness =',F10.5
     &             /1X,'Enter specified thickness:',F10.5)
             CALL READR(1,THSPEC(ITH,N),ERROR)
             IF(ERROR) GO TO 3215
             LTHSET = .TRUE.
C
            ENDIF
 321      CONTINUE
 32     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== LE curvature ===============================
      IF(KEY.EQ.KCV) THEN
        IP = IPGSEN
C
        DO 34 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 34
C
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 341 N=N1, N2
            LCVFIX(N) = .NOT.LCVFIX(N)
C
            IF(LCVFIX(N)) THEN
 3411         WRITE(*,3412) N, CVSPEC(N)
 3412         FORMAT(1X,'Enter specified',
     &   ' LE curvature (element',I2,'):',F12.3)
              CALL READR(1,CVSPEC(N),ERROR)
              IF(ERROR) GO TO 3411
            ENDIF
 341      CONTINUE
 34     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== element area ===============================
      IF(KEY.EQ.KAR) THEN
        IP = IPGSEN
C
        DO 35 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 35
C
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 351 N=N1, N2
            LABFIX(N) = .NOT.LABFIX(N)
C
            IF(LABFIX(N)) THEN
 3511         WRITE(*,3512) N, ABSPEC(N)
 3512         FORMAT(1X,'Enter specified area (element',I2,'):',F12.5)
              CALL READR(1,ABSPEC(N),ERROR)
              IF(ERROR) GO TO 3511
            ENDIF
 351      CONTINUE
 35     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C==== unit strain and stiffness =====================
      IF(KEY.EQ.KST .OR. KEY.EQ.KEI) THEN
        IP = IPGSEN
C
        DO 40 I=1, NINP
          N = KINP(I)
          IF(N.LT.0 .OR. N.GT.NBL(IP)) GO TO 40
C
          N1 = N
          N2 = N
          IF(N.EQ.0) THEN
           N1 = 1
           N2 = NBL(IP)
          ENDIF
          DO 401 N=N1, N2
C---------- toggle flags for selected constraint(s)
            IF(KEY.EQ.KST) LSGFIX(N) = .NOT.LSGFIX(N)
            IF(KEY.EQ.KEI) LEIFIX(N) = .NOT.LEIFIX(N)
C
            IF((KEY.EQ.KST .AND. LSGFIX(N)) .OR.
     &         (KEY.EQ.KEI .AND. LEIFIX(N))      ) THEN
C
C------------ get structural parmeters needed to define rms strain, EI
              RINPUT(1) = TBSKIN(N)
              RINPUT(2) = XSTRF(N)
              RINPUT(3) = XSTRB(N)
 4011         WRITE(*,4012) N, (RINPUT(K), K=1, 3)
 4012         FORMAT(1X,'Enter specified',
     &   '  t_top/t_bot, x/c1, x/c2 (element',I2,'):',3F8.4)
              CALL READR(3,RINPUT,ERROR)
              IF(ERROR) GO TO 4011
              TBSKIN(N) = RINPUT(1)
              XSTRF(N)  = RINPUT(2)
              XSTRB(N)  = RINPUT(3)
            ENDIF
C
            IF(KEY.EQ.KST .AND. LSGFIX(N)) THEN
C------------ calculate current element rms strain
              CALL SGCALC(N)
C
C------------ if specified strain has not been set, set to current strain
              IF(SGSPEC(N) .EQ. 0.0) SGSPEC(N) = ASIGB(N,IP)
C
 4013         WRITE(*,4014) N, SGSPEC(N)
 4014         FORMAT(/1X,
     &     'Enter specified Astrain (element',I2,'):',F10.5)
              CALL READR(1,SGSPEC(N),ERROR)
              IF(ERROR) GO TO 4013
            ENDIF
C
            IF(KEY.EQ.KEI .AND. LEIFIX(N)) THEN
C------------ calculate current element EI
              CALL EICALC(N)
C
C------------ if specified EI has not been set, set it to current EI
              IF(EISPEC(N) .EQ. 0.0) EISPEC(N) = EI11B(N,IP)
C
 4015         WRITE(*,4016) N, 100.0*EISPEC(N)
 4016         FORMAT(/1X,
     &     'Enter specified EIx100 (element',I2,'):',F10.5)
              EIX100 = 100.0*EISPEC(N)
              CALL READR(1,EIX100,ERROR)
              EISPEC(N) = EIX100/100.0
              IF(ERROR) GO TO 4015
            ENDIF
C
 401      CONTINUE
 40     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== kinematic shape parameter =====================
      IF(KEY.EQ.KHK) THEN
C
        DO 50 I=1, NINP
          J = KINP(I)
          IF(J.LT.0 .OR. J.GT.NTHX) GO TO 50
C
          J = MIN( J , NHKFIX+1 )
C
          IF(J.EQ.0) THEN
           J1 = 1
           J2 = NHKFIX
          ELSE
           J1 = J
           J2 = J
          ENDIF
          DO 501 J=J1, J2
            IF(J .LE. 0 .OR. J .GT. NHKX) THEN
             WRITE(*,*) '*** Hk-constraint index outside range (1-5)'
             GO TO 501
            ELSE
             LHKFIX(J) = .NOT. LHKFIX(J)
             LHKNEW = J.GT.NHKFIX
             NHKFIX = MAX(NHKFIX,J)
            ENDIF
C
            IF(LHKFIX(J)) THEN
C
             XHKOLD = XHKFIX(J)
             RINPUT(1) = FLOAT(IPHFIX(J))
             RINPUT(2) = FLOAT(ISHFIX(J))
             RINPUT(3) = XHKFIX(J)
 5011        WRITE(*,5012) J, INT(RINPUT(1)), INT(RINPUT(2)), RINPUT(3)
 5012        FORMAT(1X,
     &          'Enter  point, side, x/c  for Hk-constraint (',I1,'):',
     &           I4, I4, F8.4)
             CALL READR(3,RINPUT,ERROR)
             IF(ERROR) GO TO 5011
C
             IPHFIX(J) = RINPUT(1)
             ISHFIX(J) = RINPUT(2)
             XHKFIX(J) = RINPUT(3)
C
             IF(XHKFIX(J).LE.0.0 .OR. XHKFIX(J).GT.1.0) THEN
              WRITE(*,*) '*** Must specify 0 < x/c < 1 '
              GO TO 5011
             ENDIF
C
             IF(IPHFIX(J).LT.1 .OR. IPHFIX(J).GT.NPOINT) THEN
              WRITE(*,*) '*** Point index out of range '
              GO TO 5011
             ENDIF
C
             IF(ISHFIX(J).LT.1 .OR. ISHFIX(J).GT.2*NBL(IPHFIX(J))) THEN
              WRITE(*,*) '*** Side index out of range '
              GO TO 5011
             ENDIF
C
C----------- set local shape parameter
             IP = IPHFIX(J)
             IS = ISHFIX(J)
             N = (IS+1)/2
             ILE = ILEB(N,IP)
             NPTS = ITEB(N,IP) - ILEB(N,IP) + 1
             K = 1
             CALL VRCALC(NPTS,
     &                   XBI(ILE,IS,IP),XBI_MOD(ILE,IS,K,IP),
     &                   YBI(ILE,IS,IP),YBI_MOD(ILE,IS,K,IP),
     &                    HK(ILE,IS,IP), HK_MOD(ILE,IS,K,IP),
     &                   XLEB(N,IP),YLEB(N,IP),XTEB(N,IP),YTEB(N,IP),
     &                   XHKFIX(J), HKLOC(J), HKLP)
C
C----------- initialize specified Hk if it's new
             LHKNEW = LHKNEW
     &         .OR. ABS(HKSPEC(J) - HKSPEC(J)) .GT. 0.01
     &         .OR. ABS(XHKFIX(J) - XHKOLD   ) .GT. 0.01
C
             IF(LHKNEW) HKSPEC(J) = HKLOC(J)
C
 5215        WRITE(*,5216) HKLOC(J), HKSPEC(J)
 5216        FORMAT(1X,'Baseline local Hk =',F10.5
     &             /1X,'Enter specified Hk:',F10.5)
             CALL READR(1,HKSPEC(J),ERROR)
             IF(ERROR) GO TO 5215
             LHKSET = .TRUE.
C
            ENDIF
C
 501      CONTINUE
 50     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== CL, CM, Mach, Reyn  constraints ===========================
      IF(KEY.EQ.KCL .OR. KEY.EQ.KCM .OR. 
     &   KEY.EQ.KMC .OR. KEY.EQ.KRC      ) THEN
        DO 66 I=1, NINP
          IP = KINP(I)
          IF(IP.LT.0 .OR. IP.GT.NPOINT) GO TO 66
C
          IP1 = IP
          IP2 = IP
          IF(IP.EQ.0) THEN
           IP1 = 1
           IP2 = NPOINT
          ENDIF
          DO 661 IP=IP1, IP2
C
 6610       FORMAT(1X,A,I3)
C
            IF(KEY.EQ.KCL) THEN
              LCLFIX(IP) = .NOT.LCLFIX(IP)
              CHANGE = .TRUE.
              IF(LCLFIX(IP)) THEN
 6611          WRITE(*,6612) IP, CLSPEC(IP)
 6612          FORMAT(' Enter specified CL (point',I2,'):',F12.5)
               CALL READR(1,CLSPEC(IP),ERROR)
               IF(ERROR) GO TO 6611
              ENDIF
            ENDIF
C
            IF(KEY.EQ.KCM) THEN
              LCMFIX(IP) = .NOT.LCMFIX(IP)
              CHANGE = .TRUE.
              IF(LCMFIX(IP)) THEN
 6613          WRITE(*,6614) IP, CMSPEC(IP)
 6614          FORMAT(' Enter specified CM (point',I2,'):',F12.5)
               CALL READR(1,CMSPEC(IP),ERROR)
               IF(ERROR) GO TO 6613
              ENDIF
            ENDIF
C 
            IF(KEY.EQ.KMC) THEN
              IF(KMACH(IP).EQ.0 .OR. MACH(IP).EQ.0.0) THEN
               WRITE(*,*)
     &            'Sensitivities wrt Mach not available for point',IP
               GO TO 661
              ENDIF
C
              LMAFIX(IP) = .NOT.LMAFIX(IP)
              CHANGE = .TRUE.
              IF(LMAFIX(IP)) THEN
 6615          WRITE(*,6616) IP, MSQCL(IP)
 6616          FORMAT(' Enter specified Ma sq(CL) (point',I2,'):',F12.5)
               CALL READR(1,MSQCL(IP),ERROR)
               IF(ERROR) GO TO 6615
              ENDIF
            ENDIF
C
            IF(KEY.EQ.KRC) THEN
              IF(KREYN(IP).EQ.0 .OR. REYN(IP).EQ.0.0) THEN
               WRITE(*,*)
     &            'Sensitivities wrt Reyn not available for point',IP
               GO TO 661
              ENDIF
C
              LREFIX(IP) = .NOT.LREFIX(IP)
              CHANGE = .TRUE.
              IF(LREFIX(IP)) THEN
 6617          WRITE(*,6618) IP, RSQCL(IP)
 6618          FORMAT(' Enter specified Re sq(CL) (point',I2,'):',F12.0)
               CALL READR(1,RSQCL(IP),ERROR)
               IF(ERROR) GO TO 6617
              ENDIF
            ENDIF
C
 661      CONTINUE
 66     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C
C==== user-defined constraints ==========================
      IF(KEY.EQ.KUC .AND. NUCON.GT.0) THEN
C
        DO 86 I=1, NINP
          ICON = KINP(I)
          IF(ICON.LT.0 .OR. ICON.GT.NUCON) GO TO 86
C
          ICON1 = ICON
          ICON2 = ICON
          IF(ICON.EQ.0) THEN
           ICON1 = 1
           ICON2 = NUCON
          ENDIF
          DO 861 ICON=ICON1, ICON2
            IF(LUCDEF(ICON)) THEN
             LUCFIX(ICON) = .NOT.LUCFIX(ICON)
             CHANGE = .TRUE.
            ELSE
             WRITE(*,8610) ICON
 8610        FORMAT(1X,'User constraint',I3,' not defined in USRCON !')
            ENDIF
 861      CONTINUE
C
 86     CONTINUE
C
        CHANGE = .TRUE.
      ENDIF
C
C---- if any changes were made, will have to rebuild constraint Jacobian
      IF(CHANGE) THEN
       LXCON = .FALSE.
       LXSYS = .FALSE.
       LPRSET = .TRUE.
       LFCSET = .FALSE.
      ENDIF
C
 900  CONTINUE
C
      IF(KLIST .GT. 0) THEN
C----- "?" was input... display parameter status and toggle menu
       CALL SHOCON
       GO TO 10
      ENDIF
C
C---- go get new input line
      IF(.NOT.BLANK) GO TO 15
C
C---- if specified-thicknesses were toggled, set thicknesses
      IF(LTHSET) CALL THBLIN
      IF(LAGSET) CALL ANGLIN
      IF(LCVSET) CALL CRVLIN
      IF(LHKSET) CALL HKLLIN
C
      RETURN
      END ! SELCON



      SUBROUTINE KEYMOD
C----------------------------------------
C     Keyboard parameter input routine.
C----------------------------------------
      INCLUDE 'LINDOP.INC'
      LOGICAL ERROR
      DIMENSION DEL(0:1)
      CHARACTER*1 PTYPE
C
 1000 FORMAT(A)
C
      KALMAX = KALFA(1)
      KMAMAX = KMACH(1)
      KREMAX = KREYN(1)
      DO 8 IP=1, NPOINT
        KALMAX = MAX(KALMAX,KALFA(IP))
        KMAMAX = MAX(KMAMAX,KMACH(IP))
        KREMAX = MAX(KREMAX,KREYN(IP))
 8    CONTINUE
C
C---- display menu item for every available parameter class
 10   WRITE(*,*) '___________________________________'
      WRITE(*,*)
      IF(KALMAX.GT.0) WRITE(*,*) '    A lpha'
      IF(KMAMAX.GT.0) WRITE(*,*) '    M ach'
      IF(KREMAX.GT.0) WRITE(*,*) '    R eynolds'
      IF(NMODMX.GT.0) THEN
       IF(LNKMOD .OR. IPTARG.EQ.0) THEN
                      WRITE(*,*) '    G eometry modes for all points'
       ELSE
                   WRITE(*,1050) '    G eometry modes for point',IPTARG
       ENDIF
      ENDIF
      IF(NPOSMX.GT.0) THEN
       IF(LNKPOS .OR. IPTARG.EQ.0) THEN
                      WRITE(*,*) '    P osition modes for all points'
       ELSE
                   WRITE(*,1050) '    P osition modes for point',IPTARG
       ENDIF
      ENDIF
      IF(NUPAR .GT.0) WRITE(*,*) '    U ser parameters'
      WRITE(*,*)
C
 1050 FORMAT(1X,A,I3)
C
 15   WRITE(*,1100)
 1100 FORMAT(1X,'Specify parameter-type to modify:  ',$)
      READ(*,1000) PTYPE
C
      IF(INDEX(' ',PTYPE) .EQ. 1) RETURN
C

      IF(PTYPE.EQ.'A' .OR. PTYPE.EQ.'a') THEN
        IF(KALMAX.LE.0) GO TO 10
C
 20     WRITE(*,*) 'Enter  point, dAlpha (<cr> if no more) ...'
        DO 22 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 20
          IF(NDEL.EQ.0) GO TO 23
C
          IP = INT(DEL(0))
          IF(IP.EQ.0) THEN
            DO 2221 IPT=1, NPOINT
              DALFA(IPT) = DEL(1) * DTOR
 2221       CONTINUE
            GO TO 23
          ELSE IF(IP.LT.-1 .OR. IP.GT.NPOINT) THEN
            WRITE(*,*) '*** Point index out of range !'
          ELSE
            DALFA(IP) = DEL(1) * DTOR
          ENDIF
 22     CONTINUE
 23     CONTINUE
C
C
      ELSE IF(PTYPE.EQ.'M' .OR. PTYPE.EQ.'m') THEN
        IF(KMAMAX.LE.0) GO TO 10
C
 30     WRITE(*,*) 'Enter  point, dMach (<cr> if no more) ...'
        DO 32 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 30
          IF(NDEL.EQ.0) GO TO 33
C
          IP = INT(DEL(0))
          IF(IP.EQ.0) THEN
            DO 3221 IPT=1, NPOINT
              DMACH(IPT) = DEL(1)
 3221       CONTINUE
            GO TO 33
          ELSE IF(IP.LT.-1 .OR. IP.GT.NPOINT) THEN
            WRITE(*,*) '*** Point index out of range !'
          ELSE
            DMACH(IP) = DEL(1)
          ENDIF
 32     CONTINUE
 33     CONTINUE
C
C
      ELSE IF(PTYPE.EQ.'A' .OR. PTYPE.EQ.'a') THEN
        IF(KREMAX.LE.0) GO TO 10
C
 40     WRITE(*,*) 'Enter  point, d(ln Re) (<cr> if no more) ...'
        DO 42 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 40
          IF(NDEL.EQ.0) GO TO 43
C
          IP = INT(DEL(0))
          IF(IP.EQ.0) THEN
            DO 4221 IPT=1, NPOINT
              DLNRE(IPT) = DEL(1)
 4221       CONTINUE
            GO TO 43
          ELSE IF(IP.LT.-1 .OR. IP.GT.NPOINT) THEN
            WRITE(*,*) '*** Point index out of range !'
          ELSE
            DLNRE(IP) = DEL(1)
          ENDIF
 42     CONTINUE
 43     CONTINUE
C
C
      ELSE IF(PTYPE.EQ.'G' .OR. PTYPE.EQ.'g') THEN
        IF(NMODMX.LE.0) GO TO 10
C
        IF(LNKMOD .OR. IPTARG.EQ.0) THEN
         IP1 = 1
         IP2 = NPOINT
        ELSE
         IP1 = IPTARG
         IP2 = IPTARG
        ENDIF
C
 50     WRITE(*,*) 'Enter  k, dModk (<cr> if no more) ...'
        DO 52 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 50
          IF(NDEL.EQ.0) GO TO 53
C
          K = INT(DEL(0))
          DO 522 IP=IP1, IP2
            IF(K.EQ.0) THEN
              DO 5221 KT=1, NMOD(IP)
                DMOD(KT,IP) = DEL(1)
 5221         CONTINUE
              GO TO 53
            ELSE IF(K.LT.-1 .OR. K.GT.NMOD(IP)) THEN
              WRITE(*,*) '*** Mode index out of range !'
            ELSE
              DMOD(K,IP) = DEL(1)
            ENDIF
 522      CONTINUE
 52     CONTINUE
 53     CONTINUE
C
C
      ELSE IF(PTYPE.EQ.'P' .OR. PTYPE.EQ.'p') THEN
        IF(NPOSMX.LE.0) GO TO 10
C
        IF(LNKPOS .OR. IPTARG.EQ.0) THEN
         IP1 = 1
         IP2 = NPOINT
        ELSE
         IP1 = IPTARG
         IP2 = IPTARG
        ENDIF
C
 60     WRITE(*,*) 'Enter  k, dPosk (<cr> if no more) ...'
        DO 62 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 60
          IF(NDEL.EQ.0) GO TO 63
C
          K = INT(DEL(0))
          DO 622 IP=IP1, IP2
            IF(K.EQ.0) THEN
              DO 6221 KT=1, NPOS(IP)
                DPOS(KT,IP) = DEL(1)
 6221         CONTINUE
              GO TO 63
            ELSE IF(K.LT.-1 .OR. K.GT.NPOS(IP)) THEN
              WRITE(*,*) '*** Mode index out of range !'
            ELSE
              DPOS(K,IP) = DEL(1)
            ENDIF
 622      CONTINUE
 62     CONTINUE
 63     CONTINUE
C
C
      ELSE IF(PTYPE.EQ.'U' .OR. PTYPE.EQ.'u') THEN
        IF(NUPAR.LE.0) GO TO 10
C
 80     WRITE(*,*) 'Enter  k, dXuserk (<cr> if no more) ...'
        DO 82 IDUM=1, 12345
          READ(*,1000) LINE
          CALL GETFLT(LINE,DEL(0),NDEL,ERROR)
          IF(ERROR) GO TO 80
          IF(NDEL.EQ.0) GO TO 83
C
          K = INT(DEL(0))
          IF(K.EQ.0) THEN
            DO 8221 KT=1, NUPAR
              DUPAR(KT) = DEL(1)
 8221       CONTINUE
            GO TO 83
          ELSE IF(K.LT.-1 .OR. K.GT.NUPAR) THEN
            WRITE(*,*) '*** Point index out of range !'
          ELSE
            DUPAR(K) = DEL(1)
          ENDIF
 82     CONTINUE
 83     CONTINUE
C
      ELSE
C
        GO TO 10
C
      ENDIF
C
      GO TO 15
C
      END ! KEYMOD



      SUBROUTINE SCALES
      INCLUDE 'LINDOP.INC'
      LOGICAL NEWTAR, ERROR, CHANGE
      DIMENSION NDEL(NPX)
C
C---- save target-point index since this may change
      IPTSAV = IPTARG
C
C---- clear all current parameter changes
      CALL CLRMOD(.TRUE.)
      CALL CLRAMR(.TRUE. , 0)
      CALL CLRUSR(.TRUE.)
C
C---- get new target point if it's not defined
      CALL TARGET(NEWTAR)
      IF(NEWTAR) THEN
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
C
C---- set flags to see if any alpha,Ma,Re variables are available
      KALMAX = KALFA(1)
      KMAMAX = KMACH(1)
      KREMAX = KREYN(1)
      DO 2 IP=1, NPOINT
        KALMAX = MAX(KALMAX,KALFA(IP))
        KMAMAX = MAX(KMAMAX,KMACH(IP))
        KREMAX = MAX(KREMAX,KREYN(IP))
 2    CONTINUE
C
C---- save user-specified point index so it won't have to be chosen later
      IF(IPTSAV.EQ.999) IPTSAV = IPTARG
C
      CALL GSCSHO
C
 899  WRITE(*,*)
      IF(NMODMX.GT.0) WRITE(*,*) ' 1  scale geometry modes'
      IF(NPOSMX.GT.0) WRITE(*,*) ' 2  scale position modes'
      IF(KALMAX.GT.0 .OR.
     &   KMAMAX.GT.0 .OR.
     &   KREMAX.GT.0     )
     &                WRITE(*,*) ' 3  scale alpha, Mach, Re'
      IF(NUPAR.GT.0)  WRITE(*,*) ' 4  scale user parameters'
                      WRITE(*,*) ' 5  show current scales'
                      WRITE(*,*) ' 6  change perturbation step size'
                      WRITE(*,*) ' 7  enable/disable graphical display'
                      WRITE(*,*) ' 8  change target point'
 900  WRITE(*,1005)
 1005 FORMAT(/1X,'Enter scaling option (0=return to top level): ',$)
      READ (*,*,ERR=899) IOPT
      IF(IOPT.EQ.0) THEN
       IPTARG = IPTSAV
       IF(IPTARG.NE.0) IPGSEN = IPTARG
       RETURN
      ENDIF
C
C---- initialize rms gradient arrays
      IF(IOPT.EQ.1 .OR.
     &   IOPT.EQ.2 .OR.
     &   IOPT.EQ.3 .OR.
     &   IOPT.EQ.4     ) CALL INIGRM
C
      GO TO (10,20,30,40,50,60,70,80), IOPT
      GO TO 899
C
 10   IF(LNKMOD .OR. IPTARG.EQ.0) THEN
C----- set mode changes for all points to be the same
       IP = 1
       NP = NPOINT
      ELSE
C----- set mode changes for target point only
       IP = IPTARG
       NP = 1
      ENDIF
      CALL GSCNEW(NMODX,NMOD(IP),NP,GSCMOD,DMOD(1,IP),' dMod',CHANGE)
      IF(CHANGE) THEN
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
      GO TO 899
C
 20   IF(LNKPOS .OR. IPTARG.EQ.0) THEN
C----- set mode changes for all points to be the same
       IP = 1
       NP = NPOINT
      ELSE
C----- set mode changes for target point only
       IP = IPTARG
       NP = 1
      ENDIF
      CALL GSCNEW(NPOSX,NPOS(IP),NP,GSCPOS,DPOS(1,IP),' dPos',CHANGE)
      IF(CHANGE) THEN
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
      GO TO 899
C
 30   CONTINUE
      DO 31 IP=1, NPOINT
C------ number of dAlfa, dMach, dlnRe parameters per point (i.e. 1)
        NDEL(IP) = 1
 31   CONTINUE
C
      IF(KALMAX.GT.0) THEN
       CALL GSCNEW(1,NDEL,NPOINT,GSCAL,DALFA,'dAlfa',CHANGE)
       IF(CHANGE) THEN
        LXHES = .FALSE.
        LPRSET = .TRUE.
       ENDIF
      ENDIF
C
      IF(KMAMAX.GT.0) THEN
       CALL GSCNEW(1,NDEL,NPOINT,GSCMA,DMACH,'dMach',CHANGE)
       IF(CHANGE) THEN
        LXHES = .FALSE.
        LPRSET = .TRUE.
       ENDIF
      ENDIF
C
      IF(KREMAX.GT.0) THEN
       CALL GSCNEW(1,NDEL,NPOINT,GSCLR,DLNRE,'dlnRe',CHANGE)
       IF(CHANGE) THEN
        LXHES = .FALSE.
        LPRSET = .TRUE.
       ENDIF
      ENDIF
      GO TO 899
C
 40   CALL GSCNEW(NUPX,NUPAR,1,GSCUP,DUPAR,'dXusr',CHANGE)
      IF(CHANGE) THEN
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
      GO TO 899
C
 50   CALL GSCSHO
      GO TO 900
C
 60   WRITE(*,1600) DELTRY
 1600 FORMAT(/1X,'Enter trial perturbation step size:', F10.5)
      CALL READR(1,DELTRY,ERROR)
      IF(ERROR) GO TO 60
      GO TO 900
C
 70   LGSCPL = .NOT.LGSCPL
      IF(     LGSCPL) WRITE(*,*) 'Perturbations will be plotted'
      IF(.NOT.LGSCPL) WRITE(*,*) 'Perturbations will not be plotted'
      GO TO 900
C
 80   IPTARG = 999
      CALL TARGET(NEWTAR)
      IF(NEWTAR) THEN
       LXHES = .FALSE.
       LPRSET = .TRUE.
      ENDIF
      GO TO 900
C
      END ! SCALES



      SUBROUTINE GSCNEW(NDELX,NDEL,NP,GSC,DEL,DELNAM,CHANGE)
C---------------------------------------------------------
C     Displays current parameter scales, requests
C     new values, and plots resulting perturbations.
C
C      NDEL(p)   number of parameters per point (i.e. NMOD, NPOS)
C      NP        number of points
C      GSC(k)    parameter scale (same over all points)
C      DEL(k,p)  parameter changes
C      DELNAM(k) parameter name
C      CHANGE    returned T if change was made
C---------------------------------------------------------
      INCLUDE 'LINDOP.INC'
      DIMENSION NDEL(NP)
      DIMENSION GSC(NDELX),DEL(NDELX,NP)
      CHARACTER*5 DELNAM
      LOGICAL CHANGE
C
C---- find max number of modes over all requested operating points
      NDELMX = NDEL(1)
      DO 5 IP=2, NP
        NDELMX = MAX(NDELMX,NDEL(IP))
 5    CONTINUE
      IF(NDELMX .EQ. 0) RETURN
C
      WRITE(*,1100) DELNAM
C
      CHANGE = .FALSE.
C
C---- go over passed-in parameter classes
      DO 100 K=1, NDELMX
C
C------ set perturbation factor for this parameter class
 11     DELFAC = 1.0/GSC(K)**2
C
        IF(LGSCPL) THEN
C
C------- set perturbation(s)
         DO 12 IP=1, NP
           DEL(K,IP) = DELTRY*DELFAC
 12      CONTINUE
C
C------- plot perturbed solution
         CALL PLTINI
         CALL PLTALL(.TRUE.)
C
C------- restore parameter perturbation(s)
         DO 14 IP=1, NP
           DEL(K,IP) = 0.
 14      CONTINUE
C
        ENDIF
C
C------ display current scale and possibly get new value
 20     IF(NDELMX.EQ.1) THEN
         IF(DELFAC .LE. 99999.0) WRITE(*,1500) DELNAM,    DELFAC
         IF(DELFAC .GT. 99999.0) WRITE(*,1501) DELNAM,    DELFAC
        ELSE
         IF(DELFAC .LE. 99999.0) WRITE(*,1510) DELNAM, K, DELFAC
         IF(DELFAC .GT. 99999.0) WRITE(*,1511) DELNAM, K, DELFAC
        ENDIF
        READ (*,1000) LINE
C
        IF(LINE(1:1) .NE. ' ') THEN
C-------- something was input
          READ(LINE,*,ERR=20) DELFAC
          IF(DELFAC .NE. 0.0) THEN
            GSC(K) = 1.0/SQRT(ABS(DELFAC))
            CHANGE = .TRUE.
          ELSE
            RETURN
          ENDIF
C
          IF(DELFAC .LT. 0.0) THEN
C---------- perturb parameter
 31         DELFAC = 1.0/GSC(K)**2
            DO 32 IP=1, NP
              DEL(K,IP) = DELTRY*DELFAC
 32         CONTINUE
C
            CALL PLTINI
            CALL PLTALL(.TRUE.)
C
C---------- restore parameter
            DO 34 IP=1, NP
              DEL(K,IP) = 0.
 34         CONTINUE
C
            DELFAC = ABS(DELFAC)
            GO TO 20
          ENDIF
        ENDIF
C
 100  CONTINUE
      RETURN
C..........................................................
 1000 FORMAT(A)
 1100 FORMAT(/' Input new ',A,' scale (0 = Exit, -scale = Replot) ...')
 1500 FORMAT(1X,A,   ':',F12.5,'   ',$)
 1501 FORMAT(1X,A,   ':',G15.5,'   ',$)
 1510 FORMAT(1X,A,I3,':',F12.5,'   ',$)
 1511 FORMAT(1X,A,I3,':',G12.5,'   ',$)
      END ! GSCNEW


      SUBROUTINE GSCSHO
      INCLUDE 'LINDOP.INC'
C
      WPSUM = 0.
      DO 4 IP=1, NPOINT
        WPSUM = WPSUM + WP(IP)
 4    CONTINUE
      IF(WPSUM .EQ. 0.0) WPSUM = 1.0
C
      WRITE(*,1000) DELTRY
 1000 FORMAT(
     & /1X,' Perturbation step:', F10.5,
     & /1X,'                             ___________changes___________',
     & /1X,'Parameter       scale           CL        CD         Fuser')
C            dMod  1       0.10000       0.01234   0.001234    0.012345
C            dAlfa         0.10000       0.01234   0.001234    0.012345
 1100 FORMAT( 1X,1X,A5, I2, G16.5, 2X, F10.5, F11.6, F12.6)
 1200 FORMAT( 1X,1X,A5, 2X, G16.5, 2X, F10.5, F11.6, F12.6)
C
      DO 10 K=1, NMODMX
        IF(LNKMOD .OR. IPTARG.EQ.0) THEN
         DO 101 IP=1, NPOINT
           DMOD(K,IP) = DELTRY/GSCMOD(K)**2
 101     CONTINUE
        ELSE
         DMOD(K,IPTARG) = DELTRY/GSCMOD(K)**2
        ENDIF
C
        DCL = 0.
        DCD = 0.
        DO 104 IP=1, NPOINT
          DCL = DCL + CL_MOD(K,IP)*DMOD(K,IP) * WP(IP)/WPSUM
          DCD = DCD + CD_MOD(K,IP)*DMOD(K,IP) * WP(IP)/WPSUM
 104    CONTINUE
C
        CALL FUCALC(0,FUNC)
        DFU = FUNMOD - FUNC
        WRITE(*,1100) 'dMod ', K, 1.0/GSCMOD(K)**2, DCL, DCD, DFU
C
        DO 106 IP=1, NPOINT
          DMOD(K,IP) = 0.
 106    CONTINUE
 10   CONTINUE
C
      DO 20 K=1, NPOSMX
        IF(LNKPOS .OR. IPTARG.EQ.0) THEN
         DO 201 IP=1, NPOINT
           DPOS(K,IP) = DELTRY/GSCPOS(K)**2
 201     CONTINUE
        ELSE
         DPOS(K,IPTARG) = DELTRY/GSCPOS(K)**2
        ENDIF
C
        DCL = 0.
        DCD = 0.
        DO 204 IP=1, NPOINT
          DCL = DCL + CL_POS(K,IP)*DPOS(K,IP) * WP(IP)/WPSUM
          DCD = DCD + CD_POS(K,IP)*DPOS(K,IP) * WP(IP)/WPSUM
 204    CONTINUE
C
        CALL FUCALC(0,FUNC)
        DFU = FUNMOD - FUNC
        WRITE(*,1100) 'dPos ', K, 1.0/GSCPOS(K)**2, DCL, DCD, DFU
C
        DO 206 IP=1, NPOINT
          DPOS(K,IP) = 0.
 206    CONTINUE
 20   CONTINUE
C
C---- set flags to see if any alpha,Ma,Re variables are available
      KALMAX = KALFA(1)
      KMAMAX = KMACH(1)
      KREMAX = KREYN(1)
      DO 28 IP=1, NPOINT
        KALMAX = MAX(KALMAX,KALFA(IP))
        KMAMAX = MAX(KMAMAX,KMACH(IP))
        KREMAX = MAX(KREMAX,KREYN(IP))
 28   CONTINUE
C
      IF(KALMAX.GT.0) THEN
       DCL = 0.
       DCD = 0.
       DO 30 IP=1, NPOINT
         DALFA(IP) = DELTRY/GSCAL**2
         DCL = DCL + CL_ALFA(IP)*DALFA(IP) * WP(IP)/WPSUM
         DCD = DCD + CD_ALFA(IP)*DALFA(IP) * WP(IP)/WPSUM
 30    CONTINUE
       CALL FUCALC(0,FUNC)
       DFU = FUNMOD - FUNC
       WRITE(*,1200) 'dAlfa', 1.0/GSCAL**2, DCL, DCD, DFU
C
       DO 32 IP=1, NPOINT
         DALFA(IP) = 0.
 32    CONTINUE
      ENDIF
C
      IF(KMAMAX.GT.0) THEN
       DCL = 0.
       DCD = 0.
       DO 40 IP=1, NPOINT
         DMACH(IP) = DELTRY/GSCMA**2
         DCL = DCL + CL_MACH(IP)*DMACH(IP) * WP(IP)/WPSUM
         DCD = DCD + CD_MACH(IP)*DMACH(IP) * WP(IP)/WPSUM
 40    CONTINUE
       CALL FUCALC(0,FUNC)
       DFU = FUNMOD - FUNC
       WRITE(*,1200) 'dMach', 1.0/GSCMA**2, DCL, DCD, DFU
C
       DO 42 IP=1, NPOINT
         DMACH(IP) = 0.
 42    CONTINUE
      ENDIF
C
      IF(KREMAX.GT.0) THEN
       DCL = 0.
       DCD = 0.
       DO 50 IP=1, NPOINT
         DLNRE(IP) = DELTRY/GSCLR**2
         DCL = DCL + CL_REYN(IP)*DLNRE(IP)*REYN(IP) * WP(IP)/WPSUM
         DCD = DCD + CD_REYN(IP)*DLNRE(IP)*REYN(IP) * WP(IP)/WPSUM
 50    CONTINUE
       CALL FUCALC(0,FUNC)
       DFU = FUNMOD - FUNC
       WRITE(*,1200) 'dlnRe', 1.0/GSCLR**2, DCL, DCD, DFU
C
       DO 52 IP=1, NPOINT
         DLNRE(IP) = 0.
 52    CONTINUE
      ENDIF
C
      DCL = 0.
      DCD = 0.
      DO 80 K=1, NUPAR
        DUPAR(K) = DELTRY/GSCUP(K)**2
        CALL FUCALC(0,FUNC)
        DFU = FUNMOD - FUNC
        WRITE(*,1100) 'dXusr', K, 1.0/GSCUP(K)**2, DCL, DCD, DFU
        DUPAR(K) = 0.
 80   CONTINUE
C
      RETURN
      END ! GSCSHO

