
      SUBROUTINE UFTEST(IPNT)
      INCLUDE 'LINDOP.INC'
C----------------------------------------------------
C     Tests user-constraint routine linearizations.
C----------------------------------------------------
      LOGICAL ERROR
      DIMENSION
     &   UF_MACH(NPX), 
     &   UF_ALFA(NPX), 
     &   UF_REYN(NPX),
     &   UF_MOD(NMODX,NPX),
     &   UF_POS(NPOSX,NPX),
     &   UF_CL(NPX) ,
     &   UF_CM(NPX) ,
     &   UF_CDF(NPX),
     &   UF_CDP(NPX),
     &   UF_ARB(NBX),
     &   UF_EI1(NBX),
     &   UF_ASG(NBX),
     &   UF_UPAR(NUPX),
C
     &   UF_MACH$(NPX), 
     &   UF_ALFA$(NPX), 
     &   UF_REYN$(NPX),
     &   UF_MOD$(NMODX,NPX),
     &   UF_POS$(NPOSX,NPX),
     &   UF_CL$(NPX) ,
     &   UF_CM$(NPX) ,
     &   UF_CDF$(NPX),
     &   UF_CDP$(NPX),
     &   UF_ARB$(NBX),
     &   UF_EI1$(NBX),
     &   UF_ASG$(NBX),
     &   UF_UPAR$(NUPX),
C
     &   UPAR$(NUPX),
C
     &   ALFA$(NPX),
     &   MACH$(NPX),
     &   REYN$(NPX),
     &   CL$(NPX),
     &   CDF$(NPX),
     &   CDP$(NPX),
     &   CM$(NPX),
C
     &   MODN$(NMODX,NPX),
C
     &   POSN$(NPOSX,NPX),
C
     &   AREAB$(NBX),
     &   EI11B$(NBX),
     &   ASIGB$(NBX)
C
      DATA EPS / 0.001 /
C
      WRITE(*,1005) EPS
 1005 FORMAT(/' Enter perturbation epsilon:',F12.6)
      CALL READR(1,EPS,ERROR)
C
C---- geometry parameters taken from point IPGSEN
      IPG = IPGSEN
C
C---- operating point for which objective function is defined
      IP = IPNT
C
C---- initialize all perturbed variables < >$  to baseline values
      DO 1 IU=1, NUPAR
        UPAR$(IU) = UPAR(IU)
 1    CONTINUE
C
ccc      DO 2 IP=1, NPOINT
        ALFA$(IP) = ALFA(IP)
        MACH$(IP) = MACH(IP)
        REYN$(IP) = REYN(IP)
        CL$(IP)  = CL(IP)
        CDF$(IP) = CDF(IP)
        CDP$(IP) = CDP(IP)
        CM$(IP)  = CM(IP)
C
        DO 210 K=1, NMOD(IP)
          MODN$(K,IP) = MODN(K,IP)
 210    CONTINUE
        DO 220 K=1, NPOS(IP)
          POSN$(K,IP) = POSN(K,IP)
 220    CONTINUE
ccc 2    CONTINUE
C
      DO 3 N=1, NBL(IPG)
        AREAB$(N) = AREAB(N,IPG)
        EI11B$(N) = EI11B(N,IPG)
        ASIGB$(N) = ASIGB(N,IPG)
 3    CONTINUE
C
C
C---- set baseline objective function UF and baseline derivatives
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF,
     &            UPAR    , UF_UPAR,
     &            MACH(IP), UF_MACH(IP),
     &            CL(IP)  , UF_CL(IP) ,
     &            CDF(IP) , UF_CDF(IP),
     &            CDP(IP) , UF_CDP(IP),
     &            CM(IP)  , UF_CM(IP) ,
     &            AREAB(1,IPG), UF_ARB,
     &            EI11B(1,IPG), UF_EI1,
     &            ASIGB(1,IPG), UF_ASG )
C
C
C---- perturb all user parameters
      DO 10 IU=1, NUPAR
        DEL = UPAR(IU)*EPS
        UPAR$(IU) = UPAR(IU) + DEL
        CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &              UPAR$   , UF_UPAR$,
     &              MACH(IP), UF_MACH(IP) ,
     &              CL(IP)  , UF_CL(IP)  ,
     &              CDF(IP) , UF_CDF(IP) ,
     &              CDP(IP) , UF_CDP(IP) ,
     &              CM(IP)  , UF_CM(IP)  ,
     &              AREAB(1,IPG) , UF_ARB ,
     &              EI11B(1,IPG) , UF_EI1 ,
     &              ASIGB(1,IPG) , UF_ASG )
        UPAR$(IU) = UPAR(IU)
        IF(UF$ .NE. UF) 
     &  WRITE(*,1010) UPNAME(IU),IU,(UF_UPAR$(IU)+UF_UPAR(IU))*0.5,
     &                UPAR(IU)     ,(UF$         -UF         )/DEL
 10   CONTINUE
C
C
C---- perturb Mach number
      DEL = EPS
      MACH$(IP) = MACH(IP) + DEL
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &            UPAR     , UF_UPAR,
     &            MACH$(IP), UF_MACH$(IP) ,
     &            CL(IP)   , UF_CL(IP)  ,
     &            CDF(IP)  , UF_CDF(IP) ,
     &            CDP(IP)  , UF_CDP(IP) ,
     &            CM(IP)   , UF_CM(IP)  ,
     &            AREAB(1,IPG) , UF_ARB ,
     &            EI11B(1,IPG) , UF_EI1 ,
     &            ASIGB(1,IPG) , UF_ASG )
      MACH$(IP) = MACH(IP)
      IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'MACH    ',IP,(UF_MACH$(IP)+UF_MACH(IP))*0.5,
     &                MACH(IP)     ,(UF$         -UF         )/DEL
C
C
C
      DEL = EPS
      CL$(IP) = CL(IP) + DEL
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &            UPAR    , UF_UPAR,
     &            MACH(IP), UF_MACH(IP) ,
     &            CL$(IP) , UF_CL$(IP)  ,
     &            CDF(IP) , UF_CDF(IP) ,
     &            CDP(IP) , UF_CDP(IP) ,
     &            CM(IP)  , UF_CM(IP)  ,
     &            AREAB(1,IPG) , UF_ARB ,
     &            EI11B(1,IPG) , UF_EI1 ,
     &            ASIGB(1,IPG) , UF_ASG )
      CL$(IP) = CL(IP)
      IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'CL      ',IP,(UF_CL$(IP)+UF_CL(IP))*0.5,
     &                 CL(IP)      ,(UF$       -UF       )/DEL
C
C
      DEL = (CDF(IP)+CDP(IP))*EPS
      CDF$(IP) = CDF(IP) + DEL
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &            UPAR    , UF_UPAR,
     &            MACH(IP), UF_MACH(IP) ,
     &            CL(IP)  , UF_CL(IP)  ,
     &            CDF$(IP), UF_CDF$(IP) ,
     &            CDP(IP) , UF_CDP(IP) ,
     &            CM(IP)  , UF_CM(IP)  ,
     &            AREAB(1,IPG) , UF_ARB ,
     &            EI11B(1,IPG) , UF_EI1 ,
     &            ASIGB(1,IPG) , UF_ASG )
      CDF$(IP) = CDF(IP)
      IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'CDF     ',IP,(UF_CDF$(IP)+UF_CDF(IP))*0.5,
     &                 CDF(IP)     ,(UF$        -UF        )/DEL
C
C
      DEL = (CDF(IP)+CDP(IP))*EPS
      CDP$(IP) = CDP(IP) + DEL
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &            UPAR    , UF_UPAR,
     &            MACH(IP), UF_MACH(IP) ,
     &            CL(IP)  , UF_CL(IP)  ,
     &            CDF(IP) , UF_CDF(IP) ,
     &            CDP$(IP), UF_CDP$(IP) ,
     &            CM(IP)  , UF_CM(IP)  ,
     &            AREAB(1,IPG) , UF_ARB ,
     &            EI11B(1,IPG) , UF_EI1 ,
     &            ASIGB(1,IPG) , UF_ASG )
      CDP$(IP) = CDP(IP)
      IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'CDP     ',IP,(UF_CDP$(IP)+UF_CDP(IP))*0.5,
     &                 CDP(IP)     ,(UF$        -UF        )/DEL
C
C
      DEL = EPS
      CM$(IP) = CM(IP) + DEL
      CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &            UPAR    , UF_UPAR,
     &            MACH(IP), UF_MACH(IP) ,
     &            CL(IP)  , UF_CL(IP)  ,
     &            CDF(IP) , UF_CDF(IP) ,
     &            CDP(IP) , UF_CDP(IP) ,
     &            CM$(IP) , UF_CM$(IP)  ,
     &            AREAB(1,IPG) , UF_ARB ,
     &            EI11B(1,IPG) , UF_EI1 ,
     &            ASIGB(1,IPG) , UF_ASG )
      CM$(IP) = CM(IP)
      IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'CM      ',IP,(UF_CM$(IP)+UF_CM(IP))*0.5,
     &                 CM(IP)      ,(UF$       -UF       )/DEL
C
C
      DO 41 N=1, NBL(IPG)
        DEL = AREAB(N,IPG)*EPS
        AREAB$(N) = AREAB(N,IPG) + DEL
        CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &              UPAR    , UF_UPAR,
     &              MACH(IP), UF_MACH(IP) ,
     &              CL(IP)  , UF_CL(IP)  ,
     &              CDF(IP) , UF_CDF(IP) ,
     &              CDP(IP) , UF_CDP(IP) ,
     &              CM(IP)  , UF_CM(IP)  ,
     &              AREAB$(1) , UF_ARB$ ,
     &              EI11B(1,IPG) , UF_EI1 ,
     &              ASIGB(1,IPG) , UF_ASG )
        AREAB$(N) = AREAB(N,IPG)
        IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'AREA    ', N,(UF_ARB$(N)+UF_ARB(N))*0.5,
     &                 AREAB(N,IPG),(UF$       -UF       )/DEL
 41   CONTINUE
C
C
      DO 42 N=1, NBL(IPG)
        DEL = EI11B(N,IPG)*EPS
        EI11B$(N) = EI11B(N,IPG) + DEL
        CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &              UPAR    , UF_UPAR,
     &              MACH(IP), UF_MACH(IP) ,
     &              CL(IP)  , UF_CL(IP)  ,
     &              CDF(IP) , UF_CDF(IP) ,
     &              CDP(IP) , UF_CDP(IP) ,
     &              CM(IP)  , UF_CM(IP)  ,
     &              AREAB(1,IPG) , UF_ARB ,
     &              EI11B$(1) , UF_EI1$ ,
     &              ASIGB(1,IPG) , UF_ASG )
        EI11B$(N) = EI11B(N,IPG)
        IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'EI11    ',N,(UF_EI1$(N)+UF_EI1(N))*0.5,
     &                 EI11B(N,IPG),(UF$-UF)/DEL
 42   CONTINUE
C
C
C
      DO 43 N=1, NBL(IPG)
        DEL = ASIGB(N,IPG)*EPS
        ASIGB$(N) = ASIGB(N,IPG) + DEL
        CALL USRFUN(NBL(IPG),NUPAR,IPNT, UF$,
     &              UPAR    , UF_UPAR,
     &              MACH(IP), UF_MACH(IP) ,
     &              CL(IP)  , UF_CL(IP)  ,
     &              CDF(IP) , UF_CDF(IP) ,
     &              CDP(IP) , UF_CDP(IP) ,
     &              CM(IP)  , UF_CM(IP)  ,
     &              AREAB(1,IPG) , UF_ARB ,
     &              EI11B(1,IPG) , UF_EI1 ,
     &              ASIGB$(1) , UF_ASG$ )
        ASIGB$(N) = ASIGB(N,IPG)
        IF(UF$ .NE. UF) 
     &  WRITE(*,1010) 'ASIG    ',N,(UF_ASG$(N)+UF_ASG(N))*0.5,
     &                 ASIGB(N,IPG),(UF$-UF)/DEL
 43   CONTINUE
C
      WRITE(*,*)
      RETURN
C
 1010 FORMAT(/1X,A8,2X,I2,E16.6, '   analytic   '
     &       /1X,F12.4   ,E16.6, '   differenced' )
      END ! UFTEST



      SUBROUTINE UCTEST(ICON)
      INCLUDE 'LINDOP.INC'
C----------------------------------------------------
C     Tests user-constraint routine linearizations.
C----------------------------------------------------
      LOGICAL ERROR
      DIMENSION
     &   UC_MACH(NPX), 
     &   UC_ALFA(NPX), 
     &   UC_REYN(NPX),
     &   UC_MOD(NMODX,NPX),
     &   UC_POS(NPOSX,NPX),
     &   UC_CL(NPX) ,
     &   UC_CM(NPX) ,
     &   UC_CDF(NPX),
     &   UC_CDP(NPX),
     &   UC_ARB(NBX),
     &   UC_EI1(NBX),
     &   UC_ASG(NBX),
     &   UC_UPAR(NUPX),
C
     &   UC_MACH$(NPX), 
     &   UC_ALFA$(NPX), 
     &   UC_REYN$(NPX),
     &   UC_MOD$(NMODX,NPX),
     &   UC_POS$(NPOSX,NPX),
     &   UC_CL$(NPX) ,
     &   UC_CM$(NPX) ,
     &   UC_CDF$(NPX),
     &   UC_CDP$(NPX),
     &   UC_ARB$(NBX),
     &   UC_EI1$(NBX),
     &   UC_ASG$(NBX),
     &   UC_UPAR$(NUPX),
C
     &   UPAR$(NUPX),
C
     &   ALFA$(NPX),
     &   MACH$(NPX),
     &   REYN$(NPX),
     &   CL$(NPX),
     &   CDF$(NPX),
     &   CDP$(NPX),
     &   CM$(NPX),
C
     &   MODN$(NMODX,NPX),
C
     &   POSN$(NPOSX,NPX),
C
     &   AREAB$(NBX),
     &   EI11B$(NBX),
     &   ASIGB$(NBX)
C
      DATA EPS / 0.001 /
C
      WRITE(*,1005) EPS
 1005 FORMAT(/' Enter perturbation epsilon:',F12.6)
      CALL READR(1,EPS,ERROR)
C
      IPG = IPGSEN
C
      DO 1 IU=1, NUPAR
        UPAR$(IU) = UPAR(IU)
 1    CONTINUE
C
      DO 2 IP=1, NPOINT
        ALFA$(IP) = ALFA(IP)
        MACH$(IP) = MACH(IP)
        REYN$(IP) = REYN(IP)
        CL$(IP)  = CL(IP)
        CDF$(IP) = CDF(IP)
        CDP$(IP) = CDP(IP)
        CM$(IP)  = CM(IP)
C
        DO 210 K=1, NMOD(IP)
          MODN$(K,IP) = MODN(K,IP)
 210    CONTINUE
        DO 220 K=1, NPOS(IP)
          POSN$(K,IP) = POSN(K,IP)
 220    CONTINUE
 2    CONTINUE
C
      DO 3 N=1, NBL(IPG)
        AREAB$(N) = AREAB(N,IPG)
        EI11B$(N) = EI11B(N,IPG)
        ASIGB$(N) = ASIGB(N,IPG)
 3    CONTINUE
C

C---- test-call each constraint, set maximum available-constraint number
ccc      DO 100 ICON=1, NUCON
C
        WRITE(*,*)
        WRITE(*,*) '========================================'
        WRITE(*,*) 'Constraint: ', UCNAME(ICON)
        ICONT = ICON
        CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &              NMODX,NMOD,NPOSX,NPOS,
     &              ICONT,UCNAME(ICON), 
     &                    UCR,
     &              UPAR, UC_UPAR,
     &              ALFA, UC_ALFA,
     &              MACH, UC_MACH,
     &              REYN, UC_REYN,
     &              CL , UC_CL ,
     &              CDF, UC_CDF,
     &              CDP, UC_CDP,
     &              CM , UC_CM ,
     &              AREAB(1,IPG), UC_ARB,
     &              EI11B(1,IPG), UC_EI1,
     &              ASIGB(1,IPG), UC_ASG,
     &              MODN , UC_MOD,
     &              POSN , UC_POS )
        IF(ICONT.EQ.0) THEN
          WRITE(*,*) 'Constraint', ICON, '  not defined.'
          RETURN
        ENDIF
C
        DO 10 IU=1, NUPAR
          DEL = UPAR(IU)*EPS
          UPAR$(IU) = UPAR(IU) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR$,UC_UPAR$,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          UPAR$(IU) = UPAR(IU)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) UPNAME(IU),IU,(UC_UPAR$(IU)+UC_UPAR(IU))*0.5,
     &                  UPAR(IU)     ,(UCR$-UCR  )/DEL
 10     CONTINUE
C
C
        DO 21 IP=1, NPOINT
          DEL = EPS
          ALFA$(IP) = ALFA(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA$ , UC_ALFA$ ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          ALFA$(IP) = ALFA(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'ALFA    ',IP,(UC_ALFA$(IP)+UC_ALFA(IP))*0.5,
     &                  ALFA(IP)     ,(UCR$-UCR)/DEL
 21     CONTINUE
C
C
C
        DO 22 IP=1, NPOINT
          DEL = EPS
          MACH$(IP) = MACH(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH$ , UC_MACH$ ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          MACH$(IP) = MACH(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'MACH    ',IP,(UC_MACH$(IP)+UC_MACH(IP))*0.5,
     &                  MACH(IP)     ,(UCR$-UCR)/DEL
 22     CONTINUE
C
C
C
        DO 23 IP=1, NPOINT
          DEL = REYN(IP)*EPS
          REYN$(IP) = REYN(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN$ , UC_REYN$ ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          REYN$(IP) = REYN(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'REYN    ',IP,(UC_REYN$(IP)+UC_REYN(IP))*0.5,
     &                  REYN(IP)     ,(UCR$-UCR)/DEL
 23       CONTINUE
C
C
        DO 31 IP=1, NPOINT
          DEL = EPS
          CL$(IP) = CL(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL$  , UC_CL$  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          CL$(IP) = CL(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'CL      ',IP,(UC_CL$(IP)+UC_CL(IP))*0.5,
     &                   CL(IP)      ,(UCR$-UCR)/DEL
 31     CONTINUE
C
C
        DO 32 IP=1, NPOINT
          DEL = (CDF(IP)+CDP(IP))*EPS
          CDF$(IP) = CDF(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF$ , UC_CDF$ ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          CDF$(IP) = CDF(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'CDF     ',IP,(UC_CDF$(IP)+UC_CDF(IP))*0.5,
     &                   CDF(IP)     ,(UCR$-UCR)/DEL
 32     CONTINUE
C
C
        DO 33 IP=1, NPOINT
          DEL = (CDF(IP)+CDP(IP))*EPS
          CDP$(IP) = CDP(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP$ , UC_CDP$ ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          CDP$(IP) = CDP(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'CDP     ',IP,(UC_CDP$(IP)+UC_CDP(IP))*0.5,
     &                   CDP(IP)     ,(UCR$-UCR)/DEL
 33     CONTINUE
C
C
        DO 34 IP=1, NPOINT
          DEL = EPS
          CM$(IP) = CM(IP) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM$  , UC_CM$  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          CM$(IP) = CM(IP)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'CM      ',IP,(UC_CM$(IP)+UC_CM(IP))*0.5,
     &                   CM(IP)      ,(UCR$-UCR)/DEL
 34     CONTINUE
C
C
        DO 41 N=1, NBL(IPG)
          DEL = AREAB(N,IPG)*EPS
          AREAB$(N) = AREAB(N,IPG) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB$(1) , UC_ARB$ ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          AREAB$(N) = AREAB(N,IPG)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'AREA    ',N,(UC_ARB$(N)+UC_ARB(N))*0.5,
     &                   AREAB(N,IPG),(UCR$-UCR)/DEL
 41     CONTINUE
C
C
        DO 42 N=1, NBL(IPG)
          DEL = EI11B(N,IPG)*EPS
          EI11B$(N) = EI11B(N,IPG) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B$(1) , UC_EI1$ ,
     &                ASIGB(1,IPG) , UC_ASG ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          EI11B$(N) = EI11B(N,IPG)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'EI11    ',N,(UC_EI1$(N)+UC_EI1(N))*0.5,
     &                   EI11B(N,IPG),(UCR$-UCR)/DEL
 42     CONTINUE
C
C
C
        DO 43 N=1, NBL(IPG)
          DEL = ASIGB(N,IPG)*EPS
          ASIGB$(N) = ASIGB(N,IPG) + DEL
          ICONT = ICON
          CALL USRCON(NBL(IPG),NUPX,NUPAR,NPX,NPOINT,
     &                NMODX,NMOD,NPOSX,NPOS,
     &                ICONT,UCNAME(ICON), 
     &                      UCR$,
     &                UPAR,UC_UPAR,
     &                ALFA , UC_ALFA ,
     &                MACH , UC_MACH ,
     &                REYN , UC_REYN ,
     &                CL  , UC_CL  ,
     &                CDF , UC_CDF ,
     &                CDP , UC_CDP ,
     &                CM  , UC_CM  ,
     &                AREAB(1,IPG) , UC_ARB ,
     &                EI11B(1,IPG) , UC_EI1 ,
     &                ASIGB$(1) , UC_ASG$ ,
     &                MODN  , UC_MOD ,
     &                POSN  , UC_POS  )
          ASIGB$(N) = ASIGB(N,IPG)
          IF(UCR$ .NE. UCR) 
     &    WRITE(*,1010) 'ASIG    ',N,(UC_ASG$(N)+UC_ASG(N))*0.5,
     &                   ASIGB(N,IPG),(UCR$-UCR)/DEL
 43     CONTINUE
C
C
C
ccc 100  CONTINUE
C
      WRITE(*,*)
      RETURN
C
 1010 FORMAT(/1X,A8,2X,I2,E16.6, '   analytic   '
     &       /1X,F12.4   ,E16.6, '   differenced' )

      END ! UCTEST
