
      SUBROUTINE UFDIFF(NTHX,NBX, NBL,NUPAR, NPOINT, 
     &            WP, FUN, 
     &            UPAR, FUN_UPAR, EPUPAR,
     &            ALFA, FUN_ALFA,
     &            MACH, FUN_MACH,
     &            REYN, FUN_REYN,
     &            CL  , FUN_CL  ,
     &            CDF , FUN_CDF ,
     &            CDP , FUN_CDP ,
     &            CM  , FUN_CM  ,
     &            ARB , FUN_ARB ,
     &            EI1 , FUN_EI1 ,
     &            ASG , FUN_ASG ,
     &            THB , FUN_THB  )
C----------------------------------------------------
C     Differentiates user objective function.
C----------------------------------------------------
      IMPLICIT REAL (A-H,M,O-Z)
C
      DIMENSION NBL(*)
      DIMENSION WP(*)
C
      DIMENSION UPAR(*), FUN_UPAR(*), EPUPAR(*)
C
      DIMENSION ALFA(*), FUN_ALFA(*),
     &          MACH(*), FUN_MACH(*),
     &          REYN(*), FUN_REYN(*),
     &          CL  (*), FUN_CL  (*),
     &          CDF (*), FUN_CDF (*),
     &          CDP (*), FUN_CDP (*),
     &          CM  (*), FUN_CM  (*)
C
      DIMENSION ARB(NBX,*), FUN_ARB(NBX,*),
     &          EI1(NBX,*), FUN_EI1(NBX,*),
     &          ASG(NBX,*), FUN_ASG(NBX,*),
     &          THB(0:NTHX,NBX,*), FUN_THB(0:NTHX,NBX,*)
C
C
C---- local arrays for calling USRFUN
      PARAMETER (NUPY=100,NPY=10,NBY=10,NTHY=3)
      DIMENSION UPAR_(NUPY)
      DIMENSION ALFA_(NPY),
     &          MACH_(NPY),
     &          REYN_(NPY),
     &          CL_  (NPY),
     &          CDF_ (NPY),
     &          CDP_ (NPY),
     &          CM_  (NPY)
      DIMENSION ARB_(NBY,NPY),
     &          EI1_(NBY,NPY),
     &          ASG_(NBY,NPY),
     &          THB_(0:NTHY,NBY,NPY)
C
      DATA EPS / 0.001 /
C
      IF(NUPAR .GT.NUPY) STOP 'UFDIFF: Array overflow. NUPY too small.'
      IF(NPOINT.GT.NPY ) STOP 'UFDIFF: Array overflow. NPY  too small.'
      IF(NBX   .GT.NBY ) STOP 'UFDIFF: Array overflow. NBY  too small.'
      IF(NTHX  .GT.NTHY) STOP 'UFDIFF: Array overflow. NTHY too small.'
C
      WPSUM = 0.0
      DO IP=1, NPOINT
        WPSUM = WPSUM + ABS(WP(IP))
      ENDDO
      IF(WPSUM.EQ.0.0) WPSUM = 1.0
C
C---- initialize all perturbed variables < >_  to baseline values
      DO IU=1, NUPAR
        UPAR_(IU) = UPAR(IU)
      ENDDO
C
      DO IP=1, NPOINT
        ALFA_(IP) = ALFA(IP)
        MACH_(IP) = MACH(IP)
        REYN_(IP) = REYN(IP)
        CL_  (IP) = CL  (IP)
        CDF_ (IP) = CDF (IP)
        CDP_ (IP) = CDP (IP)
        CM_  (IP) = CM  (IP)
        DO N=1, NBL(IP)
          ARB_(N,IP) = ARB(N,IP)
          EI1_(N,IP) = EI1(N,IP)
          ASG_(N,IP) = ASG(N,IP)
          DO KT=0, NTHX
            THB_(KT,N,IP) = THB(KT,N,IP)
          ENDDO
        ENDDO
      ENDDO
C
C---- set objective function value FUN
      CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, FUN, 
     &            UPAR,
     &            ALFA,
     &            MACH,
     &            REYN,
     &            CL ,
     &            CDF,
     &            CDP,
     &            CM ,
     &            ARB,
     &            EI1,
     &            ASG,
     &            THB )
C
C---- perturb all user parameters
      DO 10 IU=1, NUPAR
        DEL = EPUPAR(IU)
        IF(DEL .EQ. 0.0) DEL = EPS*UPAR(IU)
C
        UPAR_(IU) = UPAR(IU) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR_,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
C
        UPAR_(IU) = UPAR(IU) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR_,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        UPAR_(IU) = UPAR(IU)
C
        FUN_UPAR(IU) = 0.5*(UF2 - UF1) / DEL
 10   CONTINUE
C
C
      DO 100 IP = 1, NPOINT
C------ perturb alpha
        DEL = EPS
        ALFA_(IP) = ALFA(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA_,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        ALFA_(IP) = ALFA(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA_,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        ALFA_(IP) = ALFA(IP)
        FUN_ALFA(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb Mach number
        DEL = EPS
        MACH_(IP) = MACH(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH_,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        MACH_(IP) = MACH(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH_,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        MACH_(IP) = MACH(IP)
        FUN_MACH(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb Reynolds number
        DEL = EPS*REYN(IP)
        REYN_(IP) = REYN(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN_,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        REYN_(IP) = REYN(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN_,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        REYN_(IP) = REYN(IP)
        FUN_REYN(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb CL
        DEL = EPS
        CL_(IP) = CL(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL_  ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CL_(IP) = CL(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL_  ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CL_(IP) = CL(IP)
        FUN_CL(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb CDF
        DEL = ABS(CDF(IP)*EPS)
        DEL = MAX(DEL,0.000001)
        DEL = EPS
        CDF_(IP) = CDF(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF_ ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CDF_(IP) = CDF(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF_ ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CDF_(IP) = CDF(IP)
        FUN_CDF(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb CDP
        DEL = ABS(CDP(IP)*EPS)
        DEL = MAX(DEL,0.000001)
        DEL = EPS
        CDP_(IP) = CDP(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP_ ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CDP_(IP) = CDP(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP_ ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CDP_(IP) = CDP(IP)
        FUN_CDP(IP) = 0.5*(UF2 - UF1) / DEL
C
C------ perturb CM
        DEL = EPS
        CM_(IP) = CM(IP) - DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM_  ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CM_(IP) = CM(IP) + DEL
        CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM_  ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
        CM_(IP) = CM(IP)
        FUN_CM(IP) = 0.5*(UF2 - UF1) / DEL
C
        DO 20 N=1, NBL(IP)
C-------- perturb ARB
          DEL = ABS(EPS*ARB(N,IP))
          DEL = MAX(DEL,0.00000001)
          ARB_(N,IP) = ARB(N,IP) - DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB_ ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
          ARB_(N,IP) = ARB(N,IP) + DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB_ ,
     &            EI1  ,
     &            ASG  ,
     &            THB   )
          ARB_(N,IP) = ARB(N,IP)
          FUN_ARB(N,IP) = 0.5*(UF2 - UF1) / DEL
C
C-------- perturb EI1
          DEL = ABS(EPS*EI1(N,IP))
          DEL = MAX(DEL,0.00000001)
          EI1_(N,IP) = EI1(N,IP) - DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1_ ,
     &            ASG  ,
     &            THB   )
          EI1_(N,IP) = EI1(N,IP) + DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1_ ,
     &            ASG  ,
     &            THB   )
          EI1_(N,IP) = EI1(N,IP)
          FUN_EI1(N,IP) = 0.5*(UF2 - UF1) / DEL
C
C-------- perturb ASG
          DEL = ABS(EPS*ASG(N,IP))
          DEL = MAX(DEL,0.00000001)
          ASG_(N,IP) = ASG(N,IP) - DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG_ ,
     &            THB   )
          ASG_(N,IP) = ASG(N,IP) + DEL
          CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG_ ,
     &            THB   )
          ASG_(N,IP) = ASG(N,IP)
          FUN_ASG(N,IP) = 0.5*(UF2 - UF1) / DEL
C
C-------- perturb THB
          DO KT=1, NTHX
            DEL = ABS(EPS*THB(KT,N,IP))
            DEL = MAX(DEL,0.00000001)
            THB_(KT,N,IP) = THB(KT,N,IP) - DEL
            CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF1, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB_  )
            THB_(KT,N,IP) = THB(KT,N,IP) + DEL
            CALL USRFUN(NTHX,NBX,NBL,NUPAR,NPOINT, WP, UF2, 
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB_  )
            THB_(KT,N,IP) = THB(KT,N,IP)
            FUN_THB(KT,N,IP) = 0.5*(UF2 - UF1) / DEL
          ENDDO
C
 20     CONTINUE
 100  CONTINUE
C
      RETURN
      END ! UFDIFF


      SUBROUTINE UCDIFF(NTHX,NBX,NBL,NUPAR,NPOINT,
     &              NMODX,NMOD,NPOSX,NPOS,
     &              ICON , UCNAME,  UCRES,
     &              UPAR , UC_UPAR, EPUPAR,
     &              ALFA , UC_ALFA,
     &              MACH , UC_MACH,
     &              REYN , UC_REYN,
     &              CL   , UC_CL ,
     &              CDF  , UC_CDF,
     &              CDP  , UC_CDP,
     &              CM   , UC_CM ,
     &              ARB  , UC_ARB,
     &              EI1  , UC_EI1,
     &              ASG  , UC_ASG,
     &              THB  , UC_THB,
     &              MODN , UC_MOD,
     &              POSN , UC_POS )
      IMPLICIT REAL(A-H,M,O-Z)
      CHARACTER*8 UCNAME
      DIMENSION NBL(*)
      DIMENSION    UPAR(*),
     &          UC_UPAR(*),
     &           EPUPAR(*)
      DIMENSION    ALFA(*),    MACH(*),    REYN(*),
     &          UC_ALFA(*), UC_MACH(*), UC_REYN(*)
      DIMENSION    CL(*),    CDF(*),    CDP(*),    CM(*),
     &          UC_CL(*), UC_CDF(*), UC_CDP(*), UC_CM(*)
      DIMENSION    ARB(NBX,*),    EI1(NBX,*),    ASG(NBX,*),
     &          UC_ARB(NBX,*), UC_EI1(NBX,*), UC_ASG(NBX,*)
      DIMENSION    THB(0:NTHX,NBX,*),
     &          UC_THB(0:NTHX,NBX,*)
      DIMENSION   MODN(NMODX,*),   POSN(NPOSX,*),
     &          UC_MOD(NMODX,*), UC_POS(NPOSX,*)
      DIMENSION NMOD(*), NPOS(*)
C
C----------------------------------------------------
C     Differentiates user-defined constraint # ICON.
C----------------------------------------------------
      PARAMETER (NUPY=100,NBY=5,NPY=50,NTHY=3,NMODY=150,NPOSY=15)
      DIMENSION UPAR_(NUPY),
     &          ALFA_(NPY),
     &          MACH_(NPY),
     &          REYN_(NPY),
     &          CL_(NPY),
     &          CDF_(NPY),
     &          CDP_(NPY),
     &          CM_(NPY),
     &          ARB_(NBY,NPY), 
     &          EI1_(NBY,NPY), 
     &          ASG_(NBY,NPY),
     &          THB_(0:NTHY,NBY,NPY),
     &          MODN_(NMODY,NPY),
     &          POSN_(NPOSY,NPY)
C
      IF(NUPAR .GT.NUPY) STOP 'UCDIFF: Array overflow. NUPY too small.'
      IF(NPOINT.GT.NPY ) STOP 'UCDIFF: Array overflow. NPY  too small.'
      IF(NBX   .GT.NBY ) STOP 'UCDIFF: Array overflow. NBY  too small.'
      IF(NTHX  .GT.NTHY) STOP 'UCDIFF: Array overflow. NTHY too small.'
C
      IF(NMODX .GT.NMODY) STOP 'UCDIFF: Array overflow. NMODY too small'
      IF(NPOSX .GT.NPOSY) STOP 'UCDIFF: Array overflow. NPOSY too small'
C
      DATA EPS / 0.001 /
C
      DO IU=1, NUPAR
        UPAR_(IU) = UPAR(IU)
      ENDDO
C
      DO IP=1, NPOINT
        DO N=1, NBL(IP)
          ARB_(N,IP) = ARB(N,IP)
          EI1_(N,IP) = EI1(N,IP)
          ASG_(N,IP) = ASG(N,IP)
          DO K = 0, NTHX
            THB_(K,N,IP) = THB(K,N,IP)
          ENDDO
        ENDDO
C
        ALFA_(IP) = ALFA(IP)
        MACH_(IP) = MACH(IP)
        REYN_(IP) = REYN(IP)
        CL_(IP)  = CL(IP)
        CDF_(IP) = CDF(IP)
        CDP_(IP) = CDP(IP)
        CM_(IP)  = CM(IP)
C
        DO K=1, NMOD(IP)
          MODN_(K,IP) = MODN(K,IP)
        ENDDO
        DO K=1, NPOS(IP)
          POSN_(K,IP) = POSN(K,IP)
        ENDDO
      ENDDO
C
C
      ICONT = ICON
      CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICONT,UCNAME, UCRES,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
      IF(ICONT.EQ.0) THEN
ccc        WRITE(*,*) 'Constraint', ICON, '  not defined.'
        RETURN
      ENDIF
C
      DO 10 IU=1, NUPAR
        DEL = EPUPAR(IU)
        IF(DEL .EQ. 0.0) DEL = EPS*UPAR(IU)
C
        UPAR_(IU) = UPAR(IU) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC1,
     &            UPAR_,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        UPAR_(IU) = UPAR(IU) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC2,
     &            UPAR_,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        UPAR_(IU) = UPAR(IU)
        UC_UPAR(IU) = 0.5*(UC2 - UC1) / DEL
 10   CONTINUE
C
C
      DO 20 IP=1, NPOINT
C
C------ perturb alpha
        DEL = EPS
        ALFA_(IP) = ALFA(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC1,
     &            UPAR ,
     &            ALFA_,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ALFA_(IP) = ALFA(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC2,
     &            UPAR ,
     &            ALFA_,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ALFA_(IP) = ALFA(IP)
        UC_ALFA(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb Mach
        DEL = EPS
        MACH_(IP) = MACH(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH_,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        MACH_(IP) = MACH(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH_,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        MACH_(IP) = MACH(IP)
        UC_MACH(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb Reyn
        DEL = REYN(IP)*EPS
        DEL = MAX(DEL,0.000001)
        REYN_(IP) = REYN(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN_,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        REYN_(IP) = REYN(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN_,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        REYN_(IP) = REYN(IP)
        UC_REYN(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb CL
        DEL = EPS
        CL_(IP) = CL(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL_  ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CL_(IP) = CL(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL_  ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CL_(IP) = CL(IP)
        UC_CL(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb CDF
        DEL = ABS(EPS*CDF(IP))
        DEL = MAX(DEL,0.0000001)
        CDF_(IP) = CDF(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF_ ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CDF_(IP) = CDF(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF_ ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CDF_(IP) = CDF(IP)
        UC_CDF(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb CDP
        DEL = ABS(EPS*CDP(IP))
        DEL = MAX(DEL,0.0000001)
        CDP_(IP) = CDP(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP_ ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CDP_(IP) = CDP(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP_ ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CDP_(IP) = CDP(IP)
        UC_CDP(IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb CM
        DEL = EPS
        CM_(IP) = CM(IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM_  ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CM_(IP) = CM(IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM_  ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        CM_(IP) = CM(IP)
        UC_CM(IP) = 0.5*(UC2 - UC1) / DEL
 20   CONTINUE
C
C
      DO 40 N=1, NBL(IP)
C
C------ perturb element area
        DEL = ABS(ARB(N,IP)*EPS)
        DEL = MAX(DEL,0.0000001)
        ARB_(N,IP) = ARB(N,IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB_ ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ARB_(N,IP) = ARB(N,IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB_ ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ARB_(N,IP) = ARB(N,IP)
        UC_ARB(N,IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb element stiffness
        DEL = ABS(EI1(N,IP)*EPS)
        DEL = MAX(DEL,0.0000001)
        EI1_(N,IP) = EI1(N,IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1_ ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        EI1_(N,IP) = EI1(N,IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1_ ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        EI1_(N,IP) = EI1(N,IP)
        UC_EI1(N,IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb element strain
        DEL = ABS(ASG(N,IP)*EPS)
        DEL = MAX(DEL,0.0000001)
        ASG_(N,IP) = ASG(N,IP) - DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG_ ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ASG_(N,IP) = ASG(N,IP) + DEL
        CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG_ ,
     &            THB  ,
     &            MODN ,
     &            POSN  )
        ASG_(N,IP) = ASG(N,IP)
        UC_ASG(N,IP) = 0.5*(UC2 - UC1) / DEL
C
C------ perturb thicknesses
        DO KTH = 0, NTHX
          DEL = ABS(THB(KTH,N,IP)*EPS)
          DEL = MAX(DEL,0.0000001)
          THB_(KTH,N,IP) = THB(KTH,N,IP) - DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB_ ,
     &            MODN ,
     &            POSN  )
          THB_(KTH,N,IP) = THB(KTH,N,IP) + DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB_ ,
     &            MODN ,
     &            POSN  )
          THB_(KTH,N,IP) = THB(KTH,N,IP)
          UC_THB(KTH,N,IP) = 0.5*(UC2 - UC1) / DEL
        ENDDO
 40   CONTINUE
C
C
      DO 50 IP=1, NPOINT
        DO 502 K=1, NMOD(IP)
C
C-------- perturb geometry mode
          DEL = 0.01*EPS
          MODN_(K,IP) = MODN(K,IP) - DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN_,
     &            POSN  )
          MODN_(K,IP) = MODN(K,IP) + DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN_,
     &            POSN  )
          MODN_(K,IP) = MODN(K,IP)
          UC_MOD(K,IP) = 0.5*(UC2 - UC1) / DEL
 502    CONTINUE
C
        DO 504 K=1, NPOS(IP)
C
C-------- perturb position mode
          DEL = 0.01*EPS
          POSN_(K,IP) = POSN(K,IP) - DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC1,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN_ )
          POSN_(K,IP) = POSN(K,IP) + DEL
          CALL USRCON(NTHX,NBX,NBL,NUPAR,NPOINT,
     &            NMODX,NMOD,NPOSX,NPOS,
     &            ICON ,UCNAME, UC2,
     &            UPAR ,
     &            ALFA ,
     &            MACH ,
     &            REYN ,
     &            CL   ,
     &            CDF  ,
     &            CDP  ,
     &            CM   ,
     &            ARB  ,
     &            EI1  ,
     &            ASG  ,
     &            THB  ,
     &            MODN ,
     &            POSN_ )
          POSN_(K,IP) = POSN(K,IP)
          UC_POS(K,IP) = 0.5*(UC2 - UC1) / DEL
 504    CONTINUE
 50   CONTINUE
C
      RETURN
      END ! UCDIFF

