c
cC=====================================================
cC     Include-file USER.INC for storing global data 
cC     for user-defined routines USRFUN and USRCON.
cC     Customize as needed.
cC=====================================================
cC
cC---- max number of mission points, aero points per mission point
c      PARAMETER (NMSX=5,NAEX=3)
cC
c      COMMON /USRCOM/ GAM, GEE,
c     &                ETAP, SFC, HDMIN,
c     &                ALT(NMSX), RHO(NMSX), MU(NMSX), P(NMSX),
c     &                RANGE(NMSX), MASS(NMSX),
c     &                NMS, IPMS(NAEX,NMSX), NPMS(NMSX),
c     &                IMSP(100)
cC




      SUBROUTINE USRINI
ccc   INCLUDE 'USER.INC'
C-----------------------------------------------------
C     Optimization user-setup routine,
C     called once during LINDOP start-up.
C
C     Can be used to set stuff in USER.INC,
C     which is then accessible to USRFUN and USRCON.
C-----------------------------------------------------
C
      RETURN
      END




      SUBROUTINE USRFUN(NTHX,NBX,NEL,NUPAR,NPOINT, PWT, FUN, 
     &                  UPAR,
     &                  ALFA,
     &                  MACH,
     &                  REYN,
     &                  CL ,
     &                  CDF,
     &                  CDP,
     &                  CM ,
     &                  ARB,
     &                  EIB,
     &                  SGB,
     &                  THB )
      IMPLICIT REAL (M)
ccc   INCLUDE 'USER.INC'
      DIMENSION PWT (*), 
     &          UPAR(*),
     &          ALFA(*),
     &          MACH(*),
     &          REYN(*),
     &          CL  (*),
     &          CDF (*),
     &          CDP (*),
     &          CM  (*),
     &          ARB (NBX,*),
     &          EIB (NBX,*),
     &          SGB (NBX,*),
     &          THB (0:NTHX,NBX,*)
C-----------------------------------------------------------------------
C     Returns user-defined objective function:
C
C     FUN( UPAR, ALFA, MACH, REYN, CL, CDF, CDP, CM, ARB, EIB, SGB, THB )
C
C     Input:
C        NEL      number of elements  n
C        NUPAR    number of user-defined parameters  u
C        NPOINT   number of operating points  p
C        
C        PWT (p)  operating-point weights for constructing FUN
C        
C        UPAR(u)  user-defined parameters         for 1..u..NUPAR
C        
C        ALFA(p)  alpha (radians)                 for 1..p..NPOINT 
C        MACH(p)  Mach number                       "
C        REYN(p)  Reynolds number                   "
C        CL  (p)  CL                                "
C        CDF (p)  friction CD                       "
C        CDP (p)  pressure CD                       "
C        CM  (p)  CM                                "
C        
C        ARB (n,p)  element area                  for 1..n..NEL, 1..p..NPOINT
C        EIB (n,p)  element stiffness               "
C        SGB (n,p)  element stress per unit moment  "
C
C        THB(0,n,p)  max thickness
C        THB(1,n,p)  thickness at location 1
C        THB(2,n,p)  thickness at location 2
C         .
C         .
C
C     Output: 
C        FUN        objective function
C
C
C     Customize as needed.
C
C     The PWT(p) weights are user-adjustable at runtime,
C     and can be used to define a tunable objective function.
C     They are unity by default.  They can also be ignored entirely.
C-----------------------------------------------------------------------
C
      CHORD = UPAR(1)
      EI = EIB(1,1)
C
      W1 = PWT(1)
      W2 = PWT(2)
      W3 = PWT(3)
C
      CD1 = CDF(1) + CDP(1)
      CD2 = CDF(2) + CDP(2)
      CD3 = CDF(3) + CDP(3)
C
      FUN = CHORD*(W1*CD1 + W2*CD2 + W3*CD3) - W2*EI*CHORD**5
C
      RETURN
      END


      SUBROUTINE USRCON(NTHX,NBX,NEL,NUPAR,NPOINT,
     &                  NMODX,NMOD,NPOSX,NPOS,
     &                  ICON, UCNAME, RC,
     &                  UPAR,
     &                  ALFA,
     &                  MACH,
     &                  REYN,
     &                  CL  ,
     &                  CDF ,
     &                  CDP ,
     &                  CM  ,
     &                  ARB ,
     &                  EIB ,
     &                  SGB ,
     &                  THB ,
     &                  MOD ,
     &                  POS   )
      IMPLICIT REAL (M)
ccc   INCLUDE 'USER.INC'
      CHARACTER*8 UCNAME
      DIMENSION NEL(*), NMOD(*), NPOS(*)
      DIMENSION UPAR(*),
     &          ALFA(*),
     &          MACH(*),
     &          REYN(*),
     &          CL (*) ,
     &          CDF(*) ,
     &          CDP(*) ,
     &          CM (*) ,
     &          ARB(NBX,*),
     &          EIB(NBX,*),
     &          SGB(NBX,*),
     &          THB(0:NTHX,NBX,*),
     &          MOD(NMODX,*),
     &          POS(NPOSX,*) 
C--------------------------------------------------------------
C     Returns user-defined residual for constraint # ICON:
C
C       RC( UPAR(u), ALFA(p), ... POS(k) )  =  0
C
C     Input:  NEL      number of airfoil elements
C             NUPAR    number of user-defined parameters
C             NPOINT   number of operating points
C             NMOD(p)  number geometry modes
C             NPOS(p)  number position modes
C
C             ICON     user constraint number   (1 ... NUCX)
C
C             UPAR(u)  user-defined parameters        for 1..u..NUPAR
C
C             ALFA(p)  alphas (radians)               for 1..p..NPOINT 
C             MACH(p)  Mach numbers                        "
C             REYN(p)  Reynolds numbers                    "
C             CL  (p)  CL                                  "
C             CDF (p)  friction CD                         "
C             CDP (p)  pressure CD                         "
C             CM  (p)  CM                                  "
C
C             ARB (n,p)  element area                 for 1..n..NEL
C             EIB (n,p)  element stiffness                 "
C             SGB (n,p)  element stress per unit moment    "
C
C             THB(0,n,p)  max thickness
C             THB(1,n,p)  thickness at location 1
C             THB(2,n,p)  thickness at location 2
C              .
C              .
C
C             MOD(k,p)  geometry modes
C             POS(k,p)  position modes
C
C     Output: UCNAME  constraint name for info (8 characters max)
C             RC      constraint residual
C             ICON    returned as zero if the constraint 
C                     for input ICON is undefined here
C
C--------------------------------------------------------------
      PI = 4.0*ATAN(1.0)
C
      CHORD = UPAR(1)
      REREF = 4.4e6
C
      CL1REF = 0.
      CL2REF = 0.4
      CL3REF = 0.8
C
      IF    (ICON.EQ.1) THEN
        RC = REYN(1) - CHORD*REREF
        UCNAME = 'Re1*chord'
C
      ELSEIF(ICON.EQ.2) THEN
        RC = REYN(2) - CHORD*REREF
        UCNAME = 'Re2*chord'
C
      ELSEIF(ICON.EQ.3) THEN
        RC = REYN(3) - CHORD*REREF
        UCNAME = 'Re3*chord'
C
      ELSEIF(ICON.EQ.4) THEN
        RC = CL(1)*CHORD - CL1REF
        UCNAME = 'CL1*chord'
C
      ELSEIF(ICON.EQ.5) THEN
        RC = CL(2)*CHORD - CL2REF
        UCNAME = 'CL2*chord'
C
      ELSEIF(ICON.EQ.6) THEN
        RC = CL(3)*CHORD - CL3REF
        UCNAME = 'CL3*chord'
C
      ELSE
C
        ICON = 0
C
      ENDIF
C
      RETURN
      END
