
      SUBROUTINE USRINI
ccc   INCLUDE 'USER.INC'
C--------------------------------------
C     Optimization user-setup routine
C--------------------------------------
C
      RETURN
      END


      SUBROUTINE USRFUN(NEL,NUPAR,IPNT, FP, 
     &                  UPAR,
     &                  MACH,
     &                  CL ,
     &                  CDF,
     &                  CDP,
     &                  CM ,
     &                  ARB,
     &                  EIB,
     &                  SGB )
      IMPLICIT REAL (M)
      DIMENSION UPAR(*),
     &          ARB(*) ,
     &          EIB(*) ,
     &          SGB(*)
C-----------------------------------------------------------------------
C     Returns user-defined objective function for one operating point:
C
C         FP( UPAR(u), MACH, CL, ... SGB(n) )
C
C     Overall objective function is determined by weighted 
C     summing over all operating points.
C
C
C     Input:  NEL     number of elements
C             NUPAR   number of user-defined parameters
C             IPNT    operating point index
C
C             UPAR(u) user-defined parameters         for 1..u..NUPAR
C             MACH    Mach number
C             CL      CL
C             CDF     friction CD
C             CDP     pressure CD
C             CM      CM
C             ARB(n)  element area                    for 1..n..NEL
C             EIB(n)  element stiffness                 "
C             SGB(n)  element stress per unit moment    "
C
C     Output: FP      objective function for operating point IPNT
C
C-----------------------------------------------------------------------
C
      IF(IPNT.LE.3) THEN
C
        FP = CDF + CDP
C
      ELSE
C
        FP = -0.01*CL
C
      ENDIF
C
      RETURN
      END



      SUBROUTINE USRCON(NEL,NUPAR,NPOINT,
     &                  NMODX,NMOD,NPOSX,NPOS,
     &                  ICON, UCNAME, RC,
     &                  UPAR,
     &                  ALFA,
     &                  MACH,
     &                  REYN,
     &                  CL  ,
     &                  CDF ,
     &                  CDP ,
     &                  CM  ,
     &                  ARB ,
     &                  EIB ,
     &                  SGB ,
     &                  MOD ,
     &                  POS   )
      IMPLICIT REAL (M)
      CHARACTER*8 UCNAME
      DIMENSION NMOD(*), NPOS(*)
      DIMENSION UPAR(*),
     &          ALFA(*),
     &          MACH(*),
     &          REYN(*),
     &          CL(*) ,
     &          CDF(*),
     &          CDP(*),
     &          CM(*) ,
     &          ARB(*),
     &          EIB(*),
     &          SGB(*),
     &          MOD(NMODX,*),
     &          POS(NPOSX,*) 
C--------------------------------------------------------------
C     Returns user-defined residual for constraint # ICON:
C
C       RC( UPAR(u), ALFA(p), ... POS(k) )  =  0
C
C     Input:  NEL      number of airfoil elements
C             NUPAR    number of user-defined parameters
C             NPOINT   number of operating points
C             NMOD(p)  number geometry modes
C             NPOS(p)  number position modes
C
C             ICON      user constraint number   (1 ... NUCX)
C
C             UPAR(u)  user-defined parameters        for 1..u..NUPAR
C             ALFA(p)  alphas (radians)               for 1..p..NPOINT 
C             MACH(p)  Mach numbers                        "
C             REYN(p)  Reynolds numbers                    "
C             CL(p)    CL                                  "
C             CDF(p)   friction CD                         "
C             CDP(p)   pressure CD                         "
C             CM(p)    CM                                  "
C             ARB(n)   element area                   for 1..n..NEL
C             EIB(n)   element stiffness                   "
C             SGB(n)   element stress per unit moment      "
C             MOD(k,p) geometry modes
C             POS(k,p) position modes
C
C     Output: UCNAME  constraint name for info (8 characters max)
C             RC      constraint residual
C             ICON    returned as zero if the constraint 
C                     for input ICON is undefined here
C
C--------------------------------------------------------------
      PI = 4.0*ATAN(1.0)
C
C
      IF    (ICON.EQ.1) THEN
C
        RC = ALFA(5) - ALFA(4) - 1.0 * PI/180.0
        UCNAME(ICON) = 'Alfa 4-5'
C
      ELSEIF(ICON.EQ.2) THEN
C
        RC = ALFA(6) - ALFA(5) - 1.0 * PI/180.0
        UCNAME(ICON) = 'Alfa 5-6'
C
      ELSE
C
        ICON = 0
C
      ENDIF
C
      RETURN
      END

