
      SUBROUTINE USRINI
      INCLUDE 'USER.INC'
C--------------------------------------
C     Optimization case setup routine
C--------------------------------------
C
C---- set cp/cv , gravitational acceleration
      GAM = 1.4
      GEE = 9.81
C
C---- number of mission points
      NMS = 5
C
C---- mission-point ranges (m)
      RANGE(1) =     0.0
      RANGE(2) =  5500.0E3
      RANGE(3) =  6000.0E3
      RANGE(4) =  9500.0E3
      RANGE(5) = 12500.0E3
C
C---- mission-point altitudes (m), and corresponding air properties
      ALT(1) =  0.0
      ALT(2) = 20.0E3
      ALT(3) = 27.0E3
      ALT(4) = 27.0E3
      ALT(5) = 20.0E3
C
      DO IMS=1, NMS
        ALTKM = ALT(IMS) / 1000.0
        CALL ATMO(ALTKM,VSO,RHO(IMS),MU(IMS))
        P(IMS) = RHO(IMS) * VSO**2 / GAM
      ENDDO
C
C
      ETAP = 0.85           !  propulsive efficiency    
      SFC  = 0.32 / 3.6E6   !  SFC (kg/J)
      HDMIN = 0.10          ! minimum climb rate at mission point 3  (m/s)
C
      OPEN(8,FILE='user.dat',STATUS='OLD',ERR=10)
      READ(8,*) ETAP
      READ(8,*) SFC
      READ(8,*) HDMIN
      SFC = SFC / 3.6E6
 10   CLOSE(8)
C
C
C---- number of aero points at each mission point
      NPMS(1) = 0
      NPMS(2) = 3
      NPMS(3) = 3
      NPMS(4) = 0
      NPMS(5) = 3
C
C---- set aero points corresponding to the mission points
      IPMS(1,2) = 1
      IPMS(2,2) = 2
      IPMS(3,2) = 3
C
      IPMS(1,3) = 4
      IPMS(2,3) = 5
      IPMS(3,3) = 6
C
      IPMS(1,5) = 7
      IPMS(2,5) = 8
      IPMS(3,5) = 9
C
C---- set mission points corresponding to the aero points
      IMSP(1) = 2
      IMSP(2) = 2
      IMSP(3) = 2
C
      IMSP(4) = 3
      IMSP(5) = 3
      IMSP(6) = 3
C
      IMSP(7) = 5
      IMSP(8) = 5
      IMSP(9) = 5
C
      RETURN
      END


      SUBROUTINE USRFUN(NEL,NUPAR,IPNT, FP, 
     &                  UPAR, FP_UPAR,
     &                  MACH, FP_MACH,
     &                  CL , FP_CL ,
     &                  CDF, FP_CDF,
     &                  CDP, FP_CDP,
     &                  CM , FP_CM ,
     &                  ARB, FP_ARB,
     &                  EIB, FP_EIB,
     &                  SGB, FP_SGB )
      IMPLICIT REAL (M)
      DIMENSION UPAR(NUPAR), FP_UPAR(NUPAR),
     &          ARB(NEL) , FP_ARB(NEL),
     &          EIB(NEL) , FP_EIB(NEL),
     &          SGB(NEL) , FP_SGB(NEL)
C--------------------------------------------------------------
C     Returns user-defined objective function for one point:
C      FP( UPAR(u), MACH, CL, ... SGB(n) )
C
C     Also returns the function derivatives.
C
C     Input:  NEL     number of elements
C             NUPAR   number of user-defined parameters
C             IPNT    operating point index
C
C             UPAR(u) user-defined parameters         for 1..u..NUPAR
C             MACH    Mach number
C             CL      CL
C             CDF     friction CD
C             CDP     pressure CD
C             CM      CM
C             ARB(n)  element area                    for 1..n..NEL
C             EIB(n)  element stiffness                 "
C             SGB(n)  element stress per unit moment    "
C
C     Output: FP      objective function for operating point
C             FP_[ ]  dFP/d[ ]
C
C     This USRFUN version simply minimizes user parameter (1).
C
C--------------------------------------------------------------
      INCLUDE 'USER.INC'
C
      FP = 0.0
      DO 5 IU=1, NUPAR
        FP_UPAR(IU) = 0.0
 5    CONTINUE
      FP_MACH = 0.
      FP_CL = 0.
      FP_CDF = 0.
      FP_CDP = 0.
      FP_CM = 0.
C
      DO 7 N=1, NEL
        FP_ARB(N) = 0.
        FP_EIB(N) = 0.
        FP_SGB(N) = 0.
 7    CONTINUE
C
C
      FP         = UPAR(1) / 2450.0
      FP_UPAR(1) =     1.0 / 2450.0
C
C
      RETURN
      END


      SUBROUTINE USRCON(NEL,NUPAR,NPOINT,
     &                  NMODX,NMOD,NPOSX,NPOS,
     &                  ICON, UCNAME,
     &                        RC,
     &                  UPAR, RC_UPAR,
     &                  ALFA, RC_ALFA,
     &                  MACH, RC_MACH,
     &                  REYN, RC_REYN,
     &                  CL  , RC_CL,
     &                  CDF , RC_CDF,
     &                  CDP , RC_CDP,
     &                  CM  , RC_CM,
     &                  ARB , RC_ARB,
     &                  EIB , RC_EIB,
     &                  SGB , RC_SGB,
     &                  MOD , RC_MOD,
     &                  POS , RC_POS )
      IMPLICIT REAL (M)
      CHARACTER*8 UCNAME
      DIMENSION NMOD(NPOINT), NPOS(NPOINT)
      DIMENSION UPAR(NUPAR) , RC_UPAR(NUPAR),
     &          ALFA(NPOINT), RC_ALFA(NPOINT),
     &          MACH(NPOINT), RC_MACH(NPOINT),
     &          REYN(NPOINT), RC_REYN(NPOINT),
     &          CL(NPOINT) , RC_CL(NPOINT),
     &          CDF(NPOINT), RC_CDF(NPOINT),
     &          CDP(NPOINT), RC_CDP(NPOINT),
     &          CM(NPOINT) , RC_CM(NPOINT),
     &          ARB(NEL) , RC_ARB(NEL),
     &          EIB(NEL) , RC_EIB(NEL),
     &          SGB(NEL) , RC_SGB(NEL),
     &          MOD(NMODX,NPOINT), RC_MOD(NMODX,NPOINT),
     &          POS(NPOSX,NPOINT), RC_POS(NPOSX,NPOINT) 
C--------------------------------------------------------------
C     Returns user-defined residual for constraint # ICON:
C
C       RC( UPAR(u), ALFA(p), ... POS(k) )  =  0
C
C     Also returns the residual derivatives.
C
C     Input:  NEL      number of airfoil elements
C             NUPAR    number of user-defined parameters
C             NPOINT   number of operating points
C             NMOD(p)  number geometry modes
C             NPOS(p)  number position modes
C
C             ICON      user constraint number   (1 ... NUCX)
C
C             UPAR(u)  user-defined parameters        for 1..u..NUPAR
C             ALFA(p)  alphas (radians)               for 1..p..NPOINT 
C             MACH(p)  Mach numbers                        "
C             REYN(p)  Reynolds numbers                    "
C             CL(p)    CL                                  "
C             CDF(p)   friction CD                         "
C             CDP(p)   pressure CD                         "
C             CM(p)    CM                                  "
C             ARB(n)   element area                   for 1..n..NEL
C             EIB(n)   element stiffness                   "
C             SGB(n)   element stress per unit moment      "
C             MOD(k,p) geometry modes
C             POS(k,p) position modes
C
C     Output: UCNAME  constraint name (8 characters max)
C             RC      constraint residual
C             RC_[ ]  dRC/d[ ], with all other parameters held fixed
C             ICON    returned as zero if the constraint 
C                     for input ICON is undefined here
C
C     This routine defines a variety of constraint residuals 
C     for a complex HALE-type mission.
C
C--------------------------------------------------------------
      INCLUDE 'USER.INC'
C
C---- temporary arrays for point-averaged CD/CL ratio
      PARAMETER (NPX=20)
      DIMENSION DOL_CL(NPX), DOL_CDF(NPX), DOL_CDP(NPX), DOL_REYN(NPX)
C
      IF(NPOINT .GT. NPX) STOP 'USRCON: Array overflow. Increase NPX.'
C
C
C---- clear everything, assuming constraint will be undefined
      RC = 0.
      DO 5 IU=1, NUPAR
        RC_UPAR(IU) = 0.
 5    CONTINUE
C
      DO 6 IP=1, NPOINT
        RC_ALFA(IP) = 0.
        RC_MACH(IP) = 0.
        RC_REYN(IP) = 0.
        RC_CL(IP) = 0.
        RC_CDF(IP) = 0.
        RC_CDP(IP) = 0.
        RC_CM(IP) = 0.
C
        DO 62 K=1, NMOD(IP)
          RC_MOD(K,IP) = 0.
 62     CONTINUE
C
        DO 64 K=1, NPOS(IP)
          RC_POS(K,IP) = 0.
 64     CONTINUE
 6    CONTINUE
C
      DO 7 N=1, NEL
        RC_ARB(N) = 0.
        RC_EIB(N) = 0.
        RC_SGB(N) = 0.
 7    CONTINUE
C
C
      IF(ICON .LE. NMS-1) THEN
C------ Breguet relation between mission points IMS1, IMS2
C
        IMS1 = ICON
        IMS2 = ICON + 1
        UCNAME = 'RA_' // CHAR(ICHAR('0')+IMS1) // 
     &             '-' // CHAR(ICHAR('0')+IMS2) // '  '
C
C------ user-parameter indices:  start & end masses, span, chord
        IUM1 = IMS1
        IUM2 = IMS2
        IUB  = NMS + 1
        IUC  = NMS + 2
C
        GO TO 100
C
      ELSE IF(ICON .EQ. NMS) THEN
C------ climb-rate constraint on mission point 3, using middle-point CL
        IMS = 3
        IP  = IPMS(2,IMS)
        UCNAME = 'HDOT_3  '
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
        IUP = NMS + 3
C
        HDMIN = 0.1
        GO TO 200
C
      ELSE IF(ICON .LE. NMS+NPOINT) THEN
C------ reduced-Mach -- weight  constraints on all aero points
C
        IP = ICON - NMS
        IMS = IMSP(IP)
        UCNAME = 'M-CL_' // CHAR(ICHAR('0')+IP)
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
C
        GO TO 300
C
      ELSE IF(ICON .LE. NMS+2*NPOINT) THEN
C------ reduced-Re -- weight  constraints on mission points 2,3,5
C
        IP = ICON - NMS - NPOINT
        IMS = IMSP(IP)
        UCNAME = 'R-CL_' // CHAR(ICHAR('0')+IP)
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
C
        GO TO 400
C
      ELSE IF(ICON .LE. NMS+2*NPOINT+6) THEN
C----- CL-difference constraints on the various aero points
C
        ICOFF = NMS + 2*NPOINT
C
        IF     (ICON .EQ. ICOFF+1 ) THEN
          IP1 = 1
          IP2 = 2
          DCL = 0.1
          UCNAME = 'CL 1-2  '
        ELSE IF(ICON .EQ. ICOFF+2 ) THEN
          IP1 = 2
          IP2 = 3
          DCL = 0.1
          UCNAME = 'CL 2-3  '
        ELSE IF(ICON .EQ. ICOFF+3) THEN
          IP1 = 4
          IP2 = 5
          DCL = 0.1
          UCNAME = 'CL 4-5  '
        ELSE IF(ICON .EQ. ICOFF+4) THEN
          IP1 = 5
          IP2 = 6
          DCL = 0.1
          UCNAME = 'CL 5-6  '
        ELSE IF(ICON .EQ. ICOFF+5) THEN
          IP1 = 7
          IP2 = 8
          DCL = 0.1
          UCNAME = 'CL 7-8  '
        ELSE IF(ICON .EQ. ICOFF+6) THEN
          IP1 = 8
          IP2 = 9
          DCL = 0.1
          UCNAME = 'CL 8-9  '
        ENDIF
C
        GO TO 500
C
      ELSE IF(ICON .EQ. NMS+2*NPOINT+7) THEN
C----- empty-weight constraint on last mission point NMS
C-     (depends on takeoff weight at mission point 1)
C
       IMS = NMS
       UCNAME = 'WEMPTY  '
C
       IUM0 = 1
       IUM = IMS
       IUB = NMS + 1
       IUC = NMS + 2
       IUP = NMS + 3
C
C----- index for Cm
       IP = 2
C
       GO TO 600
C
      ENDIF
C
C
C---- no constraint defined for passed-in ICON value
      ICON = 0
      RETURN
C
C
C============================================================
 100  CONTINUE
C---- Breguet relation for mission segment IMS1..IMS2
C
      B = UPAR(IUB)
      C = UPAR(IUC)
C
C---- set effective segment D/L by averaging over aero points
      CALL DOLAVG(NAEX,IMS1,IMS2,IPMS,NPMS, NPOINT,
     &             CL,     CDF,     CDP,     B,     C,     REYN,
     &    DOL, DOL_CL, DOL_CDF, DOL_CDP, DOL_B, DOL_C, DOL_REYN )

      write(*,*) 'L/D:', ims1, ims2, 1.0/DOL

C
C---- set Breguet relation with altitude-change term
      RC = ETAP/(SFC*GEE) * LOG(UPAR(IUM1)/UPAR(IUM2))
     &   + DOL*(RANGE(IMS1) - RANGE(IMS2)) + ALT(IMS1) - ALT(IMS2)
C
      RC_LOGW = ETAP/(SFC*GEE)
      RC_DOL = RANGE(IMS1) - RANGE(IMS2)
C
c      write(*,*) ucname, 1.0/dol, 
c     & ETAP/(SFC*GEE)*LOG(UPAR(IUM1)/UPAR(IUM2))/1000.0/dol
c     & -(  ALT(IMS2) -   ALT(IMS1))/1000.0/dol,
c     &  (RANGE(IMS2) - RANGE(IMS1))/1000.0
C
      RC_UPAR(IUM1) =  RC_LOGW / UPAR(IUM1)
      RC_UPAR(IUM2) = -RC_LOGW / UPAR(IUM2)
      RC_UPAR(IUB) = RC_DOL*DOL_B
      RC_UPAR(IUC) = RC_DOL*DOL_C
      DO IP=1, NPOINT
        RC_CL(IP)   = RC_DOL*DOL_CL(IP)
        RC_CDF(IP)  = RC_DOL*DOL_CDF(IP)
        RC_CDP(IP)  = RC_DOL*DOL_CDP(IP)
        RC_REYN(IP) = RC_DOL*DOL_REYN(IP)
      ENDDO
C
      RETURN
C
C============================================================
 200  CONTINUE
C---- climb-rate constraint on mission point IMS
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
      PMAX = UPAR(IUP)*1000.0
C
C---- set effective D/L by averaging over aero points
      CALL DOLAVG(NAEX,IMS,IMS, IPMS,NPMS, NPOINT,
     &                  CL,     CDF,     CDP,     B,     C,     REYN,
     &         DOL, DOL_CL, DOL_CDF, DOL_CDP, DOL_B, DOL_C, DOL_REYN )
C
      V = SQRT( 2.0*M*GEE/(RHO(IMS)*CL(IP)*B*C) )
      V_M  =  0.5*V/M
      V_CL = -0.5*V/CL(IP)
      V_B  = -0.5*V/B
      V_C  = -0.5*V/C
C
c      write(*,*) ucname, dol, v, ETAP*PMAX/M/GEE - V*DOL

      RC           =                        ETAP*PMAX  /(M*GEE)
     &               -V   *DOL  -  HDMIN
      RC_UPAR(IUM) =                       -ETAP*PMAX  /(M*M*GEE)
     &               -V_M *DOL
      RC_UPAR(IUB) = -V_B *DOL - V*DOL_B
      RC_UPAR(IUC) = -V_C *DOL - V*DOL_C
      RC_UPAR(IUP) =                        ETAP*1000.0/(M*GEE)
      RC_CL(IP)    = -V_CL*DOL
C
      DO JP=1, NPOINT
        RC_CL(JP)   = RC_CL(JP) - V*DOL_CL(JP)
        RC_CDF(JP)  =           - V*DOL_CDP(JP)
        RC_CDP(JP)  =           - V*DOL_CDF(JP)
        RC_REYN(JP) =           - V*DOL_REYN(JP)
      ENDDO
C
      RETURN
C
C============================================================
 300  CONTINUE
C---- reduced-Mach -- weight  constraint on mission,aero points IMS,IP
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
C
c      write(*,*) ucname, mach(ip), 
c     &           0.5*GAM*P(ims)*MACH(IP)**2*CL(IP) * B*C / GEE - M


      RC           = 0.5*GAM*P(IMS)*MACH(IP)**2*CL(IP) * B*C  - M*GEE
      RC_MACH(IP)  =     GAM*P(IMS)*MACH(IP)   *CL(IP) * B*C
      RC_CL(IP)    = 0.5*GAM*P(IMS)*MACH(IP)**2        * B*C
      RC_UPAR(IUM) =                                          -   GEE
      RC_UPAR(IUB) = 0.5*GAM*P(IMS)*MACH(IP)**2*CL(IP)    *C
      RC_UPAR(IUC) = 0.5*GAM*P(IMS)*MACH(IP)**2*CL(IP) * B
C
      RETURN
C
C============================================================
 400  CONTINUE
C---- reduced-Re -- weight  constraint on mission,aero points IMS,IP
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
c
c      write(*,*) ucname, reyn(ip),
c     &    (MU(IMS)*REYN(IP))**2*CL(IP) * 0.5*B/(RHO(IMS)*C) / GEE - M

C
      RC           = (MU(IMS)*REYN(IP))**2*CL(IP) * 0.5*B/(RHO(IMS)*C)
     &             -  M*GEE
      RC_REYN(IP)  = (MU(IMS)*REYN(IP))   *CL(IP)      *B/(RHO(IMS)*C)
     &              * MU(IMS)
      RC_CL(IP)    = (MU(IMS)*REYN(IP))**2        * 0.5*B/(RHO(IMS)*C)
      RC_UPAR(IUM) =   -GEE 
      RC_UPAR(IUB) = (MU(IMS)*REYN(IP))**2*CL(IP) * 0.5  /(RHO(IMS)*C)
      RC_UPAR(IUC) =-(MU(IMS)*REYN(IP))**2*CL(IP) * 0.5*B/(RHO(IMS)*C)/C
C
      RETURN
C
C============================================================
 500  CONTINUE
C---- CL-difference constraint between aero points IP1, IP2
C
      RC         = CL(IP1) - CL(IP2) + DCL
      RC_CL(IP1) =  1.0
      RC_CL(IP2) = -1.0
C
      RETURN
C
C============================================================
 600  CONTINUE
C---- empty-weight constraint on the various weight-influencing parameters
C
      M0 = UPAR(IUM0)
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
      PMAX = UPAR(IUP)
C
      CALL MEMPTY( M0,   B,   C,   ARB(1),   EIB(1),   CM(IP),   PMAX,
     &      ME, ME_M0,ME_B,ME_C,ME_ARB   ,ME_EIB   ,ME_CM    ,ME_PMAX )
C

c      write(*,*) ucname, me

      RC            = ME  - M
      RC_UPAR(IUM)  =     - 1.0
      RC_UPAR(IUM0) = ME_M0
      RC_UPAR(IUB)  = ME_B
      RC_UPAR(IUC)  = ME_C
      RC_ARB(1)     = ME_ARB
      RC_EIB(1)     = ME_EIB
      RC_CM(IP)     = ME_CM
      RC_UPAR(IUP)  = ME_PMAX
C
      RETURN
C
      END



      SUBROUTINE DOLAVG(NAEX,IMS1,IMS2,IPMS,NPMS, NPOINT,
     &                    CL,     CDF,     CDP,     B,     C,     RE,
     &           DOL, DOL_CL, DOL_CDF, DOL_CDP, DOL_B, DOL_C, DOL_RE )
      DIMENSION IPMS(NAEX,1), NPMS(1)
      DIMENSION CL(NPOINT), CDF(NPOINT), 
     &          RE(NPOINT), CDP(NPOINT),
     &          DOL_CL(NPOINT), DOL_CDF(NPOINT),
     &          DOL_RE(NPOINT), DOL_CDP(NPOINT)
C-------------------------------------------
C     Averages total CD/CL over aero points
C-------------------------------------------
C
      DOL = 0.
      DO IP=1, NPOINT
        DOL_CL(IP)  = 0.
        DOL_CDF(IP) = 0.
        DOL_CDP(IP) = 0.
        DOL_RE(IP)  = 0.
      ENDDO
      DOL_B = 0.
      DOL_C = 0.
C
      PWTSUM = 0.
      DO IMS=IMS1, IMS2
        DO IA=1, NPMS(IMS)
C
C-------- set aero-point index and aero-point weight
          IP = IPMS(IA,IMS)
          PWT = 1.0
C
C-------- set total aircraft drag CDT
          CD = CDF(IP) + CDP(IP)
          CALL CDTOT(         CL(IP),     CD,     B,     C,     RE(IP), 
     &               CDT, CDT_CL    , CDT_CD, CDT_B, CDT_C, CDT_RE )
C
          PWTSUM = PWTSUM + PWT
C
C-------- accumulate D/L and its sensitivities
          DOL         = DOL         + PWT*CDT   /CL(IP)
          DOL_CL(IP)  = DOL_CL(IP)  + PWT*CDT_CL/CL(IP)
     &                              - PWT*CDT   /CL(IP)**2
          DOL_CDF(IP) = DOL_CDF(IP) + PWT*CDT_CD/CL(IP)
          DOL_CDP(IP) = DOL_CDP(IP) + PWT*CDT_CD/CL(IP)
          DOL_B       = DOL_B       + PWT*CDT_B /CL(IP)
          DOL_C       = DOL_C       + PWT*CDT_C /CL(IP)
          DOL_RE(IP)  = DOL_RE(IP)  + PWT*CDT_RE/CL(IP)
        ENDDO
      ENDDO
C
      IF(PWTSUM .GT. 0.0) THEN
        DOL = DOL/PWTSUM
        DO IP=1, NPOINT
          DOL_CL(IP)  = DOL_CL(IP) /PWTSUM
          DOL_CDF(IP) = DOL_CDF(IP)/PWTSUM
          DOL_CDP(IP) = DOL_CDP(IP)/PWTSUM
          DOL_RE(IP)  = DOL_RE(IP) /PWTSUM
        ENDDO
        DOL_B = DOL_B/PWTSUM
        DOL_C = DOL_C/PWTSUM
      ENDIF
C
      RETURN
      END



      SUBROUTINE CDTOT(   CL,     CD,     B,     C,     RE,
     &           CDT, CDT_CL, CDT_CD, CDT_B, CDT_C, CDT_RE )
      DATA PI / 3.141592654 /
C
C---- general contingency factor for profile and parasite drags
      CDFUDG = 1.05
C
C---- baseline chord, span, wing area
      CB = 1.4
      BB = 40.0
C
      SWB = CB*BB
C
C---- baseline chord reduced-Reynolds number   (20 km)
      REB = 0.750E6
C
C---- Reynolds number scaling exponent for parasite CD
      RX = -0.3
C
C---- parasite drag area (m^2) at baseline Re
C-    represents fuselage, pods, radiators
      APAR = 0.41 * CDFUDG
C
C---- tail/wing area ratio
      STSW = 0.14
C
C---- tail/wing profile CD ratio
      CDTRAT = 0.8
C
C---- span efficiency
      E = 0.92
C
C---- Reynolds number scaling factor for parasite drag
      RF = ( (RE/REB) * (CB/C) / SQRT(CL) )**RX
      RF_RE =      RX*RF/RE
      RF_C  =     -RX*RF/C
      RF_CL = -0.5*RX*RF/CL
C
C---- wing profile CD multiplier (assumes tail area scales with wing area)
      CDFAC = (1.0 + STSW*CDTRAT) * CDFUDG
C
C---- total airframe CD
      CDT    = CD*CDFAC  +  APAR/(C*B)*RF      +  CL**2*C/(E*PI*B)  
      CDT_CD =    CDFAC                     
      CDT_CL =              APAR/(C*B)*RF_CL   +  CL*2.*C/(E*PI*B)  
      CDT_B  =           -  APAR/(C*B)*RF / B  -  CL**2*C/(E*PI*B) / B
      CDT_C  =           -  APAR/(C*B)*RF / C  +  CL**2  /(E*PI*B)  
     &                   +  APAR/(C*B)*RF_C                         
      CDT_RE =              APAR/(C*B)*RF_RE                        
C
      RETURN
      END


      SUBROUTINE MEMPTY( M0,   B,   C,   A,   TT,   CM,   PX,
     &              M, M_M0, M_B, M_C, M_A, M_TT, M_CM, M_PX )
C-----------------------------------------------------------
C     Returns empty mass M as a function of the input
C     parameters M0, B... PX.
C
C     Assumes the various weight components scale by 
C     appropriate input/baseline parameter ratios.
C-----------------------------------------------------------
      IMPLICIT REAL (M)
C
C---- baseline parameters
      MB = 1650.0       ! empty mass (kg)
C
      M0B = 2450.0      ! GTOM  (kg)
      BB = 40.0         ! span  (m)
      CB = 1.4          ! chord (m)
C
      AB  = 0.0874475   !  A/c^2    airfoil area/c^2
      TTB = 0.00052384  ! (t/c)^2  (thickness/c)^2 at spar
C
      CMB = -0.155309   ! airfoil Cm
C
      PXB = 115.0       ! max power (kW)
C
c
c      WRITE(*,*)
c      WRITE(*,*) 'M0',M0B,M0
c      WRITE(*,*) 'B ',BB ,B 
c      WRITE(*,*) 'C ',CB ,C 
c      WRITE(*,*) 'A ',AB ,A 
c      WRITE(*,*) 'TT',TTB,TT
c      WRITE(*,*) 'CM',CMB,CM
c      WRITE(*,*) 'PX',PXB,PX
c

C---- component empty-mass fractions
      FSPR = 0.063 + 0.009   ! wing_spar + web
      FSKN = 0.124 - 0.025   ! wing_skin - wing_Nomex
C
      FSWI = 0.036 + 0.025   ! tails + lightn_prot + wing_Nomex
      FENG = 0.126 + 0.071   ! engine + coolers
C
      FFIX = 1.0 - FSPR - FSKN - FSWI - FENG
C
C====================================
C     set new/baseline ratios
C
C---- set spar weight ratio assuming fixed deflection slope w' at GTOM
C     (M = bending moment, S = spar cap area, m = GTOM)
C
C     w'' ~ M/EI           2
C     w' ~ bw'' ~ bM/EI ~ b  m / EI
C                              2      2          2  2
C     with w',E fixed...  I ~ b  m ~ t  S ~ (t/c)  c  S
C                          3           2  2
C     spar weight ~ b S ~ b  m / {(t/c)  c }
C
      RSPR = (B/BB)**3 * (M0/M0B) * (TTB/TT) * (CB/C)**2
      RSPR_B  =  3.0*RSPR/B
      RSPR_C  = -2.0*RSPR/C
      RSPR_M0 =      RSPR/M0
      RSPR_TT =     -RSPR/TT
C
C
C---- set skin weight ratio assuming fixed tip twist angle change  a
C-    over some nominal CL change  (this change is proportional to CM)
C
C     (T = torsion, A = airfoil area, Askin = skin x-sectional area)
C
C     a' ~ T/GJ
C     a ~ ba' ~ bT/GJ ~ b m c CM / GJ
C                                      2  2             2 2  2 
C     with a,G fixed... J ~ bc m CM ~ A /c  Askin ~ (A/c )  c  Askin
C                              2             2 2 
C     skin weight ~ b Askin ~ b  m CM / {(A/c )  c}
C
      RSKN = (B/BB)**2*(M0/M0B)*(AB/A)**2*(CB/C)*(0.5+0.5*CM/CMB)
      RSKN_B  =  2.0*RSKN/B
      RSKN_C  =     -RSKN/C
      RSKN_M0 =      RSKN/M0
      RSKN_A  = -2.0*RSKN/A
      RSKN_CM =      RSKN/(0.5+0.5*CM/CMB) * (0.5/CMB)
C
C
C---- set wing area ratio
C
      RSWI   = (B/BB) * (C/CB)
      RSWI_B = RSWI/B
      RSWI_C = RSWI/C
C
C
C---- set engine weight ratio
C
      RENG    = PX/PXB
      RENG_PX = RENG/PX
C
C
C---- set new empty mass
C
      M    = MB*(FFIX + 
     &           FSPR*RSPR    +FSKN*RSKN    +FSWI*RSWI   +FENG*RENG   )
      M_M0 = MB*(FSPR*RSPR_M0 +FSKN*RSKN_M0                           )
      M_B  = MB*(FSPR*RSPR_B  +FSKN*RSKN_B  +FSWI*RSWI_B              )
      M_C  = MB*(FSPR*RSPR_C  +FSKN*RSKN_C  +FSWI*RSWI_C              )
      M_A  = MB*(              FSKN*RSKN_A                            )
      M_TT = MB*(FSPR*RSPR_TT                                         )
      M_CM = MB*(              FSKN*RSKN_CM                           )
      M_PX = MB*(                                         FENG*RENG_PX)
C
      RETURN
      END


      SUBROUTINE ATMO(ALSPEC,VSOALT,RHOALT,RMUALT)
C---------------------------------------------------------
C     Returns speed of sound (VSO) in m/s, density (RHO)
C     in kg/m^3, and dynamic viscosity (RMU) in kg/m-s
C     of standard atmosphere at specified altitude ALSPEC
C     (in kilometers).  If ALSPEC=-1, water properties
C     at 15 Celsius are returned.
C
C     Reference:  "U.S. Standard Atmosphere", NOAA.
C---------------------------------------------------------
      LOGICAL FIRST
      DATA FIRST / .TRUE. /
C
      PARAMETER ( N = 44 )
      REAL ALT(N), VSO(N), RHO(N), RMU(N)
C
      DATA ALT
     &   / 0.0,  1.0,  2.0,  3.0,  4.0,  5.0,  6.0,  7.0,  8.0,  9.0,
     &    10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0,
     &    20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0,
     &    30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 
     &    40.0, 45.0, 60.0, 75.0 /
      DATA VSO
     & / 340.0,336.0,332.0,329.0,325.0,320.0,316.0,312.0,308.0,304.0,
     &   299.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,
     &   295.0,295.8,296.4,297.1,297.8,298.5,299.1,299.8,300.5,301.1,
     &   301.8,302.5,303.1,305.0,306.8,308.7,310.5,312.3,314.0,316.0,
     &   318.0,355.0,372.0,325.0 /
      DATA RHO
     & / 1.226,1.112,1.007,0.909,0.820,0.737,0.660,0.589,0.526,0.467,
     &   0.413,0.364,0.311,0.265,0.227,0.194,0.163,0.141,0.121,0.103,
     &   .0880,.0749,.0637,.0543,.0463,.0395,.0338,.0288,.0246,.0210,
     &   .0180,.0154,.0132,.0113,.0096,.0082,.0070,.0060,.0052,.0044,
     &   0.004,0.002,3.9E-4,8.0E-5 /
      DATA RMU
     & / 1.780,1.749,1.717,1.684,1.652,1.619,1.586,1.552,1.517,1.482,
     &   1.447,1.418,1.418,1.418,1.418,1.418,1.418,1.418,1.418,1.418,
     &   1.418,1.427,1.433,1.438,1.444,1.449,1.454,1.460,1.465,1.471,
     &   1.476,1.481,1.487,1.502,1.512,1.532,1.546,1.561,1.580,1.600,
     &   1.700,1.912,2.047,1.667 /
C
C---- special case: Water at STP
      IF(ALSPEC.EQ.-1.0) THEN
       VSOALT = 1500.
       RHOALT = 1000.
       RMUALT = 1.15E-3
       WRITE(*,*) '                              o        '
       WRITE(*,*) 'ATMO: You are underwater at 15  Celsius'
       RETURN
      ENDIF
C
C---- linearly interpolate quantities from tabulated values
      DO 10 I=2, N
        IF(ALSPEC.GT.ALT(I)) GO TO 10
C
         DALT = ALT(I) - ALT(I-1)
         DVSO = VSO(I) - VSO(I-1)
         DRHO = RHO(I) - RHO(I-1)
         DRMU = RMU(I) - RMU(I-1)
C
         ALFRAC = (ALSPEC - ALT(I-1)) / DALT
C
         VSOALT = VSO(I-1) + DVSO*ALFRAC
         RHOALT = RHO(I-1) + DRHO*ALFRAC
         RMUALT = RMU(I-1) + DRMU*ALFRAC
         RMUALT = RMUALT * 1.0E-5
C
         RETURN
   10 CONTINUE
C
C
      IF(ALSPEC.GT.ALT(N)) THEN
       WRITE(*,*) ' '
       WRITE(*,*) 'ATMO: You''re in low earth orbit.  Good luck.'
       VSOALT = VSO(N)
       RHOALT = RHO(N)
       RMUALT = RMU(N) * 1.0E-5
       RETURN
      ENDIF
C
c      IF(FIRST) THEN
c       DO 20 I=1, N
c         RHO(I) = ALOG(RHO(I))
c 20    CONTINUE
c       CALL SPLINE(VSO,VSOH,ALT,N)
c       CALL SPLIND(RHO,RHOH,ALT,N,999.0,0.0)
c       CALL SPLINE(RMU,RMUH,ALT,N)
c       FIRST = .FALSE.
c      ENDIF
cC
cC---- interpolate quantities from splines
c      VSOALT = SEVAL(ALSPEC,VSO,VSOH,ALT,N)
c      RHOALT = SEVAL(ALSPEC,RHO,RHOH,ALT,N)
c      RMUALT = SEVAL(ALSPEC,RMU,RMUH,ALT,N) * 1.0E-5
c      RHOALT = EXP(RHOALT)
cC
      RETURN
      END ! ATMO

