
      SUBROUTINE USRINI
      IMPLICIT REAL (M)
      INCLUDE 'USER.INC'
C--------------------------------------
C     Optimization case setup routine
C--------------------------------------
C
C---- set cp/cv , gravitational acceleration
      GAM = 1.4
      GEE = 9.81
C
C---- number of mission points
      NMS = 5
C
C---- mission-point ranges (m)
      RANGE(1) =     0.0
      RANGE(2) =  5500.0E3
      RANGE(3) =  6000.0E3
      RANGE(4) =  9500.0E3
      RANGE(5) = 12500.0E3
C
C---- mission-point altitudes (m), and corresponding air properties
      ALT(1) =  0.0
      ALT(2) = 20.0E3
      ALT(3) = 27.0E3
      ALT(4) = 27.0E3
      ALT(5) = 20.0E3
C
      DO IMS=1, NMS
        ALTKM = ALT(IMS) / 1000.0
        CALL ATMO(ALTKM,VSO,RHO(IMS),MU(IMS))
        P(IMS) = RHO(IMS) * VSO**2 / GAM
      ENDDO
C
C---- default parameters
      ETAP = 0.85           !  propulsive efficiency    
      SFC  = 0.32 / 3.6E6   !  SFC (kg/J)
      HDMIN = 0.10          ! minimum climb rate at mission point 3  (m/s)
C
C---- try to get parameters from file
      OPEN(8,FILE='user.dat',STATUS='OLD',ERR=10)
      READ(8,*) ETAP
      READ(8,*) SFC
      READ(8,*) HDMIN
      SFC = SFC / 3.6E6
 10   CLOSE(8)
C
C
C---- number of aero points at each mission point
      NPMS(1) = 0
      NPMS(2) = 3
      NPMS(3) = 3
      NPMS(4) = 0
      NPMS(5) = 3
C
C---- set aero points corresponding to the mission points
      IPMS(1,2) = 1
      IPMS(2,2) = 2
      IPMS(3,2) = 3
C
      IPMS(1,3) = 7
      IPMS(2,3) = 8
      IPMS(3,3) = 9
C
      IPMS(1,5) = 4
      IPMS(2,5) = 5
      IPMS(3,5) = 6
C
C---- set mission points corresponding to the aero points
      IMSP(1) = 2
      IMSP(2) = 2
      IMSP(3) = 2
C
      IMSP(4) = 5
      IMSP(5) = 5
      IMSP(6) = 5
C
      IMSP(7) = 3
      IMSP(8) = 3
      IMSP(9) = 3
C
      RETURN
      END


      SUBROUTINE USRFUN(NEL,NUPAR,IPNT, FP, 
     &                  UPAR,
     &                  MACH,
     &                  CL ,
     &                  CDF,
     &                  CDP,
     &                  CM ,
     &                  ARB,
     &                  EIB,
     &                  SGB )
      IMPLICIT REAL (M)
      DIMENSION UPAR(*),
     &          ARB(*) ,
     &          EIB(*) ,
     &          SGB(*)
C--------------------------------------------------------------
C     Returns user-defined objective function for one point:
C      FP( UPAR(u), MACH, CL, ... SGB(n) )
C
C     Also returns the function derivatives.
C
C     Input:  NEL     number of elements
C             NUPAR   number of user-defined parameters
C             IPNT    operating point index
C
C             UPAR(u) user-defined parameters         for 1..u..NUPAR
C             MACH    Mach number
C             CL      CL
C             CDF     friction CD
C             CDP     pressure CD
C             CM      CM
C             ARB(n)  element area                    for 1..n..NEL
C             EIB(n)  element stiffness                 "
C             SGB(n)  element stress per unit moment    "
C
C     Output: FP      objective function for operating point
C
C     This USRFUN version simply minimizes user parameter (1).
C
C--------------------------------------------------------------
      INCLUDE 'USER.INC'
C
      FP = UPAR(1) / 2450.0
C
      RETURN
      END



      SUBROUTINE USRCON(NEL,NUPAR,NPOINT,
     &                  NMODX,NMOD,NPOSX,NPOS,
     &                  ICON, UCNAME, RC,
     &                  UPAR,
     &                  ALFA,
     &                  MACH,
     &                  REYN,
     &                  CL  ,
     &                  CDF ,
     &                  CDP ,
     &                  CM  ,
     &                  ARB ,
     &                  EIB ,
     &                  SGB ,
     &                  MOD ,
     &                  POS  )
      IMPLICIT REAL (M)
      CHARACTER*8 UCNAME
      DIMENSION NMOD(*), NPOS(*)
      DIMENSION UPAR(*) ,
     &          ALFA(*),
     &          MACH(*),
     &          REYN(*),
     &          CL(*) ,
     &          CDF(*),
     &          CDP(*),
     &          CM(*) ,
     &          ARB(*) ,
     &          EIB(*) ,
     &          SGB(*) ,
     &          MOD(NMODX,*),
     &          POS(NPOSX,*)
C--------------------------------------------------------------
C     Returns user-defined residual for constraint # ICON:
C
C       RC( UPAR(u), ALFA(p), ... POS(k) )  =  0
C
C     Also returns the residual derivatives.
C
C     Input:  NEL      number of airfoil elements
C             NUPAR    number of user-defined parameters
C             NPOINT   number of operating points
C             NMOD(p)  number geometry modes
C             NPOS(p)  number position modes
C
C             ICON      user constraint number   (1 ... NUCX)
C
C             UPAR(u)  user-defined parameters        for 1..u..NUPAR
C             ALFA(p)  alphas (radians)               for 1..p..NPOINT 
C             MACH(p)  Mach numbers                        "
C             REYN(p)  Reynolds numbers                    "
C             CL(p)    CL                                  "
C             CDF(p)   friction CD                         "
C             CDP(p)   pressure CD                         "
C             CM(p)    CM                                  "
C             ARB(n)   element area                   for 1..n..NEL
C             EIB(n)   element stiffness                   "
C             SGB(n)   element stress per unit moment      "
C             MOD(k,p) geometry modes
C             POS(k,p) position modes
C
C     Output: UCNAME  constraint name (8 characters max)
C             RC      constraint residual
C             ICON    returned as zero if the constraint 
C                     for input ICON is undefined here
C
C     This routine defines a variety of constraint residuals 
C     for a complex HALE-type mission.
C
C--------------------------------------------------------------
      INCLUDE 'USER.INC'
C
C---- clear everything, assuming constraint will be undefined
      RC = 0.
C
      IF(ICON .LE. NMS-1) THEN
C------ Breguet relation between mission points IMS1, IMS2
C
        IMS1 = ICON
        IMS2 = ICON + 1
        UCNAME = 'RA_' // CHAR(ICHAR('0')+IMS1) // 
     &             '-' // CHAR(ICHAR('0')+IMS2) // '  '
C
C------ user-parameter indices:  start & end masses, span, chord
        IUM1 = IMS1
        IUM2 = IMS2
        IUB  = NMS + 1
        IUC  = NMS + 2
C
        GO TO 100
C
      ELSE IF(ICON .EQ. NMS) THEN
C------ climb-rate constraint on mission point 3, using middle-point CL
        IMS = 3
        IP  = IPMS(2,IMS)
        UCNAME = 'HDOT_3  '
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
        IUP = NMS + 3
C
        HDMIN = 0.1
        GO TO 200
C
      ELSE IF(ICON .LE. NMS+NPOINT) THEN
C------ reduced-Mach -- weight  constraints on all aero points
C
        IP = ICON - NMS
        IMS = IMSP(IP)
        UCNAME = 'M-CL_' // CHAR(ICHAR('0')+IP)
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
C
        GO TO 300
C
      ELSE IF(ICON .LE. NMS+2*NPOINT) THEN
C------ reduced-Re -- weight  constraints on mission points 2,3,5
C
        IP = ICON - NMS - NPOINT
        IMS = IMSP(IP)
        UCNAME = 'R-CL_' // CHAR(ICHAR('0')+IP)
C
        IUM = IMS
        IUB = NMS + 1
        IUC = NMS + 2
C
        GO TO 400
C
      ELSE IF(ICON .LE. NMS+2*NPOINT+6) THEN
C----- CL-difference constraints on the various aero points
C
        ICOFF = NMS + 2*NPOINT
C
        IF     (ICON .EQ. ICOFF+1 ) THEN
          IP1 = 1
          IP2 = 2
          DCL = 0.1
          UCNAME = 'CL 1-2  '
        ELSE IF(ICON .EQ. ICOFF+2 ) THEN
          IP1 = 2
          IP2 = 3
          DCL = 0.1
          UCNAME = 'CL 2-3  '
        ELSE IF(ICON .EQ. ICOFF+3) THEN
          IP1 = 4
          IP2 = 5
          DCL = 0.1
          UCNAME = 'CL 4-5  '
        ELSE IF(ICON .EQ. ICOFF+4) THEN
          IP1 = 5
          IP2 = 6
          DCL = 0.1
          UCNAME = 'CL 5-6  '
        ELSE IF(ICON .EQ. ICOFF+5) THEN
          IP1 = 7
          IP2 = 8
          DCL = 0.1
          UCNAME = 'CL 7-8  '
        ELSE IF(ICON .EQ. ICOFF+6) THEN
          IP1 = 8
          IP2 = 9
          DCL = 0.1
          UCNAME = 'CL 8-9  '
        ENDIF
C
        GO TO 500
C
      ELSE IF(ICON .EQ. NMS+2*NPOINT+7) THEN
C----- empty-weight constraint on last mission point NMS
C-     (depends on takeoff weight at mission point 1)
C
       IMS = NMS
       UCNAME = 'WEMPTY  '
C
       IUM0 = 1
       IUM = IMS
       IUB = NMS + 1
       IUC = NMS + 2
       IUP = NMS + 3
C
C----- index for Cm
       IP = 2
C
       GO TO 600
C
      ENDIF
C
C
C---- no constraint defined for passed-in ICON value
      ICON = 0
      RETURN
C
C
C============================================================
 100  CONTINUE
C---- Breguet relation for mission segment IMS1..IMS2
C
      B = UPAR(IUB)
      C = UPAR(IUC)
C
C---- set effective segment D/L by averaging over aero points
      CALL DOLAVG(NAEX,IMS1,IMS2,IPMS,NPMS, NPOINT,
     &            CL, CDF, CDP, B, C, REYN, DOL )

ccc      write(*,*) 'L/D:', ims1, ims2, 1.0/DOL

C
C---- set Breguet relation with altitude-change term
      ECON = GEE*SFC/ETAP
      RC = LOG(UPAR(IUM1)/UPAR(IUM2))
     &   + ( DOL*(RANGE(IMS1) - RANGE(IMS2))
     &            + ALT(IMS1) -   ALT(IMS2) ) * ECON
C
c      write(*,*) ucname, 1.0/dol, 
c     & ETAP/(SFC*GEE)*LOG(UPAR(IUM1)/UPAR(IUM2))/1000.0/dol
c     & -(  ALT(IMS2) -   ALT(IMS1))/1000.0/dol,
c     &  (RANGE(IMS2) - RANGE(IMS1))/1000.0
C
      RETURN
C
C============================================================
 200  CONTINUE
C---- climb-rate constraint on mission point IMS
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
      PMAX = UPAR(IUP)*1000.0
C
C---- set effective D/L by averaging over aero points
      CALL DOLAVG(NAEX,IMS,IMS, IPMS,NPMS, NPOINT,
     &            CL, CDF, CDP, B, C, REYN, DOL )
C
      V = SQRT( 2.0*M*GEE/(RHO(IMS)*CL(IP)*B*C) )
C
c      write(*,*) ucname, dol, v, ETAP*PMAX/M/GEE - V*DOL

      RC = ETAP*PMAX/(M*GEE)  -  V*DOL  -  HDMIN
C
      RETURN
C
C============================================================
 300  CONTINUE
C---- reduced-Mach -- weight  constraint on mission,aero points IMS,IP
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
C
c      write(*,*) ucname, mach(ip), 
c     &           0.5*GAM*P(ims)*MACH(IP)**2*CL(IP) * B*C / GEE - M

      RC = 0.5*GAM*P(IMS)*MACH(IP)**2*CL(IP) * B*C  - M*GEE
C
      RETURN
C
C============================================================
 400  CONTINUE
C---- reduced-Re -- weight  constraint on mission,aero points IMS,IP
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
c
c      write(*,*) ucname, reyn(ip),
c     &    (MU(IMS)*REYN(IP))**2*CL(IP) * 0.5*B/(RHO(IMS)*C) / GEE - M

C
      RC = (MU(IMS)*REYN(IP))**2*CL(IP) * 0.5*B/(RHO(IMS)*C)
     &   -  M*GEE
C
      RETURN
C
C============================================================
 500  CONTINUE
C---- CL-difference constraint between aero points IP1, IP2
C
      RC  =  CL(IP1) - CL(IP2) + DCL
C
      RETURN
C
C============================================================
 600  CONTINUE
C---- empty-weight constraint on the various weight-influencing parameters
C
      M0 = UPAR(IUM0)
C
      M = UPAR(IUM)
      B = UPAR(IUB)
      C = UPAR(IUC)
      PMAX = UPAR(IUP)
C
      CALL MEMPTY( M0, B, C, ARB(1), EIB(1), CM(IP), PMAX, ME )
C
      RC  =  ME - M
C
      RETURN
C
      END



      SUBROUTINE DOLAVG(NAEX,IMS1,IMS2,IPMS,NPMS, NPOINT,
     &                  CL, CDF, CDP, B, C, RE,   DOL )
      DIMENSION IPMS(NAEX,1), NPMS(1)
      DIMENSION CL(*), CDF(*), 
     &          RE(*), CDP(*)
C-------------------------------------------
C     Averages total CD/CL over aero points
C-------------------------------------------
C
      DOL = 0.0
C
      PWTSUM = 0.
      DO IMS=IMS1, IMS2
        DO IA=1, NPMS(IMS)
C
C-------- set aero-point index and aero-point weight
          IP = IPMS(IA,IMS)
          PWT = 1.0
C
C-------- set total aircraft drag CDT
          CD = CDF(IP) + CDP(IP)
          CALL CDTOT( CL(IP), CD, B, C, RE(IP), CDT )
C
          PWTSUM = PWTSUM + PWT
C
C-------- accumulate D/L and its sensitivities
          DOL  =  DOL  +  PWT*CDT/CL(IP)
        ENDDO
      ENDDO
C
      IF(PWTSUM .GT. 0.0) THEN
        DOL = DOL/PWTSUM
      ENDIF
C
      RETURN
      END



      SUBROUTINE CDTOT(CL, CD, B, C, RE, CDT )
      DATA PI / 3.141592654 /
C
C---- general contingency factor for profile and parasite drags
      CDFUDG = 1.05
C
C---- baseline chord, span, wing area
      CB = 1.4
      BB = 40.0
C
      SWB = CB*BB
C
C---- baseline chord reduced-Reynolds number   (20 km)
      REB = 0.750E6
C
C---- Reynolds number scaling exponent for parasite CD
      RX = -0.3
C
C---- parasite drag area (m^2) at baseline Re
C-    represents fuselage, pods, radiators
      APAR = 0.42 * CDFUDG
C
C---- tail/wing area ratio
      STSW = 0.15
C
C---- tail/wing profile CD ratio
      CDTRAT = 0.8
C
C---- span efficiency
      E = 0.92
C
C---- Reynolds number scaling factor for parasite drag
      RF = ( (RE/REB) * (CB/C) / SQRT(CL) )**RX
C
C---- wing profile CD multiplier (assumes tail area scales with wing area)
      CDFAC = (1.0 + STSW*CDTRAT) * CDFUDG
C
C---- total airframe CD
      CDT = CD*CDFAC  +  APAR/(C*B)*RF  +  CL**2*C/(E*PI*B)  
C
      RETURN
      END


      SUBROUTINE MEMPTY( M0,   B,   C,   A,   TT,   CM,   PX,  M )
C-----------------------------------------------------------
C     Returns empty mass M as a function of the input
C     parameters M0, B... PX.
C
C     Assumes the various weight components scale by 
C     appropriate input/baseline parameter ratios.
C-----------------------------------------------------------
      IMPLICIT REAL (M)
C
C---- baseline parameters
      MB = 1650.0       ! empty mass (kg)
C
      M0B = 2450.0      ! GTOM  (kg)
      BB = 40.0         ! span  (m)
      CB = 1.4          ! chord (m)
C
      AB  = 0.0874475   !  A/c^2    airfoil area/c^2
      TTB = 0.00052763  ! (t/c)^2  (thickness/c)^2 at spar
C
      CMB = -0.150      ! airfoil Cm
C
      PXB = 115.0       ! max power (kW)
C
c      WRITE(*,*)
c      WRITE(*,*) 'M0',M0B,M0
c      WRITE(*,*) 'B ',BB ,B 
c      WRITE(*,*) 'C ',CB ,C 
c      WRITE(*,*) 'A ',AB ,A 
c      WRITE(*,*) 'TT',TTB,TT
c      WRITE(*,*) 'CM',CMB,CM
c      WRITE(*,*) 'PX',PXB,PX
C
C---- component empty-mass fractions
      FSPR = 0.063 + 0.009   ! wing_spar + web
      FSKN = 0.124 - 0.025   ! wing_skin - wing_Nomex
C
      FSWI = 0.036 + 0.025   ! tails + lightn_prot + wing_Nomex
      FENG = 0.126 + 0.071   ! engine + coolers
C
      FFIX = 1.0 - FSPR - FSKN - FSWI - FENG
C
C====================================
C     set new/baseline ratios
C
C---- set spar weight ratio assuming fixed deflection slope w' at GTOM
C     (M = bending moment, S = spar cap area, m = GTOM)
C
C     w'' ~ M/EI
C
C                          2
C     w' ~ bw'' ~ bM/EI ~ b  m / EI
C
C                              2      2          2  2
C     with w',E fixed...  I ~ b  m ~ t  S ~ (t/c)  c  S
C
C                          3           2  2
C     spar weight ~ b S ~ b  m / {(t/c)  c }
C
C
      RSPR = (B/BB)**3 * (M0/M0B) * (TTB/TT) * (CB/C)**2
C
C
C---- set skin weight ratio assuming fixed tip twist angle change  a
C-    over some nominal CL change  (this change is proportional to CM)
C
C     (T = torsion, A = airfoil area, Askin = skin x-sectional area)
C
C     a' ~ T/GJ
C
C     a ~ ba' ~ bT/GJ ~ b m c CM / GJ
C
C                                      2  2             2 2  2 
C     with a,G fixed... J ~ bc m CM ~ A /c  Askin ~ (A/c )  c  Askin
C
C                              2             2 2 
C     skin weight ~ b Askin ~ b  m CM / {(A/c )  c}
C
C
      RSKN = (B/BB)**2 * (M0/M0B) * (AB/A)**2 * (CB/C)*(0.5+0.5*CM/CMB)
C
C---- set wing area ratio
      RSWI = (B/BB) * (C/CB)
C
C---- set engine weight ratio
      RENG = PX/PXB
C
C---- set new empty mass
      M = MB*(FFIX + FSPR*RSPR + FSKN*RSKN + FSWI*RSWI + FENG*RENG)
C
      RETURN
      END


      SUBROUTINE ATMO(ALSPEC,VSOALT,RHOALT,RMUALT)
C---------------------------------------------------------
C     Returns speed of sound (VSO) in m/s, density (RHO)
C     in kg/m^3, and dynamic viscosity (RMU) in kg/m-s
C     of standard atmosphere at specified altitude ALSPEC
C     (in kilometers).  If ALSPEC=-1, water properties
C     at 15 Celsius are returned.
C
C     Reference:  "U.S. Standard Atmosphere", NOAA.
C---------------------------------------------------------
      LOGICAL FIRST
C
      PARAMETER ( N = 44 )
      REAL ALT(N), VSO(N), RHO(N), RMU(N)
C
      DATA FIRST / .TRUE. /
C
      DATA ALT
     &   / 0.0,  1.0,  2.0,  3.0,  4.0,  5.0,  6.0,  7.0,  8.0,  9.0,
     &    10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0,
     &    20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0,
     &    30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 
     &    40.0, 45.0, 60.0, 75.0 /
      DATA VSO
     & / 340.0,336.0,332.0,329.0,325.0,320.0,316.0,312.0,308.0,304.0,
     &   299.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,295.0,
     &   295.0,295.8,296.4,297.1,297.8,298.5,299.1,299.8,300.5,301.1,
     &   301.8,302.5,303.1,305.0,306.8,308.7,310.5,312.3,314.0,316.0,
     &   318.0,355.0,372.0,325.0 /
      DATA RHO
     & / 1.226,1.112,1.007,0.909,0.820,0.737,0.660,0.589,0.526,0.467,
     &   0.413,0.364,0.311,0.265,0.227,0.194,0.163,0.141,0.121,0.103,
     &   .0880,.0749,.0637,.0543,.0463,.0395,.0338,.0288,.0246,.0210,
     &   .0180,.0154,.0132,.0113,.0096,.0082,.0070,.0060,.0052,.0044,
     &   0.004,0.002,3.9E-4,8.0E-5 /
      DATA RMU
     & / 1.780,1.749,1.717,1.684,1.652,1.619,1.586,1.552,1.517,1.482,
     &   1.447,1.418,1.418,1.418,1.418,1.418,1.418,1.418,1.418,1.418,
     &   1.418,1.427,1.433,1.438,1.444,1.449,1.454,1.460,1.465,1.471,
     &   1.476,1.481,1.487,1.502,1.512,1.532,1.546,1.561,1.580,1.600,
     &   1.700,1.912,2.047,1.667 /
C
C---- special case: Water at STP
      IF(ALSPEC.EQ.-1.0) THEN
       VSOALT = 1500.
       RHOALT = 1000.
       RMUALT = 1.15E-3
       WRITE(*,*) '                              o        '
       WRITE(*,*) 'ATMO: You are underwater at 15  Celsius'
       RETURN
      ENDIF
C
C---- linearly interpolate quantities from tabulated values
      DO 10 I=2, N
        IF(ALSPEC.GT.ALT(I)) GO TO 10
C
         DALT = ALT(I) - ALT(I-1)
         DVSO = VSO(I) - VSO(I-1)
         DRHO = RHO(I) - RHO(I-1)
         DRMU = RMU(I) - RMU(I-1)
C
         ALFRAC = (ALSPEC - ALT(I-1)) / DALT
C
         VSOALT = VSO(I-1) + DVSO*ALFRAC
         RHOALT = RHO(I-1) + DRHO*ALFRAC
         RMUALT = RMU(I-1) + DRMU*ALFRAC
         RMUALT = RMUALT * 1.0E-5
C
         RETURN
   10 CONTINUE
C
C
      IF(ALSPEC.GT.ALT(N)) THEN
       WRITE(*,*) ' '
       WRITE(*,*) 'ATMO: You''re in low earth orbit.  Good luck.'
       VSOALT = VSO(N)
       RHOALT = RHO(N)
       RMUALT = RMU(N) * 1.0E-5
       RETURN
      ENDIF
C
c      IF(FIRST) THEN
c       DO 20 I=1, N
c         RHO(I) = ALOG(RHO(I))
c 20    CONTINUE
c       CALL SPLINE(VSO,VSOH,ALT,N)
c       CALL SPLIND(RHO,RHOH,ALT,N,999.0,0.0)
c       CALL SPLINE(RMU,RMUH,ALT,N)
c       FIRST = .FALSE.
c      ENDIF
cC
cC---- interpolate quantities from splines
c      VSOALT = SEVAL(ALSPEC,VSO,VSOH,ALT,N)
c      RHOALT = SEVAL(ALSPEC,RHO,RHOH,ALT,N)
c      RMUALT = SEVAL(ALSPEC,RMU,RMUH,ALT,N) * 1.0E-5
c      RHOALT = EXP(RHOALT)
cC
      RETURN
      END ! ATMO

