
      SUBROUTINE LEFIND(SLE,X,XP,Y,YP,S,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N),XP(N),Y(N),YP(N),S(N)
C
C**** Locates leading edge arc length value SLE
C
C---- set trailing edge point coordinates
      XTE = 0.5*(X(1) + X(N))
      YTE = 0.5*(Y(1) + Y(N))
C
C---- get first guess for SLE
      DO 10 I=3, N-2
        DXTE = X(I) - XTE
        DYTE = Y(I) - YTE
        DX = X(I+1) - X(I)
        DY = Y(I+1) - Y(I)
        DOTP = DXTE*DX + DYTE*DY
        IF(DOTP .LT. 0.0) GO TO 11
   10 CONTINUE
C
   11 SLE = S(I)
C
C---- Newton iteration to get exact SLE value
      DO 20 ITER=1, 50
        XLE  = SEVAL(SLE,X,XP,S,N)
        YLE  = SEVAL(SLE,Y,YP,S,N)
        DXDS = DEVAL(SLE,X,XP,S,N)
        DYDS = DEVAL(SLE,Y,YP,S,N)
        DXDD = D2VAL(SLE,X,XP,S,N)
        DYDD = D2VAL(SLE,Y,YP,S,N)
C
        XCHORD = XLE - XTE
        YCHORD = YLE - YTE
C
C------ drive dot product between chord line and LE tangent to zero
        RES  = XCHORD*DXDS + YCHORD*DYDS
        RESS = DXDS  *DXDS + DYDS  *DYDS
     &       + XCHORD*DXDD + YCHORD*DYDD
C
C------ Newton delta for SLE 
        DSLE = -RES/RESS
C
        CHORD = SQRT(XCHORD**2 + YCHORD**2)
        CURV = (DXDS*DYDD - DYDS*DXDD) / SQRT((DXDS**2 + DYDS**2)**3)
C
        DSLIM = 0.01*CHORD
        IF(CURV .NE. 0.0) DSLIM = MIN( DSLIM , 0.1/ABS(CURV) )
C
        DSLE = MAX( DSLE , -DSLIM )
        DSLE = MIN( DSLE ,  DSLIM )
C
        SLE = SLE + DSLE
        IF(ABS(DSLE/(S(N)-S(1))) .LT. 5.0E-5) RETURN
   20 CONTINUE
      WRITE(*,*) 'LEFIND:  LE point not found.  Continuing...'
      SLE = S(I)
      RETURN
C
      END ! LEFIND



      SUBROUTINE LUDCMP(NSIZ,N,A,INDX,LSING)
C     *******************************************************
C     *                                                     *
C     *   Factors a full NxN matrix into an LU form.        *
C     *   Subr. BAKSUB can back-substitute it with some RHS.*
C     *   Assumes matrix is non-singular...                 *
C     *    ...if it isn't, LSING is returned .TRUE.         *
C     *                                                     *
C     *   A is the matrix...                                *
C     *    ...replaced with its LU factors if non-singular. *
C     *                                                     *
C     *                              Mark Drela  1988       *
C     *******************************************************
C
      DIMENSION A(NSIZ,NSIZ), INDX(NSIZ)
      PARAMETER (NVV=250)
      DIMENSION VV(NVV)
      LOGICAL LSING
C
      IF(N .GT. NVV) STOP 'LUDCMP: Array overflow.'
C
      DO 12 I=1, N
        AAMAX = 0.
        DO 11 J=1, N
          AAMAX = MAX( ABS(A(I,J)) , AAMAX )
   11   CONTINUE
C
        LSING = AAMAX .EQ. 0.0
        IF(LSING) RETURN
C
        VV(I) = 1.0/AAMAX
   12 CONTINUE
C
      DO 19 J=1, N
        DO 14 I=1, J-1
          SUM = A(I,J)
          DO 13 K=1, I-1
            SUM = SUM - A(I,K)*A(K,J)
   13     CONTINUE
          A(I,J) = SUM
   14   CONTINUE
C
        AAMAX = 0.
        DO 16 I=J, N
          SUM = A(I,J)
          DO 15 K=1, J-1
            SUM = SUM - A(I,K)*A(K,J)
   15     CONTINUE
          A(I,J) = SUM
C
          DUM = VV(I)*ABS(SUM)
          IF(DUM.GE.AAMAX) THEN
           IMAX = I
           AAMAX = DUM
          ENDIF
   16   CONTINUE
C
        IF(J.NE.IMAX) THEN
         DO 17 K=1, N
           DUM = A(IMAX,K)
           A(IMAX,K) = A(J,K)
           A(J,K) = DUM
   17    CONTINUE
         VV(IMAX) = VV(J)
        ENDIF
C
        INDX(J) = IMAX
        IF(J.NE.N) THEN
         LSING = A(J,J) .EQ. 0.0
         IF(LSING) RETURN
C
         DUM = 1.0/A(J,J)
         DO 18 I=J+1, N
           A(I,J) = A(I,J)*DUM
   18    CONTINUE
        ENDIF
C
   19 CONTINUE
C
      RETURN
      END ! LUDCMP


      SUBROUTINE BAKSUB(NSIZ,N,A,INDX,B)
      DIMENSION A(NSIZ,NSIZ), B(NSIZ), INDX(NSIZ)
C
      II = 0
      DO 12 I=1, N
        LL = INDX(I)
        SUM = B(LL)
        B(LL) = B(I)
        IF(II.NE.0) THEN
         DO 11 J=II, I-1
           SUM = SUM - A(I,J)*B(J)
   11    CONTINUE
        ELSE IF(SUM.NE.0.0) THEN
         II = I
        ENDIF
        B(I) = SUM
   12 CONTINUE
C
      DO 14 I=N, 1, -1
        SUM = B(I)
        IF(I.LT.N) THEN
         DO 13 J=I+1, N
           SUM = SUM - A(I,J)*B(J)
   13    CONTINUE
        ENDIF
        B(I) = SUM/A(I,I)
   14 CONTINUE
C
      RETURN
      END ! BAKSUB



      SUBROUTINE SORT(NDIM,N,NT,S,T)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S(NDIM), T(NDIM,NT)
      LOGICAL DONE
C
      IF(N.LE.1) RETURN
C
C---- sort array S, reordering T the same way
      DO 1 IPASS=1, 2*N
        DONE = .TRUE.
        DO 11 I=1, N-1
          IP = I+1
          IF(S(IP).GE.S(I)) GO TO 11
C
           TEMP  = S(IP)
           S(IP) = S(I)
           S(I)  = TEMP
C
           DO 111 K=1, NT
             TEMP    = T(IP,K)
             T(IP,K) = T(I,K)
             T(I,K)  = TEMP
 111       CONTINUE
C
           DONE = .FALSE.
 11     CONTINUE
        IF(DONE) RETURN
 1    CONTINUE
      STOP 'SORT failed'
      END ! SORT



      SUBROUTINE REMD(NDIM,N,NT,S,T)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION S(NDIM), T(NDIM,NT)
C
C---- search for duplicate S pairs and eliminate each one along with T
      NS = N
      DO 2 I=1, NS
        IF(I.GE.N) RETURN
        IF( ABS(S(I)-S(I+1)) .GT. 1.0E-8) GO TO 2
C
C------ eliminate first entry in pair
        N = N - 1
        DO 21 IT=I, N
          S(IT) = S(IT+1)
          DO 214 K=1, NT
            T(IT,K) = T(IT+1,K)
 214      CONTINUE
  21    CONTINUE
   2  CONTINUE
C
      RETURN
      END ! REMD



      SUBROUTINE SGSCAL(II,Y,YOFF,YSF,ANN,NANN)
      DIMENSION Y(II)
C.............................................................
C
C     Y(1:II)  array whose scaling factor is to be determined
C     YOFF     offset of Y array  (Y-YOFF is actually scaled)
C     YSF      Y scaling factor
C     ANN      recommended max annotation value on Y axis 
C     NANN     recommended number of annotations on Y axis
C.............................................................
C
      AG2 = ALOG10(2.0)
      AG3 = ALOG10(3.0)
      AG4 = ALOG10(4.0)
      AG5 = ALOG10(5.0)
C
      YMAX = Y(1) - YOFF
      DO 10 I=2, II
        IF(ABS(Y(I)-YOFF) .GT. ABS(YMAX)) YMAX = Y(I)-YOFF
   10 CONTINUE
C
      IF(YMAX.EQ.0.0) THEN
       WRITE(*,*) 'SCALIT: Zero array passed in'
       YSF = 1.0E8
       RETURN
      ENDIF
C
      YLOG = ALOG10( ABS(YMAX) )
C
C---- find log of nearest power of 10 above YMAX
      YLOG1 = AINT(YLOG+100.0) - 99.0
 
C---- find log of nearest 2x(power of 10) above YMAX
      YLOG2 = YLOG1 + AG2
      IF(YLOG2-1.0.GE.YLOG) YLOG2 = YLOG2 - 1.0
C
C---- find log of nearest 3x(power of 10) above YMAX
      YLOG3 = YLOG1 + AG3
      IF(YLOG3-1.0.GE.YLOG) YLOG3 = YLOG3 - 1.0
C
C---- find log of nearest 4x(power of 10) above YMAX
      YLOG4 = YLOG1 + AG4
      IF(YLOG4-1.0.GE.YLOG) YLOG4 = YLOG4 - 1.0
C
C---- find log of nearest 5x(power of 10) above YMAX
      YLOG5 = YLOG1 + AG5
      IF(YLOG5-1.0.GE.YLOG) YLOG5 = YLOG5 - 1.0
C
C---- find log of smallest upper bound
      GMIN = MIN( YLOG1 , YLOG2 , YLOG3, YLOG4, YLOG5 )
C
      NANN = 5
      IF (GMIN.EQ.YLOG2) NANN = 4
      IF (GMIN.EQ.YLOG3) NANN = 3
      IF (GMIN.EQ.YLOG4) NANN = 4
C
C---- set max annotation
      ANNLOG = GMIN - AINT(GMIN+100.01) + 100.0
      ANN = 10.0**ANNLOG
C
C---- set scaling factor
      YSF = SIGN( 10.0**(-GMIN) , YMAX )
C
      RETURN
      END ! SGSCAL
