
      program pwrite
c
c     Reads specified mdat.xxx files and creates a standard 
c     formatted polar file which can be plotted with PPLOT.
c
c       % pwrite xxx1 xxx2 xxx3 xxx4 ...
c
      include '../../src/STATE.INC'
      parameter (npx=20)
      dimension cl(npx),cd(npx),cdw(npx),cm(npx), adeg(npx),reinf(npx)
      character*80 argp(npx), fname, LINE1, LINE2
      dimension CL_AL(npx), CD_AL(npx), CL_MA(npx),CD_MA(npx),
     &          XTRP(ISX,npx)

c
      do kp=1, npx
        argp(kp) = '                                           '
        call getarg(kp,argp(kp))
        if(argp(kp)(1:1) .eq. ' ') go to 6
      enddo
 6    np = kp-1
c
      do kp=1, np
c
      CALL INPUTN(KP)
C
C==========================================================
C
      que = 0.5*rhoinf*qinf**2
      cl(kp) = lift/que
      cd(kp) = (dragw+dragv)/que
      cm(kp) = momn/que
      cdw(kp) = dragw/que
      adeg(kp) = alfa*45.0/atan(1.0)
      reinf(kp) = reyn * rhoinf*qinf/muinf
c
      CL_AL(kp) = cl_alfa
      CL_MA(kp) = cl_minf
      CD_AL(kp) = cdv_alfa + cdw_alfa
      CD_MA(kp) = cdv_minf + cdw_minf
      do is=1, 2*nbl
        XTRP(IS,kp) = xtr(is)
      enddo
c
      enddo

 1000 format(1x,a)
c
      IRETYP = 1
      IMATYP = 1
      IFFBC = 2
      ISMOM = 2
c
      fname = 'polar.'
      open(4,file=fname,status='new')

      WRITE(4,*) ' '
      WRITE(4,8995) VERSION
 8995 FORMAT(1X,'MSES polar driver   Version', F4.1)
      WRITE(4,*) ' '
      WRITE(4,9000) NAME, NBL
 9000 FORMAT(1X,'Calculated polar for: ', A32, 5X, I2, ' elements')
      WRITE(4,*) ' '
C
      IF(IRETYP.EQ.1) LINE1 = ' Reynolds number fixed       '
      IF(IRETYP.EQ.2) LINE1 = ' Reynolds number ~ 1/sqrt(CL)'
      IF(IRETYP.EQ.3) LINE1 = ' Reynolds number ~ 1/CL      '
      IF(IMATYP.EQ.1) LINE2 = '   Mach number fixed         '
      IF(IMATYP.EQ.2) LINE2 = '   Mach number ~ 1/sqrt(CL)  '
      IF(IMATYP.EQ.3) LINE2 = '   Mach number ~ 1/CL        '
      WRITE(4,9002) IRETYP, IMATYP, LINE1, LINE2
 9002 FORMAT(1X,I1,I2,2A29)
C
      IF(IFFBC.EQ.1)  LINE1 = ' Solid wall far field        '
      IF(IFFBC.EQ.2)  LINE1 = ' Vortex + doublet far field  '
      IF(IFFBC.EQ.3)  LINE1 = ' Constant pressure far field '
      IF(IFFBC.EQ.4)  LINE1 = ' Supersonic wave far field   '
      IF(IFFBC.GE.5)  LINE1 = '                             '
      IF(ISMOM.EQ.1)  LINE2 = '   S-momentum conserved      '
      IF(ISMOM.EQ.2)  LINE2 = '   Entropy conserved         '
      IF(ISMOM.EQ.3)  LINE2 = '   Entropy conserved near LE '
      IF(ISMOM.GE.4)  LINE2 = '                             '
      WRITE(4,9006) LINE1, LINE2
 9006 FORMAT(1X,3X,2A29)
C
      WRITE(4,*) ' '
      WRITE(4,9010) MINF,REINF(np)/1.0E6,ACRIT
 9010 FORMAT(1X,
     &'Mach = ',F7.3,5X,'Re = ',F9.3,' e 6',5X,'Ncrit = ',F7.3)
C
      WRITE(4,*) ' '
      WRITE(4,9020)
     &'  alpha     CL        CD       CDi       CM   ' //
     &'  dCL/da   dCD/da   dCL/dM   dCD/dM ' //
     &'  S xtr   P xtr '
      WRITE(4,9020)
     &' ------- -------- --------- --------- --------' //
     &'  ------  --------  ------  --------' //
     &'  ------  ------'
CCC      3.453   1.3750   0.00921   0.00251  -0.1450 
CCC      0.3245  0.002341  10.234  0.131234
CCC      0.9231  0.5382
 9020 FORMAT(1X,A)
C
      pie = 4.0*atan(1.0)
      do kp=1, np
         WRITE(4,9110) ADEG(kp),CL(kp),CD(kp),CDW(kp),CM(kp),
     &                 CL_AL(kp)*PIE/180.0, CD_AL(kp)*PIE/180.0,
     &                 CL_MA(kp),CD_MA(kp),
     &                 (XTRP(IS,kp),IS=1,2*NBL)
      enddo
 9110    FORMAT(1X,
     &       F7.3,    F9.4,    F10.5,    F10.5,    F9.4,
     &       F9.4,    F10.6,   F8.3,    F10.6,
     &     8( F9.4 ,  F8.4) )
c
      CLOSE(UNIT=4)
c
      write(*,*) 'Polar file written:  ', fname
c
      stop
      end
 


      SUBROUTINE INPUTN(INP)
      INCLUDE 'STATE.INC'
      CHARACTER*80 ARGP1, FNAME
      DIMENSION SSTATE(NSTATS), ISTATE(NSTATI)
      EQUIVALENCE (alf1,SSTATE(1)), (II,ISTATE(1))
C
      CALL GETARG(INP,ARGP1)
      FNAME = 'mdat.' // ARGP1 
      LU = 1
C
      OPEN(LU,FILE=FNAME,STATUS='OLD',FORM='UNFORMATTED')
C
      READ(LU) NAME
      READ(LU) (ISTATE(I),I=1,NSTATI)
      READ(LU) (SSTATE(I),I=1,NSTATS)
C
      READ(LU) (JBLD(N),NINL(N),NOUT(N),NBLD(N),IIB(N),IBLE(N),N=1,NBL)
C
      DO 10 J=1, JJ
        READ(LU) MFRACT(J)
        READ(LU) (X(I,J), Y(I,J), R(I,J), I=1, II)
 10   CONTINUE
C
      DO 20 N=1, NBL
        READ(LU) (XB(IB,N), YB(IB,N), XPB(IB,N), YPB(IB,N), SB(IB,N), 
     &           IB=1, IIB(N))
        READ(LU) (SGINL(I,N), SGOUT(I,N), XW(I,N), YW(I,N), WGAP(I,N),
     &           I=1, II)
 20   CONTINUE
C
C
      NS = 2*NBL
C
      DO 30 IS=1, NS
        READ(LU) (SG(I,IS), DISP(I,IS), PSPEC(I,IS), I=1, II)
        READ(LU) 
     &      (THET(I,IS), DSTR(I,IS), UEDG(I,IS), CTAU(I,IS), TAU(I,IS),
     &       I=1, II)
 30   CONTINUE
C
      READ(LU) (KNOR(IS), IS=1, NS)
      DO 40 IS=1, NS
        READ(LU) (SNOR(K,IS),XNOR(K,IS),XSNOR(K,IS),
     &                       YNOR(K,IS),YSNOR(K,IS), K=1, KNOR(IS))
 40   CONTINUE
C
      READ(LU) (BLIFT(N),BDRAG(N),BMOMN(N),BDRAGV(N),BDRAGF(N),N=1,NBL)
      READ(LU) (SBLE(N),SBLOLD(N),SWAK(N),SBCMAX(N),SBNOSE(N),N=1,NBL)
      READ(LU) (XBNOSE(N),YBNOSE(N),XBTAIL(N),YBTAIL(N),N=1,NBL)
      READ(LU) (PXX0(IS),PXX1(IS),XTR(IS),STR1(IS),IS=1,NS)
      IF(NMODN.GT.0) THEN
        READ(LU) (CL_MOD(K),CM_MOD(K),CDW_MOD(K),CDV_MOD(K),CDF_MOD(K),
     &          MODN(K),DMSPN(K),K=1,NMODN)
      ENDIF
      IF(NPOSN.GT.0) THEN
        READ(LU) (CL_POS(K),CM_POS(K),CDW_POS(K),CDV_POS(K),CDF_POS(K),
     &          POSN(K),DPSPN(K),K=1,NPOSN)
      ENDIF
C
      READ(LU) (IGFIX(IS),IGCORN(IS),ITRAN(IS),IS=1,NS)
C
      DO 50 NBIT=1, NBITX
        READ(LU,ERR=51) (ISBITS(NBIT,I),I=1, II)
 50   CONTINUE
 51   CONTINUE
C
      CLOSE(LU)
      RETURN
      END
