
      program swrite
c
c     Reads specified mdat.xxx files and creates a standard 
c     formatted Mach sweep file which can be plotted with SPLOT.
c
c       % swrite xxx1 xxx2 xxx3 xxx4 ...
c
      include '../../src/STATE.INC'
      parameter (npx=20)
      dimension mach(npx),
     &          cl(npx),cd(npx),cdw(npx),cm(npx), adeg(npx),reinf(npx)
      character*80 argp(npx), fname, LINE1, LINE2
      dimension CL_AL(npx), CD_AL(npx), CL_MA(npx),CD_MA(npx),
     &          XTRP(ISX,npx)

c
      do kp=1, npx
        argp(kp) = '                                           '
        call getarg(kp,argp(kp))
        if(argp(kp)(1:1) .eq. ' ') go to 6
      enddo
 6    np = kp-1
c
      do kp=1, np
c
      FNAME = 'mdat.' // ARGP(kp)
C
C==========================================================
C---- machine-independent i/o with iolib library
C
      IERR = IOOPER(1,FNAME,'OLD')
      IF(IERR.LT.0) THEN
        WRITE(*,*) 'IOOPER Error ...'
        CALL IOERR(IERR)
        STOP
      ENDIF
      CALL INPUT
      CALL IOCLOS(1)
C
C==========================================================
C---- conventional unformatted i/o
C
ccc      OPEN(1,FILE=FNAME,STATUS='OLD',FORM='UNFORMATTED')
ccc      CALL INPUT
ccc      CLOSE(1)
C
C==========================================================
C
      que = 0.5*rhoinf*qinf**2
      cl(kp) = lift/que
      cd(kp) = (dragw+dragv)/que
      cm(kp) = momn/que
      cdw(kp) = dragw/que
      adeg(kp) = alfa*45.0/atan(1.0)
      reinf(kp) = reyn * rhoinf*qinf/muinf
      mach(kp) = minf
c
      CL_AL(kp) = cl_alfa
      CL_MA(kp) = cl_minf
      CD_AL(kp) = cdv_alfa + cdw_alfa
      CD_MA(kp) = cdv_minf + cdw_minf
      do is=1, 2*nbl
        XTRP(IS,kp) = xtr(is)
      enddo
c
      enddo

 1000 format(1x,a)
c
      IRETYP = 1
      IMATYP = 1
      IFFBC = 2
      ISMOM = 2
c
      fname = 'msweep.'
      open(4,file=fname,status='new')

      WRITE(4,*) ' '
      WRITE(4,8995) VERSION
 8995 FORMAT(1X,'MSES sweep driver   Version', F4.1)
      WRITE(4,*) ' '
      WRITE(4,9000) NAME, NBL
 9000 FORMAT(1X,'Calculated sweep for: ', A32, 5X, I2, ' elements')
      WRITE(4,*) ' '
C
      IF(IRETYP.EQ.1) LINE1 = ' Reynolds number fixed       '
      IF(IRETYP.EQ.2) LINE1 = ' Reynolds number ~ 1/sqrt(CL)'
      IF(IRETYP.EQ.3) LINE1 = ' Reynolds number ~ 1/CL      '
      IF(IMATYP.EQ.1) LINE2 = '   Mach number fixed         '
      IF(IMATYP.EQ.2) LINE2 = '   Mach number ~ 1/sqrt(CL)  '
      IF(IMATYP.EQ.3) LINE2 = '   Mach number ~ 1/CL        '
      WRITE(4,9002) IRETYP, IMATYP, LINE1, LINE2
 9002 FORMAT(1X,I1,I2,2A29)
C
      IF(IFFBC.EQ.1)  LINE1 = ' Solid wall far field        '
      IF(IFFBC.EQ.2)  LINE1 = ' Vortex + doublet far field  '
      IF(IFFBC.EQ.3)  LINE1 = ' Constant pressure far field '
      IF(IFFBC.EQ.4)  LINE1 = ' Supersonic wave far field   '
      IF(IFFBC.GE.5)  LINE1 = '                             '
      IF(ISMOM.EQ.1)  LINE2 = '   S-momentum conserved      '
      IF(ISMOM.EQ.2)  LINE2 = '   Entropy conserved         '
      IF(ISMOM.EQ.3)  LINE2 = '   Entropy conserved near LE '
      IF(ISMOM.GE.4)  LINE2 = '                             '
      WRITE(4,9006) LINE1, LINE2
 9006 FORMAT(1X,3X,2A29)
C
      WRITE(4,*) ' '
      WRITE(4,9010) reinf(np)/1.0E6,ACRIT
 9010 FORMAT(1X,'Re = ',F9.3,' e 6',5X,'Ncrit = ',F7.3)
C
      WRITE(4,*) ' '
c      WRITE(4,9020)
c     &'  Mach   alpha     CL        CD       CDi       CM   ' //
c     &'  dCL/da   dCD/da   dCL/dM   dCD/dM ' //
c     &'  S xtr   P xtr '
c      WRITE(4,9020)
c     &  ' ------ ------- -------- --------- --------- --------' //
c     &  '  ------  --------  ------  --------' //
c     &  '  ------  ------'
c
      WRITE(4,9020)
     &  '  Mach   alpha     CL        CDf      CDp       CM   ' //
     &  '  dCL/da   dCDf/da   dCDp/da  dCL/dM   dCDf/dM   dCDp/dM '
      WRITE(4,9020)
     &  ' ------ ------- -------- --------- --------- --------' //
     &  '  ------  --------  --------  ------  --------  --------'
CCC     0.8750  3.453   1.3750   0.00921   0.00251  -0.1450 
CCC      0.3245  0.002341  10.234  0.131234
 9020 FORMAT(1X,A)
C
      pie = 4.0*atan(1.0)
      do kp=1, np
         WRITE(4,9111) MACH(kp), ADEG(kp),CL(kp),CD(kp),CDW(kp),CM(kp),
     &                 CL_AL(kp)*PIE/180.0, CD_AL(kp)*PIE/180.0,
     &                 CL_MA(kp),CD_MA(kp)
ccc     &                 (XTRP(IS,kp),IS=1,2*NBL)
      enddo
      CLOSE(UNIT=4)
C
 9111 FORMAT(1X,
     &       F7.4,  F7.3,    F9.4,    F10.5,    F10.5,    F9.4,
     &       F9.4,    F10.6,   F10.6,   F8.3,    F10.6,   F10.6 )
c
      write(*,*) 'Sweep file written:  ', fname
c
      stop
      end

