#***********************************************************************
#    Module:  Makefile
# 
#    Copyright (C) 1996 Harold Youngren, Mark Drela 
# 
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Library General Public
#    License as published by the Free Software Foundation; either
#    version 2 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Library General Public License for more details.
#
#    You should have received a copy of the GNU Library General Public
#    License along with this library; if not, write to the Free
#    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#    Report problems to:    guppy@maine.com 
#                        or drela@orville.mit.edu  
#***********************************************************************



#################################
# makefile for Xplot11 library  #
#################################

#point to your install directory
INSTALLDIR= $(HOME)/lib
#INSTALLDIR= /usr/local/lib
#INSTALLDIR= .

### Use these to set library name 
### (add DP to keep double precision version separate)
PLTLIB = libPlt.a
#PLTLIB = libPltDP.a

###========================================================
###  Basic plot library object files
OBJ     = plt_base.o plt_font.o plt_util.o plt_color.o \
          set_subs.o gw_subs.o ps_subs.o Xwin.o
OBJMISC =
OBJ3D   =
OBJOLD  =
###
###--------------------------------------------------------
###  Uncomment to add the old plot compatibility routines
#OBJOLD  = plt_old.o
###
###--------------------------------------------------------
###  Uncomment to add the 3D-view routines
OBJ3D  = plt_3D.o
###
###--------------------------------------------------------
###  Uncomment for f77 compiler w/o AND() and RSHIFT/LSHIFT functions.
###   This adds some functions to duplicate these using IAND and ISHFT
###   which often appear in these offending fortran's libraries.
###   The compilers that this has affected include:
###      HPUX f77
###      Absoft f77 on Linux
###
#OBJMISC = util-ops.o


###================================================
###  Default compilers and flags, install commands
FC = f77
CC  = cc

# Uncomment DP to make double-precision version
#DP = -r8

# Some fortrans need trailing underscores in C interface symbols (see Xwin.c)
DEFINE = -DUNDERSCORE

FFLAGS  = -O $(DP)
CFLAGS  = -O $(DEFINE)
AR = ar r 
RANLIB = ranlib
LINKLIB =  -lX11 


###-------------------------------------------------------------------------
### Select compile options if one of these is appropriate
###-------------------------------------------------------------------------

###-------------------------------------------------------------------------
###  Uncomment for Linux, using the script f77 (unusable in Slackware 3.0) 
###  Note compiler options for Linux:
###   f77    script (calls f2c/gcc) note bug in Slackware 3.0 f77 script
###   fort77 script (calls f2c/gcc) perl script from RH or from yaf77
###   g77    the GNU F77 compiler 
#FC = g77
#FC = fort77
#FC = f77-f2c 
#CC  = gcc
# Uncomment DP to make double-precision version
# (note -r8 does not work in g77, use f2c instead)
#DP = -r8
#FFLAGS  = -O2 $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#LINKLIB = -L/usr/X11R6/lib -lX11 

###-------------------------------------------------------------------------
###  Uncomment for Linux, using PGI f77
#FC = pgf77
#CC  = gcc
##
# Uncomment to make double-precision version
#DP = -r8
#FFLAGS  = -fast -O $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#LINKLIB = -L/usr/X11R6/lib -lX11

###-------------------------------------------------------------------------
###  Uncomment for Linux, using Absoft f77
#FC = f77
#CC  = gcc
##
# Uncomment to make double-precision version
# (note -r8 does not work in Absoft f77, but -N113 does...)
#DP = -N113
# PPro only executable 
#FFLAGS  = -s -f -O -B108 -N3 -N90 -B100 $(DP)
# Pentium and PPro executable 
#FFLAGS  = -s -f -O -B108 -N3 -N90 -B101 $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#OBJMISC = util-ops.o
#LINKLIB = -L/usr/X11R6/lib -lX11 -lU77

###-------------------------------------------------------------------------
###  Uncomment for DEC OSF/Alpha
FC = f77 
#
# Uncomment DP to make double-precision version
#DP = -r8
CFLAGS = -O4 -float $(DEFINE)
FFLAGS = -O4 $(DP)
# Debug flags
#CFLAGS = -O0 -g -float $(DEFINE) 
#FFLAGS = -O0 -g $(DP)
 
###-------------------------------------------------------------------------
###  Uncomment for RS/6000
# Note if the library is compiled double precision use the -qautodbl=dbl4 
# option, not the -qautodbl=dblpad4 option.  The dblpad4 option puts padding
# into the argument lists for integer args that cause the polylines and 
# linepatterns to fail as the alignment assumptions between the C and fortran
# routines are then different.  (The problem lies with xlf90, at least you 
# can cure it with a compile option:-). This is not a problem on xlf (f77) 
# because it doesn't have a dblpad4 option...
#
#FC = xlf90
#
# Uncomment DP to make double-precision version
#DP = -qautodbl=dbl4
#FFLAGS = -O -qextname -qfixed $(DP) 

###-------------------------------------------------------------------------
###  Uncomment for Sun Open-Windows 
###  (give location of X11/xxx.h include files)
#
# Uncomment DP to make double-precision version
#DP = -r8
#FFLAGS = -O $(DP)
#CFLAGS = -O -I/usr/openwin/share/include $(DEFINE)

###-------------------------------------------------------------------------
###  Uncomment for HP-9000
###  (use ANSI-C standard, use underscored C-routine names)
#
# Uncomment DP to make double-precision version
#DP = -r8
#CFLAGS = -O -Aa $(DEFINE)
#FFLAGS = -O +ppu $(DP)
#OBJMISC = util-ops.o

###-------------------------------------------------------------------------
###  Uncomment for SGI IRIX
###  (use ANSI-C standard, use underscored C-routine names)
#
# Uncomment DP to make double-precision version
#DP = -r8
#CFLAGS = -O $(DEFINE)
#FFLAGS = -O -static  $(DP)
#RANLIB = ar qs





###-------------------------------------------------------------------------
### Basic make targets - build library, test programs

$(PLTLIB):  $(OBJ) $(OBJOLD) $(OBJ3D) $(OBJMISC)
	$(AR)     $(PLTLIB) $(OBJ) $(OBJOLD) $(OBJ3D) $(OBJMISC)
	$(RANLIB) $(PLTLIB)

test:  $(PLTLIB)
	(cd examples; make test)


###-------------------------------------------------------------------------
### Utility functions - install the library, clean the directory

install:  $(PLTLIB)
	mv $(PLTLIB) $(INSTALLDIR)
	$(RANLIB)   $(INSTALLDIR)/$(PLTLIB)

clean:
	-/bin/rm *.o
	-/bin/rm *.a 
	-/bin/rm plot*.ps
	(cd examples; make clean)



###-------------------------------------------------------------------------
### compile plot package routines

plt_base.o: plt_base.f pltlib.inc
	$(FC) -c $(FFLAGS)  plt_base.f

plt_color.o: plt_color.f  pltlib.inc
	$(FC) -c $(FFLAGS)  plt_color.f

plt_font.o: plt_font.f CHAR.INC SLAN.INC MATH.INC SYMB.INC
	$(FC) -c $(FFLAGS)  plt_font.f

plt_util.o: plt_util.f
	$(FC) -c $(FFLAGS)  plt_util.f

plt_3D.o: plt_3D.f
	$(FC) -c $(FFLAGS)  plt_3D.f

plt_old.o: plt_old.f pltlib.inc
	$(FC) -c $(FFLAGS)  plt_old.f

set_subs.o: set_subs.f  pltlib.inc
	$(FC) -c $(FFLAGS)  set_subs.f

gw_subs.o: gw_subs.f  pltlib.inc
	$(FC) -c $(FFLAGS)  gw_subs.f

ps_subs.o: ps_subs.f  pltlib.inc
	$(FC) -c $(FFLAGS)  ps_subs.f

util-ops.o: util-ops.f 
	$(FC) -c $(FFLAGS)  util-ops.f

Xwin.o: Xwin.c
	$(CC) -c $(CFLAGS) Xwin.c


### May need to specify these on a brain-dead make system
#.f.o:	$(FC) -c $(FFLAGS) $<
#.c.o:	$(CC)  -c $(CFLAGS) $<



