#***********************************************************************
#    Module:  Makefile (examples directory)
# 
#    Copyright (C) 1996 Harold Youngren, Mark Drela 
# 
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Library General Public
#    License as published by the Free Software Foundation; either
#    version 2 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Library General Public License for more details.
#
#    You should have received a copy of the GNU Library General Public
#    License along with this library; if not, write to the Free
#    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#    Report problems to:    guppy@netcom.com 
#                        or drela@henry.mit.edu  
#***********************************************************************



########################################
# makefile for Xplot11 library examples
########################################

#PLTLIB  = -L.. -lPlt 
#PLTLIB  = -L.. -lPltDP 
PLTLIB  = ../libPlt.a 
#PLTLIB  = ../libPltDP.a 

#### Link libs default
LINKLIB =  -lX11
#### Link libs required on Linux
LINKLIB =  -L/usr/X11R6/lib -lX11
#### Link libs required Absoft f77 on Linux
#LINKLIB =  -L/usr/X11R6/lib -lX11 -lU77
#### Link libs required for xlf90 
#LINKLIB =  -lX11   -L/fortran/libfor -lxlfabb 
 


###================================================
###  Default compilers and flags, install commands
F77 = f77
CC  = cc
# Uncomment DP to make double-precision version
#DP = -r8
FFLAGS  = -O $(DP)
CFLAGS  = -O 
AR = ar r 
RANLIB = ranlib


###-------------------------------------------------------------------------
### Select compile options if one of these is appropriate
###-------------------------------------------------------------------------

###-------------------------------------------------------------------------
###  Uncomment for Linux, using the script f77 (unusable in Slackware 3.0) 
###  Note compiler options for Linux:
###   f77    script (calls f2c/gcc) note bug in Slackware 3.0 f77 script
###   fort77 script (calls f2c/gcc) perl script from RH or from yaf77
###   g77    the GNU F77 compiler 
#FC = g77
#FC = fort77
#FC = f77-f2c 
#CC  = gcc
# Uncomment DP to make double-precision version
# (note -r8 does not work in g77, use f2c instead)
#DP = -r8
#FFLAGS  = -O2 $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#LINKLIB = -L/usr/X11R6/lib -lX11 

###-------------------------------------------------------------------------
###  Uncomment for Linux, using PGI f77
#FC = pgf77
#CC  = gcc
##
# Uncomment to make double-precision version
#DP = -r8
#FFLAGS  = -fast -O $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#LINKLIB = -L/usr/X11R6/lib -lX11

###-------------------------------------------------------------------------
###  Uncomment for Linux, using Absoft f77
#FC = f77
#CC  = gcc
##
# Uncomment to make double-precision version
# (note -r8 does not work in Absoft f77, but -N113 does...)
#DP = -N113
# PPro only executable 
#FFLAGS  = -s -f -O -B108 -N3 -N90 -B100 $(DP)
# Pentium and PPro executable 
#FFLAGS  = -s -f -O -B108 -N3 -N90 -B101 $(DP)
#CFLAGS  = -O2 $(DEFINE)
#AR = ar r
#RANLIB = ranlib 
#OBJMISC = util-ops.o
#LINKLIB = -L/usr/X11R6/lib -lX11 -lU77

###-------------------------------------------------------------------------
###  Uncomment for DEC OSF/Alpha
FC = f77 
#
# Uncomment DP to make double-precision version
#DP = -r8
CFLAGS = -O4 -float $(DEFINE)
FFLAGS = -O4 $(DP)
# Debug flags
#CFLAGS = -O0 -g -float $(DEFINE) 
#FFLAGS = -O0 -g $(DP)
 
###-------------------------------------------------------------------------
###  Uncomment for RS/6000
# Note if the library is compiled double precision use the -qautodbl=dbl4 
# option, not the -qautodbl=dblpad4 option.  The dblpad4 option puts padding
# into the argument lists for integer args that cause the polylines and 
# linepatterns to fail as the alignment assumptions between the C and fortran
# routines are then different.  (The problem lies with xlf90, at least you 
# can cure it with a compile option:-). This is not a problem on xlf (f77) 
# because it doesn't have a dblpad4 option...
#
#FC = xlf90
#
# Uncomment DP to make double-precision version
#DP = -qautodbl=dbl4
#FFLAGS = -O -qextname -qfixed $(DP) 

###-------------------------------------------------------------------------
###  Uncomment for Sun Open-Windows 
###  (give location of X11/xxx.h include files)
#
# Uncomment DP to make double-precision version
#DP = -r8
#FFLAGS = -O $(DP)
#CFLAGS = -O -I/usr/openwin/share/include $(DEFINE)

###-------------------------------------------------------------------------
###  Uncomment for HP-9000
###  (use ANSI-C standard, use underscored C-routine names)
#
# Uncomment DP to make double-precision version
#DP = -r8
#CFLAGS = -O -Aa $(DEFINE)
#FFLAGS = -O +ppu $(DP)
#OBJMISC = util-ops.o

###-------------------------------------------------------------------------
###  Uncomment for SGI IRIX
###  (use ANSI-C standard, use underscored C-routine names)
#
# Uncomment DP to make double-precision version
#DP = -r8
#CFLAGS = -O $(DEFINE)
#FFLAGS = -O -static  $(DP)
#RANLIB = ar qs



PROGS = volts volts_old \
        symbols symbolsall \
	squares squaresdoublebuff \
	spectrum cmap2 cmap3 defmap \
        gridtest zoomtest contest


examples:  $(PROGS)


test:  $(PROGS)

clean:
	-/bin/rm *.o
	-/bin/rm $(PROGS)
	-/bin/rm plot*.ps



#Test routines for package

volts: volts.o 
	$(FC) -o volts volts.o $(PLTLIB) $(LINKLIB)

volts_old: volts_old.o 
	$(FC) -o volts_old volts_old.o $(PLTLIB) $(LINKLIB)

symbols: symbols.o 
	$(FC) -o symbols symbols.o $(PLTLIB) $(LINKLIB)

symbolsall: symbolsall.o 
	$(FC) -o symbolsall symbolsall.o $(PLTLIB) $(LINKLIB)

squares: squares.o
	$(FC) -o squares squares.o $(PLTLIB) $(LINKLIB)

squaresdoublebuff: squaresdoublebuff.o
	$(FC) -o squaresdoublebuff squaresdoublebuff.o $(PLTLIB) $(LINKLIB)

spectrum: spectrum.o 
	$(FC) -o spectrum spectrum.o $(PLTLIB) $(LINKLIB)

cmap2: cmap2.o 
	$(FC) -o cmap2 cmap2.o $(PLTLIB) $(LINKLIB)

cmap3: cmap3.o 
	$(FC) -o cmap3 cmap3.o $(PLTLIB) $(LINKLIB)
 
defmap: defmap.o
	$(FC) -o defmap defmap.o $(PLTLIB) $(LINKLIB)

gridtest: gridtest.o 
	$(FC) -o gridtest gridtest.o $(PLTLIB) $(LINKLIB)

zoomtest: zoomtest.o 
	$(FC) -o zoomtest zoomtest.o $(PLTLIB) $(LINKLIB)

contest: contest.o 
	$(FC) -o contest contest.o $(PLTLIB) $(LINKLIB)



volts.o: volts.f
	$(FC) -c $(FFLAGS) $<

volts_old.o: volts_old.f
	$(FC) -c $(FFLAGS) $<

symbols.o: symbols.f
	$(FC) -c $(FFLAGS) $<

symbolsall.o: symbolsall.f
	$(FC) -c $(FFLAGS) $<

squares.o: squares.f
	$(FC) -c $(FFLAGS) $<

squaresdoublebuff.o: squaresdoublebuff.f
	$(FC) -c $(FFLAGS) $<

spectrum.o: spectrum.f
	$(FC) -c $(FFLAGS) $<

cmap2.o: cmap2.f
	$(FC) -c $(FFLAGS) $<

cmap3.o: cmap3.f
	$(FC) -c $(FFLAGS) $<

defmap.o: defmap.f
	$(FC) -c $(FFLAGS) $<

gridtest.o: gridtest.f
	$(FC) -c $(FFLAGS) $<

zoomtest.o: zoomtest.f
	$(FC) -c $(FFLAGS) $<

contest.o: contest.f
	$(FC) -c $(FFLAGS) $<

#May need to specify these on a brain-dead make system
#.f.o:	$(FC) -c $(FFLAGS) $<
#.c.o:	$(CC) -c $(CFLAGS) $<







