C
C---- NEX = max number of elements (must be same as  NBX  in MSES.INC)
      PARAMETER (NEX=3)
C
      PARAMETER (NCOM=71,NCOMA=25)
      PARAMETER (NSX=2*NEX)
      REAL COM1(NCOM), COM2(NCOM), COMA(NCOMA)
      REAL M1, M1_U1, M2, M2_U2
C
      LOGICAL SIMI,TRAN,TURB,WAKE,UPLE,CONVB
      LOGICAL DIRECT,LSEP
C
C
C-    CECON  =  Ce   weighting coefficient
C-    DICON  =  initial growth rate of inner slip layer just behind TE
C-    SCC    =  shear coefficient lag constant
C-    GACON  =  G-beta locus constants...
C-    GBCON  =   G = GACON * sqrt(1.0 + GBCON*beta) 
C-    GCCON  =         + GCCON / [H*Rtheta*sqrt(Cf/2)]   <-- wall term
C-    DLCON  =  wall/wake dissipation length ratio  Lo/L
C-    CTCON  =  Ctau weighting coefficient (implied by G-beta constants)
C
      PARAMETER (CECON = 2.0   ,  !!!  5.0
     &           DICON = 0.15  ,
     &           SCC   = 5.6   ,  !!!  5.6
     &           GACON = 6.70  ,  !!!  6.935
     &           GBCON = 0.75  ,  !!!  0.7
     &           GCCON = 18.0  ,
     &           DLCON = 0.90    )  !!! 0.90
      PARAMETER (CTCON = 0.5/(GACON**2 * GBCON))
C
C
C---- variables at i-1  (see descriptions below)
      COMMON/VAR1/ X1,  U1,  T1,  D1,  S1, AMPL1, DW1, UN1, R1
     &        , H1, H1_T1, H1_D1
     &        , M1, M1_U1
     &        , HK1, HK1_U1, HK1_T1, HK1_D1
     &        , HS1, HS1_U1, HS1_T1, HS1_D1, HS1_R1, HS1_RE
     &        , HC1, HC1_U1, HC1_T1, HC1_D1, HC1_R1, HC1_RE
     &        , RT1, RT1_U1, RT1_T1,         RT1_R1, RT1_RE
     &        , CF1, CF1_U1, CF1_T1, CF1_D1, CF1_R1, CF1_RE
     &        , DI1, DI1_U1, DI1_T1, DI1_D1, DI1_R1, DI1_RE, DI1_S1
     &        , CQ1, CQ1_U1, CQ1_T1, CQ1_D1, CQ1_R1, CQ1_RE, CQ1_UN1
     &        , DE1, DE1_U1, DE1_T1, DE1_D1
     &        , US1, US1_U1, US1_T1, US1_D1, US1_R1, US1_RE
     &        , DS1, DS1_U1, DS1_T1, DS1_D1, DS1_R1, DS1_RE
C
C---- variables at i  (see descriptions below)
      COMMON/VAR2/ X2,  U2,  T2,  D2,  S2, AMPL2, DW2, UN2, R2
     &        , H2, H2_T2, H2_D2
     &        , M2, M2_U2
     &        , HK2, HK2_U2, HK2_T2, HK2_D2
     &        , HS2, HS2_U2, HS2_T2, HS2_D2, HS2_R2, HS2_RE
     &        , HC2, HC2_U2, HC2_T2, HC2_D2, HC2_R2, HC2_RE
     &        , RT2, RT2_U2, RT2_T2,         RT2_R2, RT2_RE
     &        , CF2, CF2_U2, CF2_T2, CF2_D2, CF2_R2, CF2_RE
     &        , DI2, DI2_U2, DI2_T2, DI2_D2, DI2_R2, DI2_RE, DI2_S2
     &        , CQ2, CQ2_U2, CQ2_T2, CQ2_D2, CQ2_R2, CQ2_RE, CQ2_UN2
     &        , DE2, DE2_U2, DE2_T2, DE2_D2
     &        , US2, US2_U2, US2_T2, US2_D2, US2_R2, US2_RE
     &        , DS2, DS2_U2, DS2_T2, DS2_D2, DS2_R2, DS2_RE
C
      EQUIVALENCE (X1,COM1(1)), (X2,COM2(1))
C
C---- CFM is Cf at midpoint of interval
C-    XT is X position of transition point (if any) in current interval
      COMMON/VARA/ CFM, CFM_RE
     &        , CFM_U1, CFM_T1, CFM_D1, CFM_R1
     &        , CFM_U2, CFM_T2, CFM_D2, CFM_R2
     &        , XT,    XT_A1, XT_RE, XT_XF, XT_NC
     &        , XT_X1, XT_T1, XT_D1, XT_U1, XT_R1
     &        , XT_X2, XT_T2, XT_D2, XT_U2, XT_R2
      EQUIVALENCE (CFM,COMA(1))
C
      COMMON/SAV/ V1SAV(NCOM,NSX), V2SAV(NCOM,NSX), VASAV(NCOMA,NSX)
C
C---- variables passed into BL routines
      COMMON/VAR/ RSTBL, PSTBL, HSTBL, REYBL, GAMBL, GM1BL, HVISBL
     &          , BULE(NSX), DWTE(NSX), SENS(NSX)
     &          , AMCRIT, XIFORC(NSX), XITRAN(NSX), XITE(NSX)
     &          , UEREF(NSX),HKREF(NSX),DSREF(NSX)
     &          , DMAXS(NSX),HTARG(NSX),DTARG(NSX)
      COMMON/VAI/ ISIDE
     &          , SIMI(NSX),TRAN(NSX),TURB(NSX),WAKE(NSX)
     &          , UPLE(NSX)
     &          , ITROLD(NSX)
     &          , DIRECT(NSX),LSEP(NSX),CONVB(NEX)
      COMMON/TAUC/ TAUWI,TAU_RHI,TAU_UEI,TAU_THI,TAU_DSI,TAU_REY,
     &             VCENI
C
C---- arrays holding Newton system for current interval
      COMMON/SYS/ VS1(4,7),VS2(4,7),VSREZ(4),VSR(4),VSX(4),
     &        VVREZ(8,NEX),VVR(8,NEX),VVXF(8,2,NEX),
     &        VV1(8,8,NEX),VVX1(8,2,NEX),VVN1(8,2,NEX),VVR1(8,2,NEX),
     &        VV2(8,8,NEX),VVX2(8,2,NEX),VVN2(8,2,NEX),VVR2(8,2,NEX)
C
c      PARAMETER (NDECK = 24*NSX + 18*NSX*NSX)
c      COMMON/DEC/ XS(NSX),  UE(NSX),  TH(NSX),  DS(NSX),  RH(NSX)
cCCC     &  , RT(NSX),RT_U(NSX),RT_T(NSX),          RT_RE(NSX)
c     &  , HK(NSX),HK_U(NSX),HK_T(NSX),HK_D(NSX)
c     &  , HS(NSX),HS_U(NSX,NSX),HS_T(NSX,NSX),HS_D(NSX,NSX),HS_RE(NSX)
c     &  , DO(NSX),DO_U(NSX,NSX),DO_T(NSX,NSX),DO_D(NSX,NSX),DO_RE(NSX)
c     &  , DI(NSX),DI_U(NSX,NSX),DI_T(NSX,NSX),DI_D(NSX,NSX),DI_RE(NSX)
c     &  , UO(NSX),UO_U(NSX,NSX),UO_T(NSX,NSX),UO_D(NSX,NSX),UO_RE(NSX)
c     &  , UI(NSX),UI_U(NSX,NSX),UI_T(NSX,NSX),UI_D(NSX,NSX),UI_RE(NSX)
c     &  , UB(NSX),UB_U(NSX,NSX),UB_T(NSX,NSX),UB_D(NSX,NSX),UB_RE(NSX)
C
C
C---- variables in COMMON VAR1 , VAR2  (at  i-1 , i )
C
C   X      BL coordinate from stagnation point (arc length)
C   U      edge velocity  ue
C   T      Theta
C   D      Dstar
C   R      edge density   rhoe
C   S      (Ctau)^1/2
C   AMPL   n  (in e^n method)
C   DW     width of dead-air region just behind blunt TE
C   UN     due/dy at displacement surface (measures flow curvature)
C   H      shape parameter  H = Dstar / Theta
C   M      edge Mach**2
C   HK     kinematic shape parameter
C   HS     KE shape parameter  H* = Theta* / Theta
C   RT     Rtheta (momentum thickness Reynolds number)
C   CF     skin friction coefficient   TauW / (0.5 rhoe ue^2)
C   DI     modified dissipation coefficient  2 CD / H*
C   CQ     (CtauEQ)^1/2
C   DE     BL thickness
C   US     slip velocity  Us = us/ue
C
C   a_b    denotes partial derivative  da/db
