C
C---- Primary limits for MSES grid
ccc      PARAMETER (IX=280, JX=48, NBX=1, NMODX=124, NPOSX=3 )
      PARAMETER (IX=360, JX=74, NBX=3, NMODX=40, NPOSX=3 )
C
C  IX    = number of streamwise points
C  JX    = number of streamlines   (cannot exceed YPOS dimension below)
C  NBX   = number of elements (must be same as NEX in MBL.INC)
C  NMODX = number of element geometry perturbation modes
C  NPOSX = number of element position perturbation modes
C
C
C---- derived limits
      PARAMETER (ISX=2*NBX, IBX=2*IX, NBITX=(JX-1)/30+1,NNX=ISX+5)
C
C  ISX   - number of surfaces (2 per element)
C  IBX   - number of points in element geometry arrays
C  NBITX - number of words per i-station for isentropic-bit array
C  NNX   - number of points in delta* slide lines
C
C
      IMPLICIT REAL (A-H,M,O-Z)
      LOGICAL LCONV
      REAL LIFT
      CHARACTER*32 NAME
C
C
C---- field arrays
      COMMON/STATR/ 
     &   X(IX,JX), Y(IX,JX), R(IX,JX),
     &   MFRACT(JX),
     &   PSPEC(IX,ISX),
     &   XB(IBX,NBX),  YB(IBX,NBX),
     &   XPB(IBX,NBX), YPB(IBX,NBX),  SB(IBX,NBX),
     &   SG(IX,ISX), SGINL(IX,NBX), SGOUT(IX,NBX),
     &   XW(IX,NBX), YW(IX,NBX),  WGAP(IX,NBX), VCEN(IX,NBX),
     &   DISP(IX,ISX),  THET(IX,ISX),  DSTR(IX,ISX),
     &   UEDG(IX,ISX),  CTAU(IX,ISX),   TAU(IX,ISX)
C
C
C---- real scalars and small arrays
C-    NSTATS is number of scalars
      PARAMETER (NSTATS = 6
     &                  + 37
     &                  + 6
     &                  + 7
     &                  + 2
     &                  + 15
     &                  + 1
     &                  + 6
     &                  + 3
     &                  + 20
     &                  + 100 )
C
      COMMON/STATS/
     &   alf1,bet1, tau1, cc0,cc1,cc2,
     &   RSTOUT, PSTOUT, 
     &   QSTAR, PSTAR, RSTAR,
     &   GAM, TRF, HVIS, MCRIT, MUCON,
     &   WXPD, WXPT, WXUD, WXUT,
     &   RHOINF, QINF, HINF, MUINF, PINF, MINF, AINF,
     &   MASS, REYN, CIRC, ALFA, SINL, SOUT, PREX,
     &   DOUX, DOUY, SRCE,
     &   XCENT, YCENT, XBINL, XBOUT, YBBOT, YBTOP,
     &   LIFT, DRAG, MOMN, DRAGW, DRAGV, DRAGF, 
     &   PDF0, PDF1, PDFL, PDX0, PDX1, PDD0, PDD1,
     &   ACRIT,
     &   VERSION, 
     &   CL_ALFA, CM_ALFA, CDW_ALFA, CDV_ALFA, CDF_ALFA, 
     &   CL_MINF, CM_MINF, CDW_MINF, CDV_MINF, CDF_MINF,
     &   CL_RINF, CM_RINF, CDW_RINF, CDV_RINF, CDF_RINF,
     &   XPEX,
     &   DNRMS,DRRMS,DVRMS,DNMAX,DRMAX,DVMAX,
     &   DPTEPS, DQTEPS, PCWT,
     &   FREE(20),
     &   YPOS(100),
     &   SNOR(NNX,ISX),
     &   XNOR(NNX,ISX),XSNOR(NNX,ISX),
     &   YNOR(NNX,ISX),YSNOR(NNX,ISX),
     &   PXX0(ISX),PXX1(ISX),
     &   SBLE(NBX), SBLOLD(NBX), SWAK(NBX),
     &   SBNOSE(NBX),SBCMAX(NBX),
     &   XBNOSE(NBX),YBNOSE(NBX),XBTAIL(NBX),YBTAIL(NBX),
     &   XTR(ISX), STR1(ISX),
     &   BLIFT(NBX), BDRAG(NBX), BMOMN(NBX), BDRAGV(NBX), BDRAGF(NBX),
     &   CL_MOD(NMODX), CM_MOD(NMODX), 
     &   CDW_MOD(NMODX), CDV_MOD(NMODX), CDF_MOD(NMODX),
     &   MODN(NMODX),
     &   CL_POS(NPOSX), CM_POS(NPOSX),
     &   CDW_POS(NPOSX), CDV_POS(NPOSX), CDF_POS(NPOSX),
     &   POSN(NPOSX),
     &   DMSPN(NMODX),
     &   DPSPN(NPOSX)
C
C
C
C---- integers 
C-    NSTATI is number of scalars only
      PARAMETER (NSTATI = 3
     &                  + 3
     &                  + 3
     &                  + 2
     &                  + 4
     &                  + 15 )
C
      COMMON /STATI/
     &   II,JJ,NBL,
     &   NMIX,IX0,IX1,
     &   INITBL, INITRQ, ICOUNT,
     &   NMODN,NPOSN,
     &   KTRIP,ISSET,NHALF,LCONV,
     &   IFREE(15),
     &   KNOR(ISX),
     &   JBLD(NBX), NINL(NBX), NOUT(NBX), NBLD(NBX),
     &   IIB(NBX),  IBLE(NBX), 
     &   IGFIX(ISX), IGCORN(ISX),
     &   ITRAN(ISX),
     &   ISBITS(NBITX,IX),
     &   NAME
C
C
C...................................................................
C
C   Solution state vector --- reals
C
C   X,Y     (..) grid node coordinate arrays
C   R       (..) density array
C
C
C   MFRACT  (.)  streamtube mass fraction array  mj/mtot
C
C... non-ideal gas version constants
C   alf1         constant term in cp(T) function
C   bet1         linear   term in cp(T) function
C   tau1         Tstag/Tcrit
C   cc0-2        constants in non-ideality factor
C
C   RSTOUT       freestream stagnation density
C   PSTOUT       freestream stagnation pressure
C   QSTAR        sonic speed
C   PSTAR        sonic pressure
C   RSTAR        sonic density
C   GAM          Cp/Cv
C   TRF          temperature recovery factor
C   HVIS         Cp x Sutherland's constant
C   MCRIT        dissipation critical Mach number
C   MUCON        artificial bulk viscosity coefficient
C
C   WXPD         wall pressure extrapolation weights
C   WXPT
C   WXUD         Ue extrapolation weights
C   WXUT
C
C   RHOINF       freestream density
C   QINF         freestream speed
C   HINF         freestream stagnation enthalpy
C   MUINF        freestream viscosity
C   PINF         freestream pressure
C   MINF         freestream Mach
C   AINF         domain capture area (height) far upstream
C
C... global dofs
C   MASS         total mass flux
C   REYN         Reynolds number
C   CIRC         airfoil circulation
C   ALFA         airfoil angle of attack
C   SINL         cascade inlet  slope
C   SOUT         cascade outlet slope
C
C   PREX         grid-exit static pressure (for choked-passage cases)
C
C   DOUX,DOUY    doublet components
C   SRCE         farfield source
C   XCENT        farfield singularity x location
C   YCENT        farfield singularity y location
C   XBINL        inlet  plane x position
C   XBOUT        outlet plane x position
C   YBBOT        bottommost airfoil streamline y position
C   YBTOP        topmost    airfoil streamline y position
C
C   LIFT         total lift due to surface pressures
C   DRAG         total drag due to surface pressures
C   MOMN         total moment due to surface pressures
C                 (moment taken about  x,y  =  0.25 , 0.0 )
C   DRAGV        viscous drag from momentum defects of all elements
C   DRAGF        friction drag from viscous surface shear on all elements
C   DRAGW        inviscid (wave) drag from shock entropy wake
C   BLIFT  (.)   element lift due to surface pressures
C   BDRAG  (.)   element drag due to surface pressures
C   BMOMN  (.)   element moment (typ. about 0 , .25) due to surface press.
C   BDRAGV (.)   viscous drag from momentum defect of this element
C   BDRAGF (.)   friction drag from viscous surface shear on this element
C
C   Note: DRAG is usually inaccurate due to numerical integration errors.
C         A better value for pressure drag is obtained as follows.
C
C   pressure DRAG  =  (Total drag)  - DRAGF
C                  =  DRAGV + DRAGW - DRAGF
C
C   To get CD, normalize with dynamic pressure  0.5*RHOINF*QINF**2
C
C
C   PXX0 (.)     d^2p/dx^2 at left  freewall segment endpoint
C   PXX1 (.)     d^2p/dx^2 at right freewall segment endpoint
C   PSPEC  (..)  specified pressure array (Pspec - Po)
C   PDF0         full inverse pressure dof
C   PDF1         full inverse pressure dof
C   PDFL         full inverse pressure dof
C   PDX0         mixed inverse left  endpoint pressure dof
C   PDX1         mixed inverse right endpoint pressure dof
C   PDD0         mixed inverse left  endpoint pressure dof
C   PDD1         mixed inverse right endpoint pressure dof
C
C   SBLE   (.)   spline arc length value of LE point
C   SBLOLD (.)   spline arc length value of LE point since last grid fix
C
C   XB,YB   (..) airfoil spline coordinates
C   XPB,YPB (..) airfoil spline coordinate derivatives
C   SB      (..) airfoil spline arc length (independent coordinate)
C
C   SG      (..) airfoil  surface  grid node spacing array
C   SGINL   (..) inlet  streamline grid node spacing array
C   SGOUT   (..) outlet streamline grid node spacing array
C
C   XW    (..)   wake trajectory x coordinates
C   YW    (..)   wake trajectory y coordinates
C   WGAP  (..)   wake gap array  
C   SWAK  (.)    length of wake from TE to outlet
C
C   SBNOSE(.)    arc length location at XBNOSE,YBNOSE
C   SBCMAX(.)    arc length location of max-curvature point
C
C   XBNOSE(.)    element nose location 
C   YBNOSE(.)      (where chord line is perpendicular to surface tangent)
C
C   XBTAIL(.)    element TE point location
C   YBTAIL(.)
C
C   ACRIT        critical amplification ratio for e^n criterion
C   DISP  (..)   grid displacement array (= DSTR if converged)
C   THET  (..)   momentum thickness
C   DSTR  (..)   displacement thickness
C   UEDG  (..)   edge velocity
C   CTAU  (..)   shear stress coefficient  or  amplification ratio
C   TAU   (..)   wall shear
C   XTR   (.)    transition x/c location
C
C   STR1(.)      forced transition s/s_max  if  KTRIP = 1
C
C   ISSET        = 1 if SETUP was used to generate solution
C                = 2 if SETIS was used to generate solution
C
C   NHALF        Number of times solution has been halved
C
C   LCONV        .TRUE. if case is converged
C
C   VERSION      MSES version number
C
C   CL_ALFA      dCL/dalpha
C   CM_ALFA      dCM/dalpha
C   CD_ALFA      dCD/dalpha
C   CL_MINF      dCL/dMinf
C   CM_MINF      dCM/dMinf
C   CD_MINF      dCD/dMinf
C   CL_RINF      dCL/dReinf
C   CM_RINF      dCM/dReinf
C   CD_RINF      dCD/dReinf
C
C   CL_MOD (.)   CL  derivative wrt geometry mode perturbations
C   CM_MOD (.)   CM  derivative wrt geometry mode perturbations
C   CD_MOD (.)   CD  derivative wrt geometry mode perturbations
C   AL_MOD (.)   AOA derivative wrt geometry mode perturbations
C   MODN   (.)   accumulated geometry mode amplitudes
C
C   CL_POS (.)   CL  derivative wrt element position mode perturbations
C   CM_POS (.)   CM  derivative wrt element position mode perturbations
C   CD_POS (.)   CD  derivative wrt element position mode perturbations
C   AL_POS (.)   AOA derivative wrt element position mode perturbations
C   POSN   (.)   accumulated element position mode amplitudes
C
C   XPEX         exponent governing normal grid line spreading
C
C   DNRMS,DNRMS  max,rms grid node change from previous Newton iteration
C   DRRMS,DRMAX          density
C   DVRMS,DVMAX          viscous-variable
C
C   FREE (.)     not used
C
C   DPTEPS       thresholds for momentum/isentropy trigger function
C   DQTEPS
C
C   PCWT         weighting factor for Pcorr pressure-correction term
C
C
C   Solution state vector --- integers / alphanumerics
C
C   II,JJ        max grid indices
C   NBL          number of blades (2 for splitter)
C
C   NMIX         index of element which has mixed-inverse freewall segment
C   IX0          left  freewall segment endpoint index
C   IX1          right freewall segment endpoint index
C
C   JBLD  (.)    J index of blade upper surface
C   NINL  (.)    number of inlet  streamline grid nodes
C   NOUT  (.)    number of outlet streamline grid nodes
C   NBLD  (.)    number of blade surface grid nodes
C
C   IIB   (.)    max number of airfoil spline points
C   IBLE  (.)    sharp LE index in spline array  (0 for blunt LE)
C
C   IGFIX   (.)  points downstream of IGFIX do not slide on airfoil
C   IGCORN  (.)  index of point where corner is located
C
C   INITBL       BL initialization flag  (0 = BL not initialized)
C   INITRQ       flowfield initialization flag
C   ICOUNT       Newton iteration counter
C   ITRAN (.)    transition interval index
C
C   ISBITS(.)    array containing packed isentropic-cell bits
C
C   NAME         case descriptor string
C
C   NMODN        number of geometry perturbation modes
C   NPOSN        number of element position modes
C
C   KTRIP        0: forced transition x/c      specified via XTR1.
C                   STR1 ignored.
C                1: forced transition s/s_side specified via STR1,
C                   XTR1 in mses.xxx ignored.
C
C   IFREE (.)    not used
