
      SUBROUTINE CONMOD(NV,AVAR,VAR,VAR_MOD, NMODX,NMOD,KMOD,DMOD)
      CHARACTER*4 AVAR(NV)
      REAL VAR(NV), VAR_MOD(NMODX,NV), DMOD(NMODX)
      INTEGER KMOD(NMODX)
C-------------------------------------------------------------
C     Modifies mode changes DMOD(.) to drive variables VAR(.)
C     to specified values, by projecting mode changes onto 
C     constant-VAR subspace, also adding driving terms.
C-------------------------------------------------------------
C
      PARAMETER (NVX = 10)
      REAL VMDOTM(NVX), VMI(NVX), VTARG(NVX)
C
      IF(NV.GT.NVX) STOP 'CONMOD: Array overflow.  Increase NVX.'
C
      WRITE(*,1100) (AVAR(IV),IV=1,NV)
 1100 FORMAT(/1X,4X,10(5X,A4,4X) )
C
      WRITE(*,1120) ( VAR(IV),IV=1,NV)
 1120 FORMAT(1X,10F13.5)
C
      WRITE(*,1150) (AVAR(IV),IV=1,NV)
 1150 FORMAT(/1X,' k  ',10('  d',A4,'/dMODk') )
C
      DO 10 N=1, NMOD
        K = KMOD(N)
        WRITE(*,1180) K, (VAR_MOD(K,IV), IV=1, NV)
 1180   FORMAT(1X,I2,2X,10(F13.5) )
 10   CONTINUE
C
      DO 20 IV=1, NV
 202    WRITE(*,1200) AVAR(IV)
 1200   FORMAT(/' Enter target ',A4,'  (0 if unconstrained)')
        READ (*,*,ERR=202) VTARG(IV)
C
        VMDOTM(IV) = 0.0
        VMI(IV) = 0.0
C
        IF(VTARG(IV) .NE. 0.0) THEN
C
         VMSQ = 0.0
         DO 205 N=1, NMOD
           K = KMOD(N)
           VMSQ       = VMSQ       + VAR_MOD(K,IV)**2
           VMDOTM(IV) = VMDOTM(IV) + VAR_MOD(K,IV)*DMOD(K)
 205     CONTINUE
C
         IF(VMSQ .EQ. 0.0) THEN
          WRITE(*,*) 'Mode influence insufficient'
          WRITE(*,*) 'Unable to enforce constraint'
          VMI(IV) = 0.0
         ELSE
          VMI(IV) = 1.0/VMSQ
         ENDIF
C
        ENDIF
C
 20   CONTINUE
C
C
C---- project mode changes onto constant-VAR subspace,
C-    also adding driving term
      DO 50 N=1, NMOD
        K = KMOD(N)
        DO 505 IV=1, NV
          DMOD(K) = DMOD(K)
     &    + (VTARG(IV)-VAR(IV) - VMDOTM(IV))*VAR_MOD(K,IV) * VMI(IV)
 505    CONTINUE
 50   CONTINUE
C
      RETURN
      END ! CONMOD
