
      SUBROUTINE CONTPL
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      LOGICAL BLANK, ERROR
      CHARACTER*1 VAR
      CHARACTER*2 COPT
C
 1000 FORMAT(A)
C
C---- initialize blowup scale and offsets
ccc      CALL OFFINI
C
      BLANK = .TRUE.
      LPLOT = .FALSE.
C
 9000 WRITE(*,9001)
 9001 FORMAT(
     & /' -----------------------------------------------------------'
     & /
     & /' 1  Grid                     11  BL profile plots with data'  
     & /' 2  Characteristic waves     12  BL profile plots from cursor'   
     & /' 3  Flow contours (MPRQCLT)  13  Change BL profile U scaling'    
     & /' 4  LE Nhats                 14  BL edge overlay flag'
     & /' 5  Window                   15  Annotation menu'
     & /' 6  Blowup                   16  Delta* slide lines'
     & /' 7  Reset plot scaling       17  Shade mom.-conserving cells'
     & /' 8  Hardcopy current plot    18  Locate cell i,j'
     & /' 9  Options                  19  Toggle color-bar plotting'
     & /'10  Grid statistics          20  Toggle disp. body shading')
 9005 WRITE(*,9007)
 9007 FORMAT(/1X,'Select contour/grid plot option:  ',$)
      READ(*,1000) COPT
C
      IF(INDEX('0 ',COPT(1:1)).NE.0) THEN
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
        RETURN
      ENDIF
C
      IF(INDEX('MPRGQCLTSmprgqclts',COPT(1:1)) .NE. 0) THEN
C------ one of the variable keyword letters was selected... go plot it
        NOPT = 3
        VAR = COPT(1:1)
        GO TO 31
      ELSE
C------ read character string into integer for the case GOTO statement below
        NOPT = 0
        READ(COPT,*,ERR=9000) NOPT
      ENDIF
C
C---- Do different plot options
C
      GOTO( 10, 20, 30, 40, 50, 60, 70, 80, 90,100,
     &     110,120,130,140,150,160,170,180,190,200 ) NOPT
      GOTO 9000
C
C===============================================
C---- Geometric grid
   10 IF(BLANK) THEN
       CALL PLTINI(1.0)
C
C----- plot airfoil and BL edges
       CALL NEWPEN(2)
       CALL APLOT
       IF(LDELTA) CALL DELTA
C
C----- plot grid size label
       CALL NEWPEN(3)
       CHL = 0.9*CH
       XLAB = 3.0*CHL
       YLAB = 3.0*CHL
       CALL PLNUMB(XLAB,YLAB,CHL,FLOAT(II),0.0,-1)
       CALL PLMATH(999.,999.,0.7*CHL,' # ',0.0, 3)
       CALL PLNUMB(999.,999.,CHL,FLOAT(JJ),0.0,-1)
      ELSE
       CALL NEWCOLORNAME('cadetblue4')
      ENDIF
C
      CALL GGRID
      CALL NEWCOLORNAME('black')
      BLANK = .FALSE.
C
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
C---- Mach waves
   20 CALL PLTINI(1.0)
      CALL NEWPEN(2)
      CALL APLOT
      IF(LDELTA) CALL DELTA
C
      CALL NEWPEN(1)
      NCON = 0
      CALL WAVCLL(FMIN,FMAX,NCON)
      BLANK = .FALSE.
C
      CALL NEWPEN(2)
      CHL = 0.6*CH
      XLAB = 4.0*CHL
      YLAB = 4.5*CHL
      CALL PLCHAR(XLAB,YLAB,CHL,'Mach Waves',0.0,10)
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
C---- Flowfield contours
   30 WRITE(*,*)
      WRITE(*,*) '   M ach '
      WRITE(*,*) '   P ressure / Po'
      WRITE(*,*) '   R ho      / Ro'
      WRITE(*,*) '   Q         / Qinf' 
ccc   WRITE(*,*) '   G radient of Rho ( Schlieren )'
      WRITE(*,*) '   C p                    ( dP  / q  )'
      WRITE(*,*) '   L oss coefficient      ( dPo / q  )'
      WRITE(*,*) '   T otal pressure change ( dPo / Po )'
      WRITE(*,*) '   S ource density        (div(Q)/Qinf)'
      WRITE(*,3010)
 3010 FORMAT(/1X,'Enter contour flow variable:  ',$)
      READ (*,1000) VAR
      IF(INDEX(' ',VAR).EQ.1) GO TO 9000
C
      IF(INDEX('MPRQGCLTS',VAR).LE.0 .AND. 
     &   INDEX('mprqgclts',VAR).LE.0      ) GO TO 30
C
 31   CONTINUE
C
C---- fill F(i,j) array with variable, and then transfer it to FV(i,j) 
C-     with FSETN (if it's cell-centered), or
C-     with FSETC (if it's node-centered).
      IF    (INDEX('Mm',VAR).NE.0) THEN
        DO 311 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 311
          DO 3111 I=1, II-1
CCC         F(I,J) = Q(I,J) / SQRT(GM1*(HINF-0.5*Q(I,J)**2))
            MSQ = R(I,J)*Q(I,J)**2 / (GAM*(P(I,J)+PSTINF))
            F(I,J) = SQRT(MAX(MSQ,0.))
 3111     CONTINUE
 311    CONTINUE
        CALL FSETC
C
      ELSEIF (INDEX('Rr',VAR).NE.0) THEN
        DO 312 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 312
          DO 3121 I=1, II-1
            F(I,J) = R(I,J)/RSTINF
 3121     CONTINUE
 312    CONTINUE
        CALL FSETC
C
      ELSEIF (INDEX('Qq',VAR).NE.0) THEN
        DO 313 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 313
          DO 3131 I=1, II-1
            F(I,J) = Q(I,J)/QINF
 3131     CONTINUE
 313    CONTINUE
        CALL FSETC
C
      ELSEIF (INDEX('Ll',VAR).NE.0) THEN
        DO 314 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 314
          DO 3141 I=1, II-1
            F(I,J) = (PST(I,J) - PSTINF)/QU
 3141     CONTINUE
 314    CONTINUE
        CALL FSETC
C
      ELSEIF (INDEX('Tt',VAR).NE.0) THEN
        DO 315 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 315
          DO 3151 I=1, II-1
            F(I,J) = (PST(I,J)-PSTINF)/PSTINF
 3151     CONTINUE
 315    CONTINUE
        CALL FSETC
C
      ELSEIF (INDEX('Pp',VAR).NE.0) THEN
       DO 32 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 32
         DO 321 I=1, II-1
           F(I,J) = (P(I,J)+PSTINF)/PSTINF
  321    CONTINUE
   32  CONTINUE
       CALL FSETC
C
      ELSEIF (INDEX('Cc',VAR).NE.0) THEN
       DPINF = PINF-PSTINF
       DO 33 J=1, JJ
         DO 331 I=1, II
           F(I,J) = (PI(I,J)-DPINF)/QU
  331    CONTINUE
   33  CONTINUE
       CALL FSETN
C
      ELSEIF (INDEX('Ss',VAR).NE.0) THEN
        DO J=1, JJ-1
          IF(JSTAG(J).LE.0) THEN
           DO I=1, II-1
             F(I,J) = SRC(I,J)/QINF
           ENDDO
          ENDIF
        ENDDO
        CALL FSETC
C
      ELSEIF (INDEX('Gg',VAR).NE.0) THEN
C
       WRITE(*,*)
   34  WRITE(*,*) 'Enter derivative direction angle (0-90)'
       READ (*,*,ERR=34) ANGLE
C
       SA = SIN(ANGLE*3.1415926/180.0)
       CA = COS(ANGLE*3.1415926/180.0)
C
C----- set interior density derivatives
       DO 35 J=2, JJ-1
         IF(JSTAG(J).NE.0) GO TO 35
         DO 351 I=2, II-1
           XOO = 0.25*(X(I,J) + X(I+1,J) + X(I,J+1) + X(I+1,J+1))
           YOO = 0.25*(Y(I,J) + Y(I+1,J) + Y(I,J+1) + Y(I+1,J+1))
           XOM = 0.25*(X(I,J) + X(I+1,J) + X(I,J-1) + X(I+1,J-1))
           YOM = 0.25*(Y(I,J) + Y(I+1,J) + Y(I,J-1) + Y(I+1,J-1))
           XMO = 0.25*(X(I,J) + X(I-1,J) + X(I,J+1) + X(I-1,J+1))
           YMO = 0.25*(Y(I,J) + Y(I-1,J) + Y(I,J+1) + Y(I-1,J+1))
           XMM = 0.25*(X(I,J) + X(I-1,J) + X(I,J-1) + X(I-1,J-1))
           YMM = 0.25*(Y(I,J) + Y(I-1,J) + Y(I,J-1) + Y(I-1,J-1))

           DX1 = XOM - XMO
           DY1 = YOM - YMO
           DR1 = R(I,J-1) - R(I-1,J)
C
           DX2 = XOO - XMM
           DY2 = YOO - YMM
           DR2 = R(I,J) - R(I-1,J-1)
C
           DET =  DX1*DY2 - DY1*DX2
           GRX = (DR1*DY2 - DY1*DR2) / DET
           GRY = (DX1*DR2 - DR1*DX2) / DET
C
           F(I,J) = CA*GRX + SA*GRY
  351    CONTINUE
   35  CONTINUE
C
C----- extrapolate to inlet and outlet boundaries
       DO 36 J=2, JJ-1
         IF(JSTAG(J).NE.0) GO TO 36
C
         I = 1
         DSO = SQRT((X(I  ,J)-X(I+1,J))**2 + (Y(I  ,J)-Y(I+1,J))**2)
         DSP = SQRT((X(I+1,J)-X(I+2,J))**2 + (Y(I+1,J)-Y(I+2,J))**2)
         F(I,J) = F(I+1,J) + (F(I+1,J)-F(I+2,J))*DSO/DSP
C
         I = II
         DSO = SQRT((X(I  ,J)-X(I-1,J))**2 + (Y(I  ,J)-Y(I-1,J))**2)
         DSM = SQRT((X(I-1,J)-X(I-2,J))**2 + (Y(I-1,J)-Y(I-2,J))**2)
         F(I,J) = F(I-1,J) + (F(I-1,J)-F(I-2,J))*DSO/DSM
   36  CONTINUE
C
C----- extrapolate to farfield, element surface boundaries
       DO 38 I=1, II
         DO 380 J=1, JJ
           IF(J.EQ.1 .OR. JSTAG(J).LT.0) THEN
            DSO = SQRT((X(I,J  )-X(I,J+1))**2 + (Y(I,J  )-Y(I,J+1))**2)
            DSP = SQRT((X(I,J+1)-X(I,J+2))**2 + (Y(I,J+1)-Y(I,J+2))**2)
            F(I,J) = F(I,J+1) + (F(I,J+1)-F(I,J+2))*DSO/DSP
           ELSEIF (J.EQ.JJ .OR. JSTAG(J).GT.0) THEN
            DSO = SQRT((X(I,J  )-X(I,J-1))**2 + (Y(I,J  )-Y(I,J-1))**2)
            DSM = SQRT((X(I,J-1)-X(I,J-2))**2 + (Y(I,J-1)-Y(I,J-2))**2)
            F(I,J) = F(I,J-1) + (F(I,J-1)-F(I,J-2))*DSO/DSM
           ENDIF
  380    CONTINUE
   38  CONTINUE
C
       CALL FSETN
C
      ENDIF
C
C---- plot airfoil and displacement surfaces
      CALL PLTINI(1.0)
      CALL NEWPEN(2)
      CALL APLOT
      IF(LDELTA) CALL DELTA
C
C---- plot contours
      CALL NEWPEN(1)
      CALL CONCLL(FCMIN,FCMAX,NCCON)
      BLANK = .FALSE.
C
C---- plot label
      CALL NEWPEN(2)
      CHL = 0.6*CH
      XLAB = 3.0*CHL
      YLAB = 3.0*CHL
C
      DFC = 1.0
      IF(NCCON.GT.0) DFC = (FCMAX-FCMIN)/FLOAT(NCCON)
      NDIG = INT( 0.7 - LOG10(DFC) )
      DO K=2, 9
        FC = ABS( LOG10(DFC/FLOAT(K)) )
        IF( ABS(FC - AINT(FC+0.005)) .LT. 0.005 ) GO TO 39
      ENDDO
      NDIG = NDIG+1
 39   CONTINUE
C
      CALL PLCHAR(XLAB ,YLAB,0.85*CHL,'Increment = ',0.0,12)
      CALL PLNUMB(999.0,YLAB,0.85*CHL,DFC,0.0,NDIG)
C
      YLAB = YLAB + 2.5*CHL
      CALL PLCHAR(XLAB,YLAB,CHL,'Contours of ',0.0,12)
C
      IF    (INDEX('Mm',VAR).NE.0) THEN
C
        CALL PLCHAR(XLAB+12.5*CHL,YLAB,CHL,'Mach',0.0,4)
C
      ELSEIF(INDEX('Qq',VAR).NE.0) THEN
C
        CALL PLCHAR(XLAB+12.5*CHL,YLAB,CHL,'q/q ',0.0,4)
        CALL PLMATH(XLAB+12.5*CHL,YLAB,CHL,'   &',0.0,4)
C
      ELSEIF(INDEX('Ll',VAR).NE.0) THEN
C
        CALL PLMATH(XLAB+12.0*CHL,YLAB       ,    CHL,'O '  ,0.0,2)
        CALL PLCHAR(XLAB+12.0*CHL,YLAB       ,    CHL,' C'  ,0.0,2)
        CALL PLCHAR(XLAB+14.0*CHL,YLAB-0.2*CH,0.8*CHL,  'p' ,0.0,1)
        CALL PLCHAR(XLAB+14.8*CHL,YLAB-0.5*CH,0.6*CHL,   'o',0.0,1)
C
      ELSEIF(INDEX('Tt',VAR).NE.0) THEN
C
        CALL PLMATH(XLAB+12.5*CHL,YLAB        ,    CHL,'O    ' ,0.0,5)
        CALL PLCHAR(XLAB+12.5*CHL,YLAB        ,    CHL,' p /p' ,0.0,5)
        CALL PLCHAR(XLAB+14.5*CHL,YLAB-0.3*CHL,0.7*CHL,  'o'   ,0.0,1)
        CALL PLCHAR(XLAB+17.5*CHL,YLAB-0.3*CHL,0.7*CHL,     'o',0.0,1)
C
      ELSEIF(INDEX('Pp',VAR).NE.0) THEN
C
        CALL PLCHAR(XLAB+12.5*CHL,YLAB        ,    CHL,'p/p' ,0.0,3)
        CALL PLCHAR(XLAB+15.5*CHL,YLAB-0.3*CHL,0.7*CHL,   'o',0.0,1)
C
      ELSEIF(INDEX('Rr',VAR).NE.0) THEN
C
        CALL PLMATH(XLAB+12.5*CHL,YLAB        ,    CHL,'r/r' ,0.0,3)
        CALL PLCHAR(XLAB+15.5*CHL,YLAB-0.3*CHL,0.7*CHL,   'o',0.0,1)
C
      ELSEIF(INDEX('Cc',VAR).NE.0) THEN
C
        CALL PLCHAR(XLAB+12.5*CHL,YLAB        ,    CHL,'C' ,0.0,1)
        CALL PLCHAR(XLAB+13.4*CHL,YLAB-0.3*CHL,0.8*CHL, 'p',0.0,1)
C
      ELSEIF(INDEX('Gg',VAR).NE.0) THEN
C
        CALL PLMATH(XLAB+12.5*CHL,YLAB,CHL,'|Nr|',0.0,4)
C
      ELSEIF(INDEX('Ss',VAR).NE.0) THEN
C
        CALL PLMATH(XLAB+12.5*CHL,YLAB        ,    CHL,'N*    ' ,0.0,6)
        CALL PLCHAR(XLAB+12.5*CHL,YLAB        ,    CHL,'  q/q ' ,0.0,6)
        CALL PLMATH(XLAB+12.5*CHL,YLAB        ,    CHL,'  >  &' ,0.0,6)
C
      ENDIF
C
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
cC---- DSBLE influence direction vectors (LE Nhats)
c   40 IF(.NOT.LNHATS) CALL NCALC
c      LNHATS = .TRUE.
c      CALL PLTINI(1.0)
c      CALL NEWPEN(2)
c      CALL APLOT
c      IF(LDELTA) CALL DELTA
c   42 WRITE(*,*) 'Enter element number (0 = alpha mode), Nhat scale'
c      READ(*,*,ERR=42) N, FACN
c      CALL NHATS(N,FACN)
c      BLANK = .FALSE.
c      CALL PLFLUSH
c      GO TO 9005
C
C---- NPOSN influence direction vectors
   40 CONTINUE
      WRITE(*,*) 'Enter N  Xpos Ypos Apos'
      READ (*,*,ERR=40) N, XBPOS, YBPOS, ABPOS
C
cc      IF(N.EQ.0) THEN
cc       N = 1
cc       rewind(15)
cc       do j=1, jj
cc         read(15) (nxg(i,j,n), nyg(i,j,n), i=1, ii)
cc       enddo
cc      ELSE
       CALL NPOSET(N, XBPOS, YBPOS, ABPOS)
cc      ENDIF
C
      CALL PLTINI(1.0)
      CALL NEWPEN(2)
      CALL APLOT
   42 WRITE(*,*) 'Enter unit Nhat length'
      READ(*,*,ERR=42) FACN
      CALL NHATS(N,FACN)
      BLANK = .FALSE.
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
C---- plot skeleton
   50 CALL PLTINI(1.0)
      CALL OUTLIN
C
C---- plot airfoil and BL edges
      CALL NEWPEN(2)
      CALL APLOT
C
      BLANK = .FALSE.
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
C---- Zoom in on the plot
   60 IF ((.NOT.LCURS) .OR. (.NOT.BLANK)) THEN
        CALL OFFGET(XOFFG,YOFFG,SFG,SFG,1.0,AR,.TRUE.,LCURS)
        BLANK = .TRUE.
      ELSE
        CALL PLTINI(1.0)
        CALL OUTLIN
        BLANK = .FALSE.
        CALL PLFLUSH
        CALL OFFGET(XOFFG,YOFFG,SFG,SFG,1.0,AR,.TRUE.,LCURS)
        BLANK = .TRUE.
      ENDIF
      GO TO 9005
C
C===============================================
C---- Reset to default offset and scaling factors
   70 CALL OFFINI
      BLANK = .TRUE.
      GO TO 9005
C
C===============================================
C---- Hardcopy Flag
   80 IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 9005
C
C===============================================
C---- Change settings
   90 CALL OPLSET(IDEVRP,IPSLU,
     &            SIZE,AR,
     &            XMARG,YMARG,XPAGE,YPAGE,
     &            CH,SCRNFR,LCURS,LLAND)
      GO TO 9005
C
C===============================================
  100 CALL PRNTIJ
      GO TO 9005
C
C===============================================
  110 CALL PLTINI(1.0)
      CALL DPLOT
      BLANK = .FALSE.
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
  120 CALL PLTINI(1.0)
      CALL DPLOTC
C
      IF(LSHADE) CALL DSHADE
C
      BLANK = .FALSE.
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
  130 WRITE(*,1305) UWT
 1305 FORMAT(1X,'Enter u scaling factor:', F9.5)
      CALL READR(1,UWT,ERROR)
      IF(ERROR) GO TO 130
      GO TO 9005
C
C===============================================
C---- BL edges
  140 WRITE(*,*)
      LDELTA = .NOT.LDELTA
      IF(     LDELTA) WRITE(*,*) 'BL edges will be overlaid'
      IF(.NOT.LDELTA) WRITE(*,*) 'BL edges will not be overlaid'
      GO TO 9005
C
C===============================================
  150 CALL ANNOT(CH)
      GO TO 9005
C
C===============================================
C---- TE delta* slide lines
  160 IF(BLANK) THEN
        CALL PLTINI(1.0)
        CALL OUTLIN
        BLANK = .FALSE.
      ENDIF
      CALL DSLIDE
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
cC---- isentropic-cell shading
c  170 IF(BLANK) THEN
c        CALL PLTINI(1.0)
c        CALL OUTLIN
c        BLANK = .FALSE.
c      ENDIF
c
c      CALL ISHADE(0)
c      CALL PLFLUSH
c      GO TO 9005
C
C---- momentum-cell shading
  170 IF(BLANK) THEN
        CALL PLTINI(1.0)
        CALL OUTLIN
        BLANK = .FALSE.
      ENDIF
      CALL ISHADE(1)
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
cC---- inviscid-profile routine
c  180 CALL PLTINI(1.0)
c      CALL DPLOTI
c      BLANK = .FALSE.
c      CALL PLFLUSH
c      GO TO 9005
C
C===============================================
C---- Put Marker on plot at I,J
  180 CALL PRNTIJ
      IF(BLANK) THEN
        CALL PLTINI(1.0)
        CALL OUTLIN
        BLANK = .FALSE.
        CALL PLFLUSH
      ENDIF
C
      WRITE(*,*)
      WRITE(*,*) 'Enter i,j :'
      READ (*,*,ERR=180) I,J
      I = MAX(1,MIN(II,I))
      J = MAX(1,MIN(JJ,J))
      XSYM = SFG*(X(I,J)-XOFFG)
      YSYM = SFG*(Y(I,J)-YOFFG)
      CALL PLSYMB(XSYM,YSYM,0.8*CH,5,0.0,0)
      I = MAX(1,MIN(II-1,I))
      J = MAX(1,MIN(JJ-1,J))
      XCELL = 0.25*(X(I,J)+X(I+1,J)+X(I,J+1)+X(I+1,J+1))
      YCELL = 0.25*(Y(I,J)+Y(I+1,J)+Y(I,J+1)+Y(I+1,J+1))
      XSYM = SFG*(XCELL-XOFFG)
      YSYM = SFG*(YCELL-YOFFG)
      CALL PLSYMB(XSYM,YSYM,0.5*CH,1,0.0,0)
      CALL PLFLUSH
      GO TO 9005
C
C===============================================
C---- toggle color-bar plotting
  190 LCBAR = .NOT.LCBAR
      GO TO 9005
C
C===============================================
C---- toggle displacement-body shading
  200 LSHADE = .NOT.LSHADE
      GO TO 9005
C
      END ! CONTPL


      SUBROUTINE OFFINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
C---- set initial scaling and offset parameters
      XRANGE = XMAX-XMIN
      YRANGE = YMAX-YMIN
      SFG = 0.95*MIN( 1./XRANGE , AR/YRANGE )
      XOFFG = XMIN - 0.5*(1. -SFG*XRANGE)/SFG
      YOFFG = YMIN - 0.5*(AR -SFG*YRANGE)/SFG
C
      RETURN
      END ! OFFINI



      SUBROUTINE OUTLIN
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
C---- plots grid skeleton
C
      CALL NEWPEN(1)
C
      J1 = 1
      DO 1 J2=2, JJ
        IF(JSTAG(J2).GT.0 .OR. J2.EQ.JJ) THEN
C
         DO 10 J=J1, J2, J2-J1
           CALL PLOT(XMOD(X(1,J)),YMOD(Y(1,J)),3)
           DO 101 I=2, II
             CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
 101       CONTINUE
 10      CONTINUE
C
         DO 12 I=1, II, II-1
           CALL PLOT(XMOD(X(I,J1)),YMOD(Y(I,J1)),3)
           DO 121 J=J1+1, J2
             CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
 121       CONTINUE
 12      CONTINUE
C
         J1 = J2+1
        ENDIF
 1    CONTINUE
C
      RETURN
      END ! OUTLIN



      SUBROUTINE FSETC
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
C==== Sets up contour arrays for f,x,y, defined at cell centers
C
C---- set indices of stagnation streamlines on XV,YV grid
      L0 = 0
      DO 5 J=1, JJ
        L = L0 + J
        LSTAG(L) = JSTAG(J)
        IF(JSTAG(J).LT.0 .OR. J.EQ.1) THEN
         LSTAG(L+1) = JSTAG(J+1)
         L0 = L0+1
        ENDIF
    5 CONTINUE
C
      NYV = JJ + 1 + NBL
C                  
C---- go over streamwise stations
      DO 10 I=1, II-1
        K = I+1
C
C------ set interior nodes
        L0 = 1
        DO 101 J=1, JJ-1
          L = L0 + J
          IF(JSTAG(J).GT.0) THEN
           L0 = L0+1
           GO TO 101
          ENDIF
          XV(K,L) = 0.25*(X(I,J)+X(I+1,J)+X(I,J+1)+X(I+1,J+1))
          YV(K,L) = 0.25*(Y(I,J)+Y(I+1,J)+Y(I,J+1)+Y(I+1,J+1))
          FV(K,L) = F(I,J)
  101   CONTINUE    
C
C------ set extra nodes at j=1, J, and stagnation streamlines
        L0 = 0
        DO 105 J=1, JJ
          L = L0 + J
C
          IF(JSTAG(J).LT.0 .OR. J.EQ.1) THEN
           XV(K,L) = 0.5*(X(I,J)+X(I+1,J))
           YV(K,L) = 0.5*(Y(I,J)+Y(I+1,J))
           DSO = SQRT((XV(K,L  )-XV(K,L+1))**2+(YV(K,L  )-YV(K,L+1))**2)
           DSP = SQRT((XV(K,L+1)-XV(K,L+2))**2+(YV(K,L+1)-YV(K,L+2))**2)
           FV(K,L) = FV(K,L+1) + (FV(K,L+1)-FV(K,L+2))*DSO/DSP
           L0 = L0+1
          ELSEIF (JSTAG(J).GT.0 .OR. J.EQ.JJ) THEN
           XV(K,L) = 0.5*(X(I,J)+X(I+1,J))
           YV(K,L) = 0.5*(Y(I,J)+Y(I+1,J))
           DSO = SQRT((XV(K,L  )-XV(K,L-1))**2+(YV(K,L  )-YV(K,L-1))**2)
           DSM = SQRT((XV(K,L-1)-XV(K,L-2))**2+(YV(K,L-1)-YV(K,L-2))**2)
           FV(K,L) = FV(K,L-1) + (FV(K,L-1)-FV(K,L-2))*DSO/DSM
          ENDIF
C
          IF(JSTAG(J).LT.0) THEN
           N = ( IABS(JSTAG(J)) + 1 ) / 2
           IF(I.LT.NINL(N)) THEN
C---------- make sure inlet contour is continuous across stagnation streamline
            FV(K,L) = 0.5*(FV(K,L) + FV(K,L-1))
            FV(K,L-1) = FV(K,L)
           ENDIF
          ENDIF
C
  105   CONTINUE
C
   10 CONTINUE
C
C---- take care of inlet/outlet planes
      L0 = 1
      DO 20 J=1, JJ-1
        L = L0 + J
C
        IF(JSTAG(J).GT.0) THEN
         L0 = L0+1
         GO TO 20
        ENDIF
C
C------ outlet
        I = II
        K = II+1
        XV(K,L) = 0.5*(X(I,J)+X(I,J+1))
        YV(K,L) = 0.5*(Y(I,J)+Y(I,J+1))
        DSO = SQRT((XV(K-1,L)-XV(K  ,L))**2 + (YV(K-1,L)-YV(K  ,L))**2)
        DSM = SQRT((XV(K-2,L)-XV(K-1,L))**2 + (YV(K-2,L)-YV(K-1,L))**2)
        FV(K,L) = FV(K-1,L) + (FV(K-1,L)-FV(K-2,L))*DSO/DSM
C
C------ inlet
        I = 1
        K = 1
        XV(K,L) = 0.5*(X(I,J)+X(I,J+1))
        YV(K,L) = 0.5*(Y(I,J)+Y(I,J+1))
        DSO = SQRT((XV(K+1,L)-XV(K  ,L))**2 + (YV(K+1,L)-YV(K  ,L))**2)
        DSP = SQRT((XV(K+2,L)-XV(K+1,L))**2 + (YV(K+2,L)-YV(K+1,L))**2)
        FV(K,L) = FV(K+1,L) + (FV(K+1,L)-FV(K+2,L))*DSO/DSP
C
   20 CONTINUE
C
C
C---- inlet/outlet points on stagnation streamlines
      L0 = 1
      DO 30 J=2, JJ-1
        L = L0 + J
C
        IF(JSTAG(J).LT.0) THEN
         I = 1
         K = 1
         XV(K,L) = X(I,J)
         YV(K,L) = Y(I,J)
         DSO = SQRT((XV(K,L  )-XV(K,L+1))**2+(YV(K,L  )-YV(K,L+1))**2)
         DSP = SQRT((XV(K,L+1)-XV(K,L+2))**2+(YV(K,L+1)-YV(K,L+2))**2)
         FV(K,L) = FV(K,L+1) + (FV(K,L+1)-FV(K,L+2))*DSO/DSP
C
         I = II
         K = II+1
         XV(K,L) = X(I,J)
         YV(K,L) = Y(I,J)
         DSO = SQRT((XV(K,L  )-XV(K,L+1))**2+(YV(K,L  )-YV(K,L+1))**2)
         DSP = SQRT((XV(K,L+1)-XV(K,L+2))**2+(YV(K,L+1)-YV(K,L+2))**2)
         FV(K,L) = FV(K,L+1) + (FV(K,L+1)-FV(K,L+2))*DSO/DSP
C
         L0 = L0+1
        ELSEIF (JSTAG(J).GT.0) THEN
         I = 1
         K = 1
         XV(K,L) = X(I,J)
         YV(K,L) = Y(I,J)
         DSO = SQRT((XV(K,L  )-XV(K,L-1))**2+(YV(K,L  )-YV(K,L-1))**2)
         DSM = SQRT((XV(K,L-1)-XV(K,L-2))**2+(YV(K,L-1)-YV(K,L-2))**2)
         FV(K,L) = FV(K,L-1) + (FV(K,L-1)-FV(K,L-2))*DSO/DSM
C
         I = II
         K = II+1
         XV(K,L) = X(I,J)
         YV(K,L) = Y(I,J)
         DSO = SQRT((XV(K,L  )-XV(K,L-1))**2+(YV(K,L  )-YV(K,L-1))**2)
         DSM = SQRT((XV(K,L-1)-XV(K,L-2))**2+(YV(K,L-1)-YV(K,L-2))**2)
         FV(K,L) = FV(K,L-1) + (FV(K,L-1)-FV(K,L-2))*DSO/DSM
        ENDIF
C
   30 CONTINUE
C
C
C---- corners
      K = 1
      L = 1
      XV(K,L) = X(1,1)
      YV(K,L) = Y(1,1)
      DSO = SQRT((XV(K+1,L)-XV(K  ,L))**2 + (YV(K+1,L)-YV(K  ,L))**2)
      DSP = SQRT((XV(K+2,L)-XV(K+1,L))**2 + (YV(K+2,L)-YV(K+1,L))**2)
      FV(K,L) = FV(K+1,L) + (FV(K+1,L)-FV(K+2,L))*DSO/DSP
C
      K = 1
      L = JJ+1+NBL
      XV(K,L) = X(1,JJ)
      YV(K,L) = Y(1,JJ)
      DSO = SQRT((XV(K+1,L)-XV(K  ,L))**2 + (YV(K+1,L)-YV(K  ,L))**2)
      DSP = SQRT((XV(K+2,L)-XV(K+1,L))**2 + (YV(K+2,L)-YV(K+1,L))**2)
      FV(K,L) = FV(K+1,L) + (FV(K+1,L)-FV(K+2,L))*DSO/DSP
C
      K = II+1
      L = 1
      XV(K,L) = X(II,1)
      YV(K,L) = Y(II,1)
      DSO = SQRT((XV(K-1,L)-XV(K  ,L))**2 + (YV(K-1,L)-YV(K  ,L))**2)
      DSM = SQRT((XV(K-2,L)-XV(K-1,L))**2 + (YV(K-2,L)-YV(K-1,L))**2)
      FV(K,L) = FV(K-1,L) + (FV(K-1,L)-FV(K-2,L))*DSO/DSM
C
      K = II+1
      L = JJ+1+NBL
      XV(K,L) = X(II,JJ)
      YV(K,L) = Y(II,JJ)
      DSO = SQRT((XV(K-1,L)-XV(K  ,L))**2 + (YV(K-1,L)-YV(K  ,L))**2)
      DSM = SQRT((XV(K-2,L)-XV(K-1,L))**2 + (YV(K-2,L)-YV(K-1,L))**2)
      FV(K,L) = FV(K-1,L) + (FV(K-1,L)-FV(K-2,L))*DSO/DSM
C
      NXV = II+1
      NYV = JJ+1+NBL
C
      RETURN
      END ! FSETC



      SUBROUTINE FSETN
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
C==== Sets up contour arrays for f,x,y, defined at grid nodes
C
      DO 5 J=1, JJ
        LSTAG(J) = JSTAG(J)
    5 CONTINUE
C
      DO 10 I=1, II
        DO 101 J=1, JJ
          XV(I,J) = X(I,J)
          YV(I,J) = Y(I,J)
          FV(I,J) = F(I,J)
  101   CONTINUE
   10 CONTINUE
C
      NXV = II
      NYV = JJ
C
      RETURN
      END ! FSETN



      SUBROUTINE CONCLL(FMIN,FMAX,NCON)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION RINPUT(3)
      LOGICAL ERROR
C
C---- Calculate max. and min. values
      XHI = XV(1,1)
      XLO = XV(1,1)
      YHI = YV(1,1)
      YLO = YV(1,1)
      FHI = FV(1,1)
      FLO = FV(1,1)
      DO 1 I=1, NXV
        DO 10 J=1, NYV
          XHI = MAX(XHI,XV(I,J))
          XLO = MIN(XLO,XV(I,J))
          YHI = MAX(YHI,YV(I,J))
          YLO = MIN(YLO,YV(I,J))
          FHI = MAX(FHI,FV(I,J))
          FLO = MIN(FLO,FV(I,J))
   10   CONTINUE
    1 CONTINUE
C
      WRITE(*,1000) FLO,FHI
 1000 FORMAT(1X,'Minimum and maximum function values are:',2F12.5)
C
C---- set reasonable estimate for number of contour levels
      CALL SCALIT(1,FHI,FLO,FSCAL,ANNMAX,NANN)
      NANN = 20*NANN
C
C---- set number of contours below/above zero, using "nice" increment DF
      DF = 1.0/(FSCAL*FLOAT(NANN))
      NLO = (INT(FLO/(5.0*DF) + 100.0) - 100) * 5
      NHI = (INT(FHI/(5.0*DF) + 101.0) - 100) * 5
C
C---- set final min/max contour levels and number of contour levels
      FMIN = FLOAT(NLO) * DF
      FMAX = FLOAT(NHI) * DF
      NCON = NHI - NLO
C
C---- use contour parameters as defaults for user
    2 WRITE(*,1010) FMIN,FMAX,NCON
 1010 FORMAT(1X,
     &   'Enter min, max, and no. of intervals   :',2(F10.3,2X),I6)
      RINPUT(1) = FMIN
      RINPUT(2) = FMAX
      RINPUT(3) = FLOAT(NCON)
      CALL READR(3,RINPUT,ERROR)
      IF(ERROR) GO TO 2
C
      FMIN = RINPUT(1)
      FMAX = RINPUT(2)
      NCON = INT(RINPUT(3)+0.001)
      IF(NCON.EQ.0) GO TO 2
C
      CALL GETCOLOR(ICOL0)
C
C---- loop through all contour levels, plotting each level
      DO 50 NC=NCON, 0, -1
        FRAC = FLOAT(NC)/FLOAT(NCON)
C
        FCON = FMIN + (FMAX-FMIN)*FRAC
C
        IF(LCOLOR) THEN
          ICOL = 1 + INT(FLOAT(NCOLOR-1)*FRAC)
          CALL NEWCOLOR(-ICOL)
        ENDIF
C
C------ loop through streamtube blocks
        L1 = 1
        DO 510 L2=2, NYV
          IF(LSTAG(L2).GT.0 .OR. L2.EQ.NYV) THEN
           CALL CONTGRID((IX+2),(JX+2+NBX),NXV,(L2-L1+1),
     &               XV(1,L1),YV(1,L1),FV(1,L1),FCON,
     &               XOFFG,YOFFG,SFG,SFG)
           L1 = L2+1
          ENDIF
  510   CONTINUE
   50 CONTINUE
C
      IF(LCBAR.AND.LCOLOR) THEN
C------ plot color bar
        XPL = XPAGE - 2.0*XMARG
        YPL = YPAGE - 2.0*YMARG
        CHB  = 0.50 *XPL*CH
        BWID = 0.035*XPL
        BHGT = 0.880*YPL
        XB0  = 0.980*XPL - BWID - 8.0*CHB
        YB0  = 0.060*YPL
        NANN = 8
        CALL GETFACTORS(XFAC,YFAC)
        CALL NEWFACTORS(1.0 ,1.0 )
        CALL COLBAR(XB0,YB0,BWID,BHGT,NCOLOR,FMIN,FMAX,NANN,CHB,-2)
        CALL NEWFACTORS(XFAC,YFAC)
      ENDIF
C
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! CONCLL



      SUBROUTINE WAVCLL(FMIN,FMAX,NCON)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION FT(IX,2), XT(IX,2), YT(IX,2)
      DIMENSION RINPUT(3)
      LOGICAL ERROR
C
      GRAT = SQRT(GM1/GP1)
C
      MMAX = 0.0
C
      CALL GETCOLOR(ICOL0)
C
C---- go over left- and right-running waves
      DO 500 IPASS=1, 2
C
      SGN = FLOAT(2*IPASS - 3)
C
      FLO =  1.0E9
      FHI = -1.0E9
C
      DO 10 J=1, JJ
        DO 100 I=1, II
          IO = MAX( MIN(II-1, I  ) , 1 )
          IM = MAX( MIN(II-1, I-1) , 1 )
          JO = MAX( MIN(JJ-1, J  ) , 1 )
          JM = MAX( MIN(JJ-1, J-1) , 1 )
C
          IF(JSTAG(J).LT.0) JM = JO
          IF(JSTAG(J).GT.0) JO = JM
C
          PSTAVG = 0.25*(  PST(IM,JO) + PST(IO,JO)
     &                   + PST(IM,JM) + PST(IO,JM) )
C
          PILOC = PI(I,J) + PSTINF
          PILOC = MAX(PILOC,0.001*PSTINF)
C
          MSQ = (2.0/GM1)*((PSTAVG/PILOC)**(GM1/GAM) - 1.0)
          MSQ = MAX(MSQ,0.0)
          MMAX = MAX(MMAX,SQRT(MSQ))
C
          BET = 0.0
          IF(MSQ.GE.1.0) BET = SQRT(MSQ - 1.0)
C
          RNU = ATAN(GRAT*BET)/GRAT  -  ATAN(BET)
C
          ANGLE = 0.0
          IF(I.GT.1 .AND. I.LT.II)
     &     ANGLE = ATAN2( (Y(I+1,J) - Y(I-1,J)) ,
     &                    (X(I+1,J) - X(I-1,J))   ) + ALFA
C
          F(I,J) = (SGN*RNU + ANGLE) * 180.0/3.1415926
C
          IF(MSQ.GE.1.0) THEN
           FLEFT = ( RNU + ANGLE) * 180.0/3.1415926
           FRITE = (-RNU + ANGLE) * 180.0/3.1415926
           FLO = MIN( FLO , FLEFT , FRITE )
           FHI = MAX( FHI , FLEFT , FRITE )
          ENDIF
C
  100   CONTINUE
   10 CONTINUE
C
C
      IF(NCON.EQ.0 .AND. IPASS.EQ.1) THEN
C
       WRITE(*,1000) FLO,FHI
 1000  FORMAT(1X,'Minimum and maximum angle values are:',2F9.2)
C
       DANG = 1.0
       NLO = (INT(FLO/(10.0*DANG) + 100.0) - 100) * 10
       NHI = (INT(FHI/(10.0*DANG) + 101.0) - 100) * 10
C       
       FMIN = FLOAT(NLO) * DANG
       FMAX = FLOAT(NHI) * DANG
       NCON = NHI - NLO

    2  WRITE(*,1010) FMIN,FMAX,NCON
 1010  FORMAT(1X,'Enter min, max, and no. of intervals:',2(F7.0,2X),I7)
       RINPUT(1) = FMIN
       RINPUT(2) = FMAX
       RINPUT(3) = FLOAT(NCON)
       CALL READR(3,RINPUT,ERROR)
       IF(ERROR) GO TO 2
C
       FMIN = RINPUT(1)
       FMAX = RINPUT(2)
       NCON = INT(RINPUT(3)+0.001)
       IF(NCON.EQ.0) GO TO 2
C
      ENDIF
C
C---- plot each streamtube separately
      DO 60 JO=1, JJ-1
        IF(JSTAG(JO).GT.0) GO TO 60
C
        JP = JO+1
C
C------ plot each supersonic streamtube segment
        ISTART = 2
        DO 605 I=3, II-1
C
          PSTAVG = 0.50*(  PST(I-1,JO) + PST(I,JO) )
C
          PIO = PI(I,JO) + PSTINF
          PIP = PI(I,JP) + PSTINF
          PIO = MAX(PIO,0.001*PSTINF)
          PIP = MAX(PIP,0.001*PSTINF)
C
          MSQO = (2.0/GM1)*((PSTAVG/PIO)**(GM1/GAM) - 1.0)
          MSQP = (2.0/GM1)*((PSTAVG/PIP)**(GM1/GAM) - 1.0)
C
          IF((MSQO.LT.1.0 .AND. MSQP.LT.1.0)  .OR.
     &       (I.EQ.II-1 .AND. MINF.GT.1.0)         ) THEN
C
           IF(I .GT. ISTART+1) THEN
C
C---------- set temp arrays for supersonic part of streamtube
            DO 6053 IT=ISTART, I-1
              K = IT - ISTART + 1
              FT(K,1) = F(IT,JO)
              FT(K,2) = F(IT,JP)
              XT(K,1) = X(IT,JO)
              XT(K,2) = X(IT,JP)
              YT(K,1) = Y(IT,JO)
              YT(K,2) = Y(IT,JP)
 6053       CONTINUE
C
C---------- Loop through all contour levels   
            DO 6057 NC=NCON, 0, -1
              FRAC = FLOAT(NC)/FLOAT(NCON)
              IF(LCOLOR) THEN
                ICOL = 1 + INT(FLOAT(NCOLOR-1)*FRAC)
                CALL NEWCOLOR(-ICOL)
              ENDIF
              FCON = FMIN + (FMAX-FMIN)*FRAC
              CALL CONTGRID(IX,2,(I-ISTART),2,
     &                  XT,YT,FT,FCON,
     &                  XOFFG,YOFFG,SFG,SFG)
 6057       CONTINUE
C
           ENDIF
C
           ISTART = I
C
          ENDIF
C
 605    CONTINUE
 60   CONTINUE
C
      CALL PLFLUSH
C
  500 CONTINUE
C
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! WAVCLL



      SUBROUTINE GGRID
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
C---- plots grid
C
      CALL NEWPEN(1)
C
      DO 10 J = 1, JJ
        CALL PLOT(XMOD(X(1,J)),YMOD(Y(1,J)),3)
        DO 101 I = 2, II
          CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
  101   CONTINUE
   10 CONTINUE
C
      DO 20 I = 1, II
        CALL PLOT(XMOD(X(I,1)),YMOD(Y(I,1)),3)
        DO 201 J = 2, JJ
          IF(JSTAG(J).LT.0) THEN
            CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),3)
           ELSE
            CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
          ENDIF
  201   CONTINUE
   20 CONTINUE
C
cC---- plot Dstar vectors in wake
c      DO 40 N=1, NBL
c        DO 405 J=JBLD(N)-1, JBLD(N)
c          IS = 2*N - 1 + (JBLD(N)-J)
c          DO 4052 IW=2, NOUT(N)-1
c            I = ITEB(N) + IW-1
c            X1 = XW(IW,N)
c            Y1 = YW(IW,N)
c            X2 = X(I,J)
c            Y2 = Y(I,J) + YMOV
c            DS = SQRT((X2-X1)**2 + (Y2-Y1)**2)
c            DX = DISP(I,IS) * (X2-X1)/DS
c            DY = DISP(I,IS) * (Y2-Y1)/DS
cC
c            CALL PLOT( XMOD(X1   ), YMOD(Y1   ) , 3)
c            CALL PLOT( XMOD(X1+DX), YMOD(Y1+DY) , 2)
c            CALL PLSYMB(XMOD(X1+DX),YMOD(Y1+DY),0.0005*SFG,4,
c     &                  ATAN2(DY,DX)*180.0/3.14159,0)
c 4052     CONTINUE
c 405    CONTINUE
c 40   CONTINUE
C
      RETURN
      END ! GGRID




      SUBROUTINE APLOT        
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'     
C
      DO 100 N = 1, NBL
        CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &              XPB(1,N),YPB(1,N),SB(1,N),XOFFG,YOFFG,SFG,
     &              0.0,0.0,0.0)
  100 CONTINUE
C
      CALL NEWPEN(2)
ccc      IF(REYN .GT. 0.0) THEN
       DO 200 N = 1, NBL
ccc      CALL XYLINE(NOUT(N),XW(1,N),YW(1,N),
ccc  &               XOFFG,SFG,YOFFG,SFG,3)
         CALL XYLINE(NOUT(N),XW(1,N),YW(1,N),
     &               XOFFG,SFG,YOFFG,SFG,3)
         CALL XYSYMB(NOUT(N),XW(1,N),YW(1,N),
     &               XOFFG,SFG,YOFFG,SFG,0.0005*SFG,1)
  200  CONTINUE
ccc      ENDIF

C---- plot displacement body  $$$
      CALL NEWPEN(2)
      DO N=1, NBL
ccc        I = ILEB(N)
        I = 1
C
        J1 = JBLD(N)
        J2 = JBLD(N)-1
        NST = II - I + 1
        CALL XYLINE(NST,X(I,J1),Y(I,J1),XOFFG,SFG,YOFFG,SFG,1)
        CALL XYLINE(NST,X(I,J2),Y(I,J2),XOFFG,SFG,YOFFG,SFG,1)
      ENDDO
C
C---- plot displacement vectors
c      call newpen(1)
cC
c      do n=1, nbl
c       do i=ileb(n)+1, iteb(n)
c         ig = i - ileb(n) + 1
cc
c         j = jbld(n)
c         sbi = sble(n) - sble(n)*sg(ig,is1(n))
c         xbi = seval(sbi,xb(1,n),xpb(1,n),sb(1,n),iib(n))
c         ybi = seval(sbi,yb(1,n),ypb(1,n),sb(1,n),iib(n))
c         call plot(sfg*(xbi-xoffg),
c     &             sfg*(ybi-yoffg),3)
c         call plot(sfg*(x(i,j)-xoffg),
c     &             sfg*(y(i,j)-yoffg),2)
cC
c         j = jbld(n)-1
c         sbi = sble(n) + (sb(iib(n),n) - sble(n))*sg(ig,is2(n))
c         xbi = seval(sbi,xb(1,n),xpb(1,n),sb(1,n),iib(n))
c         ybi = seval(sbi,yb(1,n),ypb(1,n),sb(1,n),iib(n))
c         call plot(sfg*(xbi-xoffg),
c     &             sfg*(ybi-yoffg),3)
c         call plot(sfg*(x(i,j)-xoffg),
c     &             sfg*(y(i,j)-yoffg),2)
c       enddo
cc
c       do iw=2, nout(n)-1
c         i = iteb(n) + iw-1
c         delx = xw(iw+1,n) - xw(iw-1,n)
c         dely = yw(iw+1,n) - yw(iw-1,n)
c         dels = sqrt(delx**2 + dely**2)
cc
c         dx = disp(i,is1(n)) * (-dely/dels)
c         dy = disp(i,is1(n)) * ( delx/dels)
c         call plot(sfg*(xw(iw,n)-xoffg),
c     &             sfg*(yw(iw,n)-yoffg),3)
c         call plot(sfg*(xw(iw,n)-xoffg+dx),
c     &             sfg*(yw(iw,n)-yoffg+dy),2)
cC
c         dx = disp(i,is2(n)) * ( dely/dels)
c         dy = disp(i,is2(n)) * (-delx/dels)
c         call plot(sfg*(xw(iw,n)-xoffg),
c     &             sfg*(yw(iw,n)-yoffg),3)
c         call plot(sfg*(xw(iw,n)-xoffg+dx),
c     &             sfg*(yw(iw,n)-yoffg+dy),2)
c       enddo
cC
c      enddo
cc
      RETURN   
      END ! APLOT   



      SUBROUTINE AIRFPL(N,X,Y,XS,YS,S,XOFF,YOFF,SF,XROT,YROT,AROT)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N), Y(N), XS(N), YS(N), S(N)
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SINA = SIN(AROT)
      COSA = COS(AROT)
C
      IVIS = 3
      I = 1
      XR = (X(I)-XROT)*COSA - (Y(I)-YROT)*SINA
      YR = (Y(I)-YROT)*COSA + (X(I)-XROT)*SINA
      CALL PLOT( XMOD(XR) , YMOD(YR) , 3)
      DO 10 I=2, N
        DSDK = (S(I) - S(I-1))/5.0
        DO 100 K=1, 5
          SS = S(I-1) + DSDK*FLOAT(K)
          XX = SEVAL(SS,X,XS,S,N)
          YY = SEVAL(SS,Y,YS,S,N)
          XR = (XX-XROT)*COSA - (YY-YROT)*SINA
          YR = (YY-YROT)*COSA + (XX-XROT)*SINA
          CALL PLOT( XMOD(XR) , YMOD(YR) , 2)
  100   CONTINUE
   10 CONTINUE
      RETURN
      END ! AIRFPL




      SUBROUTINE PRNTIJ
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      WRITE(*,*)
      WRITE(*,*) 'Grid size: I  ,J   = ', II, JJ
      WRITE(*,*) 'Number of elments: ',NBL
      WRITE(*,*)
      DO 10 N = 1, NBL
        WRITE(*,*) ' Element :',N
        WRITE(*,*) ' Jside1 =',JS1(N),'  ILE1 =',ILEB(N),
     &                                '  ITE1 =',ITEB(N)
        WRITE(*,*) ' Jside2 =',JS2(N),'  ILE2 =',ILEB(N),
     &                                '  ITE2 =',ITEB(N)
 10   CONTINUE
C
      RETURN
      END




      SUBROUTINE ISHADE(IMOM)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION XX(4), YY(4)
C----------------------------------
C     Shades all isentropic cells
C----------------------------------
C
      XLIM1 = XOFFG
      XLIM2 = XOFFG + (XPAGE/SIZE)/SFG
      YLIM1 = YOFFG
      YLIM2 = YOFFG + (YPAGE/SIZE)/SFG
C
C---- find max element chord
      CHMAX = 0.0
      DO 5 N=1, NBL
        CHORD = SQRT( (XBTAIL(N)-XBNOSE(N))**2
     &              + (YBTAIL(N)-YBNOSE(N))**2 )
        CHMAX = MAX(CHMAX,CHORD)
 5    CONTINUE
C
C---- plot distance between shading pixels in inches
      DPIXEL = 0.025
C
      CALL NEWPEN(1)
C
      DO 10 IO=2, II-1
        IM = IO - 1
        IP = IO + 1
        DO 104 JO=1, JJ-1
          IF(JSTAG(JO).GT.0) GO TO 104
C
          IF(LISEN(IO,JO)) THEN
            IF(IMOM.EQ.1) GO TO 104
          ELSE
            IF(IMOM.EQ.0) GO TO 104
          ENDIF
C
          JP = JO+1
C
C-------- set conservation cell corners
          XX(1) = 0.5*(X(IM,JO) + X(IO,JO))
          XX(2) = 0.5*(X(IO,JO) + X(IP,JO))
          XX(3) = 0.5*(X(IO,JP) + X(IP,JP))
          XX(4) = 0.5*(X(IM,JP) + X(IO,JP))
C       
          YY(1) = 0.5*(Y(IM,JO) + Y(IO,JO))
          YY(2) = 0.5*(Y(IO,JO) + Y(IP,JO))
          YY(3) = 0.5*(Y(IO,JP) + Y(IP,JP))
          YY(4) = 0.5*(Y(IM,JP) + Y(IO,JP))
C
          IF(MAX(XX(1),XX(2),XX(3),XX(4)) .GE. XLIM1 .AND.
     &       MIN(XX(1),XX(2),XX(3),XX(4)) .LE. XLIM2 .AND.
     &       MAX(YY(1),YY(2),YY(3),YY(4)) .GE. YLIM1 .AND.
     &       MIN(YY(1),YY(2),YY(3),YY(4)) .LE. YLIM2      )
     &      CALL QSHADE(XX,YY,XOFFG,SFG,YOFFG,SFG,DPIXEL/SIZE)
 104    CONTINUE
 10   CONTINUE
C
      RETURN
      END ! ISHADE


      SUBROUTINE DSHADE
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION XX(4), YY(4)
C----------------------------------
C     Shades displacement body
C----------------------------------
C
      XLIM1 = XOFFG
      XLIM2 = XOFFG + (XPAGE/SIZE)/SFG
      YLIM1 = YOFFG
      YLIM2 = YOFFG + (YPAGE/SIZE)/SFG
C
C---- find max element chord
      CHMAX = 0.0
      DO 5 N=1, NBL
        CHORD = SQRT( (XBTAIL(N)-XBNOSE(N))**2
     &              + (YBTAIL(N)-YBNOSE(N))**2 )
        CHMAX = MAX(CHMAX,CHORD)
 5    CONTINUE
C
C---- plot distance between shading pixels in inches
      DPIXEL = 0.025
C
      CALL NEWPEN(1)
      DO 10 N=1, NBL
        J1 = JS1(N)
        J2 = JS2(N)
        I1 = IS1(N)
        I2 = IS2(N)
        ILE = ILEB(N)
        ITE = ITEB(N)
        DO 104 IO=ILE, ITE-1
          IP = IO+1
          IGO = IO-ILE+1
          IGP = IP-ILE+1
          SBO1 = SBLE(N) + (SB(     1,N)-SBLE(N))*SG(IGO,I1)
          SBP1 = SBLE(N) + (SB(     1,N)-SBLE(N))*SG(IGP,I1)
          SBO2 = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IGO,I2)
          SBP2 = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IGP,I2)
C
          XX(1) = SEVAL(SBO1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          XX(2) = SEVAL(SBP1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          XX(3) = X(IP,J1)
          XX(4) = X(IO,J1)
          YY(1) = SEVAL(SBO1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          YY(2) = SEVAL(SBP1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          YY(3) = Y(IP,J1)
          YY(4) = Y(IO,J1)
          CALL QSHADE(XX,YY,XOFFG,SFG,YOFFG,SFG,DPIXEL/SIZE)
C
          XX(1) = X(IO,J2)
          XX(2) = X(IP,J2)
          XX(3) = SEVAL(SBP2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          XX(4) = SEVAL(SBO2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YY(1) = Y(IO,J2)
          YY(2) = Y(IP,J2)
          YY(3) = SEVAL(SBP2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          YY(4) = SEVAL(SBO2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          CALL QSHADE(XX,YY,XOFFG,SFG,YOFFG,SFG,DPIXEL/SIZE)
 104    CONTINUE
C
        DO 108 IO=ITE, II-1
          IP = IO+1
          XX(1) = X(IO,J2)
          XX(2) = X(IP,J2)
          XX(3) = X(IP,J1)
          XX(4) = X(IO,J1)
          YY(1) = Y(IO,J2)
          YY(2) = Y(IP,J2)
          YY(3) = Y(IP,J1)
          YY(4) = Y(IO,J1)
          CALL QSHADE(XX,YY,XOFFG,SFG,YOFFG,SFG,DPIXEL/SIZE)
 108    CONTINUE
 10   CONTINUE
      RETURN
      END ! DSHADE


      SUBROUTINE QSHADE(X,Y,XOFF,XSF,YOFF,YSF,DPIXEL)
      DIMENSION X(4), Y(4)
C--------------------------------------------
C     Shades quadrilateral cell X:Y
C     DPIXEL is spacing between shading dots
C--------------------------------------------
      XMOD(XTMP) = XSF * (XTMP - XOFF)
      YMOD(YTMP) = YSF * (YTMP - YOFF)
C
      DPX = DPIXEL/XSF
      DPY = DPIXEL/YSF
      DDX = 0.1*DPX
      DDY = 0.1*DPY
C
      XMIN = MIN( X(1), X(2), X(3), X(4) )
      XMAX = MAX( X(1), X(2), X(3), X(4) )
      YMIN = MIN( Y(1), Y(2), Y(3), Y(4) )
      YMAX = MAX( Y(1), Y(2), Y(3), Y(4) )
C
      I1 = INT(ABS(XMIN)/DPX)
      I2 = INT(ABS(XMAX)/DPX)
      J1 = INT(ABS(YMIN)/DPY)
      J2 = INT(ABS(YMAX)/DPY)
C
      I1 = ISIGN( I1 , INT( SIGN(1.0,XMIN) ) )
      I2 = ISIGN( I2 , INT( SIGN(1.0,XMAX) ) )
      J1 = ISIGN( J1 , INT( SIGN(1.0,YMIN) ) )
      J2 = ISIGN( J2 , INT( SIGN(1.0,YMAX) ) )
C
      X21 = X(2) - X(1)
      X32 = X(3) - X(2)
      X13 = X(1) - X(3)
      X31 = X(3) - X(1)
      X43 = X(4) - X(3)
      X14 = X(1) - X(4)
C
      Y21 = Y(2) - Y(1)
      Y32 = Y(3) - Y(2)
      Y13 = Y(1) - Y(3)
      Y31 = Y(3) - Y(1)
      Y43 = Y(4) - Y(3)
      Y14 = Y(1) - Y(4)
C
      DO 10 I=I1, I2
        XP = FLOAT(I) * DPX
        DO 110 J=J1, J2
          YP = FLOAT(J) * DPY
C
          DX1 = X(1) - XP
          DX2 = X(2) - XP
          DX3 = X(3) - XP
          DX4 = X(4) - XP
C
          DY1 = Y(1) - YP
          DY2 = Y(2) - YP
          DY3 = Y(3) - YP
          DY4 = Y(4) - YP
C
          IF((DX1*Y21-DY1*X21 .GT. 0.0 .AND.
     &        DX2*Y32-DY2*X32 .GT. 0.0 .AND.
     &        DX3*Y13-DY3*X13 .GT. 0.0      ) .OR.
     &       (DX1*Y31-DY1*X31 .GT. 0.0 .AND.
     &        DX3*Y43-DY3*X43 .GT. 0.0 .AND.
     &        DX4*Y14-DY4*X14 .GT. 0.0      )     ) THEN
C
C---------- pixel is inside quadrilateral...  plot it as small cross
            CALL PLOT(XMOD(XP-DDX),YMOD(YP),3)
            CALL PLOT(XMOD(XP+DDX),YMOD(YP),2)
            CALL PLOT(XMOD(XP),YMOD(YP-DDY),3)
            CALL PLOT(XMOD(XP),YMOD(YP+DDY),2)
          ENDIF
 110    CONTINUE
 10   CONTINUE
C
      RETURN
      END ! QSHADE




      SUBROUTINE DSLIDE
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      PARAMETER (NKX=256)
      DIMENSION XK(NKX), YK(NKX)
C
C---- plots Dstar slide lines on grid plots
C
      CALL GETCOLOR(ICOL0)
C
      DO IS=1, 2*NBL
        CALL NEWCOLORNAME('orange')
        DO K=1, KNOR(IS)-1
        CROSP = (XSNOR(K,IS)*YSNOR(K+1,IS)-YSNOR(K,IS)*XSNOR(K+1,IS))
     &        / SQRT( (XSNOR(K  ,IS)**2 + YSNOR(K  ,IS)**2)
     &               *(XSNOR(K+1,IS)**2 + YSNOR(K+1,IS)**2) )
        NK = INT(ABS(CROSP)/0.005) + 2
        NK = MIN( NK , NKX )
        DSNOR = SNOR(K+1,IS) - SNOR(K,IS)
        DO 105 L=1, NK
          SNK = SNOR(K,IS) + DSNOR*FLOAT(L-1)/FLOAT(NK-1)
          XK(L) = SEVAL(SNK,XNOR(1,IS),XSNOR(1,IS),SNOR(1,IS),KNOR(IS))
          YK(L) = SEVAL(SNK,YNOR(1,IS),YSNOR(1,IS),SNOR(1,IS),KNOR(IS))
 105    CONTINUE
        CALL XYLINE(NK,XK,YK,XOFFG,SFG,YOFFG,SFG,4)
        ENDDO
C
        CALL NEWCOLORNAME('red')
        DO K=1, KNOR(IS)
          XPL = (XNOR(K,IS)-XOFFG)*SFG
          YPL = (YNOR(K,IS)-YOFFG)*SFG
          CALL PLSYMB(XPL,YPL,0.005*SFG,1,0.0,0)
        ENDDO
C
      ENDDO
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END ! DSLIDE



      SUBROUTINE NHATS(N,FACN)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
C---- plots grid motion direction vectors
C
      DO 10 J = 1, JJ
        DO 101 I = 1, II
          DX = FACN*NXG(I,J,N)
          DY = FACN*NYG(I,J,N)
          CALL PLOT(XMOD(X(I,J)   ),YMOD(Y(I,J)   ),3)
          CALL PLOT(XMOD(X(I,J)+DX),YMOD(Y(I,J)+DY),2)
          X1 = X(I,J) + 0.75*DX + 0.030*DY
          Y1 = Y(I,J) + 0.75*DY - 0.030*DX
          X2 = X(I,J) + 0.75*DX - 0.030*DY
          Y2 = Y(I,J) + 0.75*DY + 0.030*DX
          CALL PLOT(XMOD(X1       ),YMOD(Y1       ),2)
          CALL PLOT(XMOD(X2       ),YMOD(Y2       ),2)
          CALL PLOT(XMOD(X(I,J)+DX),YMOD(Y(I,J)+DY),2)
  101   CONTINUE
   10 CONTINUE
C
      RETURN
      END ! NHATS



      SUBROUTINE NCALC
C..................................................
C     Calculates usual Nhat vectors along which
C     the grid nodes are defined to move.
C
C     Calculates the Nhat vectors along which
C     the grid nodes move in response to the
C     leading edge DOF.
C..................................................
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      REAL NXGT, NYGT
      DIMENSION NXGT(IX,2), NYGT(IX,2)
      DIMENSION RSCAL(NBX), EXPR(NBX)
C
      DO 10 IO=1, II
        DO 11 JO=1, JJ
          NXG(IO,JO,0) = -Y(IO,JO)+YCENT
          NYG(IO,JO,0) =  X(IO,JO)-XCENT
 11     CONTINUE
 10   CONTINUE
C
C---- set decay length for LE Nhats of each element (1/2 the perimeter)
      DO 65 N=1, NBL
        RSCAL(N) = 0.5*(SB(IIB(N),N))
   65 CONTINUE
C
C---- go over all elements
      DO 1000 N = 1, NBL
        IF(IBLE(N).NE.0) GO TO 1000
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ set unaltered top surface Nhats
        IS = IS1(N)
        DO 61 IG=1, IGFIX(IS)-1
          I = ILE + IG - 1
C
          SBI = SBLE(N) + (SB(1,N)-SBLE(N))*SG(IG,IS)
          DX = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          DY = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          FRAC = 1.0 - SG(IG,IS)/SG(IGFIX(IS),IS)
          NXGT(I,1) = FRAC * DX
          NYGT(I,1) = FRAC * DY
   61   CONTINUE
C
        DO 62 IG=IGFIX(IS), NBLD(N)
          I = ILE + IG - 1
          NXGT(I,1) = 0.0
          NYGT(I,1) = 0.0
   62   CONTINUE
C
C------ set unaltered bottom surface Nhats
        IS = IS2(N)
        DO 66 IG=1, IGFIX(IS)-1
          I = ILE + IG - 1
          SBI = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,IS)
          DX = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          DY = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          FRAC = 1.0 - SG(IG,IS)/SG(IGFIX(IS),IS)
          NXGT(I,2) = FRAC * DX
          NYGT(I,2) = FRAC * DY
   66   CONTINUE
C
        DO 67 IG=IGFIX(IS), NBLD(N)
          I = ILE + IG - 1
          NXGT(I,2) = 0.0
          NYGT(I,2) = 0.0
   67   CONTINUE
C
C
C------ Go over all grid points
        DO 100 I=1, II
          DO 90 J=1, JJ
C
C---------- set decay factors, using current element chord as decay length
            DO 82 L=1, NBL
              ISURF = MIN0(ITEB(L),MAX0(ILEB(L),I))
              IF(J.GE.JS1(L)) THEN
               JSURF = JS1(L)
              ELSE
               JSURF = JS2(L)
              ENDIF
C
              RBLD = SQRT((X(I,J)-X(ISURF,JSURF))**2 +
     &                    (Y(I,J)-Y(ISURF,JSURF))**2   )
              ARG = MIN( 10.0*RBLD/RSCAL(N) , 15.0 )
C
              EXPR(L) = EXP(-ARG)
   82       CONTINUE
C
C---------- set weighting factor for current element
            FAC = EXPR(N)
            DO 83 L=1, N-1
              FAC = FAC * ( 1.0 - EXPR(L) )
   83       CONTINUE
            DO 85 L=N+1, NBL
              FAC = FAC * ( 1.0 - EXPR(L) )
   85       CONTINUE
C
            ISURF = MIN0(ITEB(N),MAX0(ILEB(N),I))
            IF(J.GE.JS1(N)) THEN
             JSURF = JS1(N)
             IS = 1
            ELSE
             JSURF = JS2(N)
             IS = 2
            ENDIF
C
            NXG(I,J,N) = NXGT(ISURF,IS)*FAC
            NYG(I,J,N) = NYGT(ISURF,IS)*FAC
C
C---------- weighting factor for alpha-linked grid motion
            RSURF = SQRT( (X(I,J)-X(ISURF,JSURF))**2
     &                  + (Y(I,J)-Y(ISURF,JSURF))**2 )
            ARG = MIN( 2.0*RSURF/RSCAL(N) , 15.0 )
            AFAC = EXP(-ARG)
            NXG(I,J,0) = NXG(I,J,0) * (1.0 - AFAC)
            NYG(I,J,0) = NYG(I,J,0) * (1.0 - AFAC)
C
   90     CONTINUE
  100   CONTINUE
C
 1000 CONTINUE ! with next element
C
      RETURN
      END ! NCALC



      SUBROUTINE NPOSET(N,XBPOS,YBPOS,ABPOS)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      INTEGER IMOVE(2,0:ISX+1), IFIXL(2,0:ISX+1),IFIXR(2,0:ISX+1)
      INTEGER ILT(2)
C
      DIMENSION FRACT(IX,0:ISX+1), FRACN(IX,0:ISX+1),
     &          XMOVE(IX,0:ISX+1), YMOVE(IX,0:ISX+1),
     &          DNXP(IX,0:ISX+1),  DNYP(IX,0:ISX+1),
     &          MFSUM(JX), SBSIDE(ISX),
     &          SGI(IX,0:ISX+1),
     &          XSI(IX,0:ISX+1),
     &          YSI(IX,0:ISX+1)
C
      K = N
C
      DO 1 I=1, II
        DO 1 IS=0, 2*NBL+1
          FRACT(I,IS) = 0.0
          FRACN(I,IS) = 0.0
 1    CONTINUE
C
C---- set integrated mass fraction array
      MFSUM(1) = 0.0
      DO 3 J=2, JJ
        IF(JSTAG(J) .LT. 0) THEN
         MFSUM(J) = 0.0
         GO TO 3
        ENDIF
        MFSUM(J) = MFSUM(J-1) + MFRACT(J-1)
 3    CONTINUE
C
C---- set element surface side lengths
      DO 5 NN=1, NBL
        SBSIDE(IS1(NN)) = SB(1      ,NN) - SBLE(NN)
        SBSIDE(IS2(NN)) = SB(IIB(NN),NN) - SBLE(NN)
 5    CONTINUE
C
C---- put spacing arrays along streamline into single continuous array SGI
      DO 6 IS=1, 2*NBL
        NN = (IS+1)/2
C
C------ grid j index of streamline IS
        J = JS2(NN) - IS + 2*NN
C
        DO 62 I=1, ILEB(NN)
          IG = I
          SGI(I,IS) = SGINL(IG,NN)
          IM = MAX(I-1,1       )
          IP = MIN(I+1,ILEB(NN))
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 62     CONTINUE
C
        DO 64 I=ILEB(NN), ITEB(NN)
          IG = I - ILEB(NN) + 1
          SGI(I,IS) = SG(IG,IS) + SGI(ILEB(NN),IS)
cc          SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
cc          XSI(I,IS) = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
cc     &               *SBSIDE(IS)
cc          YSI(I,IS) = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
cc     &               *SBSIDE(IS)
          IM = MAX(I-1,ILEB(NN))
          IP = MIN(I+1,ITEB(NN))
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 64     CONTINUE
C
        DO 66 I=ITEB(NN)+1, II
          IG = I - ITEB(NN) + 1
          SGI(I,IS) = SGOUT(IG,NN) + SGI(ITEB(NN),IS)
cc          XSI(I,IS) = XW(IG,NN) - XW(IG-1,NN)
cc          YSI(I,IS) = YW(IG,NN) - YW(IG-1,NN)
          IM = MAX(I-1,ITEB(NN))
          IP = MIN(I+1,II      )
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 66     CONTINUE
C
 6    CONTINUE
C
C
      I1 = 0
      I2 = 2*NBL+1
      J1 = 1
      J2 = JJ
C
      I = 1
      SGI(I,I1) = 0.0
      SGI(I,I2) = 0.0
      DO 7 I=2, II
        SGI(I,I1) = SGI(I-1,I1)
     &   + SQRT( (X(I,J1)-X(I-1,J1))**2
     &         + (Y(I,J1)-Y(I-1,J1))**2 )
        SGI(I,I2) = SGI(I-1,I2)
     &   + SQRT( (X(I,J2)-X(I-1,J2))**2
     &         + (Y(I,J2)-Y(I-1,J2))**2 )
 7    CONTINUE
C
      DO 8 I=1, II
        IM = MAX(I-1,1 )
        IP = MIN(I+1,II)
        XSI(I,I1) = X(IP,J1) - X(IM,J1)
        YSI(I,I1) = Y(IP,J1) - Y(IM,J1)
        XSI(I,I2) = X(IP,J2) - X(IM,J2)
        YSI(I,I2) = Y(IP,J2) - Y(IM,J2)
 8    CONTINUE
C
C---- normalize streamwise vector arrays
      DO 9 IS=0, 2*NBL+1
        DO 92 I=1, II
          DSMOD = SQRT(XSI(I,IS)**2 + YSI(I,IS)**2)
          XSI(I,IS) = XSI(I,IS)/DSMOD
          YSI(I,IS) = YSI(I,IS)/DSMOD
 92     CONTINUE
 9    CONTINUE
C
C
      IF(ABPOS.EQ.0.0) THEN
C----- set translation mode surface vectors
       DO 10 I=1, II
         XMOVE(I,IS1(N)) = XBPOS
         YMOVE(I,IS1(N)) = YBPOS
         XMOVE(I,IS2(N)) = XBPOS
         YMOVE(I,IS2(N)) = YBPOS
 10    CONTINUE
      ELSE
C----- set rotation mode surface vectors
       ILE = ILEB(N)
       ITE = ITEB(N)
       DO 15 I=ILE, ITE
         IG = I - ILE + 1
C
         IS = IS1(N)
         SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
         XBI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         YBI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         XMOVE(I,IS) =  (YBI - YBPOS)*ABPOS
         YMOVE(I,IS) = -(XBI - XBPOS)*ABPOS
C
         IS = IS2(N)
         SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
         XBI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         YBI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         XMOVE(I,IS) =  (YBI - YBPOS)*ABPOS
         YMOVE(I,IS) = -(XBI - XBPOS)*ABPOS
 15    CONTINUE
C
C----- inlet, outlet streamlines move with LE, TE
       DO 17 I=1, ILE-1
         XMOVE(I,IS1(N)) = XMOVE(ILE,IS1(N))
         YMOVE(I,IS1(N)) = YMOVE(ILE,IS1(N))
         XMOVE(I,IS2(N)) = XMOVE(ILE,IS2(N))
         YMOVE(I,IS2(N)) = YMOVE(ILE,IS2(N))
 17    CONTINUE
       DO 18 I=ITE+1, II
         XMOVE(I,IS1(N)) = XMOVE(ITE,IS1(N))
         YMOVE(I,IS1(N)) = YMOVE(ITE,IS1(N))
         XMOVE(I,IS2(N)) = XMOVE(ITE,IS2(N))
         YMOVE(I,IS2(N)) = YMOVE(ITE,IS2(N))
 18    CONTINUE
      ENDIF
C
C
      I1 = IS1(N)
      I2 = IS2(N)
      DO 20 IS=0, IS1(N)-1
        DO 202 I=1, II
c          XMOVE(I,IS) = XMOVE(I,IS1(N))
c          YMOVE(I,IS) = YMOVE(I,IS1(N))
C
C-------- set same tangential and perp. motion on other element sides
          IB = I
          IB = MIN(IB,ITEB(N))
          IB = MAX(IB,ILEB(N))
          TMOVE = XMOVE(I,I1)*XSI(IB,I1) + YMOVE(I,I1)*YSI(IB,I1)
          PMOVE = XMOVE(I,I1)*YSI(IB,I1) - YMOVE(I,I1)*XSI(IB,I1)
          XMOVE(I,IS) = TMOVE*XSI(I,IS) !! + PMOVE*YSI(I,IS)
          YMOVE(I,IS) = TMOVE*YSI(I,IS) !! - PMOVE*XSI(I,IS)
 202    CONTINUE
 20   CONTINUE
C
      DO 22 IS=IS2(N)+1, 2*NBL+1
        DO 222 I=1, II
c          XMOVE(I,IS) = XMOVE(I,IS2(N))
c          YMOVE(I,IS) = YMOVE(I,IS2(N))
C
C-------- set same tangential and perp. motion on other element sides
          IB = I
          IB = MIN(IB,ITEB(N))
          IB = MAX(IB,ILEB(N))
          TMOVE = XMOVE(I,I2)*XSI(IB,I2) + YMOVE(I,I2)*YSI(IB,I2)
          PMOVE = XMOVE(I,I2)*YSI(IB,I2) - YMOVE(I,I2)*XSI(IB,I2)
          XMOVE(I,IS) = TMOVE*XSI(I,IS) !! + PMOVE*YSI(I,IS)
          YMOVE(I,IS) = TMOVE*YSI(I,IS) !! - PMOVE*XSI(I,IS)
 222    CONTINUE
 22   CONTINUE
C
C
      DO 25 IS=0, 2*NBL+1
        IFIXL(1,IS) = 1
        IMOVE(1,IS) = 0
        IFIXR(1,IS) = ITEB(N)
C
        IFIXL(2,IS) = ILEB(N)
        IMOVE(2,IS) = 0
        IFIXR(2,IS) = II
 25   CONTINUE
C
C
C---- distribute LE/TE motion points
      ILT(1) = ILEB(N)
      ILT(2) = ITEB(N)
C
      DO 30 LT=1, 2
        I = ILT(LT)
C
C------ sides above element N
        DO 362 IS=IS1(N), 1, -2
          IMOVE(LT,IS  ) = I
          IMOVE(LT,IS-1) = I
          IF(IS.EQ.1) GO TO 363
          NN = (IS+1)/2
          IF(I.GE.ILEB(NN-1) .AND. I.LE.ITEB(NN-1)) GO TO 363
 362    CONTINUE
 363    CONTINUE
C
C------ sides below element N
        DO 366 IS=IS2(N), 2*NBL, 2
          IMOVE(LT,IS  ) = I
          IMOVE(LT,IS+1) = I
          IF(IS.EQ.2*NBL) GO TO 367
          NN = (IS+1)/2
          IF(I.GE.ILEB(NN+1) .AND. I.LE.ITEB(NN+1)) GO TO 367
 366    CONTINUE
 367    CONTINUE
C
 30   CONTINUE
C
C
C---- LE and TE of each element other than N will pin grid movement
      DO 40 NN=1, NBL
        IF(NN.EQ.N) GO TO 40
C
        ILT(1) = ILEB(NN)
        ILT(2) = ITEB(NN)
C
C------ go over two "tent" movements on each element NN
        DO 420 LT=1, 2
C
C-------- check both LE and TE
          DO 410 LETE=1, 2
            I = ILT(LETE)
C
C---------- sides above element NN
            DO 4102 IS=IS1(NN), IS1(1), -2
              ISO = IS
              ISM = IS-1
              IMOVEO = IMOVE(LT,ISO)
              IMOVEM = IMOVE(LT,ISM)
C
              IF(I.LT.IMOVEO) IFIXL(LT,ISO) = MAX(IFIXL(LT,ISO),I)
              IF(I.GT.IMOVEO) IFIXR(LT,ISO) = MIN(IFIXR(LT,ISO),I)
C
              IF(I.LT.IMOVEM) IFIXL(LT,ISM) = MAX(IFIXL(LT,ISM),I)
              IF(I.GT.IMOVEM) IFIXR(LT,ISM) = MIN(IFIXR(LT,ISM),I)
C
              IF(IS.EQ.IS1(1)) GO TO 4103
C
              NNN = (IS+1)/2
              IF(I.GE.ILEB(NNN-1) .AND. I.LE.ITEB(NNN-1)) GO TO 4103
 4102       CONTINUE
 4103       CONTINUE
C
C---------- sides below element NN
            DO 4106 IS=IS2(NN), IS2(NBL), 2
              ISO = IS
              ISP = IS+1
              IMOVEO = IMOVE(LT,ISO)
              IMOVEP = IMOVE(LT,ISP)
C
              IF(I.LT.IMOVEO) IFIXL(LT,ISO) = MAX(IFIXL(LT,ISO),I)
              IF(I.GT.IMOVEO) IFIXR(LT,ISO) = MIN(IFIXR(LT,ISO),I)
C
              IF(I.LT.IMOVEP) IFIXL(LT,ISP) = MAX(IFIXL(LT,ISP),I)
              IF(I.GT.IMOVEP) IFIXR(LT,ISP) = MIN(IFIXR(LT,ISP),I)
C
              IF(IS.EQ.IS2(NBL)) GO TO 4107
C
              NNN = (IS+1)/2
              IF(I.GE.ILEB(NNN+1) .AND. I.LE.ITEB(NNN+1)) GO TO 4107
 4106       CONTINUE
 4107     CONTINUE
C
 410      CONTINUE
 420    CONTINUE
C
 40   CONTINUE

C==========================================================
C     Set up fraction array FRACT for streamwise movement
C
      DO 50 IS=0, 2*NBL+1
C
        DO 580 LT=1, 2

c          write(*,6667) is, ifixl(lt,is), imove(lt,is), ifixr(lt,is),
c     &                  ileb(nn), iteb(nn)
c 6667     format(1x,i3, 2x, 3i6, 4x, 2i6)

          IF(IMOVE(LT,IS).EQ.0) GO TO 580

C-------- set mode vector fractions ahead of LE
          DO 520 I=IFIXL(LT,IS), IMOVE(LT,IS)
            FRACT(I,IS) = FRACT(I,IS)
     &                  + (SGI(I,IS)            - SGI(IFIXL(LT,IS),IS))
     &                  / (SGI(IMOVE(LT,IS),IS) - SGI(IFIXL(LT,IS),IS))
 520      CONTINUE
C
C-------- set mode vector fractions behind LE
          DO 540 I=IMOVE(LT,IS)+1, IFIXR(LT,IS)
            FRACT(I,IS) = FRACT(I,IS)
     &                  + (SGI(I,IS)            - SGI(IFIXR(LT,IS),IS))
     &                  / (SGI(IMOVE(LT,IS),IS) - SGI(IFIXR(LT,IS),IS))
 540      CONTINUE
 580    CONTINUE
C
 50   CONTINUE
C
C
C==========================================================
C
C---- set fraction array FRACN for normal movement 
C-    (zero except on current element)
      DO 55 I=1, II
        FRACN(I,IS1(N)) = 1.0
        FRACN(I,IS2(N)) = 1.0
 55   CONTINUE
C
C==========================================================
C
C---- set mode vectors on all surface and top,bottom streamlines
      DO 60 IS=0, 2*NBL+1
        DO 602 I=1, II
          XT =  XSI(I,IS)
          YT =  YSI(I,IS)
          XN =  YSI(I,IS)
          YN = -XSI(I,IS)
C
          TMOVE = XMOVE(I,IS)*XT + YMOVE(I,IS)*YT
          PMOVE = XMOVE(I,IS)*XN + YMOVE(I,IS)*YN
C
          DNXP(I,IS) = XT*TMOVE*FRACT(I,IS) + XN*PMOVE*FRACN(I,IS)
          DNYP(I,IS) = YT*TMOVE*FRACT(I,IS) + YN*PMOVE*FRACN(I,IS)
 602    CONTINUE
 60   CONTINUE
C
C
C---- go over all interior streamlines, setting mode vectors
      NN = NBL
      JS = 1
      JP = JS2(NN)
      ISS = 2*NBL + 1
      ISP = IS2(NN)
C
      DO 80 J=1, JJ
C
        IF(JSTAG(J).LT.0) THEN
C------- reset bounding streamlines for this streamtube
         JS = JS1(NN)
         JP = JJ
         ISS = IS1(NN)
         ISP = 0
C
         NN = NN-1
         IF(NN.GT.0) THEN
          JP  = JS2(NN)
          ISP = IS2(NN)
         ENDIF
        ENDIF
C
C------ interpolating fractions
        FS = 1.0 - MFSUM(J)/MFSUM(JP)
        FP =       MFSUM(J)/MFSUM(JP)
C
C------ interpolate mode vectors
        DO 805 I=1, II
          DNX = FS*DNXP(I,ISS) + FP*DNXP(I,ISP)
          DNY = FS*DNYP(I,ISS) + FP*DNYP(I,ISP)
          NXG(I,J,N) = DNX  ! +  NXP(I,J,K)
          NYG(I,J,N) = DNY  ! +  NYP(I,J,K)
 805    CONTINUE
C
 80   CONTINUE
C
      RETURN
      END ! NPOSET


