
      SUBROUTINE DECALC
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION SINT_GL(0:NGLX)
      DIMENSION DRAGE_GL(0:NGLX)
C
C--------------------------------------------
C     Calculates wave drag and its
C     derivatives wrt global dofs.
C
C     This version integrates dissipation.
C--------------------------------------------
C
      DRAGE = 0.0
      DO 5 L=1, NRHS
        DRAGE_GL(L) = 0.0
    5 CONTINUE
C
C
      QI_MS = QI_MSQ/MS_MSQ
C
      DO 200 JO = 1, JJ-1
        IF(JSTAG(JO).GT.0) GOTO 200
C
        JP = JO + 1
        JZ = JO + JJ
C
        IO = 1
        IP = 2
C
        QSTAR = SQRT(2.0*HINF/(2.0/GM1 + 1.0))
C
        SX1M = X(IP,JO) - X(IO,JO)
        SX1P = X(IP,JP) - X(IO,JP)
        SY1M = Y(IP,JO) - Y(IO,JO)
        SY1P = Y(IP,JP) - Y(IO,JP)
        SX1 = 0.5*(SX1M + SX1P)
        SY1 = 0.5*(SY1M + SY1P)
        S1 = SQRT(SX1*SX1 + SY1*SY1)
        S1INV = 1.0 / S1
        AX1 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
        AY1 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
        AN1 = (SX1*AY1 - SY1*AX1)*S1INV
C
        STMP = 0.5*S1INV
C
        S1_X1M = -SX1 * STMP
        S1_Y1M = -SY1 * STMP
        S1_X1P = -SX1 * STMP
        S1_Y1P = -SY1 * STMP
        S1_X2M =  SX1 * STMP
        S1_Y2M =  SY1 * STMP
        S1_X2P =  SX1 * STMP
        S1_Y2P =  SY1 * STMP
C
        AN0_X0M = 0.
        AN0_Y0M = 0.
        AN0_X0P = 0.
        AN0_Y0P = 0.
        AN0_X1M = 0.
        AN0_Y1M = 0.
        AN0_X1P = 0.
        AN0_Y1P = 0.
C
        AN1_S1 = -AN1*S1INV
C
        AN1_X1M = ( SY1-AY1 ) * STMP  +  AN1_S1*S1_X1M
        AN1_Y1M = (-SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1M
        AN1_X1P = (-SY1-AY1 ) * STMP  +  AN1_S1*S1_X1P
        AN1_Y1P = ( SX1+AX1 ) * STMP  +  AN1_S1*S1_Y1P
        AN1_X2M = ( SY1+AY1 ) * STMP  +  AN1_S1*S1_X2M
        AN1_Y2M = (-SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2M
        AN1_X2P = (-SY1+AY1 ) * STMP  +  AN1_S1*S1_X2P
        AN1_Y2P = ( SX1-AX1 ) * STMP  +  AN1_S1*S1_Y2P
C
        R1 = R(IO,JO)
C
C------ Calculate Q(R,A;m)  and  P(R,A;m)
        Q1 = M(JO)/(AN1*R1)
        Q1_R1  = -Q1/R1
        Q1_AN1 = -Q1/AN1
        Q1_MJ  =  Q1/M(JO)
C
        MSQ1 = Q1*Q1 / (GM1*(HINF - 0.5*Q1*Q1))
        MSQ1_Q1 = MSQ1*(2.0 + GM1*MSQ1)/Q1
C
        MSQ9 = MSQ1
        MSQ0 = MSQ1
C
C------ set dummy-cell speeds upstream of inflow plane
        Q9     = QINF
        Q9_R9  = 0.
        Q9_AN9 = 0.
        Q9_MJ  = 0.
        Q9_MS  = QI_MSQ/MS_MSQ
C
        Q0     = QINF
        Q0_R0  = 0.
        Q0_AN0 = 0.
        Q0_MJ  = 0.
        Q0_MS  = QI_MSQ/MS_MSQ
C
        IF(MSQ1.GT.1.0) THEN
C------- supersonic inflow -- upwind from freestream speed QINF
         MU     = ABS(MUCON)*(MSQ1-MSFX)/(GAM*MSQ1)
         MU_Q0  = 0.
         MU_Q1  = ABS(MUCON)*      MSFX /(GAM*MSQ1**2) * MSQ1_Q1
         DQ1    =        - (Q1-Q0)*MU    + (Q0-Q9)*MU
         DQ1_Q9 =    -MU
         DQ1_Q0 = 2.0*MU - (Q1-Q0)*MU_Q0 + (Q0-Q9)*MU_Q0
         DQ1_Q1 =    -MU - (Q1-Q0)*MU_Q1 + (Q0-Q9)*MU_Q1
        ELSE
C------- subsonic inflow -- no upwinding
         MU     = 0.
         MU_Q0  = 0.
         MU_Q1  = 0.
         DQ1    = 0.
         DQ1_Q9 = 0.
         DQ1_Q0 = 0.
         DQ1_Q1 = 0.
        ENDIF
C
        SINT = 0.0
        DO 10 L=0, NGLX
          SINT_GL(L) = 0.
 10     CONTINUE
C
C====== Sweep along streamtube setting inviscid Jacobian entries
        DO 100 IO = 2, II-1
C
          IP = IO+1
          IM = IO-1
          IL = IO-2
          IK = IO-3
C
          IL = MAX(IL,1)
          IK = MAX(IK,1)
C
C-------- set random shorthand junk
          SX2M = X(IP,JO) - X(IO,JO)
          SX2P = X(IP,JP) - X(IO,JP)
          SY2M = Y(IP,JO) - Y(IO,JO)
          SY2P = Y(IP,JP) - Y(IO,JP)
          SX2 = 0.5*(SX2M + SX2P)
          SY2 = 0.5*(SY2M + SY2P)
          S2 = SQRT(SX2*SX2 + SY2*SY2)
          S2INV = 1.0 / S2
          AX2 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
          AY2 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
          AN2 = (SX2*AY2 - SY2*AX2)*S2INV
C
          STMP = 0.5*S2INV
C
          S2_X2M = -SX2 * STMP
          S2_Y2M = -SY2 * STMP
          S2_X2P = -SX2 * STMP
          S2_Y2P = -SY2 * STMP
          S2_X3M =  SX2 * STMP
          S2_Y3M =  SY2 * STMP
          S2_X3P =  SX2 * STMP
          S2_Y3P =  SY2 * STMP
C
C-------- assemble  A(x,y)  sensitivities
          AN2_S2 = -AN2*S2INV
C
          AN2_X2M = ( SY2-AY2 ) * STMP  +  AN2_S2*S2_X2M
          AN2_Y2M = (-SX2+AX2 ) * STMP  +  AN2_S2*S2_Y2M
          AN2_X2P = (-SY2-AY2 ) * STMP  +  AN2_S2*S2_X2P
          AN2_Y2P = ( SX2+AX2 ) * STMP  +  AN2_S2*S2_Y2P
          AN2_X3M = ( SY2+AY2 ) * STMP  +  AN2_S2*S2_X3M
          AN2_Y3M = (-SX2-AX2 ) * STMP  +  AN2_S2*S2_Y3M
          AN2_X3P = (-SY2+AY2 ) * STMP  +  AN2_S2*S2_X3P
          AN2_Y3P = ( SX2-AX2 ) * STMP  +  AN2_S2*S2_Y3P
C
          BXM = 0.5*(X(IP,JO)-X(IM,JO))
          BXP = 0.5*(X(IP,JP)-X(IM,JP))
          BYM = 0.5*(Y(IP,JO)-Y(IM,JO))
          BYP = 0.5*(Y(IP,JP)-Y(IM,JP))
          AXA = AX1*AY2 - AX2*AY1
          BXB = BXM*BYP - BXP*BYM
          SXSM = (SX1M*SY2M - SY1M*SX2M)
          SXSP = (SX1P*SY2P - SY1P*SX2P)
C
          XS = 0.5*(BXM+BXP)
          YS = 0.5*(BYM+BYP)
          XN = 0.5*(AX1+AX2)
          YN = 0.5*(AY1+AY2)
          SXN = XS*YN - YS*XN
          SXNINV = 1.0 / SXN
C
C-------- assemble  SXN(x,y)  sensitivities
          SXN_X1M = ( YS-YN ) * 0.25
          SXN_Y1M = (-XS+XN ) * 0.25
          SXN_X1P = (-YS-YN ) * 0.25
          SXN_Y1P = ( XS+XN ) * 0.25
          SXN_X2M = ( YS    ) * 0.5
          SXN_Y2M = (-XS    ) * 0.5
          SXN_X2P = (-YS    ) * 0.5
          SXN_Y2P = ( XS    ) * 0.5
          SXN_X3M = ( YS+YN ) * 0.25
          SXN_Y3M = (-XS-XN ) * 0.25
          SXN_X3P = (-YS+YN ) * 0.25
          SXN_Y3P = ( XS-XN ) * 0.25
C
C-------- calculate flow variables ...
C
          R2 = R(IO,JO)
C
C-------- assemble  Q(R,A;m)  and  P(R,A;m)  sensitivities
          Q2     = M(JO) / (AN2*R2)
          Q2_R2  = -Q2/R2
          Q2_AN2 = -Q2/AN2
          Q2_MJ  =  Q2/M(JO)
C
C-------- set  MSQ(Q)
          MSQ2 = Q2*Q2 / (GM1*(HINF - 0.5*Q2*Q2))
          MSQ2_Q2 = MSQ2*(2.0 + GM1*MSQ2)/Q2
C
C-------- set weighting factor MCF for 2nd order dissipation
          IF(MUCON .LT. 0.0) THEN
C
C---------- use first-order dissipation only
            MCF = 0.0
            MCF_Q1 = 0.
            MCF_Q2 = 0.
C
          ELSE
C
C---------- dot product measuring grid skew
            SNDOT = (SX2*AX2 + SY2*AY2)*S2INV**2
c            SND_S2 = -2.0*SNDOT*S2INV
cC
c            STMP = 0.5*S2INV**2
c            SND_X2M = (-SX2-AX2 ) * STMP  +  SND_S2*S2_X2M
c            SND_Y2M = (-SY2-AY2 ) * STMP  +  SND_S2*S2_Y2M
c            SND_X2P = ( SX2-AX2 ) * STMP  +  SND_S2*S2_X2P
c            SND_Y2P = ( SY2-AY2 ) * STMP  +  SND_S2*S2_Y2P
c            SND_X3M = (-SX2+AX2 ) * STMP  +  SND_S2*S2_X3M
c            SND_Y3M = (-SY2+AY2 ) * STMP  +  SND_S2*S2_Y3M
c            SND_X3P = ( SX2+AX2 ) * STMP  +  SND_S2*S2_X3P
c            SND_Y3P = ( SY2+AY2 ) * STMP  +  SND_S2*S2_Y3P
C
C---------- assume weak 2nd-order dissipation, and weaken more in high skew
            FQWT = 5.0*(1.0 + ABS(SNDOT))
c            FQWT_SND = 5.0*  SIGN(1.0,SNDOT)
C
C---------- use full 2nd-order dissipation only if flow is accelerating
            IF(Q2.GE.Q1 .AND. Q1.GE.Q0 .AND. Q0.GE.Q9) FQWT = 1.0
C
C---------- use full 2nd-order dissipation only if speed gradient is small
            FQ    =  FQWT*(Q2-Q1)/QSTAR
            FQ_Q1 = -FQWT        /QSTAR
            FQ_Q2 =  FQWT        /QSTAR
C
            ARG = FQ**2
            ARG = MIN( 20.0 , ARG )
C
            MCF = EXP(-ARG)
            MCF_FQ = -2.0*FQ*MCF
C
            MCF_Q1 = MCF_FQ*FQ_Q1
            MCF_Q2 = MCF_FQ*FQ_Q2
C
          ENDIF
C
          MU    = 0.
          MU_Q1 = 0.
          MU_Q2 = 0.
C
          MSQMAX = MAX(MSQ1,MSQ2)
          IF(MSQMAX .GT. MSFX) THEN
C
           IF(MSQ2 .GT. MSQ1) THEN
            MU    = ABS(MUCON)*(MSQ2-MSFX) / (GAM*MSQ2)
            MU_Q2 = ABS(MUCON)*      MSFX  / (GAM*MSQ2**2) * MSQ2_Q2
           ELSE
            MU    = ABS(MUCON)*(MSQ1-MSFX) / (GAM*MSQ1)
            MU_Q1 = ABS(MUCON)*      MSFX  / (GAM*MSQ1**2) * MSQ1_Q1
           ENDIF
C
          ENDIF
C
C-------- modify 1st,2nd order dissipation based on previous-cycle max dRho
          MUB     = MU
          MUB_Q1  = MU_Q1
          MUB_Q2  = MU_Q2
C
          MUC     = MCF*MU
          MUC_Q1  = MCF*MU_Q1 + MCF_Q1*MU
          MUC_Q2  = MCF*MU_Q2 + MCF_Q2*MU
C
C
C-------- calculate upwinded speed and assemble  QS(Q)  sensitivities
C-        Qs( Q{R An(x y) m}  Mu(Q) )
          DQ2    =         - (Q2-Q1)*MUB    + (Q1-Q0)*MUC
          DQ2_Q0 =    -MUC
          DQ2_Q1 = MUB+MUC - (Q2-Q1)*MUB_Q1 + (Q1-Q0)*MUC_Q1
          DQ2_Q2 =    -MUB - (Q2-Q1)*MUB_Q2 + (Q1-Q0)*MUC_Q2
C
C
          SI    = (DQ2   -DQ1   )*(MSQ1+MSQ2)/(Q2+Q1)
          SI_Q9 = (      -DQ1_Q9)*(MSQ1+MSQ2)/(Q2+Q1)
          SI_Q0 = (DQ2_Q0-DQ1_Q0)*(MSQ1+MSQ2)/(Q2+Q1)
          SI_Q1 = (DQ2_Q1-DQ1_Q1)*(MSQ1+MSQ2)/(Q2+Q1) - SI/(Q2+Q1)
     &          + (DQ2   -DQ1   )*(MSQ1_Q1  )/(Q2+Q1)
          SI_Q2 = (DQ2_Q2       )*(MSQ1+MSQ2)/(Q2+Q1) - SI/(Q2+Q1)
     &          + (DQ2   -DQ1   )*(  MSQ2_Q2)/(Q2+Q1)
C
          SI_R9 = SI_Q9*Q9_R9
          SI_R0 = SI_Q0*Q0_R0
          SI_R1 = SI_Q1*Q1_R1
          SI_R2 = SI_Q2*Q2_R2
C
          SI_X9M = SI_Q9*Q9_AN9*AN9_X9M
          SI_X0M = SI_Q0*Q0_AN0*AN0_X0M
          SI_X1M = SI_Q1*Q1_AN1*AN1_X1M
          SI_X2M = SI_Q2*Q2_AN2*AN2_X2M
          SI_X9P = SI_Q9*Q9_AN9*AN9_X9P
          SI_X0P = SI_Q0*Q0_AN0*AN0_X0P
          SI_X1P = SI_Q1*Q1_AN1*AN1_X1P
          SI_X2P = SI_Q2*Q2_AN2*AN2_X2P
C
          SI_Y9M = SI_Q9*Q9_AN9*AN9_Y9M
          SI_Y0M = SI_Q0*Q0_AN0*AN0_Y0M
          SI_Y1M = SI_Q1*Q1_AN1*AN1_Y1M
          SI_Y2M = SI_Q2*Q2_AN2*AN2_Y2M
          SI_Y9P = SI_Q9*Q9_AN9*AN9_Y9P
          SI_Y0P = SI_Q0*Q0_AN0*AN0_Y0P
          SI_Y1P = SI_Q1*Q1_AN1*AN1_Y1P
          SI_Y2P = SI_Q2*Q2_AN2*AN2_Y2P
C
          SI_MJ = SI_Q9*Q9_MJ
     &          + SI_Q0*Q0_MJ
     &          + SI_Q1*Q1_MJ
     &          + SI_Q2*Q2_MJ
C
          SINT = SINT + SI
C
          DO 40 L=1, NRHS
            SINT_GL(L) = SINT_GL(L)
     &       -  SI_R9*DR(JO+JJ,L,IL)
     &       -  SI_R0*DR(JO+JJ,L,IM)
     &       -  SI_R1*DR(JO+JJ,L,IO)
     &       -  SI_R2*DR(JO+JJ,L,IP)
     &       - (SI_X9M*NX(IL,JO) + SI_Y9M*NY(IL,JO))*DR(JO,L,IL)
     &       - (SI_X0M*NX(IM,JO) + SI_Y0M*NY(IM,JO))*DR(JO,L,IM)
     &       - (SI_X1M*NX(IO,JO) + SI_Y1M*NY(IO,JO))*DR(JO,L,IO)
     &       - (SI_X2M*NX(IP,JO) + SI_Y2M*NY(IP,JO))*DR(JO,L,IP)
     &       - (SI_X9P*NX(IL,JP) + SI_Y9P*NY(IL,JP))*DR(JP,L,IL)
     &       - (SI_X0P*NX(IM,JP) + SI_Y0P*NY(IM,JP))*DR(JP,L,IM)
     &       - (SI_X1P*NX(IO,JP) + SI_Y1P*NY(IO,JP))*DR(JP,L,IO)
     &       - (SI_X2P*NX(IP,JP) + SI_Y2P*NY(IP,JP))*DR(JP,L,IP)
 40       CONTINUE
C
          SINT_GL(LMASS) = SINT_GL(LMASS)
     &                   + (  SI_Q9*Q9_MJ
     &                      + SI_Q0*Q0_MJ
     &                      + SI_Q1*Q1_MJ
     &                      + SI_Q2*Q2_MJ )*MF0(JO)
C
          DO 42 N=1, NBL
            SINT_GL(LMAS1(N)) = SINT_GL(LMAS1(N))
     &                   + (  SI_Q9*Q9_MJ
     &                      + SI_Q0*Q0_MJ
     &                      + SI_Q1*Q1_MJ
     &                      + SI_Q2*Q2_MJ )*MF1(JO,N)
            SINT_GL(LSBLE(N)) = SINT_GL(LSBLE(N))
     &       + SI_X9M*NXG(IL,JO,N) + SI_Y9M*NYG(IL,JO,N)
     &       + SI_X9P*NXG(IL,JP,N) + SI_Y9P*NYG(IL,JP,N)
     &       + SI_X1M*NXG(IM,JO,N) + SI_Y1M*NYG(IM,JO,N)
     &       + SI_X1P*NXG(IM,JP,N) + SI_Y1P*NYG(IM,JP,N)
     &       + SI_X2M*NXG(IO,JO,N) + SI_Y2M*NYG(IO,JO,N)
     &       + SI_X2P*NXG(IO,JP,N) + SI_Y2P*NYG(IO,JP,N)
     &       + SI_X3M*NXG(IP,JO,N) + SI_Y3M*NYG(IP,JO,N)
     &       + SI_X3P*NXG(IP,JP,N) + SI_Y3P*NYG(IP,JP,N)
 42       CONTINUE
C
          DO 45 NN = 1, NPOSN
            K = KPOSN(NN)
            SINT_GL(LPOSN(K)) = SINT_GL(LPOSN(K))
     &       + SI_X9M*NXP(IL,JO,K) + SI_Y9M*NYP(IL,JO,K)
     &       + SI_X9P*NXP(IL,JP,K) + SI_Y9P*NYP(IL,JP,K)
     &       + SI_X1M*NXP(IM,JO,K) + SI_Y1M*NYP(IM,JO,K)
     &       + SI_X1P*NXP(IM,JP,K) + SI_Y1P*NYP(IM,JP,K)
     &       + SI_X2M*NXP(IO,JO,K) + SI_Y2M*NYP(IO,JO,K)
     &       + SI_X2P*NXP(IO,JP,K) + SI_Y2P*NYP(IO,JP,K)
     &       + SI_X3M*NXP(IP,JO,K) + SI_Y3M*NYP(IP,JO,K)
     &       + SI_X3P*NXP(IP,JP,K) + SI_Y3P*NYP(IP,JP,K)
  45       CONTINUE
           SINT_GL(LALFA) = SINT_GL(LALFA)
     &       + SI_X9M*NXA(IL,JO) + SI_Y9M*NYA(IL,JO)
     &       + SI_X9P*NXA(IL,JP) + SI_Y9P*NYA(IL,JP)
     &       + SI_X1M*NXA(IM,JO) + SI_Y1M*NYA(IM,JO)
     &       + SI_X1P*NXA(IM,JP) + SI_Y1P*NYA(IM,JP)
     &       + SI_X2M*NXA(IO,JO) + SI_Y2M*NYA(IO,JO)
     &       + SI_X2P*NXA(IO,JP) + SI_Y2P*NYA(IO,JP)
     &       + SI_X3M*NXA(IP,JO) + SI_Y3M*NYA(IP,JO)
     &       + SI_X3P*NXA(IP,JP) + SI_Y3P*NYA(IP,JP)
C
C
          AN9_X9M = AN0_X0M
          AN9_Y9M = AN0_Y0M
          AN9_X9P = AN0_X0P
          AN9_Y9P = AN0_Y0P
          AN9_X0M = AN0_X1M
          AN9_Y0M = AN0_Y1M
          AN9_X0P = AN0_X1P
          AN9_Y0P = AN0_Y1P
C
          AN0_X0M = AN1_X1M
          AN0_Y0M = AN1_Y1M
          AN0_X0P = AN1_X1P
          AN0_Y0P = AN1_Y1P
          AN0_X1M = AN1_X2M
          AN0_Y1M = AN1_Y2M
          AN0_X1P = AN1_X2P
          AN0_Y1P = AN1_Y2P
C
          AN1_X1M = AN2_X2M
          AN1_Y1M = AN2_Y2M
          AN1_X1P = AN2_X2P
          AN1_Y1P = AN2_Y2P
          AN1_X2M = AN2_X3M
          AN1_Y2M = AN2_Y3M
          AN1_X2P = AN2_X3P
          AN1_Y2P = AN2_Y3P
C
          DQ1 = DQ2
          Q9 = Q0
          Q0 = Q1
          Q1 = Q2
          R1 = R2
          P1 = P2
          MSQ9 = MSQ0
          MSQ0 = MSQ1
          MSQ1 = MSQ2
C
          DQ1_Q9 = DQ2_Q0
          DQ1_Q0 = DQ2_Q1
          DQ1_Q1 = DQ2_Q2
C
          Q9_R9  = Q0_R0
          Q9_AN9 = Q0_AN0
          Q9_MJ  = Q0_MJ
C
          Q0_R0  = Q1_R1
          Q0_AN0 = Q1_AN1
          Q0_MJ  = Q1_MJ
C
          Q1_R1  = Q2_R2
          Q1_AN1 = Q2_AN2
          Q1_MJ  = Q2_MJ
C
          MSQ1_Q1 = MSQ2_Q2
C
  100   CONTINUE
C
        EXS = EXP(-GM1*SINT)
        EXS_SI = -GM1*EXS
C
        GINF = HINF - 0.5*QINF**2
        QSQ    = 2.0*(HINF - GINF    * EXS)
        QSQ_QI = 2.0*        QINF    * EXS
        QSQ_SI =             QINF**2 * EXS_SI
C
        QL = SQRT(QSQ)
        QL_QI = 0.5*QSQ_QI / QL
        QL_SI = 0.5*QSQ_SI / QL
C
        DRAGE = DRAGE + (QINF - QL)*M(JO)
C
        DO 110 L=1, NRHS
          DRAGE_GL(L) = DRAGE_GL(L) - QL_SI*SINT_GL(L)*M(JO)
 110    CONTINUE
        DRAGE_GL(LMASS) = DRAGE_GL(LMASS) + (QINF  - QL)*MF0(JO)
     &                                    + (QI_MS - QL)*MF0(JO)
     &                                   - QL_QI*QI_MS *M(JO)
        DO 112 N=1, NBL
          DRAGE_GL(LMAS1(N)) = DRAGE_GL(LMASS1(N) + (QINF-QL)*MF1(JO,N)
 112    CONTINUE
C
  200 CONTINUE
C
      RETURN
      END ! DECALC
