      SUBROUTINE DPLOT
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'
C-----------------------------------------------------------
C     Reads in data file or reference profiles and plots them
C     superimposed on calculated profiles.  The profiles are
C     plotted in proper location on actual airfoil.
C-----------------------------------------------------------
C
      CHARACTER*40 FNAME, LINE, uname, argp1
      PARAMETER (IPRX=40,KPRX=160)
      DIMENSION XX(KPRX), YY(KPRX)
      DIMENSION APR(IPRX), XPR(IPRX), YPR(KPRX,IPRX), UPR(KPRX,IPRX)
      DIMENSION YADD(IPRX), YPRFAC(IPRX), UPRFAC(IPRX)
      DIMENSION DSPR(IPRX), THPR(IPRX), TSPR(IPRX)
      INTEGER KK(IPRX), NXPR(IPRX)
      LOGICAL LUPR, LTPR
c
      parameter (jprx=isx*200)
      dimension nsum$(jprx)
      dimension y$(jprx), u$(jprx), uinv$(jprx), udef$(jprx)
      common /prof/ nn$(isx),ue$(isx),uy$(isx),xd$(isx),yd$(isx),
     &              xx$(129,isx),yy$(129,isx),
     &              ui$(129,isx),ud$(129,isx),
     &              vi$(129,isx),vd$(129,isx)
C
      SAVE FNAME
C
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
C---- scaling factors
      TWT = 10.0           ! shear profile
      SH = 0.0009          ! data symbol height/c
C
      LUPR = .FALSE.
      LTPR = .FALSE.
C
 1000 FORMAT(A40)
C
C---- read profile data file
      WRITE(*,1010) FNAME
      READ (*,1000) LINE
      IF(LINE(1:1).EQ.'!') GO TO 19
      IF(LINE(1:1).NE.' ') FNAME = LINE
C
 1010 FORMAT(1X,'Enter u profile data filename: ',A40)
C
      OPEN(UNIT=8,FILE=FNAME,STATUS='OLD',ERR=990)
      READ(8,*,ERR=19,END=19) UREF, REREF
      READ(8,*) XADD, XPRFAC
C
      DO 10 IPR=1, IPRX
        READ(8,*,END=11) YADD(IPR), YPRFAC(IPR), UPRFAC(IPR),
     &                   APR(IPR),XPR(IPR), NXPR(IPR)
        DO 110 K=1, KPRX
          READ(8,*) YPR(K,IPR), UPR(K,IPR)
          IF(YPR(K,IPR) .EQ. 999.0) THEN
           KK(IPR) = K-1
           IF(KK(IPR) .GT. KPRX) WRITE(*,*) 'Profile array overflow.'
           GO TO 10
          ENDIF
  110   CONTINUE
   10 CONTINUE
      KK(IPRX) = K
      IF(KK(IPR) .GT. KPRX) WRITE(*,*) 'Profile array overflow.'
      IPR = IPRX+1
C
   11 NPR = IPR-1
      CLOSE(8)
c
c      do ipr=1, npr
c        if(ypr(1,ipr) .gt. ypr(kk(ipr),ipr)) then
c          do k=1, kk(ipr)/2
c            ytmp = ypr(k,ipr)
c            utmp = upr(k,ipr)
c            ypr(k,ipr) = ypr(kk(ipr)-k+1,ipr)
c            upr(k,ipr) = upr(kk(ipr)-k+1,ipr)
c            ypr(kk(ipr)-k+1,ipr) = ytmp
c            upr(kk(ipr)-k+1,ipr) = utmp
c          enddo
c        endif
c      enddo
c
C
C---- set profile existence flag if one or more profiles were read in
   12 LUPR = NPR .GT. 0
C
C
C---- calculate Dstar, Theta, Tstar  from u profile data
      DO 15 IPR=1, NPR
        DSSUM = 0.0
        THSUM = 0.0
        TSSUM = 0.0
        UPRE = UPR(KK(IPR),IPR)
        DO 155 K=1, KK(IPR)-1
          DYPR = ABS( YPR(K+1,IPR) - YPR(K,IPR) )
          UPRAVG = 0.5*(UPR(K+1,IPR) + UPR(K,IPR)) / UPRE
          DSSUM = DSSUM + (1.0 - UPRAVG   )*DYPR
          THSUM = THSUM + (1.0 - UPRAVG   )*UPRAVG*DYPR
          TSSUM = TSSUM + (1.0 - UPRAVG**2)*UPRAVG*DYPR
 155    CONTINUE
C
        DSPR(IPR) = DSSUM * YPRFAC(IPR)
        THPR(IPR) = THSUM * YPRFAC(IPR)
        TSPR(IPR) = TSSUM * YPRFAC(IPR)
 15   CONTINUE
C
C
C---- skip reading shear data if u data was read in
      IF(LUPR) GO TO 45
C
C
 19   CONTINUE
C
C---- read shear profile data file
      WRITE(*,1020) FNAME
      READ (*,1000) LINE
      IF(LINE(1:1).NE.' ') FNAME = LINE
C
 1020 FORMAT(1X,'Enter shear profile data filename: ',A40)
C
      OPEN(UNIT=8,FILE=FNAME,STATUS='OLD',ERR=990)
      READ(8,*,ERR=45,END=45) UREF, REREF
      READ(8,*) XADD, XPRFAC
      DO 20 IPR=1, IPRX
        READ(8,*,END=21) YADD(IPR), YPRFAC(IPR), UPRFAC(IPR),
     &                   APR(IPR),XPR(IPR), NXPR(IPR)
        DO 210 K=1, KPRX
          READ(8,*) YPR(K,IPR), UPR(K,IPR)
          IF(YPR(K,IPR) .EQ. 999.0) THEN
           KK(IPR) = K-1
           IF(KK(IPR) .GT. KPRX) WRITE(*,*) 'Profile array overflow.'
           GO TO 20
          ENDIF
  210   CONTINUE
   20 CONTINUE
      KK(IPRX) = K
      IF(KK(IPR) .GT. KPRX) WRITE(*,*) 'Profile array overflow.'
      IPR = IPRX+1
C
   21 NPR = IPR-1
      CLOSE(8)
C
      LTPR = NPR .GT. 0
C
C
   45 CONTINUE
C
C---- plot airfoil contour
      CALL NEWPEN(4)
      CALL APLOT
C
C---- plot BL edge 
      IF(LDELTA) CALL DELTA
C
c      call getarg(1,argp1)
c      uname = 'vel.' // argp1
c      open(3,file=uname,status='unknown')
c      write(3,*) '*******************************************'
c      write(3,*) 'VELOCITY PROFILES'
c      write(3,*) '*******************************************'
C
C---- go over profiles ...
      DO 50 IPR=1, NPR
C
C****** plot experimental data
C
C------ scale profile axis y coordinates
        YAX1 = YPR(1      ,IPR) * YPRFAC(IPR)
        YAX2 = YPR(KK(IPR),IPR) * YPRFAC(IPR)
C
C------ set position of profile axes' origin
        X0 = (XPR(IPR) + XADD     )*XPRFAC
        Y0 = (           YADD(IPR))*YPRFAC(IPR)
C
C------ rotate and position axis
        SA = SIN(APR(IPR))
        CA = COS(APR(IPR))
C
C------ scale profile data for plotting
        DO 30 K=1, KK(IPR)
          XX(K) = UPR(K,IPR)*UPRFAC(IPR)*UWT
          YY(K) = YPR(K,IPR)*YPRFAC(IPR)
   30   CONTINUE
C
C------ rotate and position profile
        DO 31 K=1, KK(IPR)
          XBAR = XX(K)
          YBAR = YY(K)
          XROT = XBAR*CA + YBAR*SA + X0
          YROT = YBAR*CA - XBAR*SA + Y0
          XX(K) = XMOD(XROT)
          YY(K) = YMOD(YROT)
   31   CONTINUE
C
C------ plot data profile
        CALL NEWPEN(1)
        CALL XYPLOT(KK(IPR),XX,YY,0.0,1.0,0.0,1.0,1,SH*SFG,1)
C
C
C****** plot analytical profile(s)
C
        YDIR = SIGN( 1.0 , (YPR(KK(IPR),IPR) - YPR(1,IPR)) )
        COSA = CA*YDIR
        SINA = SA*YDIR
C
        YAXDIR = COSA*COS(ALFA) - SINA*SIN(ALFA)
C
        IF(YAXDIR .GT. 0.0) THEN
         IS = 2*NXPR(IPR) - 1
        ELSE
         IS = 2*NXPR(IPR)
        ENDIF
C
        CALL PRPLOT(IS,X0,Y0,SINA,COSA,YDIR)
c
        kslo = 2*nbl
        kshi = 1
        do ks=1, 2*nbl
          if(nn$(ks).ne.0) then
           kslo = min(kslo,ks)
           kshi = max(kshi,ks)
          endif
        enddo
c
c        write(*,*) 
c        write(*,*) kslo, nn$(kslo), yy$(1,kslo),yy$(nn$(kslo),kslo)
c        write(*,*) kshi, nn$(kshi), yy$(1,kshi),yy$(nn$(kshi),kshi)
c        write(*,*) 'y limits:', yy$(nn$(kslo),kslo),yy$(1,kshi)
c
        nssum = 0
        do ks=1, 2*nbl
c
          nk = nn$(ks)
c
          if(nk.eq.0) go to 480
c
          nssum = nssum + 1
c
c-------- normal distance from profile origin
          do k=1, nk
            dx = xx$(k,ks) - x0
            dy = yy$(k,ks) - y0
            yy$(k,ks) = dx*sina + dy*cosa
          enddo
          dx = xd$(ks) - x0
          dy = yd$(ks) - y0
          yd$(ks) = dx*sina + dy*cosa
c
          if(yy$(nk,ks) .lt. yy$(1,ks)) then
c---------- reverse upside-down profile
cc            write(*,*) 'Reversing side', ks
            do k=1, nk/2
              ytmp = yy$(nk-k+1,ks)
              utmp = ui$(nk-k+1,ks)
              dtmp = ud$(nk-k+1,ks)
              yy$(nk-k+1,ks) = yy$(k,ks)
              ui$(nk-k+1,ks) = ui$(k,ks)
              ud$(nk-k+1,ks) = ud$(k,ks)
              yy$(k,ks) = ytmp
              ui$(k,ks) = utmp
              ud$(k,ks) = dtmp
            enddo
          endif
c
c          write(*,*)
c          do k=1, nk
c            write(*,*) ks, k, yy$(k,ks)
c          enddo
c
c-------- spline ui(y) and u(y) profiles
          call spline(ui$(1,ks),vi$(1,ks),yy$(1,ks),nk)
          call spline(ud$(1,ks),vd$(1,ks),yy$(1,ks),nk)
c
 480      continue
        enddo
c
        ytop = yy$(nn$(kslo),kslo)
        ybot = yy$(        1,kshi)
        jsum = 50
        do j=1, jsum
          y$(j) = ybot + (ytop-ybot)*float(j-1)/float(jsum-1)
        enddo
c
        do ks=2*nbl, 1, -1
          nk = nn$(ks)
          do k=1, nk
            if(yy$(k,ks).le.ytop .and. yy$(k,ks).ge.ybot) then
             jsum = jsum + 1
             y$(jsum) = yy$(k,ks)
            endif
          enddo
          if(jsum.gt.jprx) stop 'DPLOT: Array overflow. Increase JPRX.'
        enddo
c
        if(nssum.eq.0) go to 50
c
        call ysort(y$,jsum)
        call ystrp(y$,jsum,0.00001)
c
        do j=1, jsum
          u$(j) = 0.0
          uinv$(j) = 0.0
          udef$(j) = 0.0
          nsum$(j) = 0
        enddo
C
        do ks=1, 2*nbl
          nk = nn$(ks)
          if(nk.ne.0) then
c           write(*,*) ks, yy$(1,ks), yd$(ks), yy$(nk,ks)
           do j=1, jsum
             if(y$(j) .ge. yy$( 1,ks) .and.
     &          y$(j) .le. yy$(nk,ks)      ) then
              dui = seval(y$(j),ui$(1,ks),vi$(1,ks),yy$(1,ks),nk)
              dud = seval(y$(j),ud$(1,ks),vd$(1,ks),yy$(1,ks),nk)
ccc              write(*,*) ks, j, y$(j), dui, dud
              uinv$(j) = uinv$(j) + dui
              udef$(j) = udef$(j) + dud
              nsum$(j) = nsum$(j) + 1
             endif
           enddo
          endif
        enddo
c
c------ reverse inviscid velocity spline arrays
        nssum = kshi - kslo + 1
        do ls=1, (nssum+1)/2
          ksb = kshi-ls+1
          ksf = kslo+ls-1
          utmp = ue$(ksb)
          vtmp = uy$(ksb)
          ytmp = yd$(ksb)
          ue$(ksb) = ue$(ksf)
          uy$(ksb) = uy$(ksf)
          yd$(ksb) = yd$(ksf)
          ue$(ksf) = utmp
          uy$(ksf) = vtmp
          yd$(ksf) = ytmp
        enddo
c
c        write(*,*) kslo, kshi
c        do ks=1, 2*nbl
c          write(*,*) yd$(ks), ue$(ks), uy$(ks)
c        enddo

c------ calculate total profile
        do j=1, jsum
          if(nsum$(j) .ne. 0) then
           uinv$(j) = uinv$(j)/float(nsum$(j))
          endif
c
           if(y$(j).lt.yd$(kslo)) then
            uinv$(j) = ue$(kslo) + uy$(kslo)*(y$(j)-yd$(kslo))
           else if(y$(j).gt.yd$(kshi)) then
            uinv$(j) = ue$(kshi) + uy$(kshi)*(y$(j)-yd$(kshi))
           else
            uinv$(j) = seval(y$(j),ue$(kslo),uy$(kslo),yd$(kslo),nssum)
           endif
           u$(j) = uinv$(j)*(1.0 - udef$(j))

cc           write(*,*) j, y$(j), udef$(j), utmp, uinv$(j)

        enddo
c
        numst = 0
        if(npr.eq.8) then
          if(ipr.eq.1) numst = 1
          if(ipr.eq.2) numst = 2
          if(ipr.eq.3) numst = 3
          if(ipr.eq.4) numst = 4
          if(ipr.eq.5) numst = 5
          if(ipr.eq.6) numst = 6
          if(ipr.eq.7) numst = 8
          if(ipr.eq.8) numst = 9
        else
          if(ipr.eq.1) numst = 3
          if(ipr.eq.2) numst = 5
          if(ipr.eq.3) numst = 6
          if(ipr.eq.4) numst = 7
          if(ipr.eq.5) numst = 8
          if(ipr.eq.6) numst = 9
        endif
c        write(3,3100) x0, numst
c 3100   format(1x,' x/c =',f7.4,', station',i2 /
c     &         1x,'    n/c    u/uinf' )
c        do j=1, jsum, 5
c          write(3,3200) y$(j), u$(j)
c 3200     format(1x,f9.5,f9.4)
c        enddo
C
c
c------ rotate and position profile
        do j=1, jsum
ccc          write(*,*) j, y$(j), u$(j), udef$(j), nsum$(j)

          xbar = u$(j)*uwt
          ybar = y$(j)
c
          xrot = XBAR*COSA + YBAR*SINA + x0
          yrot = YBAR*COSA - XBAR*SINA + y0
          u$(j) = XMOD(xrot)
          y$(j) = YMOD(yrot)
        enddo
c
ccc        CALL NEWPEN(1)
ccc        CALL XYPLOT(jsum,u$,y$,0.0,1.0,0.0,1.0,1,0.5*sh*SFG,1)
ccc        CALL XYPLOT(jsum,u$,y$,0.0,1.0,0.0,1.0,1,0.5*sh*SFG,0)
c
   50 CONTINUE
      close(3)
C
      RETURN
C
  990 WRITE(*,*) 'File OPEN error'
      RETURN
      END ! DPLOT


      subroutine ysort(y,n)
      dimension y(n)
      logical done
c
      DO 1 IPASS=1, 12345
        DONE = .TRUE.
        DO 10 J=2, N
          JM = J-1
          IF(Y(J).GE.Y(JM)) GO TO 10
           DONE = .FALSE.
C
           TMP   = Y(J)
           Y(J)  = Y(JM)
           Y(JM) = TMP
C
   10   CONTINUE
        IF(DONE) RETURN
    1 CONTINUE
      STOP 'YSORT: sort failed.  Increase number of passes.'
      END


      subroutine ystrp(y,n,eps)
      dimension y(n)
c
      K = 1
C
 1    K = K+1
      IF(K.GT.N) RETURN
C
        IF( ABS(Y(K)-Y(K-1)) .LT. EPS) THEN
         DO 10 J=K, N-1
           Y(J) = Y(J+1)
   10    CONTINUE
         N = N-1
        ENDIF
C
      GO TO 1
      END


      SUBROUTINE DPLOTC
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'
C-----------------------------------------------------------
C     Plots analytical profiles at cursor-selected points.
C-----------------------------------------------------------
C
      DIMENSION XXI(IX,ISX), YYI(IX,ISX)
      LOGICAL LWALL
      CHARACTER*1 KCHAR
C
C---- scaling factors
      TWT = 10.0           ! shear profile
      SH = 0.0009          ! data symbol height/c
C
      DO 20 N=1, NBL
        DO 202 IG=1, NBLD(N)
          I = IG + ILEB(N) - 1
          SB1 = SBLE(N) + (SB(1     ,N) - SBLE(N))*SG(IG,IS1(N))
          SB2 = SBLE(N) + (SB(IIB(N),N) - SBLE(N))*SG(IG,IS2(N))
          XXI(I,IS1(N)) = SEVAL(SB1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          XXI(I,IS2(N)) = SEVAL(SB2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YYI(I,IS1(N)) = SEVAL(SB1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          YYI(I,IS2(N)) = SEVAL(SB2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
  202   CONTINUE
        DO 204 IW=2, NOUT(N)
          I = IW + ITEB(N) - 1
          XXI(I,IS1(N)) = XW(IW,N)
          XXI(I,IS2(N)) = XW(IW,N)
          YYI(I,IS1(N)) = YW(IW,N)
          YYI(I,IS2(N)) = YW(IW,N)
  204   CONTINUE
   20 CONTINUE
C
C---- plot airfoil contour
      CALL NEWPEN(4)
      CALL APLOT
C
C---- plot BL edge 
      IF(LDELTA) CALL DELTA
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Mark foot of each profile with cursor,', 
     &           ' twice on last one ...'
C
      XCOLD = 1.0E9
      YCOLD = 1.0E9
C
C---- go over profiles ...
      DO 50 IPR=1, 12345
C
        WRITE(*,*)
C
C------ get cursor plot coordinates
        CALL GETCURSORXY(XC,YC,KCHAR)
C
C------ transform to airfoil coordinates
        XC = XC/SFG + XOFFG
        YC = YC/SFG + YOFFG
C
C------ see if this was the last one
        IF( (XC-XCOLD)**2+(YC-YCOLD)**2 .LT. 1.0E-8 ) RETURN
C
C------ find nearest airfoil surface point
        RSQMIN = 1.0E9
        NMIN = 0
        ISMIN = 0
        IMIN = 0
        DO 505 IS=1, 2*NBL
          N = (IS+1)/2
          DO 5052 I=ILEB(N)+1, II-1
            RSQ = (XC-XXI(I,IS))**2 + (YC-YYI(I,IS))**2
            IF(RSQ .LE. RSQMIN) THEN
             RSQMIN = RSQ
             NMIN = N
             ISMIN = IS
             IMIN = I
            ENDIF
 5052     CONTINUE
  505   CONTINUE
C
        N = NMIN
        IS = ISMIN
        I = IMIN
        LWALL = I .LT. ITEB(N)
C
        IF(I.EQ.ITEB(N)) THEN
         DX = XXI(I,IS) - XXI(I-1,IS)
         DY = YYI(I,IS) - YYI(I-1,IS)
        ELSE IF(I.EQ.ITEB(N)+1) THEN
         DX = XXI(I+1,IS) - XXI(I,IS)
         DY = YYI(I+1,IS) - YYI(I,IS)
        ELSE
         DX = XXI(I+1,IS) - XXI(I-1,IS)
         DY = YYI(I+1,IS) - YYI(I-1,IS)
        ENDIF
C
        CRSP = DX*(YC-YYI(I,IS)) - DY*(XC-XXI(I,IS))
        DOTP = DX*(XC-XXI(I,IS)) + DY*(YC-YYI(I,IS))
C
C------ find interval on which profile axis intersects airfoil or wake
        IF(DOTP .GT. 0.0) THEN
         IO = I
         IP = I+1
        ELSE
         IO = I-1
         IP = I
        ENDIF
C
        LWALL = IO .LT. ITEB(N)
c
ccc        write(*,*) i, is, n, lwall
C
C------ for wake, see on which side we're really at
        IF(.NOT.LWALL) THEN
         IF(CRSP.GT. 0.0) THEN
          ISMIN = 2*NMIN-1
         ELSE
          ISMIN = 2*NMIN
         ENDIF
         IS = ISMIN
        ENDIF
C
C------ set interpolation fraction at profile location
        DX = XXI(IP,IS) - XXI(IO,IS)
        DY = YYI(IP,IS) - YYI(IO,IS)
        VX = XC - XXI(IO,IS)
        VY = YC - YYI(IO,IS)
        FRAC = (DX*VX + DY*VY)/(DX*DX+DY*DY)
C
C------ set averaged displacement vector at profile location
        IF(LWALL) THEN
         J = JSRF(IS)
         BNXO = X(IO,J) - XXI(IO,IS)
         BNYO = Y(IO,J) - YYI(IO,IS)
         BNXP = X(IP,J) - XXI(IP,IS)
         BNYP = Y(IP,J) - YYI(IP,IS)
         CA = FRAC*BNYP + (1.0-FRAC)*BNYO
         SA = FRAC*BNXP + (1.0-FRAC)*BNXO
        ELSE
         J = JSRF(IS)
         BNXO1 = X(IO,J) - XXI(IO,IS)
         BNYO1 = Y(IO,J) - YYI(IO,IS)
         BNXP1 = X(IP,J) - XXI(IP,IS)
         BNYP1 = Y(IP,J) - YYI(IP,IS)
         DSO1 = DSTR(IO,IS)
         DSP1 = DSTR(IP,IS)
         IF(MOD(IS,2).EQ.1) THEN
          J = JSRF(IS)-1
          ISO = IS+1
         ELSE
          J = JSRF(IS)+1
          ISO = IS-1
         ENDIF
         BNXO2 = X(IO,J) - XXI(IO,IS)
         BNYO2 = Y(IO,J) - YYI(IO,IS)
         BNXP2 = X(IP,J) - XXI(IP,IS)
         BNYP2 = Y(IP,J) - YYI(IP,IS)
         DSO2 = DSTR(IO,ISO)
         DSP2 = DSTR(IP,ISO)
C
         CA = (BNYP1*DSP1 - BNYP2*DSP2)*FRAC
     &      + (BNYO1*DSO1 - BNYO2*DSO2)*(1.0-FRAC)
         SA = (BNXP1*DSP1 - BNXP2*DSP2)*FRAC
     &      + (BNXO1*DSO1 - BNXO2*DSO2)*(1.0-FRAC)
        ENDIF
C
        CSMOD = SQRT(CA**2 + SA**2)
        CA = CA/CSMOD
        SA = SA/CSMOD
C
        ASGN = 1.0
        IF(MOD(IS,2) .EQ. 0) ASGN = -1.0
C
        CALL PRPLOT(IS,XC,YC,SA,CA,ASGN)
C
        XCOLD = XC
        YCOLD = YC
   50 CONTINUE
C
      RETURN
      END ! DPLOTC



      SUBROUTINE PRPLOT(ISPR,X0,Y0,SA,CA,ASGN)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C-----------------------------------------------------------------
C     Plots velocity profile taken from flow solution.
C
C   ISPR   index of surface streamline on which profile sits
C   X0,Y0  coordinates of point through which profile axis passes
C   SA,CA  sin,cos of profile axis angle (cw from vertical)
C-----------------------------------------------------------------
C             
      LOGICAL WALL, TURB
      PARAMETER (KPRX=129)
      DIMENSION XX(KPRX), YY(KPRX), FFS(KPRX), SFS(KPRX)
c
      common /prof/ nn$(isx),ue$(isx),uy$(isx),xd$(isx),yd$(isx),
     &              xx$(129,isx),yy$(129,isx),
     &              ui$(129,isx),ud$(129,isx),
     &              vi$(129,isx),vd$(129,isx)

C
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
      do is=1, 2*nbl
        nn$(is) = 0
        do k=1, 129
          xx$(k,is) = 0.
          yy$(k,is) = 0.
          ui$(k,is) = 0.
          ud$(k,is) = 0.
        enddo
      enddo

C
      NPR = (ISPR+1)/2
C
C---- go over surface streamlines starting at this one, going up and down
      DO 1000 IPASS=1, 2
c###      DO 1000 IPASS=1, 1
C
        IF(IPASS.EQ.1) THEN
C------- start at this one and go up
         ISFRST = ISPR
         ISLAST = 1
         ISINCR = -1
        ELSE
C------- start at one below and go down
         ISFRST = ISPR+1
         ISLAST = 2*NBL
         ISINCR = 1
        ENDIF
C
C------ plot only single profile   ###
c        ISFRST = ISPR
c        ISLAST = ISPR
c        ISINCR = 1
C
        DO 40 IS=ISFRST, ISLAST, ISINCR
C
        N = (IS+1)/2
C
C------ set index of opposite streamline for this element and TE s-value
        IF(MOD(IS,2) .EQ. 1) THEN
         JS = IS+1
         SBTE = SB(1,N)
        ELSE
         JS = IS-1
         SBTE = SB(IIB(N),N)
        ENDIF
C
        SBSURF = SBTE - SBLE(N)
C
C------ for sides other than the current one, go over only wakes
        IF(IS.NE.ISFRST) GO TO 419
C
C
C------ find Y at profile origin and calculate local Dstar, Theta ...
C
        SFT1 = SBTE
        XFT1 = SEVAL(SFT1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YFT1 = SEVAL(SFT1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
        CRP1 = SA*(YFT1-Y0) - CA*(XFT1-X0)
C
C------ check airfoil surfaces first
        DO 410 IG=2, NBLD(N)
C
C-------- form cross-product with profile axis and vector to surface point
          SFT2 = SBLE(N) + SBSURF*SG(IG,IS)
          XFT2 = SEVAL(SFT2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YFT2 = SEVAL(SFT2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          CRP2 = SA*(YFT2-Y0) - CA*(XFT2-X0)
C
          CRPD = SA*(YFT2-YFT1) - CA*(XFT2-XFT1)
C
C-------- if cross-product changes sign, axis and BL intersect
          IF(CRP2*CRP1 .LE. 0.0 .AND. ASGN*CRPD .LT. 0.0) THEN
C
           FRAC = CRP1 / (CRP1-CRP2)
C
ccc        XFT = XFT1 + FRAC*(XFT2-XFT1)
ccc        YFT = YFT1 + FRAC*(YFT2-YFT1)
C
           SFT = SFT1 + FRAC*(SFT2-SFT1)
           XFT = SEVAL(SFT,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           YFT = SEVAL(SFT,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
           I = ILEB(N) + IG - 1
           TH = THET(I-1,IS) + FRAC*(THET(I,IS)-THET(I-1,IS))
           DS = DSTR(I-1,IS) + FRAC*(DSTR(I,IS)-DSTR(I-1,IS))
           UE = UEDG(I-1,IS) + FRAC*(UEDG(I,IS)-UEDG(I-1,IS))
           UN = DUDN(I-1,IS) + FRAC*(DUDN(I,IS)-DUDN(I-1,IS))
           DSB = ABS(SBSURF) * (SG(IG,IS) - SG(IG-1,IS))
           UX = (UEDG(I,IS) - UEDG(I-1,IS))/DSB
     &    * 2.0/(UEDG(I,IS) + UEDG(I-1,IS))
C
C--------- UEDG is really Ue/Qinf, so put Ue in consistent units
           UE = UE * QINF
C
           WALL = .TRUE.
           GO TO 421
          ENDIF
C
          SFT1 = SFT2
          XFT1 = XFT2
          YFT1 = YFT2
          CRP1 = CRP2
  410   CONTINUE
C
C------ check wake
  419   XFT1 = XW(1,N)
        YFT1 = YW(1,N)
        CRP1 = SA*(YFT1-Y0) - CA*(XFT1-X0)
C
        DO 420 IW=2, NOUT(N)-1
C
C-------- form cross-product with profile axis and vector to wake point
          XFT2 = XW(IW,N)
          YFT2 = YW(IW,N)
          CRP2 = SA*(YFT2-Y0) - CA*(XFT2-X0)
C
          CRPD = SA*(YFT2-YFT1) - CA*(XFT2-XFT1)
C
C-------- if cross-product changes sign, axis and BL intersect
          IF(CRP2*CRP1 .LE. 0.0 .AND. ASGN*CRPD .LT. 0.0) THEN
C
           FRAC = CRP1 / (CRP1-CRP2)
           XFT = XFT1 + FRAC*(XFT2-XFT1)
           YFT = YFT1 + FRAC*(YFT2-YFT1)
C
           I = ITEB(N) + IW - 1
C
C--------- set blunt TE dead-air region width
           IF(I .EQ. ITEB(N)+1) THEN
            DSGAP = 0.5*(              FRAC*(WGAP(I,N)            ))
           ELSE
            DSGAP = 0.5*(WGAP(I-1,N) + FRAC*(WGAP(I,N)-WGAP(I-1,N)))
           ENDIF
C
           YGAP = 0.5*(WGAP(I-1,N) + FRAC*(WGAP(I,N)-WGAP(I-1,N)))
C
C--------- set wake half variables
           TH = THET(I-1,IS) + FRAC*(THET(I,IS)-THET(I-1,IS))
           DS = DSTR(I-1,IS) + FRAC*(DSTR(I,IS)-DSTR(I-1,IS)) - DSGAP
           UE = UEDG(I-1,IS) + FRAC*(UEDG(I,IS)-UEDG(I-1,IS))
           UN = DUDN(I-1,IS) + FRAC*(DUDN(I,IS)-DUDN(I-1,IS))
           DSB = SQRT( (XW(IW,N)-XW(IW-1,N))**2
     &               + (YW(IW,N)-YW(IW-1,N))**2 )
           UX = (UEDG(I,IS) - UEDG(I-1,IS))/DSB
     &    * 2.0/(UEDG(I,IS) + UEDG(I-1,IS))
C
C--------- set variables on opposite wake half
           THOPP = THET(I-1,JS) + FRAC*(THET(I,JS)-THET(I-1,JS))
           DSOPP = DSTR(I-1,JS) + FRAC*(DSTR(I,JS)-DSTR(I-1,JS)) - DSGAP
           UEOPP = UEDG(I-1,JS) + FRAC*(UEDG(I,JS)-UEDG(I-1,JS))
           UNOPP = DUDN(I-1,JS) + FRAC*(DUDN(I,JS)-DUDN(I-1,JS))
           WALL = .FALSE.
C
C--------- UEDG is really Ue/Qinf, so put Ue in consistent units
           UE    = UE    * QINF
           UEOPP = UEOPP * QINF
C
           GO TO 421
          ENDIF
C
          XFT1 = XFT2
          YFT1 = YFT2
          CRP1 = CRP2
  420   CONTINUE
C
C------ wake point not found ... go on to next surface streamline
        GO TO 40
C
C------ pick up here after we have solution Dstar, Theta
  421   CONTINUE
C
C------ don't bother with other airfoil surface facing away from profile
        IF( WALL .AND. N.EQ.NPR .AND. IS.NE.ISPR ) GO TO 1000
C
C------ set turbulent flag
        TURB = I .GT. ITRAN(IS)
C
C------ calculate kinematic shape parameter
        HE = HINF - 0.5*UE*UE
        MSQ = UE**2 / (GM1*HE)
        HK = (DS/TH - 0.29*MSQ)/(1.0 + 0.113*MSQ)
C
C------ calculate Rtheta
        RHO = RSTOUT*(1.0 + 0.5*GM1*MSQ)**(-1.0/GM1)
        VISC = SQRT((HE/HINF)**3) * (HINF+HVIS)/(HE+HVIS)/REYN
        RET  = RHO*UE*TH/VISC
C
        NN = KPRX
C
        IF(WALL) THEN
C
         UO = 1.0
         IF(TURB) THEN
C-------- set Spalding + power-law turbulent profile
          CALL PRWALL(HK*TH,TH,UO,RET,MSQ,CT, BB,
     &                DE, DE_DS, DE_TH, DE_UO, DE_RT, DE_MS,
     &                US, US_DS, US_TH, US_UO, US_RT, US_MS,
     &                HS, HS_DS, HS_TH, HS_UO, HS_RT, HS_MS,
     &                CF, CF_DS, CF_TH, CF_UO, CF_RT, CF_MS,
     &                CD, CD_DS, CD_TH, CD_UO, CD_RT, CD_MS,
     &                    CD_CT  )
c
          WRITE(*,9100) IS, XFT,YFT, RET,HK,US
 9100     FORMAT(1X,'side  x y Rth H Us', I3, 2F8.4, F9.2, F9.4, F9.5)
C
          CALL UWALL(TH,UO,DE,US,RET,CF,BB,   YY,XX,NN)
C
C-------- limit profile height
          DECORR = 1.5 * (3.15 + 1.72/(HK-1.0) + HK) * TH
          DO 422 K=NN, 1, -1
            IF(YY(K) .LE. DECORR) GO TO 423
 422      CONTINUE
 423      NN = K
          DE = YY(K)
C
CCC       CALL TWALL(TH,UO,DE,US,RET,CF,CT,UX,YY,XX,NN)
C
         ELSE IF(LLAMPL) THEN
C-------- set Falkner-Skan profile
          WRITE(*,9200) IS, XFT,YFT, RET,HK
 9200     FORMAT(1X,'side  x y Rth H   ', I3, 2F8.4, F9.2, F9.4 )
C
          INORM = 3
          ISPEC = 2
          HSPEC = HK
          ETAE = 1.5*(3.15 + 1.72/(HK-1.0) + HK)
          GEO = 1.0
          CALL FS(INORM,ISPEC,BU,HSPEC,NN,ETAE,GEO,YY,FFS,XX,SFS,DEFS)
          DE = ETAE*TH
C
          DO 425 K=1, NN
            YY(K) = YY(K)*TH
 425      CONTINUE
C
         ELSE 
C-------- go to next profile on this line
          GO TO 39
C
         ENDIF
C
        ELSE
C
C------- calculate kinematic shape parameter for opposite wake half
         HEOPP = HINF - 0.5*UEOPP*UEOPP
         MSQ = UEOPP**2 / (GM1*HEOPP)
         HKOPP = (DSOPP/THOPP - 0.29*MSQ)/(1.0 + 0.113*MSQ)
C
         IF(HKOPP .GT. HK) THEN
C
C-------- set center velocity UI from opposite wake deck
          UO = 1.0
          CALL DUWAK1(HKOPP*THOPP,THOPP,UO, DEOPP,UI)
C
          DI = 0.20*SQRT((XFT-XW(1,N))**2 + (YFT-YW(1,N))**2)
     &       + TH*1000.0/RET
          DI = MIN(DI,TH*5.0)
C
C-------- set profile parameters for this wake deck
          UO = 1.0
          CALL DUWAK2(HK*TH,TH,UO,UI,DI, UB,DE)
C
         ELSE
C
          UO = 1.0
          CALL DUWAK1(HK*TH,TH,UO, DE,UI)
          DI = 0.0
          UB = UI
C
         ENDIF
C
         WRITE(*,9100) IS, XFT,YFT, RET,HK,UB
C
         CALL UWAKE(DI,DE,UI,UB,UO, YY,XX,NN)
CCC      CALL TWALL(TH,UO,DE,UI,RET,100.0,CT,UX, YY,XX,NN)
C
         DO 427 K=1, NN
           YY(K) = YY(K) + YGAP
 427     CONTINUE
C
        ENDIF
C
        YAX = 1.1*DE
C
C------ set sin,cos of profile axis and u-direction indicator
        IF(MOD(IS,2) .EQ. 0) THEN
         UDIR = -1.0
        ELSE
         UDIR = 1.0
        ENDIF 
C
        IF(MOD(IS,2) .NE. MOD(ISPR,2)) THEN
         COSA = -CA
         SINA = -SA
        ELSE
         COSA = CA
         SINA = SA
        ENDIF 
C
        xd$(is) = (ds+dsgap)*sina + xft
        yd$(is) = (ds+dsgap)*cosa + yft
        uy$(is) = udir * un/qinf
        ue$(is) = ue/qinf
        do k=1, nn
          ui$(k,is) = (ue + un*(yy(k)-(ds+dsgap)))/qinf
          ud$(k,is) = 1.0 - xx(k)
          xx$(k,is) = yy(k)*sina + xft
          yy$(k,is) = yy(k)*cosa + yft
        enddo
        nn$(is) = nn
C
C
        X1 = XFT
        Y1 = YFT
        X2 = XFT + YAX*SINA
        Y2 = YFT + YAX*COSA
C
        

C------ plot axis
        CALL NEWPEN(1)
        CALL PLOT(XMOD(X1),YMOD(Y1),3)
        CALL PLOT(XMOD(X2),YMOD(Y2),2)
C
        DO 430 K=1, NN
          ULOC = UE + UN*(YY(K)-(DS+DSGAP))
          XX(K) = XX(K)*ULOC/QINF * UWT * UDIR
CCC       YY(K) = YY(K)
  430   CONTINUE
C
C------ rotate and position profile
        DO 431 K=1, NN
          XBAR = XX(K)
          YBAR = YY(K)
          XROT = XBAR*COSA + YBAR*SINA + XFT
          YROT = YBAR*COSA - XBAR*SINA + YFT
          XX(K) = XMOD(XROT)
          YY(K) = YMOD(YROT)
  431   CONTINUE
C
        CALL NEWPEN(2)
        CALL XYPLOT(NN,XX,YY,0.0,1.0,0.0,1.0,1,0.0,0)
C
   39   IF( WALL .AND. IS.NE.ISPR ) GO TO 1000
C
   40   CONTINUE
C
 1000 CONTINUE
C
      RETURN
      END ! PRPLOT



      SUBROUTINE DELTA
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'     
      DIMENSION XDEL(IX), YDEL(IX)
C
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
      DPLT = 0.05
C
      DO 10 IS=1, 2*NBL
        N = (IS+1)/2
C
        IF(MOD(IS,2).EQ.1) THEN
         SBSURF = -SBLE(N)
         J = JS1(N)
        ELSE
         SBSURF = SB(IIB(N),N) - SBLE(N)
         J = JS2(N)
        ENDIF
C
C------ go over airfoil surface
        ID = 0
        DO 110 IG=2, NBLD(N)
C
          I = ILEB(N) + IG - 1
          UEI = UEDG(I,IS) * QINF
          THI = THET(I,IS)
          DSI = DSTR(I,IS)
          MSQ = UEI**2 / (GM1*(HINF - 0.5*UEI**2))
          HKI = (DSI/THI - 0.29*MSQ)/(1.0 + 0.113*MSQ)
C
          DEI = (3.15 + 1.72/(HKI-1.0) )*THI  +  DSI
          DEI = MIN( DEI , 15.0*THI )
C
          SS = SBLE(N) + SG(IG,IS)*SBSURF
          XX = SEVAL(SS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YY = SEVAL(SS,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          XD = X(I,J) - XX
          YD = Y(I,J) - YY
C
          XN = XD / SQRT(XD*XD + YD*YD)
          YN = YD / SQRT(XD*XD + YD*YD)
C
C          DS = (SG(IG,IS) - SG(IG-1,IS))*SBSURF
C          X1 = XMOD( XX + DEI*XN + DPLT*DS*YN )
C          Y1 = YMOD( YY + DEI*YN - DPLT*DS*XN )
C          X2 = XMOD( XX + DEI*XN - DPLT*DS*YN )
C          Y2 = YMOD( YY + DEI*YN + DPLT*DS*XN )
C
C          CALL PLOT(X1,Y1,3)
C          CALL PLOT(X2,Y2,2)
C
          ID = ID+1
          XDEL(ID) = XMOD( XX + DEI*XN )
          YDEL(ID) = YMOD( YY + DEI*YN )
C
  110   CONTINUE
C
C
C------ go over wake
        DO 130 IW=2, NOUT(N)-1
C
          I = ITEB(N) + IW - 1
          UEI = UEDG(I,IS) * QINF
          THI = THET(I,IS)
          DSI = DSTR(I,IS) - 0.5*WGAP(I,N)
          MSQ = UEI**2 / (GM1*(HINF - 0.5*UEI**2))
          HKI = (DSI/THI - 0.29*MSQ)/(1.0 + 0.113*MSQ)
C
          DEI = (3.15 + 1.72/(HKI-1.0) )*THI  +  DSI + 0.5*WGAP(I,N)
C
          XX = XW(IW,N)
          YY = YW(IW,N)
          XD = X(I,J) - XX
          YD = Y(I,J) - YY
C
C          DS = (SGOUT(IW,N) - SGOUT(IW-1,N))*SWAK(N)
C          X1 = XMOD( XX + DEI*XN + DPLT*DS*YN )
C          Y1 = YMOD( YY + DEI*YN - DPLT*DS*XN )
C          X2 = XMOD( XX + DEI*XN - DPLT*DS*YN )
C          Y2 = YMOD( YY + DEI*YN + DPLT*DS*XN )
C
C          CALL PLOT(X1,Y1,3)
C          CALL PLOT(X2,Y2,2)
C
          ID = ID+1
          XDEL(ID) = XMOD( XX + DEI*XN )
          YDEL(ID) = YMOD( YY + DEI*YN )
C
  130   CONTINUE
C
        CALL NEWPEN(2)
        CALL XYPLOT(ID,XDEL,YDEL,0.0,1.0,0.0,1.0,4,0.0,0)
C
   10 CONTINUE
C
      RETURN        
      END ! DELTA



      SUBROUTINE DPLOTI
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'
C-----------------------------------------------------------
C     Plots inviscid profiles at cursor-selected points.
C-----------------------------------------------------------
C
      LOGICAL LWALL
      CHARACTER*1 KCHAR
C
C---- plot airfoil contour
      CALL NEWPEN(4)
      CALL APLOT
C
C---- plot BL edge 
      IF(LDELTA) CALL DELTA
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Mark each profile with cursor,', 
     &           ' twice on last one ...'
C
      XCOLD = 1.0E9
      YCOLD = 1.0E9
C
C---- go over profiles ...
      DO 50 IPR=1, 12345
C
        WRITE(*,*)
C
C------ get cursor plot coordinates
        CALL GETCURSORXY(XC,YC,KCHAR)
C
C------ transform to airfoil coordinates
        XC = XC/SFG + XOFFG
        YC = YC/SFG + YOFFG
C
C------ see if this was the last one
        IF( (XC-XCOLD)**2+(YC-YCOLD)**2 .LT. 1.0E-8 ) GO TO 51
C
C------ find cell
        CALL LOCELL(XC,YC,IC,JC)
        IF(IC.EQ.0 .OR. JC.EQ.0) GO TO 51
C
C------ set angle of profile axis perpendicular to local velocity
        SX = X(IC+1,JC) + X(IC+1,JC+1) - X(IC,JC) - X(IC,JC+1)
        SY = Y(IC+1,JC) + Y(IC+1,JC+1) - Y(IC,JC) - Y(IC,JC+1)
C
        XA = -SY/SQRT(SX**2 + SY**2)
        YA =  SX/SQRT(SX**2 + SY**2)
C
        CALL PIPLOT(IC,JC,XC,YC,XA,YA)
C
        XCOLD = XC
        YCOLD = YC
   50 CONTINUE
C
   51 CALL NEWPEN(1)
      RETURN
      END ! DPLOTI



      SUBROUTINE LOCELL(XC,YC, IC,JC)
      INCLUDE 'STATE.INC'     
      INCLUDE 'MPLOT.INC'
      DIMENSION XT(5), YT(5)
C--------------------------------------------------
C     Finds cell IC,JC which contains point XC,YC
C--------------------------------------------------
C
      DO 10 JO=1, JJ-1
        IF(JSTAG(JO).GT.0) GO TO 10
        JP = JO+1
        DO 104 IO=1, II-1
          IP = IO+1
C
          XT(1) = X(IO,JO)
          XT(2) = X(IP,JO)
          XT(3) = X(IP,JP)
          XT(4) = X(IO,JP)
          XT(5) = X(IO,JO)
C
          YT(1) = Y(IO,JO)
          YT(2) = Y(IP,JO)
          YT(3) = Y(IP,JP)
          YT(4) = Y(IO,JP)
          YT(5) = Y(IO,JO)
C
C-------- integrate subtended angle around cell
          ANGLE = 0.0
          DO 1044 K=1, 4
            XB1 = XT(K)   - XC
            YB1 = YT(K)   - YC
            XB2 = XT(K+1) - XC
            YB2 = YT(K+1) - YC
            ANGLE = ANGLE + (XB1*YB2 - YB1*XB2)
     &                   / SQRT((XB1**2 + YB1**2)*(XB2**2 + YB2**2))
 1044     CONTINUE
C-------- angle = 0 if XC,YC is outside, angle = +/- 2 pi  if inside
          IF(ABS(ANGLE) .GT. 1.0) THEN
            IC = IO
            JC = JO
            RETURN
          ENDIF
 104    CONTINUE
 10   CONTINUE
C
      IC = 0
      JC = 0
C
      RETURN
      END ! LOCELL



      SUBROUTINE PIPLOT(IC,JC,XC,YC,XA,YA)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C-----------------------------------------------------------------
C     Plots velocity profile taken from flow solution.
C
C   IC,JC  cell containing point XC,YC
C   XC,YC  coordinates of point through which profile axis passes
C   XA,YA  profile axis unit vector
C-----------------------------------------------------------------
C             
      PARAMETER (KPRX=129)
      DIMENSION XQ(KPRX), YQ(KPRX), XM(KPRX), YM(KPRX)

c      dimension rp(kprx), qp(kprx), dm(kprx)
c      dimension HHP(2), HSP(2), UEP(2), THP(2)
c      DATA IPR / 0 /

c
c      common /prof/ nn$(isx),ue$(isx),uy$(isx),xd$(isx),yd$(isx),
c     &              xx$(129,isx),yy$(129,isx),
c     &              ui$(129,isx),ud$(129,isx),
c     &              vi$(129,isx),vd$(129,isx)
C
      XMOD(XTMP) = SFG * (XTMP - XOFFG)
      YMOD(YTMP) = SFG * (YTMP - YOFFG)
C
      K = 0
      KMIN = -12345
      KMAX =  12345
      DO 10 JO=1, JJ-1
        IF(JSTAG(JO) .GT. 0) GO TO 10
        JP = JO+1
C
        DO 110 IO=2, II-1
          IM = IO-1
          IP = IO+1
C
          X1 = 0.25*(X(IO,JO)+X(IO,JP)+X(IM,JP)+X(IM,JO))
          Y1 = 0.25*(Y(IO,JO)+Y(IO,JP)+Y(IM,JP)+Y(IM,JO))
          X2 = 0.25*(X(IP,JO)+X(IP,JP)+X(IO,JP)+X(IO,JO))
          Y2 = 0.25*(Y(IP,JO)+Y(IP,JP)+Y(IO,JP)+Y(IO,JO))
C
          CRSP1 = (X1-XC)*YA - (Y1-YC)*XA
          CRSP2 = (X2-XC)*YA - (Y2-YC)*XA
C
          IF(CRSP1*CRSP2 .LT. 0.0) GO TO 111
C
 110    CONTINUE
 111    CONTINUE
C
        F1 =  CRSP2/(CRSP2-CRSP1)
        F2 = -CRSP1/(CRSP2-CRSP1)
C
        Q1 = Q(IM,JO)
        Q2 = Q(IO,JO)
C
        SX1 = 0.5*(X(IO,JO)+X(IO,JP)-X(IM,JP)-X(IM,JO))
        SY1 = 0.5*(Y(IO,JO)+Y(IO,JP)-Y(IM,JP)-Y(IM,JO))
        SX2 = 0.5*(X(IP,JO)+X(IP,JP)-X(IO,JP)-X(IO,JO))
        SY2 = 0.5*(Y(IP,JO)+Y(IP,JP)-Y(IO,JP)-Y(IO,JO))
        S1 = SQRT(SX1**2 + SY1**2)
        S2 = SQRT(SX2**2 + SY2**2)
C
        QX = F1*Q1*SX1/S1 + F2*Q2*SX2/S2
        QY = F1*Q1*SY1/S1 + F2*Q2*SY2/S2
C
        K = K + 1
        XM(K) = F1*X1 + F2*X2
        YM(K) = F1*Y1 + F2*Y2
        XQ(K) = XM(K) + UWT*QX/QINF
        YQ(K) = YM(K) + UWT*QY/QINF
c
c        r1 = r(IM,JO)
c        r2 = r(IO,JO)
c        qp(k) = f1*q1 + f2*q2
c        rp(k) = f1*r1 + f2*r2
c        dm(k) = mfract(jo)
C
C------ if we're on upper-surface streamline and below profile point...
        IF(JSTAG(JO).LT.0 .AND. JO.LE.JC) THEN
          N = (IABS(JSTAG(JO))+1)/2
          IF(IO+INT(2.0*F2) .LE. ITEB(N) .AND.
     &       IO-INT(2.0*F1) .GE. ILEB(N)      ) KMIN = MAX(K,KMIN)
        ENDIF
C
C------ if we're on lower-surface streamline and above profile point...
        IF(JSTAG(JP).GT.0 .AND. JO.GE.JC) THEN
          N = (IABS(JSTAG(JP))+1)/2
          IF(IO+INT(2.0*F2) .LE. ITEB(N) .AND.
     &       IO-INT(2.0*F1) .GE. ILEB(N)      ) KMAX = MIN(K,KMAX)
        ENDIF
C
 10   CONTINUE
C
      KMIN = MAX(1,KMIN)
      KMAX = MIN(K,KMAX)
C
C---- plot axis
      CALL NEWPEN(1)
      CALL PLOT(XMOD(XM(KMIN)),YMOD(YM(KMIN)),3)
      CALL PLOT(XMOD(XM(KMAX)),YMOD(YM(KMAX)),2)
C
      CALL NEWPEN(3)
      KK = KMAX-KMIN+1
      K = KMIN
      CALL XYPLOT(KK,XQ(K),YQ(K),XOFFG,SFG,YOFFG,SFG,1,CH,0)
C
c      ds = 0.
c      th = 0.
c      ts = 0.
c      dd = 0.
c      re = rp(kmax)
c      qe = qp(kmax)
c      do k=kmin, kmax
c        ds = ds + (1.0 - rp(k)*qp(k)/(re*qe)    ) * dm(k)/(rp(k)*qp(k))
c        th = th + (1.0 -       qp(k)/    qe     ) * dm(k)/(re   *qe   )
c        ts = ts + (1.0 -      (qp(k)/    qe)**2 ) * dm(k)/(re   *qe   )
c        dd = dd + (1.0 - rp(k)      / re        ) * dm(k)/(rp(k)*qe   )
c      enddo
cc
c      IPR = IPR + 1 
c      THP(IPR) = TH
c      UEP(IPR) = QE
c      HHP(IPR) = DS/TH
c      HSP(IPR) = TS/TH
cC
c      IF(IPR.EQ.2) THEN
c        write(*,*) thp(1), uep(1), hhp(1), hsp(1)
c        write(*,*) thp(2), uep(2), hhp(2), hsp(2)
cc
c        HAVG = HHP(1)
c        PPM =-(LOG(THP(2)/THP(1)) + (HAVG+2.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG+1.0)
c        PPH = (LOG(HSP(2)/HSP(1)) - (HAVG-1.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG-1.0)
c        write(*,*) 'with H1  :  P =', ppm, pph
cc
c        HAVG = 0.5*(HHP(1) + HHP(2))
c        PPM =-(LOG(THP(2)/THP(1)) + (HAVG+2.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG+1.0)
c        PPH = (LOG(HSP(2)/HSP(1)) - (HAVG-1.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG-1.0)
c        write(*,*) 'with Havg:  P =', ppm, pph
cc
c        HAVG = HHP(2)
c        PPM =-(LOG(THP(2)/THP(1)) + (HAVG+2.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG+1.0)
c        PPH = (LOG(HSP(2)/HSP(1)) - (HAVG-1.0)*LOG(UEP(2)/UEP(1)))
c     &       *2.0/(HAVG-1.0)
c        write(*,*) 'with H2  :  P =', ppm, pph
c        
c        IPR = 0
c      ENDIF
c

      RETURN
      END ! PIPLOT
