
      SUBROUTINE ELLIP(IX,JX,II,JJ,JFIX,X,Y,XPOS,YPOS,R,RLIM,ITMAXS)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(IX,JX),Y(IX,JX),XPOS(IX,JX),YPOS(JX),R(IX,JX)
      DIMENSION JFIX(JX)
C-----------------------------------------------------------------
C     Elliptic grid smoother based on Thompson's method.
C
C     IX,JX     Grid dimensions
C     II,JJ     Grid size
C     JFIX(j)   If JFIX(j).ne.0 then streamline j is not changed
C     X(i,j)    Grid coordinates to be smoothed
C     Y(i,j)
C     XPOS(i,j) xsi  array for variable i spacing
C     YPOS(j)   eta  array for variable j spacing
C     R(i,j)    "density" for scaling d(eta) ~ 1/R
C     RLIM      limiter applied to R,  if RLIM=0, R=1 is used
C     ITMAXS    max number of SLOR passes
C                if ITMAXS < 0 ,  over-relaxation is NOT used
C-----------------------------------------------------------------
C
      PARAMETER (IDIM=501)
      DIMENSION C(IDIM),D(2,IDIM)
C
      IF(II.GT.IDIM) STOP 'ELLIP: Array overflow.  Increase IDIM.'
C
      ITMAX = IABS(ITMAXS)
C
      SLSQ = MAX( (X(II,JJ)-X(1, 1))**2 + (Y(II,JJ)-Y(1, 1))**2 ,
     &            (X(II, 1)-X(1,JJ))**2 + (Y(II, 1)-Y(1,JJ))**2   )
      SLEN = SQRT(SLSQ)
C
C---- convergence tolerance for each phase
      DSET1 = 0.02    * SLEN
      DSET2 = 0.001   * SLEN
      DSET3 = 0.00003 * SLEN
C
C---- over-relaxation parameter for each phase
      RLX1 = 1.30       !          DMAX > DSET1
      RLX2 = 1.50       !  DSET1 > DMAX > DSET2
      RLX3 = 1.60       !  DSET2 > DMAX > DSET3
CCC   STOP              !  DSET3 > DMAX
C
C---- no overrelaxation if ITMAXS is passed in negative
      IF(ITMAXS.LT.0) THEN
        RLX1 = 1.0
        RLX2 = 1.0
        RLX3 = 1.0
      ENDIF
C
C
      RLX = RLX1
C
C---- do SLOR sweeps
      DO 1 ITER = 1, ITMAX
C
        DMAX = 0.
        DO 5 JO=2, JJ-1
          JM = JO-1
          JP = JO+1
C
C-------- skip stagnation streamlines (adjacent to an airfoil element)
          IF (JFIX(JO).NE.0) GO TO 5
C
          IO = 1
          C(IO) = 0.
          D(1,IO) = 0.
          D(2,IO) = 0.
C
          DO 6 IO=2, II-1
            IM = IO-1
            IP = IO+1
C
C---------- set 3x3 stencil values
            XMM = X(IM,JM)
            XOM = X(IO,JM)
            XPM = X(IP,JM)
            XMO = X(IM,JO)
            XOO = X(IO,JO)
            XPO = X(IP,JO)
            XMP = X(IM,JP)
            XOP = X(IO,JP)
            XPP = X(IP,JP)
            YMM = Y(IM,JM)
            YOM = Y(IO,JM)
            YPM = Y(IP,JM)
            YMO = Y(IM,JO)
            YOO = Y(IO,JO)
            YPO = Y(IP,JO)
            YMP = Y(IM,JP)
            YOP = Y(IO,JP)
            YPP = Y(IP,JP)
C
C---------- local d(eta) is scaled with 1/rho to allow for streamtube dilation
            IF(RLIM .EQ. 0.0) THEN
             RAVO = 1.0
             RAVM = 1.0
            ELSE
             RAVO = MAX( 0.5*(R(IM,JO)+R(IO,JO)) , RLIM )
             RAVM = MAX( 0.5*(R(IM,JM)+R(IO,JM)) , RLIM )
            ENDIF
C
C---------- set d(xsi)
            DXIM =  XPOS(IO,JO)-XPOS(IM,JO)
            DXIP =  XPOS(IP,JO)-XPOS(IO,JO)
            DXIAV = 0.5*(DXIM+DXIP)
C
C---------- set d(eta)
            DETM = (YPOS(JO)-YPOS(JM))/RAVM
            DETP = (YPOS(JP)-YPOS(JO))/RAVO
            DETAV = 0.5*(DETM+DETP)
C
            DXDET = ( XOP - XOM ) / DETAV
            DYDET = ( YOP - YOM ) / DETAV
            DXDXI = ( XPO - XMO ) / DXIAV
            DYDXI = ( YPO - YMO ) / DXIAV
C
C---------- coefficients for difference operator
            ALF = DXDET**2 + DYDET**2
            BET = DXDET*DXDXI + DYDET*DYDXI
            GAM = DXDXI**2 + DYDXI**2
C
            CXIM = 1.0 / (DXIM*DXIAV)
            CXIP = 1.0 / (DXIP*DXIAV)
            CETM = 1.0 / (DETM*DETAV)
            CETP = 1.0 / (DETP*DETAV)
C
            B =      -ALF*CXIM
            A = ALF*(CXIM+CXIP) + GAM*(CETM+CETP)
            C(IO) =  -ALF*CXIP
            IF(IO.EQ.2) B = 0.0
C
C---------- residual for X equation
            D(1,IO) = ALF*((XMO-XOO)*CXIM + (XPO-XOO)*CXIP)
     &              - 2.0*BET*(XPP-XMP-XPM+XMM) / (4.0*DXIAV*DETAV)
     &              + GAM*((XOM-XOO)*CETM + (XOP-XOO)*CETP)
C
C---------- residual for Y equation
            D(2,IO) = ALF*((YMO-YOO)*CXIM + (YPO-YOO)*CXIP)
     &              - 2.0*BET*(YPP-YMP-YPM+YMM) / (4.0*DXIAV*DETAV)
     &              + GAM*((YOM-YOO)*CETM + (YOP-YOO)*CETP)
C
C---------- eliminate lower diagonal, and normalize row
            AINV = 1.0/(A - B*C(IM))
            C(IO) = C(IO) * AINV
            D(1,IO) = ( D(1,IO) - B*D(1,IM) ) * AINV
            D(2,IO) = ( D(2,IO) - B*D(2,IM) ) * AINV
C
   6      CONTINUE
C
C-------- back substitute
          D(1,II) = 0.
          D(2,II) = 0.
          DO 8 IBACK=2, II-1
            IO = II-IBACK+1
            IP = IO+1
            D( 1,IO) = D( 1,IO) - C(IO)*D(1,IP)
            D( 2,IO) = D( 2,IO) - C(IO)*D(2,IP)
            X(IO,JO) = X(IO,JO) + RLX*D(1,IO)
            Y(IO,JO) = Y(IO,JO) + RLX*D(2,IO)
            AD1 = ABS(D(1,IO))
            AD2 = ABS(D(2,IO))
            DMAX = MAX(DMAX,AD1,AD2)
   8      CONTINUE
C
   5    CONTINUE
C
        IF(ITMAXS.GT.0) WRITE(*,*) 'Dmax = ', DMAX, RLX
C
C------ set new over-relaxation factor or return
        RLX = RLX1
        IF(DMAX.LT.DSET1) RLX = RLX2
        IF(DMAX.LT.DSET2) RLX = RLX3
        IF(DMAX.LT.DSET3) RETURN
C
   1  CONTINUE
C
      RETURN
      END ! ELLIP
