C
      SUBROUTINE SOLVE
C----------------------------------------------
C     MSES Primary matrix solver
C
C     Uncomment "CPU" code blocks to get 
C     printout of CPU consumption breakdown 
C     for the various operations.
C
C----------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- local work arrays
      DIMENSION A(KX,KX),B(KX,KX),
     &          C(KX,JX,IX),Z(KX,KX),V(KX,KX)
C
      PARAMETER (KVX = 6*NBX)
      DIMENSION VMAT(KVX,KVX)
C
C---- if T, then "dumb" LU row decomposition used (no exploitation of zeros)
      LOGICAL LUDUMB, SUPERP
      DATA LUDUMB / .FALSE. /
ccc      DATA LUDUMB / .TRUE. /
C
C---- first assume all righthand sides will be solved for
      NRHSI = NRHS
C
C---- don't solve for mode righthand sides except on last iteration
      IF(ITER.LT.IABS(NITER)) THEN
       IF(LMINV) THEN
        NRHSI = NRHS - NPOSN
       ELSE
        NRHSI = NRHS - NPOSN - NMODN
       ENDIF
      ENDIF
C
C---- however, solve for all righthand sides if there are any prescribed modes
      DO N=1, NMODN
        K = KMODN(N)
        IF(ABS(DMSPN(K)) .GT. 1.0E-8) NRHSI = NRHS
      ENDDO
      DO N=1, NPOSN
        K = KPOSN(N)
        IF(ABS(DPSPN(K)) .GT. 1.0E-8) NRHSI = NRHS
      ENDDO
C
C---- block size excluding BL equations, variables
      NBJ = 2*JJ - 1
C
C---- overall block size
      NBK = 2*JJ - 1
      IF(LVISC) NBK = 2*JJ - 1 + 6*NBL
C
C
C-------------------
CPU
c      tfill = 0.0
c      telim = 0.0
c      tfact = 0.0
c      tback = 0.0
C-------------------
C
CCC** Forward sweep: Elimination of lower block diagonals (B's and Z's).
      DO 1000 I=1, II
C
        IM = I-1
        IL = I-2
        IK = I-3
C
C------ clear out work matrices
        DO K=1, NBK
          DO L=1, NBK
            V(K,L) = 0.
            Z(K,L) = 0.
            B(K,L) = 0.
            A(K,L) = 0.
          ENDDO
          DO L=1, JJ
            C(K,L,I) = 0.
          ENDDO
        ENDDO
C
C
C-------------------
CPU
c        t0 = second()
C-------------------
C
CCC**** FIRST, fill 'er up
C
C----- drho entries for N-momentum equations ...
C
C      ... Element streamlines
        DO 10 N = 1, NBL
          J1 = JS1(N)
          J2 = JS2(N)
          K1 = JJ + J1
          K2 = JJ + J2-1
          V(J1,K2) = V4(J1,I)
          V(J1,K1) = V5(J1,I)
          V(J2,K2) = V4(J2,I)
          V(J2,K1) = V5(J2,I)
          Z(J1,K2) = Z4(J1,I)
          Z(J1,K1) = Z5(J1,I)
          Z(J2,K2) = Z4(J2,I)
          Z(J2,K1) = Z5(J2,I)
          B(J1,K2) = B4(J1,I)
          B(J1,K1) = B5(J1,I)
          B(J2,K2) = B4(J2,I)
          B(J2,K1) = B5(J2,I)
          A(J1,K2) = A4(J1,I)
          A(J1,K1) = A5(J1,I)
          A(J2,K2) = A4(J2,I)
          A(J2,K1) = A5(J2,I)
   10   CONTINUE
C
C      ... Outermost streamlines
        J = 1
          V(J,JJ+J)   = V5(J,I)
          Z(J,JJ+J)   = Z5(J,I)
          B(J,JJ+J)   = B5(J,I)
          A(J,JJ+J)   = A5(J,I)
C
        J = JJ
          V(J,JJ+J-1) = V4(J,I)
          Z(J,JJ+J-1) = Z4(J,I)
          B(J,JJ+J-1) = B4(J,I)
          A(J,JJ+J-1) = A4(J,I)
C
C      ... Interior streamlines
        DO 12 J=2, JJ-1
          IF (JSTAG(J).NE.0) GO TO 12
          V(J,JJ+J-1) = V4(J,I)
          V(J,JJ+J)   = V5(J,I)
          Z(J,JJ+J-1) = Z4(J,I)
          Z(J,JJ+J)   = Z5(J,I)
          B(J,JJ+J-1) = B4(J,I)
          B(J,JJ+J)   = B5(J,I)
          A(J,JJ+J-1) = A4(J,I)
          A(J,JJ+J)   = A5(J,I)
   12   CONTINUE
C
C------ drho entries for S-momentum equations
        DO 14 J=1, JJ-1
          K = JJ+J
          V(K,K) = V8(J,I)
          Z(K,K) = Z8(J,I)
          B(K,K) = B8(J,I)
          A(K,K) = A8(J,I)
   14   CONTINUE
C
C
C----- dn entries for N-momentum equations...
C
C      ... Element streamlines
        DO 20 N = 1, NBL
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
          V(J1,J1)   = V2(J1,I)
          V(J1,J1+1) = V3(J1,I)
          V(J1,J2-1) = V1(J1,I)
          V(J1,J2)   = VT(I1,I)
          V(J2,J1+1) = V3(J2,I)
          V(J2,J2-1) = V1(J2,I)
          V(J2,J2)   = V2(J2,I)
          V(J2,J1)   = VT(I2,I)
          Z(J1,J1)   = Z2(J1,I)
          Z(J1,J1+1) = Z3(J1,I)
          Z(J1,J2-1) = Z1(J1,I)
          Z(J1,J2)   = ZT(I1,I)
          Z(J2,J1+1) = Z3(J2,I)
          Z(J2,J2-1) = Z1(J2,I)
          Z(J2,J2)   = Z2(J2,I)
          Z(J2,J1)   = ZT(I2,I)
          B(J1,J1)   = B2(J1,I)
          B(J1,J1+1) = B3(J1,I)
          B(J1,J2-1) = B1(J1,I)
          B(J1,J2)   = BT(I1,I)
          B(J2,J1+1) = B3(J2,I)
          B(J2,J2-1) = B1(J2,I)
          B(J2,J2)   = B2(J2,I)
          B(J2,J1)   = BT(I2,I)
          A(J1,J1)   = A2(J1,I)
          A(J1,J1+1) = A3(J1,I)
          A(J1,J2-1) = A1(J1,I)
          A(J1,J2)   = AT(I1,I)
          A(J2,J1+1) = A3(J2,I)
          A(J2,J2-1) = A1(J2,I)
          A(J2,J2)   = A2(J2,I)
          A(J2,J1)   = AT(I2,I)
          C(J1,J1  ,I) = C2(J1,I)
          C(J1,J1+1,I) = C3(J1,I)
          C(J1,J2-1,I) = C1(J1,I)
          C(J1,J2  ,I) = CT(I1,I)
          C(J2,J1+1,I) = C3(J2,I)
          C(J2,J2-1,I) = C1(J2,I)
          C(J2,J2  ,I) = C2(J2,I)
          C(J2,J1  ,I) = CT(I2,I)
c          if(i.ge.100) then
c           write(*,*) i,j1,a(j1,j2-1),a(j1,j2),a(j1,j1),a(j1,j1+1)
c           write(*,*) i,j2,a(j2,j2-1),a(j2,j2),a(j2,j1),a(j2,j1+1)
c          endif
   20   CONTINUE
C
C      ... Outermost streamlines
        J = 1
          V(J,J  ) = V2(J,I)
          V(J,J+1) = V3(J,I)
          Z(J,J  ) = Z2(J,I)
          Z(J,J+1) = Z3(J,I)
          B(J,J  ) = B2(J,I)
          B(J,J+1) = B3(J,I)
          A(J,J  ) = A2(J,I)
          A(J,J+1) = A3(J,I)
          C(J,J  ,I) = C2(J,I)
          C(J,J+1,I) = C3(J,I)
C
        J = JJ
          V(J,J-1) = V1(J,I)
          V(J,J  ) = V2(J,I)
          Z(J,J-1) = Z1(J,I)
          Z(J,J  ) = Z2(J,I)
          B(J,J-1) = B1(J,I)
          B(J,J  ) = B2(J,I)
          A(J,J-1) = A1(J,I)
          A(J,J  ) = A2(J,I)
          C(J,J-1,I) = C1(J,I)
          C(J,J  ,I) = C2(J,I)
C
C      ... Interior streamlines
        DO 22 J=2, JJ-1
          IF (JSTAG(J).NE.0) GO TO 22
          V(J,J-1) = V1(J,I)
          V(J,J  ) = V2(J,I)
          V(J,J+1) = V3(J,I)
          Z(J,J-1) = Z1(J,I)
          Z(J,J  ) = Z2(J,I)
          Z(J,J+1) = Z3(J,I)
          B(J,J-1) = B1(J,I)
          B(J,J  ) = B2(J,I)
          B(J,J+1) = B3(J,I)
          A(J,J-1) = A1(J,I)
          A(J,J  ) = A2(J,I)
          A(J,J+1) = A3(J,I)
          C(J,J-1,I) = C1(J,I)
          C(J,J  ,I) = C2(J,I)
          C(J,J+1,I) = C3(J,I)
   22   CONTINUE
C
C------ dn entries for S-momentum equations
        DO 24 J=1, JJ-1
          K = J+JJ
          V(K,J  ) = V6(J,I)
          V(K,J+1) = V7(J,I)
          Z(K,J  ) = Z6(J,I)
          Z(K,J+1) = Z7(J,I)
          B(K,J  ) = B6(J,I)
          B(K,J+1) = B7(J,I)
          A(K,J  ) = A6(J,I)
          A(K,J+1) = A7(J,I)
          C(K,J  ,I) = C6(J,I)
          C(K,J+1,I) = C7(J,I)
   24   CONTINUE
C
C
	IF(LVISC) THEN
C
C------ Fill dn entries for BL equations
C
        DO 40 N = 1, NBL
C
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
          JS = J1-1
          JP = J2-2
          KB = 2*JJ - 1 + 6*(N-1)
C
          DO 30 L=1, 2
            L1 = L
            L2 = L+2
C
            Z(KB+1,JS+L) = ZNC(I1,L1,I)
            Z(KB+2,JS+L) = ZNT(I1,L1,I)
            Z(KB+3,JS+L) = ZNH(I1,L1,I)
            Z(KB+4,JS+L) = ZNC(I2,L1,I)
            Z(KB+5,JS+L) = ZNT(I2,L1,I)
            Z(KB+6,JS+L) = ZNH(I2,L1,I)
            Z(KB+1,JP+L) = ZNC(I1,L2,I)
            Z(KB+2,JP+L) = ZNT(I1,L2,I)
            Z(KB+3,JP+L) = ZNH(I1,L2,I)
            Z(KB+4,JP+L) = ZNC(I2,L2,I)
            Z(KB+5,JP+L) = ZNT(I2,L2,I)
            Z(KB+6,JP+L) = ZNH(I2,L2,I)
C
            B(KB+1,JS+L) = BNC(I1,L1,I)
            B(KB+2,JS+L) = BNT(I1,L1,I)
            B(KB+3,JS+L) = BNH(I1,L1,I)
            B(KB+4,JS+L) = BNC(I2,L1,I)
            B(KB+5,JS+L) = BNT(I2,L1,I)
            B(KB+6,JS+L) = BNH(I2,L1,I)
            B(KB+1,JP+L) = BNC(I1,L2,I)
            B(KB+2,JP+L) = BNT(I1,L2,I)
            B(KB+3,JP+L) = BNH(I1,L2,I)
            B(KB+4,JP+L) = BNC(I2,L2,I)
            B(KB+5,JP+L) = BNT(I2,L2,I)
            B(KB+6,JP+L) = BNH(I2,L2,I)
C
            A(KB+1,JS+L) = ANC(I1,L1,I)
            A(KB+2,JS+L) = ANT(I1,L1,I)
            A(KB+3,JS+L) = ANH(I1,L1,I)
            A(KB+4,JS+L) = ANC(I2,L1,I)
            A(KB+5,JS+L) = ANT(I2,L1,I)
            A(KB+6,JS+L) = ANH(I2,L1,I)
            A(KB+1,JP+L) = ANC(I1,L2,I)
            A(KB+2,JP+L) = ANT(I1,L2,I)
            A(KB+3,JP+L) = ANH(I1,L2,I)
            A(KB+4,JP+L) = ANC(I2,L2,I)
            A(KB+5,JP+L) = ANT(I2,L2,I)
            A(KB+6,JP+L) = ANH(I2,L2,I)
C
            C(KB+1,JS+L,I) = CNC(I1,L1,I)
            C(KB+2,JS+L,I) = CNT(I1,L1,I)
            C(KB+3,JS+L,I) = CNH(I1,L1,I)
            C(KB+4,JS+L,I) = CNC(I2,L1,I)
            C(KB+5,JS+L,I) = CNT(I2,L1,I)
            C(KB+6,JS+L,I) = CNH(I2,L1,I)
            C(KB+1,JP+L,I) = CNC(I1,L2,I)
            C(KB+2,JP+L,I) = CNT(I1,L2,I)
            C(KB+3,JP+L,I) = CNH(I1,L2,I)
            C(KB+4,JP+L,I) = CNC(I2,L2,I)
            C(KB+5,JP+L,I) = CNT(I2,L2,I)
            C(KB+6,JP+L,I) = CNH(I2,L2,I)
C
   30     CONTINUE
C
C-------- drho entries for BL equations
          DO 31 L=1, 2
            J = JJ + J2+1 - 2*(L-1)
            Z(KB+1,J) = ZRC(I1,L,I)
            Z(KB+2,J) = ZRT(I1,L,I)
            Z(KB+3,J) = ZRH(I1,L,I)
            Z(KB+4,J) = ZRC(I2,L,I)
            Z(KB+5,J) = ZRT(I2,L,I)
            Z(KB+6,J) = ZRH(I2,L,I)
            B(KB+1,J) = BRC(I1,L,I)
            B(KB+2,J) = BRT(I1,L,I)
            B(KB+3,J) = BRH(I1,L,I)
            B(KB+4,J) = BRC(I2,L,I)
            B(KB+5,J) = BRT(I2,L,I)
            B(KB+6,J) = BRH(I2,L,I)
            A(KB+1,J) = ARC(I1,L,I)
            A(KB+2,J) = ART(I1,L,I)
            A(KB+3,J) = ARH(I1,L,I)
            A(KB+4,J) = ARC(I2,L,I)
            A(KB+5,J) = ART(I2,L,I)
            A(KB+6,J) = ARH(I2,L,I)
   31     CONTINUE
C
C-------- dCtau, dThet, dDstr  entries for BL equations
          DO 32 L=1, 6
            B(KB+1,KB+L) = BVC(I1,L,I)
            B(KB+2,KB+L) = BVT(I1,L,I)
            B(KB+3,KB+L) = BVH(I1,L,I)
            B(KB+4,KB+L) = BVC(I2,L,I)
            B(KB+5,KB+L) = BVT(I2,L,I)
            B(KB+6,KB+L) = BVH(I2,L,I)
            A(KB+1,KB+L) = AVC(I1,L,I)
            A(KB+2,KB+L) = AVT(I1,L,I)
            A(KB+3,KB+L) = AVH(I1,L,I)
            A(KB+4,KB+L) = AVC(I2,L,I)
            A(KB+5,KB+L) = AVT(I2,L,I)
            A(KB+6,KB+L) = AVH(I2,L,I)
   32     CONTINUE
C
C-------- dCtau, dThet, dDstr  entries for Euler-BL coupling conditions
          DO 38 L=1, 6
            LL = KB+L
            B(J1,LL) = BI(I1,L,I)
            B(J2,LL) = BI(I2,L,I)
            A(J1,LL) = AI(I1,L,I)
            A(J2,LL) = AI(I2,L,I)
   38     CONTINUE
C
   40   CONTINUE
C
	ENDIF
C
cc      IF(I.le.2) THEN
cc       LU = 6
cc       CALL SHOBLK(C(1,1,I),KX,NBK,JJ,LU)
cc       CALL SHOBLK(A,KX,NBK,NBK,LU)
cc       CALL SHOBLK(B,KX,NBK,NBK,LU)
cc       CALL SHOBLK(Z,KX,NBK,NBK,LU)
cc       CALL SHOBLK(V,KX,NBK,NBK,LU)
cc      ENDIF
C
C-------------------
CPU
c        t1 = second()
C-------------------
C
C****** Now, the matrix solution part (for this I index)
C
C------ Eliminate V block 3 rows below diagonal, modifying Z block and RHSs
        IF(I.GE.4) THEN
        DO 56 K=1, NBK
          DO 54 J=1, NBJ
            VTMP = V(K,J)
            IF(VTMP.EQ.0.0) GO TO 54
C
             DO 50 L=1, JJ
               Z(K,L) = Z(K,L) - VTMP*C(J,L,IK)
   50        CONTINUE
C
             DO 52 L=1, NRHSI
               DR(K,L,I) = DR(K,L,I) - VTMP*DR(J,L,IK)
   52        CONTINUE
C
   54     CONTINUE
   56   CONTINUE
        ENDIF
C
C------ Eliminate Z block 2 rows below diagonal, modifying B block and RHSs
        IF(I.GE.3) THEN
        DO 66 K=1, NBK
          DO 64 J=1, NBJ
            ZTMP = Z(K,J)
            IF(ZTMP.EQ.0.0) GO TO 64
C
             DO 60 L=1, JJ
               B(K,L) = B(K,L) - ZTMP*C(J,L,IL)
   60        CONTINUE
C
             DO 62 L=1, NRHSI
               DR(K,L,I) = DR(K,L,I) - ZTMP*DR(J,L,IL)
   62        CONTINUE
C
   64     CONTINUE
   66   CONTINUE
        ENDIF
C
C------ Eliminate B block 1 row below diagonal, modifying A block and RHSs
        IF(I.GE.2) THEN
        DO 76 K=1, NBK
          DO 74 J=1, NBK
            BTMP = B(K,J)
            IF(BTMP.EQ.0.0) GO TO 74
C
             DO 70 L=1, JJ
               A(K,L) = A(K,L) - BTMP*C(J,L,IM)
   70        CONTINUE
C
             DO 72 L=1, NRHSI
               DR(K,L,I) = DR(K,L,I) - BTMP*DR(J,L,IM)
   72        CONTINUE
   74     CONTINUE
   76   CONTINUE
        ENDIF
C
C-------------------
CPU
c        t2 = second()
C-------------------
C
        AKKMAX = -HINF
        DO NPIV = JJ+1, NBJ
          AKKMAX = MAX( AKKMAX , A(NPIV,NPIV) )
        ENDDO
        SUPERP = AKKMAX .GT. -0.004*HINF
C
        IF(LUDUMB.OR.SUPERP) THEN
C
C========================================================================
C------ "Dumb" block-processing section
C       Assumes diagonal block A matrix is full
C
C------ LU-decompose modified diagonal A block
        CALL LUDCMP(KX,NBK,A)
C                                                                         -1
C------ back-substitute upper C blocks and RHSs (effectively multiply by A  )
        DO L = 1, JJ
          CALL BAKSUB(KX,NBK,A,C(1,L,I))
        ENDDO
C
        DO L = 1, NRHSI
          CALL BAKSUB(KX,NBK,A,DR(1,L,I))
        ENDDO
C
        ELSE
C
C========================================================================
C------ Custom block-processing section
C       Takes advantage of assumed zeros and sparseness in A matrix
C
C    Caution: Assumptions may be wrong if big matrix structure changes
C             in the future.  May also be prone to pivot-growth problems.
C
C                 dn     drho   dV
C    1 ...    |********|..     |   |
C             |********| ..    | . |
C       N-mom |********|  ..   |  .|
C             |********|   ..  |   |          ***
C   JJ ...    |********|    .. |   |          ***  =  full
C             +--------+-------+---+          ***
C             |********|\      |   |
C       S-mom |********|  \    |   |
C             |********|    \  |   |          \    = diagonal only
C  NBJ ...    |********|      \|   |
C             +--------+-------+---+
C             |********| .     |***|          .
C       BL eq |********|  .    |***|           .   = sparse
C  NBK ...    |********|   .   |***|
C
C
ccc       CALL SHOBLK(A,KX,NBK,NBK,6)
C
C------ eliminate all drho entries above/below S-momentum diagonal
        DO NPIV = NBJ, JJ+1, -1
C
C-------- normalize pivot row
          PIVOT = 1.0 / A(NPIV,NPIV)
          DO L = 1, JJ
            A(NPIV,L) = A(NPIV,L)*PIVOT
          ENDDO
          DO L = 1, JJ
            C(NPIV,L,I) = C(NPIV,L,I)*PIVOT
          ENDDO
          DO L = 1, NRHSI
            DR(NPIV,L,I) = DR(NPIV,L,I)*PIVOT
          ENDDO
C
C-------- eliminate drho entries in BL equations
          DO 80 K = NBK, NBJ+1, -1
            ATMP = A(K,NPIV)
            IF(ATMP.EQ.0.0) GO TO 80
            DO L=1, JJ
              A(K,L) = A(K,L) - ATMP*A(NPIV,L)
            ENDDO
            DO L=1, JJ
              C(K,L,I) = C(K,L,I) - ATMP*C(NPIV,L,I)
            ENDDO
            DO L=1, NRHSI
              DR(K,L,I) = DR(K,L,I) - ATMP*DR(NPIV,L,I)
            ENDDO
 80       CONTINUE
C
C-------- eliminate drho entries in N-momentum equations
          DO 82 K = JJ, 1, -1
            ATMP = A(K,NPIV)
            IF(ATMP.EQ.0.0) GO TO 82
            DO L=1, JJ
              A(K,L) = A(K,L) - ATMP*A(NPIV,L)
            ENDDO
            DO L=1, JJ
              C(K,L,I) = C(K,L,I) - ATMP*C(NPIV,L,I)
            ENDDO
            DO L=1, NRHSI
              DR(K,L,I) = DR(K,L,I) - ATMP*DR(NPIV,L,I)
            ENDDO
 82       CONTINUE
        ENDDO
C
C------ factor N-momentum equation diagonal block 1..JJ  (full)
        CALL LUDCMP(KX,JJ,A)
C
C------ multiply N-equation row set by inverse of the diagonal block
        DO L = NBJ+1, NBK
          CALL BAKSUB(KX,JJ,A,A(1,L))
        ENDDO
C
        DO L = 1, JJ
          CALL BAKSUB(KX,JJ,A,C(1,L,I))
        ENDDO
C
        DO L = 1, NRHSI
          CALL BAKSUB(KX,JJ,A,DR(1,L,I))
        ENDDO
C
C------ eliminate dn entries for S-momentum and BL equation rows
        DO NPIV = 1, JJ
          DO 84 K = JJ+1, NBK
            ATMP = A(K,NPIV)
            IF(ATMP.EQ.0.0) GO TO 84
C
            DO L=NBJ+1, NBK
              A(K,L) = A(K,L) - ATMP*A(NPIV,L)
            ENDDO
            DO L=1, JJ
              C(K,L,I) = C(K,L,I) - ATMP*C(NPIV,L,I)
            ENDDO
            DO L=1, NRHSI
              DR(K,L,I) = DR(K,L,I) - ATMP*DR(NPIV,L,I)
            ENDDO
 84       CONTINUE
        ENDDO
C
        IF(LVISC) THEN
C     
C-------- put BL equation diagonal block into work array for LU decomposition
          DO K = NBJ+1, NBK
            KV = K - NBJ
            DO L = NBJ+1, NBK
              LV = L - NBJ
              VMAT(KV,LV) = A(K,L)
            ENDDO
          ENDDO
C
          NNV = NBK - NBJ
          CALL LUDCMP(KVX,NNV,VMAT)
C
          DO L = 1, JJ
            CALL BAKSUB(KVX,NNV,VMAT,C(NBJ+1,L,I))
          ENDDO
C
          DO L = 1, NRHSI
            CALL BAKSUB(KVX,NNV,VMAT,DR(NBJ+1,L,I))
          ENDDO
C
C-------- eliminate dVisc entries in N- and S-momentum equations
          DO NPIV = NBJ+1, NBK
            DO 86 K = 1, NBJ
              ATMP = A(K,NPIV)
              IF(ATMP.EQ.0.0) GO TO 86
C
              DO L=1, JJ
                C(K,L,I) = C(K,L,I) - ATMP*C(NPIV,L,I)
              ENDDO
              DO L=1, NRHSI
                DR(K,L,I) = DR(K,L,I) - ATMP*DR(NPIV,L,I)
              ENDDO
 86         CONTINUE
          ENDDO
C
        ENDIF
C
C---- end of custom block-processing section
C========================================================================
      ENDIF
C
C-------------------
CPU
c        t3 = second()
C-------------------
C
C-------------------
CPU
c      tfill = tfill + t1 - t0
c      telim = telim + t2 - t1
c      tfact = tfact + t3 - t2
C-------------------
C
 1000 CONTINUE
C
C-------------------
CPU
c        t4 = second()
C-------------------
C
C**** Backward sweep: Elimination of upper block diagonal (C's).
      DO 1200 I = II-1, 1, -1
        IP = I+1
        DO 1030 N = 1, NBK
          DO 1020 L = 1, NRHSI
            SUM = 0.
            DO 1010 K = 1, JJ
              SUM = SUM + C(N,K,I)*DR(K,L,IP)
 1010       CONTINUE
            DR(N,L,I) = DR(N,L,I) - SUM
 1020     CONTINUE
 1030   CONTINUE
 1200 CONTINUE
C
C-------------------
CPU
c      t5 = second()
c      tback = t5 - t4
cC
c      write(*,5200) tfill, telim, tfact, tback
c 5200 FORMAT(/'  Workarray block fill  :', F11.6,
c     &       /'  Lower     block elim. :', F11.6,
c     &       /'  Block line invert     :', F11.6,
c     &       /'  Upper     block elim. :', F11.6 )
C-------------------
C
      RETURN
      END ! FSOLVE


      SUBROUTINE SHOBLK(A,NDIM,NI,NJ,LU)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION A(NDIM,NDIM)
ccc      CHARACTER*2 LINE(132)
      CHARACTER*1 LINE(132)
C
ccc      WRITE(LU,1000) ('1234567890',K=1, 8)
ccc 1000 FORMAT(/1X,3X, 12A20)
C
      WRITE(LU,1000) ('1234567890',K=1, 12)
 1000 FORMAT(/1X,3X, 12A10)
C
      DO 10 I=1, NI
        DO 110 J=1, NJ
ccc          LINE(J) = '  '
          LINE(J) = ' '
ccc          IF(A(I,J) .NE. 0.0) LINE(J) = '* '
          IF(A(I,J) .NE. 0.0) LINE(J) = '*'
          IF(A(I,J) .EQ. 1.0) LINE(J) = '1'
 110    CONTINUE
        WRITE(LU,1100) I, (LINE(J),J=1, NJ)
ccc 1100   FORMAT(1X,I2,1X,120A2))
 1100   FORMAT(1X,I2,1X,120A1)
 10   CONTINUE
C
      WRITE(LU,1000) ('1234567890',K=1, 12)
      RETURN
      END
