

      SUBROUTINE GAPSET(N)
      INCLUDE 'STATE.INC'
C--------------------------------------------------
C     Sets dead-air region width array behind each
C     element TE for blunt TE treatment in MSES.
C--------------------------------------------------
C
C---- trailing edge dead-air length to TE thickness ratio
      TELRAT = 2.50
C
C---- set TE thickness component ANTE perpendicular to TE bisector
      DXTE = XB(1,N) - XB(IIB(N),N)
      DYTE = YB(1,N) - YB(IIB(N),N)
      XSB  = XPB(1,N) - XPB(IIB(N),N)
      YSB  = YPB(1,N) - YPB(IIB(N),N)
      ANTE = (DXTE*YSB - DYTE*XSB) / SQRT(XSB**2 + YSB**2)
C
      IF(ANTE .LT. 0.0) THEN
        WRITE(*,*) 'GAPSET: Negative TE base thickness: ', ANTE
        ANTE = 0.0
      ENDIF
C
C---- set sin(TE angle)
      CROSP = ( XPB(1,N)*YPB(IIB(N),N)
     &        - YPB(1,N)*XPB(IIB(N),N) )
     &      / SQRT(  (XPB(1     ,N)**2 + YPB(1     ,N)**2)
     &              *(XPB(IIB(N),N)**2 + YPB(IIB(N),N)**2) )
C
C---- set d(WGAP)/ds
      DWDXTE = CROSP / SQRT(1.0 - CROSP**2)
C
C---- limit cubic to avoid absurd TE gap widths
      DWDXTE = MAX(DWDXTE,-3.0/TELRAT)
      DWDXTE = MIN(DWDXTE, 3.0/TELRAT)
C
      AA =  3.0 + TELRAT*DWDXTE
      BB = -2.0 - TELRAT*DWDXTE
C
      DO 35 IW=1, NOUT(N)
        STRAT = ANTE - SWAK(N)*SGOUT(IW,N) / TELRAT
C
        I = II - NOUT(N) + IW
        WGAP(I,N) = 0.0
        IF(STRAT .GT. 0.0) THEN
          ZN = STRAT/ANTE
          WGAP(I,N) = ANTE * (AA + BB*ZN)*ZN**2
        ENDIF
   35 CONTINUE
C
      RETURN
      END ! GAPSET
