
      SUBROUTINE SOLVIT(NSIZ,NN,Z,R)
C............................................
C     General pivoting Gaussian elimination
C     solver for NNxNN system
C............................................
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION Z(NSIZ,NSIZ), R(NSIZ)
C
      DO 1 NP=1, NN-1
        NP1 = NP+1
C
C------ find max pivot index NX
        NX = NP
        DO 11 N=NP1, NN
          IF(ABS(Z(N,NP))-ABS(Z(NX,NP))) 11,11,111
  111      NX = N
   11   CONTINUE
C
        PIVOT = 1.0/Z(NX,NP)
C
C------ switch pivots
        Z(NX,NP) = Z(NP,NP)
C
C------ switch rows & normalize pivot row
        DO 12 L=NP1, NN
          TEMP = Z(NX,L)*PIVOT
          Z(NX,L) = Z(NP,L)
          Z(NP,L) = TEMP
   12   CONTINUE
C
        TEMP = R(NX)*PIVOT
        R(NX) = R(NP)
        R(NP) = TEMP
C
C------ forward eliminate everything
        DO 15 K=NP1, NN
          ZTMP = Z(K,NP)
          DO 151 L=NP1, NN
            Z(K,L) = Z(K,L) - ZTMP*Z(NP,L)
  151     CONTINUE
          R(K) = R(K) - ZTMP*R(NP)
   15   CONTINUE
C
    1 CONTINUE
C
C---- solve for last row
      R(NN) = R(NN)/Z(NN,NN)
C
C---- back substitute everything
      DO 2 NP=NN-1, 1, -1
        NP1 = NP+1
        DO 21 L=NP1, NN
          R(NP) = R(NP) - Z(NP,L)*R(L)
   21   CONTINUE
    2 CONTINUE
C
      RETURN
      END ! SOLVIT



      SUBROUTINE LUDCMP(NSIZ,N,A)
C     *******************************************************
C     *                                                     *
C     *   Factors a full NxN matrix A into an LU form.      *
C     *   Subr. BAKSUB can back-substitute it with some RHS.*
C     *   Assumes matrix is non-singular...                 *
C     *    ...if it isn't, a divide by zero will result.    *
C     *                                                     *
C     *   A is the matrix...                                *
C     *     ...replaced with its LU factors.                *
C     *                                                     *
C     *   Stolen from Numerical Recipes, removed pivoting.  *
C     *                                                     *
C     *                              Mark Drela  1988       *
C     *******************************************************
C
      DIMENSION A(NSIZ,NSIZ)
C
      DO 19 J=1, N
        DO 14 I=1, J-1
          SUM = A(I,J)
          DO 13 K=1, I-1
            SUM = SUM - A(I,K)*A(K,J)
   13     CONTINUE
          A(I,J) = SUM
   14   CONTINUE
C
        DO 16 I=J, N
          SUM = A(I,J)
          DO 15 K=1, J-1
            SUM = SUM - A(I,K)*A(K,J)
   15     CONTINUE
          A(I,J) = SUM
   16   CONTINUE
C
        DUM = 1.0/A(J,J)
        DO 18 I=J+1, N
          A(I,J) = A(I,J)*DUM
   18   CONTINUE
C
   19 CONTINUE
C
      RETURN
      END ! LUDCMP



      SUBROUTINE BAKSUB(NSIZ,N,A,B)
      DIMENSION A(NSIZ,NSIZ), B(NSIZ)
C
      DO II=1, N
        IF(B(II).NE.0.0) GO TO 5
      ENDDO
 5    CONTINUE
C
      DO 12 I=II+1, N
        SUM = B(I)
        DO 11 J=II, I-1
          SUM = SUM - A(I,J)*B(J)
   11   CONTINUE
        B(I) = SUM
   12 CONTINUE
C
      B(N) = B(N)/A(N,N)
C
      DO 14 I=N-1, 1, -1
        SUM = B(I)
        DO 13 J=I+1, N
          SUM = SUM - A(I,J)*B(J)
   13   CONTINUE
        B(I) = SUM/A(I,I)
   14 CONTINUE
C
      RETURN
      END ! BAKSUB
