      
      SUBROUTINE GLOBIT
C---------------------------------------------------------
C     Sets up global variable system GLSYS (NGLOBxNGLOB)
C     by combining the global constraints with the
C     d(local)/d(global) sensitivities DR(j,L,i) from
C     the already-inverted large Newton system.
C
C     Solves GLSYS for the global variable changes DGLOB.
C---------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION PW1_GL(0:NGLX), PW2_GL(0:NGLX),
     &          PW1M_GL(0:NGLX), PW2M_GL(0:NGLX),
     &          PW1P_GL(0:NGLX), PW2P_GL(0:NGLX)
C
C---- clear global variable system     
      DO 510 K=1, NGLX
         DO 500 L=0, NGLX
            GLSYS(K,L) = 0.
 500     CONTINUE
 510  CONTINUE
C     
C
C---- linearize each global constraint
      DO 400 KGC=1, NGCON
         GO TO ( 1, 2, 3, 4, 5, 6, 7, 8, 9,10,
     &          11,12,13,14,15,16,17,18,19,20,
     &          21,22,23,24,25,26,27,28,29,30,
     &          31,32,33,34,35,36,37,38,39,40,
     &          41,42,43,44,45,46,47,48,49    ), KGCON(KGC)
C     
C==================================================================
C------- Inlet slope
 1       K = LGCON(KGC)
         GLSYS(K,LSINL) = -1.0
         GLSYS(K,1) = SINL - SINLIN
         GOTO 400
C     
C==================================================================
C------- Outlet slope
 2       K = LGCON(KGC)
         GLSYS(K,LSOUT) = -1.0
         GLSYS(K,1) = SOUT - SOUTIN
         GOTO 400
C     
C==================================================================
C------- Leading edge Kutta condition(s)
 3       K = LGCON(KGC)
         DO 302 NB = 1, NBL
           ILE = ILEB(NB)
           I1 = IS1(NB)
           I2 = IS2(NB)
           J1 = JS1(NB)
           J2 = JS2(NB)
           CALL PWLIN(ILE,NB,PW1,PW2,PW1_GL,PW2_GL,.FALSE.)
           DO 301 L=1, NRHS
              GLSYS(K,L) = PW1_GL(L) - PW2_GL(L)
 301       CONTINUE
           GLSYS(K,1) = GLSYS(K,1) + (PW2 - PW1)
           K = K + 1
 302     CONTINUE
         GO TO 400
C     
C==================================================================
C------- Trailing edge Kutta condition(s)
 4       CONTINUE
C
C------- higher-order correction weight, 
C-       accounting for linear loading on airfoil towards TE
ccc         CKUTT = 0.125
         CKUTT = 0.0
         DPCON = 0.0
C
         K = LGCON(KGC)
         DO 402 NB = 1, NBL
           ITE = ITEB(NB)
           I1 = IS1(NB)
           I2 = IS2(NB)
           J1 = JS1(NB)
           J2 = JS2(NB)
           CALL PWLIN(ITE,NB,PW1,PW2,PW1_GL,PW2_GL,.TRUE.)
C
           IF(DSTR(ITE,I1).GT.0.0 .AND. DSTR(ITE,I2).GT.0.0) THEN
            DPS = DPCON
     &          * ( DSTR(ITE,I1)/DSTR(ITE,I2)
     &            - DSTR(ITE,I2)/DSTR(ITE,I1) ) * RHOINF*QINF**2
            DPS_MSQ = DPS/RHOINF   * RI_MSQ
     &              + DPS/QINF*2.0 * QI_MSQ
            DPS_DS1 = DPCON
     &          * (          1.0/DSTR(ITE,I2)
     &            + DSTR(ITE,I2)/DSTR(ITE,I1)**2 ) * RHOINF*QINF**2
            DPS_DS2 = DPCON
     &          * ( -        1.0/DSTR(ITE,I1)
     &            - DSTR(ITE,I1)/DSTR(ITE,I2)**2 ) * RHOINF*QINF**2
           ELSE
            DPS = 0.0
            DPS_MSQ = 0.0
            DPS_DS1 = 0.0
            DPS_DS2 = 0.0
           ENDIF
C
           DO 4021 L=1, NRHS
             DS1_GL = -DR(2*JJ-1+3*I1,L,ITE)
             DS2_GL = -DR(2*JJ-1+3*I2,L,ITE)
C
             GLSYS(K,L) = PW1_GL(L) - PW2_GL(L)
     &                  - DPS_DS1*DS1_GL
     &                  - DPS_DS2*DS2_GL
 4021      CONTINUE
           GLSYS(K,1) = GLSYS(K,1) + (PW2 - PW1)
     &                + DPS
C
C--------- higher-order correction
           CALL PWLIN(ITE-1,NB,PW1,PW2,PW1_GL,PW2_GL,.TRUE.)
           DO 4022 L=1, NRHS
             GLSYS(K,L) = GLSYS(K,L) - CKUTT*(PW1_GL(L) - PW2_GL(L))
 4022      CONTINUE
           GLSYS(K,1) = GLSYS(K,1) - CKUTT*(PW2 - PW1)
C
           K = K + 1
 402     CONTINUE
C     
         GO TO 400
C     
C==================================================================
C------- Alpha
 5       K = LGCON(KGC)
         GLSYS(K,LALFA) = -1.0
         GLSYS(K,1) = ALFA - ALFAIN
         GO TO 400
C     
C==================================================================
C------- Lift
 6       K = LGCON(KGC)
C------- set current LIFT and global dof sensitivities LIFT_GL
         CALL LCALC
C
         QU_MASS = QU_MSQ/MS_MSQ
C
C------- set current CL and linearize it
         CL      = LIFT / QU
         CL_LIFT =  1.0 / QU
         CL_MASS = (-CL/QU)*QU_MASS
C     
C------- set residual and its linearization
         RES    = CL - CLIFIN
         Z_LIFT = CL_LIFT
         Z_MASS = CL_MASS
C     
         GLSYS(K,1) = -RES + Z_LIFT*LIFT_GL(1)
         DO 66 L=2, NRHS
           GLSYS(K,L) = Z_LIFT*LIFT_GL(L)
 66      CONTINUE
         GLSYS(K,LMASS) = GLSYS(K,LMASS) + Z_MASS
         GO TO 400
C     
C==================================================================
C------- Zero leading edge gap(s)
 7       N = NMIX
            K = LGCON(KGC)
            ILE = ILEB(N)
            I1 = IS1(N)
            I2 = IS2(N)
            J1 = JS1(N)
            J2 = JS2(N)
            DO 71 L=1, NRHS
               GLSYS(K,L) = DR(J1,L,ILE) - DR(J2,L,ILE)
 71         CONTINUE
         GO TO 400
C     
C==================================================================
C------- Preserve trailing edge gap(s)
 8       N = NMIX
            K = LGCON(KGC)
            ITE = ITEB(N)
            I1 = IS1(N)
            I2 = IS2(N)
            J1 = JS1(N)
            J2 = JS2(N)
            DX = X(ITE+1,J1) + X(ITE+1,J2) - X(ITE-1,J1) - X(ITE-1,J2)
            DY = Y(ITE+1,J1) + Y(ITE+1,J2) - Y(ITE-1,J1) - Y(ITE-1,J2)
            DS = SQRT(DX*DX + DY*DY)
            DX = -DY/DS
            DY =  DX/DS
CCC   DOTP = DX*NX(ITE,J1) + DY*NY(ITE,J1)
            K2 = 2*JJ-1
            DO 81 L=1, NRHS
               GLSYS(K,L) = (DR(J1,L,ITE) - DR(J2,L,ITE))
     &              -  DR(K2+3*I1,L,ITE) - DR(K2+3*I2,L,ITE)
 81         CONTINUE
         GO TO 400
C     
C==================================================================
C------- Zero leading edge movement
 9       N = NMIX
            K = LGCON(KGC)
            ILE = ILEB(N)
            I1 = IS1(N)
            I2 = IS2(N)
            J1 = JS1(N)
            J2 = JS2(N)
            DO 91 L=1, NRHS
               GLSYS(K,L) = DR(J1,L,ILE) + DR(J2,L,ILE)
 91         CONTINUE
         GO TO 400
C     
C==================================================================
C------- Zero trailing edge movement
 10      N = NMIX
            K = LGCON(KGC)
            ITE = ITEB(N)
            I1 = IS1(N)
            I2 = IS2(N)
            J1 = JS1(N)
            J2 = JS2(N)
            DO 101 L=1, NRHS
               GLSYS(K,L) = DR(J1,L,ITE) + DR(J2,L,ITE)
 101        CONTINUE
         GO TO 400
C     
C     
C==================================================================
C------- Zero IX0 point movement
 11      K = LGCON(KGC)
C
         N = NMIX
         I1 = IS1(N)
         I2 = IS2(N)
         J1 = JS1(N)
         J2 = JS2(N)
C
         I = IX0
         KV = 2*JJ-1
C
         IF(ISMOVE.EQ.1) THEN
          DO 111 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
  111     CONTINUE
         ELSE IF(ISMOVE.EQ.2) THEN
          DO 112 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            - DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            + DR(KV+3*I2,L,I)
  112     CONTINUE
         ELSE IF(ISMOVE.EQ.0) THEN
          DO 113 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
     &            - DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            + DR(KV+3*I2,L,I)
  113     CONTINUE
         ELSE IF(ISMOVE.EQ.-1) THEN
          DO 114 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
     &            + DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            - DR(KV+3*I2,L,I)
  114     CONTINUE
         ENDIF
         GO TO 400
C     
C==================================================================
C------- Zero IX1 point movement
 12      K = LGCON(KGC)
C
         N = NMIX
         I1 = IS1(N)
         I2 = IS2(N)
         J1 = JS1(N)
         J2 = JS2(N)
C
         I = IX1
         KV = 2*JJ-1
C
         IF(ISMOVE.EQ.1) THEN
          DO 121 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
  121     CONTINUE
         ELSE IF(ISMOVE.EQ.2) THEN
          DO 122 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            - DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            + DR(KV+3*I2,L,I)
  122     CONTINUE
         ELSE IF(ISMOVE.EQ.0) THEN
          DO 123 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
     &            - DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            + DR(KV+3*I2,L,I)
  123     CONTINUE
         ELSE IF(ISMOVE.EQ.-1) THEN
          DO 124 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &            + DR(J1,L,I)*(NX(I,J1)*BNX(I,I1) + NY(I,J1)*BNY(I,I1))
     &            - DR(KV+3*I1,L,I)
     &            + DR(J2,L,I)*(NX(I,J2)*BNX(I,I2) + NY(I,J2)*BNY(I,I2))
     &            - DR(KV+3*I2,L,I)
  124     CONTINUE
         ENDIF
         GO TO 400
C     
C     
C==================================================================
C------- set 2nd surface pressure derivative = PXX(1)  (old value set in EDP)
 13       K = LGCON(KGC)
C
          N = NMIX
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
          I = IX0
          KV = 2*JJ-1
C
          CALL PWLIN(I-1,N,PW1M,PW2M,PW1M_GL,PW2M_GL,.FALSE.)
          CALL PWLIN(I  ,N,PW1 ,PW2 ,PW1_GL ,PW2_GL ,.FALSE.)
          CALL PWLIN(I+1,N,PW1P,PW2P,PW1P_GL,PW2P_GL,.FALSE.)
          DO 131 L=1, NRHS
            IF(ISPRES.EQ.0) GLSYS(K,L) = 
     &                     - PW1M_GL(L) + 2.0*PW1_GL(L) - PW1P_GL(L)
     &                     + PW2M_GL(L) - 2.0*PW2_GL(L) + PW2P_GL(L)
            IF(ISPRES.EQ.1) GLSYS(K,L) =
     &                     - PW1M_GL(L) + 2.0*PW1_GL(L) - PW1P_GL(L)
            IF(ISPRES.EQ.2) GLSYS(K,L) =
     &                       PW2M_GL(L) - 2.0*PW2_GL(L) + PW2P_GL(L)
  131     CONTINUE
C
          IF(ISPRES.EQ.0 .OR. ISPRES.EQ.1)
     &      GLSYS(K,1) = GLSYS(K,1) - PXX0(I1)
     &                 + PW1M - 2.0*PW1 + PW1P
          IF(ISPRES.EQ.0 .OR. ISPRES.EQ.2)
     &      GLSYS(K,1) = GLSYS(K,1) + PXX0(I2)
     &                 - PW2M + 2.0*PW2 - PW2P
          GO TO 400
C     
C==================================================================
C------- set 2nd surface pressure derivative = PXX(2)  (old value set in EDP)
 14       K = LGCON(KGC)
C
          N = NMIX
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
          I = IX1
          KV = 2*JJ-1
C
          CALL PWLIN(I-1,N,PW1M,PW2M,PW1M_GL,PW2M_GL,.FALSE.)
          CALL PWLIN(I  ,N,PW1 ,PW2 ,PW1_GL ,PW2_GL ,.FALSE.)
          CALL PWLIN(I+1,N,PW1P,PW2P,PW1P_GL,PW2P_GL,.FALSE.)
          DO 141 L=1, NRHS
            IF(ISPRES.EQ.0) GLSYS(K,L) = 
     &                     - PW1M_GL(L) + 2.0*PW1_GL(L) - PW1P_GL(L)
     &                     + PW2M_GL(L) - 2.0*PW2_GL(L) + PW2P_GL(L)
            IF(ISPRES.EQ.1) GLSYS(K,L) =
     &                     - PW1M_GL(L) + 2.0*PW1_GL(L) - PW1P_GL(L)
            IF(ISPRES.EQ.2) GLSYS(K,L) =
     &                       PW2M_GL(L) - 2.0*PW2_GL(L) + PW2P_GL(L)
  141     CONTINUE
C
          IF(ISPRES.EQ.0 .OR. ISPRES.EQ.1)
     &      GLSYS(K,1) = GLSYS(K,1) - PXX0(I1)
     &                 + PW1M - 2.0*PW1 + PW1P
          IF(ISPRES.EQ.0 .OR. ISPRES.EQ.2)
     &      GLSYS(K,1) = GLSYS(K,1) + PXX0(I2)
     &                 - PW2M + 2.0*PW2 - PW2P
          GO TO 400
C     
C==================================================================
C------- Drive Mach to MACHIN
 15      K = LGCON(KGC)
C------- freestream Mach defined from mass flux
         GLSYS(K,1) = MINF**2 - MACHIN**2
         GLSYS(K,LMASS) = -1.0/MS_MSQ
         GO TO 400
C     
C==================================================================
C------- Drive Mach**2 * CL to MACHIN**2
   16    K = LGCON(KGC)
         QU_MASS = QU_MSQ/MS_MSQ
C
C------- set current CL and linearize it
         CALL LCALC
         CL      = LIFT / QU
         CL_LIFT =  1.0 / QU
         CL_MASS = (-CL / QU) * QU_MASS
C
C------- set residual and its linearization
         RES    = MINF**2 * CL    -   MACHIN**2
         Z_LIFT = MINF**2 * CL_LIFT
         Z_MASS = MINF**2 * CL_MASS
     &     + (1.0/MS_MSQ) * CL
C
         GLSYS(K,1) = -RES + Z_LIFT*LIFT_GL(1)
         DO 166 L=2, NRHS
           GLSYS(K,L) = Z_LIFT*LIFT_GL(L)
  166    CONTINUE
         GLSYS(K,LMASS) = GLSYS(K,LMASS) + Z_MASS
         GO TO 400
C
C==================================================================
C------- Drive Reinf to REYNIN
   17    K = LGCON(KGC)
C
         IF(.NOT.LVISC) THEN
C-------- inviscid: set DREYN = 0.
          GLSYS(K,LREYN) = 1.0
          GLSYS(K,1) = 0.0
          GO TO 400
         ENDIF
C
C------- set current freestream Reynolds number and its sensitivities
         REINF   = REYN * RHOINF*QINF/MUINF
         RE_MSQ  = REYN *(RI_MSQ*QINF + RHOINF*QI_MSQ)/MUINF
     &           - (REINF/MUINF) * MU_MSQ
C
         RE_REYN =        RHOINF*QINF/MUINF
         RE_MASS = RE_MSQ/MS_MSQ
C
C------- set residual and its linearization
         RININV = 1.0/REYNIN
         RES    = REINF  * RININV  -  1.0
         Z_MASS = RE_MASS* RININV
         Z_REYN = RE_REYN* RININV
         GLSYS(K,1) = -RES
         GLSYS(K,LMASS) = Z_MASS
         GLSYS(K,LREYN) = Z_REYN
         GO TO 400
C
C==================================================================
C------- Drive Reinf*sqrt(CL) to REYNIN
   18    K = LGCON(KGC)
C
         IF(ICOUNT.EQ.1 .OR. .NOT.LVISC) THEN
C-------- first iteration or inviscid: set DREYN = 0.
          GLSYS(K,LREYN) = 1.0
          GLSYS(K,1) = 0.0
          GO TO 400
         ENDIF
C
         QU_MASS = QU_MSQ/MS_MSQ
C
C------- set current freestream Reynolds number and its sensitivities
         REINF   = REYN * RHOINF*QINF/MUINF
         RE_MSQ  = REYN *(RI_MSQ*QINF + RHOINF*QI_MSQ)/MUINF
     &           - (REINF/MUINF) * MU_MSQ
C
         RE_REYN =        RHOINF*QINF/MUINF
         RE_MASS = RE_MSQ/MS_MSQ
C
C------- set current CL and linearize it
         CALL LCALC
         CL      = LIFT / QU
         CL_LIFT =  1.0 / QU
         CL_MASS = (-CL / QU) * QU_MASS
C
C------- set residual and its linearization
         IF(CL .GT. 0.0) THEN
           SQCL = SQRT(CL)
         ELSE
           SQCL = 0.1
           WRITE(*,*) 'GLOBIT: Transient CL < 0'
         ENDIF
C
         RININV = 1.0/REYNIN
         RES    = REINF  * RININV * SQCL    -    1.0
         Z_LIFT = REINF  * RININV * 0.5/SQCL * CL_LIFT
         Z_MASS = REINF  * RININV * 0.5/SQCL * CL_MASS
     &          + RE_MASS* RININV * SQCL
         Z_REYN = RE_REYN* RININV * SQCL
         GLSYS(K,1) = -RES + Z_LIFT*LIFT_GL(1)
         DO 186 L=2, NRHS
           GLSYS(K,L) = Z_LIFT*LIFT_GL(L)
  186    CONTINUE
         GLSYS(K,LMASS) = GLSYS(K,LMASS) + Z_MASS
         GLSYS(K,LREYN) = GLSYS(K,LREYN) + Z_REYN
         GO TO 400
C
C==================================================================
C------ Drive mass-averaged Pstag (at I=1) to PSTR0
C       This is done separately for each passage
C
 19     K = LGCON(KGC)
        IO = 1
        IP = 2
        DO 190 J=1, JJ-1
          IF(JSTAG(J).GT.0) GO TO 190
C
cccC-------- Start a new global row for each passage
ccc          IF(JSTAG(J).GT.0) THEN
ccc            K = K + 1
ccc            GO TO 190
ccc          ENDIF
C
          JO = J
          JP = J + 1
          JZ = J + JJ
          DO 1904 L=1, NRHS
            GLSYS(K,L) = GLSYS(K,L)
     &                 + DRP(JO,L) 
     &                 - ( A8P(JO)*DR(JZ,L,IO)
     &                   + A6P(JO)*DR(JO,L,IO) + A7P(JO)*DR(JP,L,IO)
     &                   + C6P(JO)*DR(JO,L,IP) + C7P(JO)*DR(JP,L,IP) )
 1904     CONTINUE
C
 190    CONTINUE
        GO TO 400
C
C==================================================================
C------- set geometry perturbation modes
 20      K = LGCON(KGC)
         DO 205 NN=1, NMODN
           KK = KMODN(NN)
           GLSYS(K,LMODN(KK)) = 1.0
           GLSYS(K,1) = DMSPN(KK)
           K = K + 1
 205     CONTINUE
         GO TO 400
C     
C==================================================================
C------- Set First mode
 21      K = LGCON(KGC)
         GLSYS(K,LMODN(1)) = 1.0
         GLSYS(K,1) = DMSPN(1)
         GO TO 400
C
C==================================================================
C------- Set Second mode
 22      K = LGCON(KGC)
         GLSYS(K,LMODN(2)) = 1.0
         GLSYS(K,1) = DMSPN(2)
         GO TO 400
C
C==================================================================
C------- Set Third mode
 23      K = LGCON(KGC)
         GLSYS(K,LMODN(3)) = 1.0
         GLSYS(K,1) = DMSPN(3)
         GO TO 400
C
C==================================================================
C------- Set Fourth mode
 24      K = LGCON(KGC)
         GLSYS(K,LMODN(4)) = 1.0
         GLSYS(K,1) = DMSPN(4)
         GO TO 400
C
C==================================================================
C------- Set Fifth mode
 25      K = LGCON(KGC)
         GLSYS(K,LMODN(5)) = 1.0
         GLSYS(K,1) = DMSPN(5)
         GO TO 400
C
C==================================================================
C------- Set Sixth mode
 26      K = LGCON(KGC)
         GLSYS(K,LMODN(6)) = 1.0
         GLSYS(K,1) = DMSPN(6)
         GO TO 400
C
C==================================================================
C------- Set Seventh mode
 27      K = LGCON(KGC)
         GLSYS(K,LMODN(7)) = 1.0
         GLSYS(K,1) = DMSPN(7)
         GO TO 400
C
C==================================================================
C------- Set Eighth mode
 28      K = LGCON(KGC)
         GLSYS(K,LMODN(8)) = 1.0
         GLSYS(K,1) = DMSPN(8)
         GO TO 400
C
C==================================================================
C------- Set Ninth mode
 29      K = LGCON(KGC)
         GLSYS(K,LMODN(9)) = 1.0
         GLSYS(K,1) = DMSPN(9)
         GO TO 400
C
C==================================================================
C------- set element position modes
 30      K = LGCON(KGC)
         DO 305 NN=1, NPOSN
           KK = KPOSN(NN)
           GLSYS(K,LPOSN(KK)) = 1.0
           GLSYS(K,1) = DPSPN(KK)
           K = K + 1
 305     CONTINUE
         GO TO 400
C     
C==================================================================
C------- Set First mode
 31      K = LGCON(KGC)
         GLSYS(K,LPOSN(1)) = 1.0
         GLSYS(K,1) = DPSPN(1)
         GO TO 400
C==================================================================
C------- Set Second mode
 32      K = LGCON(KGC)
         GLSYS(K,LPOSN(2)) = 1.0
         GLSYS(K,1) = DPSPN(2)
         GO TO 400
C==================================================================
C------- Set Third mode
 33      K = LGCON(KGC)
         GLSYS(K,LPOSN(3)) = 1.0
         GLSYS(K,1) = DPSPN(3)
         GO TO 400
C==================================================================
C------- Set Fourth mode
 34      K = LGCON(KGC)
         GLSYS(K,LPOSN(4)) = 1.0
         GLSYS(K,1) = DPSPN(4)
         GO TO 400
C==================================================================
C------- Set Fifth mode
 35      K = LGCON(KGC)
         GLSYS(K,LPOSN(5)) = 1.0
         GLSYS(K,1) = DPSPN(5)
         GO TO 400
C==================================================================
C------- Set Sixth mode
 36      K = LGCON(KGC)
         GLSYS(K,LPOSN(6)) = 1.0
         GLSYS(K,1) = DPSPN(6)
         GO TO 400
C==================================================================
C------- Set Seventh mode
 37      K = LGCON(KGC)
         GLSYS(K,LPOSN(7)) = 1.0
         GLSYS(K,1) = DPSPN(7)
         GO TO 400
C==================================================================
C------- Set Eighth mode
 38      K = LGCON(KGC)
         GLSYS(K,LPOSN(8)) = 1.0
         GLSYS(K,1) = DPSPN(8)
         GO TO 400
C==================================================================
C------- Set Ninth mode
 39      K = LGCON(KGC)
         GLSYS(K,LPOSN(9)) = 1.0
         GLSYS(K,1) = DPSPN(9)
         GO TO 400
C
C==================================================================
C------- modal-inverse constraints on geometry perturbation modes
 40      K = LGCON(KGC)
         DO 405 NN=1, NMODN
           KK = KMODN(NN)
           CALL MODMIN(K,KK)
           K = K + 1
 405     CONTINUE
         GO TO 400
C     
C==================================================================
C------- First modal inverse minimization condition
 41      K = LGCON(KGC)
         CALL MODMIN(K,1)
         GO TO 400
C
C==================================================================
C------- Second modal inverse minimization condition
 42      K = LGCON(KGC)
         CALL MODMIN(K,2)
         GO TO 400
C
C==================================================================
C------- Third modal inverse minimization condition
 43      K = LGCON(KGC)
         CALL MODMIN(K,3)
         GO TO 400
C
C==================================================================
C------- Fourth modal inverse minimization condition
 44      K = LGCON(KGC)
         CALL MODMIN(K,4)
         GO TO 400
C
C==================================================================
C------- Fifth modal inverse minimization condition
 45      K = LGCON(KGC)
         CALL MODMIN(K,5)
         GO TO 400
C
C==================================================================
C------- Sixth modal inverse minimization condition
 46      K = LGCON(KGC)
         CALL MODMIN(K,6)
         GO TO 400
C
C==================================================================
C------- Seventh modal inverse minimization condition
 47      K = LGCON(KGC)
         CALL MODMIN(K,7)
         GO TO 400
C
C==================================================================
C------- Eighth modal inverse minimization condition
 48      K = LGCON(KGC)
         CALL MODMIN(K,8)
         GO TO 400
C
C==================================================================
C------- Ninth modal inverse minimization condition
 49      K = LGCON(KGC)
         CALL MODMIN(K,9)
         GO TO 400
C
 400  CONTINUE
C     
C     
C---- put glabal system matrix into temporary arrays for solution
      DO 604 K=1, NRHS
         DGLOB(K) = GLSYS(K,1)
         DO 602 L=2, NRHS
            GMAT(K,L-1) = GLSYS(K,L)
 602     CONTINUE
 604  CONTINUE
C     
C     
C---- Solve the NGLOBxNGLOB system for the global variable deltas
c      write(*,*)
c      do k=1, nglob
c        write(*,6677) (gmat(k,l),l=1,nglob), dglob(k)
c 6677   format(1x,32E10.3)
c      enddo
C
      IF(NGLOB.NE.0) CALL SOLVIT(NGLX,NGLOB,GMAT(1,1),DGLOB(1))
C
      DGLOB(-1) = 0.0
      DGLOB( 0) = 0.0
      DSINL = DGLOB(LSINL-1)
      DSOUT = DGLOB(LSOUT-1)
      DCIRC = DGLOB(LCIRC-1)
      DALFA = DGLOB(LALFA-1)
      DPDF0 = DGLOB(LPDF0-1)
      DPDF1 = DGLOB(LPDF1-1)
      DPDFL = DGLOB(LPDFL-1)
      DPDX0 = DGLOB(LPDX0-1)
      DPDX1 = DGLOB(LPDX1-1)
      DPDD0 = DGLOB(LPDD0-1)
      DPDD1 = DGLOB(LPDD1-1)
      DMASS = DGLOB(LMASS-1)
      DPREX = DGLOB(LPREX-1)
      DREYN = DGLOB(LREYN-1)
      DO 618 N=1, NMODN
        K = KMODN(N)
        DMODN(K) = DGLOB(LMODN(K)-1)
 618  CONTINUE
C     
      DO 619 N=1, NPOSN
        K = KPOSN(N)
        DPOSN(K) = DGLOB(LPOSN(K)-1)
 619  CONTINUE
C     
      DO 620 N = 1, NBL
        DSBLE(N) = DGLOB(LSBLE(N)-1)
        DMAS1(N) = DGLOB(LMAS1(N)-1)
  620 CONTINUE
C
      RETURN
      END ! GLOBIT
 
 
 
      SUBROUTINE PWLIN(IO,N,PW1,PW2,PW1_GL,PW2_GL,LVCORR)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION PW1_GL(0:NGLX), PW2_GL(0:NGLX)
      LOGICAL LVCORR
C--------------------------------------------------------------
C     Sets sensitivities P1_GL,P2_GL of wall pressures at i=I,
C     element N, with respect to global variable L.
C
C     For L=1, P1_GL,P2_GL contain -(residual change).
C
C     If LVCORR=t, the pressure is corrected for Theta,Dstar.
C
C     Returned pressures are actually P - Po
C--------------------------------------------------------------
      DIMENSION DP1_M1(NBX), DP1_NG(NBX), DP1_NP(NPOSX),
     &          DP2_M1(NBX), DP2_NG(NBX), DP2_NP(NPOSX)
C
      IK = IO - 3
      IL = IO - 2
      IM = IO - 1
      IP = IO + 1
      JO = JS1(N)
      JP = JO+1
      JL = JS2(N)
      JM = JL-1
C
      I1 = IS1(N)
      I2 = IS2(N)
C
      PW1 = PI(IO,JO)
      PW2 = PI(IO,JL)
C
      DO 10 L=1, NRHS
        SUMS = V5S(I1,IO) * DR(JO+JJ,L,IK)
     &       + Z5S(I1,IO) * DR(JO+JJ,L,IL)
     &       + B5S(I1,IO) * DR(JO+JJ,L,IM)
     &       + A5S(I1,IO) * DR(JO+JJ,L,IO)
     &       + V2S(I1,IO) * DR(JO,L,IK)
     &       + Z2S(I1,IO) * DR(JO,L,IL)
     &       + B2S(I1,IO) * DR(JO,L,IM)
     &       + A2S(I1,IO) * DR(JO,L,IO)
     &       + C2S(I1,IO) * DR(JO,L,IP)
     &       + V3S(I1,IO) * DR(JP,L,IK)
     &       + Z3S(I1,IO) * DR(JP,L,IL)
     &       + B3S(I1,IO) * DR(JP,L,IM)
     &       + A3S(I1,IO) * DR(JP,L,IO)
     &       + C3S(I1,IO) * DR(JP,L,IP)
C
        SUMP = V4S(I2,IO) * DR(JM+JJ,L,IK)
     &       + Z4S(I2,IO) * DR(JM+JJ,L,IL)
     &       + B4S(I2,IO) * DR(JM+JJ,L,IM)
     &       + A4S(I2,IO) * DR(JM+JJ,L,IO)
     &       + V1S(I2,IO) * DR(JM,L,IK)
     &       + Z1S(I2,IO) * DR(JM,L,IL)
     &       + B1S(I2,IO) * DR(JM,L,IM)
     &       + A1S(I2,IO) * DR(JM,L,IO)
     &       + C1S(I2,IO) * DR(JM,L,IP)
     &       + V2S(I2,IO) * DR(JL,L,IK)
     &       + Z2S(I2,IO) * DR(JL,L,IL)
     &       + B2S(I2,IO) * DR(JL,L,IM)
     &       + A2S(I2,IO) * DR(JL,L,IO)
     &       + C2S(I2,IO) * DR(JL,L,IP)
C
        SUMS = SUMS - DRS(I1,L,IO)
        SUMP = SUMP - DRS(I2,L,IO)
C
        PW1_GL(L) =  0.5*SUMS
        PW2_GL(L) = -0.5*SUMP
 10   CONTINUE

      PW1_GL(0) = 0.
      PW2_GL(0) = 0.
C
      IF(.NOT.LVCORR) RETURN
C
C---- set normal pressure gradients
      CALL DPDN(IO,I1,DP1,
     &            DP1_R1 , DP1_R2 ,
     &            DP1_N1M, DP1_N2M, DP1_N3M,
     &            DP1_N1P, DP1_N2P, DP1_N3P,
     &            DP1_MS , DP1_AL , DP1_M1 , DP1_NG, DP1_NP)
      CALL DPDN(IO,I2,DP2,
     &            DP2_R1 , DP2_R2 ,
     &            DP2_N1M, DP2_N2M, DP2_N3M,
     &            DP2_N1P, DP2_N2P, DP2_N3P,
     &            DP2_MS , DP2_AL , DP2_M1 , DP2_NG, DP2_NP)
C
      PW1 = PW1 + DP1*(WXPT*THET(IO,I1) + WXPD*DSTR(IO,I1))
      PW2 = PW2 + DP2*(WXPT*THET(IO,I2) + WXPD*DSTR(IO,I2))
C
      PW1_DP1 =        WXPT*THET(IO,I1) + WXPD*DSTR(IO,I1)
      PW2_DP2 =        WXPT*THET(IO,I2) + WXPD*DSTR(IO,I2)
      PW1_TH1 =   DP1* WXPT
      PW2_TH2 =   DP2* WXPT
      PW1_DS1 =   DP1*                    WXPD
      PW2_DS2 =   DP2*                    WXPD
C
      DO 20 L=1, NRHS
        DP1_GL = 
     &     - ( DP1_R1  * DR(JO+JJ,L,IM)
     &       + DP1_R2  * DR(JO+JJ,L,IO)
     &       + DP1_N1M * DR(JO,L,IM)
     &       + DP1_N2M * DR(JO,L,IO)
     &       + DP1_N3M * DR(JO,L,IP)
     &       + DP1_N1P * DR(JP,L,IM)
     &       + DP1_N2P * DR(JP,L,IO)
     &       + DP1_N3P * DR(JP,L,IP) )
C
        DP2_GL = 
     &     - ( DP2_R1  * DR(JM+JJ,L,IM)
     &       + DP2_R2  * DR(JM+JJ,L,IO)
     &       + DP2_N1M * DR(JM,L,IM)
     &       + DP2_N2M * DR(JM,L,IO)
     &       + DP2_N3M * DR(JM,L,IP)
     &       + DP2_N1P * DR(JL,L,IM)
     &       + DP2_N2P * DR(JL,L,IO)
     &       + DP2_N3P * DR(JL,L,IP) )
C
        TH1_GL = -DR(2*JJ-2+3*I1,L,IO)
        TH2_GL = -DR(2*JJ-2+3*I2,L,IO)
        DS1_GL = -DR(2*JJ-1+3*I1,L,IO)
        DS2_GL = -DR(2*JJ-1+3*I2,L,IO)
C
        PW1_GL(L) = PW1_GL(L)
     &            + PW1_DP1*DP1_GL
     &            + PW1_TH1*TH1_GL
     &            + PW1_DS1*DS1_GL
        PW2_GL(L) = PW2_GL(L)
     &            + PW2_DP2*DP2_GL
     &            + PW2_TH2*TH2_GL
     &            + PW2_DS2*DS2_GL
 20   CONTINUE
C
      PW1_GL(LMASS) = PW1_GL(LMASS) + PW1_DP1*DP1_MS
      PW2_GL(LMASS) = PW2_GL(LMASS) + PW2_DP2*DP2_MS
C
      PW1_GL(LALFA) = PW1_GL(LALFA) + PW1_DP1*DP1_AL
      PW2_GL(LALFA) = PW2_GL(LALFA) + PW2_DP2*DP2_AL
C
      DO NN=1, NBL
        L = LMAS1(NN)
        PW1_GL(L) = PW1_GL(L) + PW1_DP1*DP1_M1(NN)
        PW2_GL(L) = PW2_GL(L) + PW2_DP2*DP2_M1(NN)
        L = LSBLE(NN)
        PW1_GL(L) = PW1_GL(L) + PW1_DP1*DP1_NG(NN)
        PW2_GL(L) = PW2_GL(L) + PW2_DP2*DP2_NG(NN)
      ENDDO
C
      DO NN=1, NPOSN
        KK = KPOSN(NN)
        L = LPOSN(KK)
        PW1_GL(L) = PW1_GL(L) + PW1_DP1*DP1_NP(KK)
        PW2_GL(L) = PW2_GL(L) + PW2_DP2*DP2_NP(KK)
      ENDDO
C
      RETURN
      END  ! PWLIN
 
 
 
      SUBROUTINE MODMIN(K,KMOD)
C---------------------------------------------
C     Sets up least-squares pressure-matching
C     equation for modal inverse dof KMOD.
C---------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION PW1_GL(0:NGLX), PW2_GL(0:NGLX)
C
C---- global system column index of modal dof KMOD
      LMOD = LMODN(KMOD)
C
      DO 100 N=1, NBL
C
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
      J1 = JS1(N)
      J2 = JS2(N)
C
      DO 50 I=ILE,ITE
C
        IG = I-ILE+1
C
C------ skip this node if it not covered by mode KMOD
        IF( ABS(GN(KMOD,IG,I1)) .LT. 1.0E-6 .AND.
     &      ABS(GN(KMOD,IG,I2)) .LT. 1.0E-6       ) GO TO 50
C
        CALL PWLIN(I,N,PW1,PW2,PW1_GL,PW2_GL,.FALSE.)
C
        IF(ISPRES.EQ.0) THEN
C
         DPDB = PW1_GL(LMOD) - PW2_GL(LMOD)
         GLSYS(K,1) = GLSYS(K,1) - (PW1 - PSPEC(IG,I1))*DPDB
     &                           + (PW2 - PSPEC(IG,I2))*DPDB
         DO 11 L=1, NRHS
           GLSYS(K,L) = GLSYS(K,L) + (PW1_GL(L) - PW2_GL(L))*DPDB
   11    CONTINUE
C
        ELSE IF(ISPRES.EQ.1) THEN
C
         DPDB = PW1_GL(LMOD)
         GLSYS(K,1) = GLSYS(K,1) - (PW1 - PSPEC(IG,I1))*DPDB
C
         DO 21 L=1, NRHS
           GLSYS(K,L) = GLSYS(K,L) + PW1_GL(L)*DPDB
   21    CONTINUE
C
        ELSE IF(ISPRES.EQ.2) THEN
C
         DPDB = -PW2_GL(LMOD)
         GLSYS(K,1) = GLSYS(K,1) + (PW2 - PSPEC(IG,I2))*DPDB
C
         DO 31 L=1, NRHS
           GLSYS(K,L) = GLSYS(K,L) - PW2_GL(L)*DPDB
   31    CONTINUE
C
        ENDIF

   50 CONTINUE
 100  CONTINUE
C
      RETURN
      END ! MODMIN
 
 
 
