
      SUBROUTINE GLOSEN
C-------------------------------------------
C     Calculates CL and CD sensitivities
C     wrt various active global variables
C-------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION DGLSEN(NGLX,NGLX), GLSYSM(NGLX,0:NGLX)
      DIMENSION KROW(NGLX), LVSEN(NGLX)
      LOGICAL VSPENT(0:NGLX)
C
C---- set global system row number for each constraint equation
      KSUM = 0
      DO 5 KGC=1, NGLOB
        IF(3.EQ.KGCON(KGC) .OR.
     &     4.EQ.KGCON(KGC)     ) THEN
         KSUM = KSUM + NBL
        ELSE
         KSUM = KSUM + 1
        ENDIF
C
        KROW(KGC) = KSUM
C
C------ for special mode specification convention, add NMODN or NPOSN rows
        IF(20.EQ.KGCON(KGC) .OR.
     &     40.EQ.KGCON(KGC)    ) THEN
         KSUM = KSUM + NMODN - 1
        ELSE IF(30.EQ.KGCON(KGC)) THEN
         KSUM = KSUM + NPOSN - 1
        ENDIF
C
 5    CONTINUE
C
C
C---- first take global system straight from GLOBIT
      DO 7 L=2, NRHS
        DO 70 K=1, NGLOB
          GLSYSM(K,L) = GLSYS(K,L)
 70     CONTINUE
C
C------ initialize spent-variable flag
        VSPENT(L) = .FALSE.
 7    CONTINUE
C
C
C---- now modify global system if necessary
      DO 10 KGC=1, NGLOB
C
        K = KROW(KGC)
C
        IF(KGCON(KGC).EQ.6) THEN
C------- freeze alpha if CL is prescribed
         DO 121 L=2, NRHS
           GLSYSM(K,L) = 0.0
 121     CONTINUE
         GLSYSM(K,LALFA) = 1.0
        ENDIF
C
        IF(KGCON(KGC).EQ.15 .OR. KGCON(KGC).EQ.16) THEN
C------- freeze Minf (mass flow) if Minf or Minf*sqrt(CL) is prescribed
C
         DO 122 L=2, NRHS
           GLSYSM(K,L) = 0.0
 122     CONTINUE
         GLSYSM(K,LMASS) = 1.0
        ENDIF
C
        IF(KGCON(KGC).EQ.17 .OR. KGCON(KGC).EQ.18) THEN
C------- freeze Reinf if Reinf or Reinf*sqrt(CL) is prescribed
C
C------- set current freestream Reynolds number and its sensitivities
         REINF   = REYN * RHOINF*QINF/MUINF
         RE_MSQ  = REYN *(RI_MSQ*QINF + RHOINF*QI_MSQ)/MUINF
     &           - (REINF/MUINF) * MU_MSQ
C
         RE_REYN =        RHOINF*QINF/MUINF
         RE_MASS = RE_MSQ/MS_MSQ
C
         DO 123 L=2, NRHS
           GLSYSM(K,L) = 0.0
 123     CONTINUE
         GLSYSM(K,LREYN) = RE_REYN
         GLSYSM(K,LMASS) = RE_MASS
        ENDIF
C
        IF(KGCON(KGC).GE.41 .AND. KGCON(KGC).LE.49) THEN
C------- freeze any modal-inverse geometry mode
         DO 125 L=2, NRHS
           GLSYSM(K,L) = 0.0
 125     CONTINUE
         IF(41.EQ.KGCON(KGC)) GLSYSM(K,LMODN(1)) = 1.0
         IF(42.EQ.KGCON(KGC)) GLSYSM(K,LMODN(2)) = 1.0
         IF(43.EQ.KGCON(KGC)) GLSYSM(K,LMODN(3)) = 1.0
         IF(44.EQ.KGCON(KGC)) GLSYSM(K,LMODN(4)) = 1.0
         IF(45.EQ.KGCON(KGC)) GLSYSM(K,LMODN(5)) = 1.0
         IF(46.EQ.KGCON(KGC)) GLSYSM(K,LMODN(6)) = 1.0
         IF(47.EQ.KGCON(KGC)) GLSYSM(K,LMODN(7)) = 1.0
         IF(48.EQ.KGCON(KGC)) GLSYSM(K,LMODN(8)) = 1.0
         IF(49.EQ.KGCON(KGC)) GLSYSM(K,LMODN(9)) = 1.0
        ENDIF
C
        IF(KGCON(KGC).EQ.40) THEN
C------- freeze all modal-inverse geometry modes
         DO 127 NN=1, NMODN
           KR = KROW(KGC) + NN - 1
           DO 1275 L=2, NRHS
             GLSYSM(KR,L) = 0.0
 1275      CONTINUE
           L = LMODN(KMODN(NN))
           GLSYSM(KR,L) = 1.0
 127     CONTINUE
        ENDIF
C
 10   CONTINUE
C
C
C---- counter of how many variables were relaxed
      NLV = 0
C
C---- go over each global constraint ...
      DO 2000 KGC=1, NGLOB
C
        NPASS = 1
        IF(KGCON(KGC).EQ.20 .OR.
     &     KGCON(KGC).EQ.40) NPASS = NMODN
        IF(KGCON(KGC).EQ.30) NPASS = NPOSN
C
        DO 1990 IPASS=1, NPASS
C
C------ fill global variable system
        DO 20 K=1, NGLOB
          DGLOB(K) = 0.0
          DO 205 L=2, NRHS
            GMAT(K,L-1) = GLSYSM(K,L)
 205      CONTINUE
 20     CONTINUE
C
C------ set row index of equation to be relaxed
        KR = KROW(KGC) + IPASS - 1
C
C------ set column index of variable constrained by current equation
        LV = 0
C
        IF( 5.EQ.KGCON(KGC)) LV = LALFA
        IF( 6.EQ.KGCON(KGC)) LV = LALFA
        IF(15.EQ.KGCON(KGC)) LV = LMASS
        IF(16.EQ.KGCON(KGC)) LV = LMASS
        IF(17.EQ.KGCON(KGC)) LV = LREYN
        IF(18.EQ.KGCON(KGC)) LV = LREYN
C
        IF(20.EQ.KGCON(KGC)) LV = LMODN(IPASS)
        IF(21.EQ.KGCON(KGC)) LV = LMODN(1)
        IF(22.EQ.KGCON(KGC)) LV = LMODN(2)
        IF(23.EQ.KGCON(KGC)) LV = LMODN(3)
        IF(24.EQ.KGCON(KGC)) LV = LMODN(4)
        IF(25.EQ.KGCON(KGC)) LV = LMODN(5)
        IF(26.EQ.KGCON(KGC)) LV = LMODN(6)
        IF(27.EQ.KGCON(KGC)) LV = LMODN(7)
        IF(28.EQ.KGCON(KGC)) LV = LMODN(8)
        IF(29.EQ.KGCON(KGC)) LV = LMODN(9)
C
        IF(40.EQ.KGCON(KGC)) LV = LMODN(IPASS)
        IF(41.EQ.KGCON(KGC)) LV = LMODN(1)
        IF(42.EQ.KGCON(KGC)) LV = LMODN(2)
        IF(43.EQ.KGCON(KGC)) LV = LMODN(3)
        IF(44.EQ.KGCON(KGC)) LV = LMODN(4)
        IF(45.EQ.KGCON(KGC)) LV = LMODN(5)
        IF(46.EQ.KGCON(KGC)) LV = LMODN(6)
        IF(47.EQ.KGCON(KGC)) LV = LMODN(7)
        IF(48.EQ.KGCON(KGC)) LV = LMODN(8)
        IF(49.EQ.KGCON(KGC)) LV = LMODN(9)
C
        IF(30.EQ.KGCON(KGC)) LV = LPOSN(IPASS)
        IF(31.EQ.KGCON(KGC)) LV = LPOSN(1)
        IF(32.EQ.KGCON(KGC)) LV = LPOSN(2)
        IF(33.EQ.KGCON(KGC)) LV = LPOSN(3)
        IF(34.EQ.KGCON(KGC)) LV = LPOSN(4)
        IF(35.EQ.KGCON(KGC)) LV = LPOSN(5)
        IF(36.EQ.KGCON(KGC)) LV = LPOSN(6)
        IF(37.EQ.KGCON(KGC)) LV = LPOSN(7)
        IF(38.EQ.KGCON(KGC)) LV = LPOSN(8)
        IF(39.EQ.KGCON(KGC)) LV = LPOSN(9)
C
C------ try next equation if this one is not to be relaxed
        IF(LV.EQ.0 .OR. VSPENT(LV)) GO TO 2000
C
C
C------ set flag so this variable won't be used again for this system
        VSPENT(LV) = .TRUE.
C
C------ expunge relaxed constraint equation
        DGLOB(KR) = 0.0
        DO 40 L=2, NRHS
          GMAT(KR,L-1) = 0.0
   40   CONTINUE
C
C------ set free global variable unit change
        DGLOB(KR) = 1.0
        GMAT(KR,LV-1) = 1.0
C
c        write(*,*) ' '
c        write(*,*) kgc, kgcon(kgc), kr, lv-1
c        do k=1, nglob
c          write(*,9966) (GMAT(k,l),l=1, nglob) ! , dglob(k)
c 9966     format(1x,20f8.3)
c        enddo
C
C------ solve for resultant other global variable changes
        CALL SOLVIT(NGLX,NGLOB,GMAT(1,1),DGLOB(1))
C
C------ store resultant global variable changes
        DO 45 K=1, NGLOB
          DGLSEN(K,LV) = DGLOB(K)
 45     CONTINUE
C
C------ store column index of variable which was perturbed in this pass
        NLV = NLV+1
        LVSEN(NLV) = LV
C
 1990   CONTINUE
 2000 CONTINUE
C
C---- set DRAGV and DRAGW, and dof sensitivities DRAGV_GL, DRAGW_GL
      CALL DVCALC
      CALL DWCALC
C
C---- set LIFT and its global dof sensitivities LIFT_GL
      CALL LCALC
C
C----- set surface streamline Cp, Theta, etc, and sensitivities  xxx_GL
       CALL CPCALC
C
C----- set total sensitivities of CL, CD, CM
       CALL LDMSEN(NGLX,NLV,LVSEN,DGLSEN)
C
C----- set total sensitivities of Cp(x), Theta(x), etc.
       CALL CPVSEN(NGLX,NLV,LVSEN,DGLSEN)
C
C---- if geometry perturbation or element position modes are present...
      IF(LMODI .OR. LPOSI) THEN
C
        CALL GEOSEN
C
      ENDIF
C
C
      RETURN
      END ! GLOSEN



      SUBROUTINE LDMSEN(NLVX,NLV,LVSEN,DGLSEN)
C-----------------------------------------------------
C     Calculates various sensitivities with respect 
C     to global variables using previously-calculated 
C     variable perturbation combos.
C-----------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
C
      DIMENSION LVSEN(NLVX)
      DIMENSION DGLSEN(NLVX,NLVX)
C
C---- zero out sensitivities
      DO 11 K=1, NMODX
        CL_MOD(K) = 0.0
        CM_MOD(K) = 0.0
        AL_MOD(K) = 0.0
        CDW_MOD(K) = 0.0
        CDV_MOD(K) = 0.0
        CDF_MOD(K) = 0.0
   11 CONTINUE
C
      DO 12 K=1, NPOSX
        CL_POS(K) = 0.0
        CM_POS(K) = 0.0
        AL_POS(K) = 0.0
        CDW_POS(K) = 0.0
        CDV_POS(K) = 0.0
        CDF_POS(K) = 0.0
   12 CONTINUE
C
      AL_ALFA = 0.
      AL_MINF = 0.
      AL_RINF = 0.
C
      CL_ALFA = 0.
      CL_MINF = 0.
      CL_RINF = 0.
C
      CM_ALFA = 0.
      CM_MINF = 0.
      CM_RINF = 0.
C
      CDW_ALFA = 0.
      CDW_MINF = 0.
      CDW_RINF = 0.
C
      CDV_ALFA = 0.
      CDV_MINF = 0.
      CDV_RINF = 0.
C
      CDF_ALFA = 0.
      CDF_MINF = 0.
      CDF_RINF = 0.
C
      DO 1000 ILV = 1, NLV
C
        LV = LVSEN(ILV)
C
C------ recall resultant global variable changes
        DO 20 L=1, NGLOB
          DGLOB(L) = DGLSEN(L,LV)
 20     CONTINUE
C
        DGLOB(-1) = 0.0
        DGLOB( 0) = 0.0
        DCIRC = DGLOB(LCIRC-1)
        DALFA = DGLOB(LALFA-1)
        DPDF0 = DGLOB(LPDF0-1)
        DPDF1 = DGLOB(LPDF1-1)
        DPDFL = DGLOB(LPDFL-1)
        DREYN = DGLOB(LREYN-1)
        DPDX0 = DGLOB(LPDX0-1)
        DPDX1 = DGLOB(LPDX1-1)
        DPDD0 = DGLOB(LPDD0-1)
        DPDD1 = DGLOB(LPDD1-1)
        DMASS = DGLOB(LMASS-1)
        DO 22 N=1, NBL
          DSBLE(N) = DGLOB(LSBLE(N)-1)
          DMAS1(N) = DGLOB(LMAS1(N)-1)
 22     CONTINUE
        DO 23 NN=1, NMODN
          DMODN(NN) = DGLOB(LMODN(NN)-1)
 23     CONTINUE
        DO 24 NN=1, NPOSN
          DPOSN(NN) = DGLOB(LPOSN(NN)-1)
 24     CONTINUE
C
C****** calculate various quantity sensitivities ******
C
        CDV     = DRAGV / QU
        CDV_DV  =   1.0 / QU
        CDV_MSQ = (-CDV / QU) * QU_MSQ
C
C------ set total viscous Cd change
        DCDV = (CDV_MSQ/MS_MSQ) * DMASS
        DO 30 L=2, NRHS
          DCDV = DCDV + CDV_DV*DRAGV_GL(L) * DGLOB(L-1)
 30     CONTINUE
C
C
        CDW     = DRAGW / QU
        CDW_DW  =   1.0 / QU
        CDW_MSQ = (-CDW / QU) * QU_MSQ
C
C------ set total wave Cd change
        DCDW = (CDW_MSQ/MS_MSQ) * DMASS
        DO 32 L=2, NRHS
          DCDW = DCDW + CDW_DW*DRAGW_GL(L) * DGLOB(L-1)
 32     CONTINUE
C
C
        CDF     = DRAGF / QU
        CDF_DF  =   1.0 / QU
        CDF_MSQ = (-CDF / QU) * QU_MSQ
C
C------ set total friction Cd change
        DCDF = (CDF_MSQ/MS_MSQ) * DMASS
        DO 33 L=2, NRHS
          DCDF = DCDF + CDF_DF*DRAGF_GL(L) * DGLOB(L-1)
 33     CONTINUE
C
C
C------ set current CL and linearize it
        CL      = LIFT / QU
        CL_LIFT =  1.0 / QU
        CL_MSQ  = (-CL / QU) * QU_MSQ
C
        DCL = (CL_MSQ/MS_MSQ) * DMASS
        DO 34 L=2, NRHS
          DCL = DCL + CL_LIFT*LIFT_GL(L) * DGLOB(L-1)
 34     CONTINUE
C
CCC        DCL = 2.0*DCIRC
C
C
C------ set current CM and linearize it
        CM      = MOMN / QU
        CM_MOMN =  1.0 / QU
        CM_MSQ  = (-CM / QU) * QU_MSQ
C
        DCM = (CM_MSQ/MS_MSQ) * DMASS
        DO 36 L=2, NRHS
          DCM = DCM + CM_MOMN*MOMN_GL(L) * DGLOB(L-1)
 36     CONTINUE
C
C
C------ set Mach change due to mass change
        DMSQ = (1.0/MS_MSQ) * DMASS
        DMINF = (0.5/MINF) * DMSQ
C
C
C------ set Re_inf change due to Reyn,mass changes
        REINF   = REYN * RHOINF*QINF/MUINF
        RE_MSQ  = REYN *(RI_MSQ*QINF + RHOINF*QI_MSQ)/MUINF
     &          - (REINF/MUINF) * MU_MSQ
C
        RE_REYN =        RHOINF*QINF/MUINF
        RE_MASS = RE_MSQ/MS_MSQ
        DRINF = RE_REYN*DREYN + RE_MASS*DMASS
C
C
C------ total Cd change
        DCD = DCDV + DCDW
C
C------ set final sensitivities
        IF(LALFA.EQ.LV) THEN
         CL_ALFA = DCL/DALFA
         CM_ALFA = DCM/DALFA
         AL_ALFA = DALFA/DALFA
         CDW_ALFA = DCDW/DALFA
         CDV_ALFA = DCDV/DALFA
         CDF_ALFA = DCDF/DALFA
        ELSE IF(LMASS.EQ.LV .AND. DMINF.NE.0.0) THEN
         CL_MINF = DCL/DMINF
         CM_MINF = DCM/DMINF
         AL_MINF = DALFA/DMINF
         CDW_MINF = DCDW/DMINF
         CDV_MINF = DCDV/DMINF
         CDF_MINF = DCDF/DMINF
        ELSE IF(LREYN.EQ.LV .AND. DRINF.NE.0.0) THEN
         CL_RINF = DCL/DRINF
         CM_RINF = DCM/DRINF
         AL_RINF = DALFA/DRINF
         CDW_RINF = DCDW/DRINF
         CDV_RINF = DCDV/DRINF
         CDF_RINF = DCDF/DRINF
        ENDIF
C
        DO 40 N=1, NMODN
          K = KMODN(N)
          IF(LMODN(K).EQ.LV) THEN
           CL_MOD(K) = DCL/DMODN(K)
           CM_MOD(K) = DCM/DMODN(K)
           AL_MOD(K) = DALFA/DMODN(K)
           CDW_MOD(K) = DCDW/DMODN(K)
           CDV_MOD(K) = DCDV/DMODN(K)
           CDF_MOD(K) = DCDF/DMODN(K)
           GO TO 41
          ENDIF
 40     CONTINUE
 41     CONTINUE
C
        DO 44 N=1, NPOSN
          K = KPOSN(N)
          IF(LPOSN(K).EQ.LV) THEN
           CL_POS(K) = DCL/DPOSN(K)
           CM_POS(K) = DCM/DPOSN(K)
           AL_POS(K) = DALFA/DPOSN(K)
           CDW_POS(K) = DCDW/DPOSN(K)
           CDV_POS(K) = DCDV/DPOSN(K)
           CDF_POS(K) = DCDF/DPOSN(K)
           GO TO 45
          ENDIF
 44     CONTINUE
 45     CONTINUE
C
 1000 CONTINUE
C
      RETURN
      END ! LMDSEN



      SUBROUTINE CPVSEN(NLVX,NLV,LVSEN,DGLSEN)
C-------------------------------------------------------------
C     Calculates sensitivities of surface variables with 
C     respect to global variables using previously-calculated 
C     variable perturbation combos.
C-------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
C
      DIMENSION LVSEN(NLVX)
      DIMENSION DGLSEN(NLVX,NLVX)
C
      DIMENSION SBSIDE(ISX)
C
C
      DO 5 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
 5    CONTINUE
C
CC
      DO 1000 ILV = 1, NLV
C
        LV = LVSEN(ILV)
C
C------ recall resultant global variable changes
        DO 7 L=1, NGLOB
          DGLOB(L) = DGLSEN(L,LV)
 7      CONTINUE
C
        IF(DGLOB(LV-1) .EQ. 0.0) THEN
         WRITE(*,*) 
     &     'CPVSEN: Zero perturbation for variable in RHS column ', LV
         STOP
        ENDIF
C
C------ set mass sensitivity wrt Mach
        MS_MINF = MS_MSQ * (2.0*MINF)
C
C------ accumulate total variable changes due to global variable 
C-      perturbation vector DGLOB
        DO 10 IS=1, 2*NBL
          N = (IS+1)/2
          DO 104 I=ILEB(N), II-1
            CP_GL(I,IS,1) = 0.0
            HK_GL(I,IS,1) = 0.0
ccc            MD_GL(I,IS,1) = 0.0
ccc            ST_GL(I,IS,1) = 0.0
            DO 1042 L=2, NRHS
              DGLRAT = DGLOB(L-1)/DGLOB(LV-1)
              CP_GL(I,IS,1) = CP_GL(I,IS,1) + CP_GL(I,IS,L)*DGLRAT
              HK_GL(I,IS,1) = HK_GL(I,IS,1) + HK_GL(I,IS,L)*DGLRAT
ccc              MD_GL(I,IS,1) = MD_GL(I,IS,1) + MD_GL(I,IS,L)*DGLRAT
ccc              ST_GL(I,IS,1) = ST_GL(I,IS,1) + ST_GL(I,IS,L)*DGLRAT
 1042       CONTINUE
 104      CONTINUE
 10     CONTINUE
C
C
C------ set final sensitivities
        IF(LALFA.EQ.LV) THEN
C
         DO 20 IS=1, 2*NBL
           N = (IS+1)/2
           DO 202 I=ILEB(N), II-1
             CP_ALFA(I,IS) = CP_GL(I,IS,1)
             HK_ALFA(I,IS) = HK_GL(I,IS,1)
ccc             MD_ALFA(I,IS) = MD_GL(I,IS,1)
ccc             ST_ALFA(I,IS) = ST_GL(I,IS,1)
 202       CONTINUE
 20      CONTINUE
C
        ELSE IF(LMASS.EQ.LV) THEN
C
         DO 30 IS=1, 2*NBL
           N = (IS+1)/2
           DO 302 I=ILEB(N), II-1
             CP_MINF(I,IS) = CP_GL(I,IS,1)*MS_MINF
             HK_MINF(I,IS) = HK_GL(I,IS,1)*MS_MINF
ccc             MD_MINF(I,IS) = MD_GL(I,IS,1)*MS_MINF
ccc             ST_MINF(I,IS) = ST_GL(I,IS,1)*MS_MINF
 302       CONTINUE
 30      CONTINUE
C
        ELSE IF(LREYN.EQ.LV) THEN
C
         DO 40 IS=1, 2*NBL
           N = (IS+1)/2
           DO 402 I=ILEB(N), II-1
             CP_RINF(I,IS) = CP_GL(I,IS,1)
             HK_RINF(I,IS) = HK_GL(I,IS,1)
ccc             MD_RINF(I,IS) = MD_GL(I,IS,1)
ccc             ST_RINF(I,IS) = ST_GL(I,IS,1)
 402       CONTINUE
 40      CONTINUE
C
        ENDIF
C
C
        DO 50 NN=1, NMODN
          K = KMODN(NN)
          IF(LMODN(K).EQ.LV) THEN
            DO 505 IS=1, 2*NBL
              N = (IS+1)/2
              DO 5052 I=ILEB(N), II-1
                CP_MOD(I,IS,K) = CP_GL(I,IS,1)
                HK_MOD(I,IS,K) = HK_GL(I,IS,1)
ccc                MD_MOD(I,IS,K) = MD_GL(I,IS,1)
ccc                ST_MOD(I,IS,K) = ST_GL(I,IS,1)
 5052         CONTINUE
 505        CONTINUE
            GO TO 51
          ENDIF
 50     CONTINUE
 51     CONTINUE
C
C
        DO 60 NN=1, NPOSN
          K = KPOSN(NN)
          IF(LPOSN(K).EQ.LV) THEN
            DO 605 IS=1, 2*NBL
              N = (IS+1)/2
              DO 6052 I=ILEB(N), II-1
                CP_POS(I,IS,K) = CP_GL(I,IS,1)
                HK_POS(I,IS,K) = HK_GL(I,IS,1)
ccc                MD_POS(I,IS,K) = MD_GL(I,IS,1)
ccc                ST_POS(I,IS,K) = ST_GL(I,IS,1)
 6052         CONTINUE
 605        CONTINUE
            GO TO 61
          ENDIF
 60     CONTINUE
 61     CONTINUE
C
 1000 CONTINUE      
C
      RETURN
      END


      SUBROUTINE LCALC
C--------------------------------------------------------
C     Calculates current pressure and friction forces.
C     Also calculates the sensitivity of lift and moment
C     with respect to all global variables.
C--------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ BLIFT_GL(0:NGLX,NBX),
ccc     &             BMOMN_GL(0:NGLX,NBX),
ccc     &             BDRAGF_GL(0:NGLX,NBX),
ccc     &             PM1_GL(0:NGLX), PM2_GL(0:NGLX),
ccc     &             PO1_GL(0:NGLX), PO2_GL(0:NGLX),
ccc     &             PITE_GL(0:NGLX),
ccc     &             TAUMS_GL(0:NGLX), TAUMP_GL(0:NGLX),
ccc     &             TAUOS_GL(0:NGLX), TAUOP_GL(0:NGLX),
ccc     &             DP1_M1(NBX), DP1_NG(NBX), DP1_NP(NPOSX),
ccc     &             DP2_M1(NBX), DP2_NG(NBX), DP2_NP(NPOSX)
      DIMENSION BLIFT_GL(0:NGLX,NBX),
     &          BMOMN_GL(0:NGLX,NBX),
     &          BDRAGF_GL(0:NGLX,NBX),
     &          PM1_GL(0:NGLX), PM2_GL(0:NGLX),
     &          PO1_GL(0:NGLX), PO2_GL(0:NGLX),
     &          PITE_GL(0:NGLX),
     &          TAUMS_GL(0:NGLX), TAUMP_GL(0:NGLX),
     &          TAUOS_GL(0:NGLX), TAUOP_GL(0:NGLX),
     &          DP1_M1(NBX), DP1_NG(NBX), DP1_NP(NPOSX),
     &          DP2_M1(NBX), DP2_NG(NBX), DP2_NP(NPOSX)
C
C---- coordinates for moment reference point
      XMOMNT = 0.25
      YMOMNT = 0.0
C
      COSA = COS(ALFA)
      SINA = SIN(ALFA)
C
C---- zero out for accumulation over elements
      LIFT = 0.0
      MOMN = 0.0
      DRAG = 0.0
      DRAGF = 0.0
      DO 2 L=0, NGLX
        LIFT_GL(L) = 0.0
        MOMN_GL(L) = 0.0
        DRAGF_GL(L) = 0.0
    2 CONTINUE
C
C---- go over elements ...
      DO 100 N = 1, NBL
C
        ILE = ILEB(N)
        ITE = ITEB(N)
        J1 = JS1(N)
        J2 = JS2(N)
        I1 = IS1(N)
        I2 = IS2(N)
C
        BLIFT(N) = 0.
        BMOMN(N) = 0.
        BDRAG(N) = 0.
        BDRAGF(N) = 0.
C
        DO 5 L=0, NGLX
          BLIFT_GL(L,N) = 0.0
          BMOMN_GL(L,N) = 0.0
          BDRAGF_GL(L,N) = 0.0
    5   CONTINUE
C
C
C------ set trailing edge pressure and sensitivities
        CALL PWLIN(ITE,N,PO1,PO2,PO1_GL,PO2_GL,.TRUE.)
        PITE = 0.5*(PO1 + PO2)
        DO 10 L=1, NRHS
          PITE_GL(L) = 0.5*(PO1_GL(L) + PO2_GL(L))
   10   CONTINUE
        PITE_GL(0) = 0.
C
C------ set LE arc lengths, coordinates, and pressure sensitivities
        SOS = SBLE(N)
        SOP = SBLE(N)
C
        XMS = SEVAL(SOS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YMS = SEVAL(SOS,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
        XMP = SEVAL(SOP,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YMP = SEVAL(SOP,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
        XMSD = DEVAL(SOS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YMSD = DEVAL(SOS,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
        XMPD = DEVAL(SOP,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YMPD = DEVAL(SOP,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
        CALL PWLIN(ILE,N,PM1,PM2,PM1_GL,PM2_GL,.TRUE.)
C
        DO 20 L=1, NRHS
          TAUMS_GL(L) = 0.0
          TAUMP_GL(L) = 0.0
   20   CONTINUE
C
C------ go over element surface points, summing delta-p contributions
        DO 50 IO=ILE+1, ITE
          IM = IO-1
C
          IG = IO-ILE+1
          SOS = SBLE(N) + (SB(1     ,N)-SBLE(N))*SG(IG,I1)
          SOP = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,I2)
C
          XOS = SEVAL(SOS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YOS = SEVAL(SOS,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          XOP = SEVAL(SOP,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YOP = SEVAL(SOP,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
          XOSD = DEVAL(SOS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YOSD = DEVAL(SOS,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          XOPD = DEVAL(SOP,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YOPD = DEVAL(SOP,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
          BXS = XOS - XMS
          BYS = YOS - YMS
          BXP = XOP - XMP
          BYP = YOP - YMP
C    
          BXS_SL = NXG(IO,J1,N) - NXG(IM,J1,N)
          BYS_SL = NYG(IO,J1,N) - NYG(IM,J1,N)
          BXP_SL = NXG(IO,J2,N) - NXG(IM,J2,N)
          BYP_SL = NYG(IO,J2,N) - NYG(IM,J2,N)
C
          CALL PWLIN(IO,N,PO1,PO2,PO1_GL,PO2_GL,.TRUE.)
C
          PIS = 0.5*(PM1 + PO1) - PITE
          PIP = 0.5*(PM2 + PO2) - PITE
C
          XBARS = 0.5*(XOS+XMS) - XMOMNT
          YBARS = 0.5*(YOS+YMS) - YMOMNT
          XBARP = 0.5*(XOP+XMP) - XMOMNT
          YBARP = 0.5*(YOP+YMP) - YMOMNT
C
          XBARS_SL = 0.5*(NXG(IO,J1,N)+NXG(IM,J1,N))
          YBARS_SL = 0.5*(NYG(IO,J1,N)+NYG(IM,J1,N))
          XBARP_SL = 0.5*(NXG(IO,J2,N)+NXG(IM,J2,N))
          YBARP_SL = 0.5*(NYG(IO,J2,N)+NYG(IM,J2,N))
C
C
          BLIFT(N) = BLIFT(N) + (BXP*PIP - BXS*PIS)*COSA
     &                        + (BYP*PIP - BYS*PIS)*SINA
          BLIFT_GL(LALFA,N) = BLIFT_GL(LALFA,N)
     &                        - (BXP*PIP - BXS*PIS)*SINA
     &                        + (BYP*PIP - BYS*PIS)*COSA
          BLIFT_GL(LSBLE(N),N) = BLIFT_GL(LSBLE(N),N)
     &                        + (BXP_SL*PIP - BXS_SL*PIS)*COSA
     &                        + (BYP_SL*PIP - BYS_SL*PIS)*SINA
C
          BMOMN(N) = BMOMN(N) + (BXS*PIS*XBARS - BXP*PIP*XBARP)
     &                        + (BYS*PIS*YBARS - BYP*PIP*YBARP)
          BMOMN_GL(LSBLE(N),N) = BMOMN_GL(LSBLE(N),N)
     &                        + (BXS_SL*PIS*XBARS - BXP_SL*PIP*XBARP)
     &                        + (BYS_SL*PIS*YBARS - BYP_SL*PIP*YBARP)
     &                        + (BXS*PIS*XBARS_SL - BXP*PIP*XBARP_SL)
     &                        + (BYS*PIS*YBARS_SL - BYP*PIP*YBARP_SL)
C
          BDRAG(N) = BDRAG(N) + (BYS*PIS - BYP*PIP)*COSA 
     &                        + (BXP*PIP - BXS*PIS)*SINA
C
C-------- forces due to viscous shear stress
          TAUS = 0.5*(TAU(IO,I1)+TAU(IM,I1))
          TAUP = 0.5*(TAU(IO,I2)+TAU(IM,I2))
C
          BDRAGF(N) = BDRAGF(N) + (BXS*TAUS + BXP*TAUP)*COSA
     &                          + (BYS*TAUS + BYP*TAUP)*SINA
          BDRAGF_GL(LALFA,N) = BDRAGF_GL(LALFA,N)
     &                          - (BXS*TAUS + BXP*TAUP)*SINA
     &                          + (BYS*TAUS + BYP*TAUP)*COSA
          BDRAGF_GL(LSBLE(N),N) = BDRAGF_GL(LSBLE(N),N)
     &                          + (BXS_SL*TAUS + BXP_SL*TAUP)*COSA
     &                          + (BYS_SL*TAUS + BYP_SL*TAUP)*SINA
C
          DO 506 NN=1, NMODN
            K = KMODN(NN)
C
            BXS_MOD = GN(K,IG,I1)*BNX(IO,I1) - GN(K,IG-1,I1)*BNX(IM,I1)
            BYS_MOD = GN(K,IG,I1)*BNY(IO,I1) - GN(K,IG-1,I1)*BNY(IM,I1)
            BXP_MOD = GN(K,IG,I2)*BNX(IO,I2) - GN(K,IG-1,I2)*BNX(IM,I2)
            BYP_MOD = GN(K,IG,I2)*BNY(IO,I2) - GN(K,IG-1,I2)*BNY(IM,I2)
C
            XBARS_MOD = 0.5*( GN(K,IG  ,I1)*BNX(IO,I1)
     &                      + GN(K,IG-1,I1)*BNX(IM,I1) )
            YBARS_MOD = 0.5*( GN(K,IG  ,I1)*BNY(IO,I1)
     &                      + GN(K,IG-1,I1)*BNY(IM,I1) )
            XBARP_MOD = 0.5*( GN(K,IG  ,I2)*BNX(IO,I2)
     &                      + GN(K,IG-1,I2)*BNX(IM,I2) )
            YBARP_MOD = 0.5*( GN(K,IG  ,I2)*BNY(IO,I2)
     &                      + GN(K,IG-1,I2)*BNY(IM,I2) )
C
            BLIFT_GL(LMODN(K),N) = BLIFT_GL(LMODN(K),N)
     &                        + (BXP_MOD*PIP - BXS_MOD*PIS)*COSA
     &                        + (BYP_MOD*PIP - BYS_MOD*PIS)*SINA
            BMOMN_GL(LMODN(K),N) = BMOMN_GL(LMODN(K),N)
     &                        + (BXS_MOD*PIS*XBARS - BXP_MOD*PIP*XBARP)
     &                        + (BYS_MOD*PIS*YBARS - BYP_MOD*PIP*YBARP)
     &                        + (BXS*PIS*XBARS_MOD - BXP*PIP*XBARP_MOD)
     &                        + (BYS*PIS*YBARS_MOD - BYP*PIP*YBARP_MOD)
            BDRAGF_GL(LMODN(K),N) = BDRAGF_GL(LMODN(K),N)
     &                        + (BXS_MOD*TAUS + BXP_MOD*TAUP)*COSA
     &                        + (BYS_MOD*TAUS + BYP_MOD*TAUP)*SINA
 506      CONTINUE
C
C
          DO 507 NN=1, NPOSN
            K = KPOSN(NN)
C
            SMS_POS = (SB(1     ,N)-SBLE(N))*SGSRFP(IG-1,I1,K)
            SMP_POS = (SB(IIB(N),N)-SBLE(N))*SGSRFP(IG-1,I2,K)
C
            SOS_POS = (SB(1     ,N)-SBLE(N))*SGSRFP(IG  ,I1,K)
            SOP_POS = (SB(IIB(N),N)-SBLE(N))*SGSRFP(IG  ,I2,K)
C
            BXS_POS = NXP(IO,J1,K) - NXP(IM,J1,K)
            BYS_POS = NYP(IO,J1,K) - NYP(IM,J1,K)
            BXP_POS = NXP(IO,J2,K) - NXP(IM,J2,K)
            BYP_POS = NYP(IO,J2,K) - NYP(IM,J2,K)
C
            BXS_POS = BXS_POS + XOSD*SOS_POS - XMSD*SMS_POS
            BYS_POS = BYS_POS + YOSD*SOS_POS - YMSD*SMS_POS
            BXP_POS = BXP_POS + XOPD*SOP_POS - XMPD*SMP_POS
            BYP_POS = BYP_POS + YOPD*SOP_POS - YMPD*SMP_POS
C 
            XBARS_POS = 0.5*(NXP(IO,J1,K)+NXP(IM,J1,K))
            YBARS_POS = 0.5*(NYP(IO,J1,K)+NYP(IM,J1,K))
            XBARP_POS = 0.5*(NXP(IO,J2,K)+NXP(IM,J2,K))
            YBARP_POS = 0.5*(NYP(IO,J2,K)+NYP(IM,J2,K))
C
            XBARS_POS = XBARS_POS + 0.5*(XOSD*SOS_POS + XMSD*SMS_POS)
            YBARS_POS = YBARS_POS + 0.5*(YOSD*SOS_POS + YMSD*SMS_POS)
            XBARP_POS = XBARP_POS + 0.5*(XOPD*SOP_POS + XMPD*SMP_POS)
            YBARP_POS = YBARP_POS + 0.5*(YOPD*SOP_POS + YMPD*SMP_POS)
C 
C
            BLIFT_GL(LPOSN(K),N) = BLIFT_GL(LPOSN(K),N)
     &                        + (BXP_POS*PIP - BXS_POS*PIS)*COSA
     &                        + (BYP_POS*PIP - BYS_POS*PIS)*SINA
            BMOMN_GL(LPOSN(K),N) = BMOMN_GL(LPOSN(K),N)
     &                        + (BXS_POS*PIS*XBARS - BXP_POS*PIP*XBARP)
     &                        + (BYS_POS*PIS*YBARS - BYP_POS*PIP*YBARP)
     &                        + (BXS*PIS*XBARS_POS - BXP*PIP*XBARP_POS)
     &                        + (BYS*PIS*YBARS_POS - BYP*PIP*YBARP_POS)
            BDRAGF_GL(LPOSN(K),N) = BDRAGF_GL(LPOSN(K),N)
     &                        + (BXS_POS*TAUS + BXP_POS*TAUP)*COSA
     &                        + (BYS_POS*TAUS + BYP_POS*TAUP)*SINA
 507      CONTINUE 
C
          BXS_AL = NXA(IO,J1) - NXA(IM,J1)
          BYS_AL = NYA(IO,J1) - NYA(IM,J1)
          BXP_AL = NXA(IO,J2) - NXA(IM,J2)
          BYP_AL = NYA(IO,J2) - NYA(IM,J2)
          BLIFT_GL(LALFA,N) = BLIFT_GL(LALFA,N)
     &                   + (BXP_AL*PIP - BXS_AL*PIS)*COSA
     &                   + (BYP_AL*PIP - BYS_AL*PIS)*SINA
          BDRAGF_GL(LALFA,N) = BDRAGF_GL(LALFA,N)
     &                   + (BXS_AL*TAUS + BXP_AL*TAUP)*COSA
     &                   + (BYS_AL*TAUS + BYP_AL*TAUP)*SINA
C
          CALL TAULIN(IO,I1,TAUOS_GL)
          CALL TAULIN(IO,I2,TAUOP_GL)
C
          DO 508 L=1, NRHS
            PIS_GL = 0.5*(PM1_GL(L) + PO1_GL(L)) - PITE_GL(L)
            PIP_GL = 0.5*(PM2_GL(L) + PO2_GL(L)) - PITE_GL(L)
            BLIFT_GL(L,N) = BLIFT_GL(L,N)
     &                   + (BXP*PIP_GL - BXS*PIS_GL)*COSA
     &                   + (BYP*PIP_GL - BYS*PIS_GL)*SINA
            BMOMN_GL(L,N) = BMOMN_GL(L,N)
     &                   + (BXS*PIS_GL*XBARS - BXP*PIP_GL*XBARP)
     &                   + (BYS*PIS_GL*YBARS - BYP*PIP_GL*YBARP)
C
            TAUS_GL = 0.5*(TAUOS_GL(L) + TAUMS_GL(L))
            TAUP_GL = 0.5*(TAUOP_GL(L) + TAUMP_GL(L))
            BDRAGF_GL(L,N) = BDRAGF_GL(L,N)
     &                   + (BXS*TAUS_GL + BXP*TAUP_GL)*COSA
     &                   + (BYS*TAUS_GL + BYP*TAUP_GL)*SINA
 508      CONTINUE
C
          XMS = XOS
          YMS = YOS
          XMP = XOP
          YMP = YOP
C
          XMSD = XOSD
          YMSD = YOSD
          XMPD = XOPD
          YMPD = YOPD
C
          PM1 = PO1
          PM2 = PO2
          DO 509 L=1, NRHS
            PM1_GL(L) = PO1_GL(L)
            PM2_GL(L) = PO2_GL(L)
            TAUMS_GL(L) = TAUOS_GL(L)
            TAUMP_GL(L) = TAUOP_GL(L)
 509      CONTINUE
C
 50     CONTINUE
C
        LIFT = LIFT + BLIFT(N)
        MOMN = MOMN + BMOMN(N)
        DRAG = DRAG + BDRAG(N)
        DRAGF = DRAGF + BDRAGF(N)
        DO 80 L=1, NRHS
          LIFT_GL(L) = LIFT_GL(L) + BLIFT_GL(L,N)
          MOMN_GL(L) = MOMN_GL(L) + BMOMN_GL(L,N)
          DRAGF_GL(L) = DRAGF_GL(L) + BDRAGF_GL(L,N)
   80   CONTINUE
C
  100 CONTINUE      
C
      RETURN
      END ! LCALC


      SUBROUTINE DVCALC
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION PW1_GL(0:NGLX), PW2_GL(0:NGLX)
C
C--------------------------------------------
C     Calculates viscous drag and its
C     derivatives wrt global dofs.
C--------------------------------------------
C
      DRAGV = 0.0
      DO 5 L=0, NGLX
        DRAGV_GL(L) = 0.0
    5 CONTINUE
C
      IF(INITBL.EQ.0) RETURN
C
      I = II-1
C
      DO 100 N = 1, NBL
C
        BDRAGV(N) = 0.0
C
        CALL PWLIN(I,N,PW1,PW2,PW1_GL,PW2_GL,.FALSE.)
C
        DO 40 KS=1, 2
C
          IF(KS.EQ.1) THEN
           J = JS1(N)
           JO = JS1(N)
           JP = JS1(N)+1
           IS = IS1(N)
           KT = 2*JJ-1 + 6*(N-1) + 2
           KD = 2*JJ-1 + 6*(N-1) + 3
           PE = PW1 + PSTOUT
          ELSE
           J = JS2(N)
           JO = JS2(N)-1
           JP = JS2(N)
           IS = IS2(N)
           KT = 2*JJ-1 + 6*(N-1) + 5
           KD = 2*JJ-1 + 6*(N-1) + 6
           PE = PW2 + PSTOUT
          ENDIF
C
          JZ = JO+JJ
C
C-------- density, velocity, etc. at domain exit
CCC           RE = RSTOUT*(1.0 - 0.5*UINV(I,IS)**2/HINF)**(1.0/GM1)  
          RE = RHOI(I,IS)
          UE = UINV(I,IS)
          TH = THET(I,IS)
          DS = DSTR(I,IS)
C
C-------- momentum defect at domain exit
          MDEF    = RE*UE**2 * TH
          MDEF_RE =    UE**2 * TH
          MDEF_UE = RE*UE*2.0* TH
          MDEF_TH = RE*UE**2
C 
C-------- shape parameter far downstream (from Whitfield H-Hk correlation)
          HFF = 1.0 + 0.4*MINF**2
          HFF_MSQ   = 0.4
C
C-------- usual velocity-based Squire-Young formula
ccc          EXH = 0.5*(DS/TH + HFF)
ccc          BDV = MDEF * (UE/QINF)**EXH
C
C-------- Squire-Young formula based on pressure rather than velocity
          EXH     = 0.5*( DS/TH    + HFF) / (GAM*MINF**2)
          EXH_TH  = 0.5*(-DS/TH**2      ) / (GAM*MINF**2)
          EXH_DS  = 0.5*(1.0/TH         ) / (GAM*MINF**2)
          EXH_MSQ = 0.5*(        HFF_MSQ) / (GAM*MINF**2) - EXH/MINF**2
C
          BDV = MDEF * (PINF/PE)**EXH
C
          BDV_MDEF =   (PINF/PE)**EXH
          BDV_EXH = LOG(PINF/PE) * BDV
C
          BDV_PINF = EXH*BDV / PINF
C
          BDV_MSQ = BDV_EXH*EXH_MSQ
     &            + BDV_PINF*PI_MSQ
C
C-------- set final derivatives for BDV( P R U T D m )
          BDV_PE = -EXH*BDV / PE
          BDV_RE = BDV_MDEF*MDEF_RE
          BDV_UE = BDV_MDEF*MDEF_UE
          BDV_TH = BDV_MDEF*MDEF_TH + BDV_EXH*EXH_TH
          BDV_DS =                    BDV_EXH*EXH_DS
C
          BDV_MS = BDV_MSQ/MS_MSQ
C
C
          BDRAGV(N) = BDRAGV(N) + BDV
          DRAGV     = DRAGV     + BDV
C
          IF(KS.EQ.1) THEN
            DO 11 L=1, NRHS
              DRAGV_GL(L) = DRAGV_GL(L) + BDV_PE*PW1_GL(L)
 11         CONTINUE
          ELSE
            DO 12 L=1, NRHS
              DRAGV_GL(L) = DRAGV_GL(L) + BDV_PE*PW2_GL(L)
 12         CONTINUE
          ENDIF
C
          DRAGV_GL(LMASS) = DRAGV_GL(LMASS) + BDV_MS
C
C
          DO 32 L=1, NRHS
            DRAGV_GL(L) = DRAGV_GL(L) + BDV_TH * (-DR(KT,L,I))
     &                                + BDV_DS * (-DR(KD,L,I))
C
            DUSUM = DUIDR1(I,IS)*DR(JZ,L,I-1)
     &            + DUIDR2(I,IS)*DR(JZ,L,I)
     &         + DUIN1M(I,IS)*DR(JO,L,I-1) + DUIN1P(I,IS)*DR(JP,L,I-1)
     &         + DUIN2M(I,IS)*DR(JO,L,I  ) + DUIN2P(I,IS)*DR(JP,L,I  )
     &         + DUIN3M(I,IS)*DR(JO,L,I+1) + DUIN3P(I,IS)*DR(JP,L,I+1)
            DRAGV_GL(L) = DRAGV_GL(L) + BDV_UE*(-DUSUM)
C
            DRSUM = DRHDR1(I,IS)*DR(JZ,L,I-1)
     &            + DRHDR2(I,IS)*DR(JZ,L,I)
     &         + DRHN1M(I,IS)*DR(JO,L,I-1) + DRHN1P(I,IS)*DR(JP,L,I-1)
     &         + DRHN2M(I,IS)*DR(JO,L,I  ) + DRHN2P(I,IS)*DR(JP,L,I  )
     &         + DRHN3M(I,IS)*DR(JO,L,I+1) + DRHN3P(I,IS)*DR(JP,L,I+1)
            DRSUM = DRHDR1(I,IS)*DR(JZ,L,I-1)
     &            + DRHDR2(I,IS)*DR(JZ,L,I  )
            DRAGV_GL(L) = DRAGV_GL(L) + BDV_RE*(-DRSUM)
   32     CONTINUE
C
          DRAGV_GL(LMASS) = DRAGV_GL(LMASS) + BDV_UE*DUIDMS(I,IS)
     &                                      + BDV_RE*DRHDMS(I,IS)
          DRAGV_GL(LALFA) = DRAGV_GL(LALFA) + BDV_UE*DUIDAL(I,IS)
     &                                      + BDV_RE*DRHDAL(I,IS)
C
          DO 34 NN = 1, NBL
            DRAGV_GL(LSBLE(NN)) = DRAGV_GL(LSBLE(NN))
     &                          + BDV_UE*DUIDNG(I,IS,NN)
     &                          + BDV_RE*DRHDNG(I,IS,NN)
            DRAGV_GL(LMAS1(NN)) = DRAGV_GL(LMAS1(NN))
     &                          + BDV_UE*DUIDM1(I,IS,NN)
     &                          + BDV_RE*DRHDM1(I,IS,NN)
   34     CONTINUE
          DO 36 NN = 1, NPOSN
            K = KPOSN(NN)
            DRAGV_GL(LPOSN(K)) = DRAGV_GL(LPOSN(K))
     &                         + BDV_UE*DUIDNP(I,IS,K)
     &                         + BDV_RE*DRHDNP(I,IS,K)
   36     CONTINUE
C
   40   CONTINUE
  100 CONTINUE
C
      RETURN
      END ! DVCALC


      SUBROUTINE DWCALC
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION U_GL(2,0:NGLX), UPL(2)
C
C--------------------------------------------
C     Calculates wave drag and its
C     derivatives wrt global dofs.
C--------------------------------------------
C
      DRAGW = 0.0
      DO 5 L=0, NGLX
        DRAGW_GL(L) = 0.0
    5 CONTINUE
C
      DO 50 L=0, NGLX
        U_GL(1,L) = 0.0
        U_GL(2,L) = 0.0
   50 CONTINUE
C
      PI_MS = PI_MSQ/MS_MSQ
C
      DO 200 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 200
C
        DO 701 IT=1, II-1
          MSQT = Q(IT,J)**2 / (GM1*(HINF - 0.5*Q(IT,J)**2))
          IF(MSQT.GE.1.0) GO TO 702
  701   CONTINUE
        GO TO 200
C    
  702   CONTINUE
        JO = J
        JP = J+1
        JZ = J+JJ
C
C------ go over inlet and exit plane
        DO 720 IPL=1, 2
C
        IF(IPL.EQ.1) THEN
         IO = 1
         IP = 2
        ELSE
         IO = II-1
         IP = II
        ENDIF
C
        SX1 = 0.5*(X(IP,JO) - X(IO,JO) + X(IP,JP) - X(IO,JP))
        SY1 = 0.5*(Y(IP,JO) - Y(IO,JO) + Y(IP,JP) - Y(IO,JP))
        S1INV = 1.0 / SQRT(SX1*SX1 + SY1*SY1)
        AX1 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
        AY1 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
        AN1 = (SX1*AY1 - SY1*AX1)*S1INV
C
        STMP = 0.5*S1INV
        AN1_S1 = -AN1*S1INV
C
        AN1_X1M = ( SY1-AY1  -  AN1_S1*SX1) * STMP
        AN1_Y1M = (-SX1+AX1  -  AN1_S1*SY1) * STMP
        AN1_X1P = (-SY1-AY1  -  AN1_S1*SX1) * STMP
        AN1_Y1P = ( SX1+AX1  -  AN1_S1*SY1) * STMP
        AN1_X2M = ( SY1+AY1  +  AN1_S1*SX1) * STMP
        AN1_Y2M = (-SX1-AX1  +  AN1_S1*SY1) * STMP
        AN1_X2P = (-SY1+AY1  +  AN1_S1*SX1) * STMP
        AN1_Y2P = ( SX1-AX1  +  AN1_S1*SY1) * STMP
C
        R1 = R(IO,JO)
        Q1 = M(JO)/(AN1*R1)
C
        Q1_R1  = -Q1/R1
        Q1_AN1 = -Q1/AN1
        Q1_MJ  =  Q1/M(JO)
C
        RST = R1 * (ABS(1.0 - 0.5*Q1*Q1/HINF))**(-1.0/GM1)
C
        RST_Q1 = RST * Q1/(GM1*(HINF - 0.5*Q1*Q1))
C
        RST_R1  = RST_Q1*Q1_R1   +  RST/R1
        RST_AN1 = RST_Q1*Q1_AN1
        RST_MJ  = RST_Q1*Q1_MJ
C
        RST_X1M = RST_AN1*AN1_X1M
        RST_Y1M = RST_AN1*AN1_Y1M
        RST_X1P = RST_AN1*AN1_X1P
        RST_Y1P = RST_AN1*AN1_Y1P
        RST_X2M = RST_AN1*AN1_X2M
        RST_Y2M = RST_AN1*AN1_Y2M
        RST_X2P = RST_AN1*AN1_X2P
        RST_Y2P = RST_AN1*AN1_Y2P
C
        RST_N1M = RST_X1M*NX(IO,JO) + RST_Y1M*NY(IO,JO)
        RST_N1P = RST_X1P*NX(IO,JP) + RST_Y1P*NY(IO,JP)
        RST_N2M = RST_X2M*NX(IP,JO) + RST_Y2M*NY(IP,JO)
        RST_N2P = RST_X2P*NX(IP,JP) + RST_Y2P*NY(IP,JP)
C
        RST_MS = RST_MJ * MF0(JO)
C
        PRATX = (PINF/(GCON*HINF*RST))**GCON
        UPL(IPL) = SQRT( ABS(2.0*HINF*(1.0 - PRATX)) )
        U_PINF = 0.5/UPL(IPL) * 2.0*HINF*(-GCON)*PRATX/PINF
        U_RST  = 0.5/UPL(IPL) * 2.0*HINF*( GCON)*PRATX/RST
C
        DO 710 L=1, NRHS
          U_GL(IPL,L) = U_RST*(- RST_R1 *DR(JZ,L,IO)
     &                         - RST_N1M*DR(JO,L,IO)
     &                         - RST_N1P*DR(JP,L,IO)
     &                         - RST_N2M*DR(JO,L,IP)
     &                         - RST_N2P*DR(JP,L,IP) )
  710   CONTINUE
C
        U_GL(IPL,LMASS) = U_GL(IPL,LMASS) + U_RST*RST_MS + U_PINF*PI_MS
C
        DO 712 N = 1, NBL
          RST_M1 = RST_MJ * MF1(JO,N)
          U_GL(IPL,LMAS1(N)) = U_GL(IPL,LMAS1(N)) + U_RST*RST_M1
C
          RST_NG = RST_X1M*NXG(IO,JO,N) + RST_Y1M*NYG(IO,JO,N)
     &           + RST_X1P*NXG(IO,JP,N) + RST_Y1P*NYG(IO,JP,N)
     &           + RST_X2M*NXG(IP,JO,N) + RST_Y2M*NYG(IP,JO,N)
     &           + RST_X2P*NXG(IP,JP,N) + RST_Y2P*NYG(IP,JP,N)
          U_GL(IPL,LSBLE(N)) = U_GL(IPL,LSBLE(N)) + U_RST*RST_NG
  712   CONTINUE
C    
        DO 715 NN = 1, NPOSN
          K = KPOSN(NN)
          RST_NP = RST_X1M*NXP(IO,JO,K) + RST_Y1M*NYP(IO,JO,K)
     &           + RST_X1P*NXP(IO,JP,K) + RST_Y1P*NYP(IO,JP,K)
     &           + RST_X2M*NXP(IP,JO,K) + RST_Y2M*NYP(IP,JO,K)
     &           + RST_X2P*NXP(IP,JP,K) + RST_Y2P*NYP(IP,JP,K)
          U_GL(IPL,LPOSN(K)) = U_GL(IPL,LPOSN(K)) + U_RST*RST_NP
  715   CONTINUE
C
        RST_AL = RST_X1M*NXA(IO,JO) + RST_Y1M*NYA(IO,JO)
     &         + RST_X1P*NXA(IO,JP) + RST_Y1P*NYA(IO,JP)
     &         + RST_X2M*NXA(IP,JO) + RST_Y2M*NYA(IP,JO)
     &         + RST_X2P*NXA(IP,JP) + RST_Y2P*NYA(IP,JP)
        U_GL(IPL,LALFA) = U_GL(IPL,LALFA) + U_RST*RST_AL
C    
  720   CONTINUE
C
C    
        DU = UPL(1) - UPL(2)
        DRAGW    = DU*M(JO) + DRAGW
        DRAGW_DU =    M(JO)
C
        DO 750 L=1, NRHS
          DRAGW_GL(L) = DRAGW_GL(L) + DRAGW_DU*(U_GL(1,L) - U_GL(2,L))
  750   CONTINUE
C
        DRAGW_GL(LMASS) = DRAGW_GL(LMASS) + DU*MF0(JO)
C
        DO 752 N = 1, NBL
          DRAGW_GL(LMAS1(N)) = DRAGW_GL(LMAS1(N)) + DU*MF1(JO,N)
  752   CONTINUE
C
  200 CONTINUE
C
      RETURN
      END ! DWCALC



      SUBROUTINE GEOSEN
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
C----------------------------------------------------------------------
C     Calculates element thicknesses THIKB(.), element areas AREAB(.), 
C     and their sensitivities of geometric to mode DOFs.
C----------------------------------------------------------------------
C
C---- overlay temporary work space to save storage space
ccc      COMMON/WORK/ SBSIDE(ISX), XBD(IX,ISX),YBD(IX,ISX)
      DIMENSION SBSIDE(ISX), XBD(IX,ISX),YBD(IX,ISX)
C
C---- set surface coordinates and spline derivatives for all elements
      DO 2 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
C
C------ go over both sides of this element
        DO 24 IS=IS1(N), IS2(N)
          J = JS1(N) - (IS-IS1(N))
C
C-------- element surface points
          DO 242 IG=1, NBLD(N)
            I = ILEB(N) + IG - 1
            SBI(I,IS) = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
            XBI(I,IS) = SEVAL(SBI(I,IS),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YBI(I,IS) = SEVAL(SBI(I,IS),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
            XBD(I,IS) = DEVAL(SBI(I,IS),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YBD(I,IS) = DEVAL(SBI(I,IS),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C---------- set outward unit normal components
            XN =  YBD(I,IS)/SQRT(XBD(I,IS)**2 + YBD(I,IS)**2)
            YN = -XBD(I,IS)/SQRT(XBD(I,IS)**2 + YBD(I,IS)**2)
C
C---------- set sensitivities to modal displacements
            DO 2423 NN=1, NMODN
              K = KMODN(NN)
              SBI_MOD(I,IS,K) = 0.0
              XBI_MOD(I,IS,K) = XN*GN(K,IG,IS)
              YBI_MOD(I,IS,K) = YN*GN(K,IG,IS)
 2423       CONTINUE
C
C---------- set sensitivities to element displacements
            DO 2425 NN=1, NPOSN
              K = KPOSN(NN)
              SBI_POS(I,IS,K) = SBSIDE(IS)*SGSRFP(IG,IS,K)
              XBI_POS(I,IS,K) = NXP(I,J,K) !!! + XBD(I,IS)*SBI_POS(I,IS,K)
              YBI_POS(I,IS,K) = NYP(I,J,K) !!! + YBD(I,IS)*SBI_POS(I,IS,K)
 2425       CONTINUE
 242      CONTINUE
C
C-------- wake points
          SBSGN = SIGN( 1.0 , SBSIDE(IS) )
          DO 244 IG=2, NOUT(N)-1
            I = ITEB(N) + IG - 1
            SBI(I,IS) = SBSGN*SWAK(N)*SGOUT(IG,N) + SBI(ITEB(N),IS)
            XBI(I,IS) = XW(IG,N)
            YBI(I,IS) = YW(IG,N)

C---------- set sensitivities to modal displacements
            DO 2443 NN=1, NMODN
              K = KMODN(NN)
              SBI_MOD(I,IS,K) = 0.0
              XBI_MOD(I,IS,K) = 0.0
              YBI_MOD(I,IS,K) = 0.0
 2443       CONTINUE
C
C---------- set sensitivities to element displacements
            DO 2445 NN=1, NPOSN
              K = KPOSN(NN)
              SBI_POS(I,IS,K) = SBSGN*SWAK(N)*SGOUTP(IG,N,K)
     &                        + SBI_POS(ITEB(N),IS,K)
              XBI_POS(I,IS,K) = XPW(IG,N)*SBI_POS(I,IS,K)
              YBI_POS(I,IS,K) = YPW(IG,N)*SBI_POS(I,IS,K)
 2445       CONTINUE
 244      CONTINUE
C
 24     CONTINUE
 2    CONTINUE
C
C
C---- go over all elements
      DO 4 N=1, NBL
C
      I1 = IS1(N)
      I2 = IS2(N)
C
C---- element chord line components
      XCH = XBTAIL(N) - XBNOSE(N)
      YCH = YBTAIL(N) - YBNOSE(N)
C
      THIKB(N) = 0.0
      DO 42 NN=1, NMODN
        K = KMODN(NN)
        THB_MOD(K,N) = 0.0
 42   CONTINUE
C
C---- go over surface points on side 1
      DO 44 IG1=2, NBLD(N)
        IO1 = ILEB(N) + IG1 - 1
C
C------ go over surface points on side 2, looking for opposite point
        DO 442 IG2=2, NBLD(N)
          IO2 = ILEB(N) + IG2 - 1
C
          DXBO = XBI(IO1,I1) - XBI(IO2  ,I2)
          DYBO = YBI(IO1,I1) - YBI(IO2  ,I2)
          DXBM = XBI(IO1,I1) - XBI(IO2-1,I2)
          DYBM = YBI(IO1,I1) - YBI(IO2-1,I2)
C
C-------- dot product with thickness segment and chord line is zero
          DPO = DXBO*XCH + DYBO*YCH
          DPM = DXBM*XCH + DYBM*YCH
C
          IF(DPO .LT. 0.0 .AND. DPM .GE. 0.0) GO TO 443
 442    CONTINUE
        GO TO 44
C
 443    CONTINUE
C
C------ interpolating weights to side 2 points bounding thickness segment
        FRACO = -DPM / (DPO - DPM)
        FRACM =  DPO / (DPO - DPM)
C
C------ thickness segment components
        DXB = XBI(IO1,I1) - (FRACO*XBI(IO2,I2) + FRACM*XBI(IO2-1,I2))
        DYB = YBI(IO1,I1) - (FRACO*YBI(IO2,I2) + FRACM*YBI(IO2-1,I2))
C
C------ local thickness
        THLOC = SQRT(DXB**2 + DYB**2)
C
C------ if this is the biggest so far, save it and its sensitivities
        IF(THLOC .GT. THIKB(N)) THEN
C
C------- set outward unit normal components
         XBD1 = XBD(IO1,I1)
         YBD1 = YBD(IO1,I1)
         XN1 =  YBD1/SQRT(XBD1**2 + YBD1**2)
         YN1 = -XBD1/SQRT(XBD1**2 + YBD1**2)
C
         XBD2 = FRACO*XBD(IO2,I2) + FRACM*XBD(IO2-1,I2)
         YBD2 = FRACO*YBD(IO2,I2) + FRACM*YBD(IO2-1,I2)
         XN2 =  YBD2/SQRT(XBD2**2 + YBD2**2)
         YN2 = -XBD2/SQRT(XBD2**2 + YBD2**2)
C
         DPN1 = (XN1*DXB + YN1*DYB) / THLOC
         DPN2 = (XN2*DXB + YN2*DYB) / THLOC
C
C------- save current max thickness and set sensitivities to mode DOFs
         THIKB(N) = THLOC
         DO 446 NN=1, NMODN
           K = KMODN(NN)
           THB_MOD(K,N) = DPN1*(  GN(K,IG1  ,I1)         )
     &                  - DPN2*(  GN(K,IG2  ,I2) * FRACO
     &                          + GN(K,IG2-1,I2) * FRACM )
 446     CONTINUE
C
        ENDIF
C
 44   CONTINUE
 4    CONTINUE
C
C
C---- go over elements, setting cross-sectional areas and sensitivities
      DO 6 N=1, NBL
C
        I1 = IS1(N)
        I2 = IS2(N)
C
        AREAB(N) = 0.0
        DO 60 NN=1, NMODN
          K = KMODN(NN)
          ARB_MOD(K,N) = 0.0
 60     CONTINUE
C
C------ go over both sides of this element
        DO 64 IS=IS1(N), IS2(N)
C
          SGN = 1.0
          IF(IS.EQ.IS2(N)) SGN = -1.0
C
C-------- go over surface points on this side
          DO 644 IG=2, NBLD(N)
            I = ILEB(N) + IG - 1
C
            XBDO = XBD(I,IS)
            YBDO = YBD(I,IS)
            XNO =  YBDO/SQRT(XBDO**2 + YBDO**2)
            YNO = -XBDO/SQRT(XBDO**2 + YBDO**2)
C
            XBDM = XBD(I-1,IS)
            YBDM = YBD(I-1,IS)
            XNM =  YBDM/SQRT(XBDM**2 + YBDM**2)
            YNM = -XBDM/SQRT(XBDM**2 + YBDM**2)
C
            YA = (YBI(I,IS) + YBI(I-1,IS))*0.5
            DX =  XBI(I,IS) - XBI(I-1,IS)
C
C---------- accumulate area and sensitivities
            AREAB(N) = AREAB(N) + SGN*YA*DX
            DO 6442 NN=1, NMODN
              K = KMODN(NN)
C
              YA_MOD = (YNO*GN(K,IG,IS) + YNM*GN(K,IG-1,IS))*0.5
              DX_MOD =  XNO*GN(K,IG,IS) - XNM*GN(K,IG-1,IS)
C
              ARB_MOD(K,N) = ARB_MOD(K,N)
     &                     + SGN*(YA*DX_MOD + YA_MOD*DX)
 6442       CONTINUE
 644      CONTINUE
 64     CONTINUE
 6    CONTINUE
C
      RETURN
      END ! GEOSEN



      SUBROUTINE CPCALC
C-------------------------------------------------------------
C     Calculates sensitivities of surface variables with 
C     respect to global variables using previously-calculated 
C     variable perturbation combos.
C-------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION TH_GL(0:NGLX), DS_GL(0:NGLX), UE_GL(0:NGLX)
      DIMENSION SBSIDE(ISX)
      DIMENSION PW(2),PW_GL(0:NGLX,2)
C
      DO 5 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
 5    CONTINUE
C
      DO 100 IS=1, 2*NBL
C
        N = (IS+1)/2
C
        ILE = ILEB(N)
        ITE = ITEB(N)
        I1 = IS1(N)
        I2 = IS2(N)
C
        IF(MOD(IS,2).EQ.1) THEN
         J = JS1(N)
         JO = J
         JP = J+1
         KS = 1
        ELSE
         J = JS2(N)
         JO = J-1
         JP = J
         KS = 2
        ENDIF
C
        THET(ILE,I1) = 0.5*(THET(ILE+1,I1) + THET(ILE+1,I2))
        DSTR(ILE,I1) = 0.5*(DSTR(ILE+1,I1) + DSTR(ILE+1,I2))
        THET(ILE,I2) = THET(ILE,I1)
        DSTR(ILE,I2) = DSTR(ILE,I1)
C
        DPINF = PINF - PSTOUT
        DO 20 IO=ILE, II-1
          IM = IO-1
          IP = IO+1
C
          CALL PWLIN(IO,N,PW(1),PW(2),PW_GL(0,1),PW_GL(0,2),.TRUE.)
C
          CP(IO,IS) = (PW(KS) - DPINF )/QU
          CP_PW     =  1.0             /QU
          CP_MSQ    = (       - PI_MSQ)/QU - (CP(IO,IS)/QU)*QU_MSQ
C
          CALL UEF(UINV(IO,IS), DUDN(IO,IS), THET(IO,IS), DSTR(IO,IS),
     &             WXUT, WXUD,
     &         UE, UE_UI, UE_UN, UE_TH, UE_DS)
C
          CP_GL(IO,IS,0) = 0.
ccc       ST_GL(IO,IS,0) = 0.
          TH_GL(0)       = 0.
          DS_GL(0)       = 0.
          UE_GL(0)       = 0.
          DO 202 L=1, NRHS
            CP_GL(IO,IS,L) = CP_PW*PW_GL(L,KS)
C
ccc         ST_GL(IO,IS,L) = -DR(2*JJ-3+3*IS,L,IO)
            TH_GL(L)       = -DR(2*JJ-2+3*IS,L,IO)
            DS_GL(L)       = -DR(2*JJ-1+3*IS,L,IO)
            UE_GL(L)       = -UE_UI
     &      *( DUIDR1(IO,IS)*DR(JO+JJ,L,IM)
     &       + DUIDR2(IO,IS)*DR(JO+JJ,L,IO)
     &       + DUIN1M(IO,IS)*DR(JO,L,IM) + DUIN1P(IO,IS)*DR(JP,L,IM)
     &       + DUIN2M(IO,IS)*DR(JO,L,IO) + DUIN2P(IO,IS)*DR(JP,L,IO)
     &       + DUIN3M(IO,IS)*DR(JO,L,IP) + DUIN3P(IO,IS)*DR(JP,L,IP))
     &                       -UE_UN
     &      *( DUNDR1(IO,IS)*DR(JO+JJ,L,IM)
     &       + DUNDR2(IO,IS)*DR(JO+JJ,L,IO)
     &       + DUNN1M(IO,IS)*DR(JO,L,IM) + DUNN1P(IO,IS)*DR(JP,L,IM)
     &       + DUNN2M(IO,IS)*DR(JO,L,IO) + DUNN2P(IO,IS)*DR(JP,L,IO)
     &       + DUNN3M(IO,IS)*DR(JO,L,IP) + DUNN3P(IO,IS)*DR(JP,L,IP))
     &                       -UE_TH*DR(2*JJ-2+3*IS,L,IO)
     &                       -UE_DS*DR(2*JJ-1+3*IS,L,IO)
 202      CONTINUE
C
          CP_GL(IO,IS,LMASS) = CP_GL(IO,IS,LMASS) + CP_MSQ/MS_MSQ
          UE_GL(LMASS) = UE_GL(LMASS) + UE_UI*DUIDMS(IO,IS)
     &                                + UE_UN*DUNDMS(IO,IS)
C
          DO 206 NN = 1, NBL
            UE_GL(LMAS1(NN)) = UE_GL(LMAS1(NN))
     &                       + UE_UI*DUIDM1(IO,IS,NN)
     &                       + UE_UN*DUNDM1(IO,IS,NN)
            UE_GL(LSBLE(NN)) = UE_GL(LSBLE(NN))
     &                       + UE_UI*DUIDNG(IO,IS,NN)
     &                       + UE_UN*DUNDNG(IO,IS,NN)
 206      CONTINUE
C
          DO 208 NN = 1, NPOSN
            K = KPOSN(NN)
            UE_GL(LPOSN(K)) = UE_GL(LPOSN(K))
     &                      + UE_UI*DUIDNP(IO,IS,K)
     &                      + UE_UN*DUNDNP(IO,IS,K)
 208      CONTINUE
C
          UE_GL(LALFA) = UE_GL(LALFA)
     &                 + UE_UI*DUIDAL(IO,IS)
     &                 + UE_UN*DUNDAL(IO,IS)
C
ccc          MD(IO,IS) = THET(IO,IS)*UEDG(IO,IS)**2/QINF**2
ccc          MD_TH     =             UEDG(IO,IS)**2/QINF**2
ccc          MD_UE     = THET(IO,IS)*UEDG(IO,IS)*2./QINF**2
ccc          MD_MSQ    = -2.0*MD(IO,IS)/QINF * QI_MSQ
C
          M2    = UEDG(IO,IS)**2 / (GM1*(HINF-0.5*UEDG(IO,IS)**2))
          M2_UE = UEDG(IO,IS)    / (GM1*(HINF-0.5*UEDG(IO,IS)**2))
     &          * (2.0 + GM1*M2)
C
          IF(LVISC) THEN
C
           HH = DSTR(IO,IS)/THET(IO,IS)
           HH_TH = -HH/THET(IO,IS)
           HH_DS = 1.0/THET(IO,IS)
C
           CALL HKIN( HH, M2, GAM,  HK(IO,IS), HK_HH, HK_M2 )
           HK_TH = HK_HH*HH_TH
           HK_DS = HK_HH*HH_DS
           HK_UE = HK_M2*M2_UE
C
          ELSE
C
           HK(IO,IS) = 1.0
           HK_TH = 0.0
           HK_DS = 0.0
           HK_UE = 0.0
C
          ENDIF
C
          DO 212 L=1, NRHS
ccc         MD_GL(IO,IS,L) = MD_TH*TH_GL(L) + MD_UE*UE_GL(L)
            HK_GL(IO,IS,L) = HK_TH*TH_GL(L) + HK_UE*UE_GL(L)
     &                     + HK_DS*DS_GL(L)
 212      CONTINUE
C
ccc          L = LMASS
ccc          MD_GL(IO,IS,L) = MD_MSQ/MS_MSQ
C
ccc          ST(IO,IS) = CTAU(IO,IS)
C
ccc          IF(IO.GE.ITRAN(IS)) THEN
ccc           ST(IO,IS) = 0.0
ccc           DO 214 L=1, NRHS
ccc             ST_GL(IO,IS,L) = 0.0
ccc 214       CONTINUE
ccc          ENDIF
C
 20     CONTINUE
C
 100  CONTINUE      
C
      RETURN
      END



      SUBROUTINE TAULIN(IO,IS,TAU_GL)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION TAU_GL(0:NGLX)
C
      I = IO
C
      N = (IS+1)/2
      IF(MOD(IS,2).EQ.0) THEN
        J = JS2(N)
      ELSE
        J = JS1(N)
      ENDIF
C
      CALL UEF(UINV(I,IS), DUDN(I,IS), THET(I,IS), DSTR(I,IS),
     &         WXUT, WXUD,
     &         UE, UE_UI, UE_UN, UE_TH, UE_DS)
      CALL RHF(RHOI(I,IS), UINV(I,IS), DUDN(I,IS),
     &                     THET(I,IS), DSTR(I,IS),
     &         WXUT, WXUD, HINF, GAM,
     &         RH, RH_RI, RH_UI, RH_UN, RH_TH, RH_DS)

C
      TAU_RI =                      TAU_RH(I,IS)*RH_RI
      TAU_UI = TAU_UE(I,IS)*UE_UI + TAU_RH(I,IS)*RH_UI
      TAU_UN = TAU_UE(I,IS)*UE_UN + TAU_RH(I,IS)*RH_UN
      TAU_TT = TAU_UE(I,IS)*UE_TH + TAU_RH(I,IS)*RH_TH
      TAU_DD = TAU_UE(I,IS)*UE_DS + TAU_RH(I,IS)*RH_DS
C
      TAU_GL(0) = 0.
C
      DO 501 L=1, NRHS
        UISUM = DUIDR1(I,IS)*DR(J+JJ,L,I-1)
     &        + DUIDR2(I,IS)*DR(J+JJ,L,I  )
     &        + DUIN1M(I,IS)*DR(J  ,L,I-1)
     &        + DUIN2M(I,IS)*DR(J  ,L,I  )
     &        + DUIN3M(I,IS)*DR(J  ,L,I+1)
     &        + DUIN1P(I,IS)*DR(J+1,L,I-1)
     &        + DUIN2P(I,IS)*DR(J+1,L,I  )
     &        + DUIN3P(I,IS)*DR(J+1,L,I+1)
        RISUM = DRHDR1(I,IS)*DR(J+JJ,L,I-1)
     &        + DRHDR2(I,IS)*DR(J+JJ,L,I  )
     &        + DRHN1M(I,IS)*DR(J  ,L,I-1)
     &        + DRHN2M(I,IS)*DR(J  ,L,I  )
     &        + DRHN3M(I,IS)*DR(J  ,L,I+1)
     &        + DRHN1P(I,IS)*DR(J+1,L,I-1)
     &        + DRHN2P(I,IS)*DR(J+1,L,I  )
     &        + DRHN3P(I,IS)*DR(J+1,L,I+1)
        UNSUM = DUNDR1(I,IS)*DR(J+JJ,L,I-1)
     &        + DUNDR2(I,IS)*DR(J+JJ,L,I  )
     &        + DUNN1M(I,IS)*DR(J  ,L,I-1)
     &        + DUNN2M(I,IS)*DR(J  ,L,I  )
     &        + DUNN3M(I,IS)*DR(J  ,L,I+1)
     &        + DUNN1P(I,IS)*DR(J+1,L,I-1)
     &        + DUNN2P(I,IS)*DR(J+1,L,I  )
     &        + DUNN3P(I,IS)*DR(J+1,L,I+1)
        TAU_GL(L) = -( TAU_TH(I,IS)*DR(2*JJ-2+3*IS,L,I)
     &               + TAU_TT      *DR(2*JJ-2+3*IS,L,I)
     &               + TAU_DS(I,IS)*DR(2*JJ-1+3*IS,L,I)
     &               + TAU_DD      *DR(2*JJ-1+3*IS,L,I)
     &               + TAU_UI*UISUM
     &               + TAU_RI*RISUM
     &               + TAU_UN*UNSUM )
 501  CONTINUE
C
      TAU_GL(LMASS) = TAU_GL(LMASS) + TAU_UI*DUIDMS(I,IS)
     &                              + TAU_RI*DRHDMS(I,IS)
     &                              + TAU_UN*DUNDMS(I,IS)
C
      DO 503 N=1, NBL
        TAU_GL(LSBLE(N)) = TAU_GL(LSBLE(N)) + TAU_UI*DUIDNG(I,IS,N)
     &                                      + TAU_RI*DRHDNG(I,IS,N)
     &                                      + TAU_UN*DUNDNG(I,IS,N)
        TAU_GL(LMAS1(N)) = TAU_GL(LMAS1(N)) + TAU_UI*DUIDM1(I,IS,N)
     &                                      + TAU_RI*DRHDM1(I,IS,N)
     &                                      + TAU_UN*DUNDM1(I,IS,N)
 503  CONTINUE
C
      DO 504 NN = 1, NPOSN
        K = KPOSN(NN)
        TAU_GL(LPOSN(K)) = TAU_GL(LPOSN(K)) + TAU_UI*DUIDNP(I,IS,K)
     &                                      + TAU_RI*DRHDNP(I,IS,K)
     &                                      + TAU_UN*DUNDNP(I,IS,K)
 504  CONTINUE
C
      TAU_GL(LALFA) = TAU_GL(LALFA) + TAU_UI*DUIDAL(I,IS)
     &                              + TAU_RI*DRHDAL(I,IS)
     &                              + TAU_UN*DUNDAL(I,IS)
      TAU_GL(LREYN) = TAU_GL(LREYN) + TAU_RE(I,IS)
C
      TAU_GL(1) = TAU_GL(1) - TAU_UE(I,IS)*(UEDG(I,IS) - UE)
     &                      - TAU_RH(I,IS)*(RHOE(I,IS) - RH)
C
      RETURN
      END
