


      SUBROUTINE GNSET
C---------------------------------------------------------
C     Calls GMODES to set geometry displacement modes at 
C     current surface grid node positions.  The modes can 
C     be defined in terms of fractional arc length or x/c
C     (the option not used is commented out below).
C---------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      DIMENSION ST(IX,ISX)
C
      DO 100 N = 1, NBL
C
      ILE = ILEB(N)
      ITE = ITEB(N)
      I1 = IS1(N)
      I2 = IS2(N)
C
      DO 12 IG=1, NBLD(N)
        DO 11 K=1, NMODX
          GN(K,IG,I1) = 0.0
          GN(K,IG,I2) = 0.0
   11   CONTINUE
   12 CONTINUE
C
C
      DSBTOT = SB(IIB(N),N) - SB(1,N)
C
C---- option 1: s/smax defined from nose
      SBLEGN(N) = SBNOSE(N)
C
C---- option 2: s/smax defined from max-curvature point
ccc      SBLEGN(N) = SBCMAX(N)
C
C
      XB0 = SEVAL(SBLEGN(N),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
      YB0 = SEVAL(SBLEGN(N),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
      SBSID1 = SBLEGN(N)    - SB(1,N)
      SBSID2 = SB(IIB(N),N) - SBLEGN(N)
C
      CHRDX = XBTAIL(N) - XB0
      CHRDY = YBTAIL(N) - YB0
      CHRDSQ = CHRDX**2 + CHRDY**2
      XCN = CHRDX / CHRDSQ
      YCN = CHRDY / CHRDSQ
C
C---- 1/2 of LE grid spacing
      DSB = 0.125*DSBTOT*( SG(2,IS1(N)) - SG(1,IS1(N))
     &                   + SG(2,IS2(N)) - SG(1,IS2(N)) )
C
C---- calculate curvature at SBLEGN(N), averaging over several points
      NC = 3
      CVSUM = CURV(SBLEGN(N),XB(1,N),XPB(1,N),
     &                       YB(1,N),YPB(1,N),SB(1,N),IIB(N))
      DO 30 IC=1, NC
        SBCM = SBLEGN(N) - DSB*FLOAT(IC)
        SBCP = SBLEGN(N) + DSB*FLOAT(IC)
        CVSUM = CVSUM
     &        + 0.5*CURV(SBCM,XB(1,N),XPB(1,N),
     &                        YB(1,N),YPB(1,N),SB(1,N),IIB(N))
     &        + 0.5*CURV(SBCP,XB(1,N),XPB(1,N),
     &                        YB(1,N),YPB(1,N),SB(1,N),IIB(N))
 30   CONTINUE
      CVLE = ABS(CVSUM) / FLOAT(1 + NC)
C
      DO 80 IG=1, NBLD(N)
        I = ILE + IG - 1
C
C------ spline parameter arc lengths on sides 1,2 at current i station
C-      (SG is the normalized grid spacing array on each side)
        SB1 = SBLE(N) + (SB(1     ,N)-SBLE(N))*SG(IG,IS1(N))
        SB2 = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,IS2(N))
C
C========================================================================
C       Option A: Mode coordinate is  s/sside  from airfoil nose to TE
C
C------ set fractional arc length from airfoil nose (negative on side 2)
        ST(IG,IS1(N)) = (SBLEGN(N) - SB1)/SBSID1
        ST(IG,IS2(N)) = (SBLEGN(N) - SB2)/SBSID2
C
C------ if a node is on "wrong side", normalize it with that side length
        IF(ST(IG,IS1(N)).LT.0.0) ST(IG,IS1(N)) = (SBLEGN(N)-SB1)/SBSID2
        IF(ST(IG,IS2(N)).GT.0.0) ST(IG,IS2(N)) = (SBLEGN(N)-SB2)/SBSID1
C
C========================================================================
cC       Option B: Mode coordinate is  x/c  from airfoil nose to TE
cC
c        XB1 = SEVAL(SB1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
c        XB2 = SEVAL(SB2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
c        YB1 = SEVAL(SB1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
c        YB2 = SEVAL(SB2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
cC
cC------ set fractional chord-line x/c  (negative on side 2)
c        ST(IG,IS1(N)) =  (XB1-XB0)*XCN + (YB1-YB0)*YCN
c        ST(IG,IS2(N)) = -(XB2-XB0)*XCN - (YB2-YB0)*YCN
cC
cC------ if a node is on "wrong side", change its sign
c        IF(SB1.GT.SBLEGN(N)) ST(IG,IS1(N)) = -ST(IG,IS1(N))
c        IF(SB2.LT.SBLEGN(N)) ST(IG,IS2(N)) = -ST(IG,IS2(N))
cC
C========================================================================
C
   80   CONTINUE
  100 CONTINUE
C
C---- curvature in same units as ST
      CVT = CVLE*(0.5*DSBTOT)
C
C---- set geometry modes on all sides
      CALL GMODES(GN,ST,NMODX,IX,NBLD,2*NBL,CVT)
C
      RETURN
      END ! GNSET



      SUBROUTINE PNSET
C---------------------------------------------------------
C     Reads file "moves.xxx" to set translation and 
C     rotation mode arrays at surface and field.
C     Each line in the file contains:
C
C    KDOF     mode number (ties it to DPOS1-9 global dof)
C    GWT      rotation in radians (+ clockwise) for unit DPOS  
C             (GWT = 0 for translation mode)
C    XT,YT    movement direction vector   if GWT .eq. 0
C             rotation center coordinates if GWT .ne. 0
C    IEL      element number to which mode pertains
C
C     KDOF can be the same on two or more lines for 
C     translation modes.  This allows separate elements
C     to be "tied" together with a single mode.
C---------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      PARAMETER (LMAX=100)
      INTEGER KDOF(LMAX), IEL(LMAX)
      DIMENSION XT(LMAX), YT(LMAX), GWT(LMAX)
      LOGICAL LMDEF(NPOSX)
      CHARACTER*80 ARGP1, FNAME
C
      DO 2 K=1, NPOSX
        LMDEF(K) = .FALSE.
 2    CONTINUE
C
C---- read mode info from file  modes.xxx
      CALL GETARG(1,ARGP1)
      FNAME = 'moves.' // ARGP1 
      OPEN(7,FILE=FNAME,STATUS='OLD',ERR=5)
      GO TO 9
C
C---- try to open  moves.xxx  without "_n" extension
 5    ISCORE = INDEX(ARGP1,'_')
      IF(ISCORE.EQ.0) GO TO 990
      FNAME = 'moves.' // ARGP1(1:ISCORE-1)
      OPEN(7,FILE=FNAME,STATUS='OLD',ERR=990)
C
 9    DO 10 L=1, LMAX
        READ(7,*,END=11) KDOF(L),GWT(L),XT(L),YT(L),IEL(L)
 10   CONTINUE
      L = LMAX+1
 11   CONTINUE
      LL = L-1
      CLOSE(7)
C
C
C---- zero out all translation/rotation modes
      DO 20 K=1, NPOSX
        DO 201 J=1, JJ
          DO 2012 I=1, II
            NXP(I,J,K) = 0.0
            NYP(I,J,K) = 0.0
 2012     CONTINUE
 201    CONTINUE
        NPOSEL(K) = 0
   20 CONTINUE
C
C
C---- go over input file lines
      DO 100 L = 1, LL
C
      K = KDOF(L)
C
      IF(LMDEF(K)) THEN
       WRITE(*,*) 'Only one element motion per DOF currently permitted.'
       WRITE(*,*) 'Ignoring line', L
       GO TO 100
      ENDIF
C
      IF(K.LT.1 .OR. K.GT.NPOSX) THEN
       WRITE(*,*) 'PNSET: DOF index out of range.  Skipping line', L
       GO TO 100
      ENDIF
C
C---- target element number
      N = IEL(L)
C
      IF(N.LT.1 .OR. N.GT.NBL) THEN
       WRITE(*,*) 'PNSET: Element index out of range.  Skipping line', L
       GO TO 100
      ENDIF
C
      IF(NPOSEL(N).EQ.NBX) THEN
        WRITE(*,*) 'PNSET: Too many elements tied to mode', K,
     &                     '.   Skipping line', L
        GO TO 100
      ENDIF
C
C---- increment number of elements influenced by this mode
      NPOSEL(K) = NPOSEL(K) + 1
      NN = NPOSEL(K)
C
C---- set element number
      NBPOS(NN,K) = N
C
C---- set direction vector (GWT.EQ.0), or rotation center (GWT.NE.0)
      XBPOS(NN,K) = XT(L)
      YBPOS(NN,K) = YT(L)
      ABPOS(NN,K) = GWT(L)
C
C---- set element displacement field
      CALL NPOSET(K,NBPOS(NN,K),XBPOS(NN,K),YBPOS(NN,K),ABPOS(NN,K))
C
C---- set flag indicating this DOF is defined
      LMDEF(K) = .TRUE.
C
  100 CONTINUE
C
C---- see if all specified element position DOFs are defined
      DO 110 N=1, NPOSN
        K = KPOSN(N)
        IF(.NOT.LMDEF(K)) WRITE(*,1105) K
 1105   FORMAT(' *** Warning: Position DOF', I4,
     &         '  not defined in file  moves.xxx  ***')
 110  CONTINUE
C
c      write(*,*) 'Enter  K'
c      read (*,*) K
c      if(k.ne.0) then
c      write(*,*) k,NBPOS(NN,K),XBPOS(NN,K),YBPOS(NN,K),ABPOS(NN,K)
c      do j=1, jj
c        write(15) (nxp(i,j,k), nyp(i,j,k), i=1, ii)
c      enddo
c      endif
c
      RETURN
C
 990  WRITE(*,1990) FNAME(1:60)
 1990 FORMAT(1X,'Open error on file ', A60)
      RETURN
      END ! PNSET



      SUBROUTINE NPOSET(K,N,XBPS,YBPS,ABPS)
C----------------------------------------------------------------
C     Calculates direction vectors NXP(i,j,K),NYP(i,j,K)
C     which give the forced movement of grid node i,j 
C     in response to a unit perturbation in position mode K 
C     (translation or rotation) acting on element N.
C
C     XBPS,YBPS is the translation vector (if ABPS .eq. 0.0), or
C     XBPS,YBPS is the center of rotation (if ABPS .ne. 0.0)
C----------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INTEGER IMOVE(2,0:ISX+1), IFIXL(2,0:ISX+1),IFIXR(2,0:ISX+1)
      INTEGER ILT(2)
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ FRACT(IX,0:ISX+1), FRACN(IX,0:ISX+1),
ccc     &             XMOVE(IX,0:ISX+1), YMOVE(IX,0:ISX+1),
ccc     &              DNXP(IX,0:ISX+1),  DNYP(IX,0:ISX+1),
ccc     &             MFSUM(JX), SBSIDE(ISX),
ccc     &             SGI(IX,0:ISX+1),
ccc     &             XSI(IX,0:ISX+1),
ccc     &             YSI(IX,0:ISX+1)
      DIMENSION FRACT(IX,0:ISX+1), FRACN(IX,0:ISX+1),
     &          XMOVE(IX,0:ISX+1), YMOVE(IX,0:ISX+1),
     &           DNXP(IX,0:ISX+1),  DNYP(IX,0:ISX+1),
     &          MFSUM(JX), SBSIDE(ISX),
     &          SGI(IX,0:ISX+1),
     &          XSI(IX,0:ISX+1),
     &          YSI(IX,0:ISX+1)
C
      DO 1 I=1, II
        DO 1 IS=0, 2*NBL+1
          FRACT(I,IS) = 0.0
          FRACN(I,IS) = 0.0
 1    CONTINUE
C
C---- set integrated mass fraction array
      MFSUM(1) = 0.0
      DO 3 J=2, JJ
        IF(JSTAG(J) .LT. 0) THEN
         MFSUM(J) = 0.0
         GO TO 3
        ENDIF
        MFSUM(J) = MFSUM(J-1) + MFRACT(J-1)
 3    CONTINUE
C
C---- set element surface side lengths
      DO 5 NN=1, NBL
        SBSIDE(IS1(NN)) = SB(1      ,NN) - SBLE(NN)
        SBSIDE(IS2(NN)) = SB(IIB(NN),NN) - SBLE(NN)
 5    CONTINUE
C
C---- put spacing arrays along streamline into single continuous array SGI
      DO 6 IS=1, 2*NBL
        NN = (IS+1)/2
C
C------ grid j index of streamline IS
        J = JS2(NN) - IS + 2*NN
C
        DO 62 I=1, ILEB(NN)
          IG = I
          SGI(I,IS) = SGINL(IG,NN)
          IM = MAX(I-1,1       )
          IP = MIN(I+1,ILEB(NN))
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 62     CONTINUE
C
        DO 64 I=ILEB(NN), ITEB(NN)
          IG = I - ILEB(NN) + 1
          SGI(I,IS) = SG(IG,IS) + SGI(ILEB(NN),IS)
cc          SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
cc          XSI(I,IS) = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
cc     &               *SBSIDE(IS)
cc          YSI(I,IS) = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
cc     &               *SBSIDE(IS)
          IM = MAX(I-1,ILEB(NN))
          IP = MIN(I+1,ITEB(NN))
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 64     CONTINUE
C
        DO 66 I=ITEB(NN)+1, II
          IG = I - ITEB(NN) + 1
          SGI(I,IS) = SGOUT(IG,NN) + SGI(ITEB(NN),IS)
cc          XSI(I,IS) = XW(IG,NN) - XW(IG-1,NN)
cc          YSI(I,IS) = YW(IG,NN) - YW(IG-1,NN)
          IM = MAX(I-1,ITEB(NN))
          IP = MIN(I+1,II      )
          XSI(I,IS) = X(IP,J) - X(IM,J)
          YSI(I,IS) = Y(IP,J) - Y(IM,J)
 66     CONTINUE
C
 6    CONTINUE
C
C
      I1 = 0
      I2 = 2*NBL+1
      J1 = 1
      J2 = JJ
C
      I = 1
      SGI(I,I1) = 0.0
      SGI(I,I2) = 0.0
      DO 7 I=2, II
        SGI(I,I1) = SGI(I-1,I1)
     &   + SQRT( (X(I,J1)-X(I-1,J1))**2
     &         + (Y(I,J1)-Y(I-1,J1))**2 )
        SGI(I,I2) = SGI(I-1,I2)
     &   + SQRT( (X(I,J2)-X(I-1,J2))**2
     &         + (Y(I,J2)-Y(I-1,J2))**2 )
 7    CONTINUE
C
      DO 8 I=1, II
        IM = MAX(I-1,1 )
        IP = MIN(I+1,II)
        XSI(I,I1) = X(IP,J1) - X(IM,J1)
        YSI(I,I1) = Y(IP,J1) - Y(IM,J1)
        XSI(I,I2) = X(IP,J2) - X(IM,J2)
        YSI(I,I2) = Y(IP,J2) - Y(IM,J2)
 8    CONTINUE
C
C---- normalize streamwise vector arrays
      DO 9 IS=0, 2*NBL+1
        DO 92 I=1, II
          DSMOD = SQRT(XSI(I,IS)**2 + YSI(I,IS)**2)
          XSI(I,IS) = XSI(I,IS)/DSMOD
          YSI(I,IS) = YSI(I,IS)/DSMOD
 92     CONTINUE
 9    CONTINUE
C
C
      IF(ABPS.EQ.0.0) THEN
C----- set translation mode surface vectors
       DO 10 I=1, II
         XMOVE(I,IS1(N)) = XBPS
         YMOVE(I,IS1(N)) = YBPS
         XMOVE(I,IS2(N)) = XBPS
         YMOVE(I,IS2(N)) = YBPS
 10    CONTINUE
      ELSE
C----- set rotation mode surface vectors
       ILE = ILEB(N)
       ITE = ITEB(N)
       DO 15 I=ILE, ITE
         IG = I - ILE + 1
C
         IS = IS1(N)
         SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
         XBI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         YBI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         XMOVE(I,IS) =  (YBI - YBPS)*ABPS
         YMOVE(I,IS) = -(XBI - XBPS)*ABPS
C
         IS = IS2(N)
         SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
         XBI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         YBI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         XMOVE(I,IS) =  (YBI - YBPS)*ABPS
         YMOVE(I,IS) = -(XBI - XBPS)*ABPS
 15    CONTINUE
C
C----- inlet, outlet streamlines move with LE, TE
       DO 17 I=1, ILE-1
         XMOVE(I,IS1(N)) = XMOVE(ILE,IS1(N))
         YMOVE(I,IS1(N)) = YMOVE(ILE,IS1(N))
         XMOVE(I,IS2(N)) = XMOVE(ILE,IS2(N))
         YMOVE(I,IS2(N)) = YMOVE(ILE,IS2(N))
 17    CONTINUE
       DO 18 I=ITE+1, II
         XMOVE(I,IS1(N)) = XMOVE(ITE,IS1(N))
         YMOVE(I,IS1(N)) = YMOVE(ITE,IS1(N))
         XMOVE(I,IS2(N)) = XMOVE(ITE,IS2(N))
         YMOVE(I,IS2(N)) = YMOVE(ITE,IS2(N))
 18    CONTINUE
      ENDIF
C
C
      I1 = IS1(N)
      I2 = IS2(N)
      DO 20 IS=0, IS1(N)-1
        DO 202 I=1, II
ccc          XMOVE(I,IS) = XMOVE(I,IS1(N))
ccc          YMOVE(I,IS) = YMOVE(I,IS1(N))
C
C-------- set same tangential and perp. motion on other element sides
          IB = I
          IB = MIN(IB,ITEB(N))
          IB = MAX(IB,ILEB(N))
          TMOVE = XMOVE(I,I1)*XSI(IB,I1) + YMOVE(I,I1)*YSI(IB,I1)
          PMOVE = XMOVE(I,I1)*YSI(IB,I1) - YMOVE(I,I1)*XSI(IB,I1)
          XMOVE(I,IS) = TMOVE*XSI(I,IS) !! + PMOVE*YSI(I,IS)
          YMOVE(I,IS) = TMOVE*YSI(I,IS) !! - PMOVE*XSI(I,IS)
 202    CONTINUE
 20   CONTINUE
C
      DO 22 IS=IS2(N)+1, 2*NBL+1
        DO 222 I=1, II
ccc          XMOVE(I,IS) = XMOVE(I,IS2(N))
ccc          YMOVE(I,IS) = YMOVE(I,IS2(N))
C
C-------- set same tangential and perp. motion on other element sides
          IB = I
          IB = MIN(IB,ITEB(N))
          IB = MAX(IB,ILEB(N))
          TMOVE = XMOVE(I,I2)*XSI(IB,I2) + YMOVE(I,I2)*YSI(IB,I2)
          PMOVE = XMOVE(I,I2)*YSI(IB,I2) - YMOVE(I,I2)*XSI(IB,I2)
          XMOVE(I,IS) = TMOVE*XSI(I,IS) !! + PMOVE*YSI(I,IS)
          YMOVE(I,IS) = TMOVE*YSI(I,IS) !! - PMOVE*XSI(I,IS)
 222    CONTINUE
 22   CONTINUE
C
C
      DO 25 IS=0, 2*NBL+1
        IFIXL(1,IS) = 1
        IMOVE(1,IS) = 0
        IFIXR(1,IS) = ITEB(N)
C
        IFIXL(2,IS) = ILEB(N)
        IMOVE(2,IS) = 0
        IFIXR(2,IS) = II
 25   CONTINUE
C
C
C---- distribute LE/TE motion points
      ILT(1) = ILEB(N)
      ILT(2) = ITEB(N)
C
      DO 30 LT=1, 2
        I = ILT(LT)
C
C------ sides above element N
        DO 362 IS=IS1(N), 1, -2
          IMOVE(LT,IS  ) = I
          IMOVE(LT,IS-1) = I
          IF(IS.EQ.1) GO TO 363
          NN = (IS+1)/2
          IF(I.GE.ILEB(NN-1) .AND. I.LE.ITEB(NN-1)) GO TO 363
 362    CONTINUE
 363    CONTINUE
C
C------ sides below element N
        DO 366 IS=IS2(N), 2*NBL, 2
          IMOVE(LT,IS  ) = I
          IMOVE(LT,IS+1) = I
          IF(IS.EQ.2*NBL) GO TO 367
          NN = (IS+1)/2
          IF(I.GE.ILEB(NN+1) .AND. I.LE.ITEB(NN+1)) GO TO 367
 366    CONTINUE
 367    CONTINUE
C
 30   CONTINUE
C
C
C---- LE and TE of each element other than N will pin grid movement
      DO 40 NN=1, NBL
        IF(NN.EQ.N) GO TO 40
C
        ILT(1) = ILEB(NN)
        ILT(2) = ITEB(NN)
C
C------ go over two "tent" movements on each element NN
        DO 420 LT=1, 2
C
C-------- check both LE and TE
          DO 410 LETE=1, 2
            I = ILT(LETE)
C
C---------- sides above element NN
            DO 4102 IS=IS1(NN), IS1(1), -2
              ISO = IS
              ISM = IS-1
              IMOVEO = IMOVE(LT,ISO)
              IMOVEM = IMOVE(LT,ISM)
C
              IF(I.LT.IMOVEO) IFIXL(LT,ISO) = MAX(IFIXL(LT,ISO),I)
              IF(I.GT.IMOVEO) IFIXR(LT,ISO) = MIN(IFIXR(LT,ISO),I)
C
              IF(I.LT.IMOVEM) IFIXL(LT,ISM) = MAX(IFIXL(LT,ISM),I)
              IF(I.GT.IMOVEM) IFIXR(LT,ISM) = MIN(IFIXR(LT,ISM),I)
C
              IF(IS.EQ.IS1(1)) GO TO 4103
C
              NNN = (IS+1)/2
              IF(I.GE.ILEB(NNN-1) .AND. I.LE.ITEB(NNN-1)) GO TO 4103
 4102       CONTINUE
 4103       CONTINUE
C
C---------- sides below element NN
            DO 4106 IS=IS2(NN), IS2(NBL), 2
              ISO = IS
              ISP = IS+1
              IMOVEO = IMOVE(LT,ISO)
              IMOVEP = IMOVE(LT,ISP)
C
              IF(I.LT.IMOVEO) IFIXL(LT,ISO) = MAX(IFIXL(LT,ISO),I)
              IF(I.GT.IMOVEO) IFIXR(LT,ISO) = MIN(IFIXR(LT,ISO),I)
C
              IF(I.LT.IMOVEP) IFIXL(LT,ISP) = MAX(IFIXL(LT,ISP),I)
              IF(I.GT.IMOVEP) IFIXR(LT,ISP) = MIN(IFIXR(LT,ISP),I)
C
              IF(IS.EQ.IS2(NBL)) GO TO 4107
C
              NNN = (IS+1)/2
              IF(I.GE.ILEB(NNN+1) .AND. I.LE.ITEB(NNN+1)) GO TO 4107
 4106       CONTINUE
 4107     CONTINUE
C
 410      CONTINUE
 420    CONTINUE
C
 40   CONTINUE

C==========================================================
C     Set up fraction array FRACT for streamwise movement
C
      DO 50 IS=0, 2*NBL+1
C
        DO 580 LT=1, 2

c          write(*,6667) is, ifixl(lt,is), imove(lt,is), ifixr(lt,is),
c     &                  ileb(nn), iteb(nn)
c 6667     format(1x,i3, 2x, 3i6, 4x, 2i6)

          IF(IMOVE(LT,IS).EQ.0) GO TO 580

C-------- set mode vector fractions ahead of LE
          DO 520 I=IFIXL(LT,IS), IMOVE(LT,IS)
            FRACT(I,IS) = FRACT(I,IS)
     &                  + (SGI(I,IS)            - SGI(IFIXL(LT,IS),IS))
     &                  / (SGI(IMOVE(LT,IS),IS) - SGI(IFIXL(LT,IS),IS))
 520      CONTINUE
C
C-------- set mode vector fractions behind LE
          DO 540 I=IMOVE(LT,IS)+1, IFIXR(LT,IS)
            FRACT(I,IS) = FRACT(I,IS)
     &                  + (SGI(I,IS)            - SGI(IFIXR(LT,IS),IS))
     &                  / (SGI(IMOVE(LT,IS),IS) - SGI(IFIXR(LT,IS),IS))
 540      CONTINUE
 580    CONTINUE
C
 50   CONTINUE
C
C
C==========================================================
C
C---- set fraction array FRACN for normal movement 
C-    (zero except on current element)
      DO 55 I=1, II
        FRACN(I,IS1(N)) = 1.0
        FRACN(I,IS2(N)) = 1.0
 55   CONTINUE
C
C==========================================================
C
C---- set mode vectors on all surface and top,bottom streamlines
      DO 60 IS=0, 2*NBL+1
        DO 602 I=1, II
          XT =  XSI(I,IS)
          YT =  YSI(I,IS)
          XN =  YSI(I,IS)
          YN = -XSI(I,IS)
C
          TMOVE = XMOVE(I,IS)*XT + YMOVE(I,IS)*YT
          PMOVE = XMOVE(I,IS)*XN + YMOVE(I,IS)*YN
C
          DNXP(I,IS) = XT*TMOVE*FRACT(I,IS) + XN*PMOVE*FRACN(I,IS)
          DNYP(I,IS) = YT*TMOVE*FRACT(I,IS) + YN*PMOVE*FRACN(I,IS)
 602    CONTINUE
 60   CONTINUE
C
C
C---- go over all interior streamlines, setting mode vectors
      NN = NBL
      JS = 1
      JP = JS2(NN)
      ISS = 2*NBL + 1
      ISP = IS2(NN)
C
      DO 80 J=1, JJ
C
        IF(JSTAG(J).LT.0) THEN
C------- reset bounding streamlines for this streamtube
         JS = JS1(NN)
         JP = JJ
         ISS = IS1(NN)
         ISP = 0
C
         NN = NN-1
         IF(NN.GT.0) THEN
          JP  = JS2(NN)
          ISP = IS2(NN)
         ENDIF
        ENDIF
C
C------ interpolating fractions
        FS = 1.0 - MFSUM(J)/MFSUM(JP)
        FP =       MFSUM(J)/MFSUM(JP)
C
C------ interpolate mode vectors
        DO 805 I=1, II
          DNX = FS*DNXP(I,ISS) + FP*DNXP(I,ISP)
          DNY = FS*DNYP(I,ISS) + FP*DNYP(I,ISP)
          NXP(I,J,K) = DNX  +  NXP(I,J,K)
          NYP(I,J,K) = DNY  +  NYP(I,J,K)
 805    CONTINUE
C
 80   CONTINUE
C
      RETURN
      END ! NPOSET



      SUBROUTINE SGLIN
C---------------------------------------------------------
C     Calculates the sensitivities of surface node 
C     location array SG(IG,IS) to element position modes.
C
C     The node locations change because they are allowed
C     to slide on the surface to minimize grid shear 
C     problems in cases such as two adjacent elements 
C     slideing past each other.
C---------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC' 
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XX(IX), YY(IX), SS(IX),
ccc     &             XP(IX), YP(IX), SP(IX),
ccc     &             DFRAC1(IX), DFRAC2(IX),
ccc     &             SBSIDE(ISX)
      DIMENSION XX(IX), YY(IX), SS(IX),
     &          XP(IX), YP(IX), SP(IX),
     &          DFRAC1(IX), DFRAC2(IX),
     &          SBSIDE(ISX)
C
C---- go over each element
      DO 1000 N=1, NBL
        I1 = IS1(N)
        I2 = IS2(N)
        J1 = JS1(N)
        J2 = JS2(N)
C
        DO 10 NN=1, NPOSN
          K = KPOSN(NN)
          DO 102 I=1, II
            SGINLP(I,N,K) = 0.0
            SGOUTP(I,N,K) = 0.0
            SGSRFP(I,I1,K) = 0.0
            SGSRFP(I,I2,K) = 0.0
 102      CONTINUE
 10     CONTINUE
C
C------ put inlet streamline trajectory in temporary XX,YY arrays
        DO 20 IG=1, NINL(N)
          I = IG
          XX(IG) = X(I,J1)
          YY(IG) = Y(I,J1)
 20     CONTINUE
C
C------ also set the sensitivity of this trajectory to element position modes
        DO 22 NN=1, NPOSN
          K = KPOSN(NN)
          DO 222 IG=1, NINL(N)
            I = IG
            XP(IG) = NXP(I,J1,K)
            YP(IG) = NYP(I,J1,K)
 222      CONTINUE
C
          CALL SLIN(XX,YY,SS,XP,YP,SP,NINL(N))
C
          DELSS = SS(NINL(N)) - SS(1)
          DELSP = SP(NINL(N)) - SP(1)
C
          DO 224 IG=1, NINL(N)
            SGTEMP         = ( SS(IG)-SS(1) ) / DELSS
            SGINLP(IG,N,K) = ( SP(IG)-SP(1)
     &                       - SGTEMP*DELSP ) / DELSS
 224      CONTINUE
 22     CONTINUE
C
C
        SBSIDE(I1) = SB(1     ,N) - SBLE(N)
        SBSIDE(I2) = SB(IIB(N),N) - SBLE(N)
C
C------ now go over the element surfaces
        DO 400 IS=IS1(N), IS2(N)
C
          J = JS2(N) - IS + 2*N
C
          DO 40 IG=1, NBLD(N)
            SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
            XX(IG) = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YY(IG) = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
 40       CONTINUE
C
          DO 42 NN=1, NPOSN
            K = KPOSN(NN)
            DO 422 IG=1, NBLD(N)
              I = IG + ILEB(N) - 1
              XP(IG) = NXP(I,J,K)
              YP(IG) = NYP(I,J,K)
 422        CONTINUE
C
            CALL SLIN(XX,YY,SS,XP,YP,SP,NBLD(N))
C
            DELSS = SS(NBLD(N)) - SS(1)
            DELSP = SP(NBLD(N)) - SP(1)
C
            DO 424 IG=1, NBLD(N)
              SGTEMP          = ( SS(IG)-SS(1) ) / DELSS
              SGSRFP(IG,IS,K) = ( SP(IG)-SP(1)
     &                          - SGTEMP*DELSP ) / DELSS
c              if(k.eq.1) then
c                i = ig + ileb(n) - 1
c                write(*,6667) i, is, sgtemp, sg(ig,is), sgsrfp(ig,is,k)
c 6667           format(1x,2i4,2f10.5,2x,f10.5)
c              endif
 424        CONTINUE
 42       CONTINUE
C
 400    CONTINUE
C
C------ finally, go over the outlet streamline
        DO 60 IG=1, NOUT(N)
          I = IG + ITEB(N) - 1
C
          DSUM = DSTR(I,I1) + DSTR(I,I2)
          IF(DSUM.EQ.0.0) THEN
           DFRAC1(IG) = 0.5
           DFRAC2(IG) = 0.5
          ELSE
           DFRAC1(IG) = DSTR(I,I1)/DSUM
           DFRAC2(IG) = DSTR(I,I2)/DSUM
          ENDIF
C
CCC          XX(IG) = XW(IG,N)
CCC          YY(IG) = YW(IG,N)
C
          XX(IG) = DFRAC1(IG)*X(I,J1) + DFRAC2(IG)*X(I,J2)
          YY(IG) = DFRAC1(IG)*Y(I,J1) + DFRAC2(IG)*Y(I,J2)
C
 60     CONTINUE
C
        DO 62 NN=1, NPOSN
          K = KPOSN(NN)
          DO 622 IG=1, NOUT(N)
            I = IG + ITEB(N) - 1
            XP(IG) = DFRAC1(IG)*NXP(I,J1,K) + DFRAC2(IG)*NXP(I,J2,K)
            YP(IG) = DFRAC1(IG)*NYP(I,J1,K) + DFRAC2(IG)*NYP(I,J2,K)
 622      CONTINUE
C
          CALL SLIN(XX,YY,SS,XP,YP,SP,NOUT(N))
C
          DELSS = SS(NOUT(N)) - SS(1)
          DELSP = SP(NOUT(N)) - SP(1)
C
          DO 624 IG=1, NOUT(N)
            SGTEMP         = ( SS(IG)-SS(1) ) / DELSS
            SGOUTP(IG,N,K) = ( SP(IG)-SP(1)
     &                       - SGTEMP*DELSP ) / DELSS
c            if(k.eq.1) then
c              i = ig + iteb(n) - 1
c              write(*,6667) i, n, sgtemp, sgout(ig,n), sgoutp(ig,n,k)
c 6667         format(1x,2i4,2f10.5,2x,f10.5)
c            endif
 624      CONTINUE
 62     CONTINUE
C
 1000 CONTINUE
C
      RETURN
      END ! SGLIN



      SUBROUTINE SLIN(X,Y,S,XP,YP,SP,N)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N) , Y(N) , S(N) ,
     &          XP(N), YP(N), SP(N)
C--------------------------------------------------------
C     Calculates arc length from x,y coordinates.
C     Also calculates derivative of S wrt a parameter P.
C
C     Input:  X, Y    x,y coordinate array
C             XP,YP   dX/dP, dX/dP arrays
C             N       number of points
C
C     Output: S       arc length array
C             SP      dS/dP array
C--------------------------------------------------------
C
      S(1) = 0.0
      SP(1) = 0.0
C
      DO 10 I=2, N
        DX = X(I) - X(I-1)
        DY = Y(I) - Y(I-1)
        DS = SQRT(DX**2 + DY**2)
C
        DSP = (DX*(XP(I) - XP(I-1)) + DY*(YP(I) - YP(I-1))) / DS

CCC     S(I) = DS + S(I-1)
        S(I) = DS

CCC     SP(I) = DSP + SP(I-1)
        SP(I) = DSP
 10   CONTINUE
C
      DO 15 I=2, N
        S(I) = S(I) + S(I-1)
        SP(I) = SP(I) + SP(I-1)
 15   CONTINUE
C
      RETURN
      END ! SLIN
