
      SUBROUTINE DOUBLE(LOK)
      INCLUDE 'STATE.INC'
C-------------------------------------------------------------
C     Doubles the grid density of the current case.
C     Resets all grid indices appropriately.
C     Interpolates coarse solution onto the new fine grid.
C-------------------------------------------------------------
      LOGICAL LOK
C
      DIMENSION TEMP(JX)
      DIMENSION JFIX(3)
      DIMENSION XPS(IX,3), YPS(JX)
      DIMENSION IOLD(IX), JOLD(JX), JNEW(JX), JORG(JX), NSTRM(JX)
      DIMENSION JS1(0:NBX+1), JS2(0:NBX+1)
      DIMENSION SBSIDE(2*NBX)
C
C---- grid indices of new fine grid
      JJNEW = 2*JJ - 1 - NBL
      IINEW = 2*II - 1
C
C---- grid indices of original fine grid
      JJORG = JJ
      DO IHALF =  1, NHALF
        JJORG =  (JJORG + 1 + NBL)/2
      ENDDO
C
      DO IHALF = -1, NHALF, -1
        JJORG = 2*JJORG - 1 - NBL
      ENDDO
C
C
      LOK = .TRUE.
C
      IF(IINEW.GT.IX) THEN
       WRITE(*,*) 'DOUBLE:  Array size too small.  Increase IX to',IINEW
       LOK = .FALSE.
      ENDIF
      IF(JJNEW.GT.JX) THEN
       WRITE(*,*) 'DOUBLE:  Array size too small.  Increase JX to',JJNEW
       LOK = .FALSE.
      ENDIF
C
      IF(.NOT.LOK) THEN
       WRITE(*,*) '         Cannot refine grid.'
       RETURN
      ENDIF
C
      WRITE(*,*) 'Refining grid...'
C
      XPFAC = 1.0 - EXP(-0.2*CIRC)
      XPEXT = XPEX - (      XPEX)*XPFAC
      XPEXB = XPEX + (1.0 - XPEX)*XPFAC
C
      XPEXM = 1.0 - 0.5*(1.0-XPEX)
C
C---- dummy array for ELLIP call below
      JFIX(1) = 0
      JFIX(2) = 0
      JFIX(3) = 0
C
C---- initialize index of airfoil element touching streamline j
      DO J=1, JJ
        NSTRM(J) = 0
      ENDDO
C
C---- current airfoil-side j indices
      JS2(0) = JJ
      DO N=1, NBL
        J1 = JBLD(N)
        J2 = JBLD(N) - 1
        JS1(N) = J1
        JS2(N) = J2
        NSTRM(J1) = N
        NSTRM(J2) = N
C
        IS1 = 2*N - 1
        IS2 = 2*N
        SBSIDE(IS1) = SB(     1,N) - SBLE(N)
        SBSIDE(IS2) = SB(IIB(N),N) - SBLE(N)
      ENDDO
      JS1(NBL+1) = 1
C
C
C---- set old i stations corresponding to new i stations
      DO I=1, II
        IN = 2*I - 1
        IOLD(IN)   = I
        IOLD(IN+1) = 0
      ENDDO
C
C---- set old j streamlines corresponding to new j streamlines
      JN = JJNEW
      DO N=0, NBL
        DO J = JS2(N), JS1(N+1), -1
          JNEW(J)    = JN
          JOLD(JN)   = J
          JOLD(JN-1) = 0
          JN = JN - 2
        ENDDO
        JN = JN + 1
      ENDDO
C
      JODEL = 2**IABS(NHALF) / 2
      JO = JJORG
      DO N=0, NBL
        J2 = JS2(N)
        J1 = JS1(N+1)
        DO JN = JNEW(J2), JNEW(J1), -1
          JORG(JN) = JO
          JO = JO - JODEL
        ENDDO
        JO = JO + JODEL - 1
      ENDDO
C

c      write(*,*) 
c      write(*,*) jjorg, jjnew, jj
c      write(*,*) jodel, 2
c      write(*,*) 
c      do jn=1, jjnew
c        write(*,*) jorg(jn), jn, jold(jn)
c      enddo


C
      IF(NHALF.LT.0) THEN
C------ set new YPS from saved array
C
        DO JN = 1, JJNEW
          YPS(JN) = YPOS(JORG(JN))
        ENDDO
C
      ELSE
C------ set new YPS by interpolating current "old" one
C
C------ set "old" YPS array by summing mass fractions
        YPS(1) = 0.0
        DO N=NBL+1, 1, -1
          J2 = JS2(N-1)
          J1 = JS1(N)
          DO J=J1, J2-1
            YPS(J+1) = YPS(J) + MFRACT(J)
          ENDDO
          YPS(J2+1) = YPS(J2)
        ENDDO
C
C------ go over streamline blocks
        DO N=0, NBL
          J2 = JS2(N)
          J1 = JS1(N+1)
C
C-------- set doubled YPS array for this block
          YT1 = -999.0
          YT2 = -999.0
          IF(N.EQ.0  ) YT1 = 0.
          IF(N.EQ.NBL) YT2 = 0.
          NJ = J2 - J1 + 1
C
          CALL FDBLD(YPS(J1),YPS(JNEW(J1)),NJ,YT1,YT2)
ccc       CALL FDBL(YPS(J1),YPS(JNEW(J1)),NJ)
C
C-------- make sure YPS array is monotonic (guard against spline overshoots)
          DO JN = JNEW(J1)+1, JNEW(J2)-1, 2
            DYPS = YPS(JN+1) - YPS(JN-1)
            YPSMIN = MIN(YPS(JN+1),YPS(JN-1)) + 0.2*DYPS
            YPSMAX = MAX(YPS(JN+1),YPS(JN-1)) - 0.2*DYPS
            YPS(JN) = MAX(YPS(JN),YPSMIN)
            YPS(JN) = MIN(YPS(JN),YPSMAX)
          ENDDO
        ENDDO
      ENDIF
C
C---- set new mass fractions from new YPS
      DO JN = 1, JJNEW-1
        MFRACT(JN) = YPS(JN+1) - YPS(JN)
      ENDDO
C
C---- set dummy BL variables at inlet and outlet planes from values just inside
      DO IS=1, 2*NBL
        DISP( 1,IS) = DISP(   2,IS)
        THET( 1,IS) = THET(   2,IS)
        DSTR( 1,IS) = DSTR(   2,IS)
        UEDG( 1,IS) = UEDG(   2,IS)
        CTAU( 1,IS) = CTAU(   2,IS)
         TAU( 1,IS) =  TAU(   2,IS)
        DISP(II,IS) = DISP(II-1,IS)
        THET(II,IS) = THET(II-1,IS)
        DSTR(II,IS) = DSTR(II-1,IS)
        UEDG(II,IS) = UEDG(II-1,IS)
        CTAU(II,IS) = CTAU(II-1,IS)
         TAU(II,IS) =  TAU(II-1,IS)
      ENDDO
C
C---- go over all airfoil sides, doubling BL variable arrays
      DO IS=1, 2*NBL
        N = (IS+1)/2
C
        ILE = NINL(N)
        ITE = II - NOUT(N) + 1
        ILENEW = 2*ILE - 1
        ITENEW = 2*ITE - 1
C
C------ temporarily extrapolate trailing edge variables from wake
        DISP1 = DISP(ITE,IS)
        THET1 = THET(ITE,IS)
        DSTR1 = DSTR(ITE,IS)
        UEDG1 = UEDG(ITE,IS)
        TAUW1 =  TAU(ITE,IS)
        DISP(ITE,IS) = 2.0*DISP(ITE+1,IS) - DISP(ITE+2,IS) 
        THET(ITE,IS) = 2.0*THET(ITE+1,IS) - THET(ITE+2,IS)
        DSTR(ITE,IS) = 2.0*DSTR(ITE+1,IS) - DSTR(ITE+2,IS)
        UEDG(ITE,IS) = 2.0*UEDG(ITE+1,IS) - UEDG(ITE+2,IS)
         TAU(ITE,IS) = 2.0* TAU(ITE+1,IS) -  TAU(ITE+2,IS)
C
C------ double wake variables and reset TE values
        CALL FDBL(DISP(ITE,IS),DISP(ITENEW,IS),-NOUT(N))
        CALL FDBL(THET(ITE,IS),THET(ITENEW,IS),-NOUT(N))
        CALL FDBL(DSTR(ITE,IS),DSTR(ITENEW,IS),-NOUT(N))
        CALL FDBL(UEDG(ITE,IS),UEDG(ITENEW,IS),-NOUT(N))
        CALL FDBL( TAU(ITE,IS), TAU(ITENEW,IS),-NOUT(N))
        DISP(ITE,IS) = DISP1
        THET(ITE,IS) = THET1
        DSTR(ITE,IS) = DSTR1
        UEDG(ITE,IS) = UEDG1
         TAU(ITE,IS) = TAUW1
C
C------ double variables over surface
        CALL FDBL(DISP(ILE,IS),DISP(ILENEW,IS),-NBLD(N))
        CALL FDBL(THET(ILE,IS),THET(ILENEW,IS),-NBLD(N))
        CALL FDBL(DSTR(ILE,IS),DSTR(ILENEW,IS),-NBLD(N))
        CALL FDBL(UEDG(ILE,IS),UEDG(ILENEW,IS),-NBLD(N))
        CALL FDBL( TAU(ILE,IS), TAU(ILENEW,IS),-NBLD(N))
C
        IF(INITBL.EQ.1) THEN
C------ sanity check
CCC HHY fix for DSLIM check, THET only defined from ILE+1 to II
CCC     DO I = ILENEW, ITENEW
        DO I = ILENEW+1, ITENEW
          HKLIM = 1.05
          MSQ = UEDG(I,IS)**2 / ((GAM-1.0)*(HINF-0.5*UEDG(I,IS)**2))
          CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAM,HKLIM)
          CALL DSLIM(DISP(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAM,HKLIM)
        ENDDO
        ENDIF
C
C------ double dummy variables upstream of airfoil so they're not undefined
CCC HHY fix for interpolation bug (uses ILE value for upstream spline)
        NINLM1 = NINL(N)-1
        CALL FDBL(DISP(  1,IS),DISP(     1,IS),-NINLM1)
        CALL FDBL(THET(  1,IS),THET(     1,IS),-NINLM1)
        CALL FDBL(DSTR(  1,IS),DSTR(     1,IS),-NINLM1)
        CALL FDBL(UEDG(  1,IS),UEDG(     1,IS),-NINLM1)
        CALL FDBL( TAU(  1,IS), TAU(     1,IS),-NINLM1)
CCC HHY separately install value at ILENEW-1
        DISP(ILENEW-1,IS) = DISP(ILENEW-2,IS)
        THET(ILENEW-1,IS) = THET(ILENEW-2,IS)
        DSTR(ILENEW-1,IS) = DSTR(ILENEW-2,IS)
        UEDG(ILENEW-1,IS) = UEDG(ILENEW-2,IS)
         TAU(ILENEW-1,IS) =  TAU(ILENEW-2,IS)
C
C------ double Ctau over laminar and turbulent regions separately
        NT = II - ITRAN(IS) + 1
        ITRNEW = 2*ITRAN(IS) - 1
        CALL FDBL(CTAU(ITRAN(IS),IS),CTAU(ITRNEW,IS),NT)
C
        NL = ITRAN(IS)-1
        CALL FDBL(CTAU(1,IS),CTAU(1,IS),NL)
C
        ITRAN(IS) = ITRNEW
        CTAU(ITRAN(IS)-1,IS) = CTAU(ITRAN(IS)-2,IS) 
      ENDDO
C
C---- double WGAP array
      DO N=1, NBL
        ITE = II - NOUT(N) + 1
        ITENEW = 2*ITE - 1
        CALL FDBL( WGAP(ITE,N), WGAP(ITENEW,N),-NOUT(N))
      ENDDO
C
C---- double wake trajectory, wake gap, and wake spacing arrays
      DO N=1, NBL
        CALL FDBL(   XW(1,N),   XW(1,N),-NOUT(N))
        CALL FDBL(   YW(1,N),   YW(1,N),-NOUT(N))
C
        CALL FDBL(SGINL(1,N),SGINL(1,N),-NINL(N))
        CALL FDBL(SGOUT(1,N),SGOUT(1,N),-NOUT(N))
      ENDDO
C
C---- double surface spacing arrays
      DO IS=1, 2*NBL
        N = (IS+1)/2
        CALL FDBL(   SG(1,IS),   SG(1,IS),-NBLD(N))
        CALL FDBL(PSPEC(1,IS),PSPEC(1,IS),-NBLD(N))
        PXX0(IS) = 0.25*PXX0(IS)
        PXX1(IS) = 0.25*PXX1(IS)
      ENDDO
C
C---- double each grid streamline's x,y
      DO J = 1, JJ
        IF(NSTRM(J).EQ.0) THEN
          CALL FDBL(X(1,J),X(1,J),-II)
          CALL FDBL(Y(1,J),Y(1,J),-II)
        ELSE
C-------- stagnation streamlines done in three pieces -- don't spline over LE
          N = NSTRM(J)
          ILE = NINL(N)
          ITE = II - NOUT(N) + 1
          ILENEW = 2*ILE - 1
          ITENEW = 2*ITE - 1
          CALL FDBL(X(ITE,J),X(ITENEW,J),-NOUT(N))
          CALL FDBL(Y(ITE,J),Y(ITENEW,J),-NOUT(N))
          CALL FDBL(X(ILE,J),X(ILENEW,J),-NBLD(N))
          CALL FDBL(Y(ILE,J),Y(ILENEW,J),-NBLD(N))
          CALL FDBL(X(  1,J),X(     1,J),-NINL(N))
          CALL FDBL(Y(  1,J),Y(     1,J),-NINL(N))
        ENDIF
      ENDDO
C
C---- double each streamtube's density array
      DO J = 1, JJ-1
        CALL FDBL4(R(1,J),R(1,J),-(II-1))
      ENDDO
C
C---- go over streamline blocks, adjusting streamtube areas to match old YPOS
      DO 200 N=0, NBL
        J2 = JS2(N)
        J1 = JS1(N+1)
        DO IN=1, IINEW
          DO J=J1, J2
            TEMP(J-J1+1) = X(IN,J)
          ENDDO
          NJ = J2 - J1 + 1
          CALL FDBLT(TEMP,TEMP,YPS(JNEW(J1)),-NJ)
          DO JN = JNEW(J1), JNEW(J2)
            X(IN,JN) = TEMP(JN-JNEW(J1)+1)
          ENDDO
C
          DO J=J1, J2
            TEMP(J-J1+1) = Y(IN,J)
          ENDDO
          NJ = J2 - J1 + 1
          CALL FDBLT(TEMP,TEMP,YPS(JNEW(J1)),-NJ)
          DO JN = JNEW(J1), JNEW(J2)
            Y(IN,JN) = TEMP(JN-JNEW(J1)+1)
          ENDDO
C
          DO J=J1, J2-1
            TEMP(J-J1+1) = R(IN,J)
          ENDDO
          NJ = J2 - J1
          CALL FDBLT4(TEMP,TEMP,YPS(JNEW(J1)),-NJ)
          DO JN = JNEW(J1), JNEW(J2)-1
            R(IN,JN) = TEMP(JN-JNEW(J1)+1)
          ENDDO
        ENDDO
C
C
C------ set up XPS (xsi) array for smoothing interpolated streamlines
C
        IF    (N.EQ.0  ) THEN
C-------- top stream channel
          XPEXJ = XPEXT
          WT2 = 1.0
          WT1 = 0.0
        ELSEIF(N.EQ.NBL) THEN
C-------- bottom stream channel
          XPEXJ = XPEXB
          WT2 = 0.0
          WT1 = 1.0
        ELSE
C-------- inter-element stream channels
          XPEXJ = XPEXM
          WT2 = 0.5
          WT1 = 0.5
        ENDIF
C
        JN2 = JNEW(J2)
        JN1 = JNEW(J1)
        XPS(1,1) = 0.0
        DO IN=2, IINEW
          DS1 = SQRT(  (X(IN,JN1)-X(IN-1,JN1))**2
     &               + (Y(IN,JN1)-Y(IN-1,JN1))**2 )
          DS2 = SQRT(  (X(IN,JN2)-X(IN-1,JN2))**2
     &               + (Y(IN,JN2)-Y(IN-1,JN2))**2 )
          XPS(IN,1) = XPS(IN-1,1) + (WT1*DS1 + WT2*DS2) ** XPEXJ
        ENDDO
C
        DO IN=1, IINEW
          XPS(IN,2) = XPS(IN,1)
          XPS(IN,3) = XPS(IN,1)
        ENDDO
C
C------ smooth only interpolated streamlines by passing IINEW x 3 grid pieces
        RLIM = 0.4*RHOINF
        ITMAX = -3
        DO JN = JN1, JN2-2, 2
          XPS(1,1) = 0.0
          XPS(1,2) = 0.0
          XPS(1,3) = 0.0
          DO IN=2, IINEW
            DS1 = SQRT(  (X(IN,JN  )-X(IN-1,JN  ))**2
     &                 + (Y(IN,JN  )-Y(IN-1,JN  ))**2 )
            DS2 = SQRT(  (X(IN,JN+2)-X(IN-1,JN+2))**2
     &                 + (Y(IN,JN+2)-Y(IN-1,JN+2))**2 )
            XPS(IN,1) = XPS(IN-1,1) + 0.5*(DS1 + DS2)
            XPS(IN,2) = XPS(IN,1)
            XPS(IN,3) = XPS(IN,1)
          ENDDO
C
          CALL ELLIP(IX,JX,IINEW,3,JFIX,
     &               X(1,JN),Y(1,JN),XPS,YPS(JN),R,RLIM,ITMAX)
        ENDDO
 200  CONTINUE
C
C---- set new indices
C
      DO N=1, NBL
        NINL(N) = 2*NINL(N) - 1
        NBLD(N) = 2*NBLD(N) - 1
        NOUT(N) = 2*NOUT(N) - 1
C
        JBLD(N) = JNEW(JS1(N))
        JS1(N) = JNEW(JS1(N))
        JS2(N) = JNEW(JS2(N))
      ENDDO
C
      II = IINEW
      JJ = JJNEW
C
      DO IS=1, 2*NBL
        IF(IGFIX(IS) .NE.0)  IGFIX( IS) = 2*IGFIX( IS) - 1
        IF(IGCORN(IS).NE.0)  IGCORN(IS) = 2*IGCORN(IS) - 1
        IX0 = 2*IX0 - 1
        IX1 = 2*IX1 - 1
      ENDDO
C
      CALL INDINI
C
      DO N = 1, NBL
        CALL SPWAKE(N)
      ENDDO
C
C---- set new WGAP array directly from definition (interpolates poorly)
      DO N=1, NBL
        CALL GAPSET(N)
      ENDDO
C
C---- make sure interpolated DSTR isn't smaller than gap
      DO N = 1, NBL
        ITE = II - NOUT(N) + 1
        DO I = ITE+1, II-1
          HGAP = 0.5*WGAP(I,N)
          DO IS = 2*N-1, 2*N
            IF(DSTR(I,IS) .LE. HGAP) THEN 
             DSTR(I,IS) = HGAP + 1.1*THET(I,IS)
            ENDIF
          ENDDO
        ENDDO
      ENDDO
C
cC---- set new Delta* vectors
c      CALL BLNORM
cC
cC---- offset doubled stagnation streamlines away from surface exactly
c      DO IS=1, 2*NBL
c        N = (IS+1)/2
c        ILE = NINL(N)
c        IF(MOD(IS,2).EQ.0) THEN
c          J = JS2(N)
c        ELSE
c          J = JS1(N)
c        ENDIF
c        DO IG=1, NBLD(N)
c          SBI = SBLE(N) + SG(IG,IS)*SBSIDE(IS)
c          XBI =  SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
c          YBI =  SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
c          XBN =  DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
c          YBN = -DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
c          SBN = SQRT(XBN**2 + YBN**2)
c          XBN = XBN/SBN
c          YBN = YBN/SBN
c          I = ILE + IG - 1
c          X(I,J) = XBI + XBN*DISP(I,IS)
c          Y(I,J) = YBI + YBN*DISP(I,IS)
c        ENDDO
c      ENDDO
C
C---- make sure inlet stagnation streamline nodes match exactly
      DO N=1, NBL
        J1 = JS1(N)
        J2 = JS2(N)
        DO I=1, NINL(N)
          X(I,J1) = 0.5*(X(I,J1)+X(I,J2))
          Y(I,J1) = 0.5*(Y(I,J1)+Y(I,J2))
          X(I,J2) = X(I,J1)
          Y(I,J2) = Y(I,J1)
        ENDDO
      ENDDO
C
      RETURN
      END ! DOUBLE



      SUBROUTINE FDBL(FI,FO,NSGN)
      DIMENSION FI(*), FO(*)
C---------------------------------------------------
C     Doubles array FI into array FO via spline 
C     parameterized by index.
C
C     Also doubles array size NSGN unless it is
C     passed in negative.
C---------------------------------------------------
      DIMENSION T(1000), F(1000), FT(1000)
C
      N = IABS(NSGN)
C
      IF(N.GT.1000) STOP 'FDBL: Local-array overflow.'
C
      DO I=1, N
        T(I) = FLOAT(I-1)
        F(I) = FI(I)
      ENDDO
C
      CALL SPLINE(F,FT,T,N)
C
      DO I=1, 2*N-1
        TT = 0.5*FLOAT(I-1)
        FO(I) = SEVAL(TT,F,FT,T,N)
      ENDDO
C
      IF(NSGN.GT.0) NSGN = 2*N - 1
C
      RETURN
      END


      SUBROUTINE FDBLD(FI,FO,NSGN,FT1,FT2)
      DIMENSION FI(*), FO(*)
C---------------------------------------------------
C     Doubles array FI into array FO via spline 
C     parameterized by index.
C
C     Also doubles array size NSGN unless it is
C     passed in negative.
C---------------------------------------------------
      DIMENSION T(1000), F(1000), FT(1000)
C
      N = IABS(NSGN)
C
      IF(N.GT.1000) STOP 'FDBL: Local-array overflow.'
C
      DO I=1, N
        T(I) = FLOAT(I-1)
        F(I) = FI(I)
      ENDDO
C
      CALL SPLIND(F,FT,T,N,FT1,FT2)
C
      DO I=1, 2*N-1
        TT = 0.5*FLOAT(I-1)
        FO(I) = SEVAL(TT,F,FT,T,N)
      ENDDO
C
      IF(NSGN.GT.0) NSGN = 2*N - 1
C
      RETURN
      END



      SUBROUTINE FDBL4(FI,FO,NSGN)
      DIMENSION FI(*), FO(*)
C---------------------------------------------------
C     Doubles array FI into array FO via spline 
C     parameterized by index.  The new values
C     are placed at the 25% and 75% positions 
C     of the old intervals.
C
C     Also doubles array size NSGN unless it is
C     passed in negative.
C---------------------------------------------------
C
      DIMENSION T(0:1001), F(0:1001), FT(0:1001)
C
      N = IABS(NSGN)
C
      IF(N.GT.1000) STOP 'FDBL4: Local-array overflow.'
C
      DO I=1, N
        T(I) = FLOAT(I) - 0.5
        F(I) = FI(I)
      ENDDO
C
      T(0)   = 2.0*T(1) - T(2)
      F(0)   = 2.0*F(1) - F(2)
      T(N+1) = 2.0*T(N) - T(N-1)
      F(N+1) = 2.0*F(N) - F(N-1)
C
      CALL SPLINE(F(0),FT(0),T(0),N+2)
C
      DO I=1, N
        FO(2*I-1) = SEVAL(T(I)-0.25,F(0),FT(0),T(0),N)
        FO(2*I  ) = SEVAL(T(I)+0.25,F(0),FT(0),T(0),N)
      ENDDO
C
      IF(NSGN.GT.0) NSGN = 2*N
C
      RETURN
      END


      SUBROUTINE FDBLT(FI,FO,TO,NSGN)
      DIMENSION FI(*), FO(*), TO(*)
C-------------------------------------------------------------
C     Same as FDBL, but splines to passed-in parameters TO(i)
C-------------------------------------------------------------
      DIMENSION T(1000), F(1000), FT(1000)
C
      N = IABS(NSGN)
C
      IF(N.GT.1000) STOP 'FDBLT: Local-array overflow.'
C
      DO I=1, N
        IN = 2*I - 1
        T(I) = TO(IN)
        F(I) = FI(I)
      ENDDO
C
      CALL SPLINE(F,FT,T,N)
C
      DO I=1, 2*N - 1
        FO(I) = SEVAL(TO(I),F,FT,T,N)
      ENDDO
C
      IF(NSGN.GT.0) NSGN = 2*N - 1
C
      RETURN
      END


      SUBROUTINE FDBLT4(FI,FO,TO,NSGN)
      DIMENSION FI(*), FO(*), TO(*)
C-------------------------------------------------------------
C     Same as FDBL4, but splines to passed-in parameters TO(i)
C-------------------------------------------------------------
      DIMENSION T(0:1001), F(0:1001), FT(0:1001)
C
      N = IABS(NSGN)
C
      IF(N.GT.1000) STOP 'FDBLT4: Local-array overflow.'
C
      DO I=1, N
        T(I) = TO(2*I)
        F(I) = FI(I)
      ENDDO
C
      T(0)   =  2.0*T(1) - T(2)
      F(0)   =  2.0*F(1) - F(2)
      T(N+1) =  2.0*T(N) - T(N-1)
      F(N+1) =  2.0*F(N) - F(N-1)
C
      CALL SPLINE(F(0),FT(0),T(0),N+2)
C
      DO I=1, N
        TOM = 0.5*(TO(2*I) + TO(2*I-1))
        TOP = 0.5*(TO(2*I) + TO(2*I+1))
        FO(2*I-1) = SEVAL(TOM,F(0),FT(0),T(0),N+2)
        FO(2*I  ) = SEVAL(TOP,F(0),FT(0),T(0),N+2)
      ENDDO
C
      IF(NSGN.GT.0) NSGN = 2*N
C
      RETURN
      END





      SUBROUTINE HALVE(LOK)
      INCLUDE 'STATE.INC'
C-------------------------------------------------------------
C     Halves the grid density of the current case.
C     Resets all grid indices appropriately.
C     Sets coarse solution onto the new coarse grid.
C-------------------------------------------------------------
      LOGICAL LOK
C
      DIMENSION TEMP(JX)
      DIMENSION XPS(IX,3), YPS(JX)
      DIMENSION IOLD(IX), JOLD(JX), JNEW(JX), NSTRM(JX)
      DIMENSION JS1(0:NBX+1), JS2(0:NBX+1)
      DIMENSION SBSIDE(2*NBX)
C
C---- grid indices of new coarse grid
      IINEW = (II-1    )/2 + 1
      JJNEW = (JJ-1+NBL)/2 + 1
C
      LOK = .TRUE.
C
      IF(MOD(II,2).EQ.0) THEN
        WRITE(*,*) 'HALVE:  I dimension is even:', II
        LOK = .FALSE.
      ENDIF
C
      DO N=1, NBL
        ILE = NINL(N)
        ITE = II - NOUT(N) + 1
        IF(MOD(ILE,2).EQ.0) THEN
          WRITE(*,*) 'HALVE:  LE i index is even,  element,i:', N,ILE
          LOK = .FALSE.
        ENDIF
        IF(MOD(ITE,2).EQ.0) THEN
          WRITE(*,*) 'HALVE:  TE i index is even.  element,i:', N,ITE
          LOK = .FALSE.
        ENDIF
      ENDDO
C
      JDIF = JJ - JBLD(1) + 1
      IF(MOD(JDIF,2).EQ.0) THEN
        WRITE(*,*) 
     &   'HALVE:  Even number of streamlines above element', 1
        LOK = .FALSE.
      ENDIF
C
      DO N=2, NBL
        JDIF = JBLD(N-1) - JBLD(N)
        IF(MOD(JDIF,2).EQ.0) THEN
          WRITE(*,*) 
     &     'HALVE:  Even number of streamlines between elements ',N-1,N
          LOK = .FALSE.
        ENDIF
      ENDDO
C
      JDIF = JBLD(NBL) - 1
      IF(MOD(JDIF,2).EQ.0) THEN
        WRITE(*,*) 
     &   'HALVE:  Even number of streamlines below element', NBL
        LOK = .FALSE.
      ENDIF
C
C
      IF(.NOT.LOK) THEN
        WRITE(*,*) '        Cannot coarsen grid.'
        RETURN
      ENDIF
C
      WRITE(*,*) 'Coarsening grid...'
C
C---- initialize index of blade touching streamline j
      DO J=1, JJ
        NSTRM(J) = 0
      ENDDO
C
C---- current airfoil-side j indices
      JS2(0) = JJ
      DO N=1, NBL
        J1 = JBLD(N)
        J2 = JBLD(N) - 1
        JS1(N) = J1
        JS2(N) = J2
        NSTRM(J1) = N
        NSTRM(J2) = N
C
        IS1 = 2*N - 1
        IS2 = 2*N
        SBSIDE(IS1) = SB(     1,N) - SBLE(N)
        SBSIDE(IS2) = SB(IIB(N),N) - SBLE(N)
      ENDDO
      JS1(NBL+1) = 1
C
C---- set old i stations corresponding to new i stations
      DO IN=1, IINEW
        IOLD(IN) = 2*IN - 1
      ENDDO
C
C---- set old j streamlines corresponding to new j streamlines
      J = JJ
      JN2 = JJNEW
      DO N=0, NBL
        JN1 = JN2 - (JS2(N)-JS1(N+1))/2
        DO JN = JN2, JN1, -1
          JNEW(J)    = JN
          JOLD(JN)   = J
          J = J - 2
        ENDDO
        J = J + 1
C
        JN2 = JN1-1
      ENDDO
C
C---- set "old" YPS array by summing mass fractions
      YPS(1) = 0.0
      DO N=NBL+1, 1, -1
        J2 = JS2(N-1)
        J1 = JS1(N)
        DO J=J1, J2-1
          YPS(J+1) = YPS(J) + MFRACT(J)
        ENDDO
        YPS(J2+1) = YPS(J2)
      ENDDO
C
C---- go over streamline blocks
      DO JN=1, JJNEW
        J = JOLD(JN)
        YPS(JN) = YPS(J)
      ENDDO
C
C---- set new mass fractions from halved YPS
      DO JN=1, JJNEW-1
        MFRACT(JN) = YPS(JN+1) - YPS(JN)
      ENDDO
C
C---- go over airfoil sides
      DO IS=1, 2*NBL
C
C------ halve BL variable arrays
        DO IN=1, IINEW
          I = IOLD(IN)
          DISP(IN,IS) = DISP(I,IS) 
          CTAU(IN,IS) = CTAU(I,IS)
          THET(IN,IS) = THET(I,IS)
          DSTR(IN,IS) = DSTR(I,IS)
          UEDG(IN,IS) = UEDG(I,IS)
           TAU(IN,IS) =  TAU(I,IS)
        ENDDO
C
C------ halve specified-pressure array
        N = (IS+1)/2
        DO IGT = 1, (NBLD(N)-1)/2 + 1
          IG = 2*IGT - 1
          SG(IGT,IS) = SG(IG,IS)
          PSPEC(IGT,IS) = PSPEC(IG,IS)
        ENDDO
C
C------ new undivided 2nd pressure derivatives
        PXX0(IS) = 4.0*PXX0(IS)
        PXX1(IS) = 4.0*PXX1(IS)
      ENDDO
C
      DO N=1, NBL
C------ halve wake trajectory, wake gap, wake spacing array
        DO IGT = 1, (NOUT(N)-1)/2 + 1
          IG = 2*IGT - 1
          XW(IGT,N) = XW(IG,N)
          YW(IGT,N) = YW(IG,N)
          WGAP(IGT,N) = WGAP(IG,N)
          SGOUT(IGT,N) = SGOUT(IG,N)
        ENDDO
C
C------ halve inlet-streamline spacing array
        DO IGT = 1, (NINL(N)-1)/2 + 1
          IG = 2*IGT - 1
          SGINL(IGT,N) = SGINL(IG,N)
        ENDDO
      ENDDO
C
C
C---- halve x,y arrays
      DO JN = 1, JJNEW
        DO IN = 1, IINEW
          I = IOLD(IN)
          J = JOLD(JN)
          X(IN,JN) = X(I,J)
          Y(IN,JN) = Y(I,J)
        ENDDO
      ENDDO
C
C---- halve density array
      DO JN = 1, JJNEW-1
        DO IN = 1, IINEW-1
          I = IOLD(IN)
          J = JOLD(JN)
          MSUM = MFRACT(J) + MFRACT(J+1)
          R(IN,JN) = ( MFRACT(J  )*(R(I,J+1)+R(I+1,J+1))
     &               + MFRACT(J+1)*(R(I,J  )+R(I+1,J  )) ) * 0.5/MSUM
        ENDDO
      ENDDO
C
C
C---- set new indices
C
      DO N=1, NBL
        NINL(N) = (NINL(N)-1)/2 + 1
        NBLD(N) = (NBLD(N)-1)/2 + 1
        NOUT(N) = (NOUT(N)-1)/2 + 1
C
        JBLD(N) = JNEW(JS1(N))
      ENDDO
C
      II = IINEW
      JJ = JJNEW
C
      DO IS=1, 2*NBL
        IF(ITRAN(IS).NE.0) ITRAN(IS) = ITRAN(IS)/2 + 1
C
        IF(IGFIX(IS) .NE.0)  IGFIX( IS) = (IGFIX( IS)-1)/2 + 1
        IF(IGCORN(IS).NE.0)  IGCORN(IS) = (IGCORN(IS)-1)/2 + 1
C
        IF(IX0.NE.0) IX0 = (IX0-1)/2 + 1
        IF(IX1.NE.0) IX1 = (IX1-1)/2 + 1
      ENDDO
C
      RETURN
      END ! HALVE
