C
      SUBROUTINE INIT
C-------------------------------------
C     Initializes everything and does
C     random housekeeping before the
C     Newton cycle is started.
C-------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 ARGP1, FNAME, LINE
      LOGICAL ERROR
C
C---- set MSES version number
      VERSION = 2.98
C
      PIE = 4.0*ATAN(1.0)
      DTOR = PIE/180.0
C
      GAM = 1.0 / (1.0 - PSTOUT/(RSTOUT*HINF))
C
      GM1 = GAM - 1.0
      GP1 = GAM + 1.0
      GCON = GM1 / GAM
C
C---- Initialize pointers and indices for grid
      CALL INDINI
C
C---- read in MSES.xxx run control file
      CALL GETARG(1,ARGP1)
      FNAME = 'mses.'//ARGP1
      OPEN(2,FILE=FNAME,STATUS='OLD',FORM='FORMATTED')
C
C---- default flags
      LMIXI = .FALSE.
      LMODI = .FALSE.
      LPOSI = .FALSE.
      LMINV = .FALSE.
      LPXSET = .FALSE.
C
      DO 1 L=1, NGLX
        KGVAR(L) = 0
        KGCON(L) = 0
    1 CONTINUE
C
C
 1080 FORMAT(A)
C
C---- read global variable and global constraint indices (lines 1,2)
      READ(2,1080) LINE
      NGVAR = NGLX
      CALL GETINT(LINE,KGVAR,NGVAR,ERROR)
C
      READ(2,1080) LINE
      NGCON = NGLX
      CALL GETINT(LINE,KGCON,NGCON,ERROR)
C
C---- count number of indices
      NGVAR = 0
      NGCON = 0
      DO 2 L=1, NGLX
        IF(KGVAR(L).NE.0) NGVAR = NGVAR + 1
        IF(KGCON(L).NE.0) NGCON = NGCON + 1
    2 CONTINUE
C
C---- set various mode flags depending on specified indices
      DO 3 L=1, NGCON
        IF(KGCON(L).EQ.19) LPXSET = .TRUE.
        IF(KGCON(L).GE.11 .AND. KGCON(L).LE.12) LMIXI = .TRUE.
        IF(KGCON(L).GE.20 .AND. KGCON(L).LE.29) LMODI = .TRUE.
        IF(KGCON(L).GE.30 .AND. KGCON(L).LE.39) LPOSI = .TRUE.
        IF(KGCON(L).GE.40 .AND. KGCON(L).LE.49) LMINV = .TRUE.
    3 CONTINUE
C
C---- variable (16) must appear after (5) to assign DMAS1 dofs properly
      DO L=1, NGVAR-1
        IF(KGVAR(L).EQ.16) THEN
         DO LL=L+1, NGVAR
           IF(KGVAR(LL).EQ.5) THEN
C---------- switch 5,16 variables
            KGVAR(LL) = 16
            KGVAR(L)  = 5
            GO TO 4
           ENDIF
         ENDDO
        ENDIF
      ENDDO
 4    CONTINUE
C
C---- default inverse-side indices, and geometry/position mode numbers
C-    (might be read in from mses.xxx)
      ISMOVE = 999
      ISPRES = 999
      NMODN = 0
      NPOSN = 0
C
C
C---- hard-wired wall pressure and Ue extrapolation parameters
C-    (can be read in from mses.xxx -- uncomment READ line below)
      WXPT = 0.
      WXPD = 0.
      WXUT = 0.
      WXUD = 0.
C
c###
cc      pcwt = 0.0
C
C---- read remainder of mses.xxx
      READ(2,*) MACHIN, CLIFIN, ALFAIN
      READ(2,*) ISMOM, IFFBC
C
CC      READ(2,*) PCWT
CC      READ(2,*) WXPT, WXPD, WXUT, WXUD
C
      READ(2,*) REYNIN, ACRIT
      READ(2,*) (XTR1(IS), IS=1, 2*NBL)
      READ(2,*) MCRIT, MUCON
      READ(2,*,END=5) ISMOVE, ISPRES
      READ(2,*,END=5) NMODN, NPOSN
C
C---- there should be no modes chosen without the required global variables
      IF(.NOT.(LMODI.OR.LMINV)) NMODN = 0
      IF(.NOT. LPOSI          ) NPOSN = 0
C
      IF(NMODN.GT.NMODX) STOP 'INIT: Array overflow. NMODX too small.'
      IF(NPOSN.GT.NPOSX) STOP 'INIT: Array overflow. NPOSX too small.'
C
      IF((LMIXI .OR. LMINV) .AND.
     &   (ISMOVE.EQ.999 .OR. ISPRES.EQ.999)) THEN
       WRITE(*,*) 'Must specify ISMOVE and ISPRES in MSES.xxx'
       STOP
      ENDIF
C
 5    CLOSE(2)
C
C---- convert angle of attack to radians
      ALFAIN = ALFAIN*DTOR
C
C---- limit Mcrit to prevent indefinite 0/0 dissipation formula in SETUP
      MCRIT = MIN( MCRIT , 0.99999 )
C
C
C---- set viscous-calculation flag
      LVISC = REYNIN .NE. 0.0
C
C---- print out info just to make sure we're doing the right thing
      WRITE(*,6) VERSION, NAME
    6 FORMAT(/1X,'MSES v', F4.1
     &      //1X,A32)
C
CCC      IF(NBL.GT.1) THEN 
        DO 7 N = 1, NBL
          WRITE(*,8) N,JS1(N),JS2(N), ILEB(N), ITEB(N)
    7   CONTINUE
    8   FORMAT(1X,'Element',I2,':',
     &   '   Jtop =',I3,'  Jbot =',I3,'    iLE =',I4,'  iTE =', I4)
CCC      ENDIF
C
      WRITE(*,*)
      IF     (IFFBC.EQ.1) THEN
       WRITE(*,*) 'Solid wall far field'
      ELSEIF (IFFBC.EQ.2) THEN
       WRITE(*,*) 'Vortex + doublet far field'
      ELSEIF (IFFBC.EQ.3) THEN
       WRITE(*,*) 'Constant pressure far field'
      ELSEIF (IFFBC.EQ.4) THEN
       WRITE(*,*) 'Supersonic wave far field'
      ELSEIF (IFFBC.EQ.5) THEN
       WRITE(*,*) 'Supersonic wall far field'
C
      ELSEIF (IFFBC.EQ.6) THEN
       WRITE(*,*) 'Solid wall far field with prescribed wall shape'
      ELSEIF (IFFBC.EQ.7) THEN
       WRITE(*,*) 'Vortex + doublet far field with prescribed Cp(x)'
      ELSE
       WRITE(*,*) ' INIT: Illegal far field BC option: ', IFFBC
       STOP
      ENDIF
C
      WRITE(*,*)
      IF(.NOT.LMIXI .AND. .NOT.LMINV)
     &          WRITE(*,*) 'Analysis mode'
      IF(LMIXI) THEN
       N = NMIX
       WRITE(*,*) 'Mixed-Inverse mode on element', N, '  ...'
       IF(ISMOVE.EQ.-1) WRITE(*,*) '...Thickness-only geometry movement'
       IF(ISMOVE.EQ. 0) WRITE(*,*) '...Camber-only geometry movement'
       IF(ISMOVE.EQ. 1) WRITE(*,*) '...Upper side (1) geometry movement'
       IF(ISMOVE.EQ. 2) WRITE(*,*) '...Lower side (2) geometry movement'
       IF(ISPRES.EQ.0) WRITE(*,*) '...Delta(p) specified'
       IF(ISPRES.EQ.1) WRITE(*,*) '...Upper side (1) pressure specified'
       IF(ISPRES.EQ.2) WRITE(*,*) '...Lower side (2) pressure specified'
       WRITE(*,*) 'Freewall segment endpoints: ',IX0,IX1
       IF((ISMOVE.EQ.-1 .AND. ISPRES.EQ.0) .OR.
     &    (ISMOVE.EQ.1  .AND. ISPRES.EQ.2) .OR.
     &    (ISMOVE.EQ.2  .AND. ISPRES.EQ.1) )
     &  WRITE(*,*) 'Inverse problem is likely to be ill-conditioned !!!'
      ENDIF
C
      IF(LMINV) THEN
       WRITE(*,*) 'Modal-Inverse mode'
       IF(ISPRES.EQ.0) WRITE(*,*) '...Delta(p) specified'
       IF(ISPRES.EQ.1) WRITE(*,*) '...Upper side (1) pressure specified'
       IF(ISPRES.EQ.2) WRITE(*,*) '...Lower side (2) pressure specified'
      ENDIF
C
      IF(LMODI) WRITE(*,*) 'Element shape perturbation'
      IF(LPOSI) WRITE(*,*) 'Element position perturbation'
C
C
      IF(LVISC) WRITE(*,*) 'Boundary Layer coupling included'
C
      IF(ISMOM.EQ.1) WRITE(*,*) 'S-momentum will be conserved'
      IF(ISMOM.EQ.2) WRITE(*,*) 'Entropy will be conserved'
      IF(ISMOM.EQ.3) WRITE(*,*) 'S-momentum will be conserved, ',
     &                          'except near near leading edge'
      IF(ISMOM.EQ.4) WRITE(*,*) 'Entropy will be conserved, ',
     &                          'except near shocks'
C
      IF(MUCON.LT.0.0) WRITE(*,*) '1st-order upwinding will be used'
      IF(MUCON.GT.0.0) WRITE(*,*) '2nd-order upwinding will be used'
C
C---- set CL and Reynolds number for input verification
      IF(ICOUNT.EQ.0) THEN
       CL = 0.0
       REINF = 0.0
      ELSE
       CL = LIFT/(0.5*RHOINF*QINF**2)
       REINF = REYN*(RHOINF*QINF/MUINF)
      ENDIF
      SQCL = SQRT(ABS(CL))
C
C---- first assume that Mach and Reynolds number will be CL-independent
      LDEPRE = .FALSE.
      LDEPMA = .FALSE.
C
      LSINL = 0
      LSOUT = 0
      LCIRC = 0
      LALFA = 0
      LPDF0 = 0
      LPDF1 = 0
      LPDFL = 0
      LREYN = 0
      LPDX0 = 0
      LPDX1 = 0
      LPDD0 = 0
      LPDD1 = 0
      LMASS = 0
      LPREX = 0
      DO 10 N = 1, NBL
        LSBLE(N) = 0
        LMAS1(N) = 0
   10 CONTINUE
C
      DO 12 K=1, NMODX
        LMODN(K) = 0
        KMODN(K) = 0
   12 CONTINUE
C
      DO 14 K=1, NPOSX
        LPOSN(K) = 0
        KPOSN(K) = 0
   14 CONTINUE
C
C
C---- Assign righthand side column numbers to global iterates
C
      WRITE(*,*)
      WRITE(*,*) 'Active global variables ...'
C
      LGVAR = 1
      DO 20 L=1, NGVAR
        GOTO (201,202,203,204,205,19 ,207,208,209,210,
     &        211,212,213,214,215,216,19 ,19 ,19 ,220,
     &        221,222,223,224,225,226,227,228,229,230,
     &        231,232,233,234,235,236,237,238,239    ),  KGVAR(L)
C
   19   WRITE(*,*) 'Illegal variable code:', KGVAR(L)
        STOP
C
C-----------------------------------------------------------
  201   LGVAR = LGVAR + 1
        LSINL = LGVAR
        WRITE(*,*) ' 1  DSINL  inlet slope'
        GO TO 20
C-----------------------------------------------------------
  202   LGVAR = LGVAR + 1
        LSOUT = LGVAR
        WRITE(*,*) ' 2  DSOUT  outlet slope'
        GO TO 20
C-----------------------------------------------------------
  203   LGVAR = LGVAR + 1
        LCIRC = LGVAR
        WRITE(*,*) ' 3  DCIRC  far-field vortex strength'
        GO TO 20
C-----------------------------------------------------------
  204   LGVAR = LGVAR + 1
        LALFA = LGVAR
        WRITE(*,*) ' 4  DALFA  angle of attack'
        GO TO 20
C-----------------------------------------------------------
  205   DO 2051 N = 1, NBL
          LGVAR = LGVAR + 1
          LSBLE(N) = LGVAR
          WRITE(*,*)   ' 5  DSBLE  LE stagnation point for element ',N
          IF (N.GT.1) THEN
            LGVAR = LGVAR + 1
            LMAS1(N-1) = LGVAR
            WRITE(*,*) '    DMAS1  mass fraction DOF   for element ',N-1
          ENDIF
 2051   CONTINUE
        GO TO 20
C===========================================================
  207   LGVAR = LGVAR + 1
        LPDF0 = LGVAR
        WRITE(*,*) ' 7  DPDF0  zeroth moment prescribed Pi DOF'
        GO TO 20
C-----------------------------------------------------------
  208   LGVAR = LGVAR + 1
        LPDF1 = LGVAR
        WRITE(*,*) ' 8  DPDF1  first  moment prescribed Pi DOF'
        GO TO 20
C===========================================================
  209   LGVAR = LGVAR + 1
        LPREX = LGVAR
        WRITE(*,*) ' 9  DPREX  grid-exit static pressure'
        GO TO 20
C-----------------------------------------------------------
cc  209   LGVAR = LGVAR + 1
cc        LPDFL = LGVAR
cc        WRITE(*,*) ' 9  DPDFL  lift-setting  prescribed Pi DOF'
cc        GO TO 20
C-----------------------------------------------------------
  210   LGVAR = LGVAR + 1
        LREYN = LGVAR
        WRITE(*,*) '10  DREYN  stagnation Reynolds number DOF'
        GO TO 20
C===========================================================
  211   LGVAR = LGVAR + 1
        LPDX0 = LGVAR
        WRITE(*,*) '11  DPDX0  zeroth mixed inverse prescribed Pi DOF'
        GO TO 20
C-----------------------------------------------------------
  212   LGVAR = LGVAR + 1
        LPDX1 = LGVAR
        WRITE(*,*) '12  DPDX1  first  mixed inverse prescribed Pi DOF'
        GO TO 20
C-----------------------------------------------------------
  213   LGVAR = LGVAR + 1
        LPDD0 = LGVAR
        WRITE(*,*) '13  DPDD0  second mixed inverse prescribed Pi DOF'
        GO TO 20
C-----------------------------------------------------------
  214   LGVAR = LGVAR + 1
        LPDD1 = LGVAR
        WRITE(*,*) '14  DPDD1  third  mixed inverse prescribed Pi DOF'
        GO TO 20
C===========================================================
  215   LGVAR = LGVAR + 1
        LMASS = LGVAR
        WRITE(*,*) '15  DMASS  total mass flow'
        GO TO 20
C-----------------------------------------------------------
  216   NMAS1 = NBL-1
        IF (IFFBC.EQ.1) NMAS1 = NBL
        DO 2161 N = 1, NMAS1
          IF (LMAS1(N).NE.0) GO TO 2161
           LGVAR = LGVAR + 1
           LMAS1(N) = LGVAR
           WRITE(*,*) '16  DMAS1  mass fraction DOF for element ',N
 2161   CONTINUE
        GO TO 20
C===========================================================
  220   DO 2204 NN=1, NMODN
          LGVAR = LGVAR + 1
          KMODN(NN) = NN
          LMODN(NN) = LGVAR
 2204   CONTINUE
        WRITE(*,2209) NMODN
 2209   FORMAT(1X,'    DMOD   modal geometry DOFs  (',I2,')')
        GO TO 20
C-----------------------------------------------------------
  221   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(1) = LGVAR
        KMODN(NMODN) = 1
        WRITE(*,*) '21  DMOD1  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  222   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(2) = LGVAR
        KMODN(NMODN) = 2
        WRITE(*,*) '22  DMOD2  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  223   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(3) = LGVAR
        KMODN(NMODN) = 3
        WRITE(*,*) '23  DMOD3  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  224   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(4) = LGVAR
        KMODN(NMODN) = 4
        WRITE(*,*) '24  DMOD4  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  225   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(5) = LGVAR
        KMODN(NMODN) = 5
        WRITE(*,*) '25  DMOD5  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  226   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(6) = LGVAR
        KMODN(NMODN) = 6
        WRITE(*,*) '26  DMOD6  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  227   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(7) = LGVAR
        KMODN(NMODN) = 7
        WRITE(*,*) '27  DMOD7  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  228   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(8) = LGVAR
        KMODN(NMODN) = 8
        WRITE(*,*) '28  DMOD8  modal geometry DOF'
        GO TO 20
C-----------------------------------------------------------
  229   LGVAR = LGVAR + 1
        NMODN = NMODN + 1
        LMODN(9) = LGVAR
        KMODN(NMODN) = 9
        WRITE(*,*) '29  DMOD9  modal geometry DOF'
        GO TO 20
C===========================================================
  230   DO 2304 NN=1, NPOSN
          LGVAR = LGVAR + 1
          KPOSN(NN) = NN
          LPOSN(NN) = LGVAR
 2304   CONTINUE
        WRITE(*,2309) NPOSN
 2309   FORMAT(1X,'    DPOS   element position DOFs  (',I2,')')
        GO TO 20
C-----------------------------------------------------------
  231   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(1) = LGVAR
        KPOSN(NPOSN) = 1
        WRITE(*,*) '31  DPOS1  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  232   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(2) = LGVAR
        KPOSN(NPOSN) = 2
        WRITE(*,*) '32  DPOS2  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  233   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(3) = LGVAR
        KPOSN(NPOSN) = 3
        WRITE(*,*) '33  DPOS3  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  234   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(4) = LGVAR
        KPOSN(NPOSN) = 4
        WRITE(*,*) '34  DPOS4  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  235   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(5) = LGVAR
        KPOSN(NPOSN) = 5
        WRITE(*,*) '35  DPOS5  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  236   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(6) = LGVAR
        KPOSN(NPOSN) = 6
        WRITE(*,*) '36  DPOS6  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  237   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(7) = LGVAR
        KPOSN(NPOSN) = 7
        WRITE(*,*) '37  DPOS7  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  238   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(8) = LGVAR
        KPOSN(NPOSN) = 8
        WRITE(*,*) '38  DPOS8  element position DOF'
        GO TO 20
C-----------------------------------------------------------
  239   LGVAR = LGVAR + 1
        NPOSN = NPOSN + 1
        LPOSN(9) = LGVAR
        KPOSN(NPOSN) = 9
        WRITE(*,*) '39  DPOS9  element position DOF'
C-----------------------------------------------------------
C
   20 CONTINUE
C
      IF((LMODI .OR. LMINV) .AND.
     &                NMODN.EQ.0) STOP '? Number of modal DOFs = 0'
      IF( LPOSI .AND. NPOSN.EQ.0) STOP '? Number of position DOFs = 0'
C
C---- Set number of global unknowns and number of RHS's
      NGLOB = LGVAR-1
      NRHS  = NGLOB+1
      WRITE(*,22) NGLOB
   22 FORMAT(/' Number of global variables : ',I2)
C
      IF(NRHS.GT.NGLX) 
     &   STOP 'INIT: Too many righthand sides. Increase NGLX.'
C
C
      WRITE(*,*)
      WRITE(*,*) 'Active global constraints ...'
C
      IGCON = 0
      DO 30 KGC=1, NGCON
        LGCON(KGC) = IGCON + 1
        GOTO (301,302,303,304,305,306,307,308,309,310,
     &        311,312,313,314,315,316,317,318,319,320,
     &        321,322,323,324,325,326,327,328,329,330,
     &        331,332,333,334,335,336,337,338,339,340,
     &        341,342,343,344,345,346,347,348,349    ),    KGCON(KGC)
C
  29    WRITE(*,*) 'Illegal constraint code:', KGCON(KGC)
        STOP
C
C-----------------------------------------------------------
  301   IGCON = IGCON + 1
        WRITE(*,*) ' 1  Drive inlet  slope from ',SINL,' to ',SINLIN
        GO TO 30
C-----------------------------------------------------------
  302   IGCON = IGCON + 1
        WRITE(*,*) ' 2  Drive outlet slope from ',SOUT,' to ',SOUTIN
        GO TO 30
C===========================================================
  303   IGCON = IGCON + NBL
        WRITE(*,*) ' 3  Set LE Kutta condition for',NBL,'  Elements'
        GO TO 30
C-----------------------------------------------------------
  304   IGCON = IGCON + NBL
        WRITE(*,*) ' 4  Set TE Kutta condition for',NBL,'  Elements'
        GO TO 30
C-----------------------------------------------------------
  305   IGCON = IGCON + 1
        WRITE(*,*) ' 5  Drive alpha from ',ALFA/DTOR,' to ',ALFAIN/DTOR
        GO TO 30
C-----------------------------------------------------------
  306   IGCON = IGCON + 1
        WRITE(*,*) ' 6  Drive CL from ',CL,' to ',CLIFIN
        GO TO 30
C===========================================================
  307   IGCON = IGCON + 1
        WRITE(*,*) ' 7  Drive LE gap to zero'
        GO TO 30
C-----------------------------------------------------------
  308   IGCON = IGCON + 1
        WRITE(*,*) ' 8  Drive TE gap to zero'
        GO TO 30
C-----------------------------------------------------------
  309   IGCON = IGCON + 1
        WRITE(*,*) ' 9  Fix LE point'
        GO TO 30
C-----------------------------------------------------------
  310   IGCON = IGCON + 1
        WRITE(*,*) '10  Fix TE point'
        GO TO 30
C-----------------------------------------------------------
  311   IGCON = IGCON + 1
        WRITE(*,*) '11  Fix left  endpoint of freewall segment'
        GO TO 30
C-----------------------------------------------------------
  312   IGCON = IGCON + 1
        WRITE(*,*) '12  Fix right endpoint of freewall segment'
        GO TO 30
C-----------------------------------------------------------
  313   IGCON = IGCON + 1
        WRITE(*,*) '13  Fix Pxx at left  endpoint of freewall segment'
        GO TO 30
C-----------------------------------------------------------
  314   IGCON = IGCON + 1
        WRITE(*,*) '14  Fix Pxx at right endpoint of freewall segment'
        GO TO 30
C===========================================================
 315    IGCON = IGCON + 1
        WRITE(*,*) '15  Drive Mach from',MINF,'to', MACHIN
        GO TO 30
C-----------------------------------------------------------
 316    IGCON = IGCON + 1
        WRITE(*,*) '16  Drive Mach*sqrt(CL) from', MINF*SQCL,'to',MACHIN
        LDEPMA = .TRUE.
        GO TO 30
C-----------------------------------------------------------
 317    IGCON = IGCON + 1
        WRITE(*,*) '17  Drive Reyn from',REINF,'to',REYNIN
        GO TO 30
C-----------------------------------------------------------
 318    IGCON = IGCON + 1
        WRITE(*,*) '18  Drive Reyn*sqrt(CL) from',REINF*SQCL,'to',REYNIN
        LDEPRE = .TRUE.
        GO TO 30
C===========================================================
 319    IGCON = IGCON + 1
        WRITE(*,*) '19  Drive mass-averaged inlet Pst to Pstinf'
        GO TO 30
C===========================================================
  320   IGCON = IGCON + NMODN
        WRITE(*,3209) NMODN
 3209   FORMAT(1X,'    DMOD  fixing constraints   (',I2,')')
        GO TO 30
C-----------------------------------------------------------
  321   IGCON = IGCON + 1
        WRITE(*,*) '21  DMOD1 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  322   IGCON = IGCON + 1
        WRITE(*,*) '22  DMOD2 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  323   IGCON = IGCON + 1
        WRITE(*,*) '23  DMOD3 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  324   IGCON = IGCON + 1
        WRITE(*,*) '24  DMOD4 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  325   IGCON = IGCON + 1
        WRITE(*,*) '25  DMOD5 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  326   IGCON = IGCON + 1
        WRITE(*,*) '26  DMOD6 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  327   IGCON = IGCON + 1
        WRITE(*,*) '27  DMOD7 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  328   IGCON = IGCON + 1
        WRITE(*,*) '28  DMOD8 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  329   IGCON = IGCON + 1
        WRITE(*,*) '29  DMOD9 fixing constraint'
        GO TO 30
C===========================================================
  330   IGCON = IGCON + NPOSN
        WRITE(*,3309) NPOSN
 3309   FORMAT(1X,'    DPOS  fixing constraints   (',I2,')')
        GO TO 30
C-----------------------------------------------------------
  331   IGCON = IGCON + 1
        WRITE(*,*) '31  DPOS1 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  332   IGCON = IGCON + 1
        WRITE(*,*) '32  DPOS2 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  333   IGCON = IGCON + 1
        WRITE(*,*) '33  DPOS3 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  334   IGCON = IGCON + 1
        WRITE(*,*) '34  DPOS4 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  335   IGCON = IGCON + 1
        WRITE(*,*) '35  DPOS5 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  336   IGCON = IGCON + 1
        WRITE(*,*) '36  DPOS6 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  337   IGCON = IGCON + 1
        WRITE(*,*) '37  DPOS7 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  338   IGCON = IGCON + 1
        WRITE(*,*) '38  DPOS8 fixing constraint'
        GO TO 30
C-----------------------------------------------------------
  339   IGCON = IGCON + 1
        WRITE(*,*) '39  DPOS9 fixing constraint'
        GO TO 30
C===========================================================
  340   IGCON = IGCON + NMODN
        WRITE(*,3409) NMODN
 3409   FORMAT(1X,'    DMOD  modal inverse constraints   (',I2,')')
        GO TO 30
C-----------------------------------------------------------
  341   IGCON = IGCON + 1
        WRITE(*,*) '41  DMOD1 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  342   IGCON = IGCON + 1
        WRITE(*,*) '42  DMOD2 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  343   IGCON = IGCON + 1
        WRITE(*,*) '43  DMOD3 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  344   IGCON = IGCON + 1
        WRITE(*,*) '44  DMOD4 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  345   IGCON = IGCON + 1
        WRITE(*,*) '45  DMOD5 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  346   IGCON = IGCON + 1
        WRITE(*,*) '46  DMOD6 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  347   IGCON = IGCON + 1
        WRITE(*,*) '47  DMOD7 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  348   IGCON = IGCON + 1
        WRITE(*,*) '48  DMOD8 modal inverse constraint'
        GO TO 30
C-----------------------------------------------------------
  349   IGCON = IGCON + 1
        WRITE(*,*) '49  DMOD9 modal inverse constraint'
C-----------------------------------------------------------
C
  30  CONTINUE
C
      WRITE(*,32) IGCON
   32 FORMAT(/' Number of global constraints : ',I2)
C
      IF(NGLOB .NE. IGCON) STOP 
     & '*** Different number of global variables and constraints. ***'
C
C---- try to read new parameters for optimization cases
      IF(LMODI .OR. LPOSI) CALL READOP(ARGP1)
C
C---- set freestream Mach number if it's not a global variable
      IF(ICOUNT.EQ.0 .OR. LMASS.EQ.0) MINF = MACHIN
C
      IF(ICOUNT.EQ.0 .AND. LDEPMA) THEN
C----- use CLIFIN for better initial guess if Mach is CL-dependent
       IF(CLIFIN.GT.0.0) MINF = MACHIN/SQRT(CLIFIN)
       WRITE(*,*)
       WRITE(*,*) 'Freestream Mach initialized to', MINF
      ENDIF
C
      qiold = qinf
c
C---- set all freestream variables from freestream Mach number
      CALL FFCALC
C
      if(qiold.gt.0.0) then
        do is=1, 2*nbl
          do i=1, ii-1
            uedg(i,is) = uedg(i,is) * qinf/qiold
          enddo
        enddo
      endif
C
C---- calculate sonic quantities
      QSTAR = SQRT(2.0*HINF/(2.0/GM1 + 1.0))
      PSTAR = PSTOUT*(1.0 + 0.5*GM1)**(-GAM/GM1)
      RSTAR = RSTOUT*(1.0 + 0.5*GM1)**(-1.0/GM1)
C
C---- calculate total domain mass flow from capture area
      AINF = YBTOP - YBBOT
      MASSIN = RHOINF*QINF*AINF
C
C---- if total mass is not a global variable, then set it explicitly
      IF(ICOUNT.EQ.0 .OR. LMASS.EQ.0) THEN
       MASS = MASSIN
      ENDIF
C
C---- initialize stagnation-condition Reynolds number
      IF(ICOUNT.EQ.0 .OR. REYN.EQ.0.0 .OR. LREYN.EQ.0) 
     &   REYN = REYNIN/(RHOINF*QINF/MUINF)
C
      IF((ICOUNT.EQ.0 .OR. REYN.EQ.0.0) .AND. LDEPRE) THEN
C----- use CLIFIN for better initial guess if Re is CL-dependent
       IF(CLIFIN.GT.0.0) REYN = REYNIN/(RHOINF*QINF/MUINF)/SQRT(CLIFIN)
       WRITE(*,*)
       WRITE(*,*) 'Reynolds number initialized to', REYNIN/SQRT(CLIFIN)
      ENDIF
C
C---- transition must occur no later than trailing edge
      DO N = 1, NBL
        I1 = 2*(N-1) + 1
        I2 = I1 + 1
        XTR1(I1) = MIN( XTR1(I1) ,  1.0 )
        XTR1(I2) = MIN( XTR1(I2) ,  1.0 )
        XTR1(I1) = MAX( XTR1(I1) , -1.0 )
        XTR1(I2) = MAX( XTR1(I2) , -1.0 )
      ENDDO
C
C---- default LE mode endpoint locations
      DO N=1, NBL
        SBLEGN(N) = SBNOSE(N)
      ENDDO
C
C---- initialize entire flowfield to something half-reasonable
      IF(INITRQ.EQ.0) CALL RQINIT
C
      CALL XYSINI
C
C---- do sanity checks on user input
      IF(IFFBC.EQ.1 .AND. LCIRC.NE.0) THEN
       WRITE(*,*)
     &   '*** Circulation DOF(3) incompatible with solid-wall BCs !'
      ENDIF
C
      IF(IFFBC.EQ.2 .AND. LMAS1(NBL).NE.0) THEN
       WRITE(*,*)
     &   '*** Mass-fraction DOF(16) incompatible with vortex BCs !'
      ENDIF
C
      IF(IFFBC.EQ.4 .OR. IFFBC.EQ.5 .AND. LCIRC.NE.0) THEN
       WRITE(*,*)
     &   '*** Circulation DOF(3) incompatible with supersonic BCs !'
      ENDIF
C
      RETURN
      END ! INIT



      SUBROUTINE XYSINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      IF(LMIXI) THEN
C
        N = NMIX
        ILE = ILEB(N)
        ITE = ITEB(N)
        I1 = IS1(N)
        I2 = IS2(N)
C
C------ set specified pressure DOF shape functions
        DO 70 I=ILE, ITE
          FX0(I) = 0.0
          FX1(I) = 0.0
          FD0(I) = 0.0
          FD1(I) = 0.0
   70   CONTINUE
C
        IGX0 = IX0-ILE+1
        IGX1 = IX1-ILE+1
        DO 75 I=IX0, IX1
          IG = I-ILE+1
          IF(ISPRES.EQ.0) THEN
           TTT1 = (SG(IG  ,I1) - SG(IGX0,I1))
     &          / (SG(IGX1,I1) - SG(IGX0,I1))
           TTT2 = (SG(IG  ,I2) - SG(IGX0,I2))
     &          / (SG(IGX1,I2) - SG(IGX0,I2))
           TTT = 0.5*(TTT1 + TTT2)
          ELSE IF(ISPRES.EQ.1) THEN
           TTT = (SG(IG  ,I1) - SG(IGX0,I1))
     &         / (SG(IGX1,I1) - SG(IGX0,I1))
          ELSE IF(ISPRES.EQ.2) THEN
           TTT = (SG(IG  ,I2) - SG(IGX0,I2))
     &         / (SG(IGX1,I2) - SG(IGX0,I2))
          ELSE
           STOP 'Illegal ISPRES trigger'
          ENDIF
          FX0(I) = TTT
          FX1(I) = 1.0 - TTT
          FD0(I) = EXP(-3.0*TTT)
          FD1(I) = EXP(3.0*TTT - 3.0)
   75   CONTINUE
C
      ENDIF
C
C---- set arc length arrays for BL equations
      CALL XICALC
C
C---- spline wake trajectories
      DO N=1, NBL
        CALL SPWAKE(N)
      ENDDO
C
      RETURN
      END ! XYSINI


      SUBROUTINE READOP(ARGP1)
C------------------------------------------------------------
C     Reads optimization-change params.xxx file if it exists.
C     Overwrites specified geometry and position modes.
C     Overwrites specified alpha, CL, Mach, Re
C------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 ARGP1, FNAME
      CHARACTER*1 ANS
C
      DTOR = PIE/180.0
C
      FNAME = 'params.' // ARGP1
      OPEN(8,FILE=FNAME,STATUS='OLD',ERR=90)
C
      IBLANK = INDEX(FNAME,' ')
      IF(ICOUNT.LE.1) THEN
C----- suspicious... params.xxx file is being used with new case (user error?)
       WRITE(*,*) 'Read new parameters from ',FNAME(1:IBLANK-1),'?  Y'
       READ (*,1000) ANS
       IF(INDEX('Nn',ANS).NE.0) THEN
        GO TO 89
       ENDIF
C
      ELSE
       WRITE(*,1010) FNAME(1:IBLANK-1)
 1010  FORMAT(/1X,'Reading new parameters from  ',A,' ...')
C
      ENDIF
C
      READ(8,*) NMOD1, NPOS1
C
      IF(IABS(NMOD1).NE.NMODN) THEN
       WRITE(*,*) '*** Wrong number of geometry modes. File not read.'
       GO TO 89
      ENDIF
C
      IF(IABS(NPOS1).NE.NPOSN) THEN
       WRITE(*,*) '*** Wrong number of position modes. File not read.'
       GO TO 89
      ENDIF
C
C---- read new mode amplitudes, and set changes to be executed
      DO 41 N=1, NMODN
        K = KMODN(N)
        READ(8,*) MODN1
        DMSPN(K) = MODN1 - MODN(K)
        IF(NMOD1.LT.0) DMSPN(K) = MODN1
 41   CONTINUE
      DO 42 N=1, NPOSN
        K = KPOSN(N)
        READ(8,*) POSN1
        DPSPN(K) = POSN1 - POSN(K)
        IF(NPOS1.LT.0) DPSPN(K) = POSN1
 42   CONTINUE
C
      READ(8,*,END=80) ADEG1, CLIF1, MINF1, RINF1
C
      IF(LDEPMA) MINF1 = MINF1*SQRT(CLIF1)
      IF(LDEPRE) RINF1 = RINF1*SQRT(CLIF1)
C
C---- set specified flow parameters
      ALFAIN = ADEG1*DTOR
      CLIFIN = CLIF1
      MACHIN = MINF1
      REYNIN = RINF1
C
cC---- set specified changes in flow parameters
c      CL    = LIFT/(0.5*RHOINF*QINF**2)
c      REINF = REYN*(RHOINF*QINF/MUINF)
c      ALFAIN = ALFA  + ADEG1*DTOR
c      CLIFIN = CL    + CLIF1
c      MACHIN = MINF  + MINF1
c      REYNIN = REINF + RINF1
C
      WRITE(*,1200) ALFAIN/DTOR, CLIFIN, MACHIN, REYNIN/1.0E6
 1200 FORMAT(/1X,'New flow conditions:',
     &       /1X,'ALFAIN =',F10.5,'     CLIFIN =',F10.5,
     &       /1X,'MACHIN =',F10.5,'     REYNIN =',F10.5,'e6'/)
C
      GO TO 89
C
 80   WRITE(*,*) '*** New flow conditions not set.'
C
 89   CLOSE(8)
 90   RETURN
C
 1000 FORMAT(A)
      END ! READOP
 
 
      SUBROUTINE INDINI
C------------------------------------------------------------------
C    Initializes indices and pointers for element(s)
C
C    IS arrays give side indices for element
C       IS1 - top    side (odd) 
C       IS2 - bottom side (even) 
C
C    JS arrays give J line corresponding to element side
C       JS1 - top    side 
C       JS2 - bottom side
C
C    JSTAG links the J lines and the element sides
C                 0 for J line not corresponding to element side
C                -IS1 for top    side on element
C                +IS2 for bottom side on element
C
C Note: JSTAG(J) > 0 indicates a dummy streamtube J (containing an airfoil)
C
C    KBNFIX(IS)   is the number of prescribed-direction Delta* 
C                   vectors for side IS
C    IBNFIX(K,IS) are the i locations of these vectors
C
C------------------------------------------------------------------
C
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL DONE
C
      DO 10 J = 1, JJ
        JSTAG(J) = 0
   10 CONTINUE
C
      DO 20 N = 1, NBL
        ILE = NINL(N)
        ITE = II-NOUT(N)+1
        ILEB(N) = ILE
        ITEB(N) = ITE
C
        IS1(N) = 2*N - 1
        IS2(N) = 2*N
C
        JS1(N) = JBLD(N)
        JS2(N) = JBLD(N) - 1
        IF (JS2(N).LT.1) JS2(N) = JJ
C
        JSTAG(JS1(N)) = -IS1(N)
        JSTAG(JS2(N)) =  IS2(N)
   20 CONTINUE
C
C
C==== set prescribed-direction d* vector indices at LE, corners, TE lines.
C
C---- first set vector indices at LE, corner, and TE on each side
      DO 30 IS=1, 2*NBL
        N = (IS+1)/2
        KBNFIX(IS) = 1
        IBNFIX(1,IS) = ILEB(N)
C
        IF(IGCORN(IS).NE.0) THEN
         KBNFIX(IS) = KBNFIX(IS) + 1
         IBNFIX(KBNFIX(IS),IS) = ILEB(N) + IGCORN(IS) - 1
        ENDIF
C
        KBNFIX(IS) = KBNFIX(IS) + 1
        IBNFIX(KBNFIX(IS),IS) = ITEB(N)
 30   CONTINUE
C
C---- go over each TE, and vector indices above each TE
      DO 41 IS=1, 2*NBL, 2
        N = (IS+1)/2
        I = ITEB(N)
        DO 415 KS=IS-1, 1, -1
          NN = (KS+1)/2
          IF(I.LE.ITEB(NN)) GO TO 416
           KBNFIX(KS) = KBNFIX(KS) + 1
           IBNFIX(KBNFIX(KS),KS) = I
 415    CONTINUE
 416    CONTINUE
 41   CONTINUE
C
C---- go over each TE, and vector indices below each TE
      DO 42 IS=2, 2*NBL, 2
        N = (IS+1)/2
        I = ITEB(N)
        DO 425 KS=IS+1, 2*NBL
          NN = (KS+1)/2
          IF(I.LE.ITEB(NN)) GO TO 426
           KBNFIX(KS) = KBNFIX(KS) + 1
           IBNFIX(KBNFIX(KS),KS) = I
 425    CONTINUE
 426    CONTINUE
 42   CONTINUE
C
      DO 45 IS=1, 2*NBL
        KBNFIX(IS) = KBNFIX(IS) + 1
        IBNFIX(KBNFIX(IS),IS) = II
        IF(KBNFIX(IS).GT.ISX+3) STOP 'INDINI: KBNFIX array overflow.'
 45   CONTINUE
C
C---- sort d* vector index array
      DO 50 IS=1, 2*NBL
        DONE = .TRUE.
        DO 505 IPASS=1, 1234
          DO 5052 K=1, KBNFIX(IS)-1
            IF(IBNFIX(K,IS) .GT. IBNFIX(K+1,IS)) THEN
              ITMP = IBNFIX(K,IS)
              IBNFIX(K,IS) = IBNFIX(K+1,IS)
              IBNFIX(K+1,IS) = ITMP
              DONE = .FALSE.
            ENDIF
 5052     CONTINUE
          IF(DONE) GO TO 50
 505    CONTINUE
 50   CONTINUE
C
      RETURN
      END ! INDINI

 
      SUBROUTINE FFCALC
C-------------------------------------------------------
C     Calculates static freestream flow variables from
C     stagnation quantities and freestream Mach number.
C-------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      HINF   = 1.0/GM1
      RSTOUT = 1.0
      PSTOUT = RSTOUT*HINF*GM1/GAM
C
      TTR = 1.0 + 0.5*GM1*MINF**2
C
      RHOINF = RSTOUT*TTR**(-1.0/GM1)
      PINF   = PSTOUT*TTR**(-GAM/GM1)
C
      QINF = SQRT( GM1*HINF * MINF**2 / TTR )
C
      GINF = HINF - 0.5*QINF**2
      MUINF = SQRT((GINF/HINF)**3) * (HINF+HVIS)/(GINF+HVIS)
     &      * RSTOUT*SQRT(GM1*HINF)
C
C
C---- set sensitivities to M^2
      RI_MSQ = -0.5*RHOINF   / TTR
      PI_MSQ = -0.5*GAM*PINF / TTR
C
      QI_MSQ = 0.5*GM1*(HINF/QINF) / TTR**2
C
CCC   MASS = RHOINF*QINF*AINF
      MS_MSQ = (RI_MSQ*QINF + RHOINF*QI_MSQ)*AINF
C
      QU     = 0.5*RHOINF*QINF**2
      QU_MSQ = 0.5*RI_MSQ*QINF**2
     &       +     RHOINF*QINF*QI_MSQ
C
      MU_MSQ = (1.5*MUINF/GINF - MUINF/(GINF+HVIS)) * (-QINF) * QI_MSQ
C
      RETURN
      END ! FFCALC
 
 
 
      SUBROUTINE RQINIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- initialize flowfield to freestream quantities
      DO 1 J=1, JJ-1
        IF(JSTAG(J).GT.0) GO TO 1
        DO 11 I=1, II-1
          R(I,J) = RHOINF
          Q(I,J) = QINF
   11   CONTINUE
    1 CONTINUE
C
cC---- MSET sets singularities for unit frestream speed.. adjust accordingly
c      CIRC = CIRC*QINF
c      DOUX = DOUX*QINF
c      DOUY = DOUY*QINF
C
C---- also adjust strengths for Mach number
      IF(MINF .LT. 1.0) THEN
       DFAC = 1.0 / SQRT(1.0 - MINF**2) 
       CIRC = CIRC * DFAC
       DOUX = DOUX * DFAC**3
       DOUY = DOUY * DFAC
      ENDIF
C
      INITRQ = 1
C
      RETURN
      END ! RQINIT


 
      SUBROUTINE NCALC
C--------------------------------------------------
C     Calculates usual Nhat vectors along which
C     the grid nodes are defined to move.
C
C     Calculates the Nhat vectors along which
C     the grid nodes move in response to the
C     leading edge DOF.
C--------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL OK
      DIMENSION RSCAL(NBX), EXPR(NBX)
      REAL NXGT, NYGT
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ NXGT(IX,2), NYGT(IX,2),
ccc     &             XT(IX),YT(IX),XST(IX),YST(IX),ST(IX),
ccc     &             AROT(IX,0:ISX+1), MFSUM(JX)
      DIMENSION NXGT(IX,2), NYGT(IX,2),
     &          XT(IX),YT(IX),XST(IX),YST(IX),ST(IX),
     &          AROT(IX,0:ISX+1), MFSUM(JX)
C
C---- set usual Nhat vectors perpendicular to all streamlines
      DO 10 JO=1, JJ
        ILE = 0
        ITE = 0
        IF (JSTAG(JO).NE.0) THEN
          IS = IABS(JSTAG(JO))
          N = (IS+1)/2
          ILE = ILEB(N)
          ITE = ITEB(N)
        ENDIF
        DO 105 IO=1, II
          IM = MAX0(IO-1,1)
          IP = MIN0(IO+1,II)
          IF(IO.EQ.ILE) IM = IO
          IF(IO.EQ.ITE) IP = IO
          DY =  X(IP,JO) - X(IM,JO)
          DX = -Y(IP,JO) + Y(IM,JO)
          DSINV = 1.0 / SQRT(DX*DX + DY*DY)
          NX(IO,JO) = DX*DSINV
          NY(IO,JO) = DY*DSINV
          NXA(IO,JO) = -Y(IO,JO)+YCENT
          NYA(IO,JO) =  X(IO,JO)-XCENT
 105    CONTINUE
 10   CONTINUE
C
C---- locate intersections of surface streamlines with all slide lines
      DO 20 IS=1, 2*NBL
        N = (IS+1)/2
        J = JBLD(N)  - (IS-2*N+1)
C
C------ spline streamline J
        DO 201 I=1, II
          XT(I) = X(I,J)
          YT(I) = Y(I,J)
 201    CONTINUE
        CALL SCALC (XT,YT ,ST,II)
        CALL SPLINE(XT,XST,ST,II)
        CALL SPLINE(YT,YST,ST,II)
C
        IM = IBNFIX(1,IS)
        AROT(IM,IS) = 0.0
        DO 203 K=2, KBNFIX(IS)-1
          IO = IBNFIX(K  ,IS)
          IM = IBNFIX(K-1,IS)
          IF(IO.LT.ITEB(N)) THEN
           AROT(IO,IS) = 0.0
           GO TO 203
          ENDIF
C
C-------- find element index whose TE originates current slide line
          DO 2031 NN=N, NBL
            IF(IO.EQ.ITEB(NN)) GO TO 2033
 2031     CONTINUE
          DO 2032 NN=N-1, 1, -1
            IF(IO.EQ.ITEB(NN)) GO TO 2033
 2032     CONTINUE
          WRITE(*,*) 'NCALC: TE not located. i = ', IBNFIX(K,IS)
          NN = 1
 2033     CONTINUE
C
          IF(NN.EQ.N) THEN
           KS = IS
          ELSE IF(NN.GT.N) THEN
           KS = 2*NN - 1
          ELSE
           KS = 2*NN
          ENDIF
C
C-------- sign of Nhat direction relative to slide-line arc length
          SGN = 1.0
          IF(MOD(KS,2).EQ.0) SGN = -1.0
C
C-------- set first intersection location guess
          KN = IABS(NN-N) + 1
          KN = MAX(KN,1)
          KN = MIN(KN,KNOR(KS))
          SNI = SNOR(KN,KS)
          STI = ST(IO)
C
C-------- calculate actual intersection location
          CALL INTERS(OK,SNI,STI,
     &       XNOR(1,KS),XSNOR(1,KS),
     &       YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS),
     &       XT,XST,
     &       YT,YST,ST,II )
          IF(.NOT.OK) WRITE(*,*) 'ks, is ite i:', KS, IS, ITEB(N), IO
C
          DX = SGN*DEVAL(SNI,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
          DY = SGN*DEVAL(SNI,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
C
C-------- set angle needed to lean Nhat vector
          DOT = NX(IO,J)*DX + NY(IO,J)*DY
          CRS = NX(IO,J)*DY - NY(IO,J)*DX
C
          AROT(IO,IS) = ATAN2(CRS,DOT)
C
C-------- linearly interpolate lean angles over segment
          DO 2034 I=IM+1, IO
            FRAC = (ST(I)-ST(IM))/(ST(IO)-ST(IM))
            AROT(I,IS) = AROT(IM,IS) + (AROT(IO,IS)-AROT(IM,IS))*FRAC
 2034     CONTINUE
C
 203    CONTINUE
C
C------ set lean angles ahead of LE
        DO 204 I=1, ILEB(N)
          AROT(I,IS) = 0.0
 204    CONTINUE
C
C------ set lean angles between last slide line and domain exit
        K = KBNFIX(IS)-1
        IM = IBNFIX(K,IS)
        IO = II
        AROT(IO,IS) = 0.0
        DO 205 I=IM+1, IO
          FRAC = (ST(I)-ST(IM))/(ST(IO)-ST(IM))
          AROT(I,IS) = AROT(IM,IS) + (AROT(IO,IS)-AROT(IM,IS))*FRAC
 205    CONTINUE
C
 20   CONTINUE
C
C
C
      DO 25 I=1, II
        AROT(I,0      ) = 0.0
        AROT(I,2*NBL+1) = 0.0
 25   CONTINUE
C
C---- set integrated mass fraction array
      MFSUM(1) = 0.0
      DO 30 J=2, JJ
        IF(JSTAG(J) .LT. 0) THEN
         MFSUM(J) = 0.0
         GO TO 30
        ENDIF
        MFSUM(J) = MFSUM(J-1) + MFRACT(J-1)
 30   CONTINUE
C
C---- go over interior streamlines, leaning all Nhats
      NN = NBL
      JS = 1
      JP = JS2(NN)
      ISS = 2*NBL + 1
      ISP = IS2(NN)
      DO 40 J=1, JJ
C
        IF(JSTAG(J).LT.0) THEN
C------- reset bounding streamlines for this streamtube
         JS = JS1(NN)
         JP = JJ
         ISS = IS1(NN)
         ISP = 0
C
         NN = NN-1
         IF(NN.GT.0) THEN
          JP  = JS2(NN)
          ISP = IS2(NN)
         ENDIF
        ENDIF
C
C------ interpolating fractions
        FS = 1.0 - MFSUM(J)/MFSUM(JP)
        FP =       MFSUM(J)/MFSUM(JP)
C
C------ interpolate lean angles
        DO 405 I=1, II
          AROTJ = FS*AROT(I,ISS) + FP*AROT(I,ISP)
          SINA = SIN(AROTJ)
          COSA = COS(AROTJ)
C
          DX = NX(I,J)
          DY = NY(I,J)
          NX(I,J) = DX*COSA - DY*SINA
          NY(I,J) = DY*COSA + DX*SINA
C
          DX = NXA(I,J)
          DY = NYA(I,J)
          NXA(I,J) = DX*COSA - DY*SINA
          NYA(I,J) = DY*COSA + DX*SINA
 405    CONTINUE
C
 40   CONTINUE
C
C
C---- set decay length for LE Nhats of each element (1/2 the perimeter)
      DO 60 N=1, NBL
        RSCAL(N) = 0.5*(SB(IIB(N),N) - SB(1,N))
   60 CONTINUE
C
      ILEMIN = ILEB(1)
      ITEMAX = ITEB(1)
      DO 70 N=2, NBL
        ILEMIN = MIN(ILEMIN,ILEB(N))
        ITEMAX = MAX(ITEMAX,ITEB(N))
 70   CONTINUE
C
C---- go over all elements
      DO 1000 N = 1, NBL
        IF(IBLE(N).NE.0) GO TO 1000
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ set unaltered top surface Nhats
        IS = IS1(N)
        DO 71 IG=1, IGFIX(IS)-1
          I = ILE + IG - 1
C
          SBI = SBLE(N) + (SB(1,N)-SBLE(N))*SG(IG,IS)
          DX = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          DY = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          FRAC = 1.0 - SG(IG,IS)/SG(IGFIX(IS),IS)
          NXGT(I,1) = FRAC * DX/SQRT(DX*DX + DY*DY)
          NYGT(I,1) = FRAC * DY/SQRT(DX*DX + DY*DY)
   71   CONTINUE
C
        DO 72 IG=IGFIX(IS), NBLD(N)
          I = ILE + IG - 1
          NXGT(I,1) = 0.0
          NYGT(I,1) = 0.0
   72   CONTINUE
C
C------ set unaltered bottom surface Nhats
        IS = IS2(N)
        DO 76 IG=1, IGFIX(IS)-1
          I = ILE + IG - 1
          SBI = SBLE(N) + (SB(IIB(N),N)-SBLE(N))*SG(IG,IS)
          DX = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          DY = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          FRAC = 1.0 - SG(IG,IS)/SG(IGFIX(IS),IS)
          NXGT(I,2) = FRAC * DX/SQRT(DX*DX + DY*DY)
          NYGT(I,2) = FRAC * DY/SQRT(DX*DX + DY*DY)
   76   CONTINUE
C
        DO 77 IG=IGFIX(IS), NBLD(N)
          I = ILE + IG - 1
          NXGT(I,2) = 0.0
          NYGT(I,2) = 0.0
   77   CONTINUE
C
C
C------ Go over all grid points
        DO 100 I=1, II
          DO 90 J=1, JJ
C
C---------- set decay factors, using current element chord as decay length
            DO 82 L=1, NBL
              ISURF = MIN0(ITEB(L),MAX0(ILEB(L),I))
              IF(J.GE.JS1(L)) THEN
               JSURF = JS1(L)
              ELSE
               JSURF = JS2(L)
              ENDIF
C
              RBLD = SQRT((X(I,J)-X(ISURF,JSURF))**2 +
     &                    (Y(I,J)-Y(ISURF,JSURF))**2   )
              ARG = MIN( 10.0*RBLD/RSCAL(N) , 15.0 )
C
              EXPR(L) = EXP(-ARG)
   82       CONTINUE
C
C---------- set weighting factor for current element
            FAC = EXPR(N)
            DO 83 L=1, N-1
              FAC = FAC * ( 1.0 - EXPR(L) )
   83       CONTINUE
            DO 85 L=N+1, NBL
              FAC = FAC * ( 1.0 - EXPR(L) )
   85       CONTINUE
C
            ISURF = MIN0(ITEB(N),MAX0(ILEB(N),I))
            IF(J.GE.JS1(N)) THEN
             JSURF = JS1(N)
             IS = 1
            ELSE
             JSURF = JS2(N)
             IS = 2
            ENDIF
C
            NXG(I,J,N) = NXGT(ISURF,IS)*FAC
            NYG(I,J,N) = NYGT(ISURF,IS)*FAC
C
C---------- weighting factor for alpha-linked grid motion
            IWAKE = MIN(ITEMAX,MAX(ILEB(N) ,I))
            JWAKE = MIN(JS1(1),MAX(JS2(NBL),J))
C
            RWAKE = SQRT( (X(I,J)-X(IWAKE,JWAKE))**2
     &                  + (Y(I,J)-Y(IWAKE,JWAKE))**2 )
            ARG = MIN( 2.0*RWAKE/RSCAL(N) , 15.0 )
            AFAC = EXP(-ARG)
            NXA(I,J) = NXA(I,J) * (1.0 - AFAC)
            NYA(I,J) = NYA(I,J) * (1.0 - AFAC)
C
   90     CONTINUE
  100   CONTINUE
C
 1000 CONTINUE ! with next element
C
      RETURN
      END ! NCALC



      SUBROUTINE BLNORM
C------------------------------------------------
C     Calculates pseudo-normal vectors along
C     which the displacement surface points
C     are offset from the airfoil surface
C     and wake centerline
C------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- set BL displacement offset vectors along airfoil and wake
      DO 20 IS=1, 2*NBL
        N = (IS+1)/2
C
C------ airfoil side
        IF (MOD(IS,2).EQ.1) THEN
          SBTOT = SB(     1,N) - SBLE(N)
          J = JBLD(N)
          WSGN = -1.0
         ELSE
          SBTOT = SB(IIB(N),N) - SBLE(N)
          J = JBLD(N)-1
          WSGN = 1.0
        ENDIF
C
        DO 200 IG=1, NBLD(N)
          I = ILEB(N) + IG - 1
          SBG = SBLE(N) + SBTOT*SG(IG,IS)
C
          DSGM = 0.0
          DSGP = 0.0
          IF(IG.GT.1      ) DSGM = SG(IG,IS) - SG(IG-1,IS)
          IF(IG.LT.NBLD(N)) DSGP = SG(IG+1,IS) - SG(IG,IS)
          DSB = ABS(SBTOT)*MAX(DSGM,DSGP)
C
          IF(ABS(DISP(I,IS)) .LE. 0.01*DSB .OR. IG.EQ.1) THEN
           DX =  DEVAL(SBG,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
           DY = -DEVAL(SBG,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          ELSE
           XBG = SEVAL(SBG,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           YBG = SEVAL(SBG,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
           DX = (X(I,J) - XBG)*SIGN( 1.0 , DISP(I,IS) )
           DY = (Y(I,J) - YBG)*SIGN( 1.0 , DISP(I,IS) )
          ENDIF
C
          BNX(I,IS) = DX / SQRT(DX*DX + DY*DY)
          BNY(I,IS) = DY / SQRT(DX*DX + DY*DY)
C
  200   CONTINUE
C
C------ wake
        DO 220 IW=2, NOUT(N)
          I = ITEB(N) + IW - 1
          SWI = SWAK(N)*SGOUT(IW,N)
C
          DSGM = 0.0
          DSGP = 0.0
          IF(IW.GT.1      ) DSGM = SGOUT(IW,N) - SGOUT(IW-1,N)
          IF(IW.LT.NOUT(N)) DSGP = SGOUT(IW+1,N) - SGOUT(IW,N)
          DSW = SWAK(N)*MAX(DSGM,DSGP)
C
          IF(ABS(DISP(I,IS)) .LE. 0.01*DSW .OR. INITBL.EQ.0) THEN
           DX =  WSGN*DEVAL(SWI,YW(1,N),YPW(1,N),SW(1,N),NOUT(N))
           DY = -WSGN*DEVAL(SWI,XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
          ELSE
           XWI = SEVAL(SWI,XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
           YWI = SEVAL(SWI,YW(1,N),YPW(1,N),SW(1,N),NOUT(N))
           DX = (X(I,J) - XWI)*SIGN( 1.0 , DISP(I,IS) )
           DY = (Y(I,J) - YWI)*SIGN( 1.0 , DISP(I,IS) )
          ENDIF
C
          BNX(I,IS) = DX / SQRT(DX*DX + DY*DY)
          BNY(I,IS) = DY / SQRT(DX*DX + DY*DY)
  220   CONTINUE
   20 CONTINUE
C
C---- set corner and TE normal vectors based on different method
      DO 30 N=1, NBL
        CALL BLNCTE(N)
   30 CONTINUE
C
      RETURN
      END ! BLNORM


      SUBROUTINE BLNCTE(N)
C------------------------------------------------
C     Calculates pseudo-normal vectors at 
C     trailing edges and corner points.
C------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      LOGICAL OK
      DIMENSION SBSIDE(ISX)
C
      SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
      SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
C
      DO 20 IS=IS1(N), IS2(N)
C
        IF(IGCORN(IS).NE.0) THEN
C------- calculate normal from averaging airfoil surface slopes at corner
         IG = IGCORN(IS)
         I = ILEB(N) + IG-1
         SBM = SBLE(N) + SBSIDE(IS)*(SG(IG,IS) - 0.001)
         SBP = SBLE(N) + SBSIDE(IS)*(SG(IG,IS) + 0.001)
         DX = DEVAL(SBM,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
     &      + DEVAL(SBP,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         DY = DEVAL(SBM,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
     &      + DEVAL(SBP,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
         BNX(I,IS) =  DY / SQRT(DX*DX + DY*DY)
         BNY(I,IS) = -DX / SQRT(DX*DX + DY*DY)
        ENDIF
C
C------ locate intersections of wake IS with all slide lines
        DO 205 K=2, KBNFIX(IS)-1
          I = IBNFIX(K,IS)
          IF(I.LT.ITEB(N)) GO TO 205
C
C-------- find element index whose TE originates current slide line
          DO 2051 NN=N, NBL
            IF(I.EQ.ITEB(NN)) GO TO 2053
 2051     CONTINUE
          DO 2052 NN=N-1, 1, -1
            IF(I.EQ.ITEB(NN)) GO TO 2053
 2052     CONTINUE
          WRITE(*,*) 'BLNCTE: TE not located. i = ', IBNFIX(K,IS)
          NN = 1
 2053     CONTINUE
C
          IF(NN.EQ.N) THEN
           KS = IS
          ELSE IF(NN.GT.N) THEN
           KS = 2*NN - 1
          ELSE
           KS = 2*NN
          ENDIF
C
C-------- sign of displacement relative to slide-line arc length
          DSGN = 1.0
          IF(MOD(IS,2) .NE. MOD(KS,2)) DSGN = -1.0
C
          IF(I.EQ.ITEB(N)) THEN
C
           SBI = SBLE(N) + SBSIDE(IS)
           XNORI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           YNORI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C--------- assumes first slide line point is on airfoil surface at TE
           SNI = SNOR(1,KS)
C
          ELSE
C
C--------- set first intersection location guess
           KN = IABS(NN-N) + 1
           KN = MAX(KN,1)
           KN = MIN(KN,KNOR(KS))
           IG = I - ITEB(N) + 1
           SNI = SNOR(KN,KS)
           SWI = SW(IG,N)
C
c          write(*,*) is, k, ig, ks, knor(ks)
c          write(*,*) xw(ig,n), yw(ig,n)
c          do kk=1, knor(ks)
c            write(*,*) xnor(kk,ks), ynor(kk,ks), snor(kk,ks)
c          enddo
c
C--------- calculate actual intersection location
           OK = .FALSE.
           CALL INTERS(OK,SNI,SWI,
     &        XNOR(1,KS),XSNOR(1,KS),
     &        YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS),
     &        XW(1,N),XPW(1,N),
     &        YW(1,N),YPW(1,N),SW(1,N),NOUT(N) )
ccc           IF(.NOT.OK) WRITE(*,*) 'n ite i:', N, ITEB(N), I
C
           XNORI = SEVAL(SNI,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
           YNORI = SEVAL(SNI,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
          ENDIF
C
          IF(DISP(I,IS) .LT. 0.001*ABS(SBSIDE(IS))) THEN
            DX = DEVAL(SNI,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
            DY = DEVAL(SNI,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
            DX = DSGN*DX
            DY = DSGN*DY
          ELSE
            SND = SNI + DSGN*DISP(I,IS)
            DX = SEVAL(SND,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
     &         - XNORI
            DY = SEVAL(SND,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
     &         - YNORI
C
C---------- take several Newton steps to correct for any curvature in 
C-          slide line
            DO 2055 ICORR=1, 3
              SX = DEVAL(SND,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
              SY = DEVAL(SND,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
C
              DS   = DX*SX + DY*SY
              DS_S = 1.0
cc
cc            write(*,*) 'd* corr:', icorr, ds, snd, sni
cc
              SND = SND - (DS-DSGN*DISP(I,IS))/DS_S
              DX = SEVAL(SND,XNOR(1,KS),XSNOR(1,KS),SNOR(1,KS),KNOR(KS))
     &           - XNORI
              DY = SEVAL(SND,YNOR(1,KS),YSNOR(1,KS),SNOR(1,KS),KNOR(KS))
     &           - YNORI
 2055       CONTINUE
          ENDIF
C
cc          write(*,*) i, disp(i,is), 
cc     &       atan2(bny(i,is),bnx(i,is))*180.0/pie,
cc     &       atan2(dy,dx)*180.0/pie
c
C-------- set displacement vector direction along slide line
          BNX(I,IS) = DX / SQRT(DX*DX + DY*DY)
          BNY(I,IS) = DY / SQRT(DX*DX + DY*DY)
C
 205    CONTINUE
C
   20 CONTINUE
C
      RETURN
      END ! BLNCTE


 
      SUBROUTINE SPWAKE(N)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- calculate wake arc length and spline wake trajectory
      SW(1,N) = 0.
      DO 10 IG=2, NOUT(N)
        SW(IG,N) = SW(IG-1,N)
     &           + SQRT((XW(IG,N)-XW(IG-1,N))**2 +
     &                  (YW(IG,N)-YW(IG-1,N))**2)
   10 CONTINUE
      CALL SPLINE(XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
      CALL SPLINE(YW(1,N),YPW(1,N),SW(1,N),NOUT(N))
      SWAK(N) = SW(NOUT(N),N)
C
      RETURN
      END ! SPWAKE


      SUBROUTINE MFCALC
C-----------------------------------------
C     Calculate mass fraction array
C     and mass variation coefficients
C-----------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
C---- set streamtube mass array for current total mass flow
      DO J=1, JJ-1
        M(J) = MASS * MFRACT(J)
      ENDDO
C
C---- Set up symmetric mass fraction array
      DO 5 J=1, JJ-1
        MF0(J) = MFRACT(J)
        DO 2 N=1, NBL
          MF1(J,N) = 0.
    2   CONTINUE
    5 CONTINUE
C
C---- Set up anti-symmetric mass fraction arrays
C     that sum to zero net additional mass but alter upper/lower balance.
C
C---- Calculate mass fraction sums between stg. streamlines or outer bound.
      DO 10 N=1, NBL
C
C------ add up mass above current element
        MFSUM = 0.0
        DO 110 J=JBLD(N), JJ-1
          IF(JSTAG(J).GT.0) GO TO 111
          MFSUM = MFSUM + MFRACT(J)
  110   CONTINUE
  111   CONTINUE
C
C------ set mass difference mode above current element
        DO 115 J=JBLD(N), JJ-1
          IF(JSTAG(J).GT.0) GO TO 116
          MF1(J,N) = MFRACT(J)/MFSUM
  115   CONTINUE
  116   CONTINUE
C
C------ add up mass below current element
        MFSUM = 0.0
        DO 120 J=JBLD(N)-2, 1, -1
          MFSUM = MFSUM + MFRACT(J)
          IF(JSTAG(J) .LT. 0) GO TO 121
  120   CONTINUE
  121   CONTINUE
C
C------ set mass difference mode below current element
        DO 125 J=JBLD(N)-2, 1, -1
          MF1(J,N) = -MFRACT(J)/MFSUM
          IF(JSTAG(J) .LT. 0) GO TO 126
  125   CONTINUE
  126   CONTINUE
C
   10 CONTINUE
C
      RETURN
      END ! MFCALC
 
 
      SUBROUTINE AREA(I,J,AN)
C----------------------------------------------------
C     Calculates streamtube area AN at location I,J
C----------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      IO = I
      IP = I+1
      JO = J
      JP = J+1
C
      DX = 0.5*(X(IP,JP)+X(IP,JO) - X(IO,JP)-X(IO,JO))
      DY = 0.5*(Y(IP,JP)+Y(IP,JO) - Y(IO,JP)-Y(IO,JO))
      DS = SQRT(DX*DX + DY*DY)
C
      AN = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO)) * DX/DS
     &   - 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO)) * DY/DS
C
      RETURN
      END ! AREA



      SUBROUTINE GETINT(INPUT,A,N,ERROR)
      CHARACTER*80 INPUT
      INTEGER A(N)
      LOGICAL ERROR
C----------------------------------------------------
C     Parses character*80 string INPUT into an array
C     of integer numbers returned in A(1...N)
C----------------------------------------------------
      CHARACTER*82 REC
C
      REC = INPUT//' ,'
      NMAX = MAX(N,1)
      N = 0
C
      K = 1
      DO 10 IPASS=1, 80
        KSPACE = INDEX(REC(K:82),' ') + K - 1
        KCOMMA = INDEX(REC(K:82),',') + K - 1
C
        IF(K.EQ.KSPACE) THEN
         K = K+1
         GO TO 9
        ENDIF
C
        IF(K.EQ.KCOMMA) THEN
         N = N+1
         K = K+1
         GO TO 9
        ENDIF
C
        N = N+1
        K = MIN(KSPACE,KCOMMA) + 1
C
  9     IF(K.GE.80 .OR. N.EQ.NMAX) GO TO 11
 10   CONTINUE
C
 11   READ(REC(1:80),*,ERR=20) (A(I),I=1,N)
      ERROR = .FALSE.
      RETURN
C
 20   WRITE(*,*) 'GETINT: String-to-integer conversion error.'
      N = 0
      ERROR = .TRUE.
      RETURN
      END



      SUBROUTINE GETFLT(INPUT,A,N,ERROR)
      CHARACTER*80 INPUT
      REAL A(N)
      LOGICAL ERROR
C----------------------------------------------------
C     Parses character*80 string INPUT into an array
C     of real numbers returned in A(1...N)
C----------------------------------------------------
      CHARACTER*82 REC
C
      REC = INPUT//' ,'
      NMAX = MAX(N,1)
C
      N = 0
C
      K = 1
      DO 10 IPASS=1, 80
        KSPACE = INDEX(REC(K:82),' ') + K - 1
        KCOMMA = INDEX(REC(K:82),',') + K - 1
C
        IF(K.EQ.KSPACE) THEN
         K = K+1
         GO TO 9
        ENDIF
C
        IF(K.EQ.KCOMMA) THEN
         N = N+1
         K = K+1
         GO TO 9
        ENDIF
C
        N = N+1
        K = MIN(KSPACE,KCOMMA) + 1
C
  9     IF(K.GE.80 .OR. N.EQ.NMAX) GO TO 11
 10   CONTINUE
C
 11   READ(REC(1:80),*,ERR=20) (A(I),I=1,N)
      ERROR = .FALSE.
      RETURN
C
 20   WRITE(*,*) 'GETFLT: String-to-real conversion error.'
      N = 0
      ERROR = .TRUE.
      RETURN
      END
