C         
      SUBROUTINE SOLVE        
C----------------------------------------------
C     MSES Subcritical isentropic solver
C
C     Solves only N-momentum and BL equations.
C
C     Ignores S-momentum equations, which are
C     assumed to have been eliminated in the
C     subscritical-setup routine with the
C     isentropic rho(area) relation.
C
C     Uncomment "CPU" code blocks to get 
C     printout of CPU consumption breakdown 
C     for the various operations.
C
C----------------------------------------------
      INCLUDE 'STATE.INC'     
      INCLUDE 'MSES.INC'      
C
C---- local work arrays
      PARAMETER (JZ = JX + 6*NBX)
      DIMENSION A(JZ,JZ),B(JZ,JZ),C(JZ,JX,IX),Z(JZ,JZ)   
C
C---- first assume all righthand sides will be solved for
      NRHSI = NRHS
C
C---- don't solve for mode righthand sides except on last iteration
      IF(ITER.LT.IABS(NITER)) THEN
       IF(LMINV) THEN
        NRHSI = NRHS - NPOSN
       ELSE
        NRHSI = NRHS - NPOSN - NMODN
       ENDIF
      ENDIF
C
C---- however, solve for all righthand sides if there are any prescribed modes
      DO N=1, NMODN
        K = KMODN(N)
        IF(ABS(DMSPN(K)) .GT. 1.0E-8) NRHSI = NRHS
      ENDDO
      DO N=1, NPOSN
        K = KPOSN(N)
        IF(ABS(DPSPN(K)) .GT. 1.0E-8) NRHSI = NRHS
      ENDDO
C
C---- overall block size
      NBK = JJ
      IF(LVISC) NBK = JJ + 6*NBL
C
      JOFF = JJ - 1
C
C-------------------
CPU
c      tfill = 0.0
c      telim = 0.0
c      tfacf = 0.0
c      tfacb = 0.0
c      tback = 0.0
C-------------------
C
CCC** Forward sweep: Elimination of lower block diagonals (B's and Z's).
      DO 1000 I=1, II
C
        IM = I-1
        IL = I-2
C
C------ Clear out work matrices
        DO K=1, NBK
          DO L=1, NBK
            Z(K,L) = 0.
            B(K,L) = 0.
            A(K,L) = 0.
          ENDDO
          DO L=1, JJ
            C(K,L,I) = 0.
          ENDDO
        ENDDO
C
C-------------------
CPU
c        t0 = second()
C-------------------
C
CCC**** FIRST, fill 'er up
C
C----- dn entries for N-momentum equations...
C
C      ... First the element streamlines
        DO 20 N = 1, NBL
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
          B(J1,J1)   = B2(J1,I) 
          B(J1,J1+1) = B3(J1,I) 
          B(J1,J2-1) = B1(J1,I) 
          B(J1,J2)   = BT(I1,I) 
          B(J2,J1+1) = B3(J2,I) 
          B(J2,J2-1) = B1(J2,I) 
          B(J2,J2)   = B2(J2,I) 
          B(J2,J1)   = BT(I2,I) 
          A(J1,J1)   = A2(J1,I) 
          A(J1,J1+1) = A3(J1,I) 
          A(J1,J2-1) = A1(J1,I) 
          A(J1,J2)   = AT(I1,I) 
          A(J2,J1+1) = A3(J2,I) 
          A(J2,J2-1) = A1(J2,I) 
          A(J2,J2)   = A2(J2,I) 
          A(J2,J1)   = AT(I2,I) 
          C(J1,J1  ,I) = C2(J1,I)
          C(J1,J1+1,I) = C3(J1,I)
          C(J1,J2-1,I) = C1(J1,I)
          C(J1,J2  ,I) = CT(I1,I)
          C(J2,J1+1,I) = C3(J2,I)
          C(J2,J2-1,I) = C1(J2,I)
          C(J2,J2  ,I) = C2(J2,I)
          C(J2,J1  ,I) = CT(I2,I)
   20   CONTINUE
C
C      ... Outermost streamlines
        J = 1
        IF(JSTAG(J).EQ.0) THEN
          B(J,J  ) = B2(J,I)
          B(J,J+1) = B3(J,I)
          A(J,J  ) = A2(J,I)
          A(J,J+1) = A3(J,I)
          C(J,J  ,I) = C2(J,I)
          C(J,J+1,I) = C3(J,I)
        ENDIF
C
        J = JJ
        IF(JSTAG(J).EQ.0) THEN
          B(J,J-1) = B1(J,I)
          B(J,J  ) = B2(J,I)
          A(J,J-1) = A1(J,I)
          A(J,J  ) = A2(J,I)
          C(J,J-1,I) = C1(J,I)
          C(J,J  ,I) = C2(J,I)
        ENDIF
C
C      ... Interior streamlines
        DO 22 J=2, JJ-1
          IF (JSTAG(J).NE.0) GO TO 22
          B(J,J-1) = B1(J,I)
          B(J,J  ) = B2(J,I)
          B(J,J+1) = B3(J,I)
          A(J,J-1) = A1(J,I)
          A(J,J  ) = A2(J,I)
          A(J,J+1) = A3(J,I)
          C(J,J-1,I) = C1(J,I)
          C(J,J  ,I) = C2(J,I)
          C(J,J+1,I) = C3(J,I)
   22   CONTINUE
C
C
        IF(LVISC) THEN
C
C------ Fill dn columns for BL equations in Z, B, A, C blocks
C
        DO 50 N = 1, NBL
C
          I1 = IS1(N)
          I2 = IS2(N)
          J1 = JS1(N)
          J2 = JS2(N)
C
          JS = J1-1
          JP = J2-2
          KB = JJ + 6*(N-1)
C
          DO 30 L=1, 2
            L1 = L
            L2 = L+2
C
            Z(KB+1,JS+L) = ZNC(I1,L1,I)
            Z(KB+2,JS+L) = ZNT(I1,L1,I)
            Z(KB+3,JS+L) = ZNH(I1,L1,I)
            Z(KB+4,JS+L) = ZNC(I2,L1,I)
            Z(KB+5,JS+L) = ZNT(I2,L1,I)
            Z(KB+6,JS+L) = ZNH(I2,L1,I)
            Z(KB+1,JP+L) = ZNC(I1,L2,I)
            Z(KB+2,JP+L) = ZNT(I1,L2,I)
            Z(KB+3,JP+L) = ZNH(I1,L2,I)
            Z(KB+4,JP+L) = ZNC(I2,L2,I)
            Z(KB+5,JP+L) = ZNT(I2,L2,I)
            Z(KB+6,JP+L) = ZNH(I2,L2,I)
C
            B(KB+1,JS+L) = BNC(I1,L1,I)
            B(KB+2,JS+L) = BNT(I1,L1,I)
            B(KB+3,JS+L) = BNH(I1,L1,I)
            B(KB+4,JS+L) = BNC(I2,L1,I)
            B(KB+5,JS+L) = BNT(I2,L1,I)
            B(KB+6,JS+L) = BNH(I2,L1,I)
            B(KB+1,JP+L) = BNC(I1,L2,I)
            B(KB+2,JP+L) = BNT(I1,L2,I)
            B(KB+3,JP+L) = BNH(I1,L2,I)
            B(KB+4,JP+L) = BNC(I2,L2,I)
            B(KB+5,JP+L) = BNT(I2,L2,I)
            B(KB+6,JP+L) = BNH(I2,L2,I)
C
            A(KB+1,JS+L) = ANC(I1,L1,I)
            A(KB+2,JS+L) = ANT(I1,L1,I)
            A(KB+3,JS+L) = ANH(I1,L1,I)
            A(KB+4,JS+L) = ANC(I2,L1,I)
            A(KB+5,JS+L) = ANT(I2,L1,I)
            A(KB+6,JS+L) = ANH(I2,L1,I)
            A(KB+1,JP+L) = ANC(I1,L2,I)
            A(KB+2,JP+L) = ANT(I1,L2,I)
            A(KB+3,JP+L) = ANH(I1,L2,I)
            A(KB+4,JP+L) = ANC(I2,L2,I)
            A(KB+5,JP+L) = ANT(I2,L2,I)
            A(KB+6,JP+L) = ANH(I2,L2,I)
C
            C(KB+1,JS+L,I) = CNC(I1,L1,I)
            C(KB+2,JS+L,I) = CNT(I1,L1,I)
            C(KB+3,JS+L,I) = CNH(I1,L1,I)
            C(KB+4,JS+L,I) = CNC(I2,L1,I)
            C(KB+5,JS+L,I) = CNT(I2,L1,I)
            C(KB+6,JS+L,I) = CNH(I2,L1,I)
            C(KB+1,JP+L,I) = CNC(I1,L2,I)
            C(KB+2,JP+L,I) = CNT(I1,L2,I)
            C(KB+3,JP+L,I) = CNH(I1,L2,I)
            C(KB+4,JP+L,I) = CNC(I2,L2,I)
            C(KB+5,JP+L,I) = CNT(I2,L2,I)
            C(KB+6,JP+L,I) = CNH(I2,L2,I)
   30     CONTINUE
C
C------ Fill dDiss, dThet, dDisp  columns for BL equations in B, A blocks
          DO 32 L=1, 6
            B(KB+1,KB+L) = BVC(I1,L,I)
            B(KB+2,KB+L) = BVT(I1,L,I)
            B(KB+3,KB+L) = BVH(I1,L,I)
            B(KB+4,KB+L) = BVC(I2,L,I)
            B(KB+5,KB+L) = BVT(I2,L,I)
            B(KB+6,KB+L) = BVH(I2,L,I)
            A(KB+1,KB+L) = AVC(I1,L,I)
            A(KB+2,KB+L) = AVT(I1,L,I)
            A(KB+3,KB+L) = AVH(I1,L,I)
            A(KB+4,KB+L) = AVC(I2,L,I)
            A(KB+5,KB+L) = AVT(I2,L,I)
            A(KB+6,KB+L) = AVH(I2,L,I)
   32     CONTINUE
C
C------ Fill dDiss, dThet, dDisp  columns for Euler-BL coupling conditions
          DO 38 L=1, 6
            LL = KB+L
            B(J1,LL) = BI(I1,L,I)
            B(J2,LL) = BI(I2,L,I)
            A(J1,LL) = AI(I1,L,I)
            A(J2,LL) = AI(I2,L,I)
   38     CONTINUE
C
   50   CONTINUE
C
C------ put viscous righthand sides in proper rows
        DO J=JJ+1, NBK
          DO L=1, NRHSI
            DR(J,L,I) = DR(J+JOFF,L,I)
          ENDDO
        ENDDO
C         
        ENDIF
C
C-------------------
CPU
c        t1 = second()
C-------------------
C
CCC**** Eliminate Z block (nonzero entries will occur only for BL equations)
        IF(I.GE.3) THEN
        DO 66 K=JJ+1, NBK
          DO 64 J=1, JJ
            ZTMP = Z(K,J)
            IF(ZTMP.EQ.0.0) GO TO 64
C
             DO 60 L=1, JJ
               B(K,L) = B(K,L) - ZTMP*C(J,L,IL)
   60        CONTINUE
C
             DO 62 L=1, NRHSI
               DR(K,L,I) = DR(K,L,I) - ZTMP*DR(J,L,IL)
   62        CONTINUE
   64     CONTINUE
   66   CONTINUE
        ENDIF
C        
CCC**** Eliminate B block
        IF(I.GE.2) THEN
        DO 76 K=1, NBK
          DO 74 J=1, NBK
            BTMP = B(K,J)
            IF(BTMP.EQ.0.0) GO TO 74
C
             DO 70 L=1, JJ
               A(K,L) = A(K,L) - BTMP*C(J,L,IM)
   70        CONTINUE
C
             DO 72 L=1, NRHSI
               DR(K,L,I) = DR(K,L,I) - BTMP*DR(J,L,IM)
   72        CONTINUE
   74     CONTINUE
   76   CONTINUE
        ENDIF
C
C-------------------
CPU
c        t2 = second()
C-------------------
C
      CALL LUDCMP(JZ,NBK,A)
C
C-------------------
CPU
c        t3 = second()
C-------------------
C
      DO L = 1, JJ
        CALL BAKSUB(JZ,NBK,A,C(1,L,I))
      ENDDO
C
      DO L = 1, NRHSI
        CALL BAKSUB(JZ,NBK,A,DR(1,L,I))
      ENDDO
C
C
C-------------------
CPU
c      t4 = second()
cC
c      tfill = tfill + t1 - t0
c      telim = telim + t2 - t1
c      tfacf = tfacf + t3 - t2
c      tfacb = tfacb + t4 - t3
C-------------------
C
 1000 CONTINUE 
C
C-------------------
CPU         
c        t5 = second()
C-------------------
C
CCC** Backward sweep: Elimination of upper block diagonal (C's). 
      DO 1200 I = II-1, 1, -1   
        IP = I+1
        DO 1030 N = 1, NBK        
          DO 1020 L = 1, NRHSI    
            SUM = 0.
            DO 1010 K = 1, JJ   
              SUM = SUM + C(N,K,I)*DR(K,L,IP)   
 1010       CONTINUE          
            DR(N,L,I) = DR(N,L,I) - SUM
 1020     CONTINUE
 1030   CONTINUE
 1200 CONTINUE 
C         
C---- put back BL variable deltas
      DO 2000 I = 1, II
        DO 1950 L = 1, NRHSI
          DO 1900 J = JJ+1, NBK
            DR(J+JOFF,L,I) = DR(J,L,I)
            DR(J,L,I) = 0.0
 1900     CONTINUE
 1950   CONTINUE
 2000 CONTINUE
C
C-------------------
CPU
c      t6 = second()
c      tback = t6 - t5
cC
c      write(*,5100) tfill, telim, tfacf, tfacb, tback
c 5100 FORMAT(/'  Workarray block fill  :', F11.6,
c     &       /'  Lower     block elim. :', F11.6,
c     &       /'  Diagonal  block LUfact:', F11.6,
c     &       /'  Upper+RHS block BakSub:', F11.6,
c     &       /'  Upper     block elim. :', F11.6 )
C-------------------
C
      RETURN   
      END ! SOLVE




      SUBROUTINE SHOBLK(A,NDIM,NI,NJ,LU)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION A(NDIM,NDIM)
ccc      CHARACTER*2 LINE(132)
      CHARACTER*1 LINE(132)
C
ccc      WRITE(LU,1000) ('1234567890',K=1, 8)
ccc 1000 FORMAT(/1X,3X, 12A20)
C
      WRITE(LU,1000) ('1234567890',K=1, 12)
 1000 FORMAT(/1X,3X, 12A10)
C
      DO 10 I=1, NI
        DO 110 J=1, NJ
ccc          LINE(J) = '  '
          LINE(J) = ' '
ccc          IF(A(I,J) .NE. 0.0) LINE(J) = '* '
          IF(A(I,J) .NE. 0.0) LINE(J) = '*'
          IF(A(I,J) .EQ. 1.0) LINE(J) = '1'
 110    CONTINUE
        WRITE(LU,1100) I, (LINE(J),J=1, NJ)
ccc 1100   FORMAT(1X,I2,1X,120A2))
 1100   FORMAT(1X,I2,1X,120A1)
 10   CONTINUE
C
      WRITE(LU,1000) ('1234567890',K=1, 12)
      RETURN
      END
