


      SUBROUTINE LEFIND(SLE,X,XP,Y,YP,S,N)
      DIMENSION X(N),XP(N),Y(N),YP(N),S(N)
C----------------------------------------------------
C     Locates leading edge arc length value SLE
C     where the surface is orthogonal to chord line.
C----------------------------------------------------
C
C---- set trailing edge point coordinates
      XTE = 0.5*(X(1) + X(N))
      YTE = 0.5*(Y(1) + Y(N))
C
C---- get first guess for SLE
      DO 10 I=3, N-2
        DXTE = X(I) - XTE
        DYTE = Y(I) - YTE
        DX = X(I+1) - X(I)
        DY = Y(I+1) - Y(I)
        DOTP = DXTE*DX + DYTE*DY
        IF(DOTP .LT. 0.0) GO TO 11
   10 CONTINUE
C
   11 SLE = S(I)
C
C---- Newton iteration to get exact SLE value
      DO 20 ITER=1, 50
        XLE  = SEVAL(SLE,X,XP,S,N)
        YLE  = SEVAL(SLE,Y,YP,S,N)
        DXDS = DEVAL(SLE,X,XP,S,N)
        DYDS = DEVAL(SLE,Y,YP,S,N)
        DXDD = D2VAL(SLE,X,XP,S,N)
        DYDD = D2VAL(SLE,Y,YP,S,N)
C
        XCHORD = XLE - XTE
        YCHORD = YLE - YTE
C
C------ drive dot product between chord line and LE tangent to zero
        RES  = XCHORD*DXDS + YCHORD*DYDS
        RESS = DXDS  *DXDS + DYDS  *DYDS
     &       + XCHORD*DXDD + YCHORD*DYDD
C
C------ Newton delta for SLE 
        DSLE = -RES/RESS
C
        CHORD = SQRT(XCHORD**2 + YCHORD**2)
        CURV = (DXDS*DYDD - DYDS*DXDD) / SQRT((DXDS**2 + DYDS**2)**3)
C
        DSLIM = 0.01*CHORD
        IF(CURV .NE. 0.0) DSLIM = MIN( DSLIM , 0.1/ABS(CURV) )
C
        DSLE = MAX( DSLE , -DSLIM )
        DSLE = MIN( DSLE ,  DSLIM )
C
        SLE = SLE + DSLE
        IF(ABS(DSLE/(S(N)-S(1))) .LT. 5.0E-5) RETURN
   20 CONTINUE
      WRITE(*,*) 'LEFIND:  LE point not found.  Continuing...'
      SLE = S(I)
      RETURN
C
      END ! LEFIND



      SUBROUTINE NSFIND(SCMAX,X,XP,Y,YP,S,N)
      REAL X(N),Y(N),S(N),XP(N),YP(N)
C----------------------------------------------------------
C     Finds "nose" of airfoil where curvature is a maximum
C----------------------------------------------------------
C
C---- overlay temporary storage space
ccc      COMMON/WORK/ CV(1000), A(1000), B(1000), C(1000)
      DIMENSION CV(1000), A(1000), B(1000), C(1000)
C
      IF(N.GT.1000) STOP 'NSFIND: Array overflow.'
C
C---- set up curvature array
      DO 3 I=1, N
        CV(I) = CURV(S(I),X,XP,Y,YP,S,N)
    3 CONTINUE
C
C---- curvature smoothing length
      SMOOL = 0.006*(S(N)-S(1))
C
C---- set up tri-diagonal system for smoothed curvatures
      SMOOSQ = SMOOL**2
      A(1) = 1.0
      C(1) = 0.0
      DO 4 I=2, N-1
        DSM = S(I) - S(I-1)
        DSP = S(I+1) - S(I)
        DSO = 0.5*(S(I+1) - S(I-1))
        IF(DSM .EQ. 0.0 .OR. DSP .EQ. 0.0) THEN
         B(I) = 0.
         A(I) = 1.0
         C(I) = 0.
        ELSE
         B(I) =  SMOOSQ * (         - 1.0/DSM) / DSO
         A(I) =  SMOOSQ * ( 1.0/DSP + 1.0/DSM) / DSO  +  1.0
         C(I) =  SMOOSQ * (-1.0/DSP          ) / DSO
        ENDIF
    4 CONTINUE
      B(N) = 0.0
      A(N) = 1.0
C
      CALL TRISOL(A,B,C,CV,N)
C
C---- find max curvature index
      CVMAX = 0.
      IVMAX = 0
      SLIM1 = S(1)
      SLIM2 = S(N)
      IF(SCMAX .NE. 0.0) THEN
C----- assume SCMAX passed in as estimate of nose position => limit search
       SLIM1 = SCMAX - 0.2*(SCMAX - S(1))
       SLIM2 = SCMAX + 0.2*(S(N) - SCMAX)
      ENDIF
      DO 71 I=2, N-1
        IF(S(I).LT.SLIM1) GO TO 71
        IF(S(I).GT.SLIM2) GO TO 72
        IF(ABS(CV(I)).GT.CVMAX) THEN
         CVMAX = ABS(CV(I))
         IVMAX = I
        ENDIF
   71 CONTINUE
   72 CONTINUE
C
      IF(IVMAX.EQ.0) RETURN
C
C---- fit a parabola to the curvature at the three points near maximum
      I = IVMAX
C
      DSM = S(I) - S(I-1)
      DSP = S(I+1) - S(I)
C
      IF(DSM.EQ.0.0 .OR. DSP.EQ.0.0) THEN
        SCMAX = S(I)
C
      ELSE
        CVSM = (CV(I)-CV(I-1))/DSM
        CVSP = (CV(I+1)-CV(I))/DSP
C
C------ 1st and 2nd derivatives at i=IVMAX
        CVS = (CVSM*DSP + CVSP*DSM)/(DSP+DSM)
        CVSS = 2.0*(CVSP-CVSM)/(DSP+DSM)
C
C------ set location of arc length at maximum of parabola
        DS = -CVS/CVSS
        SCMAX = S(I) + DS
      ENDIF
C
      RETURN
      END
