
      SUBROUTINE LINCHK1(LU)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-----------------------------------------------------------
C     Routine for checking N,S equation linearizations.
C
C     Individually perturbs the Newton variables  
C
C        n     grid node movement
C        r     density
C        mass  total mass flow
C        alfa  angle of attack (which deforms the grid)
C
C     and compares the analytic Jacobian derivatives with 
C     finite-differenced residuals.
C
C     The perturbation is done on one n(i,j) and one r(i,j),
C     and all the neighboring residuals affected by these
C     variables are compared.  This effectively tests the
C     entire N,S equation Jacobian stencils.
C
C-----------------------------------------------------------
C
      COMMON /ABC$/
     &   V1$(JX,IX),V2$(JX,IX),V3$(JX,IX),V4$(JX,IX),V5$(JX,IX),
     &   V6$(JX,IX),V7$(JX,IX),V8$(JX,IX),
     &   VT$(ISX,IX),
     &   Z1$(JX,IX),Z2$(JX,IX),Z3$(JX,IX),Z4$(JX,IX),Z5$(JX,IX),
     &   Z6$(JX,IX),Z7$(JX,IX),Z8$(JX,IX),
     &   ZT$(ISX,IX),
     &   A1$(JX,IX),A2$(JX,IX),A3$(JX,IX),A4$(JX,IX),A5$(JX,IX),
     &   A6$(JX,IX),A7$(JX,IX),A8$(JX,IX),
     &   AT$(ISX,IX),
     &   B1$(JX,IX),B2$(JX,IX),B3$(JX,IX),B4$(JX,IX),B5$(JX,IX),
     &   B6$(JX,IX),B7$(JX,IX),B8$(JX,IX),
     &   BT$(ISX,IX),
     &   C1$(JX,IX),C2$(JX,IX),C3$(JX,IX),
     &   C6$(JX,IX),C7$(JX,IX),
     &   CT$(ISX,IX)
C
      COMMON /CTH$/
     &   ZNC$(ISX,4,IX),BNC$(ISX,4,IX),ANC$(ISX,4,IX),CNC$(ISX,4,IX),
     &   ZNT$(ISX,4,IX),BNT$(ISX,4,IX),ANT$(ISX,4,IX),CNT$(ISX,4,IX),
     &   ZNH$(ISX,4,IX),BNH$(ISX,4,IX),ANH$(ISX,4,IX),CNH$(ISX,4,IX),
     &   ZRC$(ISX,2,IX),BRC$(ISX,2,IX),ARC$(ISX,2,IX),
     &   ZRT$(ISX,2,IX),BRT$(ISX,2,IX),ART$(ISX,2,IX),
     &   ZRH$(ISX,2,IX),BRH$(ISX,2,IX),ARH$(ISX,2,IX),
     &                  BVC$(ISX,6,IX),AVC$(ISX,6,IX),
     &                  BVT$(ISX,6,IX),AVT$(ISX,6,IX),
     &                  BVH$(ISX,6,IX),AVH$(ISX,6,IX),
     &    AI$(ISX,6,IX),BI$(ISX,6,IX)
C
      COMMON /RHS$/ DR$(KX,0:NGLX,IX)
C
C
      DIMENSION ZABC (NABC), CVIS (NCTH)
      DIMENSION ZABC$(NABC), CVIS$(NCTH)
      EQUIVALENCE (V1 (1,1),ZABC (1)), (ZNC (1,1,1),CVIS (1))
      EQUIVALENCE (V1$(1,1),ZABC$(1)), (ZNC$(1,1,1),CVIS$(1))
C
 2004 FORMAT(/1X,A,6X,'i-3',6X,
     &             6X,'i-2',6X,
     &             6X,'i-1',6X,
     &             6X,'i  ',6X )
 2005 FORMAT(/1X,A,6X,'i-3',6X,
     &             6X,'i-2',6X,
     &             6X,'i-1',6X,
     &             6X,'i  ',6X,
     &             6X,'i+1',6X )
 2100 FORMAT(/1X,A, E15.6,
     &       /1X,A, E15.6 )
 2400 FORMAT(/1X,A,4E15.6,
     &       /1X,A,4E15.6 )
 2500 FORMAT(/1X,A,5E15.6,
     &       /1X,A,5E15.6 )
C
      DO K=1, NABC
        ZABC$(K) = ZABC(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS$(K) = CVIS(K)
      ENDDO
C
      DO I=1, II
        DO J=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR$(J,L,I) = DR(J,L,I)
          ENDDO
        ENDDO
      ENDDO
C
C---- perturbation amplitude
      EPS = -1.0D-7
C
C---- perturbed node location
      I = 2
      J = 2
C
cc      I = 88
cc      J = 10
      write(*,*) 'Enter i, j:'
      read (*,*) I, J

      IF(I.EQ.0 .OR. J.EQ.0) RETURN
C
C
C---- print out local Mach
      msq = q(i,j)**2 / (gm1*(hinf - 0.5*q(i,j)**2))
      write(LU,*)
      write(LU,*) 'i j =', I, J
      write(LU,*) 'M    = ', sqrt(msq)
      write(LU,*) 'Minf = ', MINF
      write(LU,*) 'mass = ', MASS
      write(LU,*) 'res N,S = ', dr(j,1,i), dr(j+jj,1,i)
      write(LU,*)
C
      IK = I-3
      IL = I-2
      IM = I-1
      IO = I
      IP = I+1
      IQ = I+2
      IR = I+3
C
      JM = J-1
      JO = J
      JP = J+1
C
      IK = MAX(IK,1 )
      IL = MAX(IL,1 )
      IM = MAX(IM,1 )
      IP = MIN(IP,II)
      IQ = MIN(IQ,II)
      IR = MIN(IR,II)
C
      JM = MAX(JM,1 )
      JP = MIN(JP,JJ)
C
cc      go to 200
cc      go to 300

      call area(im,jo,an1o$)
      call area(io,jo,an2o$)
      call area(im,jm,an1m$)
      call area(io,jm,an2m$)
C
C=============================
C---- perturb grid node
 100  CONTINUE
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2500)
     &  'N mom dR/dn j+1:',
     &  (V3$(JM,IR) + V3(JM,IR))*0.5,
     &  (Z3$(JM,IQ) + Z3(JM,IQ))*0.5,
     &  (B3$(JM,IP) + B3(JM,IP))*0.5,
     &  (A3$(JM,IO) + A3(JM,IO))*0.5,
     &  (C3$(JM,IM) + C3(JM,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(JM,1,IR)-DR(JM,1,IR))/EPS,
     &  (DR$(JM,1,IQ)-DR(JM,1,IQ))/EPS,
     &  (DR$(JM,1,IP)-DR(JM,1,IP))/EPS,
     &  (DR$(JM,1,IO)-DR(JM,1,IO))/EPS,
     &  (DR$(JM,1,IM)-DR(JM,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'N mom dR/dn j  :',
     &  (V2$(JO,IR) + V2(JO,IR))*0.5,
     &  (Z2$(JO,IQ) + Z2(JO,IQ))*0.5,
     &  (B2$(JO,IP) + B2(JO,IP))*0.5,
     &  (A2$(JO,IO) + A2(JO,IO))*0.5,
     &  (C2$(JO,IM) + C2(JO,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(JO,1,IR)-DR(JO,1,IR))/EPS,
     &  (DR$(JO,1,IQ)-DR(JO,1,IQ))/EPS,
     &  (DR$(JO,1,IP)-DR(JO,1,IP))/EPS,
     &  (DR$(JO,1,IO)-DR(JO,1,IO))/EPS,
     &  (DR$(JO,1,IM)-DR(JO,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'N mom dR/dn j-1:',
     &  (V1$(JP,IR) + V1(JP,IR))*0.5,
     &  (Z1$(JP,IQ) + Z1(JP,IQ))*0.5,
     &  (B1$(JP,IP) + B1(JP,IP))*0.5,
     &  (A1$(JP,IO) + A1(JP,IO))*0.5,
     &  (C1$(JP,IM) + C1(JP,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(JP,1,IR)-DR(JP,1,IR))/EPS,
     &  (DR$(JP,1,IQ)-DR(JP,1,IQ))/EPS,
     &  (DR$(JP,1,IP)-DR(JP,1,IP))/EPS,
     &  (DR$(JP,1,IO)-DR(JP,1,IO))/EPS,
     &  (DR$(JP,1,IM)-DR(JP,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'S mom dR/dn j+1:',
     &  (V7$(JM,IR) + V7(JM,IR))*0.5,
     &  (Z7$(JM,IQ) + Z7(JM,IQ))*0.5,
     &  (B7$(JM,IP) + B7(JM,IP))*0.5,
     &  (A7$(JM,IO) + A7(JM,IO))*0.5,
     &  (C7$(JM,IM) + C7(JM,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(JM+JJ,1,IR)-DR(JM+JJ,1,IR))/EPS,
     &  (DR$(JM+JJ,1,IQ)-DR(JM+JJ,1,IQ))/EPS,
     &  (DR$(JM+JJ,1,IP)-DR(JM+JJ,1,IP))/EPS,
     &  (DR$(JM+JJ,1,IO)-DR(JM+JJ,1,IO))/EPS,
     &  (DR$(JM+JJ,1,IM)-DR(JM+JJ,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'S mom dR/dn j  :',
     &  (V6$(JO,IR) + V6(JO,IR))*0.5,
     &  (Z6$(JO,IQ) + Z6(JO,IQ))*0.5,
     &  (B6$(JO,IP) + B6(JO,IP))*0.5,
     &  (A6$(JO,IO) + A6(JO,IO))*0.5,
     &  (C6$(JO,IM) + C6(JO,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(JO+JJ,1,IR)-DR(JO+JJ,1,IR))/EPS,
     &  (DR$(JO+JJ,1,IQ)-DR(JO+JJ,1,IQ))/EPS,
     &  (DR$(JO+JJ,1,IP)-DR(JO+JJ,1,IP))/EPS,
     &  (DR$(JO+JJ,1,IO)-DR(JO+JJ,1,IO))/EPS,
     &  (DR$(JO+JJ,1,IM)-DR(JO+JJ,1,IM))/EPS
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C
C=============================
C---- perturb density
 200  CONTINUE
      R(I,J) = R(I,J) + EPS
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2004)
     &  '                '
      WRITE(LU,2400)
     &  'N mom dR/dr j  :',
     &  (V5$(JO,IR) + V5(JO,IR))*0.5,
     &  (Z5$(JO,IQ) + Z5(JO,IQ))*0.5,
     &  (B5$(JO,IP) + B5(JO,IP))*0.5,
     &  (A5$(JO,IO) + A5(JO,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(JO,1,IR)-DR(JO,1,IR))/EPS,
     &  (DR$(JO,1,IQ)-DR(JO,1,IQ))/EPS,
     &  (DR$(JO,1,IP)-DR(JO,1,IP))/EPS,
     &  (DR$(JO,1,IO)-DR(JO,1,IO))/EPS
C
      WRITE(LU,2400)
     &  'N mom dR/dr j-1:',
     &  (V4$(JP,IR) + V4(JP,IR))*0.5,
     &  (Z4$(JP,IQ) + Z4(JP,IQ))*0.5,
     &  (B4$(JP,IP) + B4(JP,IP))*0.5,
     &  (A4$(JP,IO) + A4(JP,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(JP,1,IR)-DR(JP,1,IR))/EPS,
     &  (DR$(JP,1,IQ)-DR(JP,1,IQ))/EPS,
     &  (DR$(JP,1,IP)-DR(JP,1,IP))/EPS,
     &  (DR$(JP,1,IO)-DR(JP,1,IO))/EPS
C
      WRITE(LU,2400)
     &  'S mom dR/dr j  :',
     &  (V8$(JO,IR) + V8(JO,IR))*0.5,
     &  (Z8$(JO,IQ) + Z8(JO,IQ))*0.5,
     &  (B8$(JO,IP) + B8(JO,IP))*0.5,
     &  (A8$(JO,IO) + A8(JO,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(JO+JJ,1,IR)-DR(JO+JJ,1,IR))/EPS,
     &  (DR$(JO+JJ,1,IQ)-DR(JO+JJ,1,IQ))/EPS,
     &  (DR$(JO+JJ,1,IP)-DR(JO+JJ,1,IP))/EPS,
     &  (DR$(JO+JJ,1,IO)-DR(JO+JJ,1,IO))/EPS
C
      R(I,J) = R(I,J) - EPS
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C
C=============================
C---- perturb mass flow
 300  CONTINUE
      DO JT=1, JJ-1
        M(JT) = M(JT) + MF0(JT)*EPS
      ENDDO
      MASS = MASS + EPS
C
      CALL FFCALC
C
      CALL SETUP
      CALL SETBC
C
      L = LMASS
C
      WRITE(LU,2100)
     &  'N mom dR/dmass:',
     &  (DR$(JO,L,IO)+DR(JO,L,IO))*0.5,
     &  '   (R-R)/(m-m):',
     &  (DR$(JO,1,IO)-DR(JO,1,IO))/EPS
C
      WRITE(LU,2100)
     &  'S mom dR/dmass:',
     &  (DR$(JO+JJ,L,IO)+DR(JO+JJ,L,IO))*0.5,
     &  '   (R-R)/(m-m):',
     &  (DR$(JO+JJ,1,IO)-DR(JO+JJ,1,IO))/EPS
C
      DO JT=1, JJ-1
        M(JT) = M(JT) - MF0(JT)*EPS
      ENDDO
      MASS = MASS - EPS
C
      CALL FFCALC
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C=============================
C---- perturb alpha
 310  CONTINUE
      ALFA = ALFA + EPS
C
      DO IT=1, II
        DO JT=1, JJ
          X(IT,JT) = X(IT,JT) + NXA(IT,JT)*EPS
          Y(IT,JT) = Y(IT,JT) + NYA(IT,JT)*EPS
        ENDDO
      ENDDO
C
      CALL FFCALC
C
      CALL SETUP
      CALL SETBC
C
      L = LALFA
C
      WRITE(LU,2100)
     &  'N mom dR/dAlfa:',
     &  (DR$(JO,L,IO)+DR(JO,L,IO))*0.5,
     &  '   (R-R)/(S-S):',
     &  (DR$(JO,1,IO)-DR(JO,1,IO))/EPS
C
      WRITE(LU,2100)
     &  'S mom dR/dAlfa:',
     &  (DR$(JO+JJ,L,IO)+DR(JO+JJ,L,IO))*0.5,
     &  '   (R-R)/(S-S):',
     &  (DR$(JO+JJ,1,IO)-DR(JO+JJ,1,IO))/EPS
C
      ALFA = ALFA - EPS
      DO IT=1, II
        DO JT=1, JJ
          X(IT,JT) = X(IT,JT) - NXA(IT,JT)*EPS
          Y(IT,JT) = Y(IT,JT) - NYA(IT,JT)*EPS
        ENDDO
      ENDDO
C
C
      CALL FFCALC
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C

      RETURN
      END


      SUBROUTINE LINCHK2(LU)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-----------------------------------------------------------
C     Routine for checking BC equation linearizations.
C
C     Individually perturbs the Newton variables  
C
C        n     grid node movement
C        r     density
C        mass  total mass flow
C
C     and compares the analytic Jacobian derivatives with 
C     finite-differenced derivatives.
C-----------------------------------------------------------
C
      COMMON /ABC$/
     &   V1$(JX,IX),V2$(JX,IX),V3$(JX,IX),V4$(JX,IX),V5$(JX,IX),
     &   V6$(JX,IX),V7$(JX,IX),V8$(JX,IX),
     &   VT$(ISX,IX),
     &   Z1$(JX,IX),Z2$(JX,IX),Z3$(JX,IX),Z4$(JX,IX),Z5$(JX,IX),
     &   Z6$(JX,IX),Z7$(JX,IX),Z8$(JX,IX),
     &   ZT$(ISX,IX),
     &   A1$(JX,IX),A2$(JX,IX),A3$(JX,IX),A4$(JX,IX),A5$(JX,IX),
     &   A6$(JX,IX),A7$(JX,IX),A8$(JX,IX),
     &   AT$(ISX,IX),
     &   B1$(JX,IX),B2$(JX,IX),B3$(JX,IX),B4$(JX,IX),B5$(JX,IX),
     &   B6$(JX,IX),B7$(JX,IX),B8$(JX,IX),
     &   BT$(ISX,IX),
     &   C1$(JX,IX),C2$(JX,IX),C3$(JX,IX),
     &   C6$(JX,IX),C7$(JX,IX),
     &   CT$(ISX,IX)
C
      COMMON /CTH$/
     &   ZNC$(ISX,4,IX),BNC$(ISX,4,IX),ANC$(ISX,4,IX),CNC$(ISX,4,IX),
     &   ZNT$(ISX,4,IX),BNT$(ISX,4,IX),ANT$(ISX,4,IX),CNT$(ISX,4,IX),
     &   ZNH$(ISX,4,IX),BNH$(ISX,4,IX),ANH$(ISX,4,IX),CNH$(ISX,4,IX),
     &   ZRC$(ISX,2,IX),BRC$(ISX,2,IX),ARC$(ISX,2,IX),
     &   ZRT$(ISX,2,IX),BRT$(ISX,2,IX),ART$(ISX,2,IX),
     &   ZRH$(ISX,2,IX),BRH$(ISX,2,IX),ARH$(ISX,2,IX),
     &                  BVC$(ISX,6,IX),AVC$(ISX,6,IX),
     &                  BVT$(ISX,6,IX),AVT$(ISX,6,IX),
     &                  BVH$(ISX,6,IX),AVH$(ISX,6,IX),
     &    AI$(ISX,6,IX),BI$(ISX,6,IX)
C
      COMMON /RHS$/ DR$(KX,0:NGLX,IX)
C
C
      DIMENSION ZABC (NABC), CVIS (NCTH)
      DIMENSION ZABC$(NABC), CVIS$(NCTH)
      EQUIVALENCE (V1 (1,1),ZABC (1)), (ZNC (1,1,1),CVIS (1))
      EQUIVALENCE (V1$(1,1),ZABC$(1)), (ZNC$(1,1,1),CVIS$(1))
C
 2004 FORMAT(/1X,A,6X,'i-3',6X,
     &             6X,'i-2',6X,
     &             6X,'i-1',6X,
     &             6X,'i  ',6X )
 2005 FORMAT(/1X,A,6X,'i-3',6X,
     &             6X,'i-2',6X,
     &             6X,'i-1',6X,
     &             6X,'i  ',6X,
     &             6X,'i+1',6X )
 2100 FORMAT(/1X,A, E15.6,
     &       /1X,A, E15.6 )
 2400 FORMAT(/1X,A,4E15.6,
     &       /1X,A,4E15.6 )
 2500 FORMAT(/1X,A,5E15.6,
     &       /1X,A,5E15.6 )
C
      DO K=1, NABC
        ZABC$(K) = ZABC(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS$(K) = CVIS(K)
      ENDDO
C
      DO I=1, II
        DO J=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR$(J,L,I) = DR(J,L,I)
          ENDDO
        ENDDO
      ENDDO
C
C---- perturbation amplitude
      EPS = 1.0D-6
C
C---- perturbed node location
      N = 1
      I = ITEB(N) + 3
C
cc      I = 88
cc      IS = 10
      write(*,*) 'Enter i, n:'
      read (*,*) I, N

      IF(I.EQ.0 .OR. N.EQ.0) RETURN
C
C
      IK = I-3
      IL = I-2
      IM = I-1
      IO = I
      IP = I+1
      IQ = I+2
      IR = I+3
C
      IK = MAX(IK,1 )
      IL = MAX(IL,1 )
      IM = MAX(IM,1 )
      IP = MIN(IP,II)
      IQ = MIN(IQ,II)
      IR = MIN(IR,II)
C
cc      go to 200
cc      go to 300
C
C=============================
C---- perturb grid node
 100  CONTINUE
C
      I1 = IS1(N)
      I2 = IS2(N)
      J1 = JS1(N)
      J2 = JS2(N)
C
      J = J2 - 1
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2500)
     &  'delP dR/dn j2-1:',
     &  (V1$(J1,IR) + V1(J1,IR))*0.5,
     &  (Z1$(J1,IQ) + Z1(J1,IQ))*0.5,
     &  (B1$(J1,IP) + B1(J1,IP))*0.5,
     &  (A1$(J1,IO) + A1(J1,IO))*0.5,
     &  (C1$(J1,IM) + C1(J1,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS,
     &  (DR$(J1,1,IM)-DR(J1,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'delN dR/dn j2-1:',
     &  (V1$(J2,IR) + V1(J2,IR))*0.5,
     &  (Z1$(J2,IQ) + Z1(J2,IQ))*0.5,
     &  (B1$(J2,IP) + B1(J2,IP))*0.5,
     &  (A1$(J2,IO) + A1(J2,IO))*0.5,
     &  (C1$(J2,IM) + C1(J2,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS,
     &  (DR$(J2,1,IM)-DR(J2,1,IM))/EPS
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C
      J = J2
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2500)
     &  'delP dR/dn j2  :',
     &  (VT$(I1,IR) + VT(I1,IR))*0.5,
     &  (ZT$(I1,IQ) + ZT(I1,IQ))*0.5,
     &  (BT$(I1,IP) + BT(I1,IP))*0.5,
     &  (AT$(I1,IO) + AT(I1,IO))*0.5,
     &  (CT$(I1,IM) + CT(I1,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS,
     &  (DR$(J1,1,IM)-DR(J1,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'delN dR/dn j2  :',
     &  (V2$(J2,IR) + V2(J2,IR))*0.5,
     &  (Z2$(J2,IQ) + Z2(J2,IQ))*0.5,
     &  (B2$(J2,IP) + B2(J2,IP))*0.5,
     &  (A2$(J2,IO) + A2(J2,IO))*0.5,
     &  (C2$(J2,IM) + C2(J2,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS,
     &  (DR$(J2,1,IM)-DR(J2,1,IM))/EPS
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C
      J = J1
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2500)
     &  'delP dR/dn j1  :',
     &  (V2$(J1,IR) + V2(J1,IR))*0.5,
     &  (Z2$(J1,IQ) + Z2(J1,IQ))*0.5,
     &  (B2$(J1,IP) + B2(J1,IP))*0.5,
     &  (A2$(J1,IO) + A2(J1,IO))*0.5,
     &  (C2$(J1,IM) + C2(J1,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS,
     &  (DR$(J1,1,IM)-DR(J1,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'delN dR/dn j1  :',
     &  (VT$(I2,IR) + VT(I2,IR))*0.5,
     &  (ZT$(I2,IQ) + ZT(I2,IQ))*0.5,
     &  (BT$(I2,IP) + BT(I2,IP))*0.5,
     &  (AT$(I2,IO) + AT(I2,IO))*0.5,
     &  (CT$(I2,IM) + CT(I2,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS,
     &  (DR$(J2,1,IM)-DR(J2,1,IM))/EPS
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C
      J = J1+1
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2500)
     &  'delP dR/dn j1+1:',
     &  (V3$(J1,IR) + V3(J1,IR))*0.5,
     &  (Z3$(J1,IQ) + Z3(J1,IQ))*0.5,
     &  (B3$(J1,IP) + B3(J1,IP))*0.5,
     &  (A3$(J1,IO) + A3(J1,IO))*0.5,
     &  (C3$(J1,IM) + C3(J1,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS,
     &  (DR$(J1,1,IM)-DR(J1,1,IM))/EPS
C
      WRITE(LU,2500)
     &  'delN dR/dn j1+1:',
     &  (V3$(J2,IR) + V3(J2,IR))*0.5,
     &  (Z3$(J2,IQ) + Z3(J2,IQ))*0.5,
     &  (B3$(J2,IP) + B3(J2,IP))*0.5,
     &  (A3$(J2,IO) + A3(J2,IO))*0.5,
     &  (C3$(J2,IM) + C3(J2,IM))*0.5,
     &  '    (R-R)/(n-n):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS,
     &  (DR$(J2,1,IM)-DR(J2,1,IM))/EPS
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C
C=============================
C---- perturb density
 200  CONTINUE
      J = J2-1
      R(I,J) = R(I,J) + EPS
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2400)
     &  'delP dR/dr j2-1:',
     &  (V4$(J1,IR) + V4(J1,IR))*0.5,
     &  (Z4$(J1,IQ) + Z4(J1,IQ))*0.5,
     &  (B4$(J1,IP) + B4(J1,IP))*0.5,
     &  (A4$(J1,IO) + A4(J1,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS
C
      WRITE(LU,2400)
     &  'delN dR/dr j2-1:',
     &  (V4$(J2,IR) + V4(J2,IR))*0.5,
     &  (Z4$(J2,IQ) + Z4(J2,IQ))*0.5,
     &  (B4$(J2,IP) + B4(J2,IP))*0.5,
     &  (A4$(J2,IO) + A4(J2,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS
C
      R(I,J) = R(I,J) - EPS
C
C
      J = J1
      R(I,J) = R(I,J) + EPS
C
      CALL SETUP
      CALL SETBC
C
      WRITE(LU,2005)
     &  '                '
      WRITE(LU,2400)
     &  'delP dR/dr j1  :',
     &  (V5$(J1,IR) + V5(J1,IR))*0.5,
     &  (Z5$(J1,IQ) + Z5(J1,IQ))*0.5,
     &  (B5$(J1,IP) + B5(J1,IP))*0.5,
     &  (A5$(J1,IO) + A5(J1,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(J1,1,IR)-DR(J1,1,IR))/EPS,
     &  (DR$(J1,1,IQ)-DR(J1,1,IQ))/EPS,
     &  (DR$(J1,1,IP)-DR(J1,1,IP))/EPS,
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS
C
      WRITE(LU,2400)
     &  'delN dR/dr j1  :',
     &  (V5$(J2,IR) + V5(J2,IR))*0.5,
     &  (Z5$(J2,IQ) + Z5(J2,IQ))*0.5,
     &  (B5$(J2,IP) + B5(J2,IP))*0.5,
     &  (A5$(J2,IO) + A5(J2,IO))*0.5,
     &  '    (R-R)/(r-r):',
     &  (DR$(J2,1,IR)-DR(J2,1,IR))/EPS,
     &  (DR$(J2,1,IQ)-DR(J2,1,IQ))/EPS,
     &  (DR$(J2,1,IP)-DR(J2,1,IP))/EPS,
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS
C
      R(I,J) = R(I,J) - EPS
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C
C
C=============================
C---- perturb mass flow
 300  CONTINUE
      DO JT=1, JJ-1
        M(JT) = M(JT) + MF0(JT)*EPS
      ENDDO
      MASS = MASS + EPS
C
      CALL FFCALC
C
      CALL SETUP
      CALL SETBC
C
      L = LMASS
C
      WRITE(LU,2100)
     &  'delP  dR/dmass:',
     &  (DR$(J1,L,IO)+DR(J1,L,IO))*0.5,
     &  '   (R-R)/(m-m):',
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS
C
      WRITE(LU,2100)
     &  'delN  dR/dmass:',
     &  (DR$(J2,L,IO)+DR(J2,L,IO))*0.5,
     &  '   (R-R)/(m-m):',
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS
C
      DO JT=1, JJ-1
        M(JT) = M(JT) - MF0(JT)*EPS
      ENDDO
      MASS = MASS - EPS
C
      CALL FFCALC
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C=============================
C---- perturb alpha
 310  CONTINUE
      ALFA = ALFA + EPS
C
      DO IT=1, II
        DO JT=1, JJ
          X(IT,JT) = X(IT,JT) + NXA(IT,JT)*EPS
          Y(IT,JT) = Y(IT,JT) + NYA(IT,JT)*EPS
        ENDDO
      ENDDO
C
      CALL FFCALC
C
      CALL SETUP
      CALL SETBC
C
      L = LALFA
C
      WRITE(LU,2100)
     &  'delP  dR/dAlfa:',
     &  (DR$(J1,L,IO)+DR(J1,L,IO))*0.5,
     &  '   (R-R)/(a-a):',
     &  (DR$(J1,1,IO)-DR(J1,1,IO))/EPS
C
      WRITE(LU,2100)
     &  'delN  dR/dAlfa:',
     &  (DR$(J2,L,IO)+DR(J2,L,IO))*0.5,
     &  '   (R-R)/(a-a):',
     &  (DR$(J2,1,IO)-DR(J2,1,IO))/EPS
C
      ALFA = ALFA - EPS
      DO IT=1, II
        DO JT=1, JJ
          X(IT,JT) = X(IT,JT) - NXA(IT,JT)*EPS
          Y(IT,JT) = Y(IT,JT) - NYA(IT,JT)*EPS
        ENDDO
      ENDDO
C
C
      CALL FFCALC
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C

      RETURN
      END



      SUBROUTINE LINCHK3(LU)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-----------------------------------------------------------
C     Routine for checking BL equation linearizations
C
C     Individually perturbs the Newton BL variables  
C
C         n     grid node (determines Ue)
C         rho   density   (determines Ue)
C         Ct    shear stress coefficient
C         Th    momentum thickness
C         Ds    displacement thickness
C         mass  total mass flow
C
C     and compares the analytic Jacobian derivatives with 
C     finite-differenced derivatives.
C
C     For this routine to work properly, it is also necessary to:
C       * turn off MRCHDU call in setbl.f
C       * turn off pre-elimination in PERSTR and DIRWAL in setbc.f
C
C-----------------------------------------------------------
C
      COMMON /ABC$/
     &   V1$(JX,IX),V2$(JX,IX),V3$(JX,IX),V4$(JX,IX),V5$(JX,IX),
     &   V6$(JX,IX),V7$(JX,IX),V8$(JX,IX),
     &   VT$(ISX,IX),
     &   Z1$(JX,IX),Z2$(JX,IX),Z3$(JX,IX),Z4$(JX,IX),Z5$(JX,IX),
     &   Z6$(JX,IX),Z7$(JX,IX),Z8$(JX,IX),
     &   ZT$(ISX,IX),
     &   A1$(JX,IX),A2$(JX,IX),A3$(JX,IX),A4$(JX,IX),A5$(JX,IX),
     &   A6$(JX,IX),A7$(JX,IX),A8$(JX,IX),
     &   AT$(ISX,IX),
     &   B1$(JX,IX),B2$(JX,IX),B3$(JX,IX),B4$(JX,IX),B5$(JX,IX),
     &   B6$(JX,IX),B7$(JX,IX),B8$(JX,IX),
     &   BT$(ISX,IX),
     &   C1$(JX,IX),C2$(JX,IX),C3$(JX,IX),
     &   C6$(JX,IX),C7$(JX,IX),
     &   CT$(ISX,IX)
C
      COMMON /CTH$/
     &   ZNC$(ISX,4,IX),BNC$(ISX,4,IX),ANC$(ISX,4,IX),CNC$(ISX,4,IX),
     &   ZNT$(ISX,4,IX),BNT$(ISX,4,IX),ANT$(ISX,4,IX),CNT$(ISX,4,IX),
     &   ZNH$(ISX,4,IX),BNH$(ISX,4,IX),ANH$(ISX,4,IX),CNH$(ISX,4,IX),
     &   ZRC$(ISX,2,IX),BRC$(ISX,2,IX),ARC$(ISX,2,IX),
     &   ZRT$(ISX,2,IX),BRT$(ISX,2,IX),ART$(ISX,2,IX),
     &   ZRH$(ISX,2,IX),BRH$(ISX,2,IX),ARH$(ISX,2,IX),
     &                  BVC$(ISX,6,IX),AVC$(ISX,6,IX),
     &                  BVT$(ISX,6,IX),AVT$(ISX,6,IX),
     &                  BVH$(ISX,6,IX),AVH$(ISX,6,IX),
     &    AI$(ISX,6,IX),BI$(ISX,6,IX)
C
      COMMON /RHS$/ DR$(KX,0:NGLX,IX)
C
C
      DIMENSION ZABC (NABC), CVIS (NCTH)
      DIMENSION ZABC$(NABC), CVIS$(NCTH)
      EQUIVALENCE (V1 (1,1),ZABC (1)), (ZNC (1,1,1),CVIS (1))
      EQUIVALENCE (V1$(1,1),ZABC$(1)), (ZNC$(1,1,1),CVIS$(1))
C
      DIMENSION AA(4), DD(4)
      CHARACTER*2 SS(4)
C
 2002 FORMAT(/1X,A,6X,'i-1',11X,
     &             6X,'i  ',11X )
C
 2003 FORMAT(/1X,A,6X,'i-2',11X,
     &             6X,'i-1',11X,
     &             6X,'i  ',11X )
C
 2004 FORMAT(/1X,A,6X,'i-2',11X,
     &             6X,'i-1',11X,
     &             6X,'i  ',11X,
     &             6X,'i+1',11X )
C
 2100 FORMAT(/1X,A,   E15.6,1X,A2,2X
     &       /1X,A,   E15.6,1X,A2,2X  )
 2200 FORMAT(/1X,A, 2(E15.6,1X,A2,2X)
     &       /1X,A, 2(E15.6,1X,A2,2X) )
 2300 FORMAT(/1X,A, 3(E15.6,1X,A2,2X)
     &       /1X,A, 3(E15.6,1X,A2,2X) )
 2400 FORMAT(/1X,A, 4(E15.6,1X,A2,2X)
     &       /1X,A, 4(E15.6,1X,A2,2X) )
 2500 FORMAT(/1X,A, 5(E15.6,1X,A2,2X)
     &       /1X,A, 5(E15.6,1X,A2,2X) )
C
C---- perturbation amplitude
      EPS = 1.0D-7
C
C
C---- store baseline Jacobian
      DO K=1, NABC
        ZABC$(K) = ZABC(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS$(K) = CVIS(K)
      ENDDO
C
      DO I=1, II
        DO J=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR$(J,L,I) = DR(J,L,I)
          ENDDO
        ENDDO
      ENDDO
C
C
C---- set location I,IS of perturbed BL variables
      IS = 1
C
      N = (is+1)/2
      I = iteb(N) + 1
ccc      I = 118
c
      KS = IS - 2*(N-1)
C
C---- set location I,J of perturbed inviscid variables
      J  = JS1(N)+1
      LN = 2
C
      JR = JS1(N)
      LR = 1
C
      J  = JS1(N)
      LN = 1
C
C
c      J  = JS2(N)
c      LN = 4
cC
c      JR = JS2(N)-1
c      LR = 2
cC
c      J  = JS2(N)-1
c      LN = 3
C
C
      IK = I-3
      IL = I-2
      IM = I-1
      IO = I
      IP = I+1
      IQ = I+2
      IR = I+3
C
      JM = J-1
      JO = J
      JP = J+1
C
C
C
C---- display indices and local H
      WRITE(LU,*)
      WRITE(LU,*) 'i is =', I, IS
      WRITE(LU,*) 'Ct =', CTAU(I,IS)
      WRITE(LU,*) 'Th =', THET(I,IS)
      WRITE(LU,*) 'Ds =', DSTR(I,IS)
      WRITE(LU,*) 'H  =', DSTR(I,IS)/THET(I,IS)
      WRITE(LU,*)
C
C
ccc      go to 300
C
C====================================
C---- perturb grid node
 100  CONTINUE
C
      XSAV = X(I,J)
      YSAV = Y(I,J)
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
      CALL SETBL
      CALL SETBC
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      WRITE(LU,2004)
     &  '                '
C
      AA(1) = (ZNC$(IST,LN,IQ) + ZNC(IST,LN,IQ))*0.5
      AA(2) = (BNC$(IST,LN,IP) + BNC(IST,LN,IP))*0.5
      AA(3) = (ANC$(IST,LN,IO) + ANC(IST,LN,IO))*0.5
      AA(4) = (CNC$(IST,LN,IM) + CNC(IST,LN,IM))*0.5
      DD(1) = (DR$(JC,1,IQ)-DR(JC,1,IQ))/EPS
      DD(2) = (DR$(JC,1,IP)-DR(JC,1,IP))/EPS
      DD(3) = (DR$(JC,1,IO)-DR(JC,1,IO))/EPS
      DD(4) = (DR$(JC,1,IM)-DR(JC,1,IM))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      CALL COMPARE(SS(4),AA(4),DD(4))
      WRITE(LU,2400) 'BL lag  dR/dn  :', (AA(K),SS(K), K=1, 4),
     &               '    (R-R)/(n-n):', (DD(K),SS(K), K=1, 4)
C
      AA(1) = (ZNT$(IST,LN,IQ) + ZNT(IST,LN,IQ))*0.5
      AA(2) = (BNT$(IST,LN,IP) + BNT(IST,LN,IP))*0.5
      AA(3) = (ANT$(IST,LN,IO) + ANT(IST,LN,IO))*0.5
      AA(4) = (CNT$(IST,LN,IM) + CNT(IST,LN,IM))*0.5
      DD(1) = (DR$(JT,1,IQ)-DR(JT,1,IQ))/EPS
      DD(2) = (DR$(JT,1,IP)-DR(JT,1,IP))/EPS
      DD(3) = (DR$(JT,1,IO)-DR(JT,1,IO))/EPS
      DD(4) = (DR$(JT,1,IM)-DR(JT,1,IM))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      CALL COMPARE(SS(4),AA(4),DD(4))
      WRITE(LU,2400) 'BL mom  dR/dn  :', (AA(K),SS(K), K=1, 4),
     &               '    (R-R)/(n-n):', (DD(K),SS(K), K=1, 4)
C
      AA(1) = (ZNH$(IST,LN,IQ) + ZNH(IST,LN,IQ))*0.5
      AA(2) = (BNH$(IST,LN,IP) + BNH(IST,LN,IP))*0.5
      AA(3) = (ANH$(IST,LN,IO) + ANH(IST,LN,IO))*0.5
      AA(4) = (CNH$(IST,LN,IM) + CNH(IST,LN,IM))*0.5
      DD(1) = (DR$(JH,1,IQ)-DR(JH,1,IQ))/EPS
      DD(2) = (DR$(JH,1,IP)-DR(JH,1,IP))/EPS
      DD(3) = (DR$(JH,1,IO)-DR(JH,1,IO))/EPS
      DD(4) = (DR$(JH,1,IM)-DR(JH,1,IM))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      CALL COMPARE(SS(4),AA(4),DD(4))
      WRITE(LU,2400) 'BL shp  dR/dn  :', (AA(K),SS(K), K=1, 4),
     &               '    (R-R)/(n-n):', (DD(K),SS(K), K=1, 4)
C
      ENDDO
C
      X(I,J) = XSAV
      Y(I,J) = YSAV
C
C====================================
C---- perturb density
 200  CONTINUE
      RSAV = R(I,JR)
      R(I,JR) = R(I,JR) + EPS
C
      CALL SETUP
      CALL SETBL
      CALL SETBC
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      WRITE(LU,2003)
     &  '                '
C
      AA(1) = (ZRC$(IST,LR,IQ) + ZRC(IST,LR,IQ))*0.5
      AA(2) = (BRC$(IST,LR,IP) + BRC(IST,LR,IP))*0.5
      AA(3) = (ARC$(IST,LR,IO) + ARC(IST,LR,IO))*0.5
      DD(1) = (DR$(JC,1,IQ)-DR(JC,1,IQ))/EPS
      DD(2) = (DR$(JC,1,IP)-DR(JC,1,IP))/EPS
      DD(3) = (DR$(JC,1,IO)-DR(JC,1,IO))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) 'BL lag  dR/drho:', (AA(K),SS(K), K=1, 3),
     &               '    (R-R)/(r-r):', (DD(K),SS(K), K=1, 3)
C
      AA(1) = (ZRT$(IST,LR,IQ) + ZRT(IST,LR,IQ))*0.5
      AA(2) = (BRT$(IST,LR,IP) + BRT(IST,LR,IP))*0.5
      AA(3) = (ART$(IST,LR,IO) + ART(IST,LR,IO))*0.5
      DD(1) = (DR$(JT,1,IQ)-DR(JT,1,IQ))/EPS
      DD(2) = (DR$(JT,1,IP)-DR(JT,1,IP))/EPS
      DD(3) = (DR$(JT,1,IO)-DR(JT,1,IO))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) 'BL mom  dR/drho:', (AA(K),SS(K), K=1, 3),
     &               '    (R-R)/(r-r):', (DD(K),SS(K), K=1, 3)
C
      AA(1) = (ZRH$(IST,LR,IQ) + ZRH(IST,LR,IQ))*0.5
      AA(2) = (BRH$(IST,LR,IP) + BRH(IST,LR,IP))*0.5
      AA(3) = (ARH$(IST,LR,IO) + ARH(IST,LR,IO))*0.5
      DD(1) = (DR$(JH,1,IQ)-DR(JH,1,IQ))/EPS
      DD(2) = (DR$(JH,1,IP)-DR(JH,1,IP))/EPS
      DD(3) = (DR$(JH,1,IO)-DR(JH,1,IO))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) 'BL shp  dR/drho:', (AA(K),SS(K), K=1, 3),
     &               '    (R-R)/(r-r):', (DD(K),SS(K), K=1, 3)
C
      ENDDO
C
      R(I,JR) = RSAV
      CALL SETUP
      CALL SETBL
      CALL SETBC
C
C
C====================================
C---- perturb Ctau
 300  CONTINUE
      CTAU0 = CTAU(I,IS)
C
      DCTAU = CTAU(I,IS)*EPS
      CTAU(I,IS) = CTAU(I,IS) + DCTAU
      LV = 3*(KS-1) + 1
C
      CALL SETBL
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      WRITE(LU,2002)
     &  '                '
C
      AA(2) = (BVC$(IST,LV,IP) + BVC(IST,LV,IP))*0.5
      AA(3) = (AVC$(IST,LV,IO) + AVC(IST,LV,IO))*0.5
      DD(2) = (DR$(JC,1,IP)-DR(JC,1,IP))/DCTAU
      DD(3) = (DR$(JC,1,IO)-DR(JC,1,IO))/DCTAU
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL lag  dR/dCt :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ct-Ct):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVT$(IST,LV,IP) + BVT(IST,LV,IP))*0.5
      AA(3) = (AVT$(IST,LV,IO) + AVT(IST,LV,IO))*0.5
      DD(2) = (DR$(JT,1,IP)-DR(JT,1,IP))/DCTAU
      DD(3) = (DR$(JT,1,IO)-DR(JT,1,IO))/DCTAU
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL mom  dR/dCt :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ct-Ct):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVH$(IST,LV,IP) + BVH(IST,LV,IP))*0.5
      AA(3) = (AVH$(IST,LV,IO) + AVH(IST,LV,IO))*0.5
      DD(2) = (DR$(JH,1,IP)-DR(JH,1,IP))/DCTAU
      DD(3) = (DR$(JH,1,IO)-DR(JH,1,IO))/DCTAU
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL shp  dR/dCt :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ct-Ct):', (DD(K),SS(K), K=2, 3)
C
      ENDDO
C
      CTAU(I,IS) = CTAU0
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C
C====================================
C---- perturb Theta
      THET0 = THET(I,IS)
C
      DTHET = THET(I,IS)*EPS
      THET(I,IS) = THET(I,IS) + DTHET
      LV = 3*(KS-1) + 2
C
      CALL SETBL
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      WRITE(LU,2002)
     &  '                '
C
      AA(2) = (BVC$(IST,LV,IP) + BVC(IST,LV,IP))*0.5
      AA(3) = (AVC$(IST,LV,IO) + AVC(IST,LV,IO))*0.5
      DD(2) = (DR$(JC,1,IP)-DR(JC,1,IP))/DTHET
      DD(3) = (DR$(JC,1,IO)-DR(JC,1,IO))/DTHET
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL lag  dR/dTh :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Th-Th):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVT$(IST,LV,IP) + BVT(IST,LV,IP))*0.5
      AA(3) = (AVT$(IST,LV,IO) + AVT(IST,LV,IO))*0.5
      DD(2) = (DR$(JT,1,IP)-DR(JT,1,IP))/DTHET
      DD(3) = (DR$(JT,1,IO)-DR(JT,1,IO))/DTHET
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL mom  dR/dTh :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Th-Th):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVH$(IST,LV,IP) + BVH(IST,LV,IP))*0.5
      AA(3) = (AVH$(IST,LV,IO) + AVH(IST,LV,IO))*0.5
      DD(2) = (DR$(JH,1,IP)-DR(JH,1,IP))/DTHET
      DD(3) = (DR$(JH,1,IO)-DR(JH,1,IO))/DTHET
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL shp  dR/dTh :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Th-Th):', (DD(K),SS(K), K=2, 3)
C
      ENDDO
C
      THET(I,IS) = THET0
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C
C====================================
C---- perturb Dstar
      DSTR0 = DSTR(I,IS)
C
      DDSTR = DSTR(I,IS)*EPS
      DSTR(I,IS) = DSTR(I,IS) + DDSTR
      LV = 3*(KS-1) + 3
C
      CALL SETBL
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      WRITE(LU,2002)
     &  '                '
C
      AA(2) = (BVC$(IST,LV,IP) + BVC(IST,LV,IP))*0.5
      AA(3) = (AVC$(IST,LV,IO) + AVC(IST,LV,IO))*0.5
      DD(2) = (DR$(JC,1,IP)-DR(JC,1,IP))/DDSTR
      DD(3) = (DR$(JC,1,IO)-DR(JC,1,IO))/DDSTR
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL lag  dR/dDs :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ds-Ds):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVT$(IST,LV,IP) + BVT(IST,LV,IP))*0.5
      AA(3) = (AVT$(IST,LV,IO) + AVT(IST,LV,IO))*0.5
      DD(2) = (DR$(JT,1,IP)-DR(JT,1,IP))/DDSTR
      DD(3) = (DR$(JT,1,IO)-DR(JT,1,IO))/DDSTR
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL mom  dR/dDs :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ds-Ds):', (DD(K),SS(K), K=2, 3)
C
      AA(2) = (BVH$(IST,LV,IP) + BVH(IST,LV,IP))*0.5
      AA(3) = (AVH$(IST,LV,IO) + AVH(IST,LV,IO))*0.5
      DD(2) = (DR$(JH,1,IP)-DR(JH,1,IP))/DDSTR
      DD(3) = (DR$(JH,1,IO)-DR(JH,1,IO))/DDSTR
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2200) 'BL shp  dR/dDs :', (AA(K),SS(K), K=2, 3),
     &               '  (R-R)/(Ds-Ds):', (DD(K),SS(K), K=2, 3)
C
      ENDDO
C
      DSTR(I,IS) = DSTR0
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C====================================
C---- perturb mass flow
      MINF0 = MINF
      MASS0 = RHOINF*QINF*AINF
C
      DMINF = EPS
      MINF = MINF + DMINF
      CALL FFCALC
      MASS = RHOINF*QINF*AINF
      IF(LREYN.EQ.0) THEN
       REYN = REYNIN/(RHOINF*QINF/MUINF)
      ENDIF
C
      DMASS = MASS - MASS0
C
      DO JTMP=1, JJ-1
        M(JTMP) = M(JTMP) + MF0(JTMP)*DMASS
      ENDDO
C
      CALL SETUP
      CALL SETBL
C
      L = LMASS
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      AA(1) = (DR$(JC,L,IO)+DR(JC,L,IO))*0.5
      DD(1) = (DR$(JC,1,IO)-DR(JC,1,IO))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL lag dR/dmass:', AA(1), SS(1),
     &               '    (R-R)/(m-m):', DD(1), SS(1)
C
      AA(1) = (DR$(JT,L,IO)+DR(JT,L,IO))*0.5
      DD(1) = (DR$(JT,1,IO)-DR(JT,1,IO))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL mom dR/dmass:', AA(1), SS(1),
     &               '    (R-R)/(m-m):', DD(1), SS(1)
C
      AA(1) = (DR$(JH,L,IO)+DR(JH,L,IO))*0.5
      DD(1) = (DR$(JH,1,IO)-DR(JH,1,IO))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL shp dR/dmass:', AA(1), SS(1),
     &               '    (R-R)/(m-m):', DD(1), SS(1)
C
      ENDDO
C
      MINF = MINF0
      DO JTMP=1, JJ-1
        M(JTMP) = M(JTMP) - MF0(JTMP)*DMASS
      ENDDO
C
      CALL FFCALC
      MASS = RHOINF*QINF*AINF
      IF(LREYN.EQ.0) THEN
       REYN = REYNIN/(RHOINF*QINF/MUINF)
      ENDIF
C
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO
C
C====================================
C---- perturb Reynolds number
      REYN0 = REYN
C
      DREYN = EPS*REYN
      REYN = REYN + DREYN
C
      CALL SETUP
      CALL SETBL
C
      L = LREYN
C
      DO IST = IS1(N), IS2(N)
C
C---- BL equation row indices
      JC = 2*JJ   + 3*(IST-1)
      JT = 2*JJ+1 + 3*(IST-1)
      JH = 2*JJ+2 + 3*(IST-1)
C
      AA(1) = (DR$(JC,L,IO)+DR(JC,L,IO))*0.5
      DD(1) = (DR$(JC,1,IO)-DR(JC,1,IO))/DREYN
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL lag dR/dReyn:', AA(1), SS(1),
     &               '    (R-R)/(R-R):', DD(1), SS(1)
C
      AA(1) = (DR$(JT,L,IO)+DR(JT,L,IO))*0.5
      DD(1) = (DR$(JT,1,IO)-DR(JT,1,IO))/DREYN
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL mom dR/dReyn:', AA(1), SS(1),
     &               '    (R-R)/(R-R):', DD(1), SS(1)
C
      AA(1) = (DR$(JH,L,IO)+DR(JH,L,IO))*0.5
      DD(1) = (DR$(JH,1,IO)-DR(JH,1,IO))/DREYN
      CALL COMPARE(SS(1),AA(1),DD(1))
      WRITE(LU,2100) 'BL shp dR/dReyn:', AA(1), SS(1),
     &               '    (R-R)/(R-R):', DD(1), SS(1)
C
      ENDDO
C
      REYN = REYN0
C
C
      DO K=1, NABC
        ZABC(K) = ZABC$(K)
      ENDDO
C
      DO K=1, NCTH
        CVIS(K) = CVIS$(K)
      ENDDO
C
      DO IT=1, II
        DO JT=1, 2*JJ-1+6*NBL
          DO L=1, NRHS
            DR(JT,L,IT) = DR$(JT,L,IT)
          ENDDO
        ENDDO
      ENDDO

      RETURN
      END



      SUBROUTINE LINCHK4(LU)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C-----------------------------------------------------------
C     Routine for checking UINV,DUDN linearizations
C
C     Individually perturbs the Newton BL variables  
C
C         n     grid node (determines Ue)
C         rho   density   (determines Ue)
C         mass  total mass flow
C
C     and compares the analytic Jacobian derivatives with 
C     finite-differenced derivatives.
C-----------------------------------------------------------
C
      COMMON/UES$/DUIDR1$(IX,ISX), DUIDR2$(IX,ISX), DUIDMS$(IX,ISX),
     &            DUIN1M$(IX,ISX), DUIN1P$(IX,ISX), DUIN2M$(IX,ISX),
     &            DUIN2P$(IX,ISX), DUIN3M$(IX,ISX), DUIN3P$(IX,ISX),
     &            DUIDM1$(IX,ISX,NBX),DUIDAL$(IX,ISX),
     &            DUIDNG$(IX,ISX,NBX),DUIDNP$(IX,ISX,NPOSX),
     &            DRHDR1$(IX,ISX), DRHDR2$(IX,ISX), DRHDMS$(IX,ISX),
     &            DRHN1M$(IX,ISX), DRHN1P$(IX,ISX), DRHN2M$(IX,ISX),
     &            DRHN2P$(IX,ISX), DRHN3M$(IX,ISX), DRHN3P$(IX,ISX),
     &            DRHDM1$(IX,ISX,NBX),DRHDAL$(IX,ISX),
     &            DRHDNG$(IX,ISX,NBX),DRHDNP$(IX,ISX,NPOSX),
     &            DUNDR1$(IX,ISX), DUNDR2$(IX,ISX), DUNDMS$(IX,ISX),
     &            DUNN1M$(IX,ISX), DUNN1P$(IX,ISX), DUNN2M$(IX,ISX),
     &            DUNN2P$(IX,ISX), DUNN3M$(IX,ISX), DUNN3P$(IX,ISX),
     &            DUNDM1$(IX,ISX,NBX),DUNDAL$(IX,ISX),
     &            DUNDNG$(IX,ISX,NBX),DUNDNP$(IX,ISX,NPOSX),
     &            DXIDNP$(IX,ISX,NPOSX)
      DIMENSION UINV$(IX,ISX),DUDN$(IX,ISX),RHOI$(IX,ISX)
C
      PARAMETER (NUE = 30*IX*ISX + 6*NBX*IX*ISX + 4*NPOSX*IX*ISX)
C
      DIMENSION CUE (NUE)
      DIMENSION CUE$(NUE)
      EQUIVALENCE (DUIDR1 (1,1),CUE (1))
      EQUIVALENCE (DUIDR1$(1,1),CUE$(1))
C
      DIMENSION AA(4), DD(4)
      CHARACTER*2 SS(4)
C
C
 2002 FORMAT(/1X,A,6X,'i-1',11X,
     &             6X,'i  ',11X )
C
 2003 FORMAT(/1X,A,6X,'i-2',11X,
     &             6X,'i-1',11X,
     &             6X,'i  ',11X )
C
 2004 FORMAT(/1X,A,6X,'i-2',11X,
     &             6X,'i-1',11X,
     &             6X,'i  ',11X,
     &             6X,'i+1',11X )
C
 2100 FORMAT(/1X,A,  E15.6,1X,A2,2X
     &       /1X,A,  E15.6,1X,A2,2X  )
 2200 FORMAT(/1X,A,2(E15.6,1X,A2,2X)
     &       /1X,A,2(E15.6,1X,A2,2X) )
 2300 FORMAT(/1X,A,3(E15.6,1X,A2,2X)
     &       /1X,A,3(E15.6,1X,A2,2X) )
C
C---- perturbation amplitude
      EPS = 1.0D-6
C
C
C---- store baseline Jacobian
      DO K=1, NUE
        CUE$(K) = CUE(K)
      ENDDO
C
      DO I=1, II
        DO IS=1, 2*NBL
          UINV$(I,IS) = UINV(I,IS)
          DUDN$(I,IS) = DUDN(I,IS)
          RHOI$(I,IS) = RHOI(I,IS)
        ENDDO
      ENDDO
C
C
C---- set location I,J,IS of perturbed variables
      N = 1
C
      I  =  ILEB(N) + 85
      I = 32
C
      IM = I-1
      IO = I
      IP = I+1
C
ccc      go to 300
C
C====================================
C---- perturb grid node
 100  CONTINUE
      IS = IS2(N)
C
      J = JS2(N)-1
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
C
      WRITE(LU,2004)
     &  '                '
C
      AA(1) = (DUIN1M$(IP,IS) + DUIN1M(IP,IS))*0.5
      AA(2) = (DUIN2M$(IO,IS) + DUIN2M(IO,IS))*0.5
      AA(3) = (DUIN3M$(IM,IS) + DUIN3M(IM,IS))*0.5
      DD(1) = (UINV(IP,IS)-UINV$(IP,IS))/EPS
      DD(2) = (UINV(IO,IS)-UINV$(IO,IS))/EPS
      DD(3) = (UINV(IM,IS)-UINV$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dUi/dn-  :', (AA(K), SS(K), K=1, 3),
     &               '  (Ui-Ui)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      AA(1) = (DRHN1M$(IP,IS) + DRHN1M(IP,IS))*0.5
      AA(2) = (DRHN2M$(IO,IS) + DRHN2M(IO,IS))*0.5
      AA(3) = (DRHN3M$(IM,IS) + DRHN3M(IM,IS))*0.5
      DD(1) = (RHOI(IP,IS)-RHOI$(IP,IS))/EPS
      DD(2) = (RHOI(IO,IS)-RHOI$(IO,IS))/EPS
      DD(3) = (RHOI(IM,IS)-RHOI$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dRh/dn-  :', (AA(K), SS(K), K=1, 3),
     &               '  (Rh-Rh)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      AA(1) = (DUNN1M$(IP,IS) + DUNN1M(IP,IS))*0.5
      AA(2) = (DUNN2M$(IO,IS) + DUNN2M(IO,IS))*0.5
      AA(3) = (DUNN3M$(IM,IS) + DUNN3M(IM,IS))*0.5
      DD(1) = (DUDN(IP,IS)-DUDN$(IP,IS))/EPS
      DD(2) = (DUDN(IO,IS)-DUDN$(IO,IS))/EPS
      DD(3) = (DUDN(IM,IS)-DUDN$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dUn/dn-  :', (AA(K), SS(K), K=1, 3),
     &               '  (Un-Un)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C
C
C
      J = JS2(N)
      X(I,J) = X(I,J) + EPS*NX(I,J)
      Y(I,J) = Y(I,J) + EPS*NY(I,J)
C
      CALL SETUP
C
      WRITE(LU,2004)
     &  '                '
      AA(1) = (DUIN1P$(IP,IS) + DUIN1P(IP,IS))*0.5
      AA(2) = (DUIN2P$(IO,IS) + DUIN2P(IO,IS))*0.5
      AA(3) = (DUIN3P$(IM,IS) + DUIN3P(IM,IS))*0.5
      DD(1) = (UINV(IP,IS)-UINV$(IP,IS))/EPS
      DD(2) = (UINV(IO,IS)-UINV$(IO,IS))/EPS
      DD(3) = (UINV(IM,IS)-UINV$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dUi/dn+  :', (AA(K), SS(K), K=1, 3),
     &               '  (Ui-Ui)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      AA(1) = (DRHN1P$(IP,IS) + DRHN1P(IP,IS))*0.5
      AA(2) = (DRHN2P$(IO,IS) + DRHN2P(IO,IS))*0.5
      AA(3) = (DRHN3P$(IM,IS) + DRHN3P(IM,IS))*0.5
      DD(1) = (RHOI(IP,IS)-RHOI$(IP,IS))/EPS
      DD(2) = (RHOI(IO,IS)-RHOI$(IO,IS))/EPS
      DD(3) = (RHOI(IM,IS)-RHOI$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dRh/dn+  :', (AA(K), SS(K), K=1, 3),
     &               '  (Rh-Rh)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      AA(1) = (DUNN1P$(IP,IS) + DUNN1P(IP,IS))*0.5
      AA(2) = (DUNN2P$(IO,IS) + DUNN2P(IO,IS))*0.5
      AA(3) = (DUNN3P$(IM,IS) + DUNN3P(IM,IS))*0.5
      DD(1) = (DUDN(IP,IS)-DUDN$(IP,IS))/EPS
      DD(2) = (DUDN(IO,IS)-DUDN$(IO,IS))/EPS
      DD(3) = (DUDN(IM,IS)-DUDN$(IM,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      CALL COMPARE(SS(3),AA(3),DD(3))
      WRITE(LU,2300) '      dUn/dn+  :', (AA(K), SS(K), K=1, 3),
     &               '  (Un-Un)/(n-n):', (DD(K), SS(K), K=1, 3)
C
      X(I,J) = X(I,J) - EPS*NX(I,J)
      Y(I,J) = Y(I,J) - EPS*NY(I,J)
C
C====================================
C---- perturb density
 200  CONTINUE
      J = JS2(N)-1
      R(I,J) = R(I,J) + EPS
C
      CALL SETUP
C
      WRITE(LU,2002)
     &  '                '
      AA(1) = (DUIDR1$(IP,IS) + DUIDR1(IP,IS))*0.5
      AA(2) = (DUIDR2$(IO,IS) + DUIDR2(IO,IS))*0.5
      DD(1) = (UINV(IP,IS)-UINV$(IP,IS))/EPS
      DD(2) = (UINV(IO,IS)-UINV$(IO,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2200) '      dUi/dr   :', (AA(K), SS(K), K=1, 2),
     &               '  (Ui-Ui)/(r-r):', (DD(K), SS(K), K=1, 2)
C
      AA(1) = (DRHDR1$(IP,IS) + DRHDR1(IP,IS))*0.5
      AA(2) = (DRHDR2$(IO,IS) + DRHDR2(IO,IS))*0.5
      DD(1) = (RHOI(IP,IS)-RHOI$(IP,IS))/EPS
      DD(2) = (RHOI(IO,IS)-RHOI$(IO,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2200) '      dRh/dr   :', (AA(K), SS(K), K=1, 2),
     &               '  (Rh-Rh)/(r-r):', (DD(K), SS(K), K=1, 2)
C
      AA(1) = (DUNDR1$(IP,IS) + DUNDR1(IP,IS))*0.5
      AA(2) = (DUNDR2$(IO,IS) + DUNDR2(IO,IS))*0.5
      DD(1) = (DUDN(IP,IS)-DUDN$(IP,IS))/EPS
      DD(2) = (DUDN(IO,IS)-DUDN$(IO,IS))/EPS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2200) '      dUn/dr   :', (AA(K), SS(K), K=1, 2),
     &               '  (Un-Un)/(r-r):', (DD(K), SS(K), K=1, 2)
C
      R(I,J) = R(I,J) - EPS
C
C====================================
C---- perturb mass flow
 300  CONTINUE
      MASS0 = RHOINF*QINF*AINF
C
      DMINF = EPS
      MINF = MINF + DMINF
      CALL FFCALC
      MASS = RHOINF*QINF*AINF
      IF(LREYN.EQ.0) THEN
       REYN = REYNIN/(RHOINF*QINF/MUINF)
      ENDIF
C
      DMASS = MASS - MASS0
C
      DO JTMP=1, JJ-1
        M(JTMP) = M(JTMP) + MF0(JTMP)*DMASS
      ENDDO
C
      CALL SETUP
C
      WRITE(LU,*)
     &  '                '
      AA(1) = (DUIDMS$(IP,IS) + DUIDMS(IP,IS))*0.5
      DD(1) = (UINV(IP,IS)-UINV$(IP,IS))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2100) '      dUi/dm   :', AA(1), SS(1),
     &               '  (Ui-Ui)/(m-m):', DD(1), SS(1)
C
      AA(1) = (DRHDMS$(IP,IS) + DRHDMS(IP,IS))*0.5
      DD(1) = (RHOI(IP,IS)-RHOI$(IP,IS))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2100) '      dRh/dm   :', AA(1), SS(1),
     &               '  (Rh-Rh)/(m-m):', DD(1), SS(1)
C
      AA(1) = (DUNDMS$(IP,IS) + DUNDMS(IP,IS))*0.5
      DD(1) = (DUDN(IP,IS)-DUDN$(IP,IS))/DMASS
      CALL COMPARE(SS(1),AA(1),DD(1))
      CALL COMPARE(SS(2),AA(2),DD(2))
      WRITE(LU,2100) '      dUn/dm   :', AA(1), SS(1),
     &               '  (Un-Un)/(m-m):', DD(1), SS(1)
C
      MINF = MINF - DMINF
      CALL FFCALC
      MASS = RHOINF*QINF*AINF
      IF(LREYN.EQ.0) THEN
       REYN = REYNIN/(RHOINF*QINF/MUINF)
      ENDIF
C
C
      DO K=1, NUE
        CUE(K) = CUE$(K)
      ENDDO
C
      DO I=1, II
        DO IS=1, 2*NBL
          UINV(I,IS) = UINV$(I,IS)
          DUDN(I,IS) = DUDN$(I,IS)
          RHOI(I,IS) = RHOI$(I,IS)
        ENDDO
      ENDDO
C
      RETURN
      END



      SUBROUTINE COMPARE(SP, A, D)
      CHARACTER*2 SP
C
      EPS0 = 5.0E-9
      EPS1 = 5.0E-5
C
      SP = '**'
      IF(A.EQ.D .OR. (ABS(A).LT.EPS0 .AND. ABS(D).LT.EPS0)) THEN
        SP = '  '
      ELSEIF(ABS(A).GT.ABS(D)) THEN
        IF( ABS(1.0-D/A) .LT. EPS1) SP = '  '
      ELSEIF(ABS(D).GT.ABS(A)) THEN
        IF( ABS(1.0-A/D) .LT. EPS1) SP = '  '
      ENDIF
C
      RETURN
      END
