      
      PROGRAM MPLOT
C-----------------------------------------------
C     Interactive program for plotting solution
C     contained in MSES dump file MDAT.xxx
C-----------------------------------------------
C
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      LOGICAL ERROR
C
      CALL MPLOTINIT
C
   10 WRITE(*,*)
      WRITE(*,*) '==================================='
      WRITE(*,*)
      WRITE(*,*) '   1  Airfoil surface  plots'
      WRITE(*,*) '   2  Streamtube       plots'
      WRITE(*,*) '   3  Contour/grid     plots'
      WRITE(*,*) '   4  Outer streamline plots'
      WRITE(*,*) '   5  Wake profile     plots'
      WRITE(*,1010)
 1010 FORMAT(/1X,'Select MPLOT option (0=Exit):  ', $)
      READ(*,*,ERR=10) NTYPE
C
      IF(NTYPE.EQ.0) CALL PLCLOSE
      IF(NTYPE.EQ.0) STOP
      IF(NTYPE.EQ.1) CALL SURFPL
      IF(NTYPE.EQ.2) CALL STRMPL
      IF(NTYPE.EQ.3) CALL CONTPL
      IF(NTYPE.EQ.4) CALL OSTRPL
      IF(NTYPE.EQ.5) CALL WAKEPL
      GO TO 10
      END ! MPLOT
 
 
 
      SUBROUTINE MPLOTINIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION SBSIDE(ISX)
C
C---- Get case data from MDAT file
      CALL INPUT
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU 4    (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU 10+?
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.70
C
C---- Default page dimensions in inches (also the hardcopy output area)
      XPAGE = 11.0
      YPAGE = 8.5
C
C---- page margins in inches
      XMARG = 0.0
      YMARG = 0.0
C
C---- Default size in inches of typical plot object
C-   (Must be smaller than XPAGE if objects are to fit on paper page)
      SIZE = 10.0
C
C---- plot aspect ratio Y/X for x-y plots
      AR = 0.725
C
C---- basic character size / SIZE
      CH = 0.017
C
C---- u-profile scaling weight
      UWT = 0.020
C
C---- initialize plot routines and set up basic colors
      CALL PLINITIALIZE
C
C---- set up standard spectrum colormap
      NCOLOR = 64
      CALL COLORSPECTRUMHUES1(NCOLOR,'BCGYR')
C
C---- set color for top,bottom side of each airfoil
cc      1   Black
cc      2   White
cc      3   Red  
cc      4   Orange
cc      5   Yellow
cc      6   Green 
cc      7   Cyan  
cc      8   Blue  
cc      9   Violet
cc      10  Magenta
C
      DO N=1, NBX
        ICOLS(2*N-1) = 5
        ICOLS(2*N  ) = 7
      ENDDO
C
C---- use color plotting for X11 window
      LCOLOR = .TRUE.
C
C---- plot color bar on contour plots
      LCBAR  = .TRUE.
C
C---- flag indicating cursor blowup input is selected
      LCURS = .TRUE.
C
C---- landscape plot orientation
      LLAND = .TRUE.
C
C---- Initial element to plot on x-y plots
      NBPLT = 1
C
      LNHATS = .FALSE.
      LDELTA = .FALSE.
      LLAMPL = .TRUE.
C
C---- overlay grid on x-y plots
      LGRID = .TRUE.
C
C---- by default, plot lines without symbols on x-y plots
      LSYMB = .FALSE.
C
C---- do not plot wake Cp, Mach distributions on x-y plots
      LPWAKE = .FALSE.
C
C---- shade displacement body with BL profile plo
      LSHADE = .FALSE.
C
C---- initialize indices and pointers to element surfaces and streamlines
      CALL INDINI
C
C*******************************
C---- Flow Field initialization
C*******************************
      GM1 = GAM - 1.0
      GP1 = GAM + 1.0
C
      RSTINF = RSTOUT
      PSTINF = PSTOUT
      MSQINF = MINF*MINF
      QU = 0.5*RHOINF*QINF**2
C
C---- set sonic quantities
      PSTAR  =  PSTINF/(1.0 + 0.5*GM1)**(GAM/GM1)
      CPSTAR = (PSTAR - PINF) / QU
      QSTAR  =  SQRT(2.0*HINF/(2.0/GM1 + 1.0))
C
C---- calculate streamline quantities
      DO 12 JO=1, JJ-1
C
        JP = JO+1
C
C------ arc length between cell centers
        SC(1,JO) = 0.
        X1 = 0.25*(X(1,JO)+X(1,JP)+X(2,JO)+X(2,JP))
        Y1 = 0.25*(Y(1,JO)+Y(1,JP)+Y(2,JO)+Y(2,JP))
        DO 8 IO=2, II-1
          IP = IO+1
          X2 = 0.25*(X(IO,JO)+X(IO,JP)+X(IP,JO)+X(IP,JP))
          Y2 = 0.25*(Y(IO,JO)+Y(IO,JP)+Y(IP,JO)+Y(IP,JP))
          SC(IO,JO) = SC(IO-1,JO) + SQRT((X2-X1)**2 + (Y2-Y1)**2)
          X1 = X2
          Y1 = Y2
 8      CONTINUE
C
        IF (JSTAG(JO).GT.0) THEN
C-------- fill dummy streamtube arrays to avoid arithmetic faults
          DO IO=1, II-1
            PST(IO,JO) = PSTINF
            R(IO,JO) = RHOINF
            P(IO,JO) = PINF - PSTINF
            Q(IO,JO) = QINF
          ENDDO
          GO TO 12
        ENDIF
C
C------ calculate streamtube quantities
        JP = JO+1
        CALL PICALC(JO, Q(1,JO),QS(1,JO),P(1,JO), PI(1,JO),PI(1,JP))
C
        DO 10 IO=1, II-1
C-------- stagnation pressure is based on upwinded speed
          TRAT = 1.0 - 0.5*QS(IO,JO)**2 / HINF
C
          TRAT = MAX(0.000001 , TRAT)
          PST(IO,JO) = (P(IO,JO)+PSTINF) * TRAT**(-GAM/GM1)
 10     CONTINUE
C
C------ set field source strength
        DO 11 IO=2, II-2
          MSQ = R(IO,JO)*Q(IO,JO)**2 / (GAM*(P(IO,JO)+PSTINF))
          DQDS = ( Q(IO+1,JO) -  Q(IO-1,JO))
     &         / (SC(IO+1,JO) - SC(IO-1,JO))
C
          SRC(IO,JO) = MSQ*DQDS
 11    CONTINUE
       SRC(   1,JO) = SRC(   2,JO)
       SRC(II-1,JO) = SRC(II-2,JO)
C
 12   CONTINUE
C
C---- spline wake trajectories
      DO 15 N=1, NBL
        CALL SCALC(XW(1,N),YW(1,N),SW(1,N),NOUT(N))
        CALL SPLINE(XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
        CALL SPLINE(YW(1,N),YPW(1,N),SW(1,N),NOUT(N))
 15   CONTINUE
C
C
C---- set BL variables
      CALL BLINIT
C
C*********************************
C---- Surface Flow initialization
C*********************************
C
C---- extrapolate Pi pressures to inlet and outlet
      DO 20 J=1, JJ
        I = 1
        PI(I,J) = 2.0*PI(I+1,J) - PI(I+2,J)
C
        I = II
        PI(I,J) = 2.0*PI(I-1,J) - PI(I-2,J)
   20 CONTINUE
C
C---- isentropic surface streamlines define...
      DPINF = PINF-PSTINF
      DO 34 IS=1, 2*NBL
        JO = JSRF(IS)
        DO 342 IO=2, II-1
C
C-------- set wall pressure corrected for BL curvature
          CALL DPDN(IO,IS,DPN)
          PWALL = PI(IO,JO)
     &          + DPN*(WXPT*THET(IO,IS) + WXPD*DSTR(IO,IS))
C
C-------- isentropic Mach number
          PLIM = MAX(0.000001 , PWALL+PSTINF)
          PBAR = (PSTINF/PLIM)**(GM1/GAM)
          PBAR = MAX(1.0,PBAR)
C
          MI(IO,IS) = SQRT(2.0/GM1*ABS(PBAR-1.0))
          MI(IO,IS) = MAX(1.0E-4,MI(IO,IS))
C
C-------- Cp
          CPI(IO,IS) = (PWALL-DPINF)/QU
C
C-------- Cf based on freestream dynamic pressure
          TAU(IO,IS) = TAU(IO,IS) / QU
C
C-------- Cf based on BL edge dynamic pressure
ccc       QLOCAL = 0.5*RHOE(IO,IS)*UEDG(IO,IS)**2
ccc       TAU(IO,IS) = TAU(IO,IS) / QLOCAL
C
 342    CONTINUE
C
C------ extrapolate surface-streamline variables to inlet and outlet
        IO = 1
        MI (IO,IS) = 2.0*MI (IO+1,IS) - MI (IO+2,IS)
        CPI(IO,IS) = 2.0*CPI(IO+1,IS) - CPI(IO+2,IS)
        TAU(IO,IS) = 2.0*TAU(IO+1,IS) - TAU(IO+2,IS)
C
        IO = II
        MI (IO,IS) = 2.0*MI (IO-1,IS) - MI (IO-2,IS)
        CPI(IO,IS) = 2.0*CPI(IO-1,IS) - CPI(IO-2,IS)
        TAU(IO,IS) = 2.0*TAU(IO-1,IS) - TAU(IO-2,IS)
 34   CONTINUE
C
C
C---- set side lengths and element nose,tail coordinates
      DO 45 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
C
        XNOSE(N) = XB(1,N)
        YNOSE(N) = YB(1,N)
        DO 451 IB=2, IIB(N)
          IF(XB(IB,N) .LE. XNOSE(N)) THEN
           XNOSE(N) = XB(IB,N)
           YNOSE(N) = YB(IB,N)
          ENDIF
  451   CONTINUE
        XTAIL(N) = 0.5*(XB(1,N) + XB(IIB(N),N))
        YTAIL(N) = 0.5*(YB(1,N) + YB(IIB(N),N))
   45 CONTINUE
C
C
C---- find grid point extrema
      XMAX = X(1,1)
      XMIN = X(1,1)
      YMAX = Y(1,1)
      YMIN = Y(1,1)
      DO 60 I=1, II
        DO 610 J=1, JJ
          XMAX = MAX(XMAX,X(I,J))
          XMIN = MIN(XMIN,X(I,J))
          YMAX = MAX(YMAX,Y(I,J))
          YMIN = MIN(YMIN,Y(I,J))
  610   CONTINUE
   60 CONTINUE
C
C---- find surface point extrema
      XBMAX = XB(1,1)
      YBMAX = YB(1,1)
      XBMIN = XB(1,1)
      YBMIN = YB(1,1)
      DO 70 N=1, NBL
        DO 710 IB=1, IIB(N)
          XBMAX = MAX(XBMAX,XB(IB,N))
          YBMAX = MAX(YBMAX,YB(IB,N))
          XBMIN = MIN(XBMIN,XB(IB,N))
          YBMIN = MIN(YBMIN,YB(IB,N))
  710   CONTINUE
   70 CONTINUE
C
C---- unpack isentropic-cell bit array into logical LISEN array
      DO 80 I=1, II-1
        DO 810 J=1, JJ-1
          NBIT = 1 + (J-1)/30
          JBIT = J - (NBIT-1)*30 - 1
C
          ISHIFT = ISBITS(NBIT,I) / 2**JBIT
          LISEN(I,J) = ISHIFT .GT. 2*(ISHIFT/2)
 810    CONTINUE
 80   CONTINUE
C
C---- set initial scale/offset for BL variable plots
      DO 90 N=1, NBL
        CALL DEFLIM(N)
 90   CONTINUE
C
C---- set initial scale/offset for contour and grid plots
      CALL OFFINI

C---- Mach plot axis limit and annotation increment
      MAMAX = 1.6
      MAMIN = 0.0
      MADEL = 0.2
C
C---- Cp plot axis limits and annotation increment
      CPMAX = 1.0
      CPMIN = -2.0*FLOAT(NBL)
      CPDEL = -0.5
      IF(CPMIN.LT.-6.0) CPDEL = -1.0
C
      RETURN
      END ! MPLOTINIT



      SUBROUTINE BLINIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
      DIMENSION SBSIDE(ISX)
C
      DO 45 N=1, NBL
        SBSIDE(IS1(N)) = SB(1     ,N) - SBLE(N)
        SBSIDE(IS2(N)) = SB(IIB(N),N) - SBLE(N)
 45   CONTINUE
C
C---- Define arc length, x-position, BL data for all airfoil sides
      DO 50 IS=1, 2*NBL
        N = (IS+1)/2
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ set surface streamline (J), and surface streamtube (JO,JP)
        IF(IS.EQ.IS1(N)) THEN
          J = JS1(N)
          JO = J
          JP = J+1
          YSGN = 1.0
        ELSE
          J = JS2(N)
          JO = J-1
          JP = J
          YSGN = -1.0
        ENDIF
C
        XLE = 0.5*(X(ILE,JS1(N)) + X(ILE,JS2(N)))
        XTE = 0.5*(X(ITE,JS1(N)) + X(ITE,JS2(N)))
C
        YLE = 0.5*(Y(ILE,JS1(N)) + Y(ILE,JS2(N)))
        YTE = 0.5*(Y(ITE,JS1(N)) + Y(ITE,JS2(N)))
C
C------ calculate BL arc length arrays
        DO 502 I=ILE, ITE
          IG = I-ILE+1
          SBI = SBLE(N) + SBSIDE(IS)*SG(IG,IS)
          SI(I,IS) = ABS(SBSIDE(IS))*SG(IG,IS)
          XI(I,IS) = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
  502   CONTINUE
C
        DO 504 I=ITE+1, II
          IW = I-ITE+1
          SWI = SGOUT(IW,N)*SWAK(N)
          SI(I,IS) = SI(ITE,IS) + SGOUT(IW,N)*SWAK(N)
          XI(I,IS) = SEVAL(SWI,XW(1,N),XPW(1,N),SW(1,N),NOUT(N))
  504   CONTINUE
C
        IF(REYN .GT. 0.0) THEN
C-------- set transition arc length location
          ITR = ITRAN(IS)
          SITR(IS) = SI(ITR-1,IS)
     &             + (SI(ITR,IS)-SI(ITR-1,IS))
     &              *(XTR(IS)   -XI(ITR-1,IS))
     &              /(XI(ITR,IS)-XI(ITR-1,IS))
        ENDIF
C
        UTMP = -.25*PCWT
        DO 507 I=ILE, II-1
          IM = I-1
          IO = I
          IP = I+1
C
C-------- set geometric quantities for streamtube cell
          SX2M = X(IP,JO) - X(IO,JO)
          SX2P = X(IP,JP) - X(IO,JP)
          SY2M = Y(IP,JO) - Y(IO,JO)
          SY2P = Y(IP,JP) - Y(IO,JP)
C
          SX2 = 0.5*(SX2M + SX2P)
          SY2 = 0.5*(SY2M + SY2P)
          S2 = SQRT(SX2*SX2 + SY2*SY2)
C
          AX2 = 0.5*(X(IP,JP)+X(IO,JP) - X(IP,JO)-X(IO,JO))
          AY2 = 0.5*(Y(IP,JP)+Y(IO,JP) - Y(IP,JO)-Y(IO,JO))
          AN2 = (SX2*AY2 - SY2*AX2)/S2
C
C
C-------- skip first point, since "1" quantities aren't yet available
          IF(I.EQ.ILE) GO TO 506
C
C-------- set du/dy  (y = normal to surface)
          DUDN(I,IS) = YSGN*(Q(IM,JO)+Q(IO,JO))
     &               * (SX1*SY2-SY1*SX2)/(S1*S2*(S1+S2))
C
C-------- set inviscid U
          SXSM = (SX1M*SY2M - SY1M*SX2M)
          SXSP = (SX1P*SY2P - SY1P*SX2P)
          UCORR  =  UTMP*(Q(IM,JO)+Q(IO,JO))*(SXSM-SXSP)/(S1*S2)
          WT1 = 0.5
          WT2 = 0.5
          UINV(I,IS) = WT1*Q(IM,JO) + WT2*Q(IO,JO) + UCORR
     &       - 0.5*(WT1*AN1 + WT2*AN2)*DUDN(I,IS)
C
          UI = UINV(I,IS)
          MSQI = UI*UI / (GM1*(HINF - 0.5*UI*UI))
C
C-------- velocity correction due to BL curvature
          DUI = DUDN(I,IS)*(WXUT*THET(I,IS) + WXUD*DSTR(I,IS))
C
C-------- curvature-corrected BL velocity, density
          UEDG(I,IS) = UINV(I,IS) + DUI
C
C-------- set inviscid Rho
          IF(ISSET.EQ.1) THEN
           RHOI(I,IS) = (WT1*R(IM,JO) + WT2*R(IO,JO))
     &       *(1.0 + (0.5*(WT1*AN1+WT2*AN2)*DUDN(I,IS) - UCORR)*MSQI/UI)
           RHOE(I,IS) = RHOI(I,IS)*(1.0 - MSQI*DUI/UI)
          ELSE
           RHOI(I,IS) = RSTOUT*(1.0-0.5*UINV(I,IS)**2/HINF)**(1.0/GM1)
           RHOE(I,IS) = RSTOUT*(1.0-0.5*UEDG(I,IS)**2/HINF)**(1.0/GM1)
          ENDIF
C
C-------- edge kinematic viscosity
          HSTAT = HINF - 0.5*UEDG(IO,IS)**2
          RMUE = SQRT((HSTAT/HINF)**3)*(HINF+HVIS)/(HSTAT+HVIS)
          VEDG(I,IS) = RMUE/RHOE(I,IS) / MAX( REYN, 1.0 )
C
C---- log10(Rtheta)
          IF(UEDG(I,IS)*THET(I,IS) .GT. 0.0) THEN
           ALRT(I,IS) = LOG10(UEDG(I,IS)*THET(I,IS)/VEDG(I,IS))
          ELSE
           ALRT(I,IS) = 0.
          ENDIF
C
C-------- set kinematic shape parameter
          IF(THET(I,IS).NE.0.) THEN
            H2 = DSTR(I,IS)/THET(I,IS)
            M2 = MSQI
            CALL HKIN( H2, M2, HK2, HK2_H2, HK2_M2 )
          ELSE
            HK2 = 1.0
          ENDIF
          SHAP(I,IS) = HK2
C
C-------- set "1" variables for next loop pass
 506      CONTINUE
          SX1M = SX2M
          SX1P = SX2P
          SY1M = SY2M
          SY1P = SY2P
C
          SX1 = SX2
          SY1 = SY2
          S1  = S2
C
          AX1 = AX2
          AY1 = AY2
          AN1 = AN2
  507   CONTINUE
C
        UEDG(ILE,IS) = 0.0
        DUDN(ILE,IS) = 0.0
        THET(ILE,IS) = THET(ILE+1,IS)
        DSTR(ILE,IS) = DSTR(ILE+1,IS)
        SHAP(ILE,IS) = SHAP(ILE+1,IS)
C
        THET(II,IS) = THET(II-1,IS)
        DSTR(II,IS) = DSTR(II-1,IS)
C
C------ normalize ve and Ue with freestream speed Qinf for surface plots
        DO 509 I=ILE, II
          VEDG(I,IS) = VEDG(I,IS)/QINF
          UEDG(I,IS) = UEDG(I,IS)/QINF
          UINV(I,IS) = UINV(I,IS)/QINF
 509    CONTINUE
 50   CONTINUE
C
C---- set wake parameters
      DO 54 N=1, NBL
        I1 = IS1(N)
        I2 = IS2(N)
        DO 548 I=ITEB(N), II
          TWAK(I,N) = THET(I,I1) + THET(I,I2)
          DWAK(I,N) = DSTR(I,I1) + DSTR(I,I2)
          IF(I.EQ.ITE) DWAK(I,N) = DWAK(I,N) + WGAP(I,N)
          IF(TWAK(I,N) .EQ. 0.0) THEN
           HWAK(I,N) = 1.0
          ELSE
           HW = DWAK(I,N)/TWAK(I,N)
           MSQ = 0.5*(MI(I,I1)**2 + MI(I,I2)**2)
           CALL HKIN( HW, MSQ, HWAK(I,N), HK1_H1, HK1_M1 )
          ENDIF
 548    CONTINUE
 54   CONTINUE
C
      RETURN
      END ! BLINIT
 

      SUBROUTINE INDINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
C----Initialize indices and pointers for element(s)
      DO 10 J = 1, JJ
        JSTAG(J) = 0
   10 CONTINUE
C
C----IS arrays give top(1-odd) and bottom(2-even) side indices for element
C    JS arrays give J line corresponding to side
C    JSTAG links the J lines and the element sides
C                 0 for J line not corresponding to element side
C                -IS1 for top    side on element
C                +IS2 for bottom side on element
C    Note: JSTAG(J)>0 means that the streamline J is between the element grids
C
      DO 20 N = 1, NBL
C
        ILE = NINL(N)
        ITE = II-NOUT(N)+1
        ILEB(N) = ILE
        ITEB(N) = ITE
C
        IS1(N) = 2*(N-1)+1
        IS2(N) = IS1(N)+1
C
        JS1(N) = JBLD(N)
        JS2(N) = JS1(N) - 1
        IF (JS2(N).LT.1) JS2(N) = JJ
C
        JSTAG(JS1(N)) = -IS1(N)
        JSTAG(JS2(N)) =  IS2(N)
C
        JSRF(IS1(N)) = JS1(N)
        JSRF(IS2(N)) = JS2(N)
   20 CONTINUE
C
      RETURN
      END ! INDINI




      SUBROUTINE DEFLIM(N)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C-------------------------------------------------
C     Sets x/c BL plot axis limits for element N
C-------------------------------------------------
C
      ILE = ILEB(N)
      ITE = ITEB(N)
C
      CALL SCALIT(1,XTAIL(N),XNOSE(N),XFAC,ANN,NANN)
      XIDEL(N) = 1.0/(FLOAT(NANN)*XFAC)
      XIMIN(N) = (AINT(XNOSE(N)/XIDEL(N) + 1000.0) - 1000.0)*XIDEL(N)
      XIMAX(N) = (AINT(XTAIL(N)/XIDEL(N) + 1002.0) - 1000.0)*XIDEL(N)
C
      CALL SCALIT(II-ILE,SHAP(ILE+1,IS1(N)),0.0,XFAC1,ANN,NANN1)
      CALL SCALIT(II-ILE,SHAP(ILE+1,IS2(N)),0.0,XFAC2,ANN,NANN2)
      HKMAX(N) = MIN( 1.0/MIN(XFAC1,XFAC2) , 40.0 )
      HKMIN(N) = 0.
      HKDEL(N) = 1.0
      IF(HKMAX(N) .GT. 11.0) HKDEL(N) = 2.0
      IF(HKMAX(N) .GT. 21.0) HKDEL(N) = 5.0
C
      CALL SCALIT(II-ILE,DSTR(ILE+1,IS1(N)),0.0,XFAC1,ANN,NANN1)
      CALL SCALIT(II-ILE,DSTR(ILE+1,IS2(N)),0.0,XFAC2,ANN,NANN2)
      DSMAX(N) = 1.0/XFAC1
      DSMIN(N) = 0.
      DSDEL(N) = DSMAX(N)/FLOAT(NANN1)
      DPMAX(N) = 1.0/XFAC2
      DPMIN(N) = 0.
      DPDEL(N) = DPMAX(N)/FLOAT(NANN2)
C
      CALL SCALIT(ITE-ILE,TAU(ILE+1,IS1(N)),0.0,XFAC1,ANN,NANN1)
      CALL SCALIT(ITE-ILE,TAU(ILE+1,IS2(N)),0.0,XFAC2,ANN,NANN2)
      IF(XFAC1.LT.XFAC2) THEN
       CFMAX(N) = 1.0/XFAC1
       CFMIN(N) = 0.
       CFDEL(N) = CFMAX(N)/FLOAT(NANN1)
      ELSE
       CFMAX(N) = 1.0/XFAC2
       CFMIN(N) = 0.
       CFDEL(N) = CFMAX(N)/FLOAT(NANN2)
      ENDIF
C
      CALL SCALIT(ITE-ILE,UEDG(ILE+1,IS1(N)),0.0,XFAC1,ANN,NANN1)
      CALL SCALIT(ITE-ILE,UEDG(ILE+1,IS2(N)),0.0,XFAC2,ANN,NANN2)
      UEMAX(N) = 1.0/MIN(XFAC1,XFAC2)
      UEMIN(N) = 0.
      UEDEL(N) = 0.5
C
      ACR1 = MAX(1.0,ACRIT)
      CALL SCALIT(1,ACR1,0.0,YFAC,ANN,NANN)
      ANDEL(N) = 1.0/(FLOAT(NANN)*YFAC)
      ANMAX(N) = ANDEL(N)*AINT(ACR1/ANDEL(N) + 0.6)
      ANMIN(N) = 0.
C
      IT1 = MAX(ITRAN(IS1(N)),ILE+1)
      IT2 = MAX(ITRAN(IS2(N)),ILE+1)
      CALL SCALIT(II-IT1,CTAU(IT1,IS1(N)),0.0,XFAC1,ANN,NANN1)
      CALL SCALIT(II-IT2,CTAU(IT2,IS2(N)),0.0,XFAC2,ANN,NANN2)
      IF(XFAC1.LT.XFAC2) THEN
       CTMAX(N) = 1.0/XFAC1
       CTMIN(N) = 0.
       CTDEL(N) = CTMAX(N)/FLOAT(NANN1)
      ELSE
       CTMAX(N) = 1.0/XFAC2
       CTMIN(N) = 0.
       CTDEL(N) = CTMAX(N)/FLOAT(NANN2)
      ENDIF
C
      RTMAX(N) = 5.0
      RTMIN(N) = 1.0
      RTDEL(N) = 1.0
C
      RETURN
      END ! DEFLIM



 
      SUBROUTINE HKIN( H, MSQ, HK, HK_H, HK_MSQ )
      IMPLICIT REAL (A-H,M,O-Z)
C
C---- calculate kinematic shape parameter (assuming air)
C     (from Whitfield )
      HK     = (H - 0.29*MSQ)/(1.0 + 0.113*MSQ)
      HK_H   =  1.0          /(1.0 + 0.113*MSQ)
      HK_MSQ = (-.29 - 0.113*HK) / (1.0 + 0.113*MSQ)
C
      RETURN
      END ! HKIN
 


      SUBROUTINE DPDN(I,IS,DP)
C--------------------------------------------------------------
C     Sets normal pressure gradient at BL station I, side IS.
C     Gradient is positive from wake centerline to outer flow
C      (positive for wake side curving away from outer flow).
C
C     This DPDN version uses displacement streamline curvature.
C--------------------------------------------------------------
C
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      N = (IS+1)/2
      IF(MOD(IS,2).EQ.0) THEN
       J = JS2(N)
       SGN = 1.0
      ELSE
       J = JS1(N)
       SGN = -1.0
      ENDIF
C
      X1 = X(I-1,J)
      X2 = X(I  ,J)
      X3 = X(I+1,J)
      Y1 = Y(I-1,J)
      Y2 = Y(I  ,J)
      Y3 = Y(I+1,J)
C
      SX1 = X2 - X1
      SY1 = Y2 - Y1
      SX2 = X3 - X2
      SY2 = Y3 - Y2
      S1 = SQRT(SX1*SX1 + SY1*SY1)
      S2 = SQRT(SX2*SX2 + SY2*SY2)
      S1INV = 1.0/S1
      S2INV = 1.0/S2
C
C---- set displacement-surface curvature
      CV = SGN*2.0*(SX1*SY2-SY1*SX2)*S1INV*S2INV/(S1+S2)
C
C---- set normal pressure gradient
      DP = RHOI(I,IS)*UINV(I,IS)**2 * CV
C
      RETURN
      END ! DPDN
 
 
 
      SUBROUTINE GETREF(X,Y,N,NX)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(NX), Y(NX)
      CHARACTER*48 FNAME
C
      WRITE(*,*) 'Enter reference solution filename:'
      READ(*,1000) FNAME
 1000 FORMAT(A)
C
      OPEN(UNIT=3,FILE=FNAME,STATUS='OLD',ERR=5)
      GO TO 10
C
    5 WRITE(*,*) '***   File open error   ***'
      CLOSE(UNIT=3)
      RETURN
C
   10 DO 11 I=1, NX
        READ(3,*,END=12,ERR=25) X(I), Y(I)
        IF(X(I).EQ.-999.) GO TO 12
   11 CONTINUE
   12 N = I-1
C
      IF(X(I) .EQ. -999.) THEN
C----- read scale/offset data at end of reference file
       IBEG = 1
       DO 15 ILINE=1, 12345
         READ(3,*,END=19) XOFF, AROT
         COSA = COS(AROT*3.1415926/180.0)
C
         DO 151 I=IBEG, N
           IF(X(I).EQ.999.) GO TO 155
            X(I) = X(I)*COSA + XOFF
 151     CONTINUE
 155     IBEG = I+1
 15    CONTINUE
      ENDIF
C
   19 CLOSE(UNIT=3)
      RETURN
C
   25 WRITE(*,*) '***   File read error   ***'
      CLOSE(UNIT=3)
      RETURN
C
      END ! GETREF



      SUBROUTINE PLTINI(SIZFAC)
      INCLUDE 'STATE.INC'
      INCLUDE 'MPLOT.INC'
C
      IF(LPLOT) CALL PLEND
C
C---- Landscape or Portrait ?
      IF(LLAND) THEN
        SIGNFR =  SCRNFR
      ELSE
        SIGNFR = -SCRNFR
      ENDIF
C
C---- initialize new plot
      CALL PLOPEN(SIGNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL GETWINSIZE(XWIND,YWIND)
C
C---- draw plot page outline offset by margins
      CALL NEWPEN(5)
      IF(XMARG .GT. 0.0) THEN
        CALL PLOTABS(      XMARG,      YMARG,3)
        CALL PLOTABS(      XMARG,YPAGE-YMARG,2)
        CALL PLOTABS(XPAGE-XMARG,      YMARG,3)
        CALL PLOTABS(XPAGE-XMARG,YPAGE-YMARG,2)
      ENDIF
      IF(YMARG .GT. 0.0) THEN
        CALL PLOTABS(      XMARG,      YMARG,3)
        CALL PLOTABS(XPAGE-XMARG,      YMARG,2)
        CALL PLOTABS(      XMARG,YPAGE-YMARG,3)
        CALL PLOTABS(XPAGE-XMARG,YPAGE-YMARG,2)
      ENDIF
      CALL NEWPEN(1)
C
C---- set clipping to inside page outline
      CALL PLOTABS(XMARG,YMARG,-3)
      CALL NEWCLIPABS( XMARG, XPAGE-XMARG, YMARG, YPAGE-YMARG )
C
C---- set requested scale factor
      CALL NEWFACTOR(SIZFAC*SIZE)
C
      RETURN
      END ! PLTINI
