C
      PROGRAM MPOLAR
C.........................................................................
C
C     This is an MSES or MSIS driver which sweeps over a range of angles 
C     of attack of an isolated airfoil, thus generating a polar curve.
C
C     The calculated polar itself is written to two files:
C          POLAR.xxx   (formatted,   unit 4 )
C          POLARX.xxx  (unformatted, unit 11)
C
C     POLAR.xxx contains only the integrated airfoil forces and transition
C     locations.  POLARX.xxx also contains these, plus the surface 
C     pressures and BL parameters as functions of x/c for each point, 
C     and also the airfoil coordinates for pretty-plotting purposes.
C
C     If both of the two files already exist, AND represent the same 
C     airfoil and freestream conditions, then the new points are 
C     appended to them.
C
C     If both of the two files already exist, and DO NOT represent the
C     same airfoil and freestream conditions, then POLAR will terminate
C     without calculating any operating points.  This is to prevent
C     clobbering of any existing polar disk files.
C
C     Normally, MPOLAR tries to converge each specified ALFA value.  
C     If convergence fails or an underrelaxation factor less than RLXMIN
C     appears, then the ALFA increment from the last converged point
C     is cut in half and convergence is attempted for that point.
C
C     Each time a point converges successfully, MDAT.xxx is overwritten
C     with the converged solution.  Hence, if all the following points 
C     bomb, the user can run the following points "manually" with MSES 
C     or MSIS and perhaps figure out why they bombed (massive separation,
C     local Reynolds number too low, not enough dissipation, etc., etc.).
C
C..........................................................................
C
      PARAMETER (NAX=200)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*80 LINE
      LOGICAL LSOLVE, ERROR
      REAL AINPUT(2)
      REAL ALFARR(0:NAX)
      INTEGER KSENS(0:NAX)
      CHARACTER*1 CHRS
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XX(IX,ISX), CP(IX,ISX), CF(IX,ISX), QS(IX), P(IX)
      DIMENSION XX(IX,ISX), CP(IX,ISX), CF(IX,ISX), QS(IX), P(IX)
C
      INCLUDE 'EPS.INC'
C
C---- max number of Newton iterations per point
      INEWT = 20
C
C---- minimum allowable underrelaxation factor (see header above)
      RLXMIN = 0.03
C
C---- degrees to radians factor
      DTOR = 4.0*ATAN(1.0)/180.0
C
      CALL INPUT
      CALL INIT
C
C---- UNIX
      CALL GETARG(1,ARGP1)
      CALL GETARG(2,ARGP2)
C
      IF(INDEX(ARGP2,' ').LE.1) ARGP2 = ARGP1
C
      FNAME3  = 'alfas.'  // ARGP1
      FNAME4  = 'polar.'  // ARGP2
      FNAME11 = 'polarx.' // ARGP2
C
      OPEN(3,FILE=FNAME3,STATUS='OLD',FORM='FORMATTED')
C
C---- VMS
ccc   OPEN(3,STATUS='OLD',FORM='FORMATTED')
C
C---- read in angles of attack...
      DO 10 IA=1, NAX
CCC        READ(3,*,END=11) ALFARR(IA), KSENS(IA)
C
C------ default case is KSENS = 0  (no sensitivity output)
        AINPUT(1) = 999.0
        AINPUT(2) = 0.0
        READ(3,1000,END=11) LINE
 1000   FORMAT(A80)
        NINP = 2
        CALL GETFLT(LINE,AINPUT,NINP,ERROR)
C
C------ exit on blank line
        IF(AINPUT(1) .EQ. 999.0) GO TO 11
C
        ALFARR(IA) = AINPUT(1)
        KSENS(IA) = INT(AINPUT(2))
C
        ALFARR(IA) = ALFARR(IA) * DTOR
 10   CONTINUE
      WRITE(*,*) 'MPOLAR: Array limit reached.  Increase NAX'
C
 11   NA = IA-1
      CLOSE(3)
C
C---- set up listing and dump files
      CALL PINIT(ALAST)
      CALL PXINIT
C
C---- set "zeroth" prescribed alpha for subdividing first interval
      IF(NA.GT.1) ALFARR(0) = 2.0*ALFARR(1) - ALFARR(2)
      IF(NA.EQ.1) ALFARR(0) = ALFARR(1)
C
      IABEG = 1
C
C---- if there are no "old" alphas, go start from beginning of spec. polar
      IF(ALAST.EQ.-999.0) GO TO 24
C
C---- if this is a fresh mdat.xxx, go start from beginning
      IF(ICOUNT.EQ.0) GO TO 24
C
C---- find which alpha to begin sweep at
      ALAST = ALAST * DTOR
      DO 20 IABEG=1, NA
        ALFM = ALFARR(IABEG-1)
        ALFO = ALFARR(IABEG  )
C
C------ current ALFA is nearly same as ALFO, go do ALFO
        IF(ABS(ALFO-ALFA) .LT. EPSM) GO TO 24
C
C------ current ALFA is between ALFO and ALFM, go do ALFO
        SGN = SIGN( 1.0 , ALFO-ALFM )
        IF( SGN*ALFM .LE. SGN*ALFA .AND. 
     &      SGN*ALFO .GT. SGN*ALFA       ) GO TO 24
C
 20   CONTINUE
      IABEG = 1
C
C---- if the last alpha in polar.xxx is same as current ALFA, do next one
 24   IF(ABS(ALAST-ALFA) .LT. EPSM) IABEG = IABEG+1
C
C---- set starting sensitivity dump file point index
      IASENS = 0
      DO 26 IA=1, IABEG-1
        IF(KSENS(IA).NE.0) IASENS = IASENS + 1
 26   CONTINUE
C
      ALFOLD = ALFA
C
C---- confirm
      WRITE(*,*) ' '
      WRITE(*,*) 'Prescribed alphas:'
      DO 28 IA=1, NA
        CHRS = ' '
        IF(KSENS(IA).NE.0) CHRS = 's'
        IF(IA.EQ.IABEG) THEN
         WRITE(*,9005) IA, ALFARR(IA)/DTOR,CHRS,'   (start)', IASENS+1
        ELSE
         WRITE(*,9005) IA, ALFARR(IA)/DTOR,CHRS
        ENDIF
 9005   FORMAT(3X,I3,F9.3,1X,A1, A10, I3)
C
 28   CONTINUE
      WRITE(*,*)
C
      LCONV = .FALSE.
C
C---- loop through angles of attack
      DO 100 IA=IABEG, 12345
C
 30   ALFAIN = ALFARR(IA)
C
      WRITE(*,*)
C
C---- interval-halving loop
      DO 90 ICUT=0, 5
C
      WRITE(*,*) 'Specified alfa: ',ALFAIN/DTOR
C
      LSMOVE = .FALSE.
C
C---- if inverted RHSs exist and ALFA is a global variable, then...
      IF(LCONV .AND. LALFA.NE.0) THEN
C
C----- clear residual-driven changes (should be nearly zero anyway)
       CALL CLRRHS(1)
C
C----- free Newton iteration (!) via existing  d()/dALFA  RHS vector
C-     and new  (ALFAIN - ALFA)  global residual driving term
       CALL UPDATE(.TRUE.)
C
       IF(LSMOVE) CALL SMOVE(-4,AINF,0.4*RHOINF)
      ENDIF
C
C---- set Newton iteration limit
      NITER1 = INEWT
C
C-----allow for 6 extra iterations for first point
      IF(IA.EQ.IABEG) NITER1 = NITER1 + 6
C
C---- Newton iteration loop
      DO 40 ITER=1, NITER1
        NITER = ITER + 1
C
 39     ICOUNT = ICOUNT + 1
C
C------ set up mass fraction arrays
        CALL MFCALC
C
C------ calculate grid movement direction vectors at all grid nodes
        CALL NCALC
C
C------ calculate unit vectors for displacement thickness offsetting
        CALL BLNORM
C
C------ set geometry sensitivities
        CALL GEOSEN
C
C------ set geometric mode shapes
        IF(LMODI .OR. LMINV) THEN
         CALL GNSET
        ENDIF
C
C------ set element position modes and linearize grid spacing arrays
        IF(LPOSI) THEN
         CALL PNSET
         CALL SGLIN
        ENDIF
C
C------ calculate residuals and Jacobian entries at all interior nodes
        CALL SETUP
C
        LVISC = REYNIN.GT.0.0
C
C------ calculate BL residuals & Jacobians, and combine with main system
        IF(LVISC) CALL SETBL
C
C------ calculate BC residuals & Jacobians, and combine with main system
        CALL SETBC
C
C----- solve main Newton system
        CALL SOLVE
        LSOLVE = .TRUE.
C
C------ update all variables and set LSMOVE flag
        CALL UPDATE(.TRUE.)
C
C------ fix up grid if necessary and do at least one more iteration
        IF(LSMOVE) THEN
         CALL SMOVE(-4,AINF,0.4*RHOINF)
         GO TO 40
        ENDIF
C
C------ set convergence flag
        LCONV = DRRMS  .LT. EPSR      .AND.
CCC  &          DNRMS  .LT. EPSN      .AND.
     &          DVRMS  .LT. EPSV      .AND.
     &      ABS(DRMAX) .LT. EPSR*10.0 .AND.
CCC  &      ABS(DNMAX) .LT. EPSN*10.0 .AND.
     &      ABS(DVMAX) .LT. EPSV*10.0
C
C------ check for solution blowing up -- if so, subdivide interval
        IF(RLX.LT.RLXMIN .AND. IA.GT.1) GO TO 41
C
        IF(LCONV) THEN
C
         IF((LMODI.OR.LPOSI) .AND. ITER.LT.NITER .AND.
     &       KSENS(IA).NE.0 .AND. ICUT.EQ.0        ) THEN
C--------- Optimization case: do one more iteration to get sensitivities
C-         (Note: if ITER>=NITER, then SOLVE inverts all righthand sides)
           NITER = ITER
           WRITE(*,*)
           WRITE(*,*) 'Final sensitivity iteration...'
           GO TO 39
         ENDIF
C
C------- we converged for this angle of attack
C
         DO 402 JO=1, JJ-1
           IF(JSTAG(JO).GT.0) GO TO 402
           JP = JO+1
           CALL PICALC(JO, Q(1,JO),QS,P, PI(1,JO),PI(1,JP))
 402     CONTINUE
         CALL LCALC
         CALL DVCALC
         CALL DWCALC
C
         CALL GLOSEN
C
C------- save total sensitivities to unformatted file
         IF((LMODI .OR. LPOSI) .AND. 
     &       KSENS(IA).NE.0    .AND. ICUT.EQ.0) THEN
          IASENS = IASENS + 1
          CALL SNWRIT(IASENS)
         ENDIF
C
         CALL OUTPUT
C
C------- save "last converged alpha" for interval-halving
         ALFOLD = ALFA
C
         CL = LIFT/QU
         CM = MOMN/QU
         CDV = DRAGV/QU
         CDW = DRAGW/QU
         CD = CDW + CDV
         CD_ALFA = CDW_ALFA + CDV_ALFA
         CD_MINF = CDW_MINF + CDV_MINF
C
ccc         IF(ICUT.GT.0) GO TO 30
C
C------- write forces to formatted polar listing file and screen
         WRITE(*,*)
         WRITE(*,*) 'Writing out operating point . . . '
C
CCC      OPEN(4,FILE=FNAME4,STATUS='OLD',FORM='FORMATTED')   ! %%% RS/6000
         OPEN(4,FILE=FNAME4,STATUS='OLD',
     &          FORM='FORMATTED',ACCESS='APPEND')
         WRITE(4,9110) ALFA/DTOR,CL,CD,CDW,CM,
     &                 (XTR(IS),IS=1,2*NBL)
         CLOSE(4)
C
ccc         IF(ICUT.GT.0) GO TO 30
C
         WRITE(*,9100)
         WRITE(*,9110) ALFA/DTOR,CL,CD,CDW,CM,
     &                 (XTR(IS),IS=1,2*NBL)
C
 9100    FORMAT(1X,
     &    '  alpha     CL        CD       CDw       CM   ',
     &    '  XtrTop  XtrBot')
 9110    FORMAT(1X,
     &       F7.3,    F9.4,    F10.5,    F10.5,    F9.4,
     &     8( F9.4 ,  F8.4) )
C
C------- write forces and surface variables to unformatted dump file
CCC      OPEN(11,FILE=FNAME11,STATUS='OLD',FORM='UNFORMATTED') !%%% RS/6000
         OPEN(11,FILE=FNAME11,STATUS='OLD',
     &           FORM='UNFORMATTED',ACCESS='APPEND')
         WRITE(11) ALFA/DTOR,CL,CD,CDW,CM,(XTR(IS),IS=1,2*NBL)
C
C------- for each surface...
         DO 404 IS=1, 2*NBL
           N = (IS+1)/2
C
           IF(MOD(IS,2).EQ.1) THEN
            STOT = SB(1     ,N) - SBLE(N)
            JS = JS1(N)
           ELSE
            STOT = SB(IIB(N),N) - SBLE(N)
            JS = JS2(N)
           ENDIF
C
C--------- ... write out Cp's and BL parameters to unformatted dump file
           DPINF = PINF - PSTOUT
           DO 4045 I=1, II
             IG = I - ILEB(N) + 1
             IF(IG.LT.1) THEN
              XX(I,IS) = X(I,JS)
             ELSE IF(IG.LE.NBLD(N)) THEN
              SS = SBLE(N) + STOT*SG(IG,IS)
              XX(I,IS) = SEVAL(SS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
             ELSE
              IW = I-ITEB(N)+1
              XX(I,IS) = XW(IW,N)
             ENDIF
             CP(I,IS) = (PI(I,JS) - DPINF) / QU
             CF(I,IS) = TAU(I,IS) / QU
 4045      CONTINUE
           WRITE(11) (XX(I,IS),CP(I,IS),THET(I,IS),DSTR(I,IS),
     &                CF(I,IS), CTAU(I,IS), I=1, II)
 404     CONTINUE
         CLOSE(11)
C
         GO TO 98
        ENDIF
C
 40   CONTINUE
      IF(IA.EQ.1) STOP 'POLAR: Failed to converge first point'
C
 41   CONTINUE
C
C-----convergence failed -- subdivide current interval
      WRITE(*,*) 'Halving interval ...'
      ALFAIN = 0.5*(ALFAIN + ALFOLD)
C
C-----re-read old converged solution and try again...
CCC      REWIND 1
      CALL INPUT
C
 90   CONTINUE
C
C---- if repeated halving didn't achieve convergence,
C-    something is screwed up in a major way
      STOP 'MPOLAR: Severe convergence problem detected'
C
 98   CONTINUE
      IF(IA.EQ.NA) STOP
C
C---- if interval was subdivided, keep trying the current alpha
      IF(ICUT.GT.0) GO TO 30
C
 100  CONTINUE
C
      STOP
      END ! MPOLAR


      SUBROUTINE PINIT(ALAST)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*32 NAMEX
      INTEGER MATYPX, RETYPX
      CHARACTER*29 LINE1, LINE2
C
      IMATYP = 1
      IRETYP = 1
      IF(LDEPMA) IMATYP = 2
      IF(LDEPRE) IRETYP = 2
C
      ALAST = -999.0
C
C---- try reading the formatted polar listing file to see if it exists
      OPEN(4,FILE=FNAME4,STATUS='UNKNOWN',FORM='FORMATTED')
      READ(4,1000,ERR=30,END=30) DUMMY
 1000 FORMAT(A4)
C
      WRITE(*,*) 'Will append to existing polar listing file'
C
C---- if we got to here, it exists, so read the name
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1010) NAMEX
 1010 FORMAT(23X,A)
C
C---- check to see if this is the same airfoil
      DO 20 K=1, 32
        IF(NAME(K:K).NE.NAMEX(K:K)) THEN
         WRITE(*,*) 
     &     '*** Existing polar listing file has a different NAME'
         GO TO 21
        ENDIF
   20 CONTINUE
   21 CONTINUE
C
      READ(4,1000) DUMMY
      READ(4,*,ERR=22) RETYPX, MATYPX
      IF(IRETYP .NE. RETYPX) WRITE(*,*)
     & '*** Existing polar listing file has different Re(CL) dependence'
      IF(IMATYP .NE. MATYPX) WRITE(*,*)
     & '*** Existing polar listing file has different  M(CL) dependence'
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
C
C---- set polar listing file pointer at the end
   22 READ(4,*,END=40) ALAST
      GO TO 22
C
C---- write out header to new formatted polar listing file
   30 CONTINUE
      WRITE(4,*) ' '
      WRITE(4,8995) VERSION
 8995 FORMAT(1X,'MSES polar driver   Version', F4.1)
      WRITE(4,*) ' '
      WRITE(4,9000) NAME, NBL
 9000 FORMAT(1X,'Calculated polar for: ', A32, 5X, I2, ' elements')
      WRITE(4,*) ' '
C
      IF(IRETYP.EQ.1) LINE1 = ' Reynolds number fixed       '
      IF(IRETYP.EQ.2) LINE1 = ' Reynolds number ~ 1/sqrt(CL)'
      IF(IRETYP.EQ.3) LINE1 = ' Reynolds number ~ 1/CL      '
      IF(IMATYP.EQ.1) LINE2 = '   Mach number fixed         '
      IF(IMATYP.EQ.2) LINE2 = '   Mach number ~ 1/sqrt(CL)  '
      IF(IMATYP.EQ.3) LINE2 = '   Mach number ~ 1/CL        '
      WRITE(4,9002) IRETYP, IMATYP, LINE1, LINE2
 9002 FORMAT(1X,I1,I2,2A29)
C
      IF(IFFBC.EQ.1)  LINE1 = ' Solid wall far field        '
      IF(IFFBC.EQ.2)  LINE1 = ' Vortex + doublet far field  '
      IF(IFFBC.EQ.3)  LINE1 = ' Constant pressure far field '
      IF(IFFBC.EQ.4)  LINE1 = ' Supersonic wave far field   '
      IF(IFFBC.GE.5)  LINE1 = '                             '
      IF(ISMOM.EQ.1)  LINE2 = '   S-momentum conserved      '
      IF(ISMOM.EQ.2)  LINE2 = '   Entropy conserved         '
      IF(ISMOM.EQ.3)  LINE2 = '   Entropy conserved near LE '
      IF(ISMOM.EQ.4)  LINE2 = '   S-mom conserved at shocks '
      IF(ISMOM.GE.5)  LINE2 = '                             '
      WRITE(4,9006) LINE1, LINE2
 9006 FORMAT(1X,3X,2A29)
C
      WRITE(4,*) ' '
      WRITE(4,9010) MACHIN,REYNIN/1.0E6,ACRIT
 9010 FORMAT(1X,
     &'Mach = ',F7.3,5X,'Re = ',F9.3,' e 6',5X,'Ncrit = ',F7.3)
C
      WRITE(4,*) ' '
      WRITE(4,9020)
     &'  alpha     CL        CD       CDw       CM   ' //
     &'  dCL/da   dCD/da   dCL/dM   dCD/dM ' //
     &'  S xtr   P xtr '
      WRITE(4,9020)
     &' ------- -------- --------- --------- --------' //
     &'  ------  --------  ------  --------' //
     &'  ------  ------'
CCC      3.453   1.3750   0.00921   0.00251  -0.1450 
CCC      0.3245  0.002341  10.234  0.131234
CCC      0.9231  0.5382
 9020 FORMAT(1X,A)
C
   40 CONTINUE
      CLOSE(4)
      RETURN
      END ! PINIT


      SUBROUTINE PXINIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*32 NAMEX
      INTEGER MATYPX, RETYPX
      INTEGER ILEX(NBX), ITEX(NBX), IIBX(NBX)
C
      IMATYP = 1
      IRETYP = 1
      IF(LDEPMA) IMATYP = 2
      IF(LDEPRE) IRETYP = 2
C
C---- try reading the unformatted polar dump file to see if it exists
      OPEN(11,FILE=FNAME11,STATUS='UNKNOWN',FORM='UNFORMATTED')
      READ(11,ERR=56,END=56) NAMEX
C
      WRITE(*,*) 'Will append to existing polar dump file'
C
C---- if we got to here, it exists, so read the header
      READ(11) MACHX, REYNX, ACRITX
      READ(11) MATYPX, RETYPX
      READ(11) NBLX, IIX
      READ(11) (ILEX(N), ITEX(N), IIBX(N), N=1, NBLX)
C
C---- check to see if this is the same case
      DO 50 K=1, 32
        IF(NAME(K:K).NE.NAMEX(K:K)) THEN
         WRITE(*,*) 
     &     'WARNING: Existing polar dump file has a different NAME'
         GO TO 51
        ENDIF
   50 CONTINUE
   51 CONTINUE
C
      IF(MACHIN.NE.MACHX) WRITE(*,*) 
     & '*** Existing polar dump file has a different Mach number'
      IF(REYNIN/1.0E6.NE.REYNX) WRITE(*,*) 
     & '*** Existing polar dump file has a different Reynolds number'
      IF(ACRIT.NE.ACRITX) WRITE(*,*) 
     & '*** Existing polar dump file has a different Ncrit'
      IF(IRETYP .NE. RETYPX) WRITE(*,*)
     & '*** Existing polar listing file has different Re(CL) dependence'
      IF(IMATYP .NE. MATYPX) WRITE(*,*)
     & '*** Existing polar listing file has different M(CL) dependence'
      IF(II.NE.IIX)
     & STOP 'Existing polar dump file has a different grid i-size'
      DO 53 N=1, NBLX
        IF(ILEB(N).NE.ILEX(N) .OR. ITEB(N).NE.ITEX(N))
     & STOP 'Existing polar dump file has different LE or TE grid index'
   53 CONTINUE
C
C---- set polar dump file pointer at the end
   55 READ(11,END=60) DUMMY
      GO TO 55
C
C
C---- the polar dump file doesn't exist, so write new header
   56 CONTINUE
      WRITE(11) NAME, ' MSES   ', VERSION
      WRITE(11) MACHIN, REYNIN/1.0E6, ACRIT
      WRITE(11) IMATYP, IRETYP
      WRITE(11) NBL, II
      WRITE(11) (ILEB(N), ITEB(N), IIB(N), N=1, NBL)
      DO 59 N=1, NBL
        WRITE(11) (XB(IB,N), YB(IB,N), IB=1, IIB(N))
   59 CONTINUE
C
   60 CONTINUE
C
      CLOSE(11)
      RETURN
      END ! PXINIT

 
 
      SUBROUTINE CLRRHS(L)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      DO 1 I=1, II
        DO 10 J=1, 2*JJ-1+6*NBL
          DR(J,L,I) = 0.
   10   CONTINUE
    1 CONTINUE
C
      RETURN
      END ! CLRRHS



      SUBROUTINE SHORES(LUN)
C-----------------------------------------------
C     Dumps residuals to unit LUN in an 
C     organized fashion for debugging purposes.
C-----------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      N = 1
C
      ILE = ILEB(N)
      ITE = ITEB(N)
C
c      WT = 1000.0
c      DO 5 I=ITE, II-1
c        WRITE(LUN,*) ' '
c        WRITE(LUN,1000) 
c     &   I, WT*THET(I,1),WT*DSTR(I,1),WT*DISP(I,1),UEDG(I,1)
c        WRITE(LUN,1000) 
c     &   I, WT*THET(I,2),WT*DSTR(I,2),WT*DISP(I,2),UEDG(I,2)
c 1000   FORMAT(1X,I4, 5F13.8)
c    5 CONTINUE
C
      WRITE(LUN,*) ' '
      WRITE(LUN,*) ILE, ITE
      DO 10 I=1, II
CCC        IF(I.LT.ILE-1) GO TO 10
CCC        IF(I.GT.ILE+1 .AND. I.LT.ITE-3) GO TO 10
c        itr = itran(1)
c        if(.not.(i.ge.ile-3 .and. i.le.ile+3) .and.
c     &     .not.(i.ge.itr-3 .and. i.le.itr+3)) go to 10

        WRITE(LUN,*)
c        A8(JJ,I) = 1.0
        L = 5
        DO 100 J=1, JJ
          anorm = max( abs(a2(j,i))
     &               , abs(b2(j,i))
     &               , abs(c2(j,i)) )
          WRITE(LUN,1010) I,J, DR(J,L,I), DR(J+JJ,L,I)
cc     &            , q(i,j)/qstar
 1010     FORMAT(1X,2I4,2f14.7, 2E12.4, 2x, f7.3)
c          write(*,1010) i, j, a2(j,i), a8(j,i), dr(j,1,i)
c
c          WRITE(*,*) I,J, DR(J,4,I), DR(J,5,I)
c 1012     FORMAT(1x,2I4,2e13.4)
  100   CONTINUE
c        J = JS1(N)
c        WRITE(LUN,*) J+2, I, A2(J+2,I), DR(J+2,1,I), DR(J+2+JJ,1,I)
c        WRITE(LUN,*) J+1, I, A2(J+1,I), DR(J+1,1,I), DR(J+1+JJ,1,I)
c        WRITE(LUN,*) J  , I, A2(J  ,I), DR(J  ,1,I), DR(J  +JJ,1,I)
c        J = JS2(N)
c        WRITE(LUN,*) J  , I, A2(J  ,I), DR(J  ,1,I), DR(J-1+JJ,1,I)
c        WRITE(LUN,*) J-1, I, A2(J-1,I), DR(J-1,1,I), DR(J-2+JJ,1,I)
c        WRITE(LUN,*) J-2, I, A2(J-2,I), DR(J-2,1,I), DR(J-3+JJ,1,I)
        do n=1, nbl
        IS = 2*N-1
        WRITE(LUN,1110) I,DR(2*JJ  ,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+1,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+2,L,I)
        IS = 2*N          
        WRITE(LUN,1110) I,DR(2*JJ+3,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+4,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+5,L,I)
 1110   FORMAT(1X,I4,F14.3,E13.4)
        enddo
c
c        is = 0
c        DO 110 J=2*JJ, 2*JJ+6*NBL-3, 3
c          is = is+1
c          shp = 0.0
c          if(thet(i,is) .ne. 0.0) shp = dstr(i,is)/thet(i,is)
c          WRITE(LUN,1210) i, DR(J,1,I),DR(J+1,1,I),DR(J+2,1,I)
c 1210     FORMAT(1X, I4, 3f14.7, 3E12.4, 2x, f8.4)
c  110   CONTINUE
c
   10 CONTINUE
C
      RETURN
      END
