C
      PROGRAM MPOLARM
C.........................................................................
C
C     This is an MSES or MSIS driver which sweeps over a range of Mach
C     numbers for an isolated airfoil, thus generating a Mach-sweep curve.
C
C     The calculated sweep itself is written to two files:
C          MSWEEP.xxx   (formatted,   unit 4 )
C          MSWEEPX.xxx  (unformatted, unit 11)
C
C     MSWEEP.xxx contains only the integrated airfoil forces and 
C     transition locations.  MSWEEPX.xxx also contains these, 
C     plus the surface pressures and BL parameters as functions 
C     of x/c for each point, and also the airfoil coordinates 
C     for pretty-plotting purposes.
C
C     If both of the two files already exist, AND represent the 
C     same airfoil, CL or alpha, and Reynolds number, then the 
C     new points are appended to them.
C
C     If both of the two files already exist, and DO NOT represent the
C     same airfoil and conditions, then POLARM will terminate without 
C     calculating any operating points.  This is to prevent clobbering 
C     of any existing polar disk files.
C
C     Normally, POLARM tries to converge with each specified Ma value.  
C     If convergence fails or an underrelaxation factor less than RLXMIN
C     appears, then the Ma increment from the last-converged point
C     is cut in half and convergence is attempted for that point.
C
C     If DALFA (no. 4) is chosen as a global variable, then either a 
C     prescribed-alpha condition (5), or the prescribed-CL condition (6) 
C     can be specified as the corresponding global constraint.  Mach
C     sweeps with CL fixed (6) are probably most useful.
C
C
C     Each time a point converges successfully, MDAT.xxx is overwritten
C     with the converged solution.  Hence, if all the following points 
C     bomb, the user can run the following points "manually" with MSES 
C     or MSIS and perhaps figure out why they bombed (massive separation,
C     local Reynolds number too low, not enough dissipation, etc., etc.).
C..........................................................................
C
      PARAMETER (NAX=200)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*80 LINE
      LOGICAL LSOLVE, ERROR
      REAL AINPUT(2)
      REAL MACARR(0:NAX)
      INTEGER KSENS(0:NAX)
      CHARACTER*1 CHRS
C
C---- overlay temporary storage to save space
ccc      COMMON/WORK/ XX(IX,ISX), CP(IX,ISX), CF(IX,ISX), QS(IX), P(IX)
      DIMENSION XX(IX,ISX), CP(IX,ISX), CF(IX,ISX), QS(IX), P(IX)
C
      INCLUDE 'EPS.INC'
C
C---- max number of Newton iterations per point
      INEWT = 20
C
C---- minimum allowable underrelaxation factor (see header above)
      RLXMIN = 0.03
C
C---- degrees to radians factor
      DTOR = 4.0*ATAN(1.0)/180.0
C
      CALL INPUT
C
C---- save current Mach number (it may be changed by INIT).
      MCURR = MINF
C
      CALL INIT
C
C---- UNIX
      CALL GETARG(1,ARGP1)
      CALL GETARG(2,ARGP2)
C
      IF(INDEX(ARGP2,' ').LE.1) ARGP2 = ARGP1
C
      FNAME3  = 'machs.'   // ARGP1
      FNAME4  = 'msweep.'  // ARGP2
      FNAME11 = 'msweepx.' // ARGP2
C
      OPEN(3,FILE=FNAME3,STATUS='OLD',FORM='FORMATTED')
C
C---- VMS
ccc   OPEN(3,STATUS='OLD',FORM='FORMATTED')
C
C---- read in Mach numbers
      DO 10 IA=1, NAX
CCC        READ(3,*,END=11) MACARR(IA), KSENS(IA)
C
C------ default case is KSENS = 0  (no sensitivity output)
        AINPUT(1) = 999.0
        AINPUT(2) = 0.0
        READ(3,1000,END=11) LINE
 1000   FORMAT(A80)
        NINP = 2
        CALL GETFLT(LINE,AINPUT,NINP,ERROR)
C
C------ exit on blank line
        IF(AINPUT(1) .EQ. 999.0) GO TO 11
C
        MACARR(IA) = AINPUT(1)
        KSENS(IA) = INT(AINPUT(2))
C
 10   CONTINUE
      WRITE(*,*) 'MPOLARM: Array limit reached.  Increase NAX'
C
 11   NA = IA-1
      CLOSE(3)
C
C---- set up listing and dump files
      CALL PINIT(MLAST)
      CALL PXINIT
C
C---- set "zeroth" prescribed Mach for subdividing first interval
      IF(NA.GT.1) MACARR(0) = 2.0*MACARR(1) - MACARR(2)
      IF(NA.EQ.1) MACARR(0) = MACARR(1)
C
      IABEG = 1
C
C---- if there are no "old" Machs, go start from beginning of spec. sweep
      IF(MLAST.EQ.0.0) GO TO 24
C
C---- if this is a fresh mdat.xxx, go start from beginning
      IF(ICOUNT.EQ.0) GO TO 24
C
C---- find which Mach to start at
      DO 20 IABEG=1, NA
        MACM = MACARR(IABEG-1)
        MACO = MACARR(IABEG  )
C
C------ current Mach is nearly same as MACO, go do MACO
        IF(ABS(MACO-MCURR) .LT. EPSM) GO TO 24
C
C------ current MINF is between MACO and MACM, go do MACO
        SGN = SIGN( 1.0 , MACO-MACM )
        IF( SGN*MACM .LE. SGN*MCURR .AND. 
     &      SGN*MACO .GT. SGN*MCURR       ) GO TO 24
C
 20   CONTINUE
      IABEG = 1
C
C---- if the last Mach in msweep.xxx is same as current MINF, do next one
 24   IF(ABS(MLAST-MCURR) .LT. EPSM) IABEG = IABEG+1
C
C---- set starting sensitivity dump file point index
      IASENS = 0
      DO 26 IA=1, IABEG-1
        IF(KSENS(IA).NE.0) IASENS = IASENS + 1
 26   CONTINUE
C
      MACOLD = MCURR
C
C---- confirm sweep
      WRITE(*,*) ' '
      WRITE(*,*) 'Prescribed Mach numbers:'
      DO 28 IA=1, NA
        CHRS = ' '
        IF(KSENS(IA).NE.0) CHRS = 's'
        IF(IA.EQ.IABEG) THEN
         WRITE(*,9005) IA, MACARR(IA),CHRS, '   (start)', IASENS+1
        ELSE
         WRITE(*,9005) IA, MACARR(IA),CHRS
        ENDIF
 9005   FORMAT(3X,I3,F10.4,1X, A1, A10, I3)
C
 28   CONTINUE
      WRITE(*,*)
C
C
      LCONV = .FALSE.
C
C---- loop through Mach numbers
      DO 100 IA=IABEG, 12345
C
  30  MACHIN = MACARR(IA)
C
      WRITE(*,*)
C
C---- interval-halving loop
      DO 90 ICUT=0, 5
C
      WRITE(*,*) 'Specified Mach: ', MACHIN
C
C
      IF(LCONV .AND. LMASS.NE.0) THEN
C
C----- predictor for new MACHIN via the existing  d( )/dMASS RHS vector
       CALL CLRRHS(1)        !!! not strictly necessary, but can't hurt
       CALL UPDATE(.TRUE.)   !!! free Newton iteration (!)
       IF(LSMOVE) CALL SMOVE(-4,AINF,0.4*RHOINF)
C
      ELSE
C
C----- set freestream Mach number if it's not a global variable
       IF(ICOUNT.EQ.0 .OR. LMASS.EQ.0) MINF = MACHIN
C
       IF(ICOUNT.EQ.0 .AND. LDEPMA) THEN
C------ use CLIFIN for better initial guess if Mach is CL-dependent
        IF(CLIFIN.GT.0.0) MINF = MACHIN/SQRT(CLIFIN)
        WRITE(*,*) ' '
        WRITE(*,*) 'Freestream Mach initialized to', MINF
       ENDIF
C
C----- set all freestream variables from freestream Mach number
       CALL FFCALC
C
       MASSIN = RHOINF*QINF*AINF
C
C----- if total mass is not a global variable, then set it explicitly
       IF(ICOUNT.EQ.0 .OR. LMASS.EQ.0) MASS = MASSIN
C
C----- initialize stagnation-condition Reynolds number
       IF(ICOUNT.EQ.0 .OR. REYN.EQ.0.0 .OR. LREYN.EQ.0)
     &    REYN = REYNIN/(RHOINF*QINF/MUINF)
C
       IF((ICOUNT.EQ.0 .OR. REYN.EQ.0.0) .AND. LDEPRE) THEN
C------ use CLIFIN for better initial guess if Re is CL-dependent
        IF(CLIFIN.GT.0.0) REYN = REYNIN/(RHOINF*QINF/MUINF)/SQRT(CLIFIN)
        WRITE(*,*) ' '
        WRITE(*,*) 'Reynolds number initialized to', REYNIN/SQRT(CLIFIN)
       ENDIF
C
       DO 35 J=1, JJ-1
         M(J) = MASS * MFRACT(J)
 35    CONTINUE
C
      ENDIF
C
C
C---- set Newton iteration limit
      NITER1 = INEWT
C
C-----allow for 6 extra iterations for first point
      IF(IA.EQ.IABEG) NITER1 = NITER1 + 6
C
C---- Newton iteration loop
      DO 40 ITER=1, NITER1
        NITER = ITER + 1
C
 39     ICOUNT = ICOUNT + 1
C
C------ set up mass fraction arrays
        CALL MFCALC
C
C------ calculate grid movement direction vectors at all grid nodes
        CALL NCALC
C
C------ calculate unit vectors for displacement thickness offsetting
        CALL BLNORM
C
C------ set geometry sensitivities
        CALL GEOSEN
C
C------ set geometric shape modes
        IF(LMODI .OR. LMINV) THEN
         CALL GNSET
        ENDIF
C
C------ set element position modes and linearize grid spacing arrays
        IF(LPOSI) THEN
         CALL PNSET
         CALL SGLIN
        ENDIF
C
C------ calculate residuals and Jacobian entries at all interior nodes
        CALL SETUP
C
        LVISC = REYNIN.GT.0.0
C
C------ calculate BL residuals & Jacobians, and combine with main system
        IF(LVISC) CALL SETBL
C
C------ calculate BC residuals & Jacobians, and combine with main system
        CALL SETBC
C
C------ solve main Newton system
        CALL SOLVE
        LSOLVE = .TRUE.
C
C------ update all variables
        CALL UPDATE(.TRUE.)
C
C------ fix up grid if necessary and do at least one more iteration
        IF(LSMOVE) THEN
         CALL SMOVE(-4,AINF,0.4*RHOINF)
         GO TO 40
        ENDIF
C
C------ set convergence flag
        LCONV = DRRMS  .LT. EPSR      .AND.
CCC  &          DNRMS  .LT. EPSN      .AND.
     &          DVRMS  .LT. EPSV      .AND.
     &      ABS(DRMAX) .LT. EPSR*10.0 .AND.
CCC  &      ABS(DNMAX) .LT. EPSN*10.0 .AND.
     &      ABS(DVMAX) .LT. EPSV*10.0
C
C------ check for solution blowing up -- if so, subdivide interval
        IF(RLX.LT.RLXMIN .AND. IA.GT.1) GO TO 41
C
        IF(LCONV) THEN
C
         IF((LMODI.OR.LPOSI) .AND. ITER.LT.NITER .AND.
     &       KSENS(IA).NE.0 .AND. ICUT.EQ.0        ) THEN
C--------- Optimization case: do one more iteration to get sensitivities
C-         (Note: if ITER>=NITER, then SOLVE inverts all righthand sides)
           NITER = ITER
           WRITE(*,*)
           WRITE(*,*) 'Final sensitivity iteration...'
           GO TO 39
         ENDIF
C
C------- we converged for this angle of attack
C
         DO 402 JO=1, JJ-1
           IF(JSTAG(JO).GT.0) GO TO 402
           JP = JO+1
           CALL PICALC(JO, Q(1,JO),QS,P, PI(1,JO),PI(1,JP))
 402     CONTINUE
         CALL LCALC
         CALL DVCALC
         CALL DWCALC
C
         CALL GLOSEN
C
C------- save total sensitivities to unformatted file
         IF((LMODI .OR. LPOSI) .AND. 
     &       KSENS(IA).NE.0    .AND. ICUT.EQ.0) THEN
          IASENS = IASENS + 1
          CALL SNWRIT(IASENS)
         ENDIF
C
         CALL OUTPUT
C
C------- save "last converged Mach" for interval-halving
         MACOLD = MINF
C
         CL = LIFT/QU
         CM = MOMN/QU
         CDV = DRAGV/QU
         CDW = DRAGW/QU
         CDF = DRAGF/QU
         CD = CDW + CDV
         CD_ALFA = CDW_ALFA + CDV_ALFA
         CD_MINF = CDW_MINF + CDV_MINF
         CDP = CD - CDF
         CDP_ALFA = CD_ALFA - CDF_ALFA
         CDP_MINF = CD_MINF - CDF_MINF
C
ccc         IF(ICUT.GT.0) GO TO 30
C
C------- write integrated forces to formatted listing file and screen
         WRITE(*,*)
         WRITE(*,*) 'Writing out operating point . . . '
CCC      OPEN(4,FILE=FNAME4,STATUS='OLD',FORM='FORMATTED')   !%%% RS/6000
         OPEN(4,FILE=FNAME4,STATUS='OLD',
     &          FORM='FORMATTED',ACCESS='APPEND')
c         WRITE(4,9110) MINF,ALFA/DTOR,CL,CD,CDW,CM,
c     &                  CL_ALFA*PIE/180.0, CD_ALFA*PIE/180.0,
c     &                  CL_MINF,CD_MINF,
c     &                 (XTR(IS),IS=1,2*NBL)

ccc         WRITE(4,9111) MINF,ALFA/DTOR,CL,CDF,CDP,CM,
         WRITE(4,9111) MINF,ALFA/DTOR,CL,CD,CDW,CM,
     &      CL_ALFA*PIE/180.0, CD_ALFA*PIE/180.0,
     &      CL_MINF          , CD_MINF
C
ccc     &  '  dCL/da   dCDf/da   dCDp/da  dCL/dM   dCDf/dM   dCDp/dM '
         CLOSE(4)
C
         WRITE(*,9100)
         WRITE(*,9110) MINF,ALFA/DTOR,CL,CD,CDW,CM,
     &                 (XTR(IS),IS=1,2*NBL)
 9100    FORMAT(1X,
     &    '  Mach   alpha     CL        CD       CDw       CM   ',
     &    '   dCL/da    dCD/da    dCL/dM    dCD/dM ',
     &    '  S xtr   P xtr ')
 9110    FORMAT(1X,
     &       F7.4,  F7.3,    F9.4,    F10.5,    F10.5,    F9.4,
     &       F10.4,   F11.6,   F9.3,    F11.6,
     &     8( F9.4 ,  F8.4) )
 9111    FORMAT(1X,
     &       F7.4,  F7.3,    F9.4,    F10.5,    F10.5,    F9.4,
     &       F10.4,   F11.6,   F9.3,    F11.6,    F10.6,   F10.6 )
C
ccc         IF(ICUT.GT.0) GO TO 30
C
C------- write integrated forces to unformatted dump file
CCC      OPEN(11,FILE=FNAME11,STATUS='OLD',FORM='UNFORMATTED') !%%% RS/6000
         OPEN(11,FILE=FNAME11,STATUS='OLD',
     &           FORM='UNFORMATTED',ACCESS='APPEND')
         WRITE(11) ALFA/DTOR,CL,CD,CDW,CM,(XTR(IS),IS=1,2*NBL),MINF
C
C------- for each surface...
         DO 404 IS=1, 2*NBL
           N = (IS+1)/2
C
           IF(MOD(IS,2).EQ.1) THEN
            STOT = SB(1     ,N) - SBLE(N)
            JS = JS1(N)
           ELSE
            STOT = SB(IIB(N),N) - SBLE(N)
            JS = JS2(N)
           ENDIF
C
C--------- ... write out Cp's and BL parameters to unformatted dump file
           DPINF = PINF - PSTOUT
           DO 4045 I=1, II
             IG = I - ILEB(N) + 1
             IF(IG.LT.1) THEN
              XX(I,IS) = X(I,JS)
             ELSE IF(IG.LE.NBLD(N)) THEN
              SS = SBLE(N) + STOT*SG(IG,IS)
              XX(I,IS) = SEVAL(SS,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
             ELSE
              IW = I-ITEB(N)+1
              XX(I,IS) = XW(IW,N)
             ENDIF
             CP(I,IS) = (PI(I,JS) - DPINF) / QU
             CF(I,IS) = TAU(I,IS) / QU
 4045      CONTINUE
           WRITE(11) (XX(I,IS),CP(I,IS),THET(I,IS),DSTR(I,IS),
     &                CF(I,IS), CTAU(I,IS), I=1, II)
 404     CONTINUE
         CLOSE(11)
C
         GO TO 98
        ENDIF
C
 40   CONTINUE
      IF(IA.EQ.1) STOP 'MPOLARM: Failed to converge first point'
C
 41   CONTINUE
C
C-----convergence failed -- subdivide current interval
      WRITE(*,*) 'Halving interval ...'
      MACHIN = 0.5*(MACHIN + MACOLD)
C
C---- re-read old converged solution and try again...
CCC      REWIND 1
      CALL INPUT
C
 90   CONTINUE
C
C---- if repeated halving didn't achieve convergence,
C-    something is screwed up in a major way
      STOP 'MPOLARM: Severe convergence problem detected'
C
 98   CONTINUE
      IF(IA.EQ.NA) STOP
C
C---- if interval was subdivided, keep trying the current Mach
      IF(ICUT.GT.0) GO TO 30
C
 100  CONTINUE
C
      STOP
      END ! MPOLARM


      SUBROUTINE PINIT(MLAST)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*32 NAMEX
      INTEGER MATYPX, RETYPX
      CHARACTER*29 LINE1, LINE2
C
      IMATYP = 1
      IRETYP = 1
ccc      IF(LDEPMA) IMATYP = 2
ccc      IF(LDEPRE) IRETYP = 2
C
      MLAST = 0.0
C
C---- try reading the formatted polar listing file to see if it exists
      OPEN(4,FILE=FNAME4,STATUS='UNKNOWN')
      READ(4,1000,ERR=30,END=30) DUMMY
 1000 FORMAT(A4)
C
      WRITE(*,*) 'Will append to existing sweep listing file'
C
C---- if we got to here, it exists, so read the name
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1010) NAMEX
 1010 FORMAT(23X,A)
C
C---- check to see if this is the same airfoil
      DO 20 K=1, 32
        IF(NAME(K:K).NE.NAMEX(K:K))
     &   STOP 'PINIT: Existing sweep listing file has a different NAME'
   20 CONTINUE
C
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
      READ(4,1000) DUMMY
C
C---- read Mach numbers and set polar listing file pointer at the end
   22 READ(4,*,END=40) MLAST
      GO TO 22
C
C---- write out header to new formatted polar listing file
   30 CONTINUE
      WRITE(4,*) ' '
      WRITE(4,8995) VERSION
 8995 FORMAT(1X,'MSES sweep driver   Version', F4.1)
      WRITE(4,*) ' '
      WRITE(4,9000) NAME, NBL
 9000 FORMAT(1X,'Calculated sweep for: ', A32, 5X, I2, ' elements')
      WRITE(4,*) ' '
C
      IF(IRETYP.EQ.1) LINE1 = ' Reynolds number fixed       '
      IF(IRETYP.EQ.2) LINE1 = ' Reynolds number ~ 1/sqrt(CL)'
      IF(IRETYP.EQ.3) LINE1 = ' Reynolds number ~ 1/CL      '
CCC      IF(IMATYP.EQ.1) LINE2 = '   Mach number fixed         '
CCC      IF(IMATYP.EQ.2) LINE2 = '   Mach number ~ 1/sqrt(CL)  '
CCC      IF(IMATYP.EQ.3) LINE2 = '   Mach number ~ 1/CL        '
CCC      WRITE(4,9002) IRETYP, IMATYP, LINE1, LINE2
      WRITE(4,9002) IRETYP, IMATYP, LINE1
 9002 FORMAT(1X,I1,I2,2A29)
C
      IF(IFFBC.EQ.1)  LINE1 = ' Solid wall far field        '
      IF(IFFBC.EQ.2)  LINE1 = ' Vortex + doublet far field  '
      IF(IFFBC.EQ.3)  LINE1 = ' Constant pressure far field '
      IF(IFFBC.EQ.4)  LINE1 = ' Supersonic wave far field   '
      IF(IFFBC.GE.5)  LINE1 = '                             '
      IF(ISMOM.EQ.1)  LINE2 = '   S-momentum conserved      '
      IF(ISMOM.EQ.2)  LINE2 = '   Entropy conserved         '
      IF(ISMOM.EQ.3)  LINE2 = '   Entropy conserved near LE '
      IF(ISMOM.EQ.4)  LINE2 = '   S-mom conserved at shocks '
      IF(ISMOM.GE.5)  LINE2 = '                             '
      WRITE(4,9006) LINE1, LINE2
 9006 FORMAT(1X,3X,2A29)
C
      WRITE(4,*) ' '
      WRITE(4,9010) REYNIN/1.0E6,ACRIT
 9010 FORMAT(1X,'Re = ',F9.3,' e 6',5X,'Ncrit = ',F7.3)
C
      WRITE(4,*) ' '
      WRITE(4,9020)
     &'  Mach   alpha     CL        CD       CDw       CM   ' //
     &'   dCL/da    dCD/da    dCL/dM    dCD/dM ' //
     &'  S xtr   P xtr '
      WRITE(4,9020)
     &  ' ------ ------- -------- --------- --------- --------' //
     &  '  -------  ---------  -------  ---------' //
     &  '  ------  ------'
c
c      WRITE(4,9020)
c     &  '  Mach   alpha     CL        CDf      CDp       CM   ' //
c     &  '  dCL/da   dCDf/da   dCDp/da  dCL/dM   dCDf/dM   dCDp/dM '
c      WRITE(4,9020)
c     &  ' ------ ------- -------- --------- --------- --------' //
c     &  '  ------  --------  --------  ------  --------  --------'
CCC     0.8750  3.453   1.3750   0.00921   0.00251  -0.1450 
CCC      0.3245  0.002341  10.234  0.131234
 9020 FORMAT(1X,A)
C
   40 CONTINUE
      CLOSE(4)
      RETURN
      END ! PINIT


      SUBROUTINE PXINIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      CHARACTER*80 FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
      COMMON/FNAM/ FNAME3, FNAME4, FNAME11, ARGP1, ARGP2
C
      CHARACTER*32 NAMEX
      INTEGER MATYPX, RETYPX
      INTEGER ILEX(NBX), ITEX(NBX), IIBX(NBX)
C
      IMATYP = 1
      IRETYP = 1
      IF(LDEPMA) IMATYP = 2
      IF(LDEPRE) IRETYP = 2
C
C---- try reading the unformatted polar dump file to see if it exists
      OPEN(11,FILE=FNAME11,STATUS='UNKNOWN',FORM='UNFORMATTED')
      READ(11,ERR=56,END=56) NAMEX
C
      WRITE(*,*) 'Will append to existing polar dump file'
C
C---- if we got to here, it exists, so read the header
      READ(11) MACHX, REYNX, ACRITX
      READ(11) MATYPX, RETYPX
      READ(11) NBLX, IIX
      READ(11) (ILEX(N), ITEX(N), IIBX(N), N=1, NBLX)
C
C---- check to see if this is the same case
      DO 50 K=1, 32
        IF(NAME(K:K).NE.NAMEX(K:K)) THEN
         WRITE(*,*) 
     &     'WARNING: Existing polar dump file has a different NAME'
         GO TO 51
        ENDIF
   50 CONTINUE
   51 CONTINUE
C
      IF(0.0 .NE.MACHX)
     & STOP 'Existing dump file not a Mach sweep file (polar file?)'
      IF(REYNIN/1.0E6.NE.REYNX)
     & STOP 'Existing sweep dump file has a different Reynolds number'
      IF(ACRIT.NE.ACRITX)
     & STOP 'Existing sweep dump file has a different Acrit'
      IF(II.NE.IIX)
     & STOP 'Existing sweep dump file has a different grid i-size'
      DO 53 N=1, NBLX
        IF(ILEB(N).NE.ILEX(N) .OR. ITEB(N).NE.ITEX(N))
     & STOP 'Existing sweep dump file has different LE or TE grid index'
   53 CONTINUE
C
C---- set polar dump file pointer at the end
   55 READ(11,END=60) DUMMY
      GO TO 55
C
C
C---- the polar dump file doesn't exist, so write new header
   56 CONTINUE
      WRITE(11) NAME, ' MSES   ', VERSION
      WRITE(11) 0.0, REYNIN/1.0E6, ACRIT
      WRITE(11) IMATYP, IRETYP
      WRITE(11) NBL, II
      WRITE(11) (ILEB(N), ITEB(N), IIB(N), N=1, NBL)
      DO 59 N=1, NBL
        WRITE(11) (XB(IB,N), YB(IB,N), IB=1, IIB(N))
   59 CONTINUE
C
   60 CONTINUE
C
      CLOSE(11)
      RETURN
      END ! PXINIT

 
 
      SUBROUTINE CLRRHS(L)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      DO 1 I=1, II
        DO 10 J=1, 2*JJ-1+6*NBL
          DR(J,L,I) = 0.
   10   CONTINUE
    1 CONTINUE
C
      RETURN
      END ! CLRRHS
