C
      SUBROUTINE MRCHUE
C...................................................
C     Marches the BLs and wake in direct mode using
C     the UEDG array. If separation is encountered,
C     a plausible value of Hk extrapolated from
C     upstream is prescribed instead.  Continuous
C     checking of transition onset is performed.
C...................................................
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
ccc      common /yy/ tyy(nex), uyy(nex), us(nex), ce(nex)
      LOGICAL LACC
C
c###
      DATA BLEPS / 1.0E-5 /
c      DATA BLEPS / 1.0D-12 /
C
c---- set side for diagnostics
      isbug = 0
C
C---- shape parameters for separation criteria
      HLMAX = 3.8
      HTMAX = 2.5
C
C---- minimum shape parameters
      HLMIN = 2.0
      HTMIN = 1.1
C
C---- initialize similarity station with Thwaites' formula
      DO 3 IS=1, 2*NBL
        N = (IS+1)/2
        I = ILEB(N)+1
C
        XSI = XI(I,IS)
        UEI = UEDG(I,IS)
        MSQ = UEI*UEI / (GM1BL*(HSTBL-0.5*UEI*UEI))
        HKI = 2.3
        HI  = HKI*(1.0 + 0.2825*GM1BL*MSQ)  +  0.725*GM1BL*MSQ
C
cc        UCON = UEI/XSI**BULE(IS)
cc        TSQ = 0.45/(UCON*(5.0*BULE(IS)+1.0)*REYNIN)*XSI**(1.0-BULE(IS))

        UCON = UEI
        TSQ = 0.45/(5.0*BULE(IS)+1.0) * (XSI/UEI) / REYN
C
        THET(I,IS) = SQRT(TSQ)
        DSTR(I,IS) = HI * THET(I,IS)
        CTAU(I,IS) = 0.0
C
        TRAN(IS) = .FALSE.
        TURB(IS) = .FALSE.
        ITRAN(IS) = ITEB(N) + 2
C
        DWTE(IS) = 0.5*WGAP(ITEB(N),N)
C
    3 CONTINUE
C
C
C---- find minimum LE index
      ILEMIN = ILEB(1)
      DO 4 N=1, NBL
        ILEMIN = MIN0( ILEMIN , ILEB(N) )
    4 CONTINUE
C
C**** Sweep downstream
      DO 1000 I=ILEMIN+1, II-1
      IM = I-1
C
C---- try direct convergence with specified Ue for all layers first
      DO 5 IS=1, 2*NBL
        DIRECT(IS) = .TRUE.
C
        N = (IS+1)/2
        UPLE(IS) = I.LE.ILEB(N)
        SIMI(IS) = I.EQ.ILEB(N) + 1
        WAKE(IS) = I.GT.ITEB(N)
    5 CONTINUE
C
C---- initialize convergence flag for each blade BLs/wake
      DO 6 N=1, NBL
        CONVB(N) = .FALSE.
    6 CONTINUE
C
C---- Newton iteration loop for current station
      DO 900 ITBL=1, 25
C
C**** Go over each deck, setting up variables and various flags
      DO 20 IS=1, 2*NBL
C
        IF(UPLE(IS)) GO TO 20
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 20
C
C------ set new "2" variables for SETKIN
        DSWAKI = 0.
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
        XSI = XI(I,IS)
        RHI = RHOE(I,IS)
        UEI = UEDG(I,IS)
        THI = THET(I,IS)
        DSI = DSTR(I,IS) - DSWAKI
        CTI = CTAU(I,IS)
        AMI = CTAU(I,IS)
        UNI = DUDN(I,IS)
C
C------ set all kinematic "2" variables in COMMON/VAR2/
        CALL SETKIN(XSI,AMI,CTI,UEI,THI,DSI,DSWAKI,UNI,RHI)
C
C------ check for transition in this interval and set appropriate flags
        IF((.NOT.SIMI(IS)) .AND. (.NOT.TURB(IS))) THEN
C
C------- save kinematic variables for TRCHEK
         DO 205 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
 205     CONTINUE
C
         CALL TRCHEK(I,IS,AMI)
C
C------- if no transition yet, set n and push back transition index
         IF(.NOT. TRAN(IS)) THEN
          CTAU(I,IS) = AMI
          ITRAN(IS) = I+2
         ENDIF
        ENDIF
C
C------ initialize Ctau for first turbulent station
        IF(TRAN(IS) .AND. ITBL.EQ.1) THEN
         CTAU(I,IS) = 0.03
         CTI = CTAU(I,IS)
        ENDIF
C
        S2 = CTI
        AMPL2 = AMI
C
C------ save kinematic variables
        DO 210 NC=1, NCOM
          V2SAV(NC,IS) = COM2(NC)
  210   CONTINUE
C
   20 CONTINUE
C
C
C**** set profile parameters for all decks
ccc      CALL DECPAR(GAPS,2*NBL)
C
C
      DO 30 IS=1, 2*NBL
C
        IF(UPLE(IS)) GO TO 30
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 30
C
C------ set all tertiary "1" (only at LE), "2", and "A" variables and save
        CALL SETVAR(IS)
C
   30 CONTINUE
C
C
C**** assemble linearized system for dCtau, dTh, dDs, dUe, dXi, in all layers
C     at the previous "1" station and the current "2" station
C     (the "1" station coefficients will be ignored)
C
      CALL BLSYS(NBL)
C
C
C---- complete the "2" BL system for each element to enable marching solution
      DO 40 N=1, NBL
        IF(CONVB(N) ) GO TO 40
C
        DO 400 KS=1, 2
C
          IS = 2*(N-1) + KS
C
          IF(UPLE(IS)) GO TO 40
C
C-------- recall current layer variables for station "2"
          DO 4005 NC=1, NCOM
            COM2(NC) = V2SAV(NC,IS)
 4005     CONTINUE
C
C====================================
cccc          if(itbl.eq.1 .and. ((is+1)/2 .eq. (isbug+1)/2) 
cccc     &                 .and. ks.eq.1 ) then
ccc          if(itbl.eq.1 .and. is .eq. isbug) then
c     &                 .and. i.le.iteb((isbug+1)/2)+5
c     &                 .and. ks.eq.mod(isbug+1,2)+1 ) then
c           write(*,*)
c           write(*,*) '*** i iTE itr:', i, iteb(n), itran(is),
c     &                 tran(is),turb(is)
c           write(*,*)
c     &        ' it    Th      Ds      Hk      Rt      Ct      Ue'
ccc     &       ,'      Ce      Tyy     Uyy'
c          endif
cccc          if((is+1)/2 .eq. (isbug+1)/2) then
c          if(is .eq. isbug .and. i.le.iteb((isbug+1)/2)+5) then
c           write(*,2233) itbl,1000*t2, 1000*d2,hk2, rt2, s2, u2
ccc     &                   , ce(n), 0.001*tyy(n), 0.000001*uyy(n)
c 2233      format(1x,i3,f8.3,f8.3,f8.4, f8.1, f8.4, f8.4, 3f8.3)
c          endif
C====================================
C
C-------- equation line index
          K = 4*(KS-1) + 4
C
          IF(DIRECT(IS)) THEN
C
C--------- try direct mode (set dUe = 0 in currently empty 4th line)
           VV2(K,K,N) = 1.0
           VVREZ(K,N) = 0.
C
          ELSE
C
           DISPG = DISP(I,IS)
           IF(WAKE(IS)) DISPG = 0.0
C
           IF(3.0*DISPG .GT. DSTR(I,IS) .AND. LSEP(IS)) THEN
C---------- specify Dstar from inviscid displacement if latter is bigger
            VV2(K,K-3,N) = 0.
            VV2(K,K-2,N) = (DISPG - D2)/T2**2
            VV2(K,K-1,N) = 1.0/T2
            VV2(K,K  ,N) = 0.
            VVREZ(K,N) = (DISPG - D2)/T2
           ELSE
C---------- specify Hk
            VV2(K,K-3,N) = 0.
            VV2(K,K-2,N) = HK2_T2
            VV2(K,K-1,N) = HK2_D2
            VV2(K,K  ,N) = HK2_U2
            VVREZ(K,N) = HTARG(IS) - HK2
           ENDIF
C
          ENDIF
  400   CONTINUE
C
C------ if at least one wake layer is inverse ...
        IF( WAKE(2*N) .AND. .NOT.(DIRECT(2*N).AND.DIRECT(2*N-1)) ) THEN
C
         IF(DIRECT(2*N-1)) THEN
C
C-------- require the two Ue's to have the same change
          VV2(4,1,N) = 0.
          VV2(4,2,N) = 0.
          VV2(4,3,N) = 0.
          VV2(4,4,N) = 1.0
          VV2(4,5,N) = 0.
          VV2(4,6,N) = 0.
          VV2(4,7,N) = 0.
          VV2(4,8,N) = -1.0
          VVREZ(4,N) = UEDG(I,2*N) - UEDG(I,2*N-1)
C
         ELSE IF(DIRECT(2*N)) THEN
C
C-------- require the two Ue's to have the same change
          VV2(8,1,N) = 0.
          VV2(8,2,N) = 0.
          VV2(8,3,N) = 0.
          VV2(8,4,N) = 1.0
          VV2(8,5,N) = 0.
          VV2(8,6,N) = 0.
          VV2(8,7,N) = 0.
          VV2(8,8,N) = -1.0
          VVREZ(8,N) = UEDG(I,2*N) - UEDG(I,2*N-1)
C
         ELSE
C
C-------- if both inverse, add the two inverse constraints
          VV2(4,5,N) = VV2(8,5,N)
          VV2(4,6,N) = VV2(8,6,N)
          VV2(4,7,N) = VV2(8,7,N)
          VV2(4,8,N) = VV2(8,8,N)
          VVREZ(4,N) = VVREZ(8,N) + VVREZ(4,N)
C
C-------- and require the two Ue's to be the same
          VV2(8,1,N) = 0.
          VV2(8,2,N) = 0.
          VV2(8,3,N) = 0.
          VV2(8,4,N) = 1.0
          VV2(8,5,N) = 0.
          VV2(8,6,N) = 0.
          VV2(8,7,N) = 0.
          VV2(8,8,N) = -1.0
          VVREZ(8,N) = UEDG(I,2*N) - UEDG(I,2*N-1)
C
         ENDIF
C
        ENDIF
C
C
C------ solve Newton system for current "2" station
        CALL SOLVIT(8,8,VV2(1,1,N),VVREZ(1,N))
C
   40 CONTINUE
C
C
      DO 48 IS=1, 2*NBL
        DMAXS(IS) = 0.0
   48 CONTINUE
C
C---- determine max change DMAXS for each element
      DO 50 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 50
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 50
C
        UEI = UEDG(I,IS)
        THI = THET(I,IS)
        IF(WAKE(IS)) THEN
         DSI = DSTR(I,IS) - 0.5*WGAP(I,N)
        ELSE
         DSI = DSTR(I,IS)
        ENDIF
        IF(TRAN(IS).OR.TURB(IS)) THEN
         CTI = CTAU(I,IS)
        ELSE
         CTI = AMCRIT
        ENDIF

        KS = MOD(IS+1,2) + 1
C
        KC = 4*(KS-1) + 1
        KT = 4*(KS-1) + 2
        KD = 4*(KS-1) + 3
        KU = 4*(KS-1) + 4
        DMAXS(IS) = MAX( ABS(VVREZ(KT,N)/THI),
     &                   ABS(VVREZ(KD,N)/DSI), 
     &                   ABS(VVREZ(KU,N)/UEI),
     &                   ABS(VVREZ(KC,N)/CTI), DMAXS(IS) )
   50 CONTINUE
C
C---- update variables
      DO 55 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 55
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 55
C
C------ set underrelaxation factor if necessary
        RLX = 1.0
        IF(WAKE(IS)) THEN 
          DMAX = MAX( DMAXS(2*N-1) , DMAXS(2*N) )
        ELSE
          DMAX = DMAXS(IS)
        ENDIF
C
        IF(DMAX.GT.0.3) RLX = 0.3/DMAX
C
        KS = MOD(IS+1,2) + 1
C
        KC = 4*(KS-1) + 1
        KT = 4*(KS-1) + 2
        KD = 4*(KS-1) + 3
        KU = 4*(KS-1) + 4
C
        CTAU(I,IS) = CTAU(I,IS) + RLX*VVREZ(KC,N)
        THET(I,IS) = THET(I,IS) + RLX*VVREZ(KT,N)
        DSTR(I,IS) = DSTR(I,IS) + RLX*VVREZ(KD,N)
        UEDG(I,IS) = UEDG(I,IS) + RLX*VVREZ(KU,N)
C
   55 CONTINUE
C
C---- for direct case, check if inverse convergence is needed for each layer
      DO 58 IS=1, 2*NBL
       IF(UPLE(IS)) GO TO 58
C
       N = (IS+1)/2
       IF(CONVB(N)) GO TO 58
C
       IF(.NOT.DIRECT(IS)) GO TO 58
C
        LSEP(IS) = .FALSE.
C
        DSWAKI = 0.
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
C
C------ set min and max allowable Hk for direct mode
ccc        IF(I.LT.ITRAN(IS)) THEN
        IF(.NOT. (TURB(IS).OR.TRAN(IS)) ) THEN
         HMAX = HLMAX
         HMIN = HLMIN
        ELSE 
         HMAX = HTMAX
C
ccc         RHO = RSTBL * (1.0 - 0.5*UEDG(I-1,IS)**2 / HSTBL)**(1.0/GM1BL)
ccc         HEDGE = HSTBL - 0.5*UEDG(I-1,IS)**2
ccc         VISC = SQRT((HEDGE/HSTBL)**3)
ccc     &        * (HSTBL+HVISBL)/(HEDGE+HVISBL)/REYBL
ccc         RET = RHO*UEDG(I-1,IS)*THET(I,IS) / VISC
ccc         HMIN = MAX( HTMIN , (1.0/ALOG(RET) + 1.0) )
C
         HMIN = HTMIN
C
        ENDIF
C
C------ set Mach^2 for H-Hk correlations
        MSQ = UEDG(I,IS)**2 / ((GAMBL-1.0)*(HSTBL - 0.5*UEDG(I,IS)**2))
C
C------ calculate new kinematic shape parameter Hk
        HTEST = (DSTR(I,IS)-DSWAKI) / THET(I,IS)
        CALL HKIN( HTEST, MSQ, GAMBL, HKTEST, DUMMY, DUMMY)
C
C------ decide whether to do direct or inverse problem based on Hk
        LACC     = HKTEST.LT.HMIN .AND. TURB(IS) .AND. .NOT.WAKE(IS)
        LSEP(IS) = HKTEST.GT.HMAX .OR.    !!! new  27 Apr 92
     &             (DISP(I,IS).GT.DSTR(I,IS) .AND. .NOT.WAKE(IS))
ccc        DIRECT(IS) = .NOT.LACC .AND. .NOT.LSEP(IS)
        DIRECT(IS) = .NOT.LSEP(IS)
C
        IF(.NOT. DIRECT(IS)) THEN
C------- set prescribed Hk for inverse calculation at the current station
C
         DO 552 NC=1, NCOM
           COM1(NC) = V1SAV(NC,IS)
           COM2(NC) = V2SAV(NC,IS)
 552     CONTINUE
C
         DO 553 NC=1, NCOMA
           COMA(NC) = VASAV(NC,IS)
 553     CONTINUE
C
         IF(LSEP(IS)) THEN
C
          IF(.NOT.TURB(IS)) THEN
C--------- laminar case: relatively slow increase in Hk downstream
           HTARG(IS) = HK1 + 0.03*(X2-X1)/T1
          ELSE IF(TRAN(IS)) THEN
C--------- transition interval: weighted laminar and turbulent case
CCC           HTARG(IS) = HK1 + (0.03*(XT-X1) - 0.15*(X2-XT))/T1
           HTARG(IS) = HK1
          ELSE IF(WAKE(IS)) THEN
C--------- turbulent wake case:
C-         asymptotic wake behavior with approx. Backward Euler,
C-         solve for Hk with a few Newton iterations.
           CONST = 0.03*(X2-X1)/T1
           HK2 = HK1
           HK2 = HK2 - (HK2 +     CONST*(HK2-1.0)**3 - HK1)
     &                /(1.0 + 3.0*CONST*(HK2-1.0)**2)
           HK2 = HK2 - (HK2 +     CONST*(HK2-1.0)**3 - HK1)
     &                /(1.0 + 3.0*CONST*(HK2-1.0)**2)
           HK2 = HK2 - (HK2 +     CONST*(HK2-1.0)**3 - HK1)
     &                /(1.0 + 3.0*CONST*(HK2-1.0)**2)
           HTARG(IS) = HK2
          ELSE
C--------- turbulent case: relatively fast decrease in Hk downstream
ccc        HTARG(IS) = HK1 - 0.15*(X2-X1)/T1
           HTARG(IS) = HK1 - 0.30*(X2-X1)/T1
          ENDIF
C
C-------- limit specified Hk to something reasonable
          IF(WAKE(IS)) THEN
           HTARG(IS) = MAX( HTARG(IS) , 1.01 )
          ELSE
           HTARG(IS) = MAX( HTARG(IS) , HMAX )
          ENDIF
C
         ELSE
C
          HTARG(IS) = HMIN
C
         ENDIF
C
         DISPG = DISP(I,IS)
         IF(WAKE(IS)) DISPG = 0.0
C
         IF(3.0*DISPG .GT. DSTR(I,IS) .AND. LSEP(IS)) DSTR(I,IS) = DISPG
C
         IF(3.0*DISPG .GT. DSTR(I,IS) .AND. LSEP(IS)) THEN
          WRITE(*,5515) I, IS, DISPG
         ELSE
          WRITE(*,5520) I, IS, HTARG(IS)
         ENDIF
C
 5515    FORMAT(' MRCHUE: Inverse mode at i =',I3,
     &          ' side', I2,'   d* =', F7.5)
 5520    FORMAT(' MRCHUE: Inverse mode at i =',I3,
     &          ' side', I2,'   Hk =', F7.3)
C
        ENDIF
C
   58 CONTINUE
C
C
      DO 60 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 60
C------ eliminate absurd transients
        IF(.NOT.WAKE(IS)) THEN
         MSQ = UEDG(I,IS)**2 / ((GAMBL-1.0)*(HSTBL-0.5*UEDG(I,IS)**2))
         CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAMBL,HTMIN )
        ENDIF
        IF(TURB(IS)) CTAU(I,IS) = MIN( CTAU(I,IS) , 0.30 )
   60 CONTINUE
C
      DMAX = 0.0
      DO 62 N=1, NBL
        DMAX = MAX( DMAXS(2*N-1) , DMAXS(2*N) , DMAX )
        CONVB(N) = DMAXS(2*N-1) .LE. BLEPS  .AND.
     &             DMAXS(2*N  ) .LE. BLEPS
   62 CONTINUE
C
      IF(DMAX.LE.BLEPS) GO TO 910
C
  900 CONTINUE ! with next Newton iteration
C
      WRITE(*,9010) I, (DMAXS(IS), IS=1, 2*NBL)
 9010 FORMAT(' Conv. failed at', I4, '  Res:', 10E10.3)
C
C---- check each side to see how badly it blew up and fix if necessary
      DEXT = 0.1
      DO 70 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 70
C
        IF(DMAXS(IS) .LE. DEXT) GO TO 702
C------ the current solution is garbage --> extrapolate values instead
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        IF(I.GT.ILE+2) THEN
         IF(TRAN(IS)) THEN
           CTAU(I,IS) = 0.05
         ELSE IF(TURB(IS)) THEN
           CTAU(I,IS) = CTAU(IM,IS)
           IF(IM.EQ.ITE .AND. IM.LT.ITRAN(IS)) CTAU(I,IS) = 0.02
         ENDIF
         THET(I,IS) = THET(IM,IS)
         UEDG(I,IS) = UEDG(IM,IS)
C
         IF(IM.LT.ITE) THEN
          DSTR(I,IS) = DSTR(IM,IS)
         ELSE IF(IM.EQ.ITE) THEN
          DSTR(I,IS) = DSTR(IM,IS)                + 0.5*WGAP(I,N)
         ELSE IF(IM.GT.ITE) THEN
          DSTR(I,IS) = DSTR(IM,IS)-0.5*WGAP(IM,N) + 0.5*WGAP(I,N)
         ENDIF
C
         IF(I.LE.ITE .AND. DISP(I,IS) .GT. DSTR(I,IS)) THEN
          HI = DSTR(I,IS)/THET(I,IS)
          DSTR(I,IS) = DISP(I,IS)
          THET(I,IS) = DISP(I,IS)/HI
         ENDIF
        ENDIF
C
        IF(.NOT.WAKE(IS)) THEN
         MSQ = UEDG(I,IS)**2 / ((GAMBL-1.0)*(HSTBL-0.5*UEDG(I,IS)**2))
         CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAMBL,1.05)
        ENDIF
C
 702    CONTINUE
C
        DSWAKI = 0.0
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
C
        XSI = XI(I,IS)
        AMI = CTAU(I,IS)        !  used if  I .LT. ITRAN(IS)
        CTI = CTAU(I,IS)        !  used if  I .GE. ITRAN(IS)
        UEI = UEDG(I,IS)
        RHI = RHOE(I,IS)
        THI = THET(I,IS)
        DSI = DSTR(I,IS) - DSWAKI
        UNI = DUDN(I,IS)
C
C------ set all kinematic "2" variables in COMMON/VAR2/
        CALL SETKIN(XSI,AMI,CTI,UEI,THI,DSI,DSWAKI,UNI,RHI)
C
C------ save kinematic variables
        DO 705 NC=1, NCOM
          V2SAV(NC,IS) = COM2(NC)
  705   CONTINUE
C
   70 CONTINUE
C
C
      DO 74 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 74
C
C------ check for transition in this interval and set appropriate flags
        IF((.NOT.SIMI(IS)) .AND. (.NOT.TURB(IS))) THEN
C
         CALL TRCHEK(I,IS,AMI)
C
C------- if no transition yet, set Ampl and push back transition index
         IF(.NOT. TRAN(IS)) THEN
          CTAU(I,IS) = AMI
          ITRAN(IS) = I+2
C
C-------- save new amplification variable Ampl
          AMPL2 = AMI
C
          DO 742 NC=1, NCOM
            V2SAV(NC,IS) = COM2(NC)
 742      CONTINUE
         ENDIF
        ENDIF
 74   CONTINUE
C
C
      DO 78 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 78
C
        CALL SETVAR(IS)
   78 CONTINUE
C
C
C---- pick up here after the Newton iterations
  910 CONTINUE
C
      DO 80 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 80
        N = (IS+1)/2
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        IF(I.EQ.ITE) THEN
C------- set "2" variables at TE to wake correlations for next station
         DO 810 NC=1, NCOM
           COM2(NC) = V2SAV(NC,IS)
  810    CONTINUE
C
         DW2 = 0.5*WGAP(I,N)
         TURB(IS) = .TRUE.
         WAKE(IS) = .TRUE.
         ISIDE = IS
C
         CALL DSTSET
         CALL BLVAR(3)
C
         DO 815 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
  815    CONTINUE
        ENDIF
C
C------ set "1" variables to "2" variables for next streamwise station
        DO 820 NC=1, NCOM
          V1SAV(NC,IS) = V2SAV(NC,IS)
  820   CONTINUE
C
C------ set first guess for variables at next streamwise station
        CTAU(I+1,IS) = CTAU(I,IS)
        THET(I+1,IS) = THET(I,IS)
        DSTR(I+1,IS) = DSTR(I,IS)
        IF(I .EQ. ITE) THEN
          DSTR(I+1,IS) = DSTR(I,IS) + 0.5*WGAP(I+1,N)
          IF(.NOT.(TRAN(IS).OR.TURB(IS)) ) CTAU(I+1,IS) = 0.03
        ENDIF
c
ccc        IF(I .GT. ITE) DSTR(I+1,IS) = DSTR(I,IS) + 0.5*WGAP(I+1,N)
ccc     &                                           - 0.5*WGAP(I  ,N)
C
C------ turbulent intervals will follow transition interval
        IF(TRAN(IS)) TURB(IS) = .TRUE.
        TRAN(IS) = .FALSE.
   80 CONTINUE
C
 1000 CONTINUE ! with next streamwise station
C
      RETURN
      END ! MRCHUE
 
 
 
      SUBROUTINE MRCHDU
C...................................................
C     Marches the BLs and wake in mixed mode using
C     the UEDG and DSTR,THET arrays.  The calculated 
C     Ue and Hk lie along a line quasi-normal to the
C     natural Ue-Hk characteristic line of the
C     current BL so that the Goldstein or Levy-Lees
C     singularity is never encountered.  Continuous
C     checking of transition onset is performed.
C...................................................
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
ccc      common /yy/ tyy(nex), uyy(nex), us(nex), ce(nex), du(nex)
      DIMENSION VTMP(8,8), VZTMP(8)
      DIMENSION AMPL(ISX)
C
c###
      DATA BLEPS / 1.0E-5 /
c      DATA BLEPS / 1.0D-12 /
C
c---- side index for debug info
      isbug = 0
c
C---- mixed mode weighting constant
C
C       SENSWT = infinity ...    direct  mode, Ue specified
C       SENSWT = 0        ...    inverse mode, Hk specified
C
ccc   SENSWT = 1000.0
ccc   SENSWT = 100.0
      SENSWT = 40.0
ccc   SENSWT = 10.0
C
C---- initialize stuff for downstream sweep
      DO 3 IS=1, 2*NBL
        N = (IS+1)/2
C
        TRAN(IS) = .FALSE.
        TURB(IS) = .FALSE.
        ITROLD(IS) = ITRAN(IS)
C
        DWTE(IS) = 0.5*WGAP(ITEB(N),N)
        AMPL(IS) = 0.
    3 CONTINUE
C
C---- find minimum LE index from which downstream sweep will be started
      ILEMIN = ILEB(1)
      DO 4 N=1, NBL
        ILEMIN = MIN0( ILEMIN , ILEB(N) )
    4 CONTINUE
C
C**** Sweep downstream
      DO 1000 I=ILEMIN+1, II-1
      IM = I-1
C
C---- set flag for each layer which is currently upstream of its leading edge
      DO 5 IS=1, 2*NBL
        N = (IS+1)/2
        UPLE(IS) = I.LE.ILEB(N)
C
        SIMI(IS) = I.EQ.ILEB(N) + 1
        WAKE(IS) = I.GT.ITEB(N)
C
C------ laminar: initialize amplification ratio from current solution
        IF(.NOT. (TRAN(IS).OR.TURB(IS)) )  AMPL(IS) = CTAU(I,IS)
    5 CONTINUE
C
      DO 6 N=1, NBL
        CONVB(N) = .FALSE.
    6 CONTINUE
C
C
C---- Newton iteration loop for current station
      DO 900 ITBL=1, 25
C
C---- Go over each boundary layer, setting up variables and various flags
      DO 20 IS=1, 2*NBL
C
C------ if we're still upstream of the LE for this layer, go to next layer
        IF(UPLE(IS)) GO TO 20
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 20
C
        DSWAKI = 0.
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
C
        IF(ITBL.EQ.1) THEN
C------- set prescribed values HKREF, DSREF, UEREF for this layer
         RHI = RHOE(I,IS)
         UEI = UEDG(I,IS)
         DSI = DSTR(I,IS) - DSWAKI
         THI = THET(I,IS)
         MSQ = UEI*UEI  / ((GAMBL-1.0)*(HSTBL-0.5*UEI*UEI))
C
         CALL HKIN( DSI/THI, MSQ, GAMBL, HKREF(IS), DUMMY, DUMMY )
         UEREF(IS) = UEI
         DSREF(IS) = DSI
        ENDIF
C
C------ set variables for SETVAR, etc.
        XSI = XI(I,IS)
        RHI = RHOE(I,IS)
        UEI = UEDG(I,IS)
        THI = THET(I,IS)
        DSI = DSTR(I,IS) - DSWAKI
        CTI = CTAU(I,IS)
        AMI = AMPL(  IS)
        UNI = DUDN(I,IS)
C
C------ set all kinematic "2" variables in COMMON/VAR2/
        CALL SETKIN(XSI,AMI,CTI,UEI,THI,DSI,DSWAKI,UNI,RHI)
C
C------ check for transition in this interval and set appropriate flags
        IF((.NOT.SIMI(IS)) .AND. (.NOT.TURB(IS))) THEN
C
C------- save kinematic variables for TRCHEK
         DO 205 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
 205     CONTINUE
C
         CALL TRCHEK(I,IS,AMI)
C
C------- if no transition yet, set Ampl and push back transition index
         IF(.NOT. TRAN(IS)) THEN
          AMPL(IS) = AMI
c%%%          CTAU(I,IS) = AMI
          ITRAN(IS) = I+2
         ELSE
          IF(CTAU(I,IS).LE.0.0) CTAU(I,IS) = 0.03
          CTI = CTAU(I,IS)
         ENDIF
        ENDIF
C
        IF(ITBL.EQ.1) THEN
C------- take care of special problems on first iteration pass
C
         IF(I.LT.ITRAN(IS) .AND. I.GE.ITROLD(IS) ) THEN
C-------- transition point moved downstream -- extrapolate prescribed Hk
          UEM = UEDG(IM,IS)
          DSM = DSTR(IM,IS)
          THM = THET(IM,IS)
          MSQ = UEM*UEM  / ((GAMBL-1.0)*(HSTBL-0.5*UEM*UEM))
          CALL HKIN( DSM/THM, MSQ, GAMBL, HKREF(IS), DUMMY, DUMMY )
          HREF = HKREF(IS)*(1.0 + 0.2825*(GAMBL-1.0)*MSQ)
     &                          + 0.7250*(GAMBL-1.0)*MSQ
          DSREF(IS) = HREF*THET(I,IS)
         ENDIF
C
         IF(I.LT.ITROLD(IS)) THEN
C-------- reinitialize Ctau (from Ampl) if transition point moved upstream
          IF(TRAN(IS)) CTAU(I,IS) = 0.03
          IF(TURB(IS)) CTAU(I,IS) = CTAU(IM,IS)
          IF(TRAN(IS) .OR. TURB(IS)) CTI = CTAU(I,IS)
c%%%          CTI = CTAU(I,IS)
         ENDIF
C
        ENDIF
C
        S2 = CTI
        AMPL2 = AMI
C
C------ save kinematic variables
        DO 210 NC=1, NCOM
          V2SAV(NC,IS) = COM2(NC)
  210   CONTINUE
C
   20 CONTINUE
C
C
C**** set profile parameters for each deck
ccc      CALL DECPAR(GAPS,2*NBL)
C
C
      DO 30 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 30
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 30
C
        CALL SETVAR(IS)
C
   30 CONTINUE
C
C
C**** assemble linearized system for dCtau, dTh, dDs, dUe, dXi, in all layers
C     at the previous "1" station and the current "2" station
C     (the "1" station coefficients will be ignored)
C
      CALL BLSYS(NBL)
C
C**** complete the "2" BL system for each element to allow marching solution
      DO 40 N=1, NBL
        IF(UPLE(2*N)) GO TO 40
        IF(CONVB(N)) GO TO 40
C
        IF(SIMI(2*N)) THEN
C
C******* specify Ue at similarity station
C
C------- go over element sides
         DO 410 KS=1, 2
C
           IS = 2*(N-1) + KS
C
C--------- recall current layer variables
           DO 4102 NC=1, NCOM
             COM2(NC) = V2SAV(NC,IS)
 4102      CONTINUE
C
           K = 4*(KS-1) + 4
           VV2(K,K,N) = 1.0
           VVREZ(K,N) = UEREF(IS) - U2
C
  410    CONTINUE
C
        ELSE
C
C******* specify Ue-Hk combo perpendicular to Ue-Hk locus slope
C
C------- clear temporary system used to determine locus slope
         DO 418 K=1, 8
           DO 4181 L=1, 8
             VTMP(K,L) = 0.0
 4181      CONTINUE
           VZTMP(K) = 0.0
  418    CONTINUE
C
C------- go over element sides
         DO 420 KS=1, 2
C
           IS = 2*(N-1) + KS
C
C--------- recall current layer variables
           DO 422 NC=1, NCOM
             COM2(NC) = V2SAV(NC,IS)
  422      CONTINUE
C
C--------- set linearized system for this layer
           DO 425 KT=1, 4
             K = 4*(KS-1) + KT
ccc          VZTMP(K) = VVREZ(K,N)
             VZTMP(K) = 0.0
             DO 4251 L=1, 8
               VTMP(K,L) = VV2(K,L,N)
 4251        CONTINUE
  425      CONTINUE
C
C--------- specify unit dHk
           K = 4*(KS-1) + 4
           VTMP(K,K-3) = 0.
           VTMP(K,K-2) = HK2_T2
           VTMP(K,K-1) = HK2_D2
           VTMP(K,K  ) = HK2_U2
           VZTMP(K)    = 1.0   
C
           IF(WAKE(IS) .AND. KS.EQ.2) THEN
C
CC---------- for wake, add the two dHk constraints together ...
C            VV2(4,5,N) = VV2(8,5,N)
C            VV2(4,6,N) = VV2(8,6,N)
C            VV2(4,7,N) = VV2(8,7,N)
C            VV2(4,8,N) = VV2(8,8,N)
C            VVREZ(4,N) = VVREZ(4,N) + VVREZ(8,N)
C
C---------- hold Ue's to be the same for each wake half in lieu of Hk eq'n
CCC         K = 4*(KS-1) + 4
            K = 8
            VTMP(K,1) = 0.
            VTMP(K,2) = 0.
            VTMP(K,3) = 0.
            VTMP(K,4) = 1.0
            VTMP(K,5) = 0.
            VTMP(K,6) = 0.
            VTMP(K,7) = 0.
            VTMP(K,8) = -1.0
            VZTMP(K)  = 0.0
C
           ENDIF
C
c========================
c
cCC          if(itbl.eq.1 .and. ((is+1)/2 .eq. (isbug+1)/2) 
cCC     &                 .and. ks.eq.1 ) then
c          if(itbl.eq.1 .and. is .eq. isbug
c     &                 .and. i.ge.350) then
ccc     &                 .and. i.le.ileb((isbug+1)/2)+31 ) then
ccc     &                 .and. ks.eq.mod(isbug+1,2)+1 ) then
c           write(*,*) ' '
c           write(*,*) '*** i iTE itr:', i, iteb(n), itran(is),
c     &                 tran(is),turb(is)
ccc           write(*,*) vasav(11,2), xitran(2), xiforc(2)
c           write(*,*)
c     &' i is  Th       Ds       Hk       ',
c     &'Ht       Rt      n      Ct     Ctq'
ccc     &Tyy     Uyy'
c          endif
cCC          if((is+1)/2 .eq. (isbug+1)/2) then
c          if(is .eq. isbug
c     &                 .and. i.ge.350) then
cc     &                 .and. i.ge.ileb((isbug+1)/2)+1
cc     &                 .and. i.le.ileb((isbug+1)/2)+31 ) then
cccc     &                 .and. ks.eq.mod(isbug+1,2)+1 ) then
c           itrn = 0
c           itrb = 0
c           if(tran(is)) itrn = 1
c           if(turb(is)) itrb = 1
c
c           hkt = h2 - 2.0*hc2/hs2
C
c           write(*,2233) 
c     &   itbl, ks, 1000*t2, 1000*d2,hk2,hkt,rt2,ampl2,s2,cq2
ccc     &                   , 0.001*tyy(n), 0.000001*uyy(n)
ccc           if(ks.eq.1) write(*,*) (vvrez(k,n),k=1, 4)
ccc           if(ks.eq.2) write(*,*) (vvrez(k,n),k=5, 8)
c          endif
cc
2233     format(1x,i3,i2,f7.3,f8.3,2f8.5, f8.0, f8.4,2f7.4, f8.4, 2i3)
c
c========================

  420    CONTINUE
C
ccc           if(n.eq.(isbug+1)/2) then !!!%
c             do 6666 k=1, 8
c               write(*,6667) (vtmp(k,l), l=1, 8)
c 6666        continue
c 6667        format(1x,8e10.2)
c             write(*,*) ' '
c             write(*,6667) (vztmp(k), k=1,8)
ccc           endif

C------- calculate dUe response for both sides
         CALL SOLVIT(8,8,VTMP,VZTMP)
C
C
C------- go over sides again
         DO 430 KS=1, 2
C
           IS = 2*(N-1) + KS
C
C--------- recall current layer variables
           DO 432 NC=1, NCOM
             COM2(NC) = V2SAV(NC,IS)
  432      CONTINUE
C
C--------- set new SENSWT * (normalized dUe/dHk or dUe/dDs)
           K = 4*(KS-1) + 4
           SNEW = SENSWT * VZTMP(K) * HKREF(IS)/UEREF(IS)
C
           IF(ITBL.LE.5) THEN
            SENS(IS) = SNEW
           ELSE IF(ITBL.LE.10) THEN
            SENS(IS) = 0.5*(SENS(IS) + SNEW)
           ENDIF
C
C--------- set prescribed Ue-Hk combination
           K = 4*(KS-1) + 4
           VV2(K,K-3,N) = 0.
           VV2(K,K-2,N) = HK2_T2 * HKREF(IS)**2 / HKREF(IS)
           VV2(K,K-1,N) = HK2_D2 * HKREF(IS)**2 / HKREF(IS)
           VV2(K,K  ,N) = HK2_U2 * HKREF(IS)**2 / HKREF(IS)
     &                             +   SENS(IS) / UEREF(IS)
           VVREZ(K,N) = - (HKREF(IS)**2)*(HK2/ HKREF(IS) - 1.0)
     &                  -   SENS(IS)    *(U2 / UEREF(IS) - 1.0)
c           IF(.NOT.WAKE(IS)) THEN
cC---------- add on prescribed Ue-Ds combination
c            VV2(K,K-1,N) =  VV2(K,K-1,N)
c     &                    + HKREF(IS)**2      / DSREF(IS)
c            VVREZ(K,N) = VVREZ(K,N)
c     &                   - (HKREF(IS)**2)*(D2 / DSREF(IS) - 1.0)
c           ENDIF
cC
  430    CONTINUE
C
        ENDIF
C
C
        IF(WAKE(2*N)) THEN
C
C------- for wake, add the two hybrid constraints together ...
         VV2(4,5,N) = VV2(8,5,N)
         VV2(4,6,N) = VV2(8,6,N)
         VV2(4,7,N) = VV2(8,7,N)
         VV2(4,8,N) = VV2(8,8,N)
         VVREZ(4,N) = VVREZ(4,N) + VVREZ(8,N)
C
C------- ... and require the two Ue's to have the same change
         VV2(8,1,N) = 0.
         VV2(8,2,N) = 0.
         VV2(8,3,N) = 0.
         VV2(8,4,N) = 1.0
         VV2(8,5,N) = 0.
         VV2(8,6,N) = 0.
         VV2(8,7,N) = 0.
         VV2(8,8,N) = -1.0
         VVREZ(8,N) = 0.0
C
        ENDIF
C
C------ solve Newton system for current "2" station
        CALL SOLVIT(8,8,VV2(1,1,N),VVREZ(1,N))
C
   40 CONTINUE
C
      DO 48 IS=1, 2*NBL
        DMAXS(IS) = 0.0
   48 CONTINUE
C
C---- determine max changes and underrelax if necessary
      DMAX = 0.0
      DO 50 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 50
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 50
C
        KS = MOD(IS+1,2) + 1
C
        KC = 4*(KS-1) + 1
        KT = 4*(KS-1) + 2
        KD = 4*(KS-1) + 3
        KU = 4*(KS-1) + 4
C
        DMAXS(IS) = MAX( ABS(VVREZ(KT,N)/THET(I,IS)),
     &                   ABS(VVREZ(KD,N)/DSTR(I,IS)),
     &                   ABS(VVREZ(KU,N)/UEDG(I,IS)), DMAXS(IS) )
        IF(TRAN(IS).OR.TURB(IS)) DMAXS(IS) = 
     &         MAX( ABS(VVREZ(KC,N)/CTAU(I,IS)), DMAXS(IS) )
C
   50 CONTINUE
C
      DO 60 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 60
C
        N = (IS+1)/2
        IF(CONVB(N)) GO TO 60
C
C------ set underrelaxation factor if necessary
        RLX = 1.0
        IF(WAKE(IS)) THEN 
          DMAX = MAX( DMAXS(2*N-1) , DMAXS(2*N) )
        ELSE
          DMAX = DMAXS(IS)
        ENDIF
C
        IF(DMAX .GT. 0.3) RLX = 0.3/DMAX
C
        KS = MOD(IS+1,2) + 1
C
        KC = 4*(KS-1) + 1
        KT = 4*(KS-1) + 2
        KD = 4*(KS-1) + 3
        KU = 4*(KS-1) + 4
C
C------ update as usual  (AMPL is not updated since it does not change)
        IF(TRAN(IS).OR.TURB(IS)) THEN
          CTAU(I,IS) = CTAU(I,IS) + RLX*VVREZ(KC,N)
        ELSE
          AMPL(  IS) = AMPL(  IS) + RLX*VVREZ(KC,N)
        ENDIF
        THET(I,IS) = THET(I,IS) + RLX*VVREZ(KT,N)
        DSTR(I,IS) = DSTR(I,IS) + RLX*VVREZ(KD,N)
        UEDG(I,IS) = UEDG(I,IS) + RLX*VVREZ(KU,N)
C
C------ eliminate absurd transients
        IF(.NOT.WAKE(IS)) THEN
         MSQ = UEDG(I,IS)**2 / ((GAMBL-1.0)*(HSTBL-0.5*UEDG(I,IS)**2))
         CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAMBL,1.05)
        ENDIF
C
        IF(TURB(IS)) CTAU(I,IS) = MIN( CTAU(I,IS) , 0.30 )
C
   60 CONTINUE
C
      DMAX = 0.0
      DO 62 N=1, NBL
        DMAX = MAX( DMAXS(2*N-1) , DMAXS(2*N) , DMAX )
        CONVB(N) = DMAXS(2*N-1) .LE. BLEPS  .AND.
     &             DMAXS(2*N  ) .LE. BLEPS
   62 CONTINUE
C
      IF(DMAX.LE.BLEPS) GO TO 910
C
  900 CONTINUE
C
      WRITE(*,9010) I, (DMAXS(IS), IS=1, 2*NBL)
 9010 FORMAT(' Conv. failed at', I4, '  Res:', 10E10.3)
C
C---- check each side to see how badly it blew up
      DEXT = 0.1
      DO 70 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 70
C
        IF(DMAXS(IS) .LE. DEXT) GO TO 702
C------ the current solution is garbage --> extrapolate values instead
C
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        IF(I.GT.ILE+2) THEN
         IF(TURB(IS)) CTAU(I,IS) = CTAU(IM,IS)
         IF(TRAN(IS)) CTAU(I,IS) = 0.05
         THET(I,IS) = THET(IM,IS)
         UEDG(I,IS) = UEDG(IM,IS)
c
         IF(I .LT. II-1) THEN
          THET(I,IS) = 0.5*(THET(I-1,IS)+THET(I+1,IS))
          UEDG(I,IS) = 0.5*(UEDG(I-1,IS)+UEDG(I+1,IS))
         ENDIF
C
         IF(I .LT. ITE) THEN
CCC       DSTR(I,IS) = DSTR(IM,IS)
          DSTR(I,IS) = 0.5*(DSTR(I-1,IS)+DSTR(I+1,IS))
         ELSE IF(I .EQ. ITE) THEN
CCC       DSTR(I,IS) = DSTR(IM,IS)
          DSTR(I,IS) = 0.5*(DSTR(I-1,IS)
     &                     +DSTR(I+1,IS)-0.5*WGAP(I+1,N))
         ELSE IF(I .EQ. ITE+1) THEN
CCC       DSTR(I,IS) = DSTR(IM,IS)                + 0.5*WGAP(I,N)
          DSTR(I,IS) = 0.5*(DSTR(I-1,IS)
     &                     +DSTR(I+1,IS)-0.5*WGAP(I+1,N))
     &               + 0.5*WGAP(I,N)
         ELSE IF(I .LT. II-1) THEN
CCC       DSTR(I,IS) = DSTR(IM,IS)-0.5*WGAP(IM,N) + 0.5*WGAP(I,N)
          DSTR(I,IS) = 0.5*(DSTR(I-1,IS)-0.5*WGAP(I-1,N)
     &                     +DSTR(I+1,IS)-0.5*WGAP(I+1,N))
     &               + 0.5*WGAP(I,N)
         ELSE
          DSTR(I,IS) = DSTR(IM,IS)-0.5*WGAP(IM,N) + 0.5*WGAP(I,N)
         ENDIF
        ENDIF
C
        IF(.NOT.WAKE(IS)) THEN
         MSQ = UEDG(I,IS)**2 / ((GAMBL-1.0)*(HSTBL-0.5*UEDG(I,IS)**2))
         CALL DSLIM(DSTR(I,IS),THET(I,IS),UEDG(I,IS),MSQ,GAMBL,1.05)
        ENDIF
C
 702    CONTINUE
C
        DSWAKI = 0.0
        IF(WAKE(IS)) DSWAKI = 0.5*WGAP(I,N)
C
        XSI = XI(I,IS)
c%%%    AMI = CTAU(I,IS)        !  used if  I .LT. ITRAN(IS)
        AMI = AMPL(  IS)        !  used if  I .LT. ITRAN(IS)
        CTI = CTAU(I,IS)        !  used if  I .GE. ITRAN(IS)
        UEI = UEDG(I,IS)
        RHI = RHOE(I,IS)
        THI = THET(I,IS)
        DSI = DSTR(I,IS) - DSWAKI
        UNI = DUDN(I,IS)
C
C------ set all kinematic "2" variables in COMMON/VAR2/
        CALL SETKIN(XSI,AMI,CTI,UEI,THI,DSI,DSWAKI,UNI,RHI)
C
C------ save kinematic variables
        DO 705 NC=1, NCOM
          V2SAV(NC,IS) = COM2(NC)
  705  CONTINUE
C
   70 CONTINUE
C
C
      DO 74 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 74
C
C------ check for transition in this interval and set appropriate flags
        IF((.NOT.SIMI(IS)) .AND. (.NOT.TURB(IS))) THEN
C
         CALL TRCHEK(I,IS,AMI)
C
C------- if no transition yet, set Ampl and push back transition index
         IF(.NOT. TRAN(IS)) THEN
c%%%       CTAU(I,IS) = AMI
          AMPL(IS) = AMI
          AMPL2 = AMI
          ITRAN(IS) = I+2
C
C-------- save AMPL2
          DO 745 NC=1, NCOM
            V2SAV(NC,IS) = COM2(NC)
  745     CONTINUE
         ENDIF
C
        ENDIF
C
   74 CONTINUE
C
C
      DO 78 IS=1, 2*NBL
        N = (IS+1)/2
        IF(UPLE(IS) .OR. CONVB(N)) GO TO 78
C
        CALL SETVAR(IS)
 78   CONTINUE
C
C
C---- pick up here after the Newton iterations
  910 CONTINUE
C
C
      DO 80 IS=1, 2*NBL
        IF(UPLE(IS)) GO TO 80
C
        N = (IS+1)/2
        ILE = ILEB(N)
        ITE = ITEB(N)
C
C------ CTAU array is used to hold AMPL values at laminar points
C%%%
        IF( .NOT.(TURB(IS) .OR. TRAN(IS)) ) CTAU(I,IS) = AMPL(IS)
C
        IF(I.EQ.ITE) THEN
C------- set "2" variables at TE to wake correlations for next station
         DO 810 NC=1, NCOM
           COM2(NC) = V2SAV(NC,IS)
  810    CONTINUE
C
         DW2 = 0.5*WGAP(I,N)
C
         TURB(IS) = .TRUE.
         WAKE(IS) = .TRUE.
         ISIDE = IS
C
         CALL DSTSET
         CALL BLVAR(3)
C
         DO 815 NC=1, NCOM
           V2SAV(NC,IS) = COM2(NC)
  815    CONTINUE
        ENDIF
C
C------ set "1" variables to "2" variables for next streamwise station
        DO 820 NC=1, NCOM
          V1SAV(NC,IS) = V2SAV(NC,IS)
  820   CONTINUE
C
C------ turbulent intervals will follow transition interval
        IF(TRAN(IS)) TURB(IS) = .TRUE.
        TRAN(IS) = .FALSE.
   80 CONTINUE
C
 1000 CONTINUE ! with next streamwise station
C
      RETURN
      END ! MRCHDU
 
 
 
      SUBROUTINE XIFSET
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
C
C---- go over all airfoil sides
      DO 100 IS=1, 2*NBL
        N = (IS+1)/2
        ILE = ILEB(N)
        ITE = ITEB(N)
C
        IF(MOD(IS,2).EQ.1) THEN
         SBSIDE = SB(     1,N) - SBLE(N)
        ELSE 
         SBSIDE = SB(IIB(N),N) - SBLE(N)
        ENDIF
C
C------ set unit chord line vector components
        XBC = XBTAIL(N) - XBNOSE(N)
        YBC = YBTAIL(N) - YBNOSE(N)
        SBC = SQRT(XBC**2 + YBC**2)
C
        IF(XTR1(IS) .GT. 0.0) THEN
C
          SB1 = SBLE(N)
          XB1 = SEVAL(SB1,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
          YB1 = SEVAL(SB1,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          CB1 = ((XB1-XBNOSE(N))*XBC + (YB1-YBNOSE(N))*YBC)/SBC**2
          XI1 = XI(ILE,IS)
C
C-------- set arc length value of forced transition point
          DO 10 I=ILE+1, ITE
            IG = I-ILE+1
            SB2 = SBLE(N) + SBSIDE*SG(IG,IS)
            XB2 = SEVAL(SB2,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YB2 = SEVAL(SB2,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
            CB2 = ((XB2-XBNOSE(N))*XBC + (YB2-YBNOSE(N))*YBC)/SBC**2
            XI2 = XI(I,IS)
C
            IF(XTR1(IS).GT.CB1 .AND. XTR1(IS).LE.CB2) THEN
             XIFORC(IS) = XI1 + (XI2-XI1) * (XTR1(IS)-CB1)/(CB2-CB1)
             GO TO 20
            ENDIF
            CB1 = CB2
            XI1 = XI2
   10     CONTINUE
          IF(XTR1(IS).GE.CB2) XIFORC(IS) = XI2
C
C-------- transition must occur at TE at the latest
   20     XIFORC(IS) = MIN( XIFORC(IS) , XI(ITE,IS) )
C
        ELSE
C
          XIFORC(IS) = ABS(XTR1(IS)) * ABS(SBSIDE)
C
        ENDIF
C
C------ transition must occur at a corner at the latest
        IF(IGCORN(IS) .NE. 0) THEN
         SGC = SG(IGCORN(IS),IS)
         XIFORC(IS) = MIN( XIFORC(IS) , SGC*ABS(SBSIDE) )
        ENDIF
C
C------ transition must occur just after stagnation point at the earliest
        XIFORC(IS) = MAX(XIFORC(IS) , 0.5*(XI(ILE+1,IS)+XI(ILE+2,IS)))
C
  100 CONTINUE
C
      RETURN
      END ! XIFSET
 
 
      SUBROUTINE TRCHEK(I,IS,AMI)
C----------------------------------------------------------------
C     New second-order version:  December 1994.
C
C     Checks if transition occurs in the current interval X1..X2.
C     If transition occurs, then set transition location XT, and 
C     its sensitivities to "1" and "2" variables.  If no transition, 
C     set amplification AMPL2.
C
C
C     Solves the implicit amplification equation for N2:
C
C       N2 - N1     N'(XT,NT) + N'(X1,N1)
C       -------  =  ---------------------
C       X2 - X1               2
C
C     In effect, a 2-point central difference is used between
C     X1..X2 (no transition), or X1..XT (transition).  The switch
C     is done by defining XT,NT in the equation above depending
C     on whether N2 exceeds Ncrit.
C
C  If N2<Ncrit:  NT=N2    , XT=X2                  (no transition)
C
C  If N2>Ncrit:  NT=Ncrit , XT=(Ncrit-N1)/(N2-N1)  (transition)
C
C
C----------------------------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'MBL.INC'
      LOGICAL TRFORC,TRFREE
C
c###
      DATA DAEPS / 1.0E-5 /
c      DATA DAEPS / 1.0D-12 /
C
C---- recall "1" and "2" variables
      DO 10 NC=1, NCOM
        COM1(NC) = V1SAV(NC,IS)
        COM2(NC) = V2SAV(NC,IS)
   10 CONTINUE
C
C---- calculate average amplification rate AX over X1..X2 interval
      CALL AXSET( HK1,    T1,    RT1, AMPL1,
     &            HK2,    T2,    RT2, AMPL2, AMCRIT,
     &     AX, AX_HK1, AX_T1, AX_RT1, AX_A1,
     &         AX_HK2, AX_T2, AX_RT2, AX_A2, AX_NC )
C
C---- set initial guess for iterate N2 (AMPL2) at X2
      AMPL2 = AMPL1 + AX*(X2-X1)
C
C---- solve implicit system for amplification AMPL2
      DO 100 ITAM=1, 25
C
C---- define weighting factors WF1,WF2 for defining "T" quantities from 1,2
      IF(AMPL2 .LE. AMCRIT) THEN
C------ there is no transition yet,  "T" is the same as "2"
        AMPLT    = AMPL2
        AMPLT_A2 = 1.0
        AMPLT_NC = 0.
        SFA    = 1.0
        SFA_A1 = 0.
        SFA_A2 = 0.
        SFA_NC = 0.
      ELSE
C------ there is transition in X1..X2, "T" is set from N1, N2
        AMPLT    = AMCRIT
        AMPLT_A2 = 0.
        AMPLT_NC = 1.0
        SFA    = (AMCRIT - AMPL1)/(AMPL2-AMPL1)
        SFA_A1 = ( SFA   - 1.0  )/(AMPL2-AMPL1)
        SFA_A2 = (       - SFA  )/(AMPL2-AMPL1)
        SFA_NC =  1.0            /(AMPL2-AMPL1)
      ENDIF
C
      IF(XIFORC(IS).LE.X2) THEN
        SFX    = (XIFORC(IS)-X1 )/(X2-X1)
        SFX_X1 = (SFX       -1.0)/(X2-X1)
        SFX_X2 =            -SFX /(X2-X1)
        SFX_XF =  1.0            /(X2-X1)
      ELSE
        SFX    = 1.0
        SFX_X1 = 0.
        SFX_X2 = 0.
        SFX_XF = 0.
      ENDIF
C
C---- set weighting factor from free or forced transition
      IF(SFA.LT.SFX) THEN
        WF2    = SFA
        WF2_A1 = SFA_A1
        WF2_A2 = SFA_A2
        WF2_NC = SFA_NC
        WF2_X1 = 0.
        WF2_X2 = 0.
        WF2_XF = 0.
      ELSE
        WF2    = SFX
        WF2_A1 = 0.
        WF2_A2 = 0.
        WF2_NC = 0.
        WF2_X1 = SFX_X1
        WF2_X2 = SFX_X2
        WF2_XF = SFX_XF
      ENDIF
C
C=====================
CC---- 1st-order (based on "1" quantites only, for testing)
C      WF2    = 0.0
C      WF2_A1 = 0.0
C      WF2_A2 = 0.0
C      WF2_NC = 0.0
C      WF2_X1 = 0.0
C      WF2_X2 = 0.0
C      WF2_XF = 0.0
C=====================
C
      WF1    = 1.0 - WF2
      WF1_A1 =     - WF2_A1
      WF1_A2 =     - WF2_A2
      WF1_NC =     - WF2_NC
      WF1_X1 =     - WF2_X1
      WF1_X2 =     - WF2_X2
      WF1_XF =     - WF2_XF
C
C---- interpolate BL variables to XT
      XT    = X1*WF1    + X2*WF2
      TT    = T1*WF1    + T2*WF2
      DT    = D1*WF1    + D2*WF2
      UT    = U1*WF1    + U2*WF2
      RT    = R1*WF1    + R2*WF2
C
      XT_A2 = X1*WF1_A2 + X2*WF2_A2
      TT_A2 = T1*WF1_A2 + T2*WF2_A2
      DT_A2 = D1*WF1_A2 + D2*WF2_A2
      UT_A2 = U1*WF1_A2 + U2*WF2_A2
      RT_A2 = R1*WF1_A2 + R2*WF2_A2
C
C---- calculate laminar secondary "T" variables HKT, RTT
      AMSAVE = AMPL2
      CALL SETKIN(XT,0.0,0.0,UT,TT,DT,0.0,0.0,RT)
C
      HKT    = HK2
      HKT_TT = HK2_T2
      HKT_DT = HK2_D2
      HKT_UT = HK2_U2
C
      RTT    = RT2
      RTT_TT = RT2_T2
      RTT_UT = RT2_U2
      RTT_RT = RT2_R2
      RTT_RE = RT2_RE
C
C---- restore clobbered "2" variables, except for AMPL2
      DO 12 NC=1, NCOM
        COM2(NC) = V2SAV(NC,IS)
 12   CONTINUE
      AMPL2 = AMSAVE
C
C---- calculate amplification rate AX over current X1-XT interval
      CALL AXSET( HK1,    T1,    RT1, AMPL1,
     &            HKT,    TT,    RTT, AMPLT, AMCRIT,
     &     AX, AX_HK1, AX_T1, AX_RT1, AX_A1,
     &         AX_HKT, AX_TT, AX_RTT, AX_AT, AX_NC )
C
C---- punch out early if there is no amplification here
      IF(AX .LE. 0.0) GO TO 101
C
C---- set sensitivity of AX(A2)
      AX_A2 = (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_A2
     &      + (AX_HKT*HKT_DT                        )*DT_A2
     &      + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_A2
     &      + (                        AX_RTT*RTT_RT)*RT_A2
     &      +  AX_AT                                 *AMPLT_A2
C
C---- residual for implicit AMPL2 definition (amplification equation)
      RES    = AMPL2 - AMPL1 - AX   *(X2-X1) 
      RES_A2 = 1.0           - AX_A2*(X2-X1)
C
      DA2 = -RES/RES_A2
C
C---- check if converged
      IF(ABS(DA2) .LT. DAEPS) GO TO 101
C
C
      IF((AMPL2.GT.AMCRIT .AND. AMPL2+DA2.LT.AMCRIT).OR.
     &   (AMPL2.LT.AMCRIT .AND. AMPL2+DA2.GT.AMCRIT)    ) THEN
C------ limited Newton step so AMPL2 doesn't step across AMCRIT either way
        AMPL2 = AMCRIT
      ELSE
C------ regular Newton step
        AMPL2 = AMPL2 + DA2
      ENDIF
C
 100  CONTINUE
      WRITE(*,*) 'TRCHEK: N2 convergence failed.'
      WRITE(*,6700) X1, XT, X2, AMPL1, AMPLT, AMPL2, AX, DA2
 6700 FORMAT(1X,'x:', 3F9.5,'  N:',3F7.3,'  Nx:',F8.3,'   dN:',E10.3)
C
 101  CONTINUE
C
C---- pass converged amplification back to calling routine
      AMI = AMPL2
C
C---- test for free or forced transition
      TRFREE = AMPL2 .GE. AMCRIT
      TRFORC = XIFORC(IS).GT.X1 .AND. XIFORC(IS).LE.X2
C
C---- set transition interval flag
      TRAN(IS) = TRFORC .OR. TRFREE
C
      IF(.NOT.TRAN(IS)) RETURN
C
C---- resolve if both forced and free transition
      IF(TRFREE .AND. TRFORC) THEN
       TRFORC = SFA .GE. SFX
       TRFREE = SFA .LT. SFX
      ENDIF
C
      IF(TRFORC) THEN
C----- if forced transition, then XT is prescribed
C
       XT = XIFORC(IS)
       XT_A1 = 0.
       XT_X1 = 0.
       XT_T1 = 0.
       XT_D1 = 0.
       XT_U1 = 0.
       XT_R1 = 0.
C
       XT_X2 = 0.
       XT_T2 = 0.
       XT_D2 = 0.
       XT_U2 = 0.
       XT_R2 = 0.
C
       XT_RE = 0.
       XT_NC = 0.
       XT_XF = 1.0
C
      ELSE
C
C----- free transition ... set sensitivities of XT
C
C----- XT( X1 X2 A1 A2 NC ),  TT( T1 T2 A1 A2 NC X1 X2 XF ),   DT( ...
CC     XT    = X1*WF1    + X2*WF2
CC     TT    = T1*WF1    + T2*WF2
CC     DT    = D1*WF1    + D2*WF2
CC     UT    = U1*WF1    + U2*WF2
CC     RT    = R1*WF1    + R2*WF2
C
       XT_X1 =    WF1
       TT_T1 =    WF1
       DT_D1 =    WF1
       UT_U1 =    WF1
       RT_R1 =    WF1
C
       XT_X2  =               WF2
       TT_T2  =               WF2
       DT_D2  =               WF2
       UT_U2  =               WF2
       RT_R2  =               WF2
C
       XT_A1 = X1*WF1_A1 + X2*WF2_A1
       TT_A1 = T1*WF1_A1 + T2*WF2_A1
       DT_A1 = D1*WF1_A1 + D2*WF2_A1
       UT_A1 = U1*WF1_A1 + U2*WF2_A1
       RT_A1 = R1*WF1_A1 + R2*WF2_A1
C
CC     XT_A2 = X1*WF1_A2 + X2*WF2_A2
CC     TT_A2 = T1*WF1_A2 + T2*WF2_A2
CC     DT_A2 = D1*WF1_A2 + D2*WF2_A2
CC     UT_A2 = U1*WF1_A2 + U2*WF2_A2
CC     RT_A2 = R1*WF1_A2 + R2*WF2_A2
C
       XT_NC = X1*WF1_NC + X2*WF2_NC
       TT_NC = T1*WF1_NC + T2*WF2_NC
       DT_NC = D1*WF1_NC + D2*WF2_NC
       UT_NC = U1*WF1_NC + U2*WF2_NC
       RT_NC = R1*WF1_NC + R2*WF2_NC
C
       XT_X1 = X1*WF1_X1 + X2*WF2_X1 + XT_X1
       TT_X1 = T1*WF1_X1 + T2*WF2_X1
       DT_X1 = D1*WF1_X1 + D2*WF2_X1
       UT_X1 = U1*WF1_X1 + U2*WF2_X1
       RT_X1 = R1*WF1_X1 + R2*WF2_X1
C
       XT_X2 = X1*WF1_X2 + X2*WF2_X2 + XT_X2
       TT_X2 = T1*WF1_X2 + T2*WF2_X2
       DT_X2 = D1*WF1_X2 + D2*WF2_X2
       UT_X2 = U1*WF1_X2 + U2*WF2_X2
       RT_X2 = R1*WF1_X2 + R2*WF2_X2
C
       XT_XF = X1*WF1_XF + X2*WF2_XF
       TT_XF = T1*WF1_XF + T2*WF2_XF
       DT_XF = D1*WF1_XF + D2*WF2_XF
       UT_XF = U1*WF1_XF + U2*WF2_XF
       RT_XF = R1*WF1_XF + R2*WF2_XF
C
C----- at this point, AX = AX( HK1, T1, RT1, A1, HKT, TT, RTT, AT, NC )
C
C----- set sensitivities of AX( T1 D1 U1 A1 T2 D2 U2 A2 MS RE )
       AX_T1 =  AX_HK1*HK1_T1 + AX_T1 + AX_RT1*RT1_T1
     &       + (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_T1
       AX_D1 =  AX_HK1*HK1_D1
     &       + (AX_HKT*HKT_DT                        )*DT_D1
       AX_U1 =  AX_HK1*HK1_U1         + AX_RT1*RT1_U1
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_U1
       AX_R1 =                          AX_RT1*RT1_R1
     &       + (                        AX_RTT*RTT_RT)*RT_R1
       AX_A1 =  AX_A1
     &       + (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_A1
     &       + (AX_HKT*HKT_DT                        )*DT_A1
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_A1
     &       + (                        AX_RTT*RTT_RT)*RT_A1
       AX_X1 = (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_X1
     &       + (AX_HKT*HKT_DT                        )*DT_X1
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_X1
     &       + (                        AX_RTT*RTT_RT)*RT_X1
C
       AX_T2 = (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_T2
       AX_D2 = (AX_HKT*HKT_DT                        )*DT_D2
       AX_U2 = (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_U2
       AX_R2 = (                        AX_RTT*RTT_RT)*RT_R2
       AX_A2 =  AX_AT                                 *AMPLT_A2
     &       + (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_A2
     &       + (AX_HKT*HKT_DT                        )*DT_A2
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_A2
     &       + (                        AX_RTT*RTT_RT)*RT_A2
       AX_X2 = (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_X2
     &       + (AX_HKT*HKT_DT                        )*DT_X2
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_X2
     &       + (                        AX_RTT*RTT_RT)*RT_X2
C
       AX_XF = (AX_HKT*HKT_TT + AX_TT + AX_RTT*RTT_TT)*TT_XF
     &       + (AX_HKT*HKT_DT                        )*DT_XF
     &       + (AX_HKT*HKT_UT         + AX_RTT*RTT_UT)*UT_XF
     &       + (                        AX_RTT*RTT_RT)*RT_XF
       AX_RE =                          AX_RTT*RTT_RE
     &                                + AX_RT1*RT1_RE
       AX_NC =  AX_NC
     &       +  AX_AT                                 *AMPLT_NC
C
C----- set sensitivities of residual RES
CCC    RES  = AMPL2 - AMPL1 - AX*(X2-X1)
       Z_AX =               -    (X2-X1)
C
       Z_A1 = Z_AX*AX_A1 - 1.0
       Z_T1 = Z_AX*AX_T1
       Z_D1 = Z_AX*AX_D1
       Z_U1 = Z_AX*AX_U1
       Z_R1 = Z_AX*AX_R1
       Z_X1 = Z_AX*AX_X1 + AX
C
       Z_A2 = Z_AX*AX_A2 + 1.0
       Z_T2 = Z_AX*AX_T2
       Z_D2 = Z_AX*AX_D2
       Z_U2 = Z_AX*AX_U2
       Z_R2 = Z_AX*AX_R2
       Z_X2 = Z_AX*AX_X2 - AX
C
       Z_XF = Z_AX*AX_XF
       Z_RE = Z_AX*AX_RE
       Z_NC = Z_AX*AX_NC
C
C----- set sensitivities of XT, with RES being stationary for A2 constraint
       XT_A1 = XT_A1 - (XT_A2/Z_A2)*Z_A1
       XT_T1 =       - (XT_A2/Z_A2)*Z_T1
       XT_D1 =       - (XT_A2/Z_A2)*Z_D1
       XT_U1 =       - (XT_A2/Z_A2)*Z_U1
       XT_R1 =       - (XT_A2/Z_A2)*Z_R1
       XT_X1 = XT_X1 - (XT_A2/Z_A2)*Z_X1
       XT_T2 =       - (XT_A2/Z_A2)*Z_T2
       XT_D2 =       - (XT_A2/Z_A2)*Z_D2
       XT_U2 =       - (XT_A2/Z_A2)*Z_U2
       XT_R2 =       - (XT_A2/Z_A2)*Z_R2
       XT_X2 = XT_X2 - (XT_A2/Z_A2)*Z_X2
       XT_RE =       - (XT_A2/Z_A2)*Z_RE
       XT_NC = XT_NC - (XT_A2/Z_A2)*Z_NC
       XT_XF = 0.0
C
      ENDIF
C
C---- save transition location XT and sensitivities for later setup
      DO 40 NC=1, NCOMA
        VASAV(NC,IS) = COMA(NC)
   40 CONTINUE
C
C---- save transition location info
      ITRAN(IS) = I
      TFORCE(IS) = TRFORC
      XITRAN(IS) = XT
C
      RETURN
      END ! TRCHEK



      SUBROUTINE DSLIM(DSTR,THET,UEDG,MSQ,GAM,HKLIM)
      IMPLICIT REAL (A-H,M,O-Z)
C
      H = DSTR/THET
      CALL HKIN(H,MSQ,GAM,HK,HK_H,HK_M)
C
      DH = MAX( 0.0 , HKLIM-HK ) / HK_H
      DSTR = DSTR + DH*THET
C
      RETURN
      END

