C
      PROGRAM MSES
C----------------------------------------------------
C                                                    |
C     Multi-Element Airfoil Design/Analysis System   |
C                                                    |
C         Mark Drela                                 |
C         MIT Aero & Astro                           |
C                                                    |
C     Copyright MIT  1991                            |
C                                                    |
C     May not be used for commercial purposes        |
C     without license from:                          |
C                                                    |
C     MIT Technology Licensing Office.               |
C           (617) 253-6966                           |
C                                                    |
C     Academic use unrestricted with verbal          |
C     permission from Mark Drela: (617) 253-0067     |
C                                                    |
C----------------------------------------------------
C     
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      LOGICAL LSOLVE, LITARG, LOK, LCPU
      CHARACTER*80 ARGP2
C
      INCLUDE 'EPS.INC'
C
C---- display CPU time?
ccc   DATA LCPU / .TRUE.  /
      DATA LCPU / .FALSE. /
C
 1000 FORMAT(A)
C
C---- read in state vector from MDAT.xxx
      CALL INPUT
C
C---- initialize everything and display run info
      CALL INIT
      LSOLVE = .FALSE.
C
      ARGP2(1:1) = ' '
      CALL GETARG(2,ARGP2)
C
C---- is # of iterations a command-line argument?
      LITARG = ARGP2(1:1) .NE. ' '
C
 10   CONTINUE
C
      IF(NHALF.LT.0) WRITE(*,1010) -NHALF
      IF(NHALF.GT.0) WRITE(*,1020)  NHALF
 1010 FORMAT(/1X,'Solution is currently coarsened', I3,'  levels')
 1020 FORMAT(/1X,'Solution is currently refined'  , I3,'  levels')
C
      IF(LITARG) THEN
        READ(ARGP2,*) NITER1
        WRITE(*,1110) IABS(NITER1)
 1110   FORMAT(/1X,I3,' Newton iterations will be performed')
      ELSE
 20     WRITE(*,1120)
 1120   FORMAT(/' Enter number of iterations (+refine / -coarsen): ',$)
        READ(*,1000) ARGP2
      ENDIF
C
      KMNUS = INDEX(ARGP2,'-')
      KPLUS = INDEX(ARGP2,'+')
C
      IF(KMNUS.NE.0) THEN
C------ coarsen grid if possible
        WRITE(*,*)
        CALL HALVE(LOK)
        IF(LOK) THEN
          NHALF = NHALF - 1
          CALL INDINI
          CALL XYSINI
        ENDIF
C------ remove minus sign from input string
        ARGP2(KMNUS:KMNUS) = ' '
      ENDIF
C
      IF(KPLUS.NE.0) THEN
C------ refine grid if possible
        CALL DOUBLE(LOK)
        IF(LOK) THEN
          NHALF = NHALF + 1
          CALL INDINI
          CALL XYSINI
        ENDIF
C------ remove plus sign from input string
        ARGP2(KPLUS:KPLUS) = ' '
      ENDIF
C
C---- read number of iterations from input string (should get ERR if no number)
      NITER1 = -99999
      READ(ARGP2,*,ERR=10,END=10) NITER1
      IF(NITER1.EQ.-99999) GO TO 10
C
      NITER1 = IABS(NITER1)
C
C---- first assume actual # of iterations = requested # of iterations
      NITER = NITER1
C
C---- main Newton loop
      DO 40 ITER=1, NITER1
        ICOUNT = ICOUNT + 1
C
        IF(LCPU) t0 = second()
C
C------ set up mass fraction arrays
        CALL MFCALC
C
C------ calculate grid movement direction vectors at all grid nodes
        CALL NCALC
C
C------ calculate unit vectors for displacement thickness offsetting
        CALL BLNORM
C
C------ set geometry sensitivities
        CALL GEOSEN
C
C------ set geometric shape modes
        IF(LMODI .OR. LMINV) THEN
           CALL GNSET
        ENDIF
C
C------ set element position modes and linearize grid spacing arrays
        IF(LPOSI) THEN
         CALL PNSET
         CALL SGLIN
        ENDIF
C
C------ calculate residuals and Jacobian entries at all interior nodes
        CALL SETUP
C
        IF(LCPU) t1 = second()
c
C------ first iteration is inviscid 
ccc        LVISC = REYNIN.GT.0.0 .AND. ICOUNT.GT.1
        LVISC = REYNIN.GT.0.0
C
C------ calculate BL residuals & Jacobians, and combine with main system
        IF(LVISC) CALL SETBL
C
C------ calculate BC residuals & Jacobians, and combine with main system
        CALL SETBC
C
ccc        call linchk3(6)
ccc        call linchk4(6)

cc        CALL SHORES(6)
c
        IF(LCPU) t2 = second()
        IF(LCPU) write(*,*) 'CPU seconds for SETUP = ', t1 - t0
        IF(LCPU) write(*,*) 'CPU seconds for SETBL = ', t2 - t1
c
C------ solve main Newton system
        CALL SOLVE
        LSOLVE = .TRUE.
C
cc        CALL SHORES(6)

        IF(LCPU) t3 = second()
        IF(LCPU) write(*,*) 'CPU seconds for SOLVE = ', t3 - t2
C
C------ update all variables
        CALL UPDATE(.TRUE.)
C
C------ fix up grid if necessary, and reconverge
        IF(LSMOVE) THEN
         CALL SMOVE(-4,AINF,0.4*RHOINF)
         NITER = NITER1
         GO TO 40
        ENDIF
C
C------ set convergence flag
        LCONV = DRRMS  .LT. EPSR      .AND.
     &          DVRMS  .LT. EPSV      .AND.
     &      ABS(DRMAX) .LT. EPSR*10.0 .AND.
     &      ABS(DVMAX) .LT. EPSV*10.0
C
        IF(ISSET.EQ.2 .AND. LCONV) THEN
C-------- also check node movement for MSIS
          LCONV = DNRMS  .LT. EPSN      .AND.
     &        ABS(DNMAX) .LT. EPSN*10.0
        ENDIF
C
cC------ double-precision tolerances
c        LCONV = DRRMS  .LT. 0.000000001*EPSR      .AND.
c     &          DVRMS  .LT. 0.000000001*EPSV      .AND.
c     &      ABS(DRMAX) .LT. 0.000000001*EPSR*10.0 .AND.
c     &      ABS(DVMAX) .LT. 0.000000001*EPSV*10.0
C
C------ check for early exit
        IF(ITER .GE. IABS(NITER)) GO TO 41
C
        IF(LCONV) THEN
          WRITE(*,*) 'Converged on tolerance'
C
          IF(LMODI .OR. LPOSI) THEN
C---------- Optimization case: do one more iteration to get sentivities
C-          (Note: if ITER>=NITER, then SOLVE inverts all righthand sides)
            NITER = ISIGN( ITER+1 , NITER1 )
          ELSE
C---------- Normal case: exit immediately
            GO TO 41
          ENDIF
C
        ENDIF
C
 40   CONTINUE
 41   CONTINUE
C
C---- go ask user for new number of iterations?
      IF(.NOT.LITARG .AND. NITER1.NE.0) GO TO 10
C
C
C---- if RHS's are available ...
      IF(LSOLVE) THEN
C
C------ calculate lift, drag, and sensitivities to global DOFs
        CALL GLOSEN
C
        IF(LMODI .OR. LPOSI) THEN
C
C-------- save total sensitivities to unformatted file
          CALL SNWRIT(0)
C
        ENDIF
C
      ELSE
C
C------ just set final Lift, Drag, etc.
        CALL LCALC
        CALL DVCALC
        CALL DWCALC
C
      ENDIF

C---- write out state vector to MDAT.xxx
      CALL OUTPUT
C
      STOP
      END ! MSES


      SUBROUTINE SHORES(LUN)
C-----------------------------------------------
C     Dumps residuals to unit LUN in an 
C     organized fashion for debugging purposes.
C-----------------------------------------------
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
C
      N = 1
C
      ILE = ILEB(N)
      ITE = ITEB(N)
C
c      WT = 1000.0
c      DO 5 I=ITE, II-1
c        WRITE(LUN,*) ' '
c        WRITE(LUN,1000) 
c     &   I, WT*THET(I,1),WT*DSTR(I,1),WT*DISP(I,1),UEDG(I,1)
c        WRITE(LUN,1000) 
c     &   I, WT*THET(I,2),WT*DSTR(I,2),WT*DISP(I,2),UEDG(I,2)
c 1000   FORMAT(1X,I4, 5F13.8)
c    5 CONTINUE
C
      WRITE(LUN,*) ' '
      WRITE(LUN,*) ILE, ITE
      DO 10 I=1, II
ccc      DO 10 I=ile-3, ite+5
ccc      do 10 i = 117, 120
CCC        IF(I.LT.ILE-1) GO TO 10
CCC        IF(I.GT.ILE+1 .AND. I.LT.ITE-3) GO TO 10
c        itr = itran(1)
c        if(.not.(i.ge.ile-3 .and. i.le.ile+3) .and.
c     &     .not.(i.ge.itr-3 .and. i.le.itr+3)) go to 10

        WRITE(LUN,*)
c        A8(JJ,I) = 1.0
        L = 1
        DO 100 J=1, JJ
          anorm = max( abs(a2(j,i))
     &               , abs(b2(j,i))
     &               , abs(c2(j,i)) )
          WRITE(LUN,1010) I,J, DR(J,L,I), DR(J+JJ,L,I)
cc     &            , q(i,j)/qstar
 1010     FORMAT(1X,2I4,2f16.10, 2E12.4, 2x, f7.3)
c          write(*,1010) i, j, a2(j,i), a8(j,i), dr(j,1,i)
c
c          WRITE(*,*) I,J, DR(J,4,I), DR(J,5,I)
c 1012     FORMAT(1x,2I4,2e13.4)
  100   CONTINUE
c        J = JS1(N)
c        WRITE(LUN,*) J+2, I, A2(J+2,I), DR(J+2,1,I), DR(J+2+JJ,1,I)
c        WRITE(LUN,*) J+1, I, A2(J+1,I), DR(J+1,1,I), DR(J+1+JJ,1,I)
c        WRITE(LUN,*) J  , I, A2(J  ,I), DR(J  ,1,I), DR(J  +JJ,1,I)
c        J = JS2(N)
c        WRITE(LUN,*) J  , I, A2(J  ,I), DR(J  ,1,I), DR(J-1+JJ,1,I)
c        WRITE(LUN,*) J-1, I, A2(J-1,I), DR(J-1,1,I), DR(J-2+JJ,1,I)
c        WRITE(LUN,*) J-2, I, A2(J-2,I), DR(J-2,1,I), DR(J-3+JJ,1,I)
        do n=1, nbl
        IS = 2*N-1
        WRITE(LUN,1110) I,DR(2*JJ  ,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+1,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+2,L,I)
        IS = 2*N          
        WRITE(LUN,1110) I,DR(2*JJ+3,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+4,L,I)
        WRITE(LUN,1110) I,DR(2*JJ+5,L,I)
 1110   FORMAT(1X,I4,F16.10,E13.4)
        enddo
c
c        is = 0
c        DO 110 J=2*JJ, 2*JJ+6*NBL-3, 3
c          is = is+1
c          shp = 0.0
c          if(thet(i,is) .ne. 0.0) shp = dstr(i,is)/thet(i,is)
c          WRITE(LUN,1210) i, DR(J,1,I),DR(J+1,1,I),DR(J+2,1,I)
c 1210     FORMAT(1X, I4, 3f14.7, 3E12.4, 2x, f8.4)
c  110   CONTINUE
c
   10 CONTINUE
C
      RETURN
      END

