C
      PROGRAM MSET
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      LOGICAL YES,OVER, LFLOW,LGRID,LSMOO,LSAVE, ERROR
      CHARACTER*1 ANS
      DIMENSION CLEL(NBX),CDEL(NBX),CMEL(NBX)
C
 1001 FORMAT(A)
C
C---- initialize everything
      CALL INIT
C
C---- set grid generation default parameters
      CALL DEFPAR
      DSINIT = .FALSE.
C
C---- read in airfoil coordinates
      CALL READAI
C
C---- try to read parameters from file, if one can be found
      CALL GETPAR
C
      LFLOW = .FALSE.
      LGRID = .FALSE.
      LSMOO = .FALSE.
C
      LSAVE = .TRUE.
C
C---- set airfoil quantities
      AINF = YBTOP - YBBOT
C
C---- set paneling parameters for panel solution
      CHRDMX = 0.0
      DO N=1, NBL
        CHRDMX = MAX( CHRDMX , CHRD(N) )
      ENDDO
C
      DO N=1, NBL
        NPAN(N) = 60 * (CHRD(N)/CHRDMX)**0.333
        CVPAR(N) = 1.5
        CTERAT(N) = 0.2
      ENDDO
C
C---- generate panel solution for alpha=0,90 degrees
      CALL PANGEN(IBX,XB,XPB,YB,YPB,SB,IIB,NBL,NPAN,CVPAR,CTERAT)
      ALFA = 0.0
      CALL PANSOL(ALFA,IFFTYP)
C
C---- set aerodynamic center x,y and initialize doublets for MSES farfield
      CALL VCENT(XCENT,YCENT,DOUX,DOUY)
C
      IF(ALFGEN .NE. 999.0) THEN
       WRITE(*,*)
       WRITE(*,*) 'Using default alpha ...'
       GO TO 11
      ENDIF
C
  900 WRITE(*,1005)
 1005 FORMAT(/
     &       /'  0  Exit '
     &       /'  1  Specify alpha and generate streamlines'
     &       /'  2  Generate spacing and initialize grid' 
     &       /'  3  Elliptic grid smoother'
     &       /'  4  Write  mdat.xxx'
     &       /'  5  Plot grid'   
     &       /'  6  Plot Cp vs x/c'
     &       /'  7  Modify grid parameters'
     &       /'  8  Write  grid parameters to gridpar.xxx'
     &       /'  9  Change plot size'
     &       /' 11  Zoom'
     &       /' 12  Unzoom'
     &      //' Select grid generation option:  ', $)
      READ(*,*,ERR=900) NOPT 
C
      IF(NOPT.EQ.0) THEN
       IF(.NOT.LSAVE) THEN
        WRITE(*,*) 'mdat.xxx not saved.  Really quit ?  Y'
        READ (*,1001) ANS
        IF(ANS .EQ. 'N' .OR. ANS .EQ. 'n') GO TO 900
       ENDIF
C
       CALL PLOT(0.0,0.0,+999)
       STOP
      ENDIF
C
CCC      IF (NOPT.GT.1 .AND. .NOT.LGRID) GO TO 900
C
C**** Do different grid generation options
C
      GO TO (10,20,30,40,50,60,70,80,90,900,110,120), NOPT
      GO TO 900
C
C======================================================================
   10 WRITE(*,1010) ALFGEN
 1010 FORMAT(/' Enter new alpha (deg):', F9.3)
      CALL READR(1,ALFGEN,ERROR)
      IF(ERROR) GO TO 10
C
C---- pick up here with default alpha
   11 CONTINUE
C
      ALFA = ALFGEN*PIE/180.0
      IF(ALFGEN .EQ. 999.0) ALFA = 0.0
C
      CALL ALSET(ALFA)
      AMINF = 0.0
C
      CALL CLCALC(CL,CL_ALF,CM,AMINF,CLEL,CDEL,CMEL)
C
      WRITE(*,1020) ALFA*180.0/PIE, CL
 1020 FORMAT(/ ' alpha =', F7.3, '    CL =', F8.4 /)
C
C---- set MSES circulation variable from panel solver CL (units of length)
      CIRC = 0.5*CL
C
C---- set airfoil extrema
      COSA = COS(ALFA)
      SINA = SIN(ALFA)
      N = 1
      XLEMIN = XBNOSE(N)*COSA + YBNOSE(N)*SINA
      XTEMAX = XBTAIL(N)*COSA + YBTAIL(N)*SINA
      YLEMIN = YBNOSE(N)*COSA - XBNOSE(N)*SINA
      YLEMAX = YBNOSE(N)*COSA - XBNOSE(N)*SINA
      CHDSUM = CHRD(N)
      DO 12 N=2, NBL
        XLEMIN = MIN( XBNOSE(N)*COSA + YBNOSE(N)*SINA , XLEMIN )
        XTEMAX = MAX( XBTAIL(N)*COSA + YBTAIL(N)*SINA , XTEMAX )
        YLEMIN = MIN( YBNOSE(N)*COSA - XBNOSE(N)*SINA , YLEMIN )
        YLEMAX = MAX( YBNOSE(N)*COSA - XBNOSE(N)*SINA , YLEMAX )
        CHDSUM = CHRD(N) + CHDSUM
 12   CONTINUE
C
C---- set potential at domain inlet, outlet planes
      PHIINL = XBINL - 0.25*CIRC - CIRPHI*ABS(CIRC)/6.28
      PHIOUT = XBOUT + 0.25*CIRC
C
C---- set streamfunction at bottom, top streamlines
      PSIBOT = YBBOT
      PSITOP = YBTOP
C
C---- calculate streamlines attached to LE,TE, and top and bottom of domain
      CALL STRGEN(ISTX,NST,ISTLE,ISTTE,XST,YST,PHIST,PSIST,
     &            PHIINL,PHIOUT,PSIBOT,PSITOP,PHIEND)
C
C---- make sure elements are stacked in order (streamfunction is monotonic)
      DO 13 IS=2, 2*(NBL-1), 2
        IF(PSIST(IS) .LT. PSIST(IS+2)) THEN
          WRITE(*,1310) IS/2, IS/2+1
 1310     FORMAT(/' ***  WARNING  ***'
     &           /' Incorrect element ordering'
     &           /' Element',I2,' is below element',I2)
        ENDIF
 13   CONTINUE
C
C---- spline streamlines
      DO 18 IS=1, 2*NBL+2
        CALL SCALC(XST(1,IS),YST(1,IS),SST(1,IS),NST(IS))
        CALL SEGSPL(XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
        CALL SEGSPL(YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
        CALL SEGSPL(PHIST(1,IS),QST(1,IS),SST(1,IS),NST(IS))
   18 CONTINUE

c      do is = 1, 2*nbl
c        write(*,*) is
c        lu = 10 + (is+1)/2
c        write(lu,9922) '# ', is
c 9921   format(a)
c 9922   format(a,i5)
c        do ist = 1, nst(is)
c          write(lu,*) xst(ist,is), yst(ist,is), 
c     &               sst(ist,is), phist(ist,is), qst(ist,is)
c        enddo
c        if(is.lt.2*nbl) write(lu,9921)
c      enddo

C
C---- calculate iso-potential lines at LE, TE, and inlet and outlet of domain
      CALL NORGEN(ISTX,NST,ISTLE,ISTTE,
     &            XST,YST,SST,XSTP,YSTP,PHIST,PSIST,
     &            PHIINL,PHIEND,
     &            KSX,NLIN,SSTL,ISOR,LEOR)
      CALL NORLIN
      CALL STRPLT
C
      LFLOW = .TRUE.
      GO TO 900
C
C
C======================================================================
   20 CONTINUE
C
      IF(.NOT.LFLOW) THEN
       WRITE(*,*) '***  Specify alpha first'
       GO TO 900
      ENDIF
C
C---- reset zooming parameters if necessary
      CALL CLRZOOM
C
C---- set initial streamline node distributions
      CALL SGINIT
C
C---- adjust node distributions to make adjacent element spacings compatible
      CALL SGFUDG
C
C---- set final inlet, surface, and outlet spacing arrays
      CALL SGIBO
C
C---- set corners and fudge surface point positions slightly
      CALL SETCRN
C
C---- set "fixed" points which won't be allowed to slide along surface
      CALL SETSGF
C
C---- plot streamline spacing distribution
ccc      CALL SPCPLT
C
C---- set streamfunction increments over streamtubes adjacent to elements
      CALL LEDPSI(IBX,XB,XPB,YB,YPB,SB,IIB,SBLE, IX,SG,DPSILE,CELLAR)
C
C---- set y-spacing array YPOS
      CALL YPSET(OVER)
C
      WRITE(*,2010) JJ, JX
 2010 FORMAT(/' Number of streamlines :', I4, '  ( max:',I4,' )' )
C
C---- handle array overflow
      IF(OVER) THEN
       WRITE(*,*)
       WRITE(*,*) '***  Number of streamlines exceeds array size'
       WRITE(*,*) '***  Grid not generated'
       GO TO 900
      ENDIF
C
C---- set wake lengths
      DO 22 N=1, NBL
        SWAK(N) = STOUT(N)
   22 CONTINUE
C
C---- Interpolate nodes on grid outline and in the interior 
      CALL NODES(OVER)
C
      WRITE(*,2020) II, IX
 2020 FORMAT( ' Number of normal lines:', I4, '  ( max:',I4,' )' )
C
C---- handle array overflow
      IF(OVER) THEN
       WRITE(*,*)
       WRITE(*,*) '***  Number of normal lines exceeds array size'
       WRITE(*,*) '***  Grid not generated'
       GO TO 900
      ENDIF
C
      LGRID = .TRUE.
      LSMOO = .FALSE.
      LSAVE = .FALSE.
      GO TO 900
C
C
C======================================================================
C---- Elliptic grid generator
   30 IF(LGRID) THEN
       WRITE(*,*) 'Smoothing grid ...'
       CALL SMOVE(50,AINF,0.0)
ccc       CALL ELLIP(IX,JX,II,JJ,JFIX,X,Y,XPOS,YPOS,R,0.0,50)
       LSMOO = .TRUE.
       LSAVE = .FALSE.
      ELSE
       WRITE(*,*) '***  Grid not initialized'
      ENDIF
      GO TO 900
C
C======================================================================
C---- set top and bottom streamline y-positions
   40 IF(.NOT.LGRID) THEN
       WRITE(*,*) '***  Grid not initialized'
       GO TO 900
      ENDIF
C
      IF(.NOT.LSMOO) THEN
       WRITE(*,*) 'Smooth grid first?  Y'
       READ (*,1001) ANS
       IF(ANS .NE. 'N' .AND. ANS .NE. 'n') THEN
       CALL SMOVE(50,AINF,0.0)
ccc        CALL ELLIP(IX,JX,II,JJ,JFIX,X,Y,XPOS,YPOS,R,0.0,50)
        LSMOO = .TRUE.
       ENDIF
      ENDIF
C
      DO 41 K=1, NMODX
        MODN(K) = 0.0
 41   CONTINUE
C
      DO 42 K=1, NPOSX
        POSN(K) = 0.0
 42   CONTINUE
C
C---- Initialize Flow state vector
      CALL INIFLW
C
C---- Initialize BL quantities
      CALL INIBL
C
C---- Initialize wake trajectory
      CALL WKCALC
C
C---- Set wake gap array for blunt TE treatment
      DO N = 1, NBL
        CALL GAPSET(N)
      ENDDO
C
C---- Write everything to disk
      CALL OUTPUT
      LSAVE = .TRUE.
      GO TO 900
C
C======================================================================
C---- Plot the grid
   50 IF(.NOT.LGRID) THEN
       WRITE(*,*) '***  Grid not initialized'
       GO TO 900
      ENDIF
C
      CALL CLRZOOM
      CALL PLTGRD
      GO TO 900
C
C======================================================================
C---- Plot Cp vs x/c
   60 CONTINUE
      CALL CLRZOOM
      CALL PLTCPX
      GO TO 900
C
C======================================================================
C---- allow user to change grid parameters
   70 CALL MODPAR
      GO TO 900
C
C======================================================================
C---- write out current grid parameters for later use
   80 IF(DSINIT) THEN
       CALL SAVPAR
      ELSE
       WRITE(*,*)
       WRITE(*,*) '*** Must generate grid spacing with option 2 first'
       WRITE(*,*) '*** Grid parameters not saved'
      ENDIF
      GO TO 900
C
C======================================================================
   90 WRITE(*,2090) SIZE
 2090 FORMAT(/' Current plot size =', F8.3
     &       /' Enter new plot size: ', $)
      READ (*,*,ERR=90) SIZE
      GO TO 900
C
C======================================================================
  110 CALL USETZOOM(.TRUE.,.TRUE.)
      CALL REPLOT(IDEV)
      GO TO 900
C
C======================================================================
  120 CALL CLRZOOM
      CALL REPLOT(IDEV)
      GO TO 900
C
      END ! MSET
 


      SUBROUTINE INIT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
      PIE = 4.0*ATAN(1.0)
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU 4    (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU 10+?
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.70
C
C---- Default plot size in inches
C-    (Default plot window is 11.0 x 8.5)
      SIZE = 10.0
C
C
C---- plot aspect ratio V/H
      AR = 0.75
C
C---- character height
      CH = 0.021
C
C---- initialize plot routines and set up basic colors
      CALL PLINITIALIZE
C
C---- default offset and scaling factors
      XOFF = 0.0
      YOFF = 0.0
      SF = 1.0
C
C---- Initial element to plot
      NBPLT = 1
C
C
C---- Initialize constants for MSES
      GAM = 1.4
      CIRC = 0.
      DOUX = 0.
      DOUY = 0.
      ALFA = 0.
      REYN = 0.
      INITBL = 0
      INITRQ = 0
      ICOUNT = 0
      MCRIT = 0.99
      MUCON = 1.0
C
      XCENT = 0.25
      YCENT = 0.
C
      GM1 = GAM - 1.0
      GP1 = GAM + 1.0
C
C---- initialize stagnation quantities
      HINF = 1.0/GM1
      RSTOUT = 1.0
      PSTOUT = 1.0/GAM
C
      MINF = 0.1
C
C---- initialize freestream quantities
      TTR = 1.0 + 0.5*GM1*MINF**2
      RHOINF = RSTOUT*TTR**(-1.0/GM1)
      PINF   = PSTOUT*TTR**(-GAM/GM1)
      QINF = SQRT( GM1*HINF * MINF**2 / TTR )
      GINF = HINF - 0.5*QINF**2
      MUINF = SQRT((GINF/HINF)**3) * (HINF+HVIS)/(GINF+HVIS)
C
      QSTAR = SQRT(2.0*HINF/(2.0/GM1 + 1.0))
      PSTAR = PSTOUT*(1.0 + 0.5*GM1)**(-GAM/GM1)
      RSTAR = RSTOUT*(1.0 + 0.5*GM1)**(-1.0/GM1)
C
C---- trip locations will be x/c
      KTRIP = 0
C
      TRF = 0.875                ! turbulent temperature recovery factor
      HVIS = 0.35*HINF           ! Cp x Sutherland's constant
C
      RETURN
      END


      SUBROUTINE DEFPAR
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
C---- default number of surface grid points for element of chord 1
      NBLD1 = 141
C
C---- scaling exponent for number of surface grid points: 
C-     N = NBLD1*c^FNBLD1
      FNBLD1 = 0.40
C
C---- default inlet and outlet points from leftmost LE, rightmost TE
      NINL1 = 37
      NOUT1 = 37
C
C---- default top and bottom points
      NTOP1 = 21
      NBOT1 = 15
C
C---- max number of streamtubes between elements
      NTUBMX = 11
C
C---- default capture area ratio between top and bottom of domain
C-    (only for "old" blade.xxx files)
      MRAT = 1.30
C
C---- LE cell aspect ratio
      CELLAR = 2.5
C
C---- delta(s) weighting exponent
C-    XPEX = 0    :  nodes tend to be equidistant away from surfaces
C-    XPEX = 1    :  nodes stay the same spacing as on surfaces
      XPEX = 0.85
C
C---- farfield type  (only freestream used currently)
      IFFTYP = 2
C
C---- alpha for generating grid 
C     (999.0 = do not generate solution on start-up)
      ALFGEN = 999.0
C
      DO 10 N=1, NBX
        XSREF1(N) = 1.0
        XSREF2(N) = 1.0
        XPREF1(N) = 1.0
        XPREF2(N) = 1.0
        CRRATS(N) = 0.0
        CRRATP(N) = 0.0
 10   CONTINUE
C
      RETURN
      END ! DEFPAR


      SUBROUTINE GETPAR
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      CHARACTER*80 ARGP1, FNAME
C
C---- try to read grid parameters from disk file
C
      CALL GETARG(1,ARGP1)
      FNAME = 'gridpar.' // ARGP1
C
      OPEN(13,FILE=FNAME,STATUS='OLD',ERR=80)
      READ(13,*,ERR=90) NBLD1
      READ(13,*,ERR=90) FNBLD1
      READ(13,*,ERR=90) NINL1
      READ(13,*,ERR=90) NOUT1
      READ(13,*,ERR=90) NTOP1
      READ(13,*,ERR=90) NBOT1
      READ(13,*,ERR=90) NTUBMX
      READ(13,*,ERR=90) MRAT
      READ(13,*,ERR=90) CELLAR
      READ(13,*,ERR=90) XPEX
      READ(13,*,ERR=90) ALFGEN
C
      DO 30 N=1, NBL
        READ(13,*,ERR=90) FSLE(N), FSTE(N), CVLEWT(N)
C
C------ set default spacing parameters if this is  v 2.7  gridpar.xxx file
        IF(FSLE(N).LE.0.01) THEN
          FSLE(N) = 0.4
        ENDIF
        IF(FSTE(N).LE.0.05) THEN
          FSTE(N) = 0.8
        ENDIF
C
   30 CONTINUE
      DSINIT = .TRUE.
C
      DO 40 N=1, NBL
        READ(13,*,ERR=41) 
     &    XSREF1(N),XSREF2(N),XPREF1(N),XPREF2(N),CRRATS(N),CRRATP(N)
 40   CONTINUE
 41   CONTINUE
C
      WRITE(*,1300) FNAME
 1300 FORMAT(/' Grid parameters read from file  ', A40)
      CLOSE(13)
      RETURN
C
   80 WRITE(*,1320) FNAME
 1320 FORMAT(/' Grid parameter file open error:  ', A40
     &       /' Default parameters will be used.'/)
      RETURN
C
   90 WRITE(*,1350) FNAME
 1350 FORMAT(/' Grid parameter file read error:  ', A40
     &       /' Default parameters will be used.'/)
      CLOSE(13)
C
C---- set default parameters again in case they got munched in file read
      CALL DEFPAR
C
      RETURN
      END ! GETPAR



      SUBROUTINE SAVPAR
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      CHARACTER*80 ARGP1, FNAME
C
C---- try to read grid parameters from disk file
C
      CALL GETARG(1,ARGP1)
      FNAME = 'gridpar.' // ARGP1
C
      OPEN(13,FILE=FNAME,STATUS='UNKNOWN')
      WRITE(13,*) NBLD1
      WRITE(13,*) FNBLD1
      WRITE(13,*) NINL1
      WRITE(13,*) NOUT1
      WRITE(13,*) NTOP1
      WRITE(13,*) NBOT1
      WRITE(13,*) NTUBMX
      WRITE(13,*) MRAT
      WRITE(13,*) CELLAR
      WRITE(13,*) XPEX
      WRITE(13,*) ALFGEN
C
      DO 30 N=1, NBL
        WRITE(13,*) FSLE(N), FSTE(N), CVLEWT(N)
   30 CONTINUE
C
      DO 40 N=1, NBL
        WRITE(13,1100)
     &    XSREF1(N),XSREF2(N),XPREF1(N),XPREF2(N),CRRATS(N),CRRATP(N)
 1100   FORMAT(1X,6F12.6)
 40   CONTINUE
C
      WRITE(*,1300) FNAME
 1300 FORMAT(/' Current grid  parameters saved to file  ', A48)
      CLOSE(13)
      RETURN
      END ! SAVPAR



      SUBROUTINE INIFLW
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
C---- Initialize MSES state vector
      DO 50 J=1, JJ-1
        IF(JFIX(J) .NE. -1) CALL QCALC(J)
   50 CONTINUE
C
      DO 80 NBIT=1, NBITX
        DO 70 I=1, II
          ISBITS(NBIT,I) = 0
   70   CONTINUE
   80 CONTINUE
C
      LCONV = .FALSE.
      NHALF = 0
C
C---- default Pcorr weighting factor
      PCWT = 0.1
C
      RETURN 
      END



      SUBROUTINE INIBL
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
C---- initialize BL parameters assuming no coupling
      DO 10 IS=1, 2*NBL
        N = (IS+1)/2
        ILE = NINL(N)
        ITE = II - NOUT(N) + 1
C
        ITRAN(IS) = ITE + 2
        XTR(IS) = XBTAIL(N)
C
        DO 105 I=1, II
          THET(I,IS) = 0.
          DSTR(I,IS) = 0.
          CTAU(I,IS) = 0.
          TAU (I,IS) = 0.
          DISP(I,IS) = 0.
  105   CONTINUE
   10 CONTINUE
C
C---- intialize displacement arrays at free streamline locations
      DO 20 IS=1, 2*NBL
        N = (IS+1)/2
        IF(MOD(IS,2) .EQ. 0) THEN
         SBTE = SB(IIB(N),N)
         J = JBLD(N)-1
        ELSE
         SBTE = SB(1     ,N)
         J = JBLD(N)
        ENDIF
C
        DO 205 I=NINL(N), NINL(N)+NBLD(N)-1
          IG = I-NINL(N)+1
          IF(LSFREE(IG,IS)) THEN
            SGC = SG(IGCORN(IS),IS)
            SBCORN = SBLE(N) + (SBTE-SBLE(N))*SGC
            SBI = SBCORN + (SBTE-SBCORN)*(SG(IG,IS)-SGC)/(1.0-SGC)
            XBI = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YBI = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
            XDI = DEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
            YDI = DEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C---------- set displacement if vector points outside of airfoil
            DISPX = X(I,J) - XBI
            DISPY = Y(I,J) - YBI
            CROSSP = DISPX*YDI - DISPY*XDI
            IF(CROSSP .GT. 0.0) THEN
             DISP(I,IS) = SQRT(DISPX**2 + DISPY**2)
            ENDIF
            DSTR(I,IS) = DISP(I,IS)
          ENDIF
  205   CONTINUE
   20 CONTINUE
C
C---- initialize displacement arrays in wake
      DO 40 N=1, NBL
        IS = 2*(N-1) + 1
        J1 = JBLD(N)
        J2 = JBLD(N)-1
        DO 405 I=II-NOUT(N)+2, II
          DGAP = SQRT((X(I,J1)-X(I,J2))**2 + (Y(I,J1)-Y(I,J2))**2)
          DISP(I,IS)   = 0.5*DGAP
          DISP(I,IS+1) = 0.5*DGAP
          DSTR(I,IS)   = DISP(I,IS)
          DSTR(I,IS+1) = DISP(I,IS+1)
  405   CONTINUE
   40 CONTINUE
C
      RETURN
      END ! INIBL


 
      SUBROUTINE READAI
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      DIMENSION XBNEW(IBX), YBNEW(IBX)
      LOGICAL LCLOCK, ERROR, PLAIN
      CHARACTER*80 ARGP1, FNAME
C
      CALL GETARG(2,ARGP1)
      IF(INDEX(ARGP1,' ').LE.1) CALL GETARG(1,ARGP1)
C
      FNAME = 'blade.' // ARGP1
      NAME = '                                '
CCC           12345678901234567890123456789012
C
C---- read blade.xxx coordinate file
      CALL READBL(FNAME,IBX,NBX,XB,YB,
     &            IIB,NBL,
     &            NAME,XBINL,XBOUT,YBBOT,YBTOP)
C
C---- quit if read was unsuccessful
      IF(NBL.EQ.0) RETURN
C
      PLAIN = ABS(XBINL-XBOUT) .LT. 1.0E-8
C
C---- get name and domain info if this was a plain coordinate file
      IF(PLAIN) THEN
        WRITE(*,*)
        WRITE(*,*) 'Enter case name:'
        READ(*,1000) NAME
 1000   FORMAT(A)
C
 50     WRITE(*,1005)
 1005   FORMAT(/' Enter  Xinl, Xout, Ybot, Ytop :')
        READ(*,*,ERR=50) XBINL,XBOUT,YBBOT,YBTOP
      ENDIF
C
C---- process each element
      DO 100 N=1, NBL
C
C------ spline coordinates
        CALL SCALC(XB(1,N),YB(1,N),SB(1,N),IIB(N))
        CALL SEGSPL(XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        CALL SEGSPL(YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C------ get nose s location
        CALL LEFIND(SBNOSE(N),XB(1,N),XPB(1,N),
     &                        YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C------ set LE and TE coordinates
        XBNOSE(N) = SEVAL(SBNOSE(N),XB(1,N),XPB(1,N),SB(1,N),IIB(N))
        YBNOSE(N) = SEVAL(SBNOSE(N),YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
        XBTAIL(N) = 0.5*(XB(1,N) + XB(IIB(N),N))
        YBTAIL(N) = 0.5*(YB(1,N) + YB(IIB(N),N))
C
        CHRD(N) = SQRT(  (XBTAIL(N)-XBNOSE(N))**2
     &                 + (YBTAIL(N)-YBNOSE(N))**2 )
C
C------ set arc length of max-curvature point
        SBCMAX(N) = SBNOSE(N)
        CALL NSFIND(SBCMAX(N),XB(1,N),XPB(1,N),
     &                        YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
        SBNORM = SBCMAX(N)/(SB(IIB(N),N) - SB(1,N))
        IF(SBNORM .LT. 0.45 .OR. SBNORM .GT. 0.55) THEN
          WRITE(*,1050) N, SBNORM
 1050     FORMAT(
     &     /' READAI: Questionable max-curvature location on element',I3
     &     /'         Scmax/Stotal  =', F8.5
     &     /'         setting Scmax = Snose.' )
          SBCMAX(N) = SBNOSE(N)
        ENDIF
C
  100 CONTINUE
C
C---- set circulation-correction coefficient for setting inlet potential
      XLEMIN = XBNOSE(1)
      CHDSUM = 0.
      DO 110 N=1, NBL
        XLEMIN = MIN(XLEMIN,XBNOSE(N))
        CHDSUM = CHRD(N) + CHDSUM
 110  CONTINUE
      ARG = MAX( (XLEMIN-XBINL)/CHDSUM , 0.0 )
      CIRPHI = LOG(ARG + 1.0)
C
      RETURN
      END ! READAI

 
 
 
      SUBROUTINE NODES(IOVER)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      LOGICAL IOVER
C---------------------------------------------------------------------
C     Sets grid nodes along stagnation streamlines using previously
C     defined distribution arrays.  Also sets initial grid node 
C     positions in flowfield interior by crude linear interpolation 
C     from stagnation streamlines.  This grid is then intended to be 
C     fixed up by elliptic grid generator.
C---------------------------------------------------------------------
      INTEGER JS(KSX), ILS(KSX,KSX)
      REAL XPOS(IX,KSX)
C
C---- set j indices of all stagnation and farfield streamlines
      DO 5 J=1, JJ
        JFIX(J) = 0
    5 CONTINUE
C
      DO 10 N=1, NBL
        ISO = 2*N-1
        ISP = 2*N
        JS(ISO) = JBLD(N)
        JS(ISP) = JBLD(N) - 1
        JFIX(JS(ISO)) = +1
        JFIX(JS(ISP)) = -1
   10 CONTINUE
      JS(2*NBL+1) = 1
      JS(2*NBL+2) = JJ
C
C
C---- set total i point number
      N = 1
      II = NINL(N) + NBLD(N) + NOUT(N) - 2
C
C---- check for array overflow
      IOVER = II .GT. IX
      IF(IOVER) RETURN
C
C---- set points on all element (stagnation) streamlines
      DO 20 IS=1, 2*NBL
        J = JS(IS)
C
        N = (IS+1)/2
C
C------ portion ahead of LE
        DO 210 IG=1, NINL(N)
          I = IG
          SSTI = SSTL(1,IS) + STINL(N)*SGINL(IG,N)
          X(I,J) = SEVAL(SSTI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          Y(I,J) = SEVAL(SSTI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
  210   CONTINUE
C
C------ TE arc length value SBTE depends if we're on element top or bottom
        IF(MOD(IS,2) .EQ. 0) THEN
         SBTE = SB(IIB(N),N)
        ELSE
         SBTE = SB(1     ,N)
        ENDIF
        SBSURF = SBTE - SBLE(N)
C
C------ find STCORN (= SST value nearest corner node on SB array)
        IF(IGCORN(IS) .NE. 0) THEN
C
C------- set corner  s,x,y  location on streamline
         SGC = SG(IGCORN(IS),IS)
         SBC = SBLE(N) + SBSURF*SGC
         XBC = SEVAL(SBC,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
         YBC = SEVAL(SBC,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
C
C------- initial guess for corner location arc length on airfoil
         STCORN = SST(ISTLE(IS),IS) + ABS(SBSURF)*SGC
C
C------- converge from initial guess
         CALL NEARPT(XBC,YBC,STCORN,
     &               XST(1,IS),XSTP(1,IS),
     &               YST(1,IS),YSTP(1,IS),
     &               SST(1,IS),NST(IS) )
C
        ENDIF
C
C------ go over airfoil surface
        DO 220 IG=1, NBLD(N)
          I = NINL(N)-1 + IG
          IF(LSFREE(IG,IS)) THEN
C--------- set free streamline node from splined surface streamline
           SSTI = STCORN + (SST(ISTTE(IS),IS)-STCORN)
     &                    *(SG(IG,IS)-SGC)/(1.0-SGC)
           X(I,J) = SEVAL(SSTI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
           Y(I,J) = SEVAL(SSTI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
          ELSE
C--------- set node from splined airfoil
           SBI = SBLE(N) + SBSURF*SG(IG,IS)
           X(I,J) = SEVAL(SBI,XB(1,N),XPB(1,N),SB(1,N),IIB(N))
           Y(I,J) = SEVAL(SBI,YB(1,N),YPB(1,N),SB(1,N),IIB(N))
          ENDIF
  220   CONTINUE
C
C------ go over streamline behind TE
        DO 240 IG=1, NOUT(N)
          I = NINL(N)-1 + NBLD(N)-1 + IG
          SSTI = SST(ISTTE(IS),IS) + STOUT(N)*SGOUT(IG,N)
          X(I,J) = SEVAL(SSTI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          Y(I,J) = SEVAL(SSTI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
  240   CONTINUE
C
C------ save spacing increments for setting outer streamlines
        DO I=2, II
          XPOS(I,IS) = SQRT((X(I,J)-X(I-1,J))**2 + (Y(I,J)-Y(I-1,J))**2)
        ENDDO
   20 CONTINUE
C
C---- set stretching exponents
      CIRREF = AINF
      IF(CIRC .GT. 0.0) THEN
        XPFAC = 1.0 - EXP(-CIRC/CIRREF)
        XPEXT = XPEX - (      XPEX)*XPFAC
        XPEXB = XPEX + (1.0 - XPEX)*XPFAC
      ELSE
        XPFAC = 1.0 - EXP( CIRC/CIRREF)
        XPEXB = XPEX - (      XPEX)*XPFAC
        XPEXT = XPEX + (1.0 - XPEX)*XPFAC
      ENDIF
C
c      IF(CIRC .GT. 0.0) THEN
c        XPFAC = 1.0 - EXP(-CIRC/CIRREF)
c        XPEXT = XPEX + (0.5 - XPEX)*XPFAC
c        XPEXB = XPEX + (1.0 - XPEX)*XPFAC
c      ELSE
c        XPFAC = 1.0 - EXP( CIRC/CIRREF)
c        XPEXB = XPEX + (0.5 - XPEX)*XPFAC
c        XPEXT = XPEX + (1.0 - XPEX)*XPFAC
c      ENDIF
C
      XPEXM = 1.0 - 0.5*(1.0-XPEX)
C
      ISB = 2*NBL + 1
      IST = 2*NBL + 2
C
C---- set spacing for bottom outer streamline
      IS = ISB
      XPOS(1,IS) = 0.0
      DO I=2, II
        DSI = XPOS(I,2*NBL)
        XPOS(I,IS) = XPOS(I-1,IS) + DSI**XPEXB
      ENDDO
      CALL FILTER(XPOS(1,IS),3.0,II)
C
C---- set spacing for top outer streamline
      IS = IST
      XPOS(1,IS) = 0.0
      DO I=2, II
        DSI = XPOS(I,1)
        XPOS(I,IS) = XPOS(I-1,IS) + DSI**XPEXT
      ENDDO
      CALL FILTER(XPOS(1,IS),3.0,II)
C
C---- set points on farfield streamlines
      DO 50 IS = ISB, IST
        J = JS(IS)
C
        SST1 = SSTL(1,IS)
        SSTN = SSTL(NLIN(IS),IS)
        DO 510 I=1, II
          SS = SST1 + (SSTN-SST1)*(XPOS( I,IS)-XPOS(1,IS))
     &                           /(XPOS(II,IS)-XPOS(1,IS))
          X(I,J) = SEVAL(SS,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          Y(I,J) = SEVAL(SS,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
  510   CONTINUE
   50 CONTINUE
C
C---- interpolate points to all interior streamlines
      DO 60 ISO=2*NBL+1, 1, -2
        ISP = ISO - 1
        IF(ISP.EQ.0) ISP = 2*NBL+2
C
        JO = JS(ISO)
        JP = JS(ISP)
C
        DO 610 J=JO+1, JP-1
          FRAC = (YPOS(J) - YPOS(JO))/(YPOS(JP)-YPOS(JO))
          DO 6110 I=1, II
            X(I,J) = X(I,JO) + FRAC*(X(I,JP)-X(I,JO))
            Y(I,J) = Y(I,JO) + FRAC*(Y(I,JP)-Y(I,JO))
 6110     CONTINUE
  610   CONTINUE
   60 CONTINUE
C
      RETURN
      END ! NODES





      SUBROUTINE NORLIN
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      PARAMETER (NFRACX=20)
C
      DIMENSION PSINOR(NNX), SNEW(NFRACX*(NNX+1))
C
C---- go over all TE points
      DO 1000 N=1, NBL
C
      IS1 = 2*N - 1
      IS2 = 2*N
C
C---- set TE bisector unit vector
      XSTPTE = 0.5*(XSTP(ISTTE(IS1),IS1) + XSTP(ISTTE(IS2),IS2))
      YSTPTE = 0.5*(YSTP(ISTTE(IS1),IS1) + YSTP(ISTTE(IS2),IS2))
      SSTPTE = SQRT(XSTPTE**2 + YSTPTE**2)
      XUTE = XSTPTE/SSTPTE
      YUTE = YSTPTE/SSTPTE
C
      DO 900 ISN=IS1, IS2
C
        IF(ISN.EQ.IS1) THEN
          SGN = 1.0
          ISDIR = -1
          ISEND = 0
        ELSE
          SGN = -1.0
          ISDIR = 1
          ISEND = 2*NBL+1
        ENDIF
C
C------ set first normal-line point
C-      streamfunction is used as spline coordinate
C-      spline derivatives are (dX/dPsi,dY/dPsi) = (nx,ny)/q
        IS = ISN
        K = 1
        XNOR(K,ISN) = SEVAL(SST(ISTTE(IS),IS),
     &                  XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
        YNOR(K,ISN) = SEVAL(SST(ISTTE(IS),IS),
     &                  YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
        SNOR(K,ISN) = SGN*PSIST(IS)
cccc        write(30,*) k,isn,snor(k,isn),' *1'
        XSNOR(K,ISN) = -SGN*YUTE/QST(ISTTE(IS),IS)
        YSNOR(K,ISN) =  SGN*XUTE/QST(ISTTE(IS),IS)
        PHINOR = SEVAL(SST(ISTTE(IS),IS),
     &             PHIST(1,IS), QST(1,IS),SST(1,IS),NST(IS))
C
C------ go up or down from current element's TE point
        DO 110 KS=ISN+ISDIR, ISEND, 2*ISDIR
C
C-------- set next-side index
          IF(KS.EQ.0) THEN 
           IS = 2*NBL+2
          ELSE
           IS = KS
          ENDIF
C
C-------- go over blocks and locate line originating from ISN's TE
          DO IL=1, NLIN(IS)
            IF(ISOR(IL,IS).EQ.ISN .AND. .NOT.LEOR(IL,IS)) GO TO 1106
          ENDDO
C
C-------- we must have run into an element
          GO TO 111
C
 1106     CONTINUE
C
C-------- march up to side KS using NSTEP points
ccc          if(.false.) then
          IF(KS.EQ.0 .OR. KS.EQ.2*NBL+1) THEN
            NNOR = 5
            NN = (KS-ISDIR + 1)/2
C
            DELPSI = PSIST(IS) - PSIST(KS-ISDIR)
            SBLEN = SB(IIB(NN),NN) - SB(1,NN)
            DPSI1 = SIGN( 0.02*SBLEN , DELPSI )
C
            CALL SETEXP(PSINOR(K),DPSI1,DELPSI,NNOR)
            DO KT = K, K+NNOR-1
              PSINOR(KT) = PSINOR(KT) + PSIST(KS-ISDIR)
              SNOR(KT,ISN) = SGN*PSINOR(KT)
cccc        write(30,*) kt,isn,snor(kt,isn),' *2'
            ENDDO
C
C---------- estimate next point
            XNOR(K+1,ISN) = XNOR(K,ISN)
     &                    + SGN*XSNOR(K,ISN)*(PSINOR(K+1)-PSINOR(K))
            YNOR(K+1,ISN) = YNOR(K,ISN)
     &                    + SGN*YSNOR(K,ISN)*(PSINOR(K+1)-PSINOR(K))
C
            CALL NORSET(XNOR(K,ISN),YNOR(K,ISN), 
     &                  XSNOR(K,ISN),YSNOR(K,ISN),
     &                  PHINOR,PSINOR(K),NNOR,ISN,NN)
            K = K + NNOR-2
          ENDIF
C
          K = K+1
          XNOR(K,ISN) = SEVAL(SSTL(IL,IS),
     &                    XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          YNOR(K,ISN) = SEVAL(SSTL(IL,IS),
     &                    YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
          SNOR(K,ISN) = SGN*PSIST(IS)
cccc        write(30,*) k,isn,snor(k,isn),' *3'
          XSTPI      = DEVAL(SSTL(IL,IS),
     &                   XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          YSTPI      = DEVAL(SSTL(IL,IS),
     &                   YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
          QSTI       = DEVAL(SSTL(IL,IS),
     &                 PHIST(1,IS), QST(1,IS),SST(1,IS),NST(IS))
          SSTPI = SQRT(XSTPI**2 + YSTPI**2)
          XUI = XSTPI/SSTPI
          YUI = YSTPI/SSTPI
C
          XSNOR(K,ISN) = -SGN*YUI/QSTI
          YSNOR(K,ISN) =  SGN*XUI/QSTI
C
          PHINOR = SEVAL(SSTL(IL,IS),
     &                 PHIST(1,IS), QST(1,IS),SST(1,IS),NST(IS))
C
CMD 9-16-00 Bug fix for wake potential addition, only add when crossing wake!
          IF(SSTL(IL,IS) .GE. SST(ISTTE(IS),IS)) THEN
C--------- reset potential to account for jump across wake
           PHINOR = PHINOR
     &          + (  PHIST(ISTTE(IS+ISDIR),IS+ISDIR)
     &             - PHIST(ISTTE(IS      ),IS      ))
          ENDIF
 110    CONTINUE
C
C------ set total number of points
 111    KNOR(ISN) = K
C
C------ reset spline parameter to arc length
        NFRAC = NFRACX
        XNEW = XNOR(1,ISN)
        YNEW = YNOR(1,ISN)
        KNEW = 1
        SNEW(KNEW) = 0.0
        DO 150 K=2, KNOR(ISN)
          DSNOR = SNOR(K,ISN) - SNOR(K-1,ISN)
          DO 1505 IFRAC=1, NFRAC
            FRAC = FLOAT(IFRAC)/FLOAT(NFRAC)
            SNORK = SNOR(K-1,ISN) + DSNOR*FRAC
            XNEWK = SEVAL(SNORK,
     &                XNOR(1,ISN),XSNOR(1,ISN),SNOR(1,ISN),KNOR(ISN))
            YNEWK = SEVAL(SNORK,
     &                YNOR(1,ISN),YSNOR(1,ISN),SNOR(1,ISN),KNOR(ISN))
            KNEW = KNEW + 1
            IF(KNEW.GT.NFRACX*(NNX+1)) THEN
             WRITE(*,*) 'NORLIN: KNEW dimension exceeded'
             STOP
            ENDIF
            SNEW(KNEW) = SNEW(KNEW-1)
     &                 + SQRT((XNEWK-XNEW)**2 + (YNEWK-YNEW)**2)
            XNEW = XNEWK
            YNEW = YNEWK
 1505     CONTINUE
 150    CONTINUE
C
        DO 160 K=1, KNOR(ISN)
          KNEW = 1 + NFRAC*(K-1)
          SNOR(K,ISN) = SNEW(KNEW)
cccc        write(40,*) k,isn,snor(k,isn)
          GMOD = SQRT(XSNOR(K,ISN)**2 + YSNOR(K,ISN)**2)
          XSNOR(K,ISN) = XSNOR(K,ISN)/GMOD
          YSNOR(K,ISN) = YSNOR(K,ISN)/GMOD
 160    CONTINUE
C
 900  CONTINUE
 1000 CONTINUE
C
      RETURN
      END ! NORLIN



 
      SUBROUTINE QCALC(J)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C---------------------------------------------------
C     Sets density at along streamtube J assuming 
C     incompressible flow to get the speed.
C---------------------------------------------------
C
      JO = J
C
C---- Sweep along streamtube
      DO 5 IO = 1, II-1
        R(IO,JO) = RSTOUT
  5   CONTINUE
C
      RETURN
      END ! QCALC
 
 

 
 
      SUBROUTINE MODPAR
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      CHARACTER*1 ANS
      LOGICAL ERROR
C
    2 WRITE(*,1000) NBLD1,FNBLD1,NINL1,NOUT1,NTOP1,NBOT1,NTUBMX,
ccc  &              IFFTYP,
     &              XPEX,CELLAR,ALFGEN
 1000 FORMAT(/'    Current grid parameters:'
     &  /' N ',I7  ,'   Airfoil side points (for chord = 1)          E'
     &  /' E ',F7.3,'   Exponent for airfoil side points: n = N*chord '
     &  /' I ',I7  ,'   Inlet  points on leftmost  airfoil streamline'
     &  /' O ',I7  ,'   Outlet points on rightmost airfoil streamline'
     &  /' T ',I7  ,'   Number of streamlines in top of domain'
     &  /' B ',I7  ,'   Number of streamlines in bottom of domain'
     &  /' M ',I7  ,'   Maximum streamlines between two airfoils'
ccc  &  /' F ',I7  ,'   Farfield type'
     &  /' X ',F7.3,'   X-spacing parameter'
ccc  &  /' R ',F7.3,'   Ratio of mass flow between top and bottom'
     &  /' A ',F7.3,'   Aspect ratio of each cell at stagnation point'
     &  /' S ',F7.2,'   Initial alpha for streamline generation')
C
    5 WRITE(*,1050) 
      READ (*,1100) ANS
 1050 FORMAT(/' Change what (<return> if done)?:  ',$)
 1100 FORMAT(A)
C
      IF(ANS .EQ. ' ') RETURN
      IF(ANS .EQ. '?') GO TO 2
C
      IF(ANS .EQ. 'N' .OR. ANS .EQ. 'n') THEN
   10   WRITE(*,2010)
 2010   FORMAT(' Enter number of airfoil side points:  ',$)
        READ(*,*,ERR=10) NBLD1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'E' .OR. ANS .EQ. 'e') THEN
   20   WRITE(*,2020)
 2020   FORMAT(' Enter exponent for airfoil side points:  ',$)
        READ(*,*,ERR=20) FNBLD1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'I' .OR. ANS .EQ. 'i') THEN
   30   WRITE(*,2030)
 2030   FORMAT(' Enter number of inlet points:  ',$)
        READ(*,*,ERR=30) NINL1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'O' .OR. ANS .EQ. 'o') THEN
   40   WRITE(*,2040)
 2040   FORMAT(' Enter number of outlet points:  ',$)
        READ(*,*,ERR=40) NOUT1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'T' .OR. ANS .EQ. 't') THEN
   50   WRITE(*,2050)
 2050   FORMAT(' Enter number of streamlines in top of domain:  ',$)
        READ(*,*,ERR=50) NTOP1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'B' .OR. ANS .EQ. 'b') THEN
   60   WRITE(*,2060)
 2060   FORMAT(' Enter number of streamlines in bottom of domain:  ',$)
        READ(*,*,ERR=60) NBOT1
        GO TO 5
C
      ELSE IF(ANS .EQ. 'M' .OR. ANS .EQ. 'm') THEN
   70   WRITE(*,2070)
 2070   FORMAT(
     &   ' Enter max number of streamlines between two elements:  ',$)
        READ(*,*,ERR=70) NTUBMX
        GO TO 5
C
c      ELSE IF(ANS .EQ. 'R' .OR. ANS .EQ. 'r') THEN
c   80   WRITE(*,2080)
c 2080   FORMAT(' Enter ratio of mass flow between top and bottom:  ',$)
c        READ(*,*,ERR=80) MRAT
c        GO TO 5
C
      ELSE IF(ANS .EQ. 'A' .OR. ANS .EQ. 'a') THEN
   90   WRITE(*,2090)
 2090   FORMAT(' Enter LE cell aspect ratio:  ',$)
        READ(*,*,ERR=90) CELLAR
        GO TO 5
C
c      ELSE IF(ANS .EQ. 'F' .OR. ANS .EQ. 'f') THEN
c 100    WRITE(*,2100)
c2100    FORMAT('  1  Solid wall'
c    &         /'  2  Infinite flow'
c    &         /'  3  Free jet'
c    &        //' Enter farfield type:  ',$)
c        READ(*,*,ERR=100) IFFTYP
c        IF(IFFTYP.LT.1 .OR. IFFTYP.GT.3) GO TO 100
c        GO TO 5
C
      ELSE IF(ANS .EQ. 'X' .OR. ANS .EQ. 'x') THEN
  110   WRITE(*,2110) 
 2110   FORMAT(/' 0 : nodes tend to uniform spacing away from surfaces'
     &         /' 1 : nodes stay the same spacing as on surfaces'
     &        //' Enter x-spacing exponent (0...1):  ',$)
        READ(*,*,ERR=110) XPEX
        GO TO 5
C
      ELSE IF(ANS .EQ. 'S' .OR. ANS .EQ. 's') THEN
  120   WRITE(*,2120)
 2120   FORMAT(' Enter initial alpha for streamline generation:  ',$)
        READ(*,*,ERR=120) ALFGEN
        GO TO 5
C
C
      ENDIF
C
      RETURN
      END ! MODPAR


 
      SUBROUTINE WKCALC
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
C---- go over all elements ...
      DO 100 N = 1, NBL
C
      IS = 2*(N-1) + 1
      J1 = JBLD(N)
      J2 = JBLD(N)-1
C
C---- calculate wake trajectory x,y
      XW(1,N) = 0.5*(XB(1,N) + XB(IIB(N),N))
      YW(1,N) = 0.5*(YB(1,N) + YB(IIB(N),N))
      DO 10 IW=2, NOUT(N)
        I = II - NOUT(N) + IW
C
C------ set distances from wake trajectory to displacement surfaces,
C-      taking account of TE thickness
        D1 = DISP(I,IS)
        D2 = DISP(I,IS+1)
        DSUM = D1 + D2
        IF(DSUM.EQ.0.0) THEN
         WGHT1 = 0.5
         WGHT2 = 0.5
        ELSE
         WGHT1 = D2/DSUM
         WGHT2 = D1/DSUM
        ENDIF
C
C------ wake trajectory coordinates
        XW(IW,N) = WGHT1*X(I,J1) + WGHT2*X(I,J2)
        YW(IW,N) = WGHT1*Y(I,J1) + WGHT2*Y(I,J2)
   10 CONTINUE
C
  100 CONTINUE
C
      RETURN
      END ! WKCALC



 
      SUBROUTINE YPSET(JOVER)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      LOGICAL JOVER
      DIMENSION PSTMP(JX)
      DIMENSION PSIK(0:JX,0:NBX)
      INTEGER NPSIK(0:NBX)
C
C**** set up streamline spacing array YPOS (streamfunction)
C
C---- first estimate for inter-element stretching ratio
      GEO = 1.5
C
C---- multiple of surface streamtube added on for stretching ratio calc.
C-    (inter-element and top/bottom streamtubes)
      FELADD = 1.1
      FTBADD = 0.9
C
      JTOT = 0
C
C---- set number of lines in each inter-element gap
      DO 10 N=1, NBL-1
        ISO = 2*N
        ISP = 2*N + 1
C
C------ volume flow through streamtube
        DELPSI = PSIST(ISP) - PSIST(ISO)
C
C------ locate normal lines attached to leading edges 
        DO 110 IL=1, NLIN(ISO)
          IF(LEOR(IL,ISO) .AND. ISOR(IL,ISO).EQ.ISO) ILO = IL
          IF(LEOR(IL,ISP) .AND. ISOR(IL,ISP).EQ.ISP) ILP = IL
  110   CONTINUE
C
C------ set streamfunction increments in streamtubes adjacent to elements
        DPSIO = -DPSILE(ISO)
        DPSIP = -DPSILE(ISP)
C
cC------ set appropriate number of streamtubes between the two current elements
c        PSIRAT = (DPSIO + DPSIP)/DELPSI
c        DO 120 NTUBE=2, NTUBMX
c          PRLIM = 6.0/FLOAT(NTUBE)**2 - 4.0/FLOAT(NTUBE)**3
c          IF(PRLIM .LE. PSIRAT) GO TO 121
c  120   CONTINUE
c        NTUBE = NTUBMX
c  121   CONTINUE
cC
cC------ set streamtube shuffling parameter to allow for disparate LE radii
c        PSIOFF = 0.5*(DPSIO - DPSIP) * (FLOAT(NTUBE)/FLOAT(NTUBE-1))**2
cC
cC------ fill streamfunction array for this inter-element gap
c        DO 150 K=0, NTUBE
c          FK0 = FLOAT(K)/FLOAT(NTUBE)
c          FK1 = 1.0 - FK0
c          PSIK(K,N) = (PSIST(ISO) + DELPSI*FK0**2)*FK1
c     &              + (PSIST(ISP) - DELPSI*FK1**2)*FK0
c     &              + PSIOFF * FK0**2 * FK1**2
c  150   CONTINUE
cC
C
C------ alternative inter-element streamfunction distribution scheme
C
        DPOADD = FELADD*DPSIO
        DPPADD = FELADD*DPSIP
C
        PSRATO = (0.3*DELPSI + DPOADD) / (DPSIO + DPOADD)
        PSRATP = (0.3*DELPSI + DPPADD) / (DPSIP + DPPADD)
C
        RNO = LOG(PSRATO*(GEO - 1.0) + 1.0) / LOG(GEO)
        RNP = LOG(PSRATP*(GEO - 1.0) + 1.0) / LOG(GEO)
C
ccc        NTUBE = INT( RNO + RNP )
        NTUBE = INT( RNO + RNP + 0.75)
        NTUBE = MAX( NTUBE , 3 )
        NTUBE = MIN( NTUBE , NTUBMX )
C
        DPSTMP = DELPSI + DPOADD + DPPADD
        CALL SETEX2(PSIK(0,N),DPSIO+DPOADD,DPSIP+DPPADD,DPSTMP,NTUBE+1)
C
        DO 155 K=1, NTUBE-1
          PSIK(K,N) = PSIK(K,N) + PSIST(ISO) - DPOADD
 155    CONTINUE
C
        PSIK(0    ,N) = PSIST(ISO)
        PSIK(NTUBE,N) = PSIST(ISP)
C
C
        NPSIK(N) = NTUBE
        JTOT = JTOT + NTUBE + 1
C
   10 CONTINUE
C
C
C**** set streamfunction array above first element
C
      ISO = 1
      ISP = 2*NBL+2
      N = 0
C
      DELPSI = PSIST(ISP) - PSIST(ISO)
      DPSIO = DPSILE(ISO)
C
C---- estimate number of points needed to get a stretching ratio of GEOMAX
CCC   RJN = LOG((GEOMAX-1.0)*DELPSI/DPSIO + 1.0) / LOG(GEOMAX)
CCC   JN = INT(RJN)
C
      JN = NTOP1
C
      DPADD = FTBADD*DPSIO
      CALL SETEXP(PSTMP,(DPSIO+DPADD),(DELPSI+DPADD),JN)
C
C---- set streamfunction
      DO K=0, JN-2
        J = JN-K
        PSIK(K,N) = PSIST(ISO) + PSTMP(J) - DPADD
      ENDDO
      K = JN-1
      PSIK(K,N) = PSIST(ISO)
C
      NPSIK(N) = JN-1
      JTOT = JTOT + JN
C
C
C**** set streamfunction array below last element
C
      ISO = 2*NBL
      ISP = 2*NBL+1
      N = NBL
C
      DELPSI = PSIST(ISP) - PSIST(ISO)
      DPSIO = -DPSILE(ISO)
C
C---- estimate number of points needed to get a stretching ratio of GEOMAX
CCC   RJN = LOG((GEOMAX-1.0)*DELPSI/DPSIO + 1.0) / LOG(GEOMAX)
CCC   JN = INT(RJN)
C
      JN = NBOT1
C
      DPADD = FTBADD*DPSIO
      CALL SETEXP(PSTMP,(DPSIO+DPADD),(DELPSI+DPADD),JN)
C
C---- set streamfunction
      DO K=1, JN-1
        J = K+1
        PSIK(K,N) = PSIST(ISO) + PSTMP(J) - DPADD
      ENDDO
      K = 0
      PSIK(K,N) = PSIST(ISO)
C
      NPSIK(N) = JN-1
      JTOT = JTOT + JN
C
      JJ = JTOT
C
      JOVER = JJ .GT. JX
      IF(JOVER) RETURN
C
C---- set spacing array and top surface streamline indices
      J = JTOT+1
      DO 50 N=0, NBL
        DO 510 K=0, NPSIK(N)
          J = J-1
          YPOS(J) = PSIK(K,N)
  510   CONTINUE
        IF(N.LT.NBL) JBLD(N+1) = J
   50 CONTINUE
C
C---- normalize spacing array
      YPOS1 = YPOS(1)
      YPDIF = YPOS(JJ) - YPOS(1)
      DO J=1, JJ
        YPOS(J) = (YPOS(J) - YPOS1)/YPDIF
      ENDDO
C
C---- set corresponding mass fraction array
      DO J=1, JJ-1
        MFRACT(J) = YPOS(J+1) - YPOS(J)
      ENDDO
C
      RETURN
      END ! YPSET
