
      SUBROUTINE PLTGRD
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      LOGICAL BLANK
      CHARACTER*1 OPTION
C
C---- find grid point extrema
      XMAX = X(1,1)
      XMIN = X(1,1)
      YMAX = Y(1,1)
      YMIN = Y(1,1)
      DO 4 I=1, II
        DO 2 J=1, JJ
          XMAX = MAX(XMAX,X(I,J))
          XMIN = MIN(XMIN,X(I,J))
          YMAX = MAX(YMAX,Y(I,J))
          YMIN = MIN(YMIN,Y(I,J))
   2    CONTINUE
   4  CONTINUE
C
C---- initialize offsets and plot-status flags
      CALL OFFINI
      BLANK = .TRUE.
      LPLOT = .FALSE.
C
C---- start off with grid skeleton
      OPTION = '2'
      GO TO 910
C
  900 WRITE(*,1000)
 1000 FORMAT(/'   1  Plot grid' 
     &       /'   2  Plot skeleton'
     &       /'   3  Blowup'
     &       /'   4  Reset plot scaling'
     &       /'   5  Hardcopy current plot'
     &       /'   6  Change absolute plot size'
     &      //' Select plot option (or <return>):  ', $)
      READ(*,1001,ERR=900) OPTION
 1001 FORMAT(A)
C
 910  CONTINUE
      IF(OPTION.EQ.' ' .OR. OPTION.EQ.'0') THEN
C
       IF(LPLOT) CALL PLEND
       RETURN
C
      ELSE IF(OPTION.EQ.'1') THEN
C
C------ Plot the grid
        CALL PLTINI
        CALL NEWPEN(2)
        CALL APLOT
        CALL NEWPEN(1)
        CALL GGRID(0.0)
C
C------ mark block corners
ccc     CALL CRNPLT(0.0)
C
        BLANK = .FALSE.
        CALL PLFLUSH
C
      ELSE IF(OPTION.EQ.'2') THEN
C
C------ plot airfoils and outer boundaries only
        CALL PLTINI
        CALL NEWPEN(1)
        CALL APLOT
        CALL OUTLIN
        BLANK = .FALSE.
        CALL PLFLUSH
C
      ELSE IF(OPTION.EQ.'3') THEN
C
C------ Zoom in on the plot
        IF (.NOT.BLANK) THEN
          CALL OFFGET(XOFF,YOFF,SF,SF,1.0,AR,.TRUE.,.TRUE.)
          BLANK = .TRUE.
          OPTION = '1'
          GO TO 910
        ELSE
          WRITE(*,*)
          WRITE(*,*) '***  Plot grid or window first  ***'
        ENDIF
C
      ELSE IF(OPTION.EQ.'4') THEN
C
C------ Reset to default offset and scaling factors, replot skeleton
        CALL OFFINI
        BLANK = .TRUE.
        OPTION = '2'
        GO TO 910
C
      ELSE IF(OPTION.EQ.'5') THEN
C
C------ Hardcopy Flag
        IF(LPLOT) CALL PLEND
        LPLOT = .FALSE.
C
        CALL REPLOT(IHARD)
C
      ELSE IF(OPTION.EQ.'6') THEN
C
C------ plot size
   60   WRITE(*,1060) SIZE
 1060   FORMAT(/' Current plot size =', F8.3
     &         /' Enter new plot size: ', $)
        READ (*,*,ERR=60) SIZE
        OPTION = '2'
        GO TO 910
C
      ENDIF
C
      GO TO 900
      END ! PLTGRD



      SUBROUTINE OFFINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
C---- set initial scaling and offset parameters
      XRANGE = XMAX-XMIN
      YRANGE = YMAX-YMIN
      SF = 0.95*MIN( 1./XRANGE , AR/YRANGE )
      XOFF = XMIN - 0.5*(1. -SF*XRANGE)/SF
      YOFF = YMIN - 0.5*(AR -SF*YRANGE)/SF
C
      RETURN
      END ! OFFINI



      SUBROUTINE PLTINI
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
      IF(LPLOT) CALL PLEND
C
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
C
      RETURN
      END ! PLTINI




      SUBROUTINE OUTLIN
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
C---- plots grid skeleton
C
      CALL NEWPEN(1)
C
      J1 = 1
      N = NBL
C
      JNEXT = JBLD(N) - 1
      DO 1 J2=2, JJ
        IF(J2.EQ.JNEXT) THEN
C
         DO 10 J=J1, J2, J2-J1
           CALL PLOT(XMOD(X(1,J)),YMOD(Y(1,J)),3)
           DO 101 I=2, II
             CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
 101       CONTINUE
 10      CONTINUE
C
         DO 12 I=1, II, II-1
           CALL PLOT(XMOD(X(I,J1)),YMOD(Y(I,J1)),3)
           DO 121 J=J1+1, J2
             CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)),2)
 121       CONTINUE
 12      CONTINUE
C
         J1 = J2+1
         N  = N-1
C
         IF(N.GT.0) THEN
          JNEXT = JBLD(N) - 1
         ELSE
          JNEXT = JJ
         ENDIF
C
        ENDIF
 1    CONTINUE
C
      RETURN
      END ! OUTLIN


      SUBROUTINE GGRID(YMOV)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      DO 10 J = 1, JJ
        CALL PLOT(XMOD(X(1,J)),YMOD(Y(1,J)+YMOV),3)
        DO 101 I = 2, II
          CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)+YMOV),2)
  101   CONTINUE
   10 CONTINUE
C
      DO 20 I = 1, II
        CALL PLOT(XMOD(X(I,1)),YMOD(Y(I,1)+YMOV),3)
        DO 201 J = 2, JJ
          IF(JFIX(J).EQ.1) THEN
            CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)+YMOV),3)
           ELSE
            CALL PLOT(XMOD(X(I,J)),YMOD(Y(I,J)+YMOV),2)
          ENDIF
  201   CONTINUE
   20 CONTINUE
C
      RETURN
      END ! GGRID



      SUBROUTINE CRNPLT(YMOV)   
      INCLUDE 'STATE.INC'     
      INCLUDE 'MSET.INC'     
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SH = 0.005*SF
C
      ISYM = 2
C
      DO 10 IS=1, 2*NBL
        N = (IS+1)/2
C
        IF(MOD(IS,2).EQ.1) THEN
         J = JBLD(N)
         ANG = 0.0
        ELSE
         J = JBLD(N)-1
         ANG = 180.0
        ENDIF
C
        I = 1
        CALL PLSYMB(XMOD(X(I,J)),YMOD(Y(I,J)+YMOV),SH,ISYM,ANG,0)
C
        DO 101 ILO=1, NLIN(IS)-1
          I = I + NGL(ILO,IS) - 1
          CALL PLSYMB(XMOD(X(I,J)),YMOD(Y(I,J)+YMOV),SH,ISYM,ANG,0)
  101   CONTINUE    
   10 CONTINUE      
C
      RETURN        
      END ! CRNPLT


      SUBROUTINE APLOT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
      CALL NEWPEN(1)
      DO 100 N = 1, NBL
        CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
     &              XPB(1,N),YPB(1,N),SB(1,N),XOFF,YOFF,SF,
     &              0.0,0.0,0.0)
  100 CONTINUE
C
      RETURN
      END ! APLOT



      SUBROUTINE AIRFPL(N,X,Y,XS,YS,S,XOFF,YOFF,SF,XROT,YROT,AROT)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N), Y(N), XS(N), YS(N), S(N)
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SINA = SIN(AROT)
      COSA = COS(AROT)
C
      IVIS = 3
      I = 1
      XR = (X(I)-XROT)*COSA - (Y(I)-YROT)*SINA
      YR = (Y(I)-YROT)*COSA + (X(I)-XROT)*SINA
      CALL PLOT( XMOD(XR) , YMOD(YR) , 3)
      DO 10 I=2, N
        DSDK = (S(I) - S(I-1))/10.0
        DO 100 K=1, 10
          SS = S(I-1) + DSDK*FLOAT(K)
          XX = SEVAL(SS,X,XS,S,N)
          YY = SEVAL(SS,Y,YS,S,N)
          XR = (XX-XROT)*COSA - (YY-YROT)*SINA
          YR = (YY-YROT)*COSA + (XX-XROT)*SINA
          CALL PLOT( XMOD(XR) , YMOD(YR) , 2)
  100   CONTINUE
   10 CONTINUE
      RETURN
      END ! AIRFPL


      SUBROUTINE STRPLT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
CCC      DSN = 0.004
      DSN = 0.0
C
      XMIN = XST(1,1)
      XMAX = XST(1,1)
      YMIN = YST(1,1)
      YMAX = YST(1,1)
      DO 8 IS=1, 2*NBL+2
        DO 81 I=1, NST(IS)
          XMIN = MIN( XMIN , XST(I,IS) )
          XMAX = MAX( XMAX , XST(I,IS) )
          YMIN = MIN( YMIN , YST(I,IS) )
          YMAX = MAX( YMAX , YST(I,IS) )
   81   CONTINUE
    8 CONTINUE
C
      CALL PLTINI
C
      CALL GETCOLOR(ICOL0)
C
      SCLMIN = 0.80 * MIN( SIZE/(XMAX-XMIN) , 0.75*SIZE/(YMAX-YMIN) )
      CALL NEWFACTOR( SCLMIN )
      CALL PLOT(-XMIN+0.10,-YMIN+0.10,-3)
c
c      CALL NEWFACTOR( SIZE/3.0 )
c      CALL PLOT( 1.0, 1.0 ,-3)
C
      DO 100 IS=1, 2*NBL+2
C
      I = 1
      CALL PLOT(XST(I,IS),YST(I,IS),3)
      CALL PLOT(XST(I,IS)-DSN*YSTP(I,IS),YST(I,IS)+DSN*XSTP(I,IS),2)
      DO 10 I=2, NST(IS)
        CALL PLOT(XST(I-1,IS),YST(I-1,IS),3)
        CALL PLOT(XST(I  ,IS),YST(I  ,IS),2)
        CALL PLOT(XST(I,IS)-DSN*YSTP(I,IS),YST(I,IS)+DSN*XSTP(I,IS),2)
   10 CONTINUE
C
  100 CONTINUE
C
C
      DO 200 ISL=0, 2*NBL, 2
        ISO = ISL
        IF(ISL.EQ.0) ISO = 2*NBL+2
        ISP = ISL+1
C
        DO 30 ILIN=1, NLIN(ISP)
          XPLT1 = SEVAL(SSTL(ILIN,ISP),
     &                  XST(1,ISP),XSTP(1,ISP),SST(1,ISP),NST(ISP))
          YPLT1 = SEVAL(SSTL(ILIN,ISP),
     &                  YST(1,ISP),YSTP(1,ISP),SST(1,ISP),NST(ISP))
          XPLT2 = SEVAL(SSTL(ILIN,ISO),
     &                  XST(1,ISO),XSTP(1,ISO),SST(1,ISO),NST(ISO))
          YPLT2 = SEVAL(SSTL(ILIN,ISO),
     &                  YST(1,ISO),YSTP(1,ISO),SST(1,ISO),NST(ISO))
          CALL PLOT(XPLT1,YPLT1,3)
          CALL PLOT(XPLT2,YPLT2,2)
   30   CONTINUE
C
  200 CONTINUE
C
      CALL NEWCOLORNAME('cyan')
      do is=1, 2*nbl
        dsnor = snor(knor(is),is) - snor(1,is)
        ipen = 3
ccc        write(*,*) is, knor(is), snor(1,is), snor(knor(is),is)
        kk = 200*(knor(is)-1) + 1
        do k=1, kk
          snk = snor(1,is) + dsnor*float(k-1)/float(kk-1)
          xplt = seval(snk,xnor(1,is),xsnor(1,is),snor(1,is),knor(is))
          yplt = seval(snk,ynor(1,is),ysnor(1,is),snor(1,is),knor(is))
          call plot(xplt,yplt,ipen)
          ipen = 2
        enddo
      enddo
        
      CALL NEWCOLORNAME('red')
      do is=1, 2*nbl
        do inor = 1, knor(is)
          xplt = xnor(inor,is)
          yplt = ynor(inor,is)
          call plsymb(xplt,yplt,0.01,1,0.0,0)
        enddo
      enddo
c
      CALL NEWCOLORNAME('red')
      CALL PLOT(XCENT-0.01,YCENT,3)
      CALL PLOT(XCENT+0.01,YCENT,2)
      CALL PLOT(XCENT,YCENT-0.01,3)
      CALL PLOT(XCENT,YCENT+0.01,2)
C
      CALL NEWCOLOR(ICOL0)
C
      CALL PLFLUSH
      CALL PLEND
C
      RETURN
      END ! STRPLT



      SUBROUTINE SPCPLT
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C
      DSN = 0.004
CCC      DSN = 0.0
C
      XMIN = XST(1,1)
      XMAX = XST(1,1)
      DO 8 IS=1, 2*NBL
        DO 81 I=1, NST(IS)
          XMIN = MIN( XMIN , XST(I,IS) )
          XMAX = MAX( XMAX , XST(I,IS) )
   81   CONTINUE
    8 CONTINUE
C
      CALL PLTINI
C
      CALL NEWFACTOR( 0.75*SIZE/(XMAX-XMIN) )
      CALL PLOT(-XMIN+0.50,0.45*(XMAX-XMIN),-3)
C
      DO 10 IS=1, 2*NBL+2
        DSS = DSN
        IF(MOD(IS,2).EQ.1) DSS = -DSN
        DO 110 IL=1, NLIN(IS)-1
          I = 1
          SLI = SSTL(IL,IS) + (SSTL(IL+1,IS)-SSTL(IL,IS))*SGL(I,IL,IS)
          XSL = SEVAL(SLI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          YSL = SEVAL(SLI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
          XDL = DEVAL(SLI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
          YDL = DEVAL(SLI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
          CALL PLOT(XSL,YSL,3)
          CALL PLOT(XSL-DSS*YDL,YSL+DSS*XDL,2)
          DO 1110 I=2, NGL(IL,IS)
            CALL PLOT(XSL,YSL,3)
            SLI = SSTL(IL,IS) + (SSTL(IL+1,IS)-SSTL(IL,IS))*SGL(I,IL,IS)
            XSL = SEVAL(SLI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
            YSL = SEVAL(SLI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
            XDL = DEVAL(SLI,XST(1,IS),XSTP(1,IS),SST(1,IS),NST(IS))
            YDL = DEVAL(SLI,YST(1,IS),YSTP(1,IS),SST(1,IS),NST(IS))
            CALL PLOT(XSL,YSL,2)
            CALL PLOT(XSL-DSS*YDL,YSL+DSS*XDL,2)
 1110     CONTINUE
  110   CONTINUE
   10 CONTINUE
C
      CALL PLFLUSH
      CALL PLEND
C
      RETURN
      END ! SPCPLT



      SUBROUTINE PLNODE(IIB,XB,XPB,YB,YPB,SB,SBLE,IBLE,SG,IX,NBLD,
     &                  XSIZ,YSIZ,XSREF1,XSREF2,XPREF1,XPREF2)
C
C---- Plot the airfoil, showing the node spacing
C
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION  XB(IIB),XPB(IIB),
     &           YB(IIB),YPB(IIB), SB(IIB),
     &           SG(IX,2)
C
      DIMENSION SBSIDE(2)
      LOGICAL LREF
C
      CALL PLTINI
C
      CALL LEFIND(SS,XB,XPB,YB,YPB,SB,IIB)
      XLE = SEVAL(SS,XB,XPB,SB,IIB)
      YLE = SEVAL(SS,YB,YPB,SB,IIB)
      XTE = 0.5*(XB(1) + XB(IIB))
      YTE = 0.5*(YB(1) + YB(IIB))
C
      XMIN =  9999.
      YMIN =  9999.
      XMAX = -9999.
      YMAX = -9999.
      DO 10 I = 1, IIB
        XMIN = MIN(XB(I),XMIN)
        XMAX = MAX(XB(I),XMAX)
        YMIN = MIN(YB(I),YMIN)
        YMAX = MAX(YB(I),YMAX)
   10 CONTINUE
      XSCL = (XSIZ-0.1)/(XMAX-XMIN)
      YSCL = (YSIZ-0.1)/(YMAX-YMIN)
      SCL = MIN(XSCL,YSCL)
      XOFF = XMIN - 0.05/SCL
      YOFF = YMIN - 0.05/SCL
C
      CHRD = SQRT((XTE-XLE)**2 + (YTE-YLE)**2)
      DSN = XSIZ * 0.01*CHRD
C
      SBSIDE(1) = SB(1  ) - SBLE
      SBSIDE(2) = SB(IIB) - SBLE
C
      CALL GETCOLOR(ICOL0)
C
C---- plot horizontal axial chord line
      CALL NEWCOLORNAME('green')
      CALL NEWPEN(1)
      XAX = SCL*(XTE-XLE)
      XP = SCL*(XLE-XOFF)
      YP = SCL*(YLE-YOFF)
      CALL PLOT(XP,YP,3)
      CALL PLOT(XP+XAX,YP,2)
C
C---- add tick marks
      DO 20 IT=1, 9
        XT = XP + XAX*0.1*FLOAT(IT)
        DT = 0.003*XSIZ
        IF(IT.EQ.5) DT = 0.005*XSIZ
        CALL PLOT(XT,YP-DT,3)
        CALL PLOT(XT,YP+DT,2)
   20 CONTINUE
C
      CALL NEWCOLOR(ICOL0)
C
C---- plot airfoil sides
      I = 1
      DO 30 IS=1, 2
C
        IF(IS.EQ.1) THEN
          SREF1 = XSREF1
          SREF2 = XSREF2
        ELSE
          SREF1 = XPREF1
          SREF2 = XPREF2
        ENDIF
C
cC------ plot diamond symbol at stagnation point
c        XX =  SEVAL(SBLE,XB(I),XPB(I),SB(I),IIB)
c        YY =  SEVAL(SBLE,YB(I),YPB(I),SB(I),IIB)
c        XN =  DEVAL(SBLE,YB(I),YPB(I),SB(I),IIB)
c        YN = -DEVAL(SBLE,XB(I),XPB(I),SB(I),IIB)
c        XP = SCL*(XX-XOFF)
c        YP = SCL*(YY-YOFF)
c        CHS = 0.75*SCL*DSN
c        CHA = ATAN2(YN,XN) * 45.0/ATAN(1.0)
c        CALL PLSYMB(XP,YP,CHS,5,CHA,0)
c        CALL PLOT(XP,YP,3)
C
C------ plot surface
        DO 302 IG=1, NBLD
          SBI = SBLE + SG(IG,IS)*SBSIDE(IS)
          XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          XP = SCL*(XX-XOFF)
          YP = SCL*(YY-YOFF)
C
          IF(IG.EQ.1) THEN
           CALL PLOT(XP,YP,3)
           GO TO 302
          ENDIF
C
          IF(SREF1.GE.SG(IG-1,IS) .AND. 
     &       SREF1.LT.SG(IG  ,IS)      ) THEN
           SBI = SBLE + SREF1*SBSIDE(IS)
           XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
           YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
           XPR = SCL*(XX-XOFF)
           YPR = SCL*(YY-YOFF)
           CALL PLOT(XPR,YPR,2)
           CALL NEWCOLORNAME('magenta')
          ENDIF
C
          IF(SREF2.GT.SG(IG-1,IS) .AND. 
     &       SREF2.LE.SG(IG  ,IS)      ) THEN
           SBI = SBLE + SREF2*SBSIDE(IS)
           XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
           YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
           XPR = SCL*(XX-XOFF)
           YPR = SCL*(YY-YOFF)
           CALL PLOT(XPR,YPR,2)
           CALL NEWCOLOR(ICOL0)
          ENDIF
C
          CALL PLOT(XP,YP,2)
 302    CONTINUE
C
C
C------ plot normal tick marks outside airfoil
        CALL NEWCOLORNAME('orange')
        DO 304 IG=1, NBLD
          SBI = SBLE + SG(IG,IS)*SBSIDE(IS)
          XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          XN =  DEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          YN = -DEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          XP = SCL*(XX-XOFF)
          YP = SCL*(YY-YOFF)
C
          CALL PLOT(XP+SCL*DSN*XN,YP+SCL*DSN*YN,3)
          CALL PLOT(XP,YP,2)
 304    CONTINUE
C
C------ fractional arc length tick marks inside element
        CALL NEWCOLORNAME('cyan')
        DO 306 IT=0, 10
          SFRAC = FLOAT(IT)/10.0
          SBI = SBLE + SFRAC*SBSIDE(IS)
          XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          XN =  DEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          YN = -DEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          XP = SCL*(XX-XOFF)
          YP = SCL*(YY-YOFF)
          SCLF = -0.5*SCL
          IF(MOD(IT,5).EQ.0) SCLF = -SCL
          CALL PLOT(XP,YP,3)
          CALL PLOT(XP+SCLF*DSN*XN,YP+SCLF*DSN*YN,2)
 306    CONTINUE
C
        DO 308 IT=1, 9
          SFRAC = 0.1 * FLOAT(IT)/10.0
          SBI = SBLE + SFRAC*SBSIDE(IS)
          XX =  SEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          YY =  SEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          XN =  DEVAL(SBI,YB(I),YPB(I),SB(I),IIB)
          YN = -DEVAL(SBI,XB(I),XPB(I),SB(I),IIB)
          XP = SCL*(XX-XOFF)
          YP = SCL*(YY-YOFF)
          SCLF = -0.15*SCL
          IF(MOD(IT,5).EQ.0) SCLF = -0.25*SCL
          CALL PLOT(XP,YP,3)
          CALL PLOT(XP+SCLF*DSN*XN,YP+SCLF*DSN*YN,2)
 308    CONTINUE
C
        CALL NEWCOLOR(ICOL0)
C
 30   CONTINUE
C
      CALL PLFLUSH
      CALL PLEND
C
      RETURN
      END ! PLNODE





      SUBROUTINE PLTCRV(SBLE,SB,CV,CVS,IIB,XSIZ,YSIZ)
C
C---- Plot the blade, showing the node spacing
C
      DIMENSION  SB(IIB),CV(IIB),CVS(IIB)
      CHARACTER*1 ANS
C
      CALL PLTINI
      CALL PLOT(0.05*XSIZ,0.05*YSIZ,-3)
C
      SWT = 1.0/ABS( SB(1)- SB(IIB))
      CWT = 0.005
      DWT = 0.7/ABS(CVS(1)-CVS(IIB))
C
      CALL PLOT( 0.0,0.0,3)
      CALL PLOT(XSIZ,0.0,2)
C
      CALL PLOT(XSIZ*(1.0-SB(1)*SWT),CV(1)*CWT,3)
      DO 10 I=2, IIB
        ipen = 2
ccc        IPEN = MOD(I,2) + 2
        CALL PLOT(XSIZ*(1.0-SB(I)*SWT),CV(I)*CWT,IPEN)
 10   CONTINUE
C
      CALL PLOT(XSIZ*(1.0-SB(1)*SWT),CVS(1)*DWT,3)
      DO 20 I=2, IIB
        CALL PLOT(XSIZ*(1.0-SB(I)*SWT),CVS(I)*DWT,2)
 20   CONTINUE
C
      DO 30 I=1, IIB-1
        IF(SBLE.GT.SB(I) .AND. SBLE.LE.SB(I+1)) THEN
         FRAC = (SBLE-SB(I)) / (SB(I+1)-SB(I))
         CVLE  = CV(I)  + FRAC*(CV(I+1) -CV(I) )
         CVSLE = CVS(I) + FRAC*(CVS(I+1)-CVS(I))
         CALL PLSYMB(XSIZ*(1.0-SBLE*SWT),CVLE *CWT,0.018,3,0.0,0)
         CALL PLSYMB(XSIZ*(1.0-SBLE*SWT),CVSLE*DWT,0.018,3,0.0,0)
        ENDIF
 30   CONTINUE
C
      CALL PLFLUSH
C
      WRITE(*,*) 'Hit <cr>'
      READ (*,1000) ANS
 1000 FORMAT(A)
C
      RETURN
      END



      SUBROUTINE PLTCPX
      INCLUDE 'STATE.INC'
      INCLUDE 'MSET.INC'
C-------------------------------
C     Makes  Cp vs x/c  plot
C-------------------------------
C
C---- plot aspect ratio and character height (plot width = 1)
      PAR = 0.50
      CH = 0.018
C
C---- distance from bottom of plot to bottom of Cp axis
      YSPACE = 0.20
C
C---- Cp limits on y axis
CC      CPMAX =  1.0
CC      CPMIN = -2.0*FLOAT(NBL)
CC      CPDEL = -0.5
CC      IF(CPMIN.LT.-6.0) CPDEL = -1.0
C
      CALL CPLIMS(0,CPMIN,CPMAX)
      CPDEL = -0.5
      IF(CPMIN.LT.-5.99) CPDEL = -1.0
C
      CPMAX = 1.0
      CPMIN = CPDEL * AINT(CPMIN/CPDEL + 1.0)
      CPMIN = MIN( CPMIN , -1.0 )
C
C---- scale factor for Cp
      PFAC = PAR/(CPMAX-CPMIN)
C
C---- label upper left corner position
      XLABEL = 0.65
      YLABEL = -CPMIN*PFAC
C
C---- set airfoil coordinate x,y limits
      XBMAX = -1.0E9
      YBMAX = -1.0E9
      XBMIN =  1.0E9
      YBMIN =  1.0E9
      DO 5 N=1, NBL
        XBMAX = MAX(XBMAX,XBNOSE(N),XBTAIL(N))
        YBMAX = MAX(YBMAX,YBNOSE(N),YBTAIL(N))
        XBMIN = MIN(XBMIN,XBNOSE(N),XBTAIL(N))
        YBMIN = MIN(YBMIN,YBNOSE(N),YBTAIL(N))
 5    CONTINUE
C
C---- scale factor and offsets for airfoil 
      FACAIR = 0.70/(XBMAX-XBMIN)
      XOFAIR = 0.10/FACAIR - XBMIN
      YOFAIR = -(CPMAX*PFAC+YSPACE/3.0)/FACAIR - 0.5*(YBMIN+YBMAX)
C
C---- start new plot
      CALL PLTINI
C
      CALL PLOT(6.0*CH,CPMAX*PFAC+YSPACE,-3)
C
C---- plot Cp axis from Cpmax to Cpmin
      CALL YAXIS(0.0,-CPMAX*PFAC,-(CPMIN-CPMAX)*PFAC,-CPDEL*PFAC,
     &           CPMAX,CPDEL,0.9*CH,1)
      CALL NEWPEN(3)
      YLAB = (FLOAT(INT(CPMIN/CPDEL + 0.01)/2) + 0.5)
     &     * (-CPDEL)*PFAC - 0.6*CH
      CALL PLCHAR(-4.0*CH,YLAB       ,1.2*CH,'C',0.0,1)
      CALL PLCHAR(  999.0,YLAB-0.4*CH,0.9*CH,'p',0.0,1)
C
C---- plot Cp=0 line
      CALL NEWPEN(1)
      CALL PLOT(0.,0.,3)
      CALL PLOT(1.,0.,2)
C
C---- add large and small tick marks on Cp=0 line
      DO 10 IT=0, 2
        XTIK = 0.5*FLOAT(IT)
        CALL PLOT((XTIK+XOFAIR)*FACAIR,0.005,3)
        CALL PLOT((XTIK+XOFAIR)*FACAIR,-.005,2)
   10 CONTINUE
C
      DO 15 IT=1, 9
        XTIK = 0.1*FLOAT(IT)
        CALL PLOT((XTIK+XOFAIR)*FACAIR,0.0025,3)
        CALL PLOT((XTIK+XOFAIR)*FACAIR,-.0025,2)
   15 CONTINUE
C
C---- plot element contours
      CALL NEWPEN(2)
      DO 20 N=1, NBL
      CALL PLOT((XB(1,N)+XOFAIR)*FACAIR,(YB(1,N)+YOFAIR)*FACAIR,3)
      DO 210 I=2, IIB(N)
        CALL PLOT((XB(I,N)+XOFAIR)*FACAIR,(YB(I,N)+YOFAIR)*FACAIR,2)
  210 CONTINUE
   20 CONTINUE
C
      CALL NEWPEN(1)
C
      DO 30 IS=1, 2*NBL
C
C------ streamlines
        IPEN = 3
        DO 310 IST=1, NST(IS)
          XPLT = XST(IST,IS)
          YPLT = YST(IST,IS)
          CALL PLOT((XPLT+XOFAIR)*FACAIR,(YPLT+YOFAIR)*FACAIR,IPEN)
          IPEN = 2
  310   CONTINUE
C
   30 CONTINUE
C
C---- mark aerodynamic center with small cross
      XCOFF = XCENT + XOFAIR
      YCOFF = YCENT + YOFAIR
      CALL PLOT((XCOFF-0.01)*FACAIR,(YCOFF     )*FACAIR,3)
      CALL PLOT((XCOFF+0.01)*FACAIR,(YCOFF     )*FACAIR,2)
      CALL PLOT((XCOFF     )*FACAIR,(YCOFF-0.01)*FACAIR,3)
      CALL PLOT((XCOFF     )*FACAIR,(YCOFF+0.01)*FACAIR,2)
C
C
C---- plot inviscid -Cp distribution on airfoil only
      CALL NEWPEN(2)
      DO 50 N=1, NBL
        CALL CPELPL(N,(-XOFAIR),0.0,FACAIR,(-PFAC))
   50 CONTINUE
C
      CALL NEWPEN(3)
      XPLT = XLABEL
      YPLT = YLABEL
      CALL PLCHAR(XPLT,YPLT,1.1*CH,NAME,0.0,31)
C
      CALL NEWPEN(2)
      CCH = 0.90*CH
C
      ADEG = ALFA * 180.0/PIE
      YPLT = YPLT - 2.0*CCH
      CALL PLCHAR(XLABEL,YPLT,CCH,'Alfa =  ',0.0,8)
      CALL PLNUMB(999.,999.,CCH,ADEG,0.,3)
C
      CL = 2.0*CIRC
      YPLT = YPLT - 2.0*CCH
      CALL PLCHAR(XLABEL,YPLT,CCH,'CL   =  ',0.0,8)
      CALL PLNUMB(999.,999.,CCH,CL,0.,3)
C
      CALL PLFLUSH
      CALL PLEND
C
      RETURN
      END
      
