      PROGRAM MXPLOT
      INCLUDE 'MXPLOT.INC'
      CHARACTER*1 ANS
C
C---- Plotting flag
      IDEV = 1   ! X11 window only
C     IDEV = 2   ! B&W PostScript output file only (no color)
C     IDEV = 3   ! both X11 and B&W PostScript file
C     IDEV = 4   ! Color PostScript output file only 
C     IDEV = 5   ! both X11 and Color PostScript file 

C---- Re-plotting flag (for hardcopy)
      IDEVRP = 2   ! B&W PostScript
C     IDEVRP = 4   ! Color PostScript
C
C---- PostScript output logical unit and file specification
      IPSLU = 0  ! output to file  plot.ps   on LU 4    (default case)
C     IPSLU = ?  ! output to file  plot?.ps  on LU 10+?
C
C---- screen fraction taken up by plot window upon opening
      SCRNFR = 0.70
C
C---- Default plot size in inches
C-    (Default plot window is 11.0 x 8.5)
      SIZE = 8.0
C
      LCOLOR = .TRUE.
C
      CH = 0.018
      LPLOT = .FALSE.
C
      CALL PLINITIALIZE
C
      CALL READIT
C
      LGRID = .FALSE.
      LSYMB = .FALSE.
C
CCC      CALL SORT
C
    2 WRITE(*,*)
      WRITE(*,*) '  1   Select point(s)'
      WRITE(*,*) '  2   Plot selected point(s)'
      WRITE(*,*)
      WRITE(*,*) 'Select option (0=quit):'
      WRITE(*,*)
C
      READ (*,*,ERR=2) IOPT
C
      GO TO ( 9, 10, 20 ), IOPT+1
      GO TO 2
C
    9 IF(LPLOT) CALL PLCLOSE
      STOP
C
   10 CALL SELPNT
      GO TO 2
C
   20 CALL PLTPNT
      GO TO 2
C
      END ! MXPLOT



      SUBROUTINE SELPNT
C.............................................
C     Requests the user to select the target 
C     points for all the surface plots. NAPLT
C     points are selected and their indices 
C     are saved in the IAPLT array.
C.............................................
      INCLUDE 'MXPLOT.INC'
      CHARACTER*80 RECORD
      LOGICAL ERROR
C
      WRITE(*,*)
      WRITE(*,*) 'Computed points are:'
      WRITE(*,*)
      IF(LMACH) THEN
C
       WRITE(*,*)
     &  '  Mach    alpha    CL       CD      CDw      CM   S xtr P xtr'
CCC       0.8750 -10.111  1.1111  1.00000  1.00000  1.0000 1.000 1.000
       DO 11 IA=1, NA
         WRITE(*,9110) MA(IA),
     &    ALFA(IA),CL(IA),CD(IA),CDW(IA),CM(IA),(XTR(IS,IA),IS=1,2*NBL)
 9110    FORMAT(1X,F7.4,F8.3,F8.4,2F9.5,F8.4,10F6.3)
   11  CONTINUE
C
      ELSE
C 
       WRITE(*,*)
     &  '  alpha    CL       CD      CDw      CM   S xtr P xtr'
CCC      -10.234  1.1111  1.00000  1.00000  1.0000 1.000 1.000
       DO 12 IA=1, NA
         WRITE(*,9120) ALFA(IA),
     &    CL(IA),CD(IA),CDW(IA),CM(IA),(XTR(IS,IA),IS=1,2*NBL)
 9120    FORMAT(1X,F7.3,F8.4,2F9.5,F8.4,10F6.3)
   12  CONTINUE
 
      ENDIF
C
    3 CONTINUE
C
      IF(LMACH) THEN
       WRITE(*,*)
       WRITE(*,*)
     &     'Enter Mach(s) of point(s) to be plotted:'
       READ (*,9200) RECORD
      ELSE
       WRITE(*,*)
       WRITE(*,*)
     &     'Enter alpha(s) of point(s) to be plotted:'
       READ (*,9200) RECORD
      ENDIF
 9200 FORMAT(A80)
C
      CALL GETFLT(RECORD,APLT,NAPLT,ERROR)
      IF(ERROR) GO TO 3
C
C---- do not make any changes if just a <CR> was input
      IF(NAPLT.EQ.0) RETURN
C
      IF(LMACH) THEN
C
C---- save selected point indices and count up how many points there are
      ICOL = 2
      DO 50 KA=1, NAPLT
        IAPLT(KA) = 0
        DO 510 IA=1, NA 
          IF(ABS(APLT(KA)-MA(IA)) .LE. 0.00011) THEN
           IAPLT(KA) = IA
           ICOL = ICOL + 1
           IF(ICOL.GT.10) ICOL = 3
           IACOL(KA) = ICOL
          ENDIF
  510   CONTINUE
        IF(IAPLT(KA).EQ.0) THEN
         WRITE(*,9500) APLT(KA)
 9500    FORMAT(1X,'Mach  = ',F7.4,'  has not been computed')
         GO TO 3
        ENDIF
   50 CONTINUE
C
      ELSE
C
C---- save selected point indices and count up how many points there are
      ICOL = 2
      DO 60 KA=1, NAPLT
        IAPLT(KA) = 0
        DO 610 IA=1, NA 
          IF(ABS(APLT(KA)-ALFA(IA)) .LE. 0.0011) THEN
           IAPLT(KA) = IA
           ICOL = ICOL + 1
           IF(ICOL.GT.10) ICOL = 3
           IACOL(KA) = ICOL
          ENDIF
  610   CONTINUE
        IF(IAPLT(KA).EQ.0) THEN
         WRITE(*,9600) APLT(KA)
 9600    FORMAT(1X,'alpha = ',F6.3,'  has not been computed')
         GO TO 3
        ENDIF
   60 CONTINUE
C
      ENDIF
C
      RETURN
      END ! SELPNT



      SUBROUTINE PLTPNT
      INCLUDE 'MXPLOT.INC'
      LOGICAL ERROR
      CHARACTER*2 ANS
      DIMENSION AINPUT(3)
C
      DATA LMASK1, LMASK2, LMASK3 / -32640, -30584, -21846 /
      REAL DYGARR(10)
C
C---- initialize variable scales
      CALL SCLINI
C
C---- default flags
      LAIRFF = .TRUE.
      LFOREF = .FALSE.
      LREF   = .FALSE.
      LPWAKE = .FALSE.
C
C---- number of grid intervals per axis annotation interval
      NGR = 2
C
C---- default forground color
      ICOL0 = 1
C
C---- clear plot-type indicators
      KPLOT = 0
      NPLOT = 0
C
      KSYMB = -1
C
      SH  = 0.25*CH
      CHI = 0.70*CH
C
C---- plot all elements initially
      NBPLT = 0
      IF(NBL.EQ.1) NBPLT = 1
C
C
C---- plot aspect ratio
      PAR = 0.65
C
C---- label block x-locations on M,Cp and BL plots
      XLAB1 = 0.60
      XLAB2 = 0.70
C
      WRITE(*,*)
      WRITE(*,*) 'Selected points are:'
      WRITE(*,*)
      WRITE(*,*)
     &  '  alpha   Mach    CL       CD      CDw      CM   S xtr P xtr'
      DO 1 KA=1, NAPLT
        IA = IAPLT(KA)
        WRITE(*,9120) ALFA(IA),
     &     MA(IA),CL(IA),CD(IA),CDW(IA),CM(IA),(XTR(IS,IA),IS=1,2*NBL)
 9120   FORMAT(1X,F7.3,F7.3,F8.4,2F9.5,F8.4,10F6.3)
    1 CONTINUE
C
 1100 FORMAT(A)
C
 990  WRITE(*,*)
      WRITE(*,*) '  1     Mach vs x'
      WRITE(*,*) '  2     Cp   vs x'
      WRITE(*,*) '                  ___________________________________'
      WRITE(*,*) '  3     Hk   vs x'
      WRITE(*,*) '  4 top D,T  vs x'
      WRITE(*,*) '  5 bot D,T  vs x'
      WRITE(*,*) '  6     Cf   vs x'
      WRITE(*,*) '  8     A/Ao vs x'
      WRITE(*,*) '  9     Ctau vs x'
      WRITE(*,*) ' 10     Rth  vs x'
      WRITE(*,*) '                  ___________________________________'
      WRITE(*,*) ' 12  Change settings'
      IF(NBL.GT.1)
     &WRITE(*,*) ' 13  Change element for plotting'
      WRITE(*,*) ' 14  Hardcopy current plot'
      WRITE(*,*) ' 16  Change x-axis limits for BL plots'
      WRITE(*,*) ' 17  Change y-axis limits for current plot'
      WRITE(*,*) ' 20  Annotation menu'
C
  995 WRITE(*,1995)
 1995 FORMAT(/1X,'Select surface plot (0 = return):  ',$)
      READ (*,*,ERR=990) NOPT
      IF(NOPT.EQ.0) RETURN
C
 3    GO TO( 10, 20, 30, 40, 50, 60,990, 80, 90,100,
     &      990,120,130,140,990,160,170,990,990,200 ) , NOPT
      GO TO 990
C
C===============================================
C**** Plot Mach vs x
C
   10 NF = 0
      IF(LREF) CALL GETREF(XF,MF,NF)
C
      DO 11 KA=1, NAPLT
        IA = IAPLT(KA)
        MACHSQ = MA(IA)**2
        DO 12 IS=1, 2*NBL
          CALL MASET(GAM,MACHSQ, CP(1,IS,IA), Y(1,IS,IA), II-1)
   12   CONTINUE
   11 CONTINUE
C
cc      XLE = 0.12
cc      XTE = 0.72
      XLE = 0.10
      XTE = 0.80
      IF(NBPLT.EQ.0) THEN
cc       XOFF = -.25
cc       XSF = 0.60
cc       XLE = (0.0 - XOFF)*XSF
cc       XTE = (1.0 - XOFF)*XSF
       XSF = (XTE-XLE)/(XBMAX-XBMIN)
       XOFF = XBMAX - XTE/XSF
       AYOFF = YBMAX + 0.03
       AHGHT = YBMAX-YBMIN
      ELSE
       XSF = (XTE-XLE)/(XBTAIL(NBPLT)-XBNOSE(NBPLT))
       XOFF = XBTAIL(NBPLT) - XTE/XSF
       AYOFF = YBTOP(NBPLT) + 0.03
       AHGHT = YBTOP(NBPLT)-YBBOT(NBPLT)
      ENDIF
C
      YOFF = MAMIN
      YSF = PAR/(MAMAX-MAMIN)
C
      YAXL = YSF*(MAMAX-MAMIN)
C
      DYANN = YSF*MADEL
C
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(6.0*CH,0.10+AHGHT*XSF,-3)
C
      CALL YAXIS(0.0,0.0,YAXL,DYANN,MAMIN,MADEL,CH,1)
C
      CALL NEWPEN(3)
      CALL PLCHAR(-3.0*CH,YAXL-1.5*DYANN-0.7*CH,1.4*CH,'M',0.0,1)
C
      CALL NEWPEN(1)
      YDASH = YSF*(1.0-YOFF)
      IF(1.0.LE.MAMAX) CALL DASH(0.0,0.95,YDASH)
      CALL XTICK(XLE,XTE,1.0,YSF*(MACH-YOFF))
C
      CALL IDENT(0.0,YAXL)
C
      IF(LAIRFF) THEN
       CALL NEWPEN(2)
       DO 15 N=1, NBL
ccc         CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
ccc      &              XPB(1,N),YPB(1,N),SB(1,N),XOFF,AYOFF,XSF,
ccc      &              0.0,0.0,0.0)
         CALL AIRFOI(IIB(N),XB(1,N),YB(1,N),
     &               XOFF,AYOFF,XSF,
     &               0.0,0.0,0.0)
   15  CONTINUE
      ENDIF
C
      CALL NEWPEN(2)
      DO 17 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 171 IS=1, 2*NBL
          N = (IS+1)/2
          IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
           IBEG = ILEB(N)
           IEND = ITEB(N)
           IF(LPWAKE) IEND = II-1
           IDIF = IEND - IBEG + 1
           CALL XYLINE(IDIF,X(IBEG,IS,IA),Y(IBEG,IS,IA),
     &                 XOFF,XSF,YOFF,YSF,ILIN)
           CALL XYSYMB(IDIF,X(IBEG,IS,IA),Y(IBEG,IS,IA),
     &                 XOFF,XSF,YOFF,YSF,SH,KSYMB)
          ENDIF
 171    CONTINUE
 17   CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF)
     & CALL RFPLOT(NF,XF,MF,XOFF,XSF,YOFF,YSF,0.5*CH,5)
C
      CALL PLTFOR(XLAB1,YAXL)
C
      IF(LGRID) THEN
       XAXL = XTE-XLE
       DXANN = 0.1*XAXL
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(XLE,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 1
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C
C===============================================
C**** Plot Cp vs x
C
   20 NF = 0
      IF(LREF) CALL GETREF(XF,MF,NF)
C
      DO 21 KA=1, NAPLT
        IA = IAPLT(KA)
        DO 22 IS=1, 2*NBL
          DO 23 I=1, II-1
            Y(I,IS,IA) = -CP(I,IS,IA)
   23     CONTINUE
   22   CONTINUE
   21 CONTINUE
C
      PFAC = PAR/(CPMAX-CPMIN)
C
cc      XLE = 0.12
cc      XTE = 0.72
      XLE = 0.10
      XTE = 0.80
      IF(NBPLT.EQ.0) THEN
cc       XOFF = -.25
cc       XSF = 0.60
cc       XLE = (0.0 - XOFF)*XSF
cc       XTE = (1.0 - XOFF)*XSF
       XSF = (XTE-XLE)/(XBMAX-XBMIN)
       XOFF = XBMAX - XTE/XSF
       AYOFF = YBMAX + 0.03
       AHGHT = YBMAX-YBMIN
      ELSE
       XSF = (XTE-XLE)/(XBTAIL(NBPLT)-XBNOSE(NBPLT))
       XOFF = XBTAIL(NBPLT) - XTE/XSF
       AYOFF = YBTOP(NBPLT) + 0.03
       AHGHT = YBTOP(NBPLT)-YBBOT(NBPLT)
      ENDIF
C
C
      YOFF = -CPMAX
      YSF = PAR/(CPMAX-CPMIN)
C
      YAXL = YSF*(CPMAX-CPMIN)
C
      DYANN = -YSF*CPDEL
C
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(6.0*CH,0.10+AHGHT*XSF,-3)
C
      CALL YAXIS(0.0,0.0,YAXL,DYANN,CPMAX,CPDEL,CH,1)
C
      CALL NEWPEN(3)
      YLAB = YAXL-1.5*DYANN-0.7*CH
      CALL PLCHAR(-3.5*CH,YLAB       ,1.4*CH,'C',0.0,1)
      CALL PLCHAR(-2.4*CH,YLAB-0.4*CH,0.9*CH,'P',0.0,1)
C
      IF(.NOT.LMACH) THEN
       CALL NEWPEN(1)
       DO 24 KA=1, NAPLT
         IA = IAPLT(KA)
         CALL NEWCOLOR(IACOL(KA))
         YDASH = (-CPSTAR(IA)-YOFF)*YSF
         IF(CPSTAR(IA).GE.CPMIN) CALL DASH(0.0,0.75,YDASH)
   24  CONTINUE
       CALL NEWCOLOR(ICOL0)
      ENDIF
C
      CALL NEWPEN(1)
      CALL XTICK(XLE,XTE,1.0,(0.0-YOFF)*YSF)
C
      CALL IDENT(0.0,YAXL)
C
      IF(LAIRFF) THEN
       CALL NEWPEN(2)
       DO 25 N=1, NBL
ccc         CALL AIRFPL(IIB(N),XB(1,N),YB(1,N),
ccc     &               XPB(1,N),YPB(1,N),SB(1,N),XOFF,AYOFF,XSF,
ccc     &               0.0,0.0,0.0)
         CALL AIRFOI(IIB(N),XB(1,N),YB(1,N),
     &               XOFF,AYOFF,XSF,
     &               0.0,0.0,0.0)
   25  CONTINUE
      ENDIF
C
      DO 27 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        IF(LMACH) THEN
         CALL NEWPEN(1)
         YDASH = (-CPSTAR(IA)-YOFF)*YSF
         IF(CPSTAR(IA).GE.CPMIN) CALL DASH(0.0,0.95,YDASH)
         CALL NEWPEN(2)
        ENDIF
        DO 270 IS=1, 2*NBL
          N = (IS+1)/2
          IF(NBPLT.EQ.N .OR. NBPLT.EQ.0) THEN
           IBEG = ILEB(N)
           IEND = ITEB(N)
           IF(LPWAKE) IEND = II-1
           IDIF = IEND - IBEG + 1
           CALL XYLINE(IDIF,X(IBEG,IS,IA),Y(IBEG,IS,IA),
     &                 XOFF,XSF,YOFF,YSF,ILIN)
           CALL XYSYMB(IDIF,X(IBEG,IS,IA),Y(IBEG,IS,IA),
     &                 XOFF,XSF,YOFF,YSF,SH,KSYMB)
          ENDIF
  270    CONTINUE
   27 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      IF(LREF)
     & CALL RFPLOT(NF,XF,MF,XOFF,XSF,YOFF,YSF,0.5*CH,5)
C
      CALL PLTFOR(XLAB1,YAXL)
C
      IF(LGRID) THEN
       XAXL = XTE-XLE
       DXANN = 0.1*XAXL
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(XLE,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 2
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** Plot H vs x
C
   30 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      N = NBPLT
C      
C---- Find Hk for plotting
      DO 32 KA=1, NAPLT
        IA = IAPLT(KA)
        MACHSQ = MA(IA)**2
        DO 33 IS=2*N-1, 2*N
          I = ILEB(N)+1
          NUM = II-1 - ILEB(N)
          CALL HKSET(GAM,MACHSQ, 
     &               DSTR(I,IS,IA),THET(I,IS,IA),CP(I,IS,IA), 
     &                  Y(I,IS,IA), NUM)
   33   CONTINUE
   32 CONTINUE
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
C
      XOFF = XIMIN(N)
      YOFF = HKMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(HKMAX(N)-HKMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(HKMAX(N)-HKMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*HKDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,HKMIN(N),HKDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
      CALL PLCHAR(-4.0*CH,YAXL-1.5*DYANN-0.7*CH,1.4*CH,'H',0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN-1.1*CH,0.9*CH,'k',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
C---- plot shape parameter over airfoil surface and wake
C
      CALL NEWPEN(2)
      DO 35 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 36 IS=2*N-1, 2*N
          IL = ILEB(N)
          IEND = II-1
          CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),Y(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,ILIN)
          CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),Y(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,SH,KSYMB)
   36   CONTINUE
   35 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 3
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** plot top side Dstar, Theta vs x 
C
   40 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
      XOFF = XIMIN(N)
      YOFF = DSMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(DSMAX(N)-DSMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(DSMAX(N)-DSMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*DSDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,DSMIN(N),DSDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.5*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'Top',0.0,3)
      CALL PLMATH(-4.0*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'d'  ,0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN+0.8*CH,0.8*CH,'*'  ,0.0,1)
      CALL PLMATH(-3.5*CH,YAXL-2.5*DYANN-0.6*CH,1.4*CH,'q'  ,0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      IS = 2*N - 1
C
      CALL NEWPEN(2)
      DO 45 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
C
        IL = ILEB(N)
        IEND = II-1
        CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),DSTR(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,ILIN)
        CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),DSTR(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,SH,KSYMB)
        CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),THET(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,ILIN)
        CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),THET(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,SH,KSYMB)
   45 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 4
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** plot bottom side Dstar, Theta vs x 
C
   50 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
      XOFF = XIMIN(N)
      YOFF = DSMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(DSMAX(N)-DSMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(DSMAX(N)-DSMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*DSDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,DSMIN(N),DSDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.5*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'Bot',0.0,3)
      CALL PLMATH(-4.0*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'d'  ,0.0,1)
      CALL PLCHAR(-2.7*CH,YAXL-1.5*DYANN+0.8*CH,0.8*CH,'*'  ,0.0,1)
      CALL PLMATH(-3.5*CH,YAXL-2.5*DYANN-0.6*CH,1.4*CH,'q'  ,0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      IS = 2*N
C
      CALL NEWPEN(2)
      DO 55 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
C
        IL = ILEB(N)
        IEND = II-1
        CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),DSTR(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,ILIN)
        CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),DSTR(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,SH,KSYMB)
        CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),THET(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,ILIN)
        CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),THET(IL+1,IS,IA),
     &               XOFF,XSF,YOFF,YSF,SH,KSYMB)
   55 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 5
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** Plot Cf vs x
C
   60 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
      XOFF = XIMIN(N)
      YOFF = CFMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(CFMAX(N)-CFMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(CFMAX(N)-CFMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*CFDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,CFMIN(N),CFDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.0*CH,YAXL-1.5*DYANN-0.7*CH,1.4*CH,'C',0.0,1)
      CALL PLCHAR(-2.8*CH,YAXL-1.5*DYANN-1.1*CH,1.0*CH,'f',0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      CALL NEWPEN(2)
      DO 66 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 67 IS=2*N-1, 2*N
          IL = ILEB(N)
          IEND = II-1
          CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),CF(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,ILIN)
          CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),CF(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,SH,KSYMB)
   67   CONTINUE
   66 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 6
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** plot A/Ao vs x
   80 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
      XOFF = XIMIN(N)
      YOFF = ANMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(ANMAX(N)-ANMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(ANMAX(N)-ANMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*ANDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,ANMIN(N),ANDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-4.0*CH,YAXL-0.5*DYANN-0.6*CH,1.2*CH,'ln' ,0.0,2)
      CALL PLCHAR(-5.0*CH,YAXL-1.5*DYANN-0.6*CH,1.2*CH,'A/A',0.0,3)
      CALL PLCHAR(-1.4*CH,YAXL-1.5*DYANN-1.0*CH,0.8*CH,'0'  ,0.0,1)
C
      CALL GETCLIP(XCLIP1,XCLIP2,YCLIP1,YCLIP2)
      CALL NEWCLIP(0.0,XAXL,0.0,YAXL,1)
C
      CALL DASH(0.0,XAXL,(ACRIT-YOFF)*YSF)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      CALL NEWPEN(2)
      DO 85 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 86 IS=2*N-1, 2*N
          IL = ILEB(N)
          ITR = ITRAN(IS,IA)
          CALL XYLINE(ITR-(IL+1),X(IL+1,IS,IA),CTAU(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,ILIN)
          CALL XYSYMB(ITR-(IL+1),X(IL+1,IS,IA),CTAU(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,SH,KSYMB)
   86   CONTINUE
   85 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 8
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** Plot Ctau vs x
C
   90 CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      N = NBPLT
C
      DO 92 KA=1, NAPLT
        IA = IAPLT(KA)
        DO 93 IS=2*N-1, 2*N
          ITR = ITRAN(IS,IA)
          IEND = II-1
          DO 94 I=ITR, IEND
            Y(I,IS,IA) = CTAU(I,IS,IA)
   94     CONTINUE
   93   CONTINUE
   92 CONTINUE
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
      XOFF = XIMIN(N)
      YOFF = CTMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(CTMAX(N)-CTMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(CTMAX(N)-CTMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*CTDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,CTMIN(N),CTDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x' ,0.0,1)
C
      CALL PLMATH(-3.7*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,' H',0.0,2)
      CALL PLCHAR(-3.7*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'C ',0.0,2)
      CALL PLMATH(-3.7*CH,YAXL-1.5*DYANN-1.0*CH,1.1*CH,' t',0.0,2)
CCC   CALL PLCHAR(-1.8*CH,YAXL-1.5*DYANN-1.4*CH,0.7*CH,'eq',0.0,2)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      CALL NEWPEN(2)
      DO 95 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 96 IS=2*N-1, 2*N
          ITR = ITRAN(IS,IA)
          IEND = II-1
          CALL XYLINE(IEND-ITR,X(ITR,IS,IA),CTAU(ITR,IS,IA),
     &                XOFF,XSF,YOFF,YSF,ILIN)
          CALL XYSYMB(IEND-ITR,X(ITR,IS,IA),CTAU(ITR,IS,IA),
     &                XOFF,XSF,YOFF,YSF,SH,KSYMB)
   96   CONTINUE
   95 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR = NGR * INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN / FLOAT(NGR)
       CALL NEWPEN(1)
       CALL PLGRID(0.0,0.0, NXGR,DXG, NYGR,DYG, LMASK2 )
      ENDIF
C
      KPLOT = 9
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C---- log10(Rtheta)
C
 100  CONTINUE
      IF(NBPLT.EQ.0) THEN
       WRITE(*,*) 'Select element number first'
       GO TO 995
      ENDIF
C
      N = NBPLT
C      
C---- Find log10(Rtheta) for plotting
      DO 102 KA=1, NAPLT
        IA = IAPLT(KA)
        MACHSQ = MA(IA)**2
        DO 103 IS=2*N-1, 2*N
          I = ILEB(N)+1
          NUM = II-1 - ILEB(N)
          CALL RTSET(GAM,MACHSQ, RE(IA),
     &               THET(I,IS,IA),CP(I,IS,IA), 
     &                  Y(I,IS,IA), NUM)
  103   CONTINUE
  102 CONTINUE
C
      IF(LPLOT) CALL PLEND
      CALL PLOPEN(SCRNFR,IPSLU,IDEV)
      LPLOT = .TRUE.
C
      CALL NEWFACTOR(SIZE)
      CALL PLOT(7.0*CH,0.2,-3)
C
C
      XOFF = XIMIN(N)
      YOFF = RTMIN(N)
      XSF = 1.0/(XIMAX(N)-XIMIN(N))
      YSF = PAR/(RTMAX(N)-RTMIN(N))
C
      XAXL = XSF*(XIMAX(N)-XIMIN(N))
      YAXL = YSF*(RTMAX(N)-RTMIN(N))
C
      DXANN = XSF*XIDEL(N)
      DYANN = YSF*RTDEL(N)
C
      CALL NEWPEN(2)
      CALL XAXIS(0.0,0.0,XAXL,DXANN,XIMIN(N),XIDEL(N),CH,-2)
      CALL YAXIS(0.0,0.0,YAXL,DYANN,RTMIN(N),RTDEL(N),CH,-2)
C
      CALL NEWPEN(3)
      CALL PLCHAR(XAXL-1.5*DXANN-0.6*CH,-3.1*CH,1.4*CH,'x',0.0,1)
C
      CALL PLCHAR(-5.5*CH,YAXL-0.5*DYANN-0.6*CH,1.1*CH,'log',0.0,3)
      CALL PLCHAR(-2.0*CH,YAXL-0.5*DYANN-1.2*CH,0.8*CH,'10' ,0.0,2)
      CALL PLCHAR(-4.4*CH,YAXL-1.5*DYANN-0.6*CH,1.4*CH,'Re' ,0.0,2)
      CALL PLMATH(999.0  ,YAXL-1.5*DYANN-1.3*CH,1.0*CH,'q'  ,0.0,1)
C
      IF (NBL.GT.1 .AND. NBPLT.NE.0) THEN
        CALL NEWPEN(2)
        CALL PLCHAR(0.0    ,-4.0*CH,CHI,'Element '  ,0.0, 8)
        CALL PLNUMB(8.0*CHI,-4.0*CH,CHI,FLOAT(NBPLT),0.0,-1)
      ENDIF
C
      CALL IDENT(0.0,YAXL)
C
      CALL NEWPEN(2)
      DO 105 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        ILIN = KA
        DO 106 IS=2*N-1, 2*N
          IL = ILEB(N)
          IEND = II-1
          CALL XYLINE(IEND-1-IL,X(IL+1,IS,IA),Y(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,ILIN)
          CALL XYSYMB(IEND-1-IL,X(IL+1,IS,IA),Y(IL+1,IS,IA),
     &                XOFF,XSF,YOFF,YSF,SH,KSYMB)
  106   CONTINUE
  105 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      CALL PLTFOR(XLAB2,YAXL)
C
      IF(LGRID) THEN
       NXGR = NGR * INT(XAXL/DXANN + 0.001)
       NYGR =       INT(YAXL/DYANN + 0.001)
       DXG = DXANN / FLOAT(NGR)
       DYG = DYANN
C
       CALL NEWPEN(1)
C
       KK = 10
       DO 1005 K=1, KK
         FRAC = FLOAT(K+1)/FLOAT(K)
         DYGARR(K) = DYG * LOG10(FRAC)
 1005  CONTINUE
       DO 1008 IG=1, NYGR
         YG0 = DYG*FLOAT(IG-1)
         CALL PLGRID(0.0,YG0, NXGR,DXG, KK-1+1000,DYGARR, LMASK2)
 1008  CONTINUE
      ENDIF
C
      KPLOT = 10
      NPLOT = N
      CALL PLFLUSH
ccc      WRITE(*,*) 'Hit <return>'
ccc      READ (*,1100) ANS
      GO TO 995
C
C===============================================
C**** Change settings
C
  120 CONTINUE
      WRITE(*,*)
      WRITE(*,*) '  1  plot size'
      WRITE(*,*) '  2  toggle grid plotting'
      WRITE(*,*) '  3  toggle symbol plotting'
      WRITE(*,*) '  4  reference data overlay plotting flag'
      WRITE(*,*) '  5  force coefficient data plotting flag'
      WRITE(*,*) '  6  toggle airfoil plotting'
      WRITE(*,*) '  7  toggle wake Cp, Mach plotting'
      WRITE(*,*) '  8  case name'
      WRITE(*,*)
  122 WRITE(*,1230)
 1230 FORMAT(1X,'Change what ?  ',$)
      READ (*,1100) ANS
C
      IF(ANS.EQ.'0' .OR. ANS.EQ.' ') THEN
        GO TO 995
      ELSE IF(ANS.EQ.'1') THEN
 124    WRITE(*,*) 'Enter plot size:', SIZE
        CALL READR(1,SIZE,ERROR)
        IF(ERROR) GO TO 124
      ELSE IF(ANS.EQ.'2') THEN
        LGRID = .NOT.LGRID
        WRITE(*,*)
        IF(     LGRID) WRITE(*,*) 'Grid overlay will be plotted'
        IF(.NOT.LGRID) WRITE(*,*) 'Grid overlay will not be plotted'
      ELSE IF(ANS.EQ.'3') THEN
        IF(KSYMB.LT.0) THEN
          KSYMB = 1
        ELSE
          KSYMB = -1
        ENDIF
      ELSE IF(ANS.EQ.'4') THEN
        LREF = .NOT.LREF
        WRITE(*,*)
        IF(     LREF) WRITE(*,*) 'Reference data will be overlaid'
        IF(.NOT.LREF) WRITE(*,*) 'Reference data will not be overlaid'
      ELSE IF(ANS.EQ.'5') THEN
        LFOREF = .NOT.LFOREF
        WRITE(*,*)
        IF(     LFOREF) WRITE(*,*) 'Force coeff. data will be plotted'
        IF(.NOT.LFOREF) WRITE(*,*) 'Force coeff. data won''t be plotted'
      ELSE IF(ANS.EQ.'6') THEN
        LAIRFF = .NOT.LAIRFF
        WRITE(*,*)
        IF(     LAIRFF) WRITE(*,*) 'Airfoil will be plotted'
        IF(.NOT.LAIRFF) WRITE(*,*) 'Airfoil won''t be plotted'
      ELSE IF(ANS.EQ.'7') THEN
        LPWAKE = .NOT.LPWAKE
        WRITE(*,*)
        IF(     LPWAKE) WRITE(*,*) ' Wake Cp, M will be plotted'
        IF(.NOT.LPWAKE) WRITE(*,*) ' Wake Cp, M will not be plotted'
      ELSE IF(ANS.EQ.'8') THEN
        WRITE(*,1100) ' Current name: ' // NAME
        WRITE(*,*) 'Enter new name (32 characters max): '
        READ (*,1100) NAME
      ENDIF
      GO TO 122
C
C===============================================
C**** Change element to plot
C
  130 IF (NBL.LE.1) GO TO 990
      WRITE(*,*)
      WRITE(*,*) '  Currently plotting element :',NBPLT
      WRITE(*,*)
  132 WRITE(*,*) 'Enter new element number (0 for all):'
      READ(*,*,ERR=132) NUM
      IF(NUM.LT.0 .OR. NUM.GT.NBL) THEN
       WRITE(*,*) 'Element number out of range !'
       GO TO 132
      ELSE 
       NBPLT = NUM
      ENDIF
C
      GO TO 995
C
C===============================================
C**** Hardcopy
C
  140 IF(LPLOT) CALL PLEND
      LPLOT = .FALSE.
      CALL REPLOT(IDEVRP)
      GO TO 995
C
C==============================================
C**** change x-axis limits
C
 160  CONTINUE
      N = NPLOT
      IF(N.LT.1 .OR. N.GT.NBL .OR. KPLOT.EQ.0) THEN
       WRITE(*,*) 'No current BL plot'
       GO TO 995
      ENDIF
      WRITE(*,9101) N, XIMIN(N), XIMAX(N), XIDEL(N)
 9101 FORMAT(/' Element',I2,':  Currently, Xmin,Xmax,Xdel =', 3F10.4,
     &       /'        ',2X,'   Enter new  Xmin,Xmax,Xdel: ', $ )
      AINPUT(1) = XIMIN(N)
      AINPUT(2) = XIMAX(N)
      AINPUT(3) = XIDEL(N)
      CALL READR(3,AINPUT,ERROR)
      IF(ERROR) GO TO 160
      XIMIN(N) = AINPUT(1)
      XIMAX(N) = AINPUT(2)
      XIDEL(N) = AINPUT(3)
      NOPT = KPLOT
      GO TO 3
C
C===================================================
C**** change y-axis limits on current BL plot
C
 170  CONTINUE
      N = NPLOT
      IF(N.LT.1 .OR. N.GT.NBL .OR. KPLOT.EQ.0) THEN
       WRITE(*,*) 'No current plot'
       GO TO 990
      ENDIF

      IF     (KPLOT.EQ.1) THEN
       YIMIN(N) = MAMIN
       YIMAX(N) = MAMAX
       YIDEL(N) = MADEL
      ELSE IF(KPLOT.EQ.2) THEN
       YIMIN(N) = CPMIN
       YIMAX(N) = CPMAX
       YIDEL(N) = CPDEL
      ELSE IF(KPLOT.EQ.3) THEN
       YIMIN(N) = HKMIN(N)
       YIMAX(N) = HKMAX(N)
       YIDEL(N) = HKDEL(N)
      ELSE IF(KPLOT.EQ.4) THEN
       YIMIN(N) = DSMIN(N)
       YIMAX(N) = DSMAX(N)
       YIDEL(N) = DSDEL(N)
      ELSE IF(KPLOT.EQ.5) THEN
       YIMIN(N) = DPMIN(N)
       YIMAX(N) = DPMAX(N)
       YIDEL(N) = DPDEL(N)
      ELSE IF(KPLOT.EQ.6) THEN
       YIMIN(N) = CFMIN(N)
       YIMAX(N) = CFMAX(N)
       YIDEL(N) = CFDEL(N)
      ELSE IF(KPLOT.EQ.7) THEN
       YIMIN(N) = UEMIN(N)
       YIMAX(N) = UEMAX(N)
       YIDEL(N) = UEDEL(N)
      ELSE IF(KPLOT.EQ.8) THEN
       YIMIN(N) = ANMIN(N)
       YIMAX(N) = ANMAX(N)
       YIDEL(N) = ANDEL(N)
      ELSE IF(KPLOT.EQ.9) THEN
       YIMIN(N) = CTMIN(N)
       YIMAX(N) = CTMAX(N)
       YIDEL(N) = CTDEL(N)
      ELSE IF(KPLOT.EQ.10) THEN
       YIMIN(N) = RTMIN(N) 
       YIMAX(N) = RTMAX(N)
       YIDEL(N) = RTDEL(N)
      ENDIF
C
      WRITE(*,9201) N, YIMIN(N), YIMAX(N), YIDEL(N)
 9201 FORMAT(/' Element',I2,':  Currently, Ymin,Ymax,Ydel =', 3F10.4,
     &       /'        ',2X,'   Enter new  Ymin,Ymax,Ydel: ', $ )
      AINPUT(1) = YIMIN(N)
      AINPUT(2) = YIMAX(N)
      AINPUT(3) = YIDEL(N)
      CALL READR(3,AINPUT,ERROR)
      IF(ERROR) GO TO 160
      YIMIN(N) = AINPUT(1)
      YIMAX(N) = AINPUT(2)
      YIDEL(N) = AINPUT(3)
C
      IF     (KPLOT.EQ.1) THEN
       MAMIN = YIMIN(N)
       MAMAX = YIMAX(N)
       MADEL = YIDEL(N)
      ELSE IF(KPLOT.EQ.2) THEN
       CPMIN = YIMIN(N)
       CPMAX = YIMAX(N)
       CPDEL = YIDEL(N)
      ELSE IF(KPLOT.EQ.3) THEN
       HKMIN(N) = YIMIN(N)
       HKMAX(N) = YIMAX(N)
       HKDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.4) THEN
       DSMIN(N) = YIMIN(N)
       DSMAX(N) = YIMAX(N)
       DSDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.5) THEN
       DPMIN(N) = YIMIN(N)
       DPMAX(N) = YIMAX(N)
       DPDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.6) THEN
       CFMIN(N) = YIMIN(N)
       CFMAX(N) = YIMAX(N)
       CFDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.7) THEN
       UEMIN(N) = YIMIN(N)
       UEMAX(N) = YIMAX(N)
       UEDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.8) THEN
       ANMIN(N) = YIMIN(N)
       ANMAX(N) = YIMAX(N)
       ANDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.9) THEN
       CTMIN(N) = YIMIN(N)
       CTMAX(N) = YIMAX(N)
       CTDEL(N) = YIDEL(N)
      ELSE IF(KPLOT.EQ.10) THEN
       RTMIN(N) = YIMIN(N)
       RTMAX(N) = YIMAX(N)
       RTDEL(N) = YIDEL(N)
      ENDIF
C
      NOPT = KPLOT
      GO TO 3
C
C===============================================
C**** annotation menu
C
 200  CALL ANNOT(CH)
      GO TO 990
C
      END     


      SUBROUTINE SCLINI
      INCLUDE 'MXPLOT.INC'
C
C---- set x/c plot axis limits
C
C---- Mach plot axis limit and annotation increment
      MAMAX = 1.6
      MAMIN = 0.0
      MADEL = 0.2
C
C---- Cp plot axis limits and annotation increment
      CPMAX = 1.0
      CPMIN = -2.0*FLOAT(NBL)
      CPDEL = -0.5
      IF(CPMIN.LT.-6.0) CPDEL = -1.0
C
C
      DO 900 N=1, NBL
C
      ILE = ILEB(N)
      ITE = ITEB(N)
C
      IS1 = 2*N-1
      IS2 = 2*N
C------------------------------------------
C
      CALL SCALIT(1,XBTAIL(N),XBNOSE(N),XFAC,ANN,NANN)
      XIDEL(N) = 1.0/(5.0*XFAC)
      XIMIN(N) = (AINT(XBNOSE(N)/XIDEL(N) + 1000.0) - 1000.0)*XIDEL(N)
      XIMAX(N) = (AINT(XBTAIL(N)/XIDEL(N) + 1002.0) - 1000.0)*XIDEL(N)
C------------------------------------------
C
      DO 10 KA=1, NAPLT
        IA = IAPLT(KA)
        MACHSQ = MA(IA)**2
        DO 105 IS=IS1, IS2
          CALL HKSET(GAM,MACHSQ, 
     &             DSTR(ILE+1,IS,IA),THET(ILE+1,IS,IA),CP(ILE+1,IS,IA), 
     &                Y(ILE+1,IS,IA), II-1-ILE)
 105    CONTINUE
 10   CONTINUE
C
      CALL SCALY(IX,ISX,NAX, ILE+1,II-1, IS1,IS2, IAPLT,NAPLT,
     &           Y,0.0,YFAC)
      HKMAX(N) = MIN( 1.0/YFAC , 20.0 )
      HKMIN(N) = 0.
      HKDEL(N) = 1.0
      IF(HKMAX(N) .GT. 11.0) HKDEL(N) = 2.0
      IF(HKMAX(N) .GT. 21.0) HKDEL(N) = 4.0
C------------------------------------------
C
      CALL SCALY(IX,ISX,NAX, ILE+1,II-1, IS1,IS2, IAPLT,NAPLT,
     &           DSTR,0.0,YFAC1)
      CALL SCALY(IX,ISX,NAX, ILE+1,II-1, IS2,IS2, IAPLT,NAPLT,
     &           DSTR,0.0,YFAC2)
      DSMAX(N) = 1.0/YFAC1
      DSMIN(N) = 0.
      DSDEL(N) = DSMAX(N)/5.0
      DPMAX(N) = 1.0/YFAC2
      DPMIN(N) = 0.
      DPDEL(N) = DPMAX(N)/5.0
C------------------------------------------
C
      CALL SCALY(IX,ISX,NAX, ILE+10,ITE, IS1,IS2, IAPLT,NAPLT,
     &           CF,0.0,YFAC)
      CFMAX(N) = 1.0/YFAC
      CFMIN(N) = 0.
      CFDEL(N) = CFMAX(N)/5.0
C------------------------------------------
C
      DO 20 KA=1, NAPLT
        IA = IAPLT(KA)
        MACHSQ = MA(IA)**2
        DO 205 IS=IS1, IS2
          CALL UESET(GAM,MACHSQ, 
     &               CP(ILE+1,IS,IA), 
     &                Y(ILE+1,IS,IA), II-1-ILE)
 205    CONTINUE
 20   CONTINUE
C
      CALL SCALY(IX,ISX,NAX, ILE+1,II-1, IS1,IS2, IAPLT,NAPLT,
     &           Y,0.0,YFAC)
      UEMAX(N) = 1.0/YFAC
      UEMIN(N) = 0.
      UEDEL(N) = 0.5
C------------------------------------------
C
      ACR1 = MAX(1.0,ACRIT)
      CALL SCALIT(1,ACR1,0.0,YFAC,ANN,NANN)
      ANDEL(N) = 1.0/(5.0*YFAC)
      ANMAX(N) = ANDEL(N)*AINT(ACR1/ANDEL(N) + 0.6)
      ANMIN(N) = 0.
C------------------------------------------
C
      YFAC = 1.0E12
      DO KA=1, NAPLT
        IA = IAPLT(KA)
        IT1 = ITRAN(IS1,IA)
        IT2 = ITRAN(IS2,IA)
        CALL SCALIT(II-IT1,CTAU(IT1,IS1,IA),0.0,YFAC1,ANN,NANN)
        CALL SCALIT(II-IT2,CTAU(IT2,IS2,IA),0.0,YFAC2,ANN,NANN)
        YFAC = MIN(YFAC, YFAC1,YFAC2)
      ENDDO
C
      CTMAX(N) = 1.0/YFAC
      CTMIN(N) = 0.
      CTDEL(N) = CTMAX(N)/5.0
C------------------------------------------
C
      RTMAX(N) = 5.0
      RTMIN(N) = 1.0
      RTDEL(N) = 1.0
C------------------------------------------
C
 900  CONTINUE
C
      RETURN
      END ! SCLINI



      SUBROUTINE SCALY(IX,ISX,NAX, I1,I2, IS1,IS2, IARR,NA, Y,YOFF,YFAC)
      DIMENSION Y(IX,ISX,NAX)
      DIMENSION IARR(NA)
C
C---- finds minimum scaling factor over active part of Y array
C
      YFAC = 1.0E12
      DO KA=1, NA
        IA = IARR(KA)
        DO IS=IS1, IS2
          CALL SCALIT(I2-I1+1,Y(I1,IS,IA),YOFF,YFAC1,ANN,NANN)
          YFAC = MIN(YFAC,YFAC1)
        ENDDO
      ENDDO
C
      RETURN
      END


      SUBROUTINE MASET(GAM,AMSQIN, CP, MA, N)
      REAL MA
      DIMENSION CP(N), MA(N)
C
C---- set Mach
C
      GM1 = GAM - 1.0
C
      DO 10 I=1, N
        PRATEX = (CP(I)*0.5*GAM*AMSQIN + 1.0)**(GM1/GAM)
     &         / (1.0 + 0.5*GM1*AMSQIN)
        AMSQ = MAX( 1.0/PRATEX - 1.0 , 0.0 ) * 2.0/GM1
        MA(I) = SQRT( AMSQ )
 10   CONTINUE
      RETURN
      END


      SUBROUTINE HKSET(GAM,AMSQIN, DS,TH,CP, HK, N)
      DIMENSION DS(N), TH(N), CP(N), HK(N)
C
C---- set Hk
C
      GM1 = GAM - 1.0
C
      DO 10 I=1, N
        IF(TH(I).EQ.0.0) THEN
         HK(I) = 1.0
        ELSE
         H = DS(I)/TH(I)
         PRATEX = (CP(I)*0.5*GAM*AMSQIN + 1.0)**(GM1/GAM)
     &          / (1.0 + 0.5*GM1*AMSQIN)
         AMSQ = MAX( 1.0/PRATEX - 1.0 , 0.0 ) * 2.0/GM1
         HK(I) = (H - 0.725*GM1*AMSQ) / (1.0 + 0.2825*GM1*AMSQ)
        ENDIF
 10   CONTINUE
C
      RETURN
      END


      SUBROUTINE UESET(GAM,AMSQIN, CP, UE, N)
      DIMENSION CP(N), UE(N)
C
C---- set Ue/Uinf
C
      GM1 = GAM - 1.0
C
      DO 10 I=1, N
        PRATEX = (CP(I)*0.5*GAM*AMSQIN + 1.0)**(GM1/GAM)
     &         / (1.0 + 0.5*GM1*AMSQIN)
        AMSQ = MAX( 1.0/PRATEX - 1.0 , 0.0 ) * 2.0/GM1
        UE(I) = SQRT( AMSQ   / (1.0 + 0.5*GM1*AMSQ  ) )
     &        / SQRT( AMSQIN / (1.0 + 0.5*GM1*AMSQIN) )
 10   CONTINUE
C
      RETURN
      END



      SUBROUTINE RTSET(GAM,AMSQIN, REIN, TH,CP, RL, N)
      DIMENSION TH(N), CP(N), RL(N)
C
C---- set log10(Rtheta)
C
      GM1 = GAM - 1.0
C
C---- Sutherland's const./To   (assumes stagnation conditions are at STP)
      HVRAT = 0.35
C
      TTIN = 1.0 + 0.5*GM1*AMSQIN
C
      DO 10 I=1, N
        PRATEX = (CP(I)*0.5*GAM*AMSQIN + 1.0)**(GM1/GAM)
     &         / (1.0 + 0.5*GM1*AMSQIN)
        AMSQ = MAX( 1.0/PRATEX - 1.0 , 0.0 ) * 2.0/GM1
        TT = 1.0 + 0.5*GM1*AMSQ
C
        UE = SQRT( AMSQ/AMSQIN * TTIN/TT )
        RH = (TTIN/TT) ** (1.0/GM1)
C
        RT = RH*UE*TH(I) * REIN
     &     * SQRT((TT/TTIN)**3) * (1.0+HVRAT)/(TT/TTIN+HVRAT)
C
        RT = MAX( RT , 0.000001 )
        RL(I) = LOG10(RT)
C
 10   CONTINUE
C
      RETURN
      END



      SUBROUTINE READIT
      INCLUDE 'MXPLOT.INC'
      CHARACTER*80 FNAME
C
      CALL GETARG(1,FNAME)
C
CCC      WRITE(*,*) 'Enter dump filename'
CCC      READ (*,1000) FNAME
CCC 1000 FORMAT(A)
C
      OPEN(11,FILE=FNAME,STATUS='OLD',FORM='UNFORMATTED')
      READ(11) NAME, CODE, VERSION
      READ(11) MACH, REYN, ACRIT
      READ(11) MATYP, RETYP
      READ(11) NBL, II
C
cc      matyp = 2
cc      retyp = 2
C
      IF(NBL.GT.NBX) STOP 'READIT:  Array overflow. Increase NBX.'
      IF(II .GT.IX ) STOP 'READIT:  Array overflow. Increase IX.'
C
      READ(11) (ILEB(N), ITEB(N), IIB(N), N=1, NBL)
      DO 1 N=1, NBL
        READ(11) (XB(IB,N), YB(IB,N), IB=1, IIB(N))
    1 CONTINUE
C
C---- T if this is a Mach sweep, F if alpha sweep
      LMACH = MACH .EQ. 0.0
C
      DO 3 IA=1, NAX
C
        IF(LMACH) THEN
         READ(11,END=4) 
     &    ALFA(IA),CL(IA),CD(IA),CDW(IA),CM(IA),
     &    (XTR(IS,IA), IS=1, 2*NBL),
     &    MA(IA)
        ELSE
         READ(11,END=4)
     &    ALFA(IA),CL(IA),CD(IA),CDW(IA),CM(IA),
     &    (XTR(IS,IA), IS=1, 2*NBL)
         IF(MATYP.EQ.1) MA(IA) = MACH
         IF(MATYP.EQ.2) MA(IA) = MACH/SQRT(CL(IA))
         IF(MATYP.EQ.3) MA(IA) = MACH/CL(IA)
        ENDIF
C
        DO 301 IS=1, 2*NBL
          READ(11,END=4) (X(I,IS,IA),CP(I,IS,IA),
     &                    THET(I,IS,IA),DSTR(I,IS,IA),
     &                    CF(I,IS,IA), CTAU(I,IS,IA), I=1, II)
  301   CONTINUE
    3 CONTINUE
      IA = NAX+1
      WRITE(*,*) 'READIT: Array limit reached.  Not all points read.'
C
    4 NA = IA - 1
      CLOSE(11)
C
      DO 5 IA=1, NA
        DO 50 IS=1, 2*NBL
          N = (IS+1)/2
          DO 500 I=ILEB(N), II-1
            IF(X(I-1,IS,IA).LT.XTR(IS,IA) .AND.
     &         X(I  ,IS,IA).GE.XTR(IS,IA)      ) THEN
             ITRAN(IS,IA) = I
             GO TO 50
            ENDIF
  500     CONTINUE
   50  CONTINUE
    5 CONTINUE
C
      GAM = 1.4
      GM1 = GAM - 1.0
C
      DO 6 IA=1, NA
        RE(IA) = REYN * 1.0E6
        IF(RETYP.EQ.2 .AND. CL(IA).GT.0.0) THEN
          RE(IA) = REYN/SQRT(CL(IA)) * 1.0E6
        ENDIF
C
        CPSTAR(IA) = -999.0
        IF(MA(IA) .EQ. 0.0) GO TO 6
        MACHSQ = MA(IA)**2
        CPSTAR(IA) = ( ( (1.0+0.5*GM1*MACHSQ)
     &                  /(1.0+0.5*GM1       ) )**(GAM/GM1) - 1.0 )
     &             / (0.5*GAM*MACHSQ)
    6 CONTINUE
C
      CLOSE(11)
C
C---- set flags indicating if CL or alpha have been held fixed (in Mach sweep)
      LCLFIX = .TRUE.
      LALFIX = .TRUE.
      DO 7 IA=1, NA-1
        ADCL = ABS(   CL(IA) -   CL(IA+1) )
        ADAL = ABS( ALFA(IA) - ALFA(IA+1) )
        IF(ADCL .GT. 0.001) LCLFIX = .FALSE.
        IF(ADAL .GT. 0.001) LALFIX = .FALSE.
    7 CONTINUE
C
C---- find nose x value
      DO 8 N=1, NBL
        XBNOSE(N) = XB(1,N)
        YBTOP(N)  = YB(1,N)
        YBBOT(N)  = YB(1,N)
        DO 81 IB=2, IIB(N)
          XBNOSE(N) = MIN(XB(IB,N),XBNOSE(N))
          YBTOP(N)  = MAX(YB(IB,N), YBTOP(N))
          YBBOT(N)  = MIN(YB(IB,N), YBBOT(N))
   81   CONTINUE
        XBTAIL(N) = 0.5*(XB(1,N)+XB(IIB(N),N))
    8 CONTINUE
C
      XBMIN = XB(1,1)
      XBMAX = XB(1,1)
      YBMIN = YB(1,1)
      YBMAX = YB(1,1)
      DO 9 N=1, NBL
        DO 91 IB=1, IIB(N)
          XBMIN = MIN(XBMIN,XB(IB,N))
          XBMAX = MAX(XBMAX,XB(IB,N))
          YBMIN = MIN(YBMIN,YB(IB,N))
          YBMAX = MAX(YBMAX,YB(IB,N))
  91    CONTINUE
   9  CONTINUE
C
c      DO 10 N=1, NBL
c        CALL SCALC(XB(1,N),YB(1,N),SB(1,N),IIB(N))
c        CALL SEGSPL(XB(1,N),XPB(1,N),SB(1,N),IIB(N))
c        CALL SEGSPL(YB(1,N),YPB(1,N),SB(1,N),IIB(N))
c   10 CONTINUE
C
      RETURN
      END ! READIT



 
      SUBROUTINE XTICK(XLE,XTE,XLEN,Y)
      CALL NEWPEN(1)
C
      XSF = XTE-XLE
C
      CALL PLOT(0.0 ,Y,3)
      CALL PLOT(XLEN,Y,2)
C
      DO 10 NT=1, 9
        XT = FLOAT(NT)/10.
        CALL PLOT(XLE+XT*XSF,Y+0.003,3) 
        CALL PLOT(XLE+XT*XSF,Y-0.003,2) 
   10 CONTINUE
      DO 20 NT=0, 2
        XT = FLOAT(NT)/2.
        CALL PLOT(XLE+XT*XSF,Y+0.006,3) 
        CALL PLOT(XLE+XT*XSF,Y-0.006,2) 
   20 CONTINUE
      RETURN
      END ! XTICK


 
      SUBROUTINE PLTFOR(X1,Y1)
      INCLUDE 'MXPLOT.INC'
C
c      CH2 = 0.012
c      CH3 = 0.010
c      CHN = 0.015
C
      CH2 = 1.00*CH
      CH3 = 0.85*CH
      CHN = 1.20*CH
C
      CALL GETCOLOR(ICOL0)
C
C---- find index of last non-blank character in NAME
      DO 10 LNB=32, 1, -1
        IF(NAME(LNB:LNB).NE.' ') GO TO 11
   10 CONTINUE
      LNB = 1
   11 CONTINUE
CCC      LNB = LNB-1
C
      XLAB = X1
      YLAB = Y1
C
      IF(LNB.GT.0) THEN
       CALL NEWPEN(4)
       CALL PLCHAR(X1,YLAB,CHN,NAME,0.0,LNB)
       YLAB = YLAB - 0.3*CH2
      ENDIF
C
      IF(LMACH) THEN
       IF(LALFIX) THEN
        XLAB = X1
        YLAB = YLAB - 2.0*CH2
        CALL NEWPEN(3)
        CALL PLCHAR(XLAB,YLAB,CH2,'Alfa  = ',0.0, 8)
        CALL NEWPEN(2)
        CALL PLNUMB(XLAB+ 8.0*CH2,YLAB,CH2,ALFA(1),0.0,4)
       ELSE
        XLAB = X1
        YLAB = YLAB - 2.0*CH2
        CALL NEWPEN(3)
        CALL PLCHAR(XLAB,YLAB,CH2,'CL    = ',0.0, 8)
        CALL NEWPEN(2)
        CALL PLNUMB(XLAB+ 8.0*CH2,YLAB,CH2,CL(1),0.0,4)
       ENDIF
      ELSE
       XLAB = X1
       YLAB = YLAB - 2.0*CH2
       CALL NEWPEN(3)
       ITYP = MATYP
       IF(ITYP.EQ.1) CALL PLCHAR(XLAB,YLAB,CH2,'Ma    = ',0.0, 8)
       IF(ITYP.EQ.2) CALL PLCHAR(XLAB,YLAB,CH2,'Ma CL = ',0.0, 8)
       IF(ITYP.EQ.2) CALL PLMATH(XLAB,YLAB,CH2,'  R     ',0.0, 8)
       IF(ITYP.EQ.3) CALL PLCHAR(XLAB,YLAB,CH2,'Ma CL = ',0.0, 8)
       IF(ITYP.EQ.3) CALL PLMATH(XLAB,YLAB,CH2,'  #     ',0.0, 8)
       CALL NEWPEN(2)
       CALL PLNUMB(XLAB+ 8.0*CH2,YLAB        ,     CH2, MACH,0.0,4)
      ENDIF
C
      IF(REYN.NE.0.0) THEN
       YLAB = YLAB - 2.0*CH2
       CALL NEWPEN(3)
       ITYP = RETYP
       IF(ITYP.EQ.1) CALL PLCHAR(XLAB,YLAB,CH2,'Re    = ',0.0, 8)
       IF(ITYP.EQ.2) CALL PLCHAR(XLAB,YLAB,CH2,'Re CL = ',0.0, 8)
       IF(ITYP.EQ.2) CALL PLMATH(XLAB,YLAB,CH2,'  R     ',0.0, 8)
       IF(ITYP.EQ.3) CALL PLCHAR(XLAB,YLAB,CH2,'Re CL = ',0.0, 8)
       IF(ITYP.EQ.3) CALL PLMATH(XLAB,YLAB,CH2,'  #     ',0.0, 8)
       CALL NEWPEN(2)
       DCH = 0.0
       IF(REYN.GE. 10.0) DCH = 1.0*CH2
       IF(REYN.GE.100.0) DCH = 2.0*CH2
       CALL PLNUMB(XLAB+ 8.0*CH2    ,YLAB        ,     CH2, REYN,0.0,4)
       CALL PLMATH(999.,YLAB+0.20*CH2,0.80*CH2,'#'  ,0.0,1)
       CALL PLCHAR(999.,YLAB         ,     CH2,'10' ,0.0,2)
       CALL PLMATH(999.,YLAB         ,1.20*CH2,  '6',0.0,1)
C
ccc       YLAB = YLAB - 2.0*CH2
ccc       CALL NEWPEN(3)
ccc       CALL PLCHAR(XLAB        ,YLAB,     CH2,'N'   ,0.0,1)
ccc       CALL PLCHAR(XLAB+1.0*CH2,YLAB,0.75*CH2,'crit',0.0,4)
ccc       CALL PLCHAR(XLAB+4.0*CH2,YLAB,     CH2,'  = ',0.0,4)
ccc       CALL NEWPEN(2)
ccc       CALL PLNUMB(XLAB+8.0*CH2,YLAB,     CH2, ACRIT,0.0,3)
      ENDIF
C
      XL1 = XLAB 
      XL2 = XL1 + 7.0*CH3
      XL3 = XL2 + 8.0*CH3
      XL4 = XL3 + 9.0*CH3
      XL5 = XL4 + 8.0*CH3
      XL6 = XL5 + 7.0*CH3
      YLAB = YLAB - 2.5*CH3
      CALL NEWPEN(3)
      IF(LMACH) THEN
       CALL PLCHAR(XL1+0.5*CH3,YLAB,CH3,'Mach' ,0.0,4)
       IF(LCLFIX) THEN
        CALL PLCHAR(XL2+0.5*CH3,YLAB,CH3,'Alfa',0.0,4)
       ELSE
        CALL PLCHAR(XL2+0.5*CH3,YLAB,CH3,' CL ',0.0,4)
       ENDIF
      ELSE
       CALL PLCHAR(XL1+0.5*CH3,YLAB,CH3,'Alfa' ,0.0,4)
       CALL PLCHAR(XL2+0.5*CH3,YLAB,CH3,' CL ' ,0.0,4)
      ENDIF
      CALL PLCHAR(XL3+2.5*CH3,YLAB,CH3,'CD'   ,0.0,2)
      CALL PLCHAR(XL4+2.0*CH3,YLAB,CH3,'CM'   ,0.0,2)
cc      IF(REYN.NE.0.0) THEN
cc       CALL PLCHAR(XL5+1.5*CH3,YLAB,    CH3,'S' ,0.0,1)
cc       CALL PLCHAR(XL5+2.5*CH3,YLAB,0.6*CH3,'tr',0.0,2)
cc       CALL PLCHAR(XL6+1.5*CH3,YLAB,    CH3,'P' ,0.0,1)
cc       CALL PLCHAR(XL6+2.5*CH3,YLAB,0.6*CH3,'tr',0.0,2)
cc      ENDIF
C
      CALL NEWPEN(1)
      CALL PLOT(XL1        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL1+5.0*CH3,YLAB-0.4*CH3,2)
      CALL PLOT(XL2        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL2+6.0*CH3,YLAB-0.4*CH3,2)
      CALL PLOT(XL3        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL3+7.0*CH3,YLAB-0.4*CH3,2)
      CALL PLOT(XL4        ,YLAB-0.4*CH3,3)
      CALL PLOT(XL4+6.0*CH3,YLAB-0.4*CH3,2)
cc      IF(REYN.NE.0.0) THEN
cc       CALL PLOT(XL5        ,YLAB-0.4*CH3,3)
cc       CALL PLOT(XL5+5.0*CH3,YLAB-0.4*CH3,2)
cc       CALL PLOT(XL6        ,YLAB-0.4*CH3,3)
cc       CALL PLOT(XL6+5.0*CH3,YLAB-0.4*CH3,2)
cc      ENDIF
C
      CALL NEWPEN(2)
      YLAB = YLAB - 0.4*CH3
      DO 50 KA=1, NAPLT
        IA = IAPLT(KA)
        CALL NEWCOLOR(IACOL(KA))
        DXL1 = 0.
        DXL2 = 0.
        DXL3 = 0.
        DXL4 = 0.
        IF(LMACH) THEN
         IF(LCLFIX) THEN
          IF(ALFA(IA).LT.0.0) DXL2 = -CH3
         ELSE
          IF(  CL(IA).LT.0.0) DXL2 = -CH3
         ENDIF
        ELSE
         IF(ALFA(IA).LT.0.0) DXL1 = -CH3
         IF(  CL(IA).LT.0.0) DXL2 = -CH3
        ENDIF

        IF(  CD(IA).LT.0.0) DXL3 = -CH3
        IF(  CM(IA).LT.0.0) DXL4 = -CH3
        YLAB = YLAB - 1.9*CH3
        IF(LMACH) THEN
         CALL PLNUMB(XL1+DXL1,YLAB,CH3,  MA(IA),0.0,3)
         IF(LCLFIX) THEN
          CALL PLNUMB(XL2+DXL2,YLAB,CH3,ALFA(IA),0.0,3)
         ELSE
          CALL PLNUMB(XL2+DXL2,YLAB,CH3,  CL(IA),0.0,4)
         ENDIF
        ELSE
         CALL PLNUMB(XL1+DXL1,YLAB,CH3,ALFA(IA),0.0,3)
         CALL PLNUMB(XL2+DXL2,YLAB,CH3,  CL(IA),0.0,4)
        ENDIF
        CALL PLNUMB(XL3+DXL3,YLAB,CH3,  CD(IA),0.0,5)
        CALL PLNUMB(XL4+DXL3,YLAB,CH3,  CM(IA),0.0,3)
cc        IF(REYN.NE.0.0) THEN
cc         CALL PLNUMB(XL5,YLAB,CH3,XTR(1,IA),0.0,3)
cc         CALL PLNUMB(XL6,YLAB,CH3,XTR(2,IA),0.0,3)
cc        ENDIF
   50 CONTINUE
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END ! PLTFOR
 
 
 
      SUBROUTINE GETREF(X,Y,N)
      REAL X(N), Y(N)
      CHARACTER*80 FNAME
C
      WRITE(*,*) 'Enter reference solution filename:'
      READ (*,1000) FNAME
 1000 FORMAT(A)
C
      OPEN(UNIT=1,FILE=FNAME,STATUS='OLD',ERR=5)
      GO TO 10
C
    5 WRITE(*,*) '***   File open error   ***'
      CLOSE(UNIT=1)
      RETURN
C
   10 DO 11 I=1, 500
        READ(1,*,END=12) X(I), Y(I)
   11 CONTINUE
   12 N = I-1
C
      CLOSE(UNIT=1)
      RETURN
      END ! GETREF




      SUBROUTINE RFPLOT(N,X,Y,XOFF,XWT,YOFF,YWT,CH,ID)
      REAL X(N), Y(N)
C
      ISYM = ID
      DO 10 I=1, N
        XPLT = XWT*(X(I)-XOFF)
        YPLT = YWT*(Y(I)-YOFF)
        IF(X(I).EQ.999.0) THEN
         ISYM = ISYM + 1
        ELSE
         CALL PLSYMB(XPLT,YPLT,CH,ISYM,0.0,0)
        ENDIF
   10 CONTINUE
C
      RETURN
      END ! RFPLOT




      SUBROUTINE IDENT(XID,YID)
      INCLUDE 'MXPLOT.INC'
C
C---- plot code and version identifier
      CALL NEWPEN(1)
      CHI = 0.75*CH
      CALL PLCHAR(XID+    CHI,YID-1.0*CHI,CHI,CODE   ,0.0,5)
      CALL PLCHAR(XID+    CHI,YID-3.0*CHI,CHI,'V'    ,0.0,1)
      CALL PLNUMB(XID+3.0*CHI,YID-3.0*CHI,CHI,VERSION,0.0,1)
C
      RETURN
      END ! IDENT
