
      SUBROUTINE OFFGET(XOFF,YOFF,XSF,YSF,XWIND,YWIND,LSAME,LCURS)
C----------------------------------------------------------------------
C     Obtains new offset/scaling factors from user.
C
C    XOFF,XSF    x offset,scaling parameters      (input,output)
C    YOFF,YSF    y offset,scaling parameters      (input,output)
C    XLEN,YLEN   dimensions of window which is 
C                   to contain newly-scaled plot  (input)
C    LSAME       if .TRUE., will return the same XSF,YSF (no distortion)
C    LCURS       if .TRUE., will obtain coordinates via cursor click,
C                  otherwise will ask for keyboard inputs
C
C
C     The plotted location of any point x,y is:
C        Xplt = (x - XOFF)*XSF
C        Yplt = (y - YOFF)*YSF
C
C     The two user-specified x,y pairs are used to determine new 
C     XOFF,XSF, YOFF,YSF parameters so that Xplt,Yplt for these two 
C     x,y points will fall on the corners of the rectangular window
C     0...XLEN, 0...YLEN
C
C     If LSAME = .TRUE., then either XSF or YSF is modified so that
C     one of these points will fall on a side rather than a corner.
C----------------------------------------------------------------------
      LOGICAL LSAME, LCURS
      CHARACTER*1 KCHAR
C
C---- crosshair "+" symbol size
      DATA SH / 2.0 /
C
C---- get current color
      CALL GETCOLOR(ICOL0)
C
C---- set new crosshair color
      CALL NEWCOLORNAME('red')
C
C
      IF(LCURS) THEN
C
       WRITE(*,*)
       WRITE(*,*) 'Mark off corners of blowup area'
       WRITE(*,*) '(2 identical points default to current area)'
C
       CALL GETCURSORXY(XX1,YY1,KCHAR)
       CALL PLSYMB(XX1,YY1,SH,3,0.0,0)
       WRITE(*,*) 'x,y =', XX1/XSF+XOFF, YY1/YSF+YOFF
C
       CALL GETCURSORXY(XX2,YY2,KCHAR)
       CALL PLSYMB(XX2,YY2,SH,3,0.0,0)
       WRITE(*,*) 'x,y =', XX2/XSF+XOFF, YY2/YSF+YOFF
C
      ELSE
C
       WRITE(*,*)
       WRITE(*,*) 'Enter x,y coordinates of blowup area corners'
       WRITE(*,*) '(2 identical points default to current area)'
       WRITE(*,*)
    1  WRITE(*,*) 'Point 1: '
       READ(*,*,ERR=1) XX1, YY1
    2  WRITE(*,*) 'Point 2: '
       READ(*,*,ERR=2) XX2, YY2
C
       XX1 = XSF*(XX1 - XOFF)
       YY1 = YSF*(YY1 - YOFF)
       XX2 = XSF*(XX2 - XOFF)
       YY2 = YSF*(YY2 - YOFF)
C
      ENDIF
C
      CALL PLFLUSH
C
C---- restore to initial color
      CALL NEWCOLOR(icol0)
C
      IF(XX1.EQ.XX2 .AND. YY1.EQ.YY2) RETURN
C
C
      XCEN = 0.5*(XX1+XX2)/XSF + XOFF
      YCEN = 0.5*(YY1+YY2)/YSF + YOFF
      XDIF = ABS(XX2 - XX1)/XSF
      YDIF = ABS(YY2 - YY1)/YSF
C
      IF(XDIF.EQ.0.0) XDIF = 1.0E-5
      IF(YDIF.EQ.0.0) YDIF = 1.0E-5
C
      XOFF = MIN(XX1,XX2)/XSF + XOFF
      YOFF = MIN(YY1,YY2)/YSF + YOFF
      XSF = XWIND/XDIF
      YSF = YWIND/YDIF
C
      IF(LSAME) THEN
C------ set equal x,y scales
        SF = MIN( XSF , YSF )
        XSF = SF
        YSF = SF
C
C------ re-center the blowup
        XOFF = XCEN - 0.5*XDIF
        YOFF = YCEN - 0.5*YDIF
      ENDIF
C
      RETURN
      END ! OFFGET
