
      SUBROUTINE PHIXY(XXX, YYY, GAM,
     &                 CIRC, ALFA, MINF, SRCE, DOUX, DOUY,
     &   PHIX, PX_X, PX_Y, PX_CIRC, PX_ALFA, PX_DOUX, PX_DOUY, PX_MSQ,
     &   PHIY, PY_X, PY_Y, PY_CIRC, PY_ALFA, PY_DOUX, PY_DOUY, PY_MSQ  )
C----------------------------------------------------------------
C     Calculates Vortex + Source + Doublet compressible farfield 
C     perturbation potential gradient components and their derivatives.
C
C     XXX,YYY  x,y location wrt singularities
C     GAM      cp/cv
C     CIRC     circulation                        Gamma/Vinf
C     ALFA     angle of freestream velocity
C     MINF     freestream Mach number
C     SRCE     source strength                    Sigma/Vinf
C     DOUX     x-doublet strength (along Vinf)       Dx/Vinf
C     DOUY     y-doublet strength (normal to Vinf)   Dy/Vinf
C
C     PHIX     dPhi/dx = u/Vinf    (perturbation velocities)
C     PHIY     dPhi/dy = v/Vinf
C
C     Total velocity is  ( cos(ALFA)+PHIX , sin(ALFA)+PHIY )
C
C-------------------------------------------------------
      IMPLICIT REAL (A-H,M,O-Z)
C
C---- 1/(2 pi),  1/(2 pi)^2
      DATA HPI, HPISQ / 0.1591549430918953, 0.025330295910584444 /
C
      GM1 = GAM - 1.0
      GP1 = GAM + 1.0
C
      MSQ = MINF**2
C
      BINV = 1.0 / SQRT(1.0 - MSQ)
      BI_MSQ = 0.5*BINV**3
C
      SINA = SIN(ALFA)
      COSA = COS(ALFA)
C                                      _ _          _
C---- set Prandtl-Glauert coordinates (x,y),  with  x  along freestream 
      XB     = ( XXX*COSA + YYY*SINA ) * BINV
      XB_X   =       COSA              * BINV
      XB_Y   =                  SINA   * BINV
C
      YB     = (-XXX*SINA + YYY*COSA )
      YB_X   =  -    SINA
      YB_Y   =                  COSA
C
      XB_MSQ = ( XXX*COSA + YYY*SINA ) * BI_MSQ
      XB_A   = (-XXX*SINA + YYY*COSA ) * BINV
      YB_A   = (-XXX*COSA - YYY*SINA )
C
C
      ACON   = HPISQ*MSQ*(    GP1*BINV**3 - GM1*BINV)
      AC_MSQ = HPISQ    *(    GP1*BINV**3 - GM1*BINV)
     &       + HPISQ*MSQ*(3.0*GP1*BINV**2 - GM1     ) * BI_MSQ
C
      BCON   = HPISQ*MSQ*BINV   * 2.0
      BC_MSQ = HPISQ    *BINV   * 2.0
     &       + HPISQ*MSQ*BI_MSQ * 2.0
C
      EE     = 0.2500*(BCON   + ACON  )
      EE_MSQ = 0.2500*(BC_MSQ + AC_MSQ)
      FF     = 0.0625*(BCON   - ACON  )
      FF_MSQ = 0.0625*(BC_MSQ - AC_MSQ)

c###
c      ee = 0.0
c      ee_msq = 0.0
c      ff = 0.0
c      ff_msq = 0.0

C
C---------------------------------------------------
C    The following trig quantities are in terms of 
C    the polar coordinates
C
C              _2  _2                       _ _
C     r = sqrt(x + y )       theta = arctan(y/x)
C
C     in the transformed Prandtl-Glauert space.
C
C
      RBSQ = XB**2 + YB**2
C
C---- cos(r) / r
      CTR    =  XB/RBSQ
      CTR_XB = (1.0 - 2.0*XB*CTR)/RBSQ
      CTR_YB = (    - 2.0*YB*CTR)/RBSQ
C
C---- sin(r) / r
      STR    =  YB/RBSQ
      STR_XB = (    - 2.0*XB*STR)/RBSQ
      STR_YB = (1.0 - 2.0*YB*STR)/RBSQ
C
C---- cos(2 theta)
      COS2T  =        (XB**2 - YB**2)/RBSQ
      C2T_XB = 2.0*XB*( 1.0  - COS2T)/RBSQ
      C2T_YB = 2.0*YB*(-1.0  - COS2T)/RBSQ
C
C---- sin(2 theta)
      SIN2T  = 2.0* XB*YB         /RBSQ
      S2T_XB = 2.0*(YB - XB*SIN2T)/RBSQ
      S2T_YB = 2.0*(XB - YB*SIN2T)/RBSQ
C
C---- cos(3 theta) / r
      C3TR    = CTR*COS2T  - STR*SIN2T
      C3TR_XB = CTR*C2T_XB - STR*S2T_XB  +  CTR_XB*COS2T - STR_XB*SIN2T
      C3TR_YB = CTR*C2T_YB - STR*S2T_YB  +  CTR_YB*COS2T - STR_YB*SIN2T
C
C---- sin(3 theta) / r
      S3TR    = STR*COS2T  + CTR*SIN2T
      S3TR_XB = STR*C2T_XB + CTR*S2T_XB  +  STR_XB*COS2T + CTR_XB*SIN2T
      S3TR_YB = STR*C2T_YB + CTR*S2T_YB  +  STR_YB*COS2T + CTR_YB*SIN2T
C
C---- log(r)
      RBLN    = 0.5*LOG(RBSQ)
      RBLN_XB = CTR
      RBLN_YB = STR
C
C-------------------------------------------------
C     Now set potential flow quantities
C
C---- r dphi/dr  for unit CIRC^2
      PGR     = -EE    *(RBLN - 1.0)*CTR    - FF    *C3TR
      PGR_XB  = -EE    *(RBLN - 1.0)*CTR_XB - FF    *C3TR_XB
     &          -EE    *(RBLN_XB   )*CTR
      PGR_YB  = -EE    *(RBLN - 1.0)*CTR_YB - FF    *C3TR_YB
     &          -EE    *(RBLN_YB   )*CTR
      PGR_MSQ = -EE_MSQ*(RBLN - 1.0)*CTR    - FF_MSQ*C3TR
C
C---- dphi/dtheta  for unit CIRC^2
      PGT     = -EE    *(RBLN      )*STR    - FF    *S3TR    * 3.0
      PGT_XB  = -EE    *(RBLN      )*STR_XB - FF    *S3TR_XB * 3.0
     &          -EE    *(RBLN_XB   )*STR
      PGT_YB  = -EE    *(RBLN      )*STR_YB - FF    *S3TR_YB * 3.0
     &          -EE    *(RBLN_YB   )*STR
      PGT_MSQ = -EE_MSQ*(RBLN      )*STR    - FF_MSQ*S3TR    * 3.0
C
C---- r dphi/dr
      PR     = ( SRCE - DOUX*CTR    - DOUY*STR   )*HPI + CIRC**2*PGR
      PR_XB  = (      - DOUX*CTR_XB - DOUY*STR_XB)*HPI + CIRC**2*PGR_XB
      PR_YB  = (      - DOUX*CTR_YB - DOUY*STR_YB)*HPI + CIRC**2*PGR_YB
      PR_MSQ =                                           CIRC**2*PGR_MSQ
C
C---- dphi/dtheta
      PT     = (-CIRC - DOUX*STR    + DOUY*CTR   )*HPI + CIRC**2*PGT
      PT_XB  = (      - DOUX*STR_XB + DOUY*CTR_XB)*HPI + CIRC**2*PGT_XB
      PT_YB  = (      - DOUX*STR_YB + DOUY*CTR_YB)*HPI + CIRC**2*PGT_YB
      PT_MSQ =                                           CIRC**2*PGT_MSQ
C           _
C---- dphi/dx
      PXB      = CTR   *PR     - STR   *PT    
      PXB_XB   = CTR   *PR_XB  - STR   *PT_XB 
     &         + CTR_XB*PR     - STR_XB*PT    
      PXB_YB   = CTR   *PR_YB  - STR   *PT_YB 
     &         + CTR_YB*PR     - STR_YB*PT    
      PXB_MSQ  = CTR   *PR_MSQ - STR   *PT_MSQ
C
      PXB_CIRC =             STR     *HPI
     &         + ( CTR*PGR - STR*PGT)*2.0*CIRC
      PXB_DOUX = (-CTR*CTR + STR*STR)*HPI
      PXB_DOUY = (-CTR*STR - STR*CTR)*HPI
      PXB_SRCE =   CTR               *HPI
C           _
C---- dphi/dy
      PYB      = STR   *PR     + CTR   *PT    
      PYB_XB   = STR   *PR_XB  + CTR   *PT_XB 
     &         + STR_XB*PR     + CTR_XB*PT    
      PYB_YB   = STR   *PR_YB  + CTR   *PT_YB 
     &         + STR_YB*PR     + CTR_YB*PT    
      PYB_MSQ  = STR   *PR_MSQ + CTR   *PT_MSQ
C
      PYB_CIRC =           - CTR     *HPI
     &         + ( STR*PGR + CTR*PGT)*2.0*CIRC
      PYB_DOUX = (-STR*CTR - CTR*STR)*HPI
      PYB_DOUY = (-STR*STR + CTR*CTR)*HPI
      PYB_SRCE =   STR               *HPI
C
C---- dPhi/dx
      PHIX    = BINV  *COSA*PXB      - SINA*PYB
      PX_XB   = BINV  *COSA*PXB_XB   - SINA*PYB_XB
      PX_YB   = BINV  *COSA*PXB_YB   - SINA*PYB_YB
      PX_MSQ  = BINV  *COSA*PXB_MSQ  - SINA*PYB_MSQ
     &        + BI_MSQ*COSA*PXB
      PX_CIRC = BINV  *COSA*PXB_CIRC - SINA*PYB_CIRC
      PX_DOUX = BINV  *COSA*PXB_DOUX - SINA*PYB_DOUX
      PX_DOUY = BINV  *COSA*PXB_DOUY - SINA*PYB_DOUY
      PX_SRCE = BINV  *COSA*PXB_SRCE - SINA*PYB_SRCE
C
C---- dPhi/dy
      PHIY    = BINV  *SINA*PXB      + COSA*PYB
      PY_XB   = BINV  *SINA*PXB_XB   + COSA*PYB_XB
      PY_YB   = BINV  *SINA*PXB_YB   + COSA*PYB_YB
      PY_MSQ  = BINV  *SINA*PXB_MSQ  + COSA*PYB_MSQ
     &        + BI_MSQ*SINA*PXB
      PY_CIRC = BINV  *SINA*PXB_CIRC + COSA*PYB_CIRC
      PY_DOUX = BINV  *SINA*PXB_DOUX + COSA*PYB_DOUX
      PY_DOUY = BINV  *SINA*PXB_DOUY + COSA*PYB_DOUY
      PY_SRCE = BINV  *SINA*PXB_SRCE + COSA*PYB_SRCE
C
C---- set final derivatives wrt physical x,y coordinates
      PX_X    = PX_XB*XB_X + PX_YB*YB_X
      PY_X    = PY_XB*XB_X + PY_YB*YB_X
      PX_Y    = PX_XB*XB_Y + PX_YB*YB_Y
      PY_Y    = PY_XB*XB_Y + PY_YB*YB_Y
C
      PX_ALFA = PX_XB*XB_A + PX_YB*YB_A  -  PHIY
      PY_ALFA = PY_XB*XB_A + PY_YB*YB_A  +  PHIX
C
      PX_MSQ  = PX_XB*XB_MSQ             + PX_MSQ
      PY_MSQ  = PY_XB*XB_MSQ             + PY_MSQ
C
      RETURN
      END ! PHIXY



      SUBROUTINE PIFAR(XXX, YYY, GAM, PSTAG, HSTAG,
     &                 CIRC, ALFA, MINF, QINF, SRCE, DOUX, DOUY,
     &                 PIFF, P_X, P_Y, 
     &                 P_CIRC, P_ALFA, P_MSQ, P_QINF,
     &                 P_SRCE, P_DOUX, P_DOUY )
C-------------------------------------------------------------
C     Calculates the pressure and sensitivities corresponding
C     to the farfield potential at the location XXX,YYY
C-------------------------------------------------------------
      IMPLICIT REAL (A-H,M,O-Z)
C
      GM1 = GAM - 1.0
C
      SINA = SIN(ALFA)
      COSA = COS(ALFA)
C
      CALL PHIXY(XXX, YYY, GAM,
     &           CIRC, ALFA, MINF, SRCE, DOUX, DOUY,
     &  PHIX, PX_X, PX_Y, PX_CIRC, PX_ALFA, PX_DOUX, PX_DOUY, PX_MSQ,
     &  PHIY, PY_X, PY_Y, PY_CIRC, PY_ALFA, PY_DOUX, PY_DOUY, PY_MSQ )
C
c      TB = 1.0 + 0.5*GM1*MINF**2
cC
c      QWT = 0.5*GM1*MINF**2 / TB
c      QWT_MSQ = 0.5*GM1/TB * ( 1.0 - QWT )
cC
c      TRAT = 1.0 - QWT*((PHIX+COSA)**2 + (PHIY+SINA)**2)
c      TRAT_MSQ =-QWT_MSQ*( (PHIX+COSA)**2     + (PHIY+SINA)**2    )
c     &          -QWT*2.0*( (PHIX+COSA)*PX_MSQ + (PHIY+SINA)*PY_MSQ)
c      TRAT_ALFA=-QWT*2.0*(-(PHIX+COSA)*SINA   + (PHIY+SINA)*COSA  )
cC
c      PIFF = PSTAG*TRAT**(GAM/GM1)
c      P_MSQ  = GAM/GM1 * PIFF/TRAT * TRAT_MSQ
c      P_ALFA = GAM/GM1 * PIFF/TRAT * TRAT_ALFA
c      P_PX   = GAM/GM1 * PIFF/TRAT *  (-2.0*QWT*(PHIX+COSA))
c      P_PY   = GAM/GM1 * PIFF/TRAT *  (-2.0*QWT*(PHIY+SINA))
cC
c      P_X    = P_PX*PX_X    + P_PY*PY_X
c      P_Y    = P_PX*PX_Y    + P_PY*PY_Y
c      P_CIRC = P_PX*PX_CIRC + P_PY*PY_CIRC
c      P_ALFA = P_PX*PX_ALFA + P_PY*PY_ALFA  +  P_ALFA
c      P_QINF = 0.0
cC
c      P_DOUX = P_PX*PX_DOUX + P_PY*PY_DOUX
c      P_DOUY = P_PX*PX_DOUY + P_PY*PY_DOUY
c      P_SRCE = 0.0
cC
C---- new setup for consistency with heavy gas model  !!! 23 March 92
C
      HRAT  = 1.0 
     &      - 0.5*QINF**2 *( (PHIX+COSA)**2   + (PHIY+SINA)**2  )/HSTAG
      HR_PX =    -QINF**2 *  (PHIX+COSA)                         /HSTAG
      HR_PY =    -QINF**2 *                     (PHIY+SINA)      /HSTAG
      HR_QI =    -QINF    *( (PHIX+COSA)**2   + (PHIY+SINA)**2  )/HSTAG
      HR_AL =    -QINF**2 *(-(PHIX+COSA)*SINA + (PHIY+SINA)*COSA)/HSTAG
C
C-----------------------------------------
      PRAT = HRAT**(GAM/GM1)
      PR_HR = (GAM/GM1)*PRAT/HRAT
      PRATM = PRAT - 1.0
C
      QSOH = QINF**2 / (GM1*HSTAG)
      IF(QSOH .LT. 0.05) THEN
C------ use Taylor series expansion for PRATM for small Mach numbers
        PXPY = PHIX**2 + 2.0*PHIX*COSA  + PHIY**2 + 2.0*PHIY*SINA
        PRATM = -0.5  *GAM*(1.0 + PXPY)    * QSOH
     &         + 0.125*GAM*(1.0 + PXPY)**2 * QSOH**2
      ENDIF
C
C-----------------------------------------
ccc      CALL FFPR(HRAT, PRAT,PR_HR, RRAT,RR_HR)
ccc      PRATM = PRAT - 1.0
C-----------------------------------------
C
C---- set pressure defect P - Po
      PIFF = PSTAG*PRATM
      P_PX = PSTAG*PR_HR*HR_PX
      P_PY = PSTAG*PR_HR*HR_PY
      P_AL = PSTAG*PR_HR*HR_AL
      P_QI = PSTAG*PR_HR*HR_QI
C
      P_X    = P_PX*PX_X    + P_PY*PY_X
      P_Y    = P_PX*PX_Y    + P_PY*PY_Y
      P_CIRC = P_PX*PX_CIRC + P_PY*PY_CIRC
      P_ALFA = P_PX*PX_ALFA + P_PY*PY_ALFA  +  P_AL
      P_MSQ  = P_PX*PX_MSQ  + P_PY*PY_MSQ
      P_QINF =                                 P_QI
C
      P_DOUX = P_PX*PX_DOUX + P_PY*PY_DOUX
      P_DOUY = P_PX*PX_DOUY + P_PY*PY_DOUY
      P_SRCE = 0.0
C
C
      RETURN
      END ! PIFAR
