

      SUBROUTINE PICALC(J,Q,QS,P,PIO,PIP)
      INCLUDE 'STATE.INC'
      DIMENSION Q(IX), QS(IX), P(IX), PIO(IX), PIP(IX)
C============================================================
C     For the current state vector...
C     ... calculates speed Q, upwinded speed QS, 
C     pressure P along streamtube J, and also
C     and pressures Pi-,Pi+ on streamlines J,J+1.
C
C     Essentially duplicates SUBROUTINE SETUP for a single
C     streamtube, but doesn't generate Jacobian.
C============================================================
      LOGICAL LLEM, LLEP
C
      JO = J
      JP = J + 1
C
      GM1 = GAM - 1.0
C
C
      AMU = 1.0 - MCRIT
C
C---- streamtube mass flow
      MJ = MASS*MFRACT(JO)
C
C---- sweep down streamtube
      DO 5 IO = 1, II-1
        IM = IO-1
        IP = IO+1
C
C------ is location 2 in LE cell?
        LLEM = .FALSE.
        LLEP = .FALSE.
        DO N=1, NBL
          IF( JO.EQ.JBLD(N)   .AND. IO.GE.NINL(N)-1
     &                        .AND. IO.LE.NINL(N)  ) LLEM = .TRUE.
          IF( JP.EQ.JBLD(N)-1 .AND. IO.GE.NINL(N)-1
     &                        .AND. IO.LE.NINL(N)  ) LLEP = .TRUE.
        ENDDO
C
        IF    (LLEM) THEN
          SWTP = 0.7
          SWTM = 0.3
        ELSEIF(LLEP) THEN
          SWTP = 0.3
          SWTM = 0.7
        ELSE
          SWTP = 0.5
          SWTM = 0.5
        ENDIF
C
C------ set geometric quantities
        SX2M = X(IP,JO) - X(IO,JO)
        SX2P = X(IP,JP) - X(IO,JP)
        SY2M = Y(IP,JO) - Y(IO,JO)
        SY2P = Y(IP,JP) - Y(IO,JP)
cc      SX2 = 0.5*( SX2M + SX2P )
cc      SY2 = 0.5*( SY2M + SY2P )
        SX2 = SWTM*SX2M + SWTP*SX2P
        SY2 = SWTM*SY2M + SWTP*SY2P
        S2 = SQRT(SX2*SX2 + SY2*SY2)
        S2INV = 1.0 / S2
        AX2 = 0.5*( (X(IP,JP)-X(IP,JO)) + (X(IO,JP)-X(IO,JO)) )
        AY2 = 0.5*( (Y(IP,JP)-Y(IP,JO)) + (Y(IO,JP)-Y(IO,JO)) )
        AN2 = (SX2*AY2 - SY2*AX2)*S2INV
C
C------ calculate speed, pressure defect, Mach number
        R2 = R(IO,JO)
        Q2 = MJ / (AN2*R2)
        P2 = (GM1/GAM) * R2 * (HINF - 0.5*Q2*Q2) - PSTOUT
        MSQ2 = Q2*Q2 / (GM1*(HINF - 0.5*Q2*Q2))
C
C------ for low Mach numbers with isentropic SETUP...
        IF(ISSET.EQ.2 .AND. MSQ2 .LT. 0.05) THEN
C
C-------- ...use fifth-order Taylor series to get more accurate pressure defect
          QSOH = Q2**2 / (GM1*HINF)
          P2 = 0.5*RSTOUT*Q2*Q2
     &       * (-1.0 + 0.25*QSOH - (2.0-GAM)/24.0 * QSOH**2)
C
        ENDIF
C
        IF(IO.EQ.1) THEN
C------- Skip until both 1 and 2 stations are defined for N-momentum eq.
         S0  = S2
         S1  = S2
         Q9  = Q2
         Q0  = Q2
         Q1  = Q2
         QS2 = Q2 
C
         Q(IO)  = Q2
         QS(IO) = QS2
         P(IO)  = P2
C
         GO TO 51
        ENDIF
C
C
        IF(MUCON .LT. 0.0) THEN
C
          MCF = 0.0
C
        ELSE
C
          MCF = 1.0
C
        ENDIF
C
C------ set basic dissipation level
        MSQ = 0.5*(MSQ1+MSQ2)
C
        ARG = (1.0-1.0/MSQ)/AMU
        IF( ARG .LT. -10.0) THEN
          MU     = 0.
        ELSEIF (ARG .GT. 10.0) THEN
          MU     = ABS(MUCON)/GAM * (1.0-1.0/MSQ)
        ELSE
          EMU    = EXP(ARG)
          MU     = ABS(MUCON)/GAM * AMU*LOG(1.0 + EMU)
        ENDIF
C
C
C------ set 1st, 2nd-order dissipation coefficients
        MUB = MU
        MUC = MU*MCF
C
C
C------ factor to correct dissipation for nonuniform grid
        SRAT    = (S2+S1)/(S1+S0)
C
C------ calculate upwinded speed
        QS2 = Q2 - (Q2-Q1)*MUB + (Q1-Q0)*MUC*SRAT
C
C------ store variables for returning
        Q(IO)  = Q2
        QS(IO) = QS2
        P(IO)  = P2
C
C======================================
C
C------ set cell-related geometric quantities
        AXA = AX1*AY2 - AX2*AY1
        SXSM = (SX1M*SY2M - SY1M*SX2M)
        SXSP = (SX1P*SY2P - SY1P*SX2P)
C
        XS = 0.25*(X(IP,JP)+X(IP,JO) - X(IM,JP)-X(IM,JO))
        YS = 0.25*(Y(IP,JP)+Y(IP,JO) - Y(IM,JP)-Y(IM,JO))
        XN = 0.5*(AX1+AX2)
        YN = 0.5*(AY1+AY2)
        SXN = XS*YN - YS*XN
        SXNINV = 1.0 / SXN
C
C------ Pcorr term
        PTMP  = 0.0625*PCWT
        PCORR = PTMP*(R1+R2)*(Q1+Q2)**2*(SXSM-SXSP)*S1INV*S2INV
C
        G1 = (SX1*XN+SY1*YN)*S1INV*SXNINV
        G2 = (SX2*XN+SY2*YN)*S2INV*SXNINV
C
C------ N-momentum balance gives  (Pi+) - (Pi-)
        PIDIF = MJ * (QS1*G1 - QS2*G2)   + PCORR*AXA*SXNINV
C
C------ Pi equation gives  (Pi+) + (Pi-)
        PISUM = P1 + P2 + 2.0*PCORR
C
C------ combine to get individual Pi pressures
        PIP(IO) = 0.5*(PISUM + PIDIF)
        PIO(IO) = 0.5*(PISUM - PIDIF)
C
C======================================
C------ set shorthand for next streamtube station
   51   SX1M = SX2M
        SX1P = SX2P
        SY1M = SY2M
        SY1P = SY2P
        SX1 = SX2
        SY1 = SY2
        AX1 = AX2
        AY1 = AY2
        AN1 = AN2
        S1INV = S2INV
C
        S0 = S1
        S1 = S2
C
        QS1 = QS2
        Q9 = Q0
        Q0 = Q1
        Q1 = Q2
        R1 = R2
        P1 = P2
        MSQ1 = MSQ2
C
  5   CONTINUE
C
      RETURN
      END ! PICALC
