
      SUBROUTINE XYPLOT(N,X,Y,XOFF,XSF,YOFF,YSF,ILIN,SH,ISYM)
      DIMENSION X(N), Y(N)
C
      IF(ISYM.LE.0) CALL XYLINE(N,X,Y,XOFF,XSF,YOFF,YSF,ILIN)
      IF(ISYM.NE.0) CALL XYSYMB(N,X,Y,XOFF,XSF,YOFF,YSF,SH,IABS(ISYM))
C
      RETURN
      END



      SUBROUTINE PLSUBS(XC,YC,CHX,STRING,ANGLE,NC,PLFONT)
C----------------------------------------------------------------
C     Plots character string as a subscript with font routine PLFONT.
C
C      XC,YC  = user coordinates of character to be subscripted 
C      CHX    = character width (user coordinates)
C      STRING = subscript character string to plot with NC characters
C      ANGLE  = angle of character (radians, positive is righthanded rotation)
C      NC     = number of subscript characters to plot
C               if NC<0 the length of the string is determined automatically 
C----------------------------------------------------------------
      CHARACTER*(*) STRING
      EXTERNAL PLFONT
      DATA  PI /3.1415926535897932384/
C
C---- subscript character reduction factor, and x,y-shift/chx
      DATA CHFAC, CHDX, CHDY / 0.7, 0.9, -0.4 /
C
      SINA = SIN(ANGLE*PI/180.0)
      COSA = COS(ANGLE*PI/180.0)
C
      XX = XC
      YY = YC
C
      IF (XC.EQ.999. .OR. YC.EQ.999.) THEN
        CALL GETLASTXY(XCHR,YCHR)
        IF(XC.EQ.999.) XX = XCHR
        IF(YC.EQ.999.) YY = YCHR
      ENDIF
C
      X = XX + CHX*(CHDX*COSA - CHDY*SINA)
      Y = YY + CHX*(CHDX*SINA + CHDY*COSA)
      CALL PLFONT(X,Y,CHX*CHFAC,STRING,ANGLE,NC)
C
      RETURN
      END



      SUBROUTINE PLSUPS(XC,YC,CHX,STRING,ANGLE,NC,PLFONT)
C----------------------------------------------------------------
C     Plots character string as a superscript with font routine PLFONT.
C
C      XC,YC  = user coordinates of character to be superscripted
C      CHX    = character width (user coordinates)
C      STRING = superscript character string to plot with NC characters
C      ANGLE  = angle of character (radians, positive is righthanded rotation)
C      NC     = number of superscript characters to plot
C               if NC<0 the length of the string is determined automatically 
C----------------------------------------------------------------
      CHARACTER*(*) STRING
      EXTERNAL PLFONT
      DATA  PI /3.1415926535897932384/
C
C---- superscript character reduction factor, and x,y-shift/chx
      DATA CHFAC, CHDX, CHDY / 0.7, 0.95, 0.7 /
C
      SINA = SIN(ANGLE*PI/180.0)
      COSA = COS(ANGLE*PI/180.0)
C
      XX = XC
      YY = YC
C
      IF (XC.EQ.999. .OR. YC.EQ.999.) THEN
        CALL GETLASTXY(XCHR,YCHR)
        IF(XC.EQ.999.) XX = XCHR
        IF(YC.EQ.999.) YY = YCHR
      ENDIF
C
      X = XX + CHX*(CHDX*COSA - CHDY*SINA)
      Y = YY + CHX*(CHDX*SINA + CHDY*COSA)
      CALL PLFONT(X,Y,CHX*CHFAC,STRING,ANGLE,NC)
C
      RETURN
      END

 

      SUBROUTINE SCALIT(N,Y,YOFF,YSF,ANN,NANN)
      DIMENSION Y(N)
C.............................................................
C
C     Determines scaling factor for the offset Y array so that
C     YSF*(Ymax-YOFF) will be O(1.0), but less than 1.0.
C
C     ANN = 1.0/YSF is therefore a "nice" plot axis max annotation.
C
C     Y(1:N)   array whose scaling factor is to be determined
C     YOFF     offset of Y array  (Y-YOFF is actually scaled)
C     YSF      Y scaling factor
C     ANN      recommended max Y annotation value  = 1.0/ANN
C     NANN     recommended number of Y annotations
C.............................................................
C
      AG2 = LOG10(2.0)
      AG5 = LOG10(5.0)
C
      YMAX = ABS(Y(1) - YOFF)
      DO 10 I=2, N
        YMAX = AMAX1( YMAX , ABS(Y(I)-YOFF) )
   10 CONTINUE
C
      IF(YMAX.EQ.0.0) THEN
       WRITE(*,*) 'SCALIT: Zero array passed in'
       YSF = 1.0E6
       ANN = 1.0/YSF
       NANN = 5
       RETURN
      ENDIF
C
      YLOG = LOG10(YMAX) - 0.001
C
C---- find log of nearest power of 10 above YMAX
      YLOG1 = AINT(YLOG+100.0) - 99.0
 
C---- find log of nearest 2x(power of 10) above YMAX
      YLOG2 = YLOG1 + AG2
      IF(YLOG2-1.0.GT.YLOG) YLOG2 = YLOG2 - 1.0
C
C---- find log of nearest 5x(power of 10) above YMAX
      YLOG5 = YLOG1 + AG5
      IF(YLOG5-1.0.GT.YLOG) YLOG5 = YLOG5 - 1.0
C
C---- find log of smallest upper bound
      GMIN = MIN( YLOG1 , YLOG2 , YLOG5 )
C
      NANN = 5
      IF (GMIN.EQ.YLOG2) NANN = 4
C
C---- set scaling factor and max annotation
      YSF = 10.0**(-GMIN)
      ANN = 1.0/YSF
C
      RETURN
      END ! SCALIT




 
      SUBROUTINE AIRFOI(N,X,Y,XOFF,YOFF,SF,XROT,YROT,AROT)
      IMPLICIT REAL (A-H,M,O-Z)
      DIMENSION X(N), Y(N)
      XMOD(XTMP) = SF * (XTMP - XOFF)
      YMOD(YTMP) = SF * (YTMP - YOFF)
C
      SINA = SIN(AROT)
      COSA = COS(AROT)
C
      DO 10 I=1, N
        XR = (X(I)-XROT)*COSA - (Y(I)-YROT)*SINA
        YR = (Y(I)-YROT)*COSA + (X(I)-XROT)*SINA
        XXM = XMOD(XR)
        YYM = YMOD(YR)
        IVIS = 2
        IF (I.EQ.1 .OR. XXM.LE.-0.05 .OR. XXM.GT.1.1) IVIS = 3
        CALL PLOT(XXM,YYM,IVIS)
   10 CONTINUE
      RETURN
      END ! AIRFOI


 

      SUBROUTINE DASH(X1,X2,Y)
      IMPLICIT REAL (A-H,M,O-Z)
C
      CALL NEWPEN(1)
      DXT = 0.08*(X2-X1)/50.
      DO 30 NT=1, 51
        XT = X1 + (X2-X1)*FLOAT(NT-1)/50.
        CALL PLOT(XT-DXT,Y,3)
        CALL PLOT(XT+DXT,Y,2)
   30 CONTINUE
C
      RETURN
      END ! DASH




      SUBROUTINE PABORT(XREL,YREL)
      COMMON /COM_ABORT/ XABORT(2), YABORT(2)
C
      CALL GETWINSIZE(XWIND,YWIND)
      CALL GETORIGIN(XORG,YORG)
      CALL GETFACTORS(XSCALE,YSCALE)
C
      CALL GETCOLOR(ICOL0)
      CALL NEWCOLORNAME('red')
C
C---- set abort window in xrel,yrel location (0..1, 0..1)
      XABORT(1) = (XREL*XWIND - 1.0 - XORG)/XSCALE
      XABORT(2) = (XREL*XWIND - 0.1 - XORG)/XSCALE
      YABORT(1) = (YREL*YWIND + 0.1 - YORG)/YSCALE
      YABORT(2) = (YREL*YWIND + 0.5 - YORG)/YSCALE
C
C---- plot abort window
      CALL PLOT(XABORT(1),YABORT(1),3)
      CALL PLOT(XABORT(2),YABORT(1),2)
      CALL PLOT(XABORT(2),YABORT(2),2)
      CALL PLOT(XABORT(1),YABORT(2),2)
      CALL PLOT(XABORT(1),YABORT(1),2)
C
      CHA = MIN( (XABORT(2)-XABORT(1))/8.0 , (YABORT(2)-YABORT(1))/1.5 )
      XCA = 0.5*(XABORT(2)+XABORT(1)) - 2.5*CHA
      YCA = 0.5*(YABORT(2)+YABORT(1)) - 0.5*CHA
      CALL PLCHAR(XCA,YCA,CHA,'ABORT',0.0,5)
C
      CALL NEWCOLOR(ICOL0)
      RETURN
      END


      FUNCTION LABORT(XC,YC)
      LOGICAL LABORT
      COMMON /COM_ABORT/ XABORT(2), YABORT(2)
C
C---- return T if location XC,YC falls within abort window
C
      LABORT = XC .GE. XABORT(1) .AND. 
     &         XC .LE. XABORT(2) .AND.
     &         YC .GE. YABORT(1) .AND.
     &         YC .LE. YABORT(2)
C
      RETURN
      END
 


 
      SUBROUTINE COLBAR(X0,Y0,W,H,NCOL,FMIN,FMAX,NNUM,CH,NDIG)
C----------------------------------------------------------
C     Plots vertical color bar with annotations.
C
C      X0,Y0  lower left point of color bar
C      W,H    width, height of color bar
C      NCOL   number of colors
C      FMIN   min annotation
C      FMAX   max annotation
C      NNUM   number of annotation intervals
C      CH     annotation character width
C      NDIG   number of digits after decimal point
C              -1 = no decimal point
C              -2 = number of digits set automatically
C----------------------------------------------------------
      DIMENSION X(5), Y(5)
C
      CALL GETCOLOR(ICOL0)
C
      DX = W
      DY = H / FLOAT(NCOL)
C
      DO ICOL=1, NCOL
C
        F = FMIN + (FMAX-FMIN)*FLOAT(ICOL-1)/FLOAT(NCOL-1)
C
        CALL NEWCOLOR(-ICOL)
C
        X(1) = X0
        X(2) = X(1) + DX
        X(3) = X(1) + DX
        X(4) = X(1)
        X(5) = X(1)
C
        Y(1) = Y0   + DY*FLOAT(ICOL-1)
        Y(2) = Y(1)
        Y(3) = Y(1) + DY
        Y(4) = Y(1) + DY
        Y(5) = Y(1)
C
        CALL POLYLINE(X,Y,5,1)
      ENDDO
C
      DF = (FMAX-FMIN) / FLOAT(NNUM)
      IF(NDIG.LE.-2) THEN
        ADF = ABS(DF)
        ND = MAX( 1 , INT(-LOG10(ADF)) )
        IF(ADF*10**ND - AINT(ADF*10**ND+0.01) .GT. 0.01) ND = ND + 1
        IF(ADF*10**ND - AINT(ADF*10**ND+0.01) .GT. 0.01) ND = ND + 1
      ELSE
        ND = NDIG
      ENDIF
C
      CALL NEWCOLORNAME('BLACK')
      DO N=0, NNUM
        FN = FMIN + DF*FLOAT(N)
        YN = Y0 + H*FLOAT(N)/FLOAT(NNUM)  - 0.6*CH
        XN = X0 + W                       + 0.7*CH
        CALL PLNUMB(XN,YN,CH,FN,0.0,ND)
      ENDDO
C
      CALL NEWCOLOR(ICOL0)
C
      RETURN
      END




      subroutine COLORSPECTRUMHUES1(ncols,HUESTR)
      character*(*) HUESTR
C
C...Sets up a color "Spectrum" table that gives a continuous 
C   blend between a small number of base colors specified in the
C   character string HUESTR, which can be "RYGCBM" or any subset thereof.
C
C   The RGB components associated with each specified color are set in 
C   the DATA statement below. These colors are appended to any existing 
C   colormap data, typically set up by COLORMAPDEFAULT.
C
C   These Spectrum colors are then accessible by NEWCOLOR(-icol)
C       -icol = 1 .. ncols
C
C NOTE: The maximum number of colors available to the Spectrum is LESS 
C       than the screen depth would indicate.  Some of the X colormap 
C       is used by other X window applications, typically this will be 
C       around 30-40 colormap entries. So, for an 8 bit depth, this 
C       leaves around 220 or so available for use, only 210 or so after 
C       the Palette colors (typ. 10) are assigned.  Less are available 
C       if other applications are using the X colormap.
C
C...RGB components of the Spectrum-defining base colors
C   COLWIDTH controls the relative extent of that defining color
C
      parameter (NRGB = 7)
      dimension irgbhue(3,NRGB), huewidth(NRGB)
C
      DIMENSION IRGBTABLE(3,NRGB)
      DIMENSION COLORWIDTH(NRGB)
      CHARACTER*(NRGB) COLORCHARS
c
      DATA COLORCHARS / 'MBCGYOR' /
      DATA ( (IRGBTABLE(L,I),L=1,3),COLORWIDTH(I), I=1, NRGB )
     &  / 240,     0,   240,  1.0,    ! Magenta
     &     32,    32,   255,  1.0,    ! Blue
     &      0,   240,   240,  1.2,    ! Cyan
     &     32,   255,    32,  0.5,    ! Green
     &    240,   240,     0,  1.4,    ! Yellow
     &    255,   160,     0,  1.0,    ! Orange
     &    255,    32,    32,  1.2  /  ! Red
C         Red   Green    Blue
C
      call convrt2uc(HUESTR)
      nhuemax = len(HUESTR)
c
      nhue = 0
      do k=1, nhuemax
        i = index( COLORCHARS , HUESTR(k:k) )
        if(i.ne.0) then
         nhue = nhue + 1
         irgbhue(1,nhue) = IRGBTABLE(1,i)
         irgbhue(2,nhue) = IRGBTABLE(2,i)
         irgbhue(3,nhue) = IRGBTABLE(3,i)
         huewidth(nhue)  = COLORWIDTH(i)
        endif
      enddo
c
      CALL COLORSPECTRUMTRP(ncols,nhue,irgbhue,huewidth)
C
      return
      end


