
      SUBROUTINE DUWAK1(HK,THETA,UO, 
     &           DO, DO_HK,DO_TH,DO_UO,
     &           UI, UI_HK,UI_TH,UI_UO )
      IMPLICIT REAL (A-H,M,O-Z)
C=========================================================
C     Computes profile parameters for simple half-wake
C
C     Input:
C        HK     deck kinematic shape parameter
C        THETA  deck momentum thickness
C        UO     outer velocity
C
C     Output:
C        DO     overall deck thickness
C        UI     inner velocity
C=========================================================
C
C---- Schlichting profile constants
      DATA CON1,CON2,CONA,CONB
     &   /  0.550000000 , 0.4155844156 , 0.3155844156 , 0.2688311688 /
C              11/20          32/77         243/770        207/770
C                                       CON2+1-2*CON1 , 2*(CON1-CON2)
C
      A =  HK * CONA
      B =  HK * UO * CONB  -  (HK + 1.0)*(1.0-CON1)
      C = (HK * UO * CON2  -  (HK + 1.0)* CON1     ) * UO  +  1.0
C
      SQT   = SQRT(B*B - 4.0*A*C)
      SQT_A = -2.0*C/SQT
      SQT_B =      B/SQT
      SQT_C = -2.0*A/SQT
C
      UI     = (-B - SQT) / (2.0*A)
      UI_SQT =     - 0.5  / (2.0*A*SQT)
C
      UI_A = -UI/A + UI_SQT*SQT_A
      UI_B = 0.5/A + UI_SQT*SQT_B
      UI_C =         UI_SQT*SQT_C
C
      UI_HK = UI_A *  CONA
     &      + UI_B * (UO*CONB - (1.0-CON1))
     &      + UI_C * (UO*CON2 -  CON1     )*UO
      UI_TH = 0.0
      UI_UO = UI_B *  HK*CONB
     &      + UI_C * (HK*CON2*2.0*UO - (HK + 1.0)*CON1)
C
      DO    =      HK * THETA / (1.0 - UI - CON1*(UO-UI))
      DO_UI = (1.0-CON1) * DO / (1.0 - UI - CON1*(UO-UI))
C
      DO_HK = DO_UI*UI_HK +   THETA / (1.0 - UI - CON1*(UO-UI))
      DO_TH = DO_UI*UI_TH +      HK / (1.0 - UI - CON1*(UO-UI))
      DO_UO = DO_UI*UI_UO + CON1*DO / (1.0 - UI - CON1*(UO-UI))
C
      RETURN
      END ! DUWAK1



      SUBROUTINE DUWAK2(HK,THETA,DI,UI,UO, 
     &                  DO, DO_HK,DO_TH,DO_DI,DO_UI,DO_UO,
     &                  UB, UB_HK,UB_TH,UB_DI,UB_UI,UB_UO )
      IMPLICIT REAL (A-H,M,O-Z)
C================================================================
C     Returns blend velocity and thickness of two-layer profile
C
C     Input:  
C        HK     kinematic shape parameter of entire profile
C        THETA  kinematic momentum thickness of entire profile
C        DI     thickness of inner layer
C        UI     inner velocity
C        UO     outer velocity
C
C     Output:
C        DO     thickness of overall layer
C        UB     blend velocity between inner and outer layers
C================================================================
C
C---- Schlichting profile constants
      DATA CON1,    CON2,         CON3,           CON4,        CON5
     &   /0.55, 0.4155844156, 0.1636363636, 0.02922077922, 0.2530175707/
C        11/20      32/77         9/55           9/308       1656/6545
C
      DATA      CON6,        CON7,          CON8,          CON9
     &   / 0.04915966387, 0.1168831169, 0.05500381971, 0.0075630252 /
C             117/2380       9/77           72/1309       9/1190
C
      DATA COND / 0.3461420932 /
C                  4531/13090
C
      DATA CONA,CONB
     &   / 0.3155844156 , 0.2688311688 /
C             243/770        207/770
C         CON2+1-2*CON1 , 2*(CON1-CON2)
C
      A =  HK * CONA
      B =  HK * UO * CONB  -  (HK + 1.0)*(1.0-CON1)
      C = (HK * UO * CON2  -  (HK + 1.0)* CON1     ) * UO  +  1.0
C
      SQT = SQRT(B*B - 4.0*A*C)
      UITMP  = (-B - SQT) / (2.0*A)
      DOTMP  = HK * THETA / (1.0 - UI - CON1*(UO-UI))
C
      IF(DOTMP .LE. DI) THEN
       WRITE(*,*) 'DUWAK2: Inner layer too thick.  Do/Di =', DOTMP/DI
      ENDIF
C
C---- set initial guesses for Newton variables  Ub, Do
      DO = HK*THETA / (1.0 - CON1*UO - (1.0-CON1)*UI)
      UB = UI
C
      DO 100 ITER=1, 10
C
        DUI = UB - UI
        DUO = UO - UB
C
        DRAT = DI/DO
C
        DRAT32 = SQRT(DRAT)**3
        DRAT52 = DRAT32 * DRAT
C
        DRAT3 = DRAT**3
        DRAT4 = DRAT3 * DRAT
C
        FR1    = CON1 - CON3*DRAT52 +     CON4*DRAT4
        FR1_DR =   -2.5*CON3*DRAT32 + 4.0*CON4*DRAT3
C
CCC        write(*,*) 'DUi DUo Do Ub', dui, duo, 100.0*DO, ub
C
        DSN = -(1.0-UI)**2 - (1.0-DRAT)*DUI**2
     &      - CON2*(DRAT*DUI**2 + DUO**2)
     &      + 2.0*(1.0-UI)*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
     &      - 2.0*DUI*DUO*FR1
        DSN_DUO =
     &      - CON2*(          2.0*DUO   )
     &      + 2.0*(1.0-UI)*(                 CON1                 )
     &      - 2.0*DUI    *FR1
        DSN_DUI =          - (1.0-DRAT)*2.0*DUI
     &      - CON2*(DRAT*2.0*DUI        )
     &      + 2.0*(1.0-UI)*(    (1.0-DRAT) + CON1*     DRAT       )
     &      - 2.0*    DUO*FR1
C
        DSN_UB = DSN_DUI - DSN_DUO
C
        DSN_DR = DUI**2 - CON2*DUI**2 + 2.0*(1.0-UI)*(-DUI + CON1*DUI)
     &         - 2.0*DUI*DUO*FR1_DR
C
        Z1  = DSN*DO + (HK-1.0)*THETA
        A11 = DSN    + DSN_DR*(-DRAT)
        A12 = DSN_UB*DO
C
        Z2  = (1.0-UI - DUI - CON1 *DUO)*DO
     &               + (1.0 - CON1)*DUI *DI - HK*THETA
        A21 = (1.0-UI - DUI - CON1*DUO)
        A22 = (       - 1.0 + CON1     )*DO
     &               + (1.0 - CON1)     *DI
C
C------ form inverse Jacobian
        DET =  A11*A22 - A12*A21
        B11 =  A22/DET
        B22 =  A11/DET
        B12 = -A12/DET
        B21 = -A21/DET
C
C------ check for convergence
        RMAX = MAX( ABS(Z1) , ABS(Z2) )
        IF(RMAX/THETA .LT. 1.0E-3) GO TO 110
C
C------ calculate Newton deltas
        DDO = Z1*B11 + Z2*B12
        DUB = Z1*B21 + Z2*B22
C
        RLX = 1.0
        IF(RLX*DDO/DO .GT. 0.5) RLX = 0.5 * DO/DDO
        IF(RLX*DDO/DO .LT. -.3) RLX = -.3 * DO/DDO
C
        DO = DO + RLX*DDO
        UB = UB + RLX*DUB
C
  100 CONTINUE
      RMS = SQRT(Z1**2 + Z2**2) / THETA
      WRITE(*,*) 'DUWAK2: Convergence failed.  Res = ', RMS
C
  110 CONTINUE
C
C
ccc   DSN = -(1.0-UI)**2 - (1.0-DRAT)*DUI**2
ccc  &    - CON2*(DRAT*DUI**2 + DUO**2)
ccc  &    + 2.0*(1.0-UI)*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
ccc  &    - 2.0*DUI*DUO*FR1
      DSN_UI =  (1.0-UI)*2.0
     &    - (2.0*DUI*(1.0-DRAT) + DUI*DRAT + DUO)
C
C
C---- set residual derivatives wrt all input variables
CCC   DUI = UB - UI
CCC   DUO = UO - UB
C
CCC   Z1    =  DO*DSN + (HK-1.0)*THETA
      Z1_HK =                    THETA
      Z1_TH =            HK-1.0
      Z1_DI =     DSN_DR
      Z1_UI = -DO*DSN_DUI + DO*DSN_UI
      Z1_UO =  DO*DSN_DUO
C
CCC   Z2    = (1.0-UI-DUI-CON1*DUO)*DO + (1.0-CON1)*DI*DUI - HK*THETA
      Z2_HK =                                              -    THETA
      Z2_TH =                                              - HK
      Z2_DI =                            (1.0-CON1)   *DUI
      Z2_UI =                          - (1.0-CON1)*DI
      Z2_UO =            -CON1     *DO
C
C
C---- calculate sensitivities
      DO_HK = -(B11*Z1_HK + B12*Z2_HK)
      DO_TH = -(B11*Z1_TH + B12*Z2_TH)
      DO_DI = -(B11*Z1_DI + B12*Z2_DI)
      DO_UI = -(B11*Z1_UI + B12*Z2_UI)
      DO_UO = -(B11*Z1_UO + B12*Z2_UO)
C
      UB_HK = -(B21*Z1_HK + B22*Z2_HK)
      UB_TH = -(B21*Z1_TH + B22*Z2_TH)
      UB_DI = -(B21*Z1_DI + B22*Z2_DI)
      UB_UI = -(B21*Z1_UI + B22*Z2_UI)
      UB_UO = -(B21*Z1_UO + B22*Z2_UO)
C
      RETURN
      END ! DUWAK2



      SUBROUTINE HCWAKE(HK,THETA,DI,DO,UI,UB,UO,CT,
     &    HS, HS_HK, HS_TH, HS_DI, HS_DO, HS_UI, HS_UB, HS_UO,
     &    CD, CD_HK, CD_TH, CD_DI, CD_DO, CD_UI, CD_UB, CD_UO, CD_CT)
      IMPLICIT REAL (A-H,M,O-Z)
C=========================================================
C     Computes profile parameters for two-layer half-wake
C
C     Input:
C        HK     deck kinematic shape parameter
C        THETA  deck momentum thickness
C        DI     inner shear layer thickness
C        DO     overall shear layer thickness
C        UI     inner velocity
C        UB     velocity at inner/outer blend point
C        UO     outer velocity
C        CT     sqrt(max. shear coefficient)
C
C     Output:
C        HS     K.E. shape parameter
C        CD     dissipation coefficient
C
C=========================================================
C
C---- Schlichting profile constants
      DATA CON1,    CON2,         CON3,           CON4,        CON5
     &   /0.55, 0.4155844156, 0.1636363636, 0.02922077922, 0.2530175707/
C        11/20      32/77         9/55           9/308       1656/6545
C
      DATA      CON6,        CON7,          CON8,          CON9
     &   / 0.04915966387, 0.1168831169, 0.05500381971, 0.0075630252 /
C             117/2380       9/77           72/1309       9/1190
C
      DATA COND / 0.3461420932 /
C                  4531/13090
C
C---- set various constants needed to define Theta*
      DUI = UB - UI
      DUO = UO - UB
C
      DRAT = DI/DO
C
      DRAT3 = DRAT**3
      DRAT4 = DRAT3 * DRAT
      DRAT6 = DRAT3 * DRAT3
      DRAT7 = DRAT3 * DRAT4
C
      DRAT32  = SQRT(DRAT3)
      DRAT52  = DRAT32 * DRAT
      DRAT72  = DRAT52 * DRAT
      DRAT92  = DRAT72 * DRAT
      DRAT112 = DRAT92 * DRAT
C
C
      FR1    = CON1 - CON3*DRAT52 +     CON4*DRAT4
      FR1_DR =   -2.5*CON3*DRAT32 + 4.0*CON4*DRAT3
C
      FR2    = CON1 - CON5*DRAT52 +     CON6*DRAT4
      FR2_DR =   -2.5*CON5*DRAT32 + 4.0*CON6*DRAT3
C
      FR3    = CON2 - CON7*DRAT4  +     CON8*DRAT112 -     CON9*DRAT7
      FR3_DR =   -4.0*CON7*DRAT3  + 5.5*CON8*DRAT92  - 7.0*CON9*DRAT6
C
      CU2    =  3.0*DUI*(1.0-DRAT) + 3.0*CON1*(DUI*DRAT + DUO)
      CU2_DUI=  3.0    *(1.0-DRAT) + 3.0*CON1*(    DRAT      )
      CU2_DUO=                       3.0*CON1
      CU2_DR = -3.0*DUI            + 3.0*CON1* DUI
C
      CU1    = 3.0*( DUI**2*(1.0-DRAT) + CON2*(DRAT*DUI**2 + DUO**2)
     &             + 2.0*DUI*DUO*FR1   )
      CU1_DUO= 3.0*(                     CON2*(          2.0*DUO   )
     &             + 2.0*DUI    *FR1   )
      CU1_DUI= 3.0*(2.0*DUI*(1.0-DRAT) + CON2*(DRAT*2.0*DUI        )
     &             + 2.0    *DUO*FR1   )
      CU1_DR = 3.0*(-DUI**2            + CON2* DUI**2
     &             + 2.0*DUI*DUO*FR1_DR)
C
      TSN = (1.0-UI)**3 - CU2    *(1.0-UI)**2 + CU1    *(1.0-UI)
     &    - DUI**3*(1.0-DRAT) - COND*(DRAT*DUI**3 + DUO**3)
     &    - 3.0*DUI**2*DUO*FR2    - 3.0*DUI*DUO**2*FR3
      TSN_DUO =         - CU2_DUO*(1.0-UI)**2 + CU1_DUO*(1.0-UI)
     &                        - COND*(          3.0*DUO**2)
     &    - 3.0*DUI**2    *FR2    - 6.0*DUI*DUO   *FR3
      TSN_DUI =         - CU2_DUI*(1.0-UI)**2 + CU1_DUI*(1.0-UI)
     &- 3.0*DUI**2*(1.0-DRAT) - COND*(DRAT*3.0*DUI**2     )
     &    - 6.0*DUI   *DUO*FR2    - 3.0    *DUO**2*FR3
      TSN_DR  =         - CU2_DR *(1.0-UI)**2 + CU1_DR *(1.0-UI)
     &    + DUI**3            - COND*(     DUI**3         )
     &    - 3.0*DUI**2*DUO*FR2_DR - 3.0*DUI*DUO**2*FR3_DR
C
      TSN_UO = TSN_DUO
      TSN_UI = -3.0*(1.0-UI)**2 + CU2*2.0*(1.0-UI) - CU1
     &       - TSN_DUI
      TSN_UB = TSN_DUI - TSN_DUO
C
C---- set and linearize H**
      HS    = DO*TSN   /THETA + 3.0 - HK
      HS_HK =                    - 1.0
      HS_TH =-DO*TSN   /THETA**2
      HS_DI = DO*TSN_DI/THETA
      HS_DO =(   TSN_DR*(-DRAT) + TSN)/THETA
      HS_UI = DO*TSN_UI/THETA
      HS_UB = DO*TSN_UB/THETA
      HS_UO = DO*TSN_UO/THETA
C
c        ts = do*(ui-ui**3 + duo*(1.0-3.0*UI**2)*con1
c     &     - 3.0*ui*duo**2*con2 - duo**3*cond)
C
c        ds = (1.0 - ui - con1*duo)*do
c        th = ds - do*((1.0-ui)**2 + con2*duo**2 - (1.0-ui)*2.0*con1*duo)
c        ts = 3.0*th - ds
c     &     + do*( (1.0-ui)**3 - 3.0*(1.0-ui)**2*con1*duo
c     &          + 3.0*(1.0-ui)*con2*duo**2 - cond*duo**3 )
cC
c        write(*,*) 'd,t,s', ds, th, ts
C
C---- set and linearize Cd
      CD = 0.0
      CD_HK = 0.0
      CD_TH = 0.0
      CD_DI = 0.0
      CD_DO = 0.0
      CD_UI = 0.0
      CD_UB = 0.0
      CD_UO = 0.0
      CD_CT = 0.0
C
      RETURN
      END ! PRWAKE




      SUBROUTINE DUWALL(HK,THETA,UO,RT,MS,CT, BB, LCONV,
     &                  DO, DO_HK, DO_TH, DO_UO, DO_RT, DO_MS,
     &                  UI, UI_HK, UI_TH, UI_UO, UI_RT, UI_MS,
     &                  CF, CF_HK, CF_TH, CF_UO, CF_RT, CF_MS )
C================================================================
C     Returns wall slip velocity and thickness of wall BL profile,
C
C     Input:
C        HK     kinematic shape parameter
C        THETA  kinematic momentum thickness of profile deck
C        UO     uo/ue outer velocity
C        RT     momentum thickness based on ue and THETA
C        MS     Mach^2 based on ue
C        CT     sqrt(max. shear coefficient) in outer layer
C
C     Output:
C        BB     outer profile exponent
C        DO     thickness of profile deck
C        UI     inner "slip" velocity
C        CF     wall skin friction
C================================================================
      IMPLICIT REAL (A-H,M,O-Z)
      LOGICAL LCONV
C
      DIMENSION ETAE(4)
      DIMENSION A(3,3), Z(3,5), R(3)
C
      DIMENSION WGHT(0:16)
C
C---- set pi/2 , number of integration intervals
      DATA HPI , N  / 1.570796327 ,  16 /
C
C---- set weights for Simpson's rule
      DATA WGHT / 1.0, 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 1.0/
C
C---- maximum g' =  9 / 4^(4/3)
      DATA GDX / 1.417411182 /
C
C---- inner shear profile decay constant
      DATA RKTAUI / 8.0 /
C
C---- slip velocity coefficient
      DATA AK / 0.09 /
C
C---- initialize variables
ccc      IF(UI.EQ.0.0) UI = 0.5*UO
ccc      IF(DO.EQ.0.0) DO = HK*THETA / (1.0 - 0.5*(UO+UI))
      UI = 0.5*UO
      DO = HK*THETA / (1.0 - 0.5*(UO+UI))
C
      DT = HK*THETA - (1.0-UO)*DO
      TT =    THETA - (1.0-UO)*DO*(UI + 0.5*(UO-UI))
C
      HKT = DT/TT
      RTT = RT*UO*TT/THETA
      MST = MS
      CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
c      CALL CFL(HKT,RTT,MST,CFZ,CFL_HKT,CFL_RTT,CFL_MST)
c      IF(CFZ.GT.CFB) THEN
c       CFB     = CFZ
c       CFB_HKT = CFL_HKT
c       CFB_RTT = CFL_RTT
c       CFB_MST = CFL_MST
c      ENDIF
C
      UT = UO * SQRT(0.5*ABS(CFB))
C
      BB = 1.5
C
      DETA = 1.0/FLOAT(N)
      LCONV = .TRUE.
C
      DO 1000 ITER=1, 12
C
        DT    = HK*THETA - (1.0-UO)*DO
        DT_DO =          - (1.0-UO)
C
        DT_HK =    THETA
        DT_UO =                  DO
C
C----------------
        HKT    = DT   /TT
        HKT_DO = DT_DO/TT
        HKT_TT =  -HKT/TT
C
        HKT_HK = DT_HK/TT
        HKT_UO = DT_UO/TT
C
C----------------
        RTT    = RT*UO*TT/THETA
        RTT_TT = RT*UO   /THETA
C
        RTT_TH =     -RTT/THETA
        RTT_UO = RT   *TT/THETA
        RTT_RT =    UO*TT/THETA
C
C----------------
        MST = MS*UO**2
C
        MST_UO = MS*2.0*UO
        MST_MS = UO**2
C
C----------------
        CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
c        CALL CFL(HKT,RTT,MST,CFZ,CFL_HKT,CFL_RTT,CFL_MST)
c        IF(CFZ.GT.CFB) THEN
c         CFB     = CFZ
c         CFB_HKT = CFL_HKT
c         CFB_RTT = CFL_RTT
c         CFB_MST = CFL_MST
c        ENDIF
C
C
        CF     = UO**2 * CFB
C
        CF_HKT = UO**2 * CFB_HKT
        CF_RTT = UO**2 * CFB_RTT
        CF_MST = UO**2 * CFB_MST
C
        CF_DO = CF_HKT*HKT_DO
        CF_TT = CF_HKT*HKT_TT + CF_RTT*RTT_TT
        CF_HK = CF_HKT*HKT_HK
        CF_TH =                 CF_RTT*RTT_TH
        CF_UO = CF_HKT*HKT_UO + CF_RTT*RTT_UO + CF_MST*MST_UO
     &        + 2.0*UO * CFB
        CF_RT =                 CF_RTT*RTT_RT
        CF_MS =                                 CF_MST*MST_MS
C
C
        S = SIGN( 1.0 , CFB )
        UT     = UO       *SQRT(0.5*S*CFB)
        UT_CFB = UO*0.25*S/SQRT(0.5*S*CFB)
C
        UT_DO = UT_CFB*(CFB_HKT*HKT_DO                 )
        UT_TT = UT_CFB*(CFB_HKT*HKT_TT + CFB_RTT*RTT_TT)
C
        UT_HK = UT_CFB*(CFB_HKT*HKT_HK                 )
        UT_TH = UT_CFB*(                 CFB_RTT*RTT_TH)
        UT_UO = UT_CFB*(CFB_HKT*HKT_UO + CFB_RTT*RTT_UO)
        UT_RT = UT_CFB*(                 CFB_RTT*RTT_RT)
        UT_MS = UT_CFB*(CFB_MST*MST_MS)
C
C---------------
c        UI    = (S*HPI/AK)*UT   
c        UI_DO = (S*HPI/AK)*UT_DO
c        UI_TT = (S*HPI/AK)*UT_TT
cC
c        UI_HK = (S*HPI/AK)*UT_HK
c        UI_TH = (S*HPI/AK)*UT_TH
c        UI_UO = (S*HPI/AK)*UT_UO
c        UI_RT = (S*HPI/AK)*UT_RT
c        UI_MS = (S*HPI/AK)*UT_MS
C
        FU = S*HPI/AK
        UI    = TANH(FU*UT)
        UI_UT = (1.0 - UI**2)*FU
C
        UI_DO = UI_UT*UT_DO
        UI_TT = UI_UT*UT_TT
C
        UI_HK = UI_UT*UT_HK
        UI_TH = UI_UT*UT_TH
        UI_UO = UI_UT*UT_UO
        UI_RT = UI_UT*UT_RT
        UI_MS = UI_UT*UT_MS
C
C--------------- 
        AD    = AK*RT*UT   *DO/THETA
        AD_DO = AK*RT*UT      /THETA
     &        + AK*RT*UT_DO*DO/THETA
        AD_TT = AK*RT*UT_TT*DO/THETA
C
        AD_HK = AK*RT*UT_HK*DO/THETA
        AD_TH = AK*RT*UT_TH*DO/THETA
     &                    - AD/THETA
        AD_UO = AK*RT*UT_UO*DO/THETA
        AD_RT = AK*RT*UT_RT*DO/THETA
     &        + AK   *UT   *DO/THETA
        AD_MS = AK*RT*UT_MS*DO/THETA
C
C--------------
        ADT = ATAN(AD)
        ADINV = 1.0/(1.0 + AD**2)
C
        ADT_DO = AD_DO*ADINV
        ADT_TT = AD_TT*ADINV
C
        ADT_HK = AD_HK*ADINV
        ADT_TH = AD_TH*ADINV
        ADT_UO = AD_UO*ADINV
        ADT_RT = AD_RT*ADINV
        ADT_MS = AD_MS*ADINV
C
C--------------
        DUO    = UO  - (UI   /HPI)*ADT
        DUO_DO =     - (UI_DO/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TT =     - (UI_TT/HPI)*ADT - (UI/HPI)*ADT_TT
C
        DUO_HK =     - (UI_HK/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TH =     - (UI_TH/HPI)*ADT - (UI/HPI)*ADT_TH
        DUO_UO = 1.0 - (UI_UO/HPI)*ADT - (UI/HPI)*ADT_UO
        DUO_RT =     - (UI_RT/HPI)*ADT - (UI/HPI)*ADT_RT
        DUO_MS =     - (UI_MS/HPI)*ADT - (UI/HPI)*ADT_MS
C
C--------------
        ETAB    = (BB-1.0)/(2.0*BB-1.0)
        ETAB_BB =     1.0 /(2.0*BB-1.0)**2
        IF(ETAB.LE.0.0) THEN
         ETAB    = 0.0
         ETAB_BB = 0.0
         ETA    = 0.0
         ETA_BB = 0.0
         GDX    = 1.417
         GDX_BB = 0.0
        ELSE
         ETA    = ETAB**(1.0/BB)
         ETA_BB = ETA*(ETAB_BB/(BB*ETAB) - LOG(ETAB)/BB**2)
         GDX    = 2.0*BB*(ETAB - ETAB**2 )/ETA
         GDX_BB = 2.0*   (ETAB - ETAB**2 )/ETA
     &          + 2.0*BB*(1.0  - ETAB*2.0)*ETAB_BB/ETA
     &          - (GDX/ETA)*ETA_BB
        ENDIF
C
C------ set integration limits
        ETAE(1) = 0.0
        ETAE(2) = MIN(  5.0/AD , 1.0 )
        ETAE(3) = MIN( 50.0/AD , 1.0 )
        ETAE(4) = 1.0
C
ccc        write(*,*) iter, (etae(k),k=1, 4)
C
        DSN = 0.0
        DSN_DO = 0.0
        DSN_BB = 0.0
        DSN_TT = 0.0
        DSN_HK = 0.0
        DSN_TH = 0.0
        DSN_UO = 0.0
        DSN_RT = 0.0
        DSN_MS = 0.0
C
        THN = 0.0
        THN_DO = 0.0
        THN_BB = 0.0
        THN_TT = 0.0
        THN_HK = 0.0
        THN_TH = 0.0
        THN_UO = 0.0
        THN_RT = 0.0
        THN_MS = 0.0
C
        TSN = 0.0
        TSN_DO = 0.0
        TSN_BB = 0.0
        TSN_TT = 0.0
        TSN_HK = 0.0
        TSN_TH = 0.0
        TSN_UO = 0.0
        TSN_RT = 0.0
        TSN_MS = 0.0
C
        CD = 0.0
        CD_DO = 0.0
        CD_BB = 0.0
        CD_TT = 0.0
        CD_HK = 0.0
        CD_TH = 0.0
        CD_UO = 0.0
        CD_RT = 0.0
        CD_MS = 0.0
C
C------ do integration in three parts
        DO 100 IPASS=1, 3
          DETA = (ETAE(IPASS+1) - ETAE(IPASS)) / FLOAT(N)
C
          DSUM = 0.0
          D_DO = 0.0
          D_BB = 0.0
          D_TT = 0.0
          D_HK = 0.0
          D_TH = 0.0
          D_UO = 0.0
          D_RT = 0.0
          D_MS = 0.0
C
          TSUM = 0.0
          T_DO = 0.0
          T_BB = 0.0
          T_TT = 0.0
          T_HK = 0.0
          T_TH = 0.0
          T_UO = 0.0
          T_RT = 0.0
          T_MS = 0.0
C
          SSUM = 0.0
          S_DO = 0.0
          S_BB = 0.0
          S_TT = 0.0
          S_HK = 0.0
          S_TH = 0.0
          S_UO = 0.0
          S_RT = 0.0
          S_MS = 0.0
C
          CSUM = 0.0
          C_DO = 0.0
          C_BB = 0.0
          C_TT = 0.0
          C_HK = 0.0
          C_TH = 0.0
          C_UO = 0.0
          C_RT = 0.0
          C_MS = 0.0
          C_CT = 0.0
C
          DO 10 I=0, N
            ETA = ETAE(IPASS) + DETA*FLOAT(I)
C
            ALE = 0.0
            IF(ETA.GT.0.0) ALE = LOG(ETA)
C
            ETABB = ETA**BB
            G    = 2.0* ETABB - ETABB**2
            G_BB = 2.0*(ETABB - ETABB**2)*ALE
C
            ETABM = 0.0
            IF(ETA.GT.0.0) ETABM = ETABB/ETA
            GD    = 2.0*BB*(ETABM -     ETABM*ETABB)
            GD_BB = 2.0*BB*(ETABM - 2.0*ETABM*ETABB)*ALE
     &            + 2.0*   (ETABM -     ETABM*ETABB)*ALE
C
            AY    = ETA*AD
            AY_DO = ETA*AD_DO
            AY_TT = ETA*AD_TT
            AY_HK = ETA*AD_HK
            AY_TH = ETA*AD_TH
            AY_UO = ETA*AD_UO
            AY_RT = ETA*AD_RT
            AY_MS = ETA*AD_MS
C
            AYT = ATAN(AY)
            AYINV = 1.0/(1.0 + AY**2)
            AYT_DO = AY_DO*AYINV
            AYT_TT = AY_TT*AYINV
            AYT_HK = AY_HK*AYINV
            AYT_TH = AY_TH*AYINV
            AYT_UO = AY_UO*AYINV
            AYT_RT = AY_RT*AYINV
            AYT_MS = AY_MS*AYINV
C
            U    = (UI   /HPI)*AYT + DUO   *G
            U_BB =                   DUO   *G_BB
            U_DO = (UI_DO/HPI)*AYT + DUO_DO*G + (UI/HPI)*AYT_DO
            U_TT = (UI_TT/HPI)*AYT + DUO_TT*G + (UI/HPI)*AYT_TT
            U_HK = (UI_HK/HPI)*AYT + DUO_HK*G + (UI/HPI)*AYT_HK
            U_TH = (UI_TH/HPI)*AYT + DUO_TH*G + (UI/HPI)*AYT_TH
            U_UO = (UI_UO/HPI)*AYT + DUO_UO*G + (UI/HPI)*AYT_UO
            U_RT = (UI_RT/HPI)*AYT + DUO_RT*G + (UI/HPI)*AYT_RT
            U_MS = (UI_MS/HPI)*AYT + DUO_MS*G + (UI/HPI)*AYT_MS
C
            ADAY    = AD*AYINV
            ADAY_AD = (1.0 - 2.0*ETA*AY*AYINV)*AYINV
            ADAY_DO = ADAY_AD*AD_DO
            ADAY_TT = ADAY_AD*AD_TT
            ADAY_HK = ADAY_AD*AD_HK
            ADAY_TH = ADAY_AD*AD_TH
            ADAY_UO = ADAY_AD*AD_UO
            ADAY_RT = ADAY_AD*AD_RT
            ADAY_MS = ADAY_AD*AD_MS
C
            UD    = (UI   /HPI)*ADAY + DUO   *GD
            UD_BB =                    DUO   *GD_BB
            UD_DO = (UI_DO/HPI)*ADAY + DUO_DO*GD + (UI/HPI)*ADAY_DO
            UD_TT = (UI_TT/HPI)*ADAY + DUO_TT*GD + (UI/HPI)*ADAY_TT
            UD_HK = (UI_HK/HPI)*ADAY + DUO_HK*GD + (UI/HPI)*ADAY_HK
            UD_TH = (UI_TH/HPI)*ADAY + DUO_TH*GD + (UI/HPI)*ADAY_TH
            UD_UO = (UI_UO/HPI)*ADAY + DUO_UO*GD + (UI/HPI)*ADAY_UO
            UD_RT = (UI_RT/HPI)*ADAY + DUO_RT*GD + (UI/HPI)*ADAY_RT
            UD_MS = (UI_MS/HPI)*ADAY + DUO_MS*GD + (UI/HPI)*ADAY_MS
C
            FI = EXP(-RKTAUI * ETA)
            TAU    = 0.5*CF   *FI + CT**2 * (GD/GDX)**2
            TAU_BB =                CT**2 * (GD/GDX)*2.0
     &                                    * (GD_BB - GDX_BB*GD/GDX)/GDX
            TAU_DO = 0.5*CF_DO*FI - 0.5*CF*AYT_DO/HPI
            TAU_TT = 0.5*CF_TT*FI - 0.5*CF*AYT_TT/HPI
            TAU_HK = 0.5*CF_HK*FI - 0.5*CF*AYT_HK/HPI
            TAU_TH = 0.5*CF_TH*FI - 0.5*CF*AYT_TH/HPI
            TAU_UO = 0.5*CF_UO*FI - 0.5*CF*AYT_UO/HPI
            TAU_RT = 0.5*CF_RT*FI - 0.5*CF*AYT_RT/HPI
            TAU_MS = 0.5*CF_MS*FI - 0.5*CF*AYT_MS/HPI
            TAU_CT = 2.0*CT * (GD/GDX)**2
C
            DSUM = DSUM + WGHT(I)*(1.0 - U)
            D_BB = D_BB - WGHT(I)*       U_BB
            D_DO = D_DO - WGHT(I)*       U_DO
            D_TT = D_TT - WGHT(I)*       U_TT
            D_HK = D_HK - WGHT(I)*       U_HK
            D_TH = D_TH - WGHT(I)*       U_TH
            D_UO = D_UO - WGHT(I)*       U_UO
            D_RT = D_RT - WGHT(I)*       U_RT
            D_MS = D_MS - WGHT(I)*       U_MS
C
            TSUM = TSUM + WGHT(I)*(U   -   U*U)
            T_BB = T_BB + WGHT(I)*(1.0 - 2.0*U)*U_BB
            T_DO = T_DO + WGHT(I)*(1.0 - 2.0*U)*U_DO
            T_TT = T_TT + WGHT(I)*(1.0 - 2.0*U)*U_TT
            T_HK = T_HK + WGHT(I)*(1.0 - 2.0*U)*U_HK
            T_TH = T_TH + WGHT(I)*(1.0 - 2.0*U)*U_TH
            T_UO = T_UO + WGHT(I)*(1.0 - 2.0*U)*U_UO
            T_RT = T_RT + WGHT(I)*(1.0 - 2.0*U)*U_RT
            T_MS = T_MS + WGHT(I)*(1.0 - 2.0*U)*U_MS
C
            SSUM = SSUM + WGHT(I)*(U   -   U*U*U)
            S_BB = S_BB + WGHT(I)*(1.0 - 3.0*U*U)*U_BB
            S_DO = S_DO + WGHT(I)*(1.0 - 3.0*U*U)*U_DO
            S_TT = S_TT + WGHT(I)*(1.0 - 3.0*U*U)*U_TT
            S_HK = S_HK + WGHT(I)*(1.0 - 3.0*U*U)*U_HK
            S_TH = S_TH + WGHT(I)*(1.0 - 3.0*U*U)*U_TH
            S_UO = S_UO + WGHT(I)*(1.0 - 3.0*U*U)*U_UO
            S_RT = S_RT + WGHT(I)*(1.0 - 3.0*U*U)*U_RT
            S_MS = S_MS + WGHT(I)*(1.0 - 3.0*U*U)*U_MS
C
            CSUM = CSUM + WGHT(I)* TAU   *GD
            C_BB = C_BB + WGHT(I)*(TAU_BB*GD + TAU*GD_BB)
            C_DO = C_DO + WGHT(I)* TAU_DO*GD
            C_TT = C_TT + WGHT(I)* TAU_TT*GD
            C_HK = C_HK + WGHT(I)* TAU_HK*GD
            C_TH = C_TH + WGHT(I)* TAU_TH*GD
            C_UO = C_UO + WGHT(I)* TAU_UO*GD
            C_RT = C_RT + WGHT(I)* TAU_RT*GD
            C_MS = C_MS + WGHT(I)* TAU_MS*GD
            C_CT = C_CT + WGHT(I)* TAU_CT*GD
C
   10     CONTINUE
C
          DSN    = DSN    + (DETA/3.0)*DSUM
          DSN_BB = DSN_BB + (DETA/3.0)*D_BB
          DSN_DO = DSN_DO + (DETA/3.0)*D_DO
          DSN_TT = DSN_TT + (DETA/3.0)*D_TT
          DSN_HK = DSN_HK + (DETA/3.0)*D_HK
          DSN_TH = DSN_TH + (DETA/3.0)*D_TH
          DSN_UO = DSN_UO + (DETA/3.0)*D_UO
          DSN_RT = DSN_RT + (DETA/3.0)*D_RT
          DSN_MS = DSN_MS + (DETA/3.0)*D_MS
C
          THN    = THN    + (DETA/3.0)*TSUM
          THN_BB = THN_BB + (DETA/3.0)*T_BB
          THN_DO = THN_DO + (DETA/3.0)*T_DO
          THN_TT = THN_TT + (DETA/3.0)*T_TT
          THN_HK = THN_HK + (DETA/3.0)*T_HK
          THN_TH = THN_TH + (DETA/3.0)*T_TH
          THN_UO = THN_UO + (DETA/3.0)*T_UO
          THN_RT = THN_RT + (DETA/3.0)*T_RT
          THN_MS = THN_MS + (DETA/3.0)*T_MS
C
          TSN    = TSN    + (DETA/3.0)*SSUM
          TSN_BB = TSN_BB + (DETA/3.0)*S_BB
          TSN_DO = TSN_DO + (DETA/3.0)*S_DO
          TSN_TT = TSN_TT + (DETA/3.0)*S_TT
          TSN_HK = TSN_HK + (DETA/3.0)*S_HK
          TSN_TH = TSN_TH + (DETA/3.0)*S_TH
          TSN_UO = TSN_UO + (DETA/3.0)*S_UO
          TSN_RT = TSN_RT + (DETA/3.0)*S_RT
          TSN_MS = TSN_MS + (DETA/3.0)*S_MS
C
          CD    = CD    + (DETA/3.0)*CSUM
          CD_BB = CD_BB + (DETA/3.0)*C_BB
          CD_DO = CD_DO + (DETA/3.0)*C_DO
          CD_TT = CD_TT + (DETA/3.0)*C_TT
          CD_HK = CD_HK + (DETA/3.0)*C_HK
          CD_TH = CD_TH + (DETA/3.0)*C_TH
          CD_UO = CD_UO + (DETA/3.0)*C_UO
          CD_RT = CD_RT + (DETA/3.0)*C_RT
          CD_MS = CD_MS + (DETA/3.0)*C_MS
          CD_CT = CD_CT + (DETA/3.0)*C_CT
C
  100   CONTINUE
C
C------ set up 3x3 system for DO BB TT
        R(1  ) = DO*DSN - HK*THETA
        A(1,1) = DO*DSN_DO + DSN
        A(1,2) = DO*DSN_BB
        A(1,3) = DO*DSN_TT
        Z(1,1) = DO*DSN_HK - THETA
        Z(1,2) = DO*DSN_TH - HK
        Z(1,3) = DO*DSN_UO
        Z(1,4) = DO*DSN_RT
        Z(1,5) = DO*DSN_MS
C
        R(2  ) = DO*THN - THETA
        A(2,1) = DO*THN_DO + THN
        A(2,2) = DO*THN_BB
        A(2,3) = DO*THN_TT
        Z(2,1) = DO*THN_HK
        Z(2,2) = DO*THN_TH - 1.0
        Z(2,3) = DO*THN_UO
        Z(2,4) = DO*THN_RT
        Z(2,5) = DO*THN_MS
C
        ADL    = 0.5*LOG(1.0 + AD**2)/AD
        ADL_AD =    1.0/(1.0 + AD**2) - ADL/AD
C
        ADL_DO = ADL_AD*AD_DO
        ADL_TT = ADL_AD*AD_TT
        ADL_HK = ADL_AD*AD_HK
        ADL_TH = ADL_AD*AD_TH
        ADL_UO = ADL_AD*AD_UO
        ADL_RT = ADL_AD*AD_RT
        ADL_MS = ADL_AD*AD_MS
C
        DK = 2.0/(BB+1.0) - 1.0/(2.0*BB+1.0)
        DK_BB = -2.0/(BB+1.0)**2 + 2.0/(2.0*BB+1.0)**2
C
        TC    = (UI   /HPI)*(ADT    - ADL   ) + DUO   *DK
        TC_BB =                                 DUO   *DK_BB
        TC_DO = (UI_DO/HPI)*(ADT    - ADL   ) + DUO_DO*DK
     &        + (UI   /HPI)*(ADT_DO - ADL_DO)
        TC_TT = (UI_TT/HPI)*(ADT    - ADL   ) + DUO_TT*DK
     &        + (UI   /HPI)*(ADT_TT - ADL_TT)
        TC_HK = (UI_HK/HPI)*(ADT    - ADL   ) + DUO_HK*DK
     &        + (UI   /HPI)*(ADT_HK - ADL_HK)
        TC_TH = (UI_TH/HPI)*(ADT    - ADL   ) + DUO_TH*DK
     &        + (UI   /HPI)*(ADT_TH - ADL_TH)
        TC_UO = (UI_UO/HPI)*(ADT    - ADL   ) + DUO_UO*DK
     &        + (UI   /HPI)*(ADT_UO - ADL_UO)
        TC_RT = (UI_RT/HPI)*(ADT    - ADL   ) + DUO_RT*DK
     &        + (UI   /HPI)*(ADT_RT - ADL_RT)
        TC_MS = (UI_MS/HPI)*(ADT    - ADL   ) + DUO_MS*DK
     &        + (UI   /HPI)*(ADT_MS - ADL_MS)
C
        R(3  ) = (1.0-UO)*DO*TC    + TT - THETA
        A(3,1) = (1.0-UO)*DO*TC_DO + (1.0-UO)*TC
        A(3,2) = (1.0-UO)*DO*TC_BB
        A(3,3) = (1.0-UO)*DO*TC_TT + 1.0
        Z(3,1) = (1.0-UO)*DO*TC_HK
        Z(3,2) = (1.0-UO)*DO*TC_TH      - 1.0
        Z(3,3) = (1.0-UO)*DO*TC_UO - DO*TC
        Z(3,4) = (1.0-UO)*DO*TC_RT
        Z(3,5) = (1.0-UO)*DO*TC_MS
C
        RSQ = (R(1)/THETA)**2 + (R(2)/THETA)**2 + (R(3)/THETA)**2
        IF(RSQ .LT. 1.0E-9) GO TO 1010
C
ccc        CALL GAUSSN(3,3,A,R,1)
C
        DDO = -R(1)
        DBB = -R(2)
        DTT = -R(3)
C
        DMAX = MAX( ABS(DDO/DO) , ABS(DBB/BB) , ABS(DTT/TT) )
        RLX = 1.0
        IF(DMAX.GT.0.5) RLX = 0.5/DMAX
C
        DO = DO + RLX*DDO
        BB = BB + RLX*DBB
        TT = TT + RLX*DTT
c
ccc        if(iter.gt.8) write(*,*) iter, do,bb,tt, sqrt(rsq)
C
 1000 CONTINUE
C
      WRITE(*,*) 'PRWALL: Convergence failed. Res =', SQRT(RSQ)
      LCONV = .FALSE.
      RETURN
C
 1010 CONTINUE
C
C
C---- get DO, BB, TT responses per unit DS, TH, UO, RT, MS changes
ccc      CALL GAUSSN(3,3,A,Z,5)
C
      DO_HK = -Z(1,1)
      DO_TH = -Z(1,2)
      DO_UO = -Z(1,3)
      DO_RT = -Z(1,4)
      DO_MS = -Z(1,5)
C
      BB_HK = -Z(2,1)
      BB_TH = -Z(2,2)
      BB_UO = -Z(2,3)
      BB_RT = -Z(2,4)
      BB_MS = -Z(2,5)
C
      TT_HK = -Z(3,1)
      TT_TH = -Z(3,2)
      TT_UO = -Z(3,3)
      TT_RT = -Z(3,4)
      TT_MS = -Z(3,5)
C
C---- set final UI sensitivities
      UI_HK = UI_HK + UI_DO*DO_HK + UI_TT*TT_HK
      UI_TH = UI_TH + UI_DO*DO_TH + UI_TT*TT_TH
      UI_UO = UI_UO + UI_DO*DO_UO + UI_TT*TT_UO
      UI_RT = UI_RT + UI_DO*DO_RT + UI_TT*TT_RT
      UI_MS = UI_MS + UI_DO*DO_MS + UI_TT*TT_MS
C
C---- set final CF sensitivities
      CF_HK = CF_HK + CF_DO*DO_HK + CF_TT*TT_HK
      CF_TH = CF_TH + CF_DO*DO_TH + CF_TT*TT_TH
      CF_UO = CF_UO + CF_DO*DO_UO + CF_TT*TT_UO
      CF_RT = CF_RT + CF_DO*DO_RT + CF_TT*TT_RT
      CF_MS = CF_MS + CF_DO*DO_MS + CF_TT*TT_MS
C
C---- set HS and linearize it
      HS      = TSN/THN
      HS_THN =  -HS/THN
      HS_TSN =  1.0/THN
C
      HS_DO = HS_THN*THN_DO + HS_TSN*TSN_DO
      HS_BB = HS_THN*THN_BB + HS_TSN*TSN_BB
      HS_TT = HS_THN*THN_TT + HS_TSN*TSN_TT
      HS_HK = HS_THN*THN_HK + HS_TSN*TSN_HK
      HS_TH = HS_THN*THN_TH + HS_TSN*TSN_TH
      HS_UO = HS_THN*THN_UO + HS_TSN*TSN_UO
      HS_RT = HS_THN*THN_RT + HS_TSN*TSN_RT
      HS_MS = HS_THN*THN_MS + HS_TSN*TSN_MS
C
      HS_HK = HS_HK + HS_DO*DO_HK + HS_BB*BB_HK + HS_TT*TT_HK
      HS_TH = HS_TH + HS_DO*DO_TH + HS_BB*BB_TH + HS_TT*TT_TH
      HS_UO = HS_UO + HS_DO*DO_UO + HS_BB*BB_UO + HS_TT*TT_UO
      HS_RT = HS_RT + HS_DO*DO_RT + HS_BB*BB_RT + HS_TT*TT_RT
      HS_MS = HS_MS + HS_DO*DO_MS + HS_BB*BB_MS + HS_TT*TT_MS
C
C---- set and linearize Cd
      CD = 0.0
      CD_HK = 0.0
      CD_TH = 0.0
      CD_UO = 0.0
      CD_RT = 0.0
      CD_MS = 0.0
      CD_CT = 0.0
C
C---- add on dependent sensitivity contributions
      CD_DO = 0.0
      CD_BB = 0.0
      CD_TT = 0.0
C
      CD_HK = CD_HK + CD_DO*DO_HK + CD_BB*BB_HK + CD_TT*TT_HK
      CD_TH = CD_TH + CD_DO*DO_TH + CD_BB*BB_TH + CD_TT*TT_TH
      CD_UO = CD_UO + CD_DO*DO_UO + CD_BB*BB_UO + CD_TT*TT_UO
      CD_RT = CD_RT + CD_DO*DO_RT + CD_BB*BB_RT + CD_TT*TT_RT
      CD_MS = CD_MS + CD_DO*DO_MS + CD_BB*BB_MS + CD_TT*TT_MS
C
      RETURN
      END ! DUWALL


      SUBROUTINE PRWALL(HK,THETA,UO,RT,MS,CT, BB, LCONV,
     &                  DO, DO_HK, DO_TH, DO_UO, DO_RT, DO_MS,
     &                  UI, UI_HK, UI_TH, UI_UO, UI_RT, UI_MS,
     &                  HS, HS_HK, HS_TH, HS_UO, HS_RT, HS_MS,
     &                  CF, CF_HK, CF_TH, CF_UO, CF_RT, CF_MS,
     &                  CD, CD_HK, CD_TH, CD_UO, CD_RT, CD_MS, CD_CT )
C================================================================
C     Returns wall slip velocity and thickness of wall BL profile,
C     and all derived integral quantities and sensitivities.
C
C     Input:
C        HK     kinematic shape parameter
C        THETA  kinematic momentum thickness of profile deck
C        UO     uo/ue outer velocity
C        RT     momentum thickness based on ue and THETA
C        MS     Mach^2 based on ue
C        CT     sqrt(max. shear coefficient) in outer layer
C
C     Output:
C        BB     outer profile exponent
C        DO     thickness of profile deck
C        UI     inner "slip" velocity
C        HS     KE thickness shape parameter
C        CF     wall skin friction
C        CD     dissipation coefficient
C================================================================
      IMPLICIT REAL (A-H,M,O-Z)
      LOGICAL LCONV
C
      DIMENSION ETAE(4)
      DIMENSION A(3,3), Z(3,5), R(3)
C
      DIMENSION WGHT(0:16)
C
C---- set pi/2 , number of integration intervals
      DATA HPI , N  / 1.570796327 ,  16 /
C
C---- set weights for Simpson's rule
      DATA WGHT / 1.0, 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 1.0/
C
C---- maximum g' =  9 / 4^(4/3)
      DATA GDX / 1.417411182 /
C
C---- inner shear profile decay constant
      DATA RKTAUI / 8.0 /
C
C---- slip velocity coefficient
      DATA AK / 0.09 /
C
C---- initialize variables
ccc      IF(UI.EQ.0.0) UI = 0.5*UO
ccc      IF(DO.EQ.0.0) DO = HK*THETA / (1.0 - 0.5*(UO+UI))
      UI = 0.5*UO
      DO = HK*THETA / (1.0 - 0.5*(UO+UI))
C
      DT = HK*THETA - (1.0-UO)*DO
      TT =    THETA - (1.0-UO)*DO*(UI + 0.5*(UO-UI))
C
      HKT = DT/TT
      RTT = RT*UO*TT/THETA
      MST = MS
      CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
c      CALL CFL(HKT,RTT,MST,CFZ,CFL_HKT,CFL_RTT,CFL_MST)
c      IF(CFZ.GT.CFB) THEN
c       CFB     = CFZ
c       CFB_HKT = CFL_HKT
c       CFB_RTT = CFL_RTT
c       CFB_MST = CFL_MST
c      ENDIF
C
      UT = UO * SQRT(0.5*ABS(CFB))
C
      BB = 1.5
C
      DETA = 1.0/FLOAT(N)
      LCONV = .TRUE.
C
      DO 1000 ITER=1, 12
C
        DT    = HK*THETA - (1.0-UO)*DO
        DT_DO =          - (1.0-UO)
C
        DT_HK =    THETA
        DT_UO =                     DO
C
C----------------
        HKT    = DT   /TT
        HKT_DO = DT_DO/TT
        HKT_TT =  -HKT/TT
C
        HKT_HK = DT_HK/TT
        HKT_UO = DT_UO/TT
C
C----------------
        RTT    = RT*UO*TT/THETA
        RTT_TT = RT*UO   /THETA
C
        RTT_TH =     -RTT/THETA
        RTT_UO = RT   *TT/THETA
        RTT_RT =    UO*TT/THETA
C
C----------------
        MST = MS*UO**2
C
        MST_UO = MS*2.0*UO
        MST_MS = UO**2
C
C----------------
        CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
c        CALL CFL(HKT,RTT,MST,CFZ,CFL_HKT,CFL_RTT,CFL_MST)
c        IF(CFZ.GT.CFB) THEN
c         CFB     = CFZ
c         CFB_HKT = CFL_HKT
c         CFB_RTT = CFL_RTT
c         CFB_MST = CFL_MST
c        ENDIF
C
C
        CF     = UO**2 * CFB
C
        CF_HKT = UO**2 * CFB_HKT
        CF_RTT = UO**2 * CFB_RTT
        CF_MST = UO**2 * CFB_MST
C
        CF_DO = CF_HKT*HKT_DO
        CF_TT = CF_HKT*HKT_TT + CF_RTT*RTT_TT
        CF_HK = CF_HKT*HKT_HK
        CF_TH =                 CF_RTT*RTT_TH
        CF_UO = CF_HKT*HKT_UO + CF_RTT*RTT_UO + CF_MST*MST_UO
     &        + 2.0*UO * CFB
        CF_RT =                 CF_RTT*RTT_RT
        CF_MS =                                 CF_MST*MST_MS
C
C
        S = SIGN( 1.0 , CFB )
        UT     = UO       *SQRT(0.5*S*CFB)
        UT_CFB = UO*0.25*S/SQRT(0.5*S*CFB)
C
        UT_DO = UT_CFB*(CFB_HKT*HKT_DO                 )
        UT_TT = UT_CFB*(CFB_HKT*HKT_TT + CFB_RTT*RTT_TT)
C
        UT_HK = UT_CFB*(CFB_HKT*HKT_HK                 )
        UT_TH = UT_CFB*(                 CFB_RTT*RTT_TH)
        UT_UO = UT_CFB*(CFB_HKT*HKT_UO + CFB_RTT*RTT_UO)
        UT_RT = UT_CFB*(                 CFB_RTT*RTT_RT)
        UT_MS = UT_CFB*(CFB_MST*MST_MS)
C
C---------------
c        UI    = (S*HPI/AK)*UT   
c        UI_DO = (S*HPI/AK)*UT_DO
c        UI_TT = (S*HPI/AK)*UT_TT
cC
c        UI_HK = (S*HPI/AK)*UT_HK
c        UI_TH = (S*HPI/AK)*UT_TH
c        UI_UO = (S*HPI/AK)*UT_UO
c        UI_RT = (S*HPI/AK)*UT_RT
c        UI_MS = (S*HPI/AK)*UT_MS
C
        FU = S*HPI/AK
        UI    = TANH(FU*UT)
        UI_UT = (1.0 - UI**2)*FU
C
        UI_DO = UI_UT*UT_DO
        UI_TT = UI_UT*UT_TT
C
        UI_HK = UI_UT*UT_HK
        UI_TH = UI_UT*UT_TH
        UI_UO = UI_UT*UT_UO
        UI_RT = UI_UT*UT_RT
        UI_MS = UI_UT*UT_MS
C
C--------------- 
        AD    = AK*RT*UT   *DO/THETA
        AD_DO = AK*RT*UT      /THETA
     &        + AK*RT*UT_DO*DO/THETA
        AD_TT = AK*RT*UT_TT*DO/THETA
C
        AD_HK = AK*RT*UT_HK*DO/THETA
        AD_TH = AK*RT*UT_TH*DO/THETA
     &                    - AD/THETA
        AD_UO = AK*RT*UT_UO*DO/THETA
        AD_RT = AK*RT*UT_RT*DO/THETA
     &        + AK   *UT   *DO/THETA
        AD_MS = AK*RT*UT_MS*DO/THETA
C
C--------------
        ADT = ATAN(AD)
        ADINV = 1.0/(1.0 + AD**2)
C
        ADT_DO = AD_DO*ADINV
        ADT_TT = AD_TT*ADINV
C
        ADT_HK = AD_HK*ADINV
        ADT_TH = AD_TH*ADINV
        ADT_UO = AD_UO*ADINV
        ADT_RT = AD_RT*ADINV
        ADT_MS = AD_MS*ADINV
C
C--------------
        DUO    = UO  - (UI   /HPI)*ADT
        DUO_DO =     - (UI_DO/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TT =     - (UI_TT/HPI)*ADT - (UI/HPI)*ADT_TT
C
        DUO_HK =     - (UI_HK/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TH =     - (UI_TH/HPI)*ADT - (UI/HPI)*ADT_TH
        DUO_UO = 1.0 - (UI_UO/HPI)*ADT - (UI/HPI)*ADT_UO
        DUO_RT =     - (UI_RT/HPI)*ADT - (UI/HPI)*ADT_RT
        DUO_MS =     - (UI_MS/HPI)*ADT - (UI/HPI)*ADT_MS
C
C--------------
        ETAB    = (BB-1.0)/(2.0*BB-1.0)
        ETAB_BB =     1.0 /(2.0*BB-1.0)**2
        IF(ETAB.LE.0.0) THEN
         ETAB    = 0.0
         ETAB_BB = 0.0
         ETA    = 0.0
         ETA_BB = 0.0
         GDX    = 1.417
         GDX_BB = 0.0
        ELSE
         ETA    = ETAB**(1.0/BB)
         ETA_BB = ETA*(ETAB_BB/(BB*ETAB) - LOG(ETAB)/BB**2)
         GDX    = 2.0*BB*(ETAB - ETAB**2 )/ETA
         GDX_BB = 2.0*   (ETAB - ETAB**2 )/ETA
     &          + 2.0*BB*(1.0  - ETAB*2.0)*ETAB_BB/ETA
     &          - (GDX/ETA)*ETA_BB
        ENDIF
C
C------ set integration limits
        ETAE(1) = 0.0
        ETAE(2) = MIN(  5.0/AD , 1.0 )
        ETAE(3) = MIN( 50.0/AD , 1.0 )
        ETAE(4) = 1.0
C
ccc        write(*,*) iter, (etae(k),k=1, 4)
C
        DSN = 0.0
        DSN_DO = 0.0
        DSN_BB = 0.0
        DSN_TT = 0.0
        DSN_HK = 0.0
        DSN_TH = 0.0
        DSN_UO = 0.0
        DSN_RT = 0.0
        DSN_MS = 0.0
C
        THN = 0.0
        THN_DO = 0.0
        THN_BB = 0.0
        THN_TT = 0.0
        THN_HK = 0.0
        THN_TH = 0.0
        THN_UO = 0.0
        THN_RT = 0.0
        THN_MS = 0.0
C
        TSN = 0.0
        TSN_DO = 0.0
        TSN_BB = 0.0
        TSN_TT = 0.0
        TSN_HK = 0.0
        TSN_TH = 0.0
        TSN_UO = 0.0
        TSN_RT = 0.0
        TSN_MS = 0.0
C
        CD = 0.0
        CD_DO = 0.0
        CD_BB = 0.0
        CD_TT = 0.0
        CD_HK = 0.0
        CD_TH = 0.0
        CD_UO = 0.0
        CD_RT = 0.0
        CD_MS = 0.0
C
C------ do integration in three parts
        DO 100 IPASS=1, 3
          DETA = (ETAE(IPASS+1) - ETAE(IPASS)) / FLOAT(N)
C
          DSUM = 0.0
          D_DO = 0.0
          D_BB = 0.0
          D_TT = 0.0
          D_HK = 0.0
          D_TH = 0.0
          D_UO = 0.0
          D_RT = 0.0
          D_MS = 0.0
C
          TSUM = 0.0
          T_DO = 0.0
          T_BB = 0.0
          T_TT = 0.0
          T_HK = 0.0
          T_TH = 0.0
          T_UO = 0.0
          T_RT = 0.0
          T_MS = 0.0
C
          SSUM = 0.0
          S_DO = 0.0
          S_BB = 0.0
          S_TT = 0.0
          S_HK = 0.0
          S_TH = 0.0
          S_UO = 0.0
          S_RT = 0.0
          S_MS = 0.0
C
          CSUM = 0.0
          C_DO = 0.0
          C_BB = 0.0
          C_TT = 0.0
          C_HK = 0.0
          C_TH = 0.0
          C_UO = 0.0
          C_RT = 0.0
          C_MS = 0.0
          C_CT = 0.0
C
          DO 10 I=0, N
            ETA = ETAE(IPASS) + DETA*FLOAT(I)
C
            ALE = 0.0
            IF(ETA.GT.0.0) ALE = LOG(ETA)
C
            ETABB = ETA**BB
            G    = 2.0* ETABB - ETABB**2
            G_BB = 2.0*(ETABB - ETABB**2)*ALE
C
            ETABM = 0.0
            IF(ETA.GT.0.0) ETABM = ETABB/ETA
            GD    = 2.0*BB*(ETABM -     ETABM*ETABB)
            GD_BB = 2.0*BB*(ETABM - 2.0*ETABM*ETABB)*ALE
     &            + 2.0*   (ETABM -     ETABM*ETABB)*ALE
C
            AY    = ETA*AD
            AY_DO = ETA*AD_DO
            AY_TT = ETA*AD_TT
            AY_HK = ETA*AD_HK
            AY_TH = ETA*AD_TH
            AY_UO = ETA*AD_UO
            AY_RT = ETA*AD_RT
            AY_MS = ETA*AD_MS
C
            AYT = ATAN(AY)
            AYINV = 1.0/(1.0 + AY**2)
            AYT_DO = AY_DO*AYINV
            AYT_TT = AY_TT*AYINV
            AYT_HK = AY_HK*AYINV
            AYT_TH = AY_TH*AYINV
            AYT_UO = AY_UO*AYINV
            AYT_RT = AY_RT*AYINV
            AYT_MS = AY_MS*AYINV
C
            U    = (UI   /HPI)*AYT + DUO   *G
            U_BB =                   DUO   *G_BB
            U_DO = (UI_DO/HPI)*AYT + DUO_DO*G + (UI/HPI)*AYT_DO
            U_TT = (UI_TT/HPI)*AYT + DUO_TT*G + (UI/HPI)*AYT_TT
            U_HK = (UI_HK/HPI)*AYT + DUO_HK*G + (UI/HPI)*AYT_HK
            U_TH = (UI_TH/HPI)*AYT + DUO_TH*G + (UI/HPI)*AYT_TH
            U_UO = (UI_UO/HPI)*AYT + DUO_UO*G + (UI/HPI)*AYT_UO
            U_RT = (UI_RT/HPI)*AYT + DUO_RT*G + (UI/HPI)*AYT_RT
            U_MS = (UI_MS/HPI)*AYT + DUO_MS*G + (UI/HPI)*AYT_MS
C
            ADAY    = AD*AYINV
            ADAY_AD = (1.0 - 2.0*ETA*AY*AYINV)*AYINV
            ADAY_DO = ADAY_AD*AD_DO
            ADAY_TT = ADAY_AD*AD_TT
            ADAY_HK = ADAY_AD*AD_HK
            ADAY_TH = ADAY_AD*AD_TH
            ADAY_UO = ADAY_AD*AD_UO
            ADAY_RT = ADAY_AD*AD_RT
            ADAY_MS = ADAY_AD*AD_MS
C
            UD    = (UI   /HPI)*ADAY + DUO   *GD
            UD_BB =                    DUO   *GD_BB
            UD_DO = (UI_DO/HPI)*ADAY + DUO_DO*GD + (UI/HPI)*ADAY_DO
            UD_TT = (UI_TT/HPI)*ADAY + DUO_TT*GD + (UI/HPI)*ADAY_TT
            UD_HK = (UI_HK/HPI)*ADAY + DUO_HK*GD + (UI/HPI)*ADAY_HK
            UD_TH = (UI_TH/HPI)*ADAY + DUO_TH*GD + (UI/HPI)*ADAY_TH
            UD_UO = (UI_UO/HPI)*ADAY + DUO_UO*GD + (UI/HPI)*ADAY_UO
            UD_RT = (UI_RT/HPI)*ADAY + DUO_RT*GD + (UI/HPI)*ADAY_RT
            UD_MS = (UI_MS/HPI)*ADAY + DUO_MS*GD + (UI/HPI)*ADAY_MS
C
            FI = EXP(-RKTAUI * ETA)
            TAU    = 0.5*CF   *FI + CT**2 * (GD/GDX)**2
            TAU_BB =                CT**2 * (GD/GDX)*2.0
     &                                    * (GD_BB - GDX_BB*GD/GDX)/GDX
            TAU_DO = 0.5*CF_DO*FI - 0.5*CF*AYT_DO/HPI
            TAU_TT = 0.5*CF_TT*FI - 0.5*CF*AYT_TT/HPI
            TAU_HK = 0.5*CF_HK*FI - 0.5*CF*AYT_HK/HPI
            TAU_TH = 0.5*CF_TH*FI - 0.5*CF*AYT_TH/HPI
            TAU_UO = 0.5*CF_UO*FI - 0.5*CF*AYT_UO/HPI
            TAU_RT = 0.5*CF_RT*FI - 0.5*CF*AYT_RT/HPI
            TAU_MS = 0.5*CF_MS*FI - 0.5*CF*AYT_MS/HPI
            TAU_CT = 2.0*CT * (GD/GDX)**2
C
            DSUM = DSUM + WGHT(I)*(1.0 - U)
            D_BB = D_BB - WGHT(I)*       U_BB
            D_DO = D_DO - WGHT(I)*       U_DO
            D_TT = D_TT - WGHT(I)*       U_TT
            D_HK = D_HK - WGHT(I)*       U_HK
            D_TH = D_TH - WGHT(I)*       U_TH
            D_UO = D_UO - WGHT(I)*       U_UO
            D_RT = D_RT - WGHT(I)*       U_RT
            D_MS = D_MS - WGHT(I)*       U_MS
C
            TSUM = TSUM + WGHT(I)*(U   -   U*U)
            T_BB = T_BB + WGHT(I)*(1.0 - 2.0*U)*U_BB
            T_DO = T_DO + WGHT(I)*(1.0 - 2.0*U)*U_DO
            T_TT = T_TT + WGHT(I)*(1.0 - 2.0*U)*U_TT
            T_HK = T_HK + WGHT(I)*(1.0 - 2.0*U)*U_HK
            T_TH = T_TH + WGHT(I)*(1.0 - 2.0*U)*U_TH
            T_UO = T_UO + WGHT(I)*(1.0 - 2.0*U)*U_UO
            T_RT = T_RT + WGHT(I)*(1.0 - 2.0*U)*U_RT
            T_MS = T_MS + WGHT(I)*(1.0 - 2.0*U)*U_MS
C
            SSUM = SSUM + WGHT(I)*(U   -   U*U*U)
            S_BB = S_BB + WGHT(I)*(1.0 - 3.0*U*U)*U_BB
            S_DO = S_DO + WGHT(I)*(1.0 - 3.0*U*U)*U_DO
            S_TT = S_TT + WGHT(I)*(1.0 - 3.0*U*U)*U_TT
            S_HK = S_HK + WGHT(I)*(1.0 - 3.0*U*U)*U_HK
            S_TH = S_TH + WGHT(I)*(1.0 - 3.0*U*U)*U_TH
            S_UO = S_UO + WGHT(I)*(1.0 - 3.0*U*U)*U_UO
            S_RT = S_RT + WGHT(I)*(1.0 - 3.0*U*U)*U_RT
            S_MS = S_MS + WGHT(I)*(1.0 - 3.0*U*U)*U_MS
C
            CSUM = CSUM + WGHT(I)* TAU   *GD
            C_BB = C_BB + WGHT(I)*(TAU_BB*GD + TAU*GD_BB)
            C_DO = C_DO + WGHT(I)* TAU_DO*GD
            C_TT = C_TT + WGHT(I)* TAU_TT*GD
            C_HK = C_HK + WGHT(I)* TAU_HK*GD
            C_TH = C_TH + WGHT(I)* TAU_TH*GD
            C_UO = C_UO + WGHT(I)* TAU_UO*GD
            C_RT = C_RT + WGHT(I)* TAU_RT*GD
            C_MS = C_MS + WGHT(I)* TAU_MS*GD
            C_CT = C_CT + WGHT(I)* TAU_CT*GD
C
   10     CONTINUE
C
          DSN    = DSN    + (DETA/3.0)*DSUM
          DSN_BB = DSN_BB + (DETA/3.0)*D_BB
          DSN_DO = DSN_DO + (DETA/3.0)*D_DO
          DSN_TT = DSN_TT + (DETA/3.0)*D_TT
          DSN_HK = DSN_HK + (DETA/3.0)*D_HK
          DSN_TH = DSN_TH + (DETA/3.0)*D_TH
          DSN_UO = DSN_UO + (DETA/3.0)*D_UO
          DSN_RT = DSN_RT + (DETA/3.0)*D_RT
          DSN_MS = DSN_MS + (DETA/3.0)*D_MS
C
          THN    = THN    + (DETA/3.0)*TSUM
          THN_BB = THN_BB + (DETA/3.0)*T_BB
          THN_DO = THN_DO + (DETA/3.0)*T_DO
          THN_TT = THN_TT + (DETA/3.0)*T_TT
          THN_HK = THN_HK + (DETA/3.0)*T_HK
          THN_TH = THN_TH + (DETA/3.0)*T_TH
          THN_UO = THN_UO + (DETA/3.0)*T_UO
          THN_RT = THN_RT + (DETA/3.0)*T_RT
          THN_MS = THN_MS + (DETA/3.0)*T_MS
C
          TSN    = TSN    + (DETA/3.0)*SSUM
          TSN_BB = TSN_BB + (DETA/3.0)*S_BB
          TSN_DO = TSN_DO + (DETA/3.0)*S_DO
          TSN_TT = TSN_TT + (DETA/3.0)*S_TT
          TSN_HK = TSN_HK + (DETA/3.0)*S_HK
          TSN_TH = TSN_TH + (DETA/3.0)*S_TH
          TSN_UO = TSN_UO + (DETA/3.0)*S_UO
          TSN_RT = TSN_RT + (DETA/3.0)*S_RT
          TSN_MS = TSN_MS + (DETA/3.0)*S_MS
C
          CD    = CD    + (DETA/3.0)*CSUM
          CD_BB = CD_BB + (DETA/3.0)*C_BB
          CD_DO = CD_DO + (DETA/3.0)*C_DO
          CD_TT = CD_TT + (DETA/3.0)*C_TT
          CD_HK = CD_HK + (DETA/3.0)*C_HK
          CD_TH = CD_TH + (DETA/3.0)*C_TH
          CD_UO = CD_UO + (DETA/3.0)*C_UO
          CD_RT = CD_RT + (DETA/3.0)*C_RT
          CD_MS = CD_MS + (DETA/3.0)*C_MS
          CD_CT = CD_CT + (DETA/3.0)*C_CT
C
  100   CONTINUE
C
C------ set up 3x3 system for DO BB TT
        R(1  ) = DO*DSN - HK*THETA
        A(1,1) = DO*DSN_DO + DSN
        A(1,2) = DO*DSN_BB
        A(1,3) = DO*DSN_TT
        Z(1,1) = DO*DSN_HK - THETA
        Z(1,2) = DO*DSN_TH - HK
        Z(1,3) = DO*DSN_UO
        Z(1,4) = DO*DSN_RT
        Z(1,5) = DO*DSN_MS
C
        R(2  ) = DO*THN - THETA
        A(2,1) = DO*THN_DO + THN
        A(2,2) = DO*THN_BB
        A(2,3) = DO*THN_TT
        Z(2,1) = DO*THN_HK
        Z(2,2) = DO*THN_TH - 1.0
        Z(2,3) = DO*THN_UO
        Z(2,4) = DO*THN_RT
        Z(2,5) = DO*THN_MS
C
        ADL    = 0.5*LOG(1.0 + AD**2)/AD
        ADL_AD =    1.0/(1.0 + AD**2) - ADL/AD
C
        ADL_DO = ADL_AD*AD_DO
        ADL_TT = ADL_AD*AD_TT
        ADL_HK = ADL_AD*AD_HK
        ADL_TH = ADL_AD*AD_TH
        ADL_UO = ADL_AD*AD_UO
        ADL_RT = ADL_AD*AD_RT
        ADL_MS = ADL_AD*AD_MS
C
        DK = 2.0/(BB+1.0) - 1.0/(2.0*BB+1.0)
        DK_BB = -2.0/(BB+1.0)**2 + 2.0/(2.0*BB+1.0)**2
C
        TC    = (UI   /HPI)*(ADT    - ADL   ) + DUO   *DK
        TC_BB =                                 DUO   *DK_BB
        TC_DO = (UI_DO/HPI)*(ADT    - ADL   ) + DUO_DO*DK
     &        + (UI   /HPI)*(ADT_DO - ADL_DO)
        TC_TT = (UI_TT/HPI)*(ADT    - ADL   ) + DUO_TT*DK
     &        + (UI   /HPI)*(ADT_TT - ADL_TT)
        TC_HK = (UI_HK/HPI)*(ADT    - ADL   ) + DUO_HK*DK
     &        + (UI   /HPI)*(ADT_HK - ADL_HK)
        TC_TH = (UI_TH/HPI)*(ADT    - ADL   ) + DUO_TH*DK
     &        + (UI   /HPI)*(ADT_TH - ADL_TH)
        TC_UO = (UI_UO/HPI)*(ADT    - ADL   ) + DUO_UO*DK
     &        + (UI   /HPI)*(ADT_UO - ADL_UO)
        TC_RT = (UI_RT/HPI)*(ADT    - ADL   ) + DUO_RT*DK
     &        + (UI   /HPI)*(ADT_RT - ADL_RT)
        TC_MS = (UI_MS/HPI)*(ADT    - ADL   ) + DUO_MS*DK
     &        + (UI   /HPI)*(ADT_MS - ADL_MS)
C
        R(3  ) = (1.0-UO)*DO*TC    + TT - THETA
        A(3,1) = (1.0-UO)*DO*TC_DO + (1.0-UO)*TC
        A(3,2) = (1.0-UO)*DO*TC_BB
        A(3,3) = (1.0-UO)*DO*TC_TT + 1.0
        Z(3,1) = (1.0-UO)*DO*TC_HK
        Z(3,2) = (1.0-UO)*DO*TC_TH      - 1.0
        Z(3,3) = (1.0-UO)*DO*TC_UO - DO*TC
        Z(3,4) = (1.0-UO)*DO*TC_RT
        Z(3,5) = (1.0-UO)*DO*TC_MS
C
        RSQ = (R(1)/THETA)**2 + (R(2)/THETA)**2 + (R(3)/THETA)**2
        IF(RSQ .LT. 1.0E-9) GO TO 1010
C
ccc        CALL GAUSSN(3,3,A,R,1)
C
        DDO = -R(1)
        DBB = -R(2)
        DTT = -R(3)
C
        DMAX = MAX( ABS(DDO/DO) , ABS(DBB/BB) , ABS(DTT/TT) )
        RLX = 1.0
        IF(DMAX.GT.0.5) RLX = 0.5/DMAX
C
        DO = DO + RLX*DDO
        BB = BB + RLX*DBB
        TT = TT + RLX*DTT
c
ccc        if(iter.gt.8) write(*,*) iter, do,bb,tt, sqrt(rsq)
C
 1000 CONTINUE
C
      WRITE(*,*) 'PRWALL: Convergence failed. Res =', SQRT(RSQ)
      LCONV = .FALSE.
      RETURN
C
 1010 CONTINUE
C
C
C---- get DO, BB, TT responses per unit DS, TH, UO, RT, MS changes
ccc      CALL GAUSSN(3,3,A,Z,5)
C
      DO_HK = -Z(1,1)
      DO_TH = -Z(1,2)
      DO_UO = -Z(1,3)
      DO_RT = -Z(1,4)
      DO_MS = -Z(1,5)
C
      BB_HK = -Z(2,1)
      BB_TH = -Z(2,2)
      BB_UO = -Z(2,3)
      BB_RT = -Z(2,4)
      BB_MS = -Z(2,5)
C
      TT_HK = -Z(3,1)
      TT_TH = -Z(3,2)
      TT_UO = -Z(3,3)
      TT_RT = -Z(3,4)
      TT_MS = -Z(3,5)
C
C---- set final UI sensitivities
      UI_HK = UI_HK + UI_DO*DO_HK + UI_TT*TT_HK
      UI_TH = UI_TH + UI_DO*DO_TH + UI_TT*TT_TH
      UI_UO = UI_UO + UI_DO*DO_UO + UI_TT*TT_UO
      UI_RT = UI_RT + UI_DO*DO_RT + UI_TT*TT_RT
      UI_MS = UI_MS + UI_DO*DO_MS + UI_TT*TT_MS
C
C---- set final CF sensitivities
      CF_HK = CF_HK + CF_DO*DO_HK + CF_TT*TT_HK
      CF_TH = CF_TH + CF_DO*DO_TH + CF_TT*TT_TH
      CF_UO = CF_UO + CF_DO*DO_UO + CF_TT*TT_UO
      CF_RT = CF_RT + CF_DO*DO_RT + CF_TT*TT_RT
      CF_MS = CF_MS + CF_DO*DO_MS + CF_TT*TT_MS
C
C---- set HS and linearize it
      HS      = TSN/THN
      HS_THN =  -HS/THN
      HS_TSN =  1.0/THN
C
      HS_DO = HS_THN*THN_DO + HS_TSN*TSN_DO
      HS_BB = HS_THN*THN_BB + HS_TSN*TSN_BB
      HS_TT = HS_THN*THN_TT + HS_TSN*TSN_TT
      HS_HK = HS_THN*THN_HK + HS_TSN*TSN_HK
      HS_TH = HS_THN*THN_TH + HS_TSN*TSN_TH
      HS_UO = HS_THN*THN_UO + HS_TSN*TSN_UO
      HS_RT = HS_THN*THN_RT + HS_TSN*TSN_RT
      HS_MS = HS_THN*THN_MS + HS_TSN*TSN_MS
C
      HS_HK = HS_HK + HS_DO*DO_HK + HS_BB*BB_HK + HS_TT*TT_HK
      HS_TH = HS_TH + HS_DO*DO_TH + HS_BB*BB_TH + HS_TT*TT_TH
      HS_UO = HS_UO + HS_DO*DO_UO + HS_BB*BB_UO + HS_TT*TT_UO
      HS_RT = HS_RT + HS_DO*DO_RT + HS_BB*BB_RT + HS_TT*TT_RT
      HS_MS = HS_MS + HS_DO*DO_MS + HS_BB*BB_MS + HS_TT*TT_MS
C
C---- set and linearize Cd
      CD = 0.0
      CD_HK = 0.0
      CD_TH = 0.0
      CD_UO = 0.0
      CD_RT = 0.0
      CD_MS = 0.0
      CD_CT = 0.0
C
C---- add on dependent sensitivity contributions
      CD_DO = 0.0
      CD_BB = 0.0
      CD_TT = 0.0
C
      CD_HK = CD_HK + CD_DO*DO_HK + CD_BB*BB_HK + CD_TT*TT_HK
      CD_TH = CD_TH + CD_DO*DO_TH + CD_BB*BB_TH + CD_TT*TT_TH
      CD_UO = CD_UO + CD_DO*DO_UO + CD_BB*BB_UO + CD_TT*TT_UO
      CD_RT = CD_RT + CD_DO*DO_RT + CD_BB*BB_RT + CD_TT*TT_RT
      CD_MS = CD_MS + CD_DO*DO_MS + CD_BB*BB_MS + CD_TT*TT_MS
C
      RETURN
      END ! PRWALL


