C
      SUBROUTINE PRWALL(DSTAR,THETA,UO,RT,MS,CT, BB,
     &                  DO, DO_DS, DO_TH, DO_UO, DO_RT, DO_MS,
     &                  UI, UI_DS, UI_TH, UI_UO, UI_RT, UI_MS,
     &                  HS, HS_DS, HS_TH, HS_UO, HS_RT, HS_MS,
     &                  CF, CF_DS, CF_TH, CF_UO, CF_RT, CF_MS,
     &                  CD, CD_DS, CD_TH, CD_UO, CD_RT, CD_MS, CD_CT )
      IMPLICIT REAL (A-H,M,O-Z)
C================================================================
C     Returns wall slip velocity and thickness of wall BL profile
C
C     Input:
C        DSTAR  kinematic displacement thickness
C        THETA  kinematic momentum thickness
C        RT     momentum thickness based on ue and THETA
C        MS     Mach^2 based on ue
C
C        UO     uo/ue outer velocity;  assumed = 1  in this version
C
C     Output:
C        BB     outer profile exponent
C        DO     thickness of profile deck
C        UI     inner "slip" velocity
C        CF     wall skin friction
C================================================================
C
      PARAMETER (N=65)
      DIMENSION ETA(N), UIP(N), UIP_DP(N), G(N), G_BB(N)
C
C---- pi/2 ,  2/pi
      DATA HPI, TOPI / 1.570796327 , 0.6366197723 /
C
      DATA T, SQT / 0.28 , 0.5291502622 /
C
C---- TCON = ( atan(T^1/2) / T^1/2  -  1/(1+T)) / (2T)  +  0.5/(1.0 + T) 
C                - atan(1/T^1/2) / 2T^1/2
      DATA TCON / -0.3864027035 /
C       
C---- slip velocity coefficient
      DATA AK / 0.09 /
C
C---- log-law constants
      DATA VKAP, VB / 0.40 , 5.0 /
C
      HK = DSTAR/THETA
C
      UO = 1.0
      BB = 1.0
C
C---- initialize variables
      CALL CFT(HK,RT,MS,CF,CF_HK,CF_RT,CF_MS)
      SGN = SIGN( 1.0 , CF )
      UT = SGN * SQRT(0.5*ABS(CF))
C
      UI = MIN( UT/AK * HPI , 0.90 )
      DO = HK*THETA / (1.0 - 0.5*(UO+UI))
C
      EBK = EXP(-VB*VKAP)
C
      DO 1000 ITER=1, 12
C
        SGN = SIGN( 1.0 , UT )
C
C------ set d+ = DP(UT DO ; RT TH)
        DP    = SGN * UT*RT*DO/THETA
        DP_DO = SGN * UT*RT   /THETA
        DP_UT = SGN *    RT*DO/THETA
C
        DP_TH = -DP/THETA
        DP_RT = SGN * UT   *DO/THETA
        DP_MS = 0.0
C
C------ estimate inner profile edge velocity Ui+ using log-law
        UPE = LOG(DP)/VKAP + VB
C
C------ converge exact Ui+ using Spalding formula
        DO 10 ITUP=1, 5
          UK = UPE*VKAP
          ARG = UK - VB*VKAP
          EXU = EXP(ARG)
          REZ  = UPE +  EXU - EBK*(1.0 + UK + UK*UK/2.0 + UK*UK*UK/6.0)
     &         - DP
          DP_U = 1.0 + (EXU - EBK*(1.0 + UK + UK*UK/2.0))*VKAP
C
          IF(ABS(REZ/DP) .LT. 1.0E-5) GO TO 11
C
          DUPE = -REZ/DP_U
          UPE = UPE + DUPE
 10     CONTINUE
        WRITE(*,*) 'PRWALL: Ue+ convergence failed,  Res =', REZ/DP
 11     CONTINUE
C
        UPE_DP = 1.0/DP_U
C
C            2      2        3      3
C------ set d y+/du+   and  d y+/du+   at BL edge
        DP_UU  = (EXU - EBK*(1.0 + UK))*VKAP**2
        DP_UUU = (EXU - EBK           )*VKAP**3
C
C------ set  du+/dy+  at BL edge
        UPD    = 1.0/DP_U
        UPD_DP = (-1.0/DP_U**3) * DP_UU
C
C             2      2
C------ set  d u+/dy+   at BL edge
CCC     UPD_DP = (-1.0/DP_U**3) * DP_UU
        UPDD    = UPD_DP
        UPDD_DP = (-1.0/DP_U**4) * DP_UUU
     &          + ( 3.0/DP_U**5) * DP_UU**2
C
C------ set coefficients for Spalding profile correction polynomial
        DC2    = 0.5*DP*DP*UPDD    - DP*UPD
        DC2_DP =        DP*UPDD    -    UPD
     &         + 0.5*DP*DP*UPDD_DP - DP*UPD_DP
C
        DC3    = -(  DP*DP*UPDD    - DP*UPD   ) / 3.0
        DC3_DP = -(2.0 *DP*UPDD    -    UPD   ) / 3.0
     &           -(  DP*DP*UPDD_DP - DP*UPD_DP) / 3.0
C
C------ set outer profile amplitude DUO
        DUO    = UO - UT*(UPE    + DC2    + DC3   )
        DUO_DP =    - UT*(UPE_DP + DC2_DP + DC3_DP)
C
        DUO_UT =    -    (UPE    + DC2    + DC3   )
     &         + DUO_DP*DP_UT
        DUO_DO = DUO_DP*DP_DO
C
        DUO_TH = DUO_DP*DP_TH
        DUO_RT = DUO_DP*DP_RT
        DUO_MS = DUO_DP*DP_MS
c
c        write(*,*) 'dUo', duo, duo_dp, duo_ut, duo_do
c        read(*,*) ddo, dut
c        if(ddo.ne.0.0 .or. dut.ne.0.0) then
c          do = do+ddo
c          ut = ut+dut
c          write(*,*) 'new', duo + duo_do*ddo + duo_ut*dut
c          go to 666
c        endif
C
C------ set wake profile coefficients
        BB1    =  3.0*(BB    +2.0)*(BB+3.0)/(BB+7.0)
        BB1_BB =  3.0*(BB*2.0+5.0         )/(BB+7.0) - BB1/(BB+7.0)
        BB2    = -5.0*(BB    +1.0)*(BB+3.0)/(BB+7.0)
        BB2_BB = -5.0*(BB*2.0+4.0         )/(BB+7.0) - BB2/(BB+7.0)
        BB3    =  2.0*(BB    +1.0)*(BB+2.0)/(BB+7.0)
        BB3_BB =  2.0*(BB*2.0+3.0         )/(BB+7.0) - BB3/(BB+7.0)
C
C------ fill eta coordinate and inner profile arrays
CCC     EXUPE = EXP(UPE*VKAP - VB*VKAP)
        EXUPE = EXU
C
        DEXU = (EXUPE - EBK)/FLOAT(N-1)
C
        I = 1
        UIP(I)    = 0.0
        UIP_DP(I) = 0.0
        G(I)    = 0.0
        G_BB(I) = 0.0
C
        DO 20 I=2, N
ccc       EXU = EBK + DEXU*FLOAT(I-1)
          EXU = EBK + (DEXU - 0.75*DEXU*FLOAT(N-I)/FLOAT(N-1))
     &                *FLOAT(I-1)
C
CCC       UK = UP*VKAP
          UK = LOG(EXU) + VB*VKAP
C
          UP = UK/VKAP
C
C-------- set "inverse" Spalding profile  y+(u+)  and derivatives
          YP    =  UP +  EXU - EBK*(1.0 + UK + UK*UK/2.0 + UK*UK*UK/6.0)
          YP_U  = 1.0 + (EXU - EBK*(1.0 + UK + UK*UK/2.0))*VKAP
          YP_UU =       (EXU - EBK*(1.0 + UK            ))*VKAP**2
C
          ET = YP/DP
C
C-------- set final inner profile (fudged Spalding)
          UIP(I)     = UP       +     DC2   *ET**2 +     DC3   *ET**3
          UIP_DP(I)  =                DC2_DP*ET**2 +     DC3_DP*ET**3
C
ccc          UIPD(I)    = 1.0/YP_U + 2.0*DC2   *ET    + 3.0*DC3   *ET**2
ccc          UIPD_DP(I) = (-1.0/YP_U**3)*YPUU
ccc     &                          + 2.0*DC2_DP*ET    + 3.0*DC3_DP*ET**2
C
C-------- set outer profile
          ETB = ET**BB
          ALE = LOG(ET)
C
ccc          G(I)    =  2.0*ETB -     ETB**2
ccc          G_BB(I) = (2.0*ETB - 2.0*ETB**2)*ALE
C
          G(I)    = (BB1   *ET + BB2   *ET**2 + BB3   *ET**3)*ETB
          G_BB(I) = (BB1_BB*ET + BB2_BB*ET**2 + BB3_BB*ET**3)*ETB
     &            + G(I)*ALE
C
          ETA(I) = ET
C
 20     CONTINUE
C
C
        DSN    = 0.0
        DSN_DO = 0.0
        DSN_UT = 0.0
        DSN_BB = 0.0
C
        DSN_TH = 0.0
        DSN_RT = 0.0
        DSN_MS = 0.0
C
C
        THN    = 0.0
        THN_DO = 0.0
        THN_UT = 0.0
        THN_BB = 0.0
C
        THN_TH = 0.0
        THN_RT = 0.0
        THN_MS = 0.0
C
c        TSN    = 0.0
c        TSN_DO = 0.0
c        TSN_UT = 0.0
c        TSN_BB = 0.0
c
c        TSN_TH = 0.0
c        TSN_RT = 0.0
c        TSN_MS = 0.0
C
C------ perform integration
        DO 100 I=1, N-1
          DETA = ETA(I+1) - ETA(I)
          GA    = 0.5*(G(I+1)    + G(I)   )
          GA_BB = 0.5*(G_BB(I+1) + G_BB(I))
C
          UIPA    = 0.5*(UIP(I+1)    + UIP(I)   )
          UIPA_DP = 0.5*(UIP_DP(I+1) + UIP_DP(I))
C
          U    = UT*UIPA    + DUO   *GA
          U_DP = UT*UIPA_DP
C
          U_DO =              DUO_DO*GA + U_DP*DP_DO
          U_UT =    UIPA    + DUO_UT*GA + U_DP*DP_UT
          U_BB =              DUO   *GA_BB
C
          U_TH =              DUO_TH*GA + U_DP*DP_TH
          U_RT =              DUO_RT*GA + U_DP*DP_RT
          U_MS =              DUO_MS*GA + U_DP*DP_MS
C
C
          DSN    = DSN    + (1.0 - U   )*DETA
          DSN_DO = DSN_DO -        U_DO *DETA
          DSN_UT = DSN_UT -        U_UT *DETA
          DSN_BB = DSN_BB -        U_BB *DETA
C
          DSN_TH = DSN_TH -        U_TH *DETA
          DSN_RT = DSN_RT -        U_RT *DETA
          DSN_MS = DSN_MS -        U_MS *DETA
C
C
          THN    = THN    + (U   -   U*U)     *DETA
          THN_DO = THN_DO + (1.0 - 2.0*U)*U_DO*DETA
          THN_UT = THN_UT + (1.0 - 2.0*U)*U_UT*DETA
          THN_BB = THN_BB + (1.0 - 2.0*U)*U_BB*DETA
C
          THN_TH = THN_TH + (1.0 - 2.0*U)*U_TH*DETA
          THN_RT = THN_RT + (1.0 - 2.0*U)*U_RT*DETA
          THN_MS = THN_MS + (1.0 - 2.0*U)*U_MS*DETA
C
c          TSN    = TSN    + (U   -   U*U*U)     *DETA
c          TSN_DO = TSN_DO + (1.0 - 3.0*U*U)*U_DO*DETA
c          TSN_UT = TSN_UT + (1.0 - 3.0*U*U)*U_UT*DETA
c          TSN_BB = TSN_BB + (1.0 - 3.0*U*U)*U_BB*DETA
C
c          TSN_TH = TSN_TH + (1.0 - 3.0*U*U)*U_TH*DETA
c          TSN_RT = TSN_RT + (1.0 - 3.0*U*U)*U_RT*DETA
c          TSN_MS = TSN_MS + (1.0 - 3.0*U*U)*U_MS*DETA
C
 100    CONTINUE
C
C------ set up 2x2 system for DO UT
        REZ1 = DO*DSN    - THETA*HK
        A11  = DO*DSN_DO + DSN
        A12  = DO*DSN_UT
cc        A12  = DO*DSN_BB
C
        REZ2 = DO*THN    - THETA
        A21  = DO*THN_DO + THN
        A22  = DO*THN_UT
cc        A22  = DO*THN_BB
C
cc      IF(ABS(REZ1/THETA) .LT. 2.0E-5 .AND.
cc   &     ABS(REZ2/THETA) .LT. 2.0E-5      ) GO TO 1010
        IF(ABS(REZ1/THETA) .LT. 1.0E-3 .AND.
     &     ABS(REZ2/THETA) .LT. 1.0E-3      ) GO TO 1010
C
        DET = A11*A22 - A12*A21
        B11 =  A22/DET
        B12 = -A12/DET
        B21 = -A21/DET
        B22 =  A11/DET
C
        DDO = -(B11*REZ1 + B12*REZ2)
        DUT = -(B21*REZ1 + B22*REZ2)
cc        DBB = -(B21*REZ1 + B22*REZ2)
C
        DMAX = MAX( ABS(DDO/DO) , ABS(DUT/0.05) )
cc        DMAX = MAX( ABS(DDO/DO) , ABS(DBB/BB  ) )
        RLX = 1.0
        IF(DMAX.GT.0.5) RLX = 0.5/DMAX
C
        DO = DO + RLX*DDO
        UT = UT + RLX*DUT
cc        BB = BB + RLX*DBB
c
cc        write(*,*) iter, do, ut, rez1, rez2
cc        write(*,*) iter, do, bb, rez1, rez2
C
 1000 CONTINUE
C
      WRITE(*,*) 'PRWALL: Convergence failed. Res =', REZ1, REZ2
C
 1010 CONTINUE
C
C
C
CCC   REZ1  = DO*DSN    - THETA*HK
      Z1_HK =           - THETA
      Z1_TH = DO*DSN_TH -       HK
      Z1_RT = DO*DSN_RT
      Z1_MS = DO*DSN_MS
C
CCC   REZ2  = DO*THN    - THETA
      Z2_HK = 0.0
      Z2_TH = DO*THN_TH - 1.0
      Z2_RT = DO*THN_RT
      Z2_MS = DO*THN_MS
C
      DO_HK = -(B11*Z1_HK + B12*Z2_HK)
      DO_TH = -(B11*Z1_TH + B12*Z2_TH)
      DO_RT = -(B11*Z1_RT + B12*Z2_RT)
      DO_MS = -(B11*Z1_MS + B12*Z2_MS)
C
      UT_HK = 0.0
      UT_TH = 0.0
      UT_RT = 0.0
      UT_MS = 0.0
C
      BB_HK = 0.0
      BB_TH = 0.0
      BB_RT = 0.0
      BB_MS = 0.0
C
      UT_HK = -(B21*Z1_HK + B22*Z2_HK)
      UT_TH = -(B21*Z1_TH + B22*Z2_TH)
      UT_RT = -(B21*Z1_RT + B22*Z2_RT)
      UT_MS = -(B21*Z1_MS + B22*Z2_MS)
C
cc      BB_HK = -(B21*Z1_HK + B22*Z2_HK)
cc      BB_TH = -(B21*Z1_TH + B22*Z2_TH)
cc      BB_RT = -(B21*Z1_RT + B22*Z2_RT)
cc      BB_MS = -(B21*Z1_MS + B22*Z2_MS)
C
C
C---- set and linearize Cf
      CF    = SGN*2.0*UT**2
      CF_UT = SGN*4.0*UT
      CF_DO = 0.0
C
      CF_HK = CF_UT*UT_HK + CF_DO*DO_HK
      CF_TH = CF_UT*UT_TH + CF_DO*DO_TH
      CF_RT = CF_UT*UT_RT + CF_DO*DO_RT
      CF_MS = CF_UT*UT_MS + CF_DO*DO_MS
C
C
C---- set and linearize "slip" velocity UI = UI( DUO(DO UT TH RT MS) )
      UI    = UO - DUO
      UI_UT =    - DUO_UT
      UI_DO =    - DUO_DO
C
      UI_HK = UI_UT*UT_HK + UI_DO*DO_HK
      UI_TH = UI_UT*UT_TH + UI_DO*DO_TH - DUO_TH
      UI_RT = UI_UT*UT_RT + UI_DO*DO_RT - DUO_RT
      UI_MS = UI_UT*UT_MS + UI_DO*DO_MS - DUO_MS
C
      RETURN
      END ! PRWALL




      SUBROUTINE PRWALL0(DSTAR,THETA,UO,RT,MS,CT, BB,
     &                  DO, DO_DS, DO_TH, DO_UO, DO_RT, DO_MS,
     &                  UI, UI_DS, UI_TH, UI_UO, UI_RT, UI_MS,
     &                  HS, HS_DS, HS_TH, HS_UO, HS_RT, HS_MS,
     &                  CF, CF_DS, CF_TH, CF_UO, CF_RT, CF_MS,
     &                  CD, CD_DS, CD_TH, CD_UO, CD_RT, CD_MS, CD_CT )
      IMPLICIT REAL (A-H,M,O-Z)
C================================================================
C     Returns wall slip velocity and thickness of wall BL profile,
C     and all derived integral quantities and sensitivities.
C
C     Input:
C        DSTAR  kinematic displacement thickness of profile deck
C        THETA  kinematic momentum thickness of profile deck
C        UO     uo/ue outer velocity
C        RT     momentum thickness based on ue and THETA
C        MS     Mach^2 based on ue
C        CT     sqrt(max. shear coefficient) in outer layer
C
C     Output:
C        BB     outer profile exponent
C        DO     thickness of profile deck
C        UI     inner "slip" velocity
C        HS     KE thickness shape parameter
C        CF     wall skin friction
C        CD     dissipation coefficient
C================================================================
C
      DIMENSION ETAE(4)
      DIMENSION A(3,3), Z(3,5), R(3)
C
      DIMENSION WGHT(0:16)
C
C---- set pi/2 , number of integration intervals
      DATA HPI , N  / 1.570796327 ,  16 /
C
C---- set weights for Simpson's rule
      DATA WGHT / 1.0, 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 2.0, 
     &                 4.0, 1.0/
C
C---- maximum g' =  9 / 4^(4/3)
      DATA GDX / 1.417411182 /
C
C---- inner shear profile decay constant
      DATA RKTAUI / 8.0 /
C
C---- slip velocity coefficient
      DATA AK / 0.09 /
C
C---- initialize variables
ccc      IF(UI.EQ.0.0) UI = 0.5*UO
ccc      IF(DO.EQ.0.0) DO = DSTAR / (1.0 - 0.5*(UO+UI))
      UI = 0.5*UO
      DO = DSTAR / (1.0 - 0.5*(UO+UI))
C
      DT = DSTAR - (1.0-UO)*DO
      TT = THETA - (1.0-UO)*DO*(UI + 0.5*(UO-UI))
C
      HKT = DT/TT
      RTT = RT*UO*TT/THETA
      MST = MS
      CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
      UT = UO * SQRT(0.5*ABS(CFB))
C
      BB = 1.5
C
      DETA = 1.0/FLOAT(N)
C
      DO 1000 ITER=1, 12
C
        DT    = DSTAR - (1.0-UO)*DO
        DT_DO =       - (1.0-UO)
C
        DT_DS = 1.0
        DT_UO =                  DO
C
C----------------
        HKT    = DT   /TT
        HKT_DO = DT_DO/TT
        HKT_TT =  -HKT/TT
C
        HKT_DS = DT_DS/TT
        HKT_UO = DT_UO/TT
C
C----------------
        RTT    = RT*UO*TT/THETA
        RTT_TT = RT*UO   /THETA
C
        RTT_TH =     -RTT/THETA
        RTT_UO = RT   *TT/THETA
        RTT_RT =    UO*TT/THETA
C
C----------------
        MST = MS*UO**2
C
        MST_UO = MS*2.0*UO
        MST_MS = UO**2
C
C----------------
        CALL CFT(HKT,RTT,MST,CFB,CFB_HKT,CFB_RTT,CFB_MST)
C
        CF     = UO**2 * CFB
C
        CF_HKT = UO**2 * CFB_HKT
        CF_RTT = UO**2 * CFB_RTT
        CF_MST = UO**2 * CFB_MST
C
        CF_DO = CF_HKT*HKT_DO
        CF_TT = CF_HKT*HKT_TT + CF_RTT*RTT_TT
        CF_DS = CF_HKT*HKT_DS
        CF_TH =                 CF_RTT*RTT_TH
        CF_UO = CF_HKT*HKT_UO + CF_RTT*RTT_UO + CF_MST*MST_UO
     &        + 2.0*UO * CFB
        CF_RT =                 CF_RTT*RTT_RT
        CF_MS =                                 CF_MST*MST_MS
C
C
        S = SIGN( 1.0 , CFB )
        UT     = UO       *SQRT(0.5*S*CFB)
        UT_CFB = UO*0.25*S/SQRT(0.5*S*CFB)
C
        UT_DO = UT_CFB*(CFB_HKT*HKT_DO                 )
        UT_TT = UT_CFB*(CFB_HKT*HKT_TT + CFB_RTT*RTT_TT)
C
        UT_DS = UT_CFB*(CFB_HKT*HKT_DS                 )
        UT_TH = UT_CFB*(                 CFB_RTT*RTT_TH)
        UT_UO = UT_CFB*(CFB_HKT*HKT_UO + CFB_RTT*RTT_UO)
        UT_RT = UT_CFB*(                 CFB_RTT*RTT_RT)
        UT_MS = UT_CFB*(CFB_MST*MST_MS)
C
C---------------
c        UI    = (S*HPI/AK)*UT   
c        UI_DO = (S*HPI/AK)*UT_DO
c        UI_TT = (S*HPI/AK)*UT_TT
cC
c        UI_DS = (S*HPI/AK)*UT_DS
c        UI_TH = (S*HPI/AK)*UT_TH
c        UI_UO = (S*HPI/AK)*UT_UO
c        UI_RT = (S*HPI/AK)*UT_RT
c        UI_MS = (S*HPI/AK)*UT_MS
C
        FU = S*HPI/AK
        UI    = TANH(FU*UT)
        UI_UT = (1.0 - UI**2)*FU
C
        UI_DO = UI_UT*UT_DO
        UI_TT = UI_UT*UT_TT
C
        UI_DS = UI_UT*UT_DS
        UI_TH = UI_UT*UT_TH
        UI_UO = UI_UT*UT_UO
        UI_RT = UI_UT*UT_RT
        UI_MS = UI_UT*UT_MS
C
C--------------- 
        AD    = AK*RT*UT   *DO/THETA
        AD_DO = AK*RT*UT      /THETA
     &        + AK*RT*UT_DO*DO/THETA
        AD_TT = AK*RT*UT_TT*DO/THETA
C
        AD_DS = AK*RT*UT_DS*DO/THETA
        AD_TH = AK*RT*UT_TH*DO/THETA
     &                    - AD/THETA
        AD_UO = AK*RT*UT_UO*DO/THETA
        AD_RT = AK*RT*UT_RT*DO/THETA
     &        + AK   *UT   *DO/THETA
        AD_MS = AK*RT*UT_MS*DO/THETA
C
C--------------
        ADT = ATAN(AD)
        ADINV = 1.0/(1.0 + AD**2)
C
        ADT_DO = AD_DO*ADINV
        ADT_TT = AD_TT*ADINV
C
        ADT_DS = AD_DS*ADINV
        ADT_TH = AD_TH*ADINV
        ADT_UO = AD_UO*ADINV
        ADT_RT = AD_RT*ADINV
        ADT_MS = AD_MS*ADINV
C
C--------------
        DUO    = UO  - (UI   /HPI)*ADT
        DUO_DO =     - (UI_DO/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TT =     - (UI_TT/HPI)*ADT - (UI/HPI)*ADT_TT
C
        DUO_DS =     - (UI_DS/HPI)*ADT - (UI/HPI)*ADT_DO
        DUO_TH =     - (UI_TH/HPI)*ADT - (UI/HPI)*ADT_TH
        DUO_UO = 1.0 - (UI_UO/HPI)*ADT - (UI/HPI)*ADT_UO
        DUO_RT =     - (UI_RT/HPI)*ADT - (UI/HPI)*ADT_RT
        DUO_MS =     - (UI_MS/HPI)*ADT - (UI/HPI)*ADT_MS
C
C--------------
        ETAB    = (BB-1.0)/(2.0*BB-1.0)
        ETAB_BB =     1.0 /(2.0*BB-1.0)**2
        IF(ETAB.LE.0.0) THEN
         ETAB    = 0.0
         ETAB_BB = 0.0
         ETA    = 0.0
         ETA_BB = 0.0
         GDX    = 1.417
         GDX_BB = 0.0
        ELSE
         ETA    = ETAB**(1.0/BB)
         ETA_BB = ETA*(ETAB_BB/(BB*ETAB) - LOG(ETAB)/BB**2)
         GDX    = 2.0*BB*(ETAB - ETAB**2 )/ETA
         GDX_BB = 2.0*   (ETAB - ETAB**2 )/ETA
     &          + 2.0*BB*(1.0  - ETAB*2.0)*ETAB_BB/ETA
     &          - (GDX/ETA)*ETA_BB
        ENDIF
C
C------ set integration limits
        ETAE(1) = 0.0
        ETAE(2) = MIN(  5.0/AD , 1.0 )
        ETAE(3) = MIN( 50.0/AD , 1.0 )
        ETAE(4) = 1.0
C
ccc        write(*,*) iter, (etae(k),k=1, 4)
C
        DSN = 0.0
        DSN_DO = 0.0
        DSN_BB = 0.0
        DSN_TT = 0.0
        DSN_DS = 0.0
        DSN_TH = 0.0
        DSN_UO = 0.0
        DSN_RT = 0.0
        DSN_MS = 0.0
C
        THN = 0.0
        THN_DO = 0.0
        THN_BB = 0.0
        THN_TT = 0.0
        THN_DS = 0.0
        THN_TH = 0.0
        THN_UO = 0.0
        THN_RT = 0.0
        THN_MS = 0.0
C
        TSN = 0.0
        TSN_DO = 0.0
        TSN_BB = 0.0
        TSN_TT = 0.0
        TSN_DS = 0.0
        TSN_TH = 0.0
        TSN_UO = 0.0
        TSN_RT = 0.0
        TSN_MS = 0.0
C
        CD = 0.0
        CD_DO = 0.0
        CD_BB = 0.0
        CD_TT = 0.0
        CD_DS = 0.0
        CD_TH = 0.0
        CD_UO = 0.0
        CD_RT = 0.0
        CD_MS = 0.0
C
C------ do integration in three parts
        DO 100 IPASS=1, 3
          DETA = (ETAE(IPASS+1) - ETAE(IPASS)) / FLOAT(N)
C
          DSUM = 0.0
          D_DO = 0.0
          D_BB = 0.0
          D_TT = 0.0
          D_DS = 0.0
          D_TH = 0.0
          D_UO = 0.0
          D_RT = 0.0
          D_MS = 0.0
C
          TSUM = 0.0
          T_DO = 0.0
          T_BB = 0.0
          T_TT = 0.0
          T_DS = 0.0
          T_TH = 0.0
          T_UO = 0.0
          T_RT = 0.0
          T_MS = 0.0
C
          SSUM = 0.0
          S_DO = 0.0
          S_BB = 0.0
          S_TT = 0.0
          S_DS = 0.0
          S_TH = 0.0
          S_UO = 0.0
          S_RT = 0.0
          S_MS = 0.0
C
          CSUM = 0.0
          C_DO = 0.0
          C_BB = 0.0
          C_TT = 0.0
          C_DS = 0.0
          C_TH = 0.0
          C_UO = 0.0
          C_RT = 0.0
          C_MS = 0.0
          C_CT = 0.0
C
          DO 10 I=0, N
            ETA = ETAE(IPASS) + DETA*FLOAT(I)
C
            ALE = 0.0
            IF(ETA.GT.0.0) ALE = LOG(ETA)
C
            ETABB = ETA**BB
            G    = 2.0* ETABB - ETABB**2
            G_BB = 2.0*(ETABB - ETABB**2)*ALE
C
            ETABM = 0.0
            IF(ETA.GT.0.0) ETABM = ETABB/ETA
            GD    = 2.0*BB*(ETABM -     ETABM*ETABB)
            GD_BB = 2.0*BB*(ETABM - 2.0*ETABM*ETABB)*ALE
     &            + 2.0*   (ETABM -     ETABM*ETABB)*ALE
C
            AY    = ETA*AD
            AY_DO = ETA*AD_DO
            AY_TT = ETA*AD_TT
            AY_DS = ETA*AD_DS
            AY_TH = ETA*AD_TH
            AY_UO = ETA*AD_UO
            AY_RT = ETA*AD_RT
            AY_MS = ETA*AD_MS
C
            AYT = ATAN(AY)
            AYINV = 1.0/(1.0 + AY**2)
            AYT_DO = AY_DO*AYINV
            AYT_TT = AY_TT*AYINV
            AYT_DS = AY_DS*AYINV
            AYT_TH = AY_TH*AYINV
            AYT_UO = AY_UO*AYINV
            AYT_RT = AY_RT*AYINV
            AYT_MS = AY_MS*AYINV
C
            U    = (UI   /HPI)*AYT + DUO   *G
            U_BB =                   DUO   *G_BB
            U_DO = (UI_DO/HPI)*AYT + DUO_DO*G + (UI/HPI)*AYT_DO
            U_TT = (UI_TT/HPI)*AYT + DUO_TT*G + (UI/HPI)*AYT_TT
            U_DS = (UI_DS/HPI)*AYT + DUO_DS*G + (UI/HPI)*AYT_DS
            U_TH = (UI_TH/HPI)*AYT + DUO_TH*G + (UI/HPI)*AYT_TH
            U_UO = (UI_UO/HPI)*AYT + DUO_UO*G + (UI/HPI)*AYT_UO
            U_RT = (UI_RT/HPI)*AYT + DUO_RT*G + (UI/HPI)*AYT_RT
            U_MS = (UI_MS/HPI)*AYT + DUO_MS*G + (UI/HPI)*AYT_MS
C
            ADAY    = AD*AYINV
            ADAY_AD = (1.0 - 2.0*ETA*AY*AYINV)*AYINV
            ADAY_DO = ADAY_AD*AD_DO
            ADAY_TT = ADAY_AD*AD_TT
            ADAY_DS = ADAY_AD*AD_DS
            ADAY_TH = ADAY_AD*AD_TH
            ADAY_UO = ADAY_AD*AD_UO
            ADAY_RT = ADAY_AD*AD_RT
            ADAY_MS = ADAY_AD*AD_MS
C
            UD    = (UI   /HPI)*ADAY + DUO   *GD
            UD_BB =                    DUO   *GD_BB
            UD_DO = (UI_DO/HPI)*ADAY + DUO_DO*GD + (UI/HPI)*ADAY_DO
            UD_TT = (UI_TT/HPI)*ADAY + DUO_TT*GD + (UI/HPI)*ADAY_TT
            UD_DS = (UI_DS/HPI)*ADAY + DUO_DS*GD + (UI/HPI)*ADAY_DS
            UD_TH = (UI_TH/HPI)*ADAY + DUO_TH*GD + (UI/HPI)*ADAY_TH
            UD_UO = (UI_UO/HPI)*ADAY + DUO_UO*GD + (UI/HPI)*ADAY_UO
            UD_RT = (UI_RT/HPI)*ADAY + DUO_RT*GD + (UI/HPI)*ADAY_RT
            UD_MS = (UI_MS/HPI)*ADAY + DUO_MS*GD + (UI/HPI)*ADAY_MS
C
            FI = EXP(-RKTAUI * ETA)
            TAU    = 0.5*CF   *FI + CT**2 * (GD/GDX)**2
            TAU_BB =                CT**2 * (GD/GDX)*2.0
     &                                    * (GD_BB - GDX_BB*GD/GDX)/GDX
            TAU_DO = 0.5*CF_DO*FI - 0.5*CF*AYT_DO/HPI
            TAU_TT = 0.5*CF_TT*FI - 0.5*CF*AYT_TT/HPI
            TAU_DS = 0.5*CF_DS*FI - 0.5*CF*AYT_DS/HPI
            TAU_TH = 0.5*CF_TH*FI - 0.5*CF*AYT_TH/HPI
            TAU_UO = 0.5*CF_UO*FI - 0.5*CF*AYT_UO/HPI
            TAU_RT = 0.5*CF_RT*FI - 0.5*CF*AYT_RT/HPI
            TAU_MS = 0.5*CF_MS*FI - 0.5*CF*AYT_MS/HPI
            TAU_CT = 2.0*CT * (GD/GDX)**2
C
            DSUM = DSUM + WGHT(I)*(1.0 - U)
            D_BB = D_BB - WGHT(I)*       U_BB
            D_DO = D_DO - WGHT(I)*       U_DO
            D_TT = D_TT - WGHT(I)*       U_TT
            D_DS = D_DS - WGHT(I)*       U_DS
            D_TH = D_TH - WGHT(I)*       U_TH
            D_UO = D_UO - WGHT(I)*       U_UO
            D_RT = D_RT - WGHT(I)*       U_RT
            D_MS = D_MS - WGHT(I)*       U_MS
C
            TSUM = TSUM + WGHT(I)*(U   -   U*U)
            T_BB = T_BB + WGHT(I)*(1.0 - 2.0*U)*U_BB
            T_DO = T_DO + WGHT(I)*(1.0 - 2.0*U)*U_DO
            T_TT = T_TT + WGHT(I)*(1.0 - 2.0*U)*U_TT
            T_DS = T_DS + WGHT(I)*(1.0 - 2.0*U)*U_DS
            T_TH = T_TH + WGHT(I)*(1.0 - 2.0*U)*U_TH
            T_UO = T_UO + WGHT(I)*(1.0 - 2.0*U)*U_UO
            T_RT = T_RT + WGHT(I)*(1.0 - 2.0*U)*U_RT
            T_MS = T_MS + WGHT(I)*(1.0 - 2.0*U)*U_MS
C
            SSUM = SSUM + WGHT(I)*(U   -   U*U*U)
            S_BB = S_BB + WGHT(I)*(1.0 - 3.0*U*U)*U_BB
            S_DO = S_DO + WGHT(I)*(1.0 - 3.0*U*U)*U_DO
            S_TT = S_TT + WGHT(I)*(1.0 - 3.0*U*U)*U_TT
            S_DS = S_DS + WGHT(I)*(1.0 - 3.0*U*U)*U_DS
            S_TH = S_TH + WGHT(I)*(1.0 - 3.0*U*U)*U_TH
            S_UO = S_UO + WGHT(I)*(1.0 - 3.0*U*U)*U_UO
            S_RT = S_RT + WGHT(I)*(1.0 - 3.0*U*U)*U_RT
            S_MS = S_MS + WGHT(I)*(1.0 - 3.0*U*U)*U_MS
C
            CSUM = CSUM + WGHT(I)* TAU   *GD
            C_BB = C_BB + WGHT(I)*(TAU_BB*GD + TAU*GD_BB)
            C_DO = C_DO + WGHT(I)* TAU_DO*GD
            C_TT = C_TT + WGHT(I)* TAU_TT*GD
            C_DS = C_DS + WGHT(I)* TAU_DS*GD
            C_TH = C_TH + WGHT(I)* TAU_TH*GD
            C_UO = C_UO + WGHT(I)* TAU_UO*GD
            C_RT = C_RT + WGHT(I)* TAU_RT*GD
            C_MS = C_MS + WGHT(I)* TAU_MS*GD
            C_CT = C_CT + WGHT(I)* TAU_CT*GD
C
   10     CONTINUE
C
          DSN    = DSN    + (DETA/3.0)*DSUM
          DSN_BB = DSN_BB + (DETA/3.0)*D_BB
          DSN_DO = DSN_DO + (DETA/3.0)*D_DO
          DSN_TT = DSN_TT + (DETA/3.0)*D_TT
          DSN_DS = DSN_DS + (DETA/3.0)*D_DS
          DSN_TH = DSN_TH + (DETA/3.0)*D_TH
          DSN_UO = DSN_UO + (DETA/3.0)*D_UO
          DSN_RT = DSN_RT + (DETA/3.0)*D_RT
          DSN_MS = DSN_MS + (DETA/3.0)*D_MS
C
          THN    = THN    + (DETA/3.0)*TSUM
          THN_BB = THN_BB + (DETA/3.0)*T_BB
          THN_DO = THN_DO + (DETA/3.0)*T_DO
          THN_TT = THN_TT + (DETA/3.0)*T_TT
          THN_DS = THN_DS + (DETA/3.0)*T_DS
          THN_TH = THN_TH + (DETA/3.0)*T_TH
          THN_UO = THN_UO + (DETA/3.0)*T_UO
          THN_RT = THN_RT + (DETA/3.0)*T_RT
          THN_MS = THN_MS + (DETA/3.0)*T_MS
C
          TSN    = TSN    + (DETA/3.0)*SSUM
          TSN_BB = TSN_BB + (DETA/3.0)*S_BB
          TSN_DO = TSN_DO + (DETA/3.0)*S_DO
          TSN_TT = TSN_TT + (DETA/3.0)*S_TT
          TSN_DS = TSN_DS + (DETA/3.0)*S_DS
          TSN_TH = TSN_TH + (DETA/3.0)*S_TH
          TSN_UO = TSN_UO + (DETA/3.0)*S_UO
          TSN_RT = TSN_RT + (DETA/3.0)*S_RT
          TSN_MS = TSN_MS + (DETA/3.0)*S_MS
C
          CD    = CD    + (DETA/3.0)*CSUM
          CD_BB = CD_BB + (DETA/3.0)*C_BB
          CD_DO = CD_DO + (DETA/3.0)*C_DO
          CD_TT = CD_TT + (DETA/3.0)*C_TT
          CD_DS = CD_DS + (DETA/3.0)*C_DS
          CD_TH = CD_TH + (DETA/3.0)*C_TH
          CD_UO = CD_UO + (DETA/3.0)*C_UO
          CD_RT = CD_RT + (DETA/3.0)*C_RT
          CD_MS = CD_MS + (DETA/3.0)*C_MS
          CD_CT = CD_CT + (DETA/3.0)*C_CT
C
  100   CONTINUE
C
C------ set up 3x3 system for DO BB TT
        R(1  ) = DO*DSN - DSTAR
        A(1,1) = DO*DSN_DO + DSN
        A(1,2) = DO*DSN_BB
        A(1,3) = DO*DSN_TT
        Z(1,1) = DO*DSN_DS - 1.0
        Z(1,2) = DO*DSN_TH
        Z(1,3) = DO*DSN_UO
        Z(1,4) = DO*DSN_RT
        Z(1,5) = DO*DSN_MS
C
        R(2  ) = DO*THN - THETA
        A(2,1) = DO*THN_DO + THN
        A(2,2) = DO*THN_BB
        A(2,3) = DO*THN_TT
        Z(2,1) = DO*THN_DS
        Z(2,2) = DO*THN_TH - 1.0
        Z(2,3) = DO*THN_UO
        Z(2,4) = DO*THN_RT
        Z(2,5) = DO*THN_MS
C
        ADL    = 0.5*LOG(1.0 + AD**2)/AD
        ADL_AD =     1.0/(1.0 + AD**2) - ADL/AD
C
        ADL_DO = ADL_AD*AD_DO
        ADL_TT = ADL_AD*AD_TT
        ADL_DS = ADL_AD*AD_DS
        ADL_TH = ADL_AD*AD_TH
        ADL_UO = ADL_AD*AD_UO
        ADL_RT = ADL_AD*AD_RT
        ADL_MS = ADL_AD*AD_MS
C
        DK = 2.0/(BB+1.0) - 1.0/(2.0*BB+1.0)
        DK_BB = -2.0/(BB+1.0)**2 + 2.0/(2.0*BB+1.0)**2
C
        TC    = (UI   /HPI)*(ADT    - ADL   ) + DUO   *DK
        TC_BB =                                 DUO   *DK_BB
        TC_DO = (UI_DO/HPI)*(ADT    - ADL   ) + DUO_DO*DK
     &        + (UI   /HPI)*(ADT_DO - ADL_DO)
        TC_TT = (UI_TT/HPI)*(ADT    - ADL   ) + DUO_TT*DK
     &        + (UI   /HPI)*(ADT_TT - ADL_TT)
        TC_DS = (UI_DS/HPI)*(ADT    - ADL   ) + DUO_DS*DK
     &        + (UI   /HPI)*(ADT_DS - ADL_DS)
        TC_TH = (UI_TH/HPI)*(ADT    - ADL   ) + DUO_TH*DK
     &        + (UI   /HPI)*(ADT_TH - ADL_TH)
        TC_UO = (UI_UO/HPI)*(ADT    - ADL   ) + DUO_UO*DK
     &        + (UI   /HPI)*(ADT_UO - ADL_UO)
        TC_RT = (UI_RT/HPI)*(ADT    - ADL   ) + DUO_RT*DK
     &        + (UI   /HPI)*(ADT_RT - ADL_RT)
        TC_MS = (UI_MS/HPI)*(ADT    - ADL   ) + DUO_MS*DK
     &        + (UI   /HPI)*(ADT_MS - ADL_MS)
C
        R(3  ) = (1.0-UO)*DO*TC    + TT - THETA
        A(3,1) = (1.0-UO)*DO*TC_DO + (1.0-UO)*TC
        A(3,2) = (1.0-UO)*DO*TC_BB
        A(3,3) = (1.0-UO)*DO*TC_TT + 1.0
        Z(3,1) = (1.0-UO)*DO*TC_DS
        Z(3,2) = (1.0-UO)*DO*TC_TH      - 1.0
        Z(3,3) = (1.0-UO)*DO*TC_UO - DO*TC
        Z(3,4) = (1.0-UO)*DO*TC_RT
        Z(3,5) = (1.0-UO)*DO*TC_MS
C
        RSQ = (R(1)/DSTAR)**2 + (R(2)/THETA)**2 + (R(3)/THETA)**2
        IF(RSQ .LT. 1.0E-9) GO TO 1010
C
        CALL GAUSSN(3,3,A,R,1)
C
        DDO = -R(1)
        DBB = -R(2)
        DTT = -R(3)
C
        DMAX = MAX( ABS(DDO/DO) , ABS(DBB/BB) , ABS(DTT/TT) )
        RLX = 1.0
        IF(DMAX.GT.0.5) RLX = 0.5/DMAX
C
        DO = DO + RLX*DDO
        BB = BB + RLX*DBB
        TT = TT + RLX*DTT
c
ccc        write(*,*) iter, do,bb,tt, sqrt(rsq)
C
 1000 CONTINUE
C
      WRITE(*,*) 'PRWALL: Convergence failed. Res =', SQRT(RSQ)
C
 1010 CONTINUE
C
C
C---- get DO, AK, TT responses per unit DS, TH, UO, RT, MS changes
      CALL GAUSSN(3,3,A,Z,5)
C
      DO_DS = -Z(1,1)
      DO_TH = -Z(1,2)
      DO_UO = -Z(1,3)
      DO_RT = -Z(1,4)
      DO_MS = -Z(1,5)
C
      BB_DS = -Z(2,1)
      BB_TH = -Z(2,2)
      BB_UO = -Z(2,3)
      BB_RT = -Z(2,4)
      BB_MS = -Z(2,5)
C
      TT_DS = -Z(3,1)
      TT_TH = -Z(3,2)
      TT_UO = -Z(3,3)
      TT_RT = -Z(3,4)
      TT_MS = -Z(3,5)
C
C---- set final UI sensitivities
      UI_DS = UI_DS + UI_DO*DO_DS + UI_TT*TT_DS
      UI_TH = UI_TH + UI_DO*DO_TH + UI_TT*TT_TH
      UI_UO = UI_UO + UI_DO*DO_UO + UI_TT*TT_UO
      UI_RT = UI_RT + UI_DO*DO_RT + UI_TT*TT_RT
      UI_MS = UI_MS + UI_DO*DO_MS + UI_TT*TT_MS
C
C---- set final CF sensitivities
      CF_DS = CF_DS + CF_DO*DO_DS + CF_TT*TT_DS
      CF_TH = CF_TH + CF_DO*DO_TH + CF_TT*TT_TH
      CF_UO = CF_UO + CF_DO*DO_UO + CF_TT*TT_UO
      CF_RT = CF_RT + CF_DO*DO_RT + CF_TT*TT_RT
      CF_MS = CF_MS + CF_DO*DO_MS + CF_TT*TT_MS
C
C---- set HS and linearize it
      HS      = TSN/THN
      HS_THN =  -HS/THN
      HS_TSN =  1.0/THN
C
      HS_DO = HS_THN*THN_DO + HS_TSN*TSN_DO
      HS_BB = HS_THN*THN_BB + HS_TSN*TSN_BB
      HS_TT = HS_THN*THN_TT + HS_TSN*TSN_TT
      HS_DS = HS_THN*THN_DS + HS_TSN*TSN_DS
      HS_TH = HS_THN*THN_TH + HS_TSN*TSN_TH
      HS_UO = HS_THN*THN_UO + HS_TSN*TSN_UO
      HS_RT = HS_THN*THN_RT + HS_TSN*TSN_RT
      HS_MS = HS_THN*THN_MS + HS_TSN*TSN_MS
C
      HS_DS = HS_DS + HS_DO*DO_DS + HS_BB*BB_DS + HS_TT*TT_DS
      HS_TH = HS_TH + HS_DO*DO_TH + HS_BB*BB_TH + HS_TT*TT_TH
      HS_UO = HS_UO + HS_DO*DO_UO + HS_BB*BB_UO + HS_TT*TT_UO
      HS_RT = HS_RT + HS_DO*DO_RT + HS_BB*BB_RT + HS_TT*TT_RT
      HS_MS = HS_MS + HS_DO*DO_MS + HS_BB*BB_MS + HS_TT*TT_MS
C
C---- set and linearize Cd
      CD = 0.0
      CD_DS = 0.0
      CD_TH = 0.0
      CD_UO = 0.0
      CD_RT = 0.0
      CD_MS = 0.0
      CD_CT = 0.0
C
C---- add on dependent sensitivity contributions
      CD_DO = 0.0
      CD_BB = 0.0
      CD_TT = 0.0
C
      CD_DS = CD_DS + CD_DO*DO_DS + CD_BB*BB_DS + CD_TT*TT_DS
      CD_TH = CD_TH + CD_DO*DO_TH + CD_BB*BB_TH + CD_TT*TT_TH
      CD_UO = CD_UO + CD_DO*DO_UO + CD_BB*BB_UO + CD_TT*TT_UO
      CD_RT = CD_RT + CD_DO*DO_RT + CD_BB*BB_RT + CD_TT*TT_RT
      CD_MS = CD_MS + CD_DO*DO_MS + CD_BB*BB_MS + CD_TT*TT_MS
C
      RETURN
      END ! PRWALL


      SUBROUTINE PRWAKE(LIN, DSTAR,THETA,UO,UI,DI,CT,
     &                  DO, DO_DS, DO_TH, DO_UO, DO_UI, DO_DI,
     &                  HS, HS_DS, HS_TH, HS_UO, HS_UI, HS_DI,
     &                  CD, CD_DS, CD_TH, CD_UO, CD_UI, CD_DI,
     &                      CD_CT )
      IMPLICIT REAL (A-H,M,O-Z)
C=========================================================
C     Computes profile parameters for two-layer half-wake
C
C     Input:
C        DSTAR  deck displacement thickness
C        THETA  deck momentum thickness
C        UO     outer velocity
C        UI     inner velocity
C        DI     inner shear layer thickness
C        CT     sqrt(max. shear coefficient)
C
C     Output:
C        DO     overall deck thickness
C        HS     K.E. shape parameter
C        CD     dissipation coefficient
C
C     Internal output:
C        UB     velocity at inner/outer blend point
C=========================================================
      LOGICAL LIN
C
C---- Schlichting profile constants
      DATA CON1,    CON2,         CON3,           CON4,        CON5
     &   /0.55, 0.4155844156, 0.1636363636, 0.02922077922, 0.2530175707/
C        11/20      32/77         9/55           9/308       1656/6545
C
      DATA      CON6,        CON7,          CON8,          CON9
     &   / 0.04915966387, 0.1168831169, 0.05500381971, 0.0075630252 /
C             117/2380       9/77           72/1309       9/1190
C
      DATA COND / 0.3461420932 /
C                  4531/13090
C
C
C---- set max allowable shape parameter as a check
      HMAX = (    1.0-UI  - CON1*(UO-UI))
     &     / (UI*(1.0-UI) + CON1*(UO-UI)*(1.0-2.0*UI) - CON2*(UO-UI)**2)
C
ccc      IF(DSTAR/THETA .GT. HMAX) WRITE(*,*) 'PRWAKE: Max H exceeded.'
C
C
C---- set initial guesses for Newton variables  Ub, Do
ccc      DO = DSTAR / (1.0 - CON1*UO - (1.0-CON1)*UI)  !!!%
      UB = UI
C
      DO 100 ITER=1, 10
C
        DUI = UB - UI
        DUO = UO - UB
C
        DRAT = DI/DO
C
        DRAT32 = SQRT(DRAT)**3
        DRAT52 = DRAT32 * DRAT
C
        DRAT3 = DRAT**3
        DRAT4 = DRAT3 * DRAT
C
        FR1    = CON1 - CON3*DRAT52 +     CON4*DRAT4
        FR1_DR =   -2.5*CON3*DRAT32 + 4.0*CON4*DRAT3
C
CCC        write(*,*) 'DUi DUo Do Ub', dui, duo, 100.0*DO, ub
C
        DSN = -(1.0-UI)**2 - (1.0-DRAT)*DUI**2
     &      - CON2*(DRAT*DUI**2 + DUO**2)
     &      + 2.0*(1.0-UI)*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
     &      - 2.0*DUI*DUO*FR1
        DSN_DUO =
     &      - CON2*(          2.0*DUO   )
     &      + 2.0*(1.0-UI)*(                 CON1                 )
     &      - 2.0*DUI    *FR1
        DSN_DUI =          - (1.0-DRAT)*2.0*DUI
     &      - CON2*(DRAT*2.0*DUI        )
     &      + 2.0*(1.0-UI)*(    (1.0-DRAT) + CON1*     DRAT       )
     &      - 2.0*    DUO*FR1
        DSN_UB = DSN_DUI - DSN_DUO
C
        DSN_DR = DUI**2 - CON2*DUI**2 + 2.0*(1.0-UI)*(-DUI + CON1*DUI)
     &         - 2.0*DUI*DUO*FR1_DR
C
        Z1  = DSN*DO + DSTAR - THETA
        A11 = DSN    + DSN_DR*(-DRAT)
        A12 = DSN_UB*DO
C
        Z2  = (1.0-UI - DUI - CON1 *DUO)*DO
     &               + (1.0 - CON1)*DUI *DI - DSTAR
        A21 = (1.0-UI - DUI - CON1*DUO)
        A22 = (       - 1.0 + CON1     )*DO
     &               + (1.0 - CON1)     *DI
C
ccc        write(*,*) iter, z1, z2  !!!%

        RMAX = MAX( ABS(Z1) , ABS(Z2) )
        IF(RMAX/THETA .LT. 1.0E-3) GO TO 110
C
        DET =   A11*A22 - A12*A21
        DDO = -(Z1 *A22 - A12*Z2 ) / DET
        DUB = -(A11*Z2  - Z1 *A21) / DET
C
        RLX = 1.0
        IF(RLX*DDO/DO .GT. 0.5) RLX = 0.5 * DO/DDO
        IF(RLX*DDO/DO .LT.-0.3) RLX = -.3 * DO/DDO
        IF(RLX*DUB/UO .GT. 0.2) RLX = 0.2 * UO/DUB
        IF(RLX*DUB/UO .LT.-0.2) RLX = -.2 * UO/DUB
C
        DO = DO + RLX*DDO
        UB = UB + RLX*DUB
C
  100 CONTINUE
      RMS = SQRT( Z1**2 + Z2**2) / THETA
      WRITE(*,*) 'PRWAKE: Convergence failed.  Res = ', RMS
C
  110 CONTINUE
C
      IF(.NOT.LIN) RETURN
C
CCC     DSN = -(1.0-UI)**2 - (1.0-DRAT)*DUI**2
CCC  &      - CON2*(DRAT*DUI**2 + DUO**2)
CCC  &      + 2.0*(1.0-UI)*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
CCC  &      - 2.0*DUI*DUO*FR1
C
        DSN_UO =  DSN_DUO
        DSN_UI = -DSN_DUI + 2.0*(1.0-UI) 
     &         - 2.0*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
        DSN_UB = DSN_DUI - DSN_DUO
C
CCC     Z1    = DSN   *DO + DSTAR - THETA
        Z1_DS =             1.0
        Z1_TH =                   - 1.0
        Z1_UO = DSN_UO*DO
        Z1_UI = DSN_UI*DO
        Z1_DI = DSN_DR
C
CCC     Z2    = (1.0-UI - DUI - CON1 *DUO)*DO
     &                 + (1.0 - CON1)*DUI *DI - DSTAR
        Z2_DS = -1.0
        Z2_TH = 0.0
        Z2_UO = (             - CON1     )*DO
        Z2_UI =        - (1.0 - CON1)     *DI
        Z2_DI =          (1.0 - CON1)*DUI
C
        DETINV = 1.0 / (A11*A22 - A12*A21)
C
        DO_DS = -(Z1_DS*A22 - A12*Z2_DS) * DETINV
        DO_TH = -(Z1_TH*A22 - A12*Z2_TH) * DETINV
        DO_UO = -(Z1_UO*A22 - A12*Z2_UO) * DETINV
        DO_UI = -(Z1_UI*A22 - A12*Z2_UI) * DETINV
        DO_DI = -(Z1_DI*A22 - A12*Z2_DI) * DETINV
C
        UB_DS = -(A11*Z2_DS - Z1_DS*A21) * DETINV
        UB_TH = -(A11*Z2_TH - Z1_TH*A21) * DETINV
        UB_UO = -(A11*Z2_UO - Z1_UO*A21) * DETINV
        UB_UI = -(A11*Z2_UI - Z1_UI*A21) * DETINV
        UB_DI = -(A11*Z2_DI - Z1_DI*A21) * DETINV
C
C
C------ set various constants needed to define Theta*
        DRAT6 = DRAT3 * DRAT3
        DRAT7 = DRAT3 * DRAT4
C
        DRAT72  = DRAT52 * DRAT
        DRAT92  = DRAT72 * DRAT
        DRAT112 = DRAT92 * DRAT
C
C
        FR1    = CON1 - CON3*DRAT52 +     CON4*DRAT4
        FR1_DR =   -2.5*CON3*DRAT32 + 4.0*CON4*DRAT3
C
        FR2    = CON1 - CON5*DRAT52 +     CON6*DRAT4
        FR2_DR =   -2.5*CON5*DRAT32 + 4.0*CON6*DRAT3
C
        FR3    = CON2 - CON7*DRAT4  +     CON8*DRAT112 -     CON9*DRAT7
        FR3_DR =   -4.0*CON7*DRAT3  + 5.5*CON8*DRAT92  - 7.0*CON9*DRAT6
C
        CU2    =  3.0*DUI*(1.0-DRAT) + 3.0*CON1*(DUI*DRAT + DUO)
        CU2_DUI=  3.0    *(1.0-DRAT) + 3.0*CON1*(    DRAT      )
        CU2_DUO=                       3.0*CON1
        CU2_DR = -3.0*DUI            + 3.0*CON1* DUI
C
        CU1    = 3.0*( DUI**2*(1.0-DRAT) + CON2*(DRAT*DUI**2 + DUO**2)
     &               + 2.0*DUI*DUO*FR1   )
        CU1_DUO= 3.0*(                     CON2*(          2.0*DUO   )
     &               + 2.0*DUI    *FR1   )
        CU1_DUI= 3.0*(2.0*DUI*(1.0-DRAT) + CON2*(DRAT*2.0*DUI        )
     &               + 2.0    *DUO*FR1   )
        CU1_DR = 3.0*(-DUI**2            + CON2* DUI**2
     &               + 2.0*DUI*DUO*FR1_DR)
C
        TSN = (1.0-UI)**3 - CU2    *(1.0-UI)**2 + CU1    *(1.0-UI)
     &      - DUI**3*(1.0-DRAT) - COND*(DRAT*DUI**3 + DUO**3)
     &      - 3.0*DUI**2*DUO*FR2    - 3.0*DUI*DUO**2*FR3
        TSN_DUO =         - CU2_DUO*(1.0-UI)**2 + CU1_DUO*(1.0-UI)
     &                          - COND*(          3.0*DUO**2)
     &      - 3.0*DUI**2    *FR2    - 6.0*DUI*DUO   *FR3
        TSN_DUI =         - CU2_DUI*(1.0-UI)**2 + CU1_DUI*(1.0-UI)
     &  - 3.0*DUI**2*(1.0-DRAT) - COND*(DRAT*3.0*DUI**2     )
     &      - 6.0*DUI   *DUO*FR2    - 3.0    *DUO**2*FR3
        TSN_DR  =         - CU2_DR *(1.0-UI)**2 + CU1_DR *(1.0-UI)
     &      + DUI**3            - COND*(     DUI**3         )
     &      - 3.0*DUI**2*DUO*FR2_DR - 3.0*DUI*DUO**2*FR3_DR
C
        TSN_UO = TSN_DUO
        TSN_UI = -3.0*(1.0-UI)**2 + CU2*2.0*(1.0-UI) - CU1
     &         - TSN_DUI
        TSN_UB = TSN_DUI - TSN_DUO
C
C------ set and linearize Theta*
        TS    = DO*TSN + 3.0*THETA - DSTAR
        TS_DS =                    - 1.0
        TS_TH =          3.0
        TS_UO = DO*TSN_UO
        TS_UI = DO*TSN_UI
        TS_DI = DO*TSN_DI
C
        TS_DO =    TSN_DR*(-DRAT) + TSN
        TS_UB = DO*TSN_UB
C
c        ts = do*(ui-ui**3 + duo*(1.0-3.0*UI**2)*con1
c     &     - 3.0*ui*duo**2*con2 - duo**3*cond)
C
c        ds = (1.0 - ui - con1*duo)*do
c        th = ds - do*((1.0-ui)**2 + con2*duo**2 - (1.0-ui)*2.0*con1*duo)
c        ts = 3.0*th - ds
c     &     + do*( (1.0-ui)**3 - 3.0*(1.0-ui)**2*con1*duo
c     &          + 3.0*(1.0-ui)*con2*duo**2 - cond*duo**3 )
cC
c        write(*,*) 'd,t,s', ds, th, ts

C------ set and linearize H*
        HS    = TS/THETA
        HS_TS = 1.0/THETA
C
        HS_DS = HS_TS*(TS_DS + TS_DO*DO_DS + TS_UB*UB_DS)
        HS_TH = HS_TS*(TS_TH + TS_DO*DO_TH + TS_UB*UB_TH) - HS/THETA
        HS_UO = HS_TS*(TS_UO + TS_DO*DO_UO + TS_UB*UB_UO)
        HS_UI = HS_TS*(TS_UI + TS_DO*DO_UI + TS_UB*UB_UI)
        HS_DI = HS_TS*(TS_DI + TS_DO*DO_DI + TS_UB*UB_DI)
C
C------ set and linearize Cd
        CD = 0.0
        CD_DS = 0.0
        CD_TH = 0.0
        CD_UO = 0.0
        CD_UI = 0.0
        CD_DI = 0.0
        CD_CT = 0.0
C
        CD_DO = 0.0
        CD_UB = 0.0
C
        CD_DS = CD_DS + CD_DO*DO_DS + CD_UB*UB_DS
        CD_TH = CD_TH + CD_DO*DO_TH + CD_UB*UB_TH
        CD_UO = CD_UO + CD_DO*DO_UO + CD_UB*UB_UO
        CD_UI = CD_UI + CD_DO*DO_UI + CD_UB*UB_UI
        CD_DI = CD_DI + CD_DO*DO_DI + CD_UB*UB_DI
C

      RETURN
      END ! PRWAKE



      SUBROUTINE DUWAK1(DSTAR,THETA,UO,  DO,UI)
      IMPLICIT REAL (A-H,M,O-Z)
C=========================================================
C     Computes profile parameters for simple half-wake
C
C     Input:
C        DSTAR  deck displacement thickness
C        THETA  deck momentum thickness
C        UO     outer velocity
C
C     Output:
C        DO     overall deck thickness
C        UI     inner velocity
C=========================================================
C
C---- Schlichting profile constants
      DATA CON1,CON2
     &   /  0.550000000 , 0.4155844156 /
C              11/20          32/77
C
C---- cubic profile constants
ccc   DATA CON1,CON2
ccc  &   / 0.5000000000 , 0.3714285714 /
C               1/2           13/35
C
C
      H    = DSTAR/THETA
C
      A =  H * (CON2 + (1.0 - 2.0*CON1))
      B =  H * UO * 2.0*(CON1 - CON2)  -  (H + 1.0)*(1.0 - CON1)
      C = (H * UO * CON2  -  (H + 1.0)*CON1) * UO  +  1.0
C
      DISC = B*B - 4.0*A*C
      UI = (-B - SQRT(DISC)) / (2.0*A)
C
      DO = DSTAR / (1.0 - UI - CON1*(UO-UI))
C
      RETURN
      END ! DUWAK1



      SUBROUTINE DUWAK2(DSTAR,THETA,UO,UI,DI,  UB,DO)
      IMPLICIT REAL (A-H,M,O-Z)
C=========================================================
C     Computes profile parameters for two-layer half-wake
C
C     Input:
C        DSTAR  deck displacement thickness
C        THETA  deck momentum thickness
C        UO     outer velocity
C        UI     inner velocity
C        DI     inner shear layer thickness
C        CT     sqrt(max. shear coefficient)
C
C     Output:
C        DO     overall deck thickness
C        UB     velocity at inner/outer blend point
C=========================================================
C
C---- Schlichting profile constants
      DATA CON1,    CON2,         CON3,           CON4,        CON5
     &   /0.55, 0.4155844156, 0.1636363636, 0.02922077922, 0.2530175707/
C        11/20      32/77         9/55           9/308       1656/6545
C
      DATA      CON6,        CON7,          CON8,          CON9
     &   / 0.04915966387, 0.1168831169, 0.05500381971, 0.0075630252 /
C             117/2380       9/77           72/1309       9/1190
C
      DATA COND / 0.3461420932 /
C                  4531/13090
C
C
C---- set max allowable shape parameter as a check
      HMAX = (    1.0-UI  - CON1*(UO-UI))
     &     / (UI*(1.0-UI) + CON1*(UO-UI)*(1.0-2.0*UI) - CON2*(UO-UI)**2)
C
      IF(DSTAR/THETA .GT. HMAX) WRITE(*,*) 'DUWAK2: Max H exceeded.'
C
C
C---- set initial guesses for Newton variables  Ub, Do
      DO = DSTAR / (1.0 - CON1*UO - (1.0-CON1)*UI)
      UB = UI
C
      DO 100 ITER=1, 15
C
        DUI = UB - UI
        DUO = UO - UB
        DUI_UB =  1.0
        DUO_UB = -1.0
C
        DRAT = DI/DO
        DR_DO = -DRAT/DO
C
        DRAT32 = SQRT(DRAT)**3
        DRAT52 = DRAT32 * DRAT
C
        DRAT3 = DRAT**3
        DRAT4 = DRAT3 * DRAT
C
        FR1    = CON1 -     CON3*DRAT52 +     CON4*DRAT4
        FR1_DR =      - 2.5*CON3*DRAT32 + 4.0*CON4*DRAT3
C
CCC        write(*,*) 'DUi DUo Do Ub', dui, duo, 100.0*DO, ub
C
        DSN = -(1.0-UI)**2 - (1.0-DRAT)*DUI**2
     &      - CON2*(DRAT*DUI**2 + DUO**2)
     &      + 2.0*(1.0-UI)*(DUI*(1.0-DRAT) + CON1*(DUI*DRAT + DUO))
     &      - 2.0*DUI*DUO*FR1
C
        DSN_DUO =
     &      - CON2*(          2.0*DUO   )
     &      + 2.0*(1.0-UI)*(                 CON1                 )
     &      - 2.0*DUI    *FR1
C
        DSN_DUI =          - (1.0-DRAT)*2.0*DUI
     &      - CON2*(DRAT*2.0*DUI        )
     &      + 2.0*(1.0-UI)*(    (1.0-DRAT) + CON1*     DRAT       )
     &      - 2.0*    DUO*FR1
C
        DSN_DR = DUI**2 - CON2*DUI**2 + 2.0*(1.0-UI)*(-DUI + CON1*DUI)
     &         - 2.0*DUI*DUO*FR1_DR
C
        DSN_DO = DSN_DR*DR_DO
        DSN_UB = DSN_DUI*DUI_UB + DSN_DUO*DUO_UB
C
C
        Z1  = DO*DSN    + DSTAR - THETA
        A11 =    DSN
     &      + DO*DSN_DO
        A12 = DO*DSN_UB
C
C
        Z2  = (1.0-UI  - DUI    - CON1 *DUO   )*DO
     &      + (1.0-CON1)*DUI   *DI - DSTAR
C
        A21 = (1.0-UI  - DUI    - CON1 *DUO   )
C
        A22 = (        - DUI_UB - CON1 *DUO_UB)*DO
     &      + (1.0-CON1)*DUI_UB*DI
C
        RMAX = MAX( ABS(Z1) , ABS(Z2) )
        IF(RMAX/THETA .LT. 1.0E-5) GO TO 110
C
        DET =   A11*A22 - A12*A21
        DDO = -(Z1 *A22 - A12*Z2 ) / DET
        DUB = -(A11*Z2  - Z1 *A21) / DET
C
        RLX = 1.0
        IF(RLX*DDO/DO .GT. 0.5) RLX = 0.5 * DO/DDO
        IF(RLX*DDO/DO .LT.-0.3) RLX = -.3 * DO/DDO
        IF(RLX*DUB/UO .GT. 0.2) RLX = 0.2 * UO/DUB
        IF(RLX*DUB/UO .LT.-0.2) RLX = -.2 * UO/DUB
C
        DO = DO + RLX*DDO
        UB = UB + RLX*DUB
C
ccc        write(*,*) iter, z1, z2, rlx
ccc        write(*,*) do/dstar, ub/uo, z1, z2, rlx
C
  100 CONTINUE
      RMS = SQRT( Z1**2 + Z2**2) / THETA
      WRITE(*,*) 'DUWAK2: Convergence failed.  Res = ', RMS
C
  110 CONTINUE
C
      RETURN
      END ! DUWAK2





      SUBROUTINE CFT( HK, RT, MSQ, CF, CF_HK, CF_RT, CF_MSQ )
      IMPLICIT REAL (A-H,M,O-Z)
C
C---- Turbulent skin friction function  ( Cf )    (Swafford)
      FC = SQRT(1.0 + 0.2*MSQ)
      GRT = LOG(RT/FC)
      GRT = MAX(GRT,3.0)
C
      GEX = -1.74 - 0.31*HK
C
      ARG1 = -1.33*HK
      ARG1 = MAX(-20.0, ARG1 )
C
      ARG2 = 4.0 - HK/0.875
      ARG2 = MIN( 10.0, ARG2 )
      ARG2 = MAX(-10.0, ARG2 )
      CFO =  0.3*EXP(ARG1) * (GRT/2.3026)**GEX
      CF     = ( CFO  +  1.1D-4*(TANH(ARG2)-1.0) ) / FC
      CF_HK  = (-1.33*CFO - 0.31*LOG(GRT/2.3026)*CFO
     &         - 1.1D-4/COSH(ARG2)**2 / 0.875    ) / FC
      CF_RT  = GEX*CFO/(FC*GRT) / RT
      CF_MSQ = GEX*CFO/(FC*GRT) * (-0.1/FC**2)  -  0.1*CF/FC**2
C
      RETURN
      END ! CFT

