
      SUBROUTINE READBL(FNAME,IBX,NBX,XB,YB,
     &                  IIB,NBL,
     &                  NAME,XINL,XOUT,YBOT,YTOP)
      CHARACTER*(*) FNAME
      DIMENSION XB(IBX,NBX) ,YB(IBX,NBX)
      DIMENSION IIB(NBX)
      CHARACTER*(*) NAME
C----------------------------------------------
C     Reads in blade.xxx dataset
C----------------------------------------------
C
      CHARACTER*128 LINE
      LOGICAL ERROR
C
      DIMENSION AINPUT(20)
C
      CHARACTER*19 NCHARS
      DATA NCHARS / '0123456789-+.,EDed ' /
C
C---- default top/bottom flow area ratio for "old" blade.xxx files
      DATA YRAT / 1.3 /
C
C---- first assume that there will be a read error
      NBL = 0
C
      NF = INDEX(FNAME,' ') + 1
C
      LU = 3
C
      OPEN(LU,FILE=FNAME,STATUS='OLD',ERR=98)
C
      READ(LU,1000) LINE
C
C---- if first line has any non-numeric character, go treat it as the name
      DO K=1, 80
        IF(INDEX(NCHARS,LINE(K:K)) .EQ. 0) GO TO 20
      ENDDO
C
C---- plain unlabeled file: rewind, and just read in X,Y coordinates
      NAME = ' '
      NINPUT = 0
C
      REWIND(LU)
      WRITE(*,*)
      WRITE(*,*) 'Reading plain coordinate file'
      GO TO 40
C
C---- first line interpreted as label string
   20 READ(LINE,1000) NAME
C
C---- read and decode second line --- grid domain limits will be set later
      READ(LU,1000) LINE
      CALL GETFLT(LINE,AINPUT,NINPUT,ERROR)
C
      IF(ERROR) GO TO 99
C
      IF(NINPUT.LT.4) THEN
C------ no domain parameters: re-read name string and then read X,Y coordinates
        REWIND(LU)
        READ(LU,1000) LINE
      ENDIF
C
      WRITE(*,1010) NAME
 1010 FORMAT(/1X,'Reading in coordinate file for: ',A/)
C
 40   CONTINUE
C
C---- read in airfoil coordinates
      DO 55 N=1, NBX+1
        DO 50 IB=1, IBX+1
          READ(LU,*,END=56,ERR=99) XBT, YBT
          IF(XBT.EQ.999.0) THEN
           IIB(N) = IB-1
           GO TO 55
          ENDIF
          IF(N.GT.NBX) THEN
           WRITE(*,*) 'READBL: Too many airfoil elements. Increase NBX.'
           STOP
          ENDIF
          XB(IB,N) = XBT
          YB(IB,N) = YBT
   50   CONTINUE
        WRITE(*,*) 'READBL: Too many airfoil points.  Increase IBX.'
        STOP
   55 CONTINUE
      N = NBX
C
   56 IF(IB.EQ.1) THEN
C----- coordinate file has "999.0 999.0" at the end ...
       NBL = N-1
      ELSE
C----- coordinate file has no ending line (single element ISES file)
       NBL = N
       IIB(N) = IB-1
      ENDIF
C
      CLOSE(LU)
C
C
      DO 80 N = 1, NBL
C
C------ calculate airfoil element area
        IB = 1
        RX = XB(IB,N) + XB(IIB(N),N)
        RY = YB(IB,N) + YB(IIB(N),N)
        DX = XB(IB,N) - XB(IIB(N),N)
        DY = YB(IB,N) - YB(IIB(N),N)
        DA = 0.25*(RX*DY - RY*DX)
        AREA = DA
        DO 802 IB=2, IIB(N)
          RX = XB(IB,N) + XB(IB-1,N)
          RY = YB(IB,N) + YB(IB-1,N)
          DX = XB(IB,N) - XB(IB-1,N)
          DY = YB(IB,N) - YB(IB-1,N)
          DA = 0.25*(RX*DY - RY*DX)
          AREA = AREA + DA
 802    CONTINUE
C
        IF(AREA.LT.0.0) THEN
C------- if area is negative (clockwise order), reverse coordinate order
         DO 804 IB=1, IIB(N)/2
           IBACK = IIB(N) - IB + 1
           XTMP = XB(IB,N)
           YTMP = YB(IB,N)
           XB(IB,N) = XB(IBACK,N)
           YB(IB,N) = YB(IBACK,N)
           XB(IBACK,N) = XTMP
           YB(IBACK,N) = YTMP
 804     CONTINUE
        ENDIF
C
 80   CONTINUE
C
      IF     (NINPUT.LT.4) THEN
C------ plain or labeled airfoil file -- no domain parameters specified
        XINL = 0.
        XOUT = 0.
        YBOT = 0.
        YTOP = 0.
      ELSEIF (NINPUT.EQ.4) THEN
C------ for "new" blade.xxx file, grid size is input directly
        XINL = AINPUT(1)
        XOUT = AINPUT(2)
        YBOT = AINPUT(3)
        YTOP = AINPUT(4)
      ELSE
C------ "old" blade.xxx file, grid size is implied from airfoil limits
        CHINL = AINPUT(3)
        CHOUT = AINPUT(4)
        CHWID = AINPUT(5)
C
        XMIN = XB(1,1) + 1.0
        XMAX = XB(1,1) - 1.0
        DO 84 N=1, NBL
          DO 842 IB=1, IIB(N)
            IF(XB(IB,N).LE.XMIN) THEN
             XMIN = XB(IB,N)
             YMIN = YB(IB,N)
            ENDIF
            IF(XB(IB,N).GE.XMAX) THEN
             XMAX = XB(IB,N)
             YMAX = YB(IB,N)
            ENDIF
 842      CONTINUE
 84     CONTINUE
C
        XINL = XMIN - CHINL
        XOUT = XMAX + CHOUT
        YBOT = YMIN - CHWID *  1.0/(1.0 + YRAT)
        YTOP = YMAX + CHWID * YRAT/(1.0 + YRAT)
      ENDIF
C
C
      RETURN
C
   98 CONTINUE
      WRITE(*,1050) FNAME(1:NF)
      NBL = 0
      RETURN
C
   99 CONTINUE
      WRITE(*,1100) FNAME(1:NF)
      RETURN
C...............................................................
 1000 FORMAT(A)
 1050 FORMAT(/' File OPEN error:  ', A)
 1100 FORMAT(/' File READ error:  ', A)
      END ! READBL
