
      SUBROUTINE SNWRIT(IP)
      INCLUDE 'STATE.INC'
      INCLUDE 'MSES.INC'
      INCLUDE 'SENS.INC'
      DIMENSION ILE(NBX), ITE(NBX)
      DIMENSION SBLEP(NBX)
      CHARACTER*80 ARGP1, FNAME
      CHARACTER*32 CODE
C
      CHARACTER*2 PNUM(99)
      CHARACTER*10 DIGITS
      DATA DIGITS / '0123456789' /
C
C---- fill array for constructing filename suffix
      DO 2 KP=1, 99
        K2 =          KP/10   + 1
        K1 = KP - 10*(KP/10)  + 1
        PNUM(KP) = DIGITS(K2:K2) // DIGITS(K1:K1)
 2    CONTINUE
C
C
      CDV = DRAGV / QU
      CDW = DRAGW / QU
      CDF = DRAGF / QU
C
      CL  = LIFT  / QU
      CM  = MOMN  / QU
C
C---- current freestream Reynolds number
      REINF = REYN * RHOINF*QINF/MUINF
C
C---- indices indicating if Minf(mass), REinf(mass,REo) are active global 
C-    variables -- i.e. dCL/dMinf, dCL/dREinf...  were calculated in GLOSEN
      LMINF = LMASS
      LRINF = LREYN
C
C---- REinf(mass,REo) is active only if both mass flow 
C-    and stagnation Reynolds number are active
      IF(LMASS.EQ.0 .OR. LREYN.EQ.0) LRINF = 0
C
C
      DO 5 N=1, NBL
        ILE(N) = NINL(N)
        ITE(N) = NINL(N)+NBLD(N)-1
        SBLEP(N) = SBLEGN(N) - SBLE(N)
 5    CONTINUE
C
C
C---- get run output argument xxx
      CALL GETARG(1,ARGP1)
C
      IF(IP.EQ.0) THEN
       FNAME = 'sensx.' // ARGP1
      ELSE
       IBLANK = INDEX(ARGP1,' ')
       FNAME = 'sensx.' // ARGP1(1:IBLANK-1) // '_' // PNUM(IP)
      ENDIF
      OPEN(8,FILE=FNAME,FORM='UNFORMATTED',STATUS='UNKNOWN')
C
      CODE = 'MSES'
C
      WRITE(8) CODE
      WRITE(8) NAME
      WRITE(8) LALFA, LMINF, LRINF
      WRITE(8) LDEPMA, LDEPRE
      WRITE(8) ALFA, MINF, REINF
      WRITE(8) DNRMS,DRRMS,DVRMS,DNMAX,DRMAX,DVMAX
      WRITE(8) II, NBL, NMODN, NPOSN
      WRITE(8) (ILE(N),ITE(N), N=1, NBL)
      WRITE(8) (XBNOSE(N),YBNOSE(N),XBTAIL(N),YBTAIL(N),SBLEP(N),
     &          N=1, NBL)
c
c     &          THIKB(N),AREAB(N)
c
c      DO 15 NN=1, NMODN
c        K = KMODN(NN)
c        WRITE(8) (THB_MOD(K,N),ARB_MOD(K,N), N=1, NBL)
c 15   CONTINUE
C
      WRITE(8) 
     &           CL     , CM     , CDW     , CDV     , CDF     ,
     &  AL_ALFA, CL_ALFA, CM_ALFA, CDW_ALFA, CDV_ALFA, CDF_ALFA,
     &  AL_MINF, CL_MINF, CM_MINF, CDW_MINF, CDV_MINF, CDF_MINF,
     &  AL_RINF, CL_RINF, CM_RINF, CDW_RINF, CDV_RINF, CDF_RINF
C
      DO 105 IS=1, 2*NBL
        N = (IS+1)/2
        WRITE(8) (XBI(I,IS),YBI(I,IS),
     &     CP(I,IS)     ,HK(I,IS)     , ! MD(I,IS)     ,ST(I,IS)     ,
     &     CP_ALFA(I,IS),HK_ALFA(I,IS), ! MD_ALFA(I,IS),ST_ALFA(I,IS),
     &     CP_MINF(I,IS),HK_MINF(I,IS), ! MD_MINF(I,IS),ST_MINF(I,IS),
     &     CP_RINF(I,IS),HK_RINF(I,IS), ! MD_RINF(I,IS),ST_RINF(I,IS),
     &     I=ILE(N), II-1)
 105  CONTINUE
C
      DO 20 NN=1, NMODN
        K = KMODN(NN)
        WRITE(8) MODN(K),
     &            AL_MOD(K),  CL_MOD(K),  CM_MOD(K), 
     &           CDW_MOD(K), CDV_MOD(K), CDF_MOD(K)
        DO 205 IS=1, 2*NBL
          N = (IS+1)/2
          WRITE(8) (GN(K,I-ILE(N)+1,IS),I=ILE(N),ITE(N))
          WRITE(8) (XBI_MOD(I,IS,K),YBI_MOD(I,IS,K),
     &               CP_MOD(I,IS,K), HK_MOD(I,IS,K),
     &              I=ILE(N), II-1)
c
c     &               MD_MOD(I,IS,K), ST_MOD(I,IS,K),
c
 205    CONTINUE
 20   CONTINUE
C
      DO 30 NN=1, NPOSN
        K = KPOSN(NN)
        WRITE(8) NPOSEL(K)
        WRITE(8) (NBPOS(IL,K), IL=1, NPOSEL(K))
        WRITE(8) (XBPOS(IL,K),YBPOS(IL,K),ABPOS(IL,K),IL=1,NPOSEL(K))
        WRITE(8) POSN(K),
     &            AL_POS(K),  CL_POS(K),  CM_POS(K), 
     &           CDW_POS(K), CDV_POS(K), CDF_POS(K)
        DO 305 IS=1, 2*NBL
          N = (IS+1)/2
          WRITE(8) (XBI_POS(I,IS,K),YBI_POS(I,IS,K),
     &               CP_POS(I,IS,K), HK_POS(I,IS,K),
     &              I=ILE(N), II-1)
c
c     &               MD_POS(I,IS,K), ST_POS(I,IS,K),
c
 305    CONTINUE
 30   CONTINUE
C
      RETURN
      END ! SNWRIT

